/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.formplugin.agency;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.sm.business.helper.BillImportHelper;
import kd.scmc.sm.business.helper.SalesAgencyHelper;

public class SalesAgencyImportPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(SalesAgencyImportPlugin.class);
    private static final String BILLCRETYPE = "1";
    private Map<String, Object> tempCache = new HashMap<String, Object>();

    public void beforeImportData(BeforeImportDataEventArgs e) {
        try (TraceSpan span = Tracer.create((String)"BillTplImportPlugin", (String)"beforeImportData");){
            String url = RequestContext.get().getClientUrl();
            if (url != null && url.contains("appendentryrows")) {
                return;
            }
            String billcretype = this.getPageCache().get("billcretype");
            if (!BillImportHelper.isImport((String)billcretype)) {
                return;
            }
            DynamicObject org = BillImportHelper.getBaseDataFromCache((Map)e.getSourceData(), (String)"org", (String)"bos_org", (String)"id,fissale", null, this.tempCache);
            if (org == null) {
                return;
            }
            QFilter customerOrgFilter = (QFilter)this.tempCache.get(org.getPkValue() + "_customerOrgFilter");
            if (customerOrgFilter == null) {
                customerOrgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_customer", (Long)((Long)org.getPkValue()));
                this.tempCache.put(org.getPkValue() + "_customerOrgFilter", customerOrgFilter);
            }
            long t1 = System.currentTimeMillis();
            Map customerMap = BillImportHelper.format4ImportAndApi(e.getSourceData().get("customer"));
            if (customerMap != null) {
                DynamicObject customer = BillImportHelper.getBaseDataFromCache((Map)e.getSourceData(), (String)"customer", (String)"bd_customer", (String)"id,consignment", (QFilter[])new QFilter[]{new QFilter((String)customerMap.get("importprop"), "=", customerMap.get(customerMap.get("importprop"))), customerOrgFilter}, this.tempCache);
                if (customer == null) {
                    e.setCancel(true);
                    e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u8ba2\u8d27\u5ba2\u6237\u201c%1$s\u201d\u672a\u5206\u914d\u7ed9\u9500\u552e\u7ec4\u7ec7\u201c%2$s\u201d\u3002", (String)"SalesAgencyImportPlugin_2", (String)"scmc-sm-formplugin", (Object[])new Object[0]), customerMap.get(customerMap.get("importprop")), org.get("number")));
                    e.setFireAfterImportData(false);
                    return;
                }
                Boolean consignment = customer.getBoolean("consignment");
                if (!consignment.booleanValue()) {
                    e.setCancel(true);
                    e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u8ba2\u8d27\u5ba2\u6237\u201c%s\u201d\u4e0d\u662f\u53ef\u5bc4\u552e\u5ba2\u6237\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"SalesAgencyImportPlugin_1", (String)"scmc-sm-formplugin", (Object[])new Object[0]), customerMap.get(customerMap.get("importprop"))));
                    e.setFireAfterImportData(false);
                    return;
                }
            }
            long t2 = System.currentTimeMillis();
            log.info("initImportData times\uff1a" + (t2 - t1));
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        String billCreType = this.getPageCache().get("billcretype");
        DynamicObject bill = this.getModel().getDataEntity(true);
        if (BillImportHelper.isImport((String)billCreType) || BillImportHelper.isApi((String)billCreType)) {
            SalesAgencyHelper.completeBillInfo(Collections.singletonList(bill));
        }
    }
}

