/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.formplugin.agency;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.mscommon.writeoff.form.manual.IWfManualExtService;
import kd.scmc.sm.business.helper.BillTplHelper;
import kd.scmc.sm.business.helper.OrgHelper;
import kd.scmc.sm.business.helper.PropertyChangeHelper;
import kd.scmc.sm.util.CommonUtils;
import kd.scmc.sm.util.DateUtils;

public class SalesAgencyMatchPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
IWfManualExtService {
    private static final Log log = LogFactory.getLog(SalesAgencyMatchPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit orgControl = (BasedataEdit)this.getControl("orgsearch");
        orgControl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long orgId = RequestContext.get().getOrgId();
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org");
        List salOrgList = OrgHelper.getHasPermissionOrg((String)"sm_salagencymatch", (String)OrgHelper.getFisSaleViewType());
        if (salOrgList != null && salOrgList.size() > 0 && org.getBoolean("fissale") && salOrgList.contains(orgId)) {
            this.getModel().setValue("orgsearch", (Object)org);
        }
        this.getModel().setValue("startdatesearch", (Object)DateUtils.getStartOfDay((Date)DateUtils.getStartDayOfCurMonth()));
        this.getModel().setValue("enddatesearch", (Object)DateUtils.getEndOfDay((Date)DateUtils.getEndDayOfCurMonth()));
    }

    public void addBillFilter(String curEntryKey, String entityNumber, List<QFilter> billFilters, Map<String, Object> pageDataMap) {
        IDataModel model = (IDataModel)pageDataMap.get("model");
        DynamicObject org = (DynamicObject)model.getValue("orgsearch");
        Date startDate = (Date)model.getValue("startdatesearch");
        Date endDate = (Date)model.getValue("enddatesearch");
        if ("sm_salesagency".equalsIgnoreCase(entityNumber)) {
            QFilter qFilter;
            if (org != null) {
                qFilter = new QFilter("org", "=", org.getPkValue());
                billFilters.add(qFilter);
            }
            if (startDate != null) {
                qFilter = new QFilter("bizdate", ">=", (Object)startDate);
                billFilters.add(qFilter);
            }
            if (endDate != null) {
                qFilter = new QFilter("bizdate", "<=", (Object)endDate);
                billFilters.add(qFilter);
            }
        } else if ("im_saloutbill".equalsIgnoreCase(entityNumber)) {
            QFilter qFilter;
            if (org != null) {
                qFilter = new QFilter("bizorg", "=", org.getPkValue());
                billFilters.add(qFilter);
            }
            if (startDate != null) {
                qFilter = new QFilter("biztime", ">=", (Object)startDate);
                billFilters.add(qFilter);
            }
            if (endDate != null) {
                qFilter = new QFilter("biztime", "<=", (Object)endDate);
                billFilters.add(qFilter);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String proName = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        switch (proName) {
            case "orgsearch": {
                List salOrgList = OrgHelper.getHasPermissionOrg((String)"sm_salagencymatch", (String)OrgHelper.getFisSaleViewType());
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)salOrgList));
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object wfScheme = this.getModel().getValue("wfscheme");
        Object org = this.getModel().getValue("orgsearch");
        Object startDate = this.getModel().getValue("startdatesearch");
        Object endDate = this.getModel().getValue("enddatesearch");
        if (wfScheme != null && org != null && startDate != null && endDate != null) {
            this.getView().invokeOperation("query");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (PropertyChangeHelper.isStopPropertyChange((IPageCache)this.getPageCache())) {
            return;
        }
        String name = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        switch (name) {
            case "writeofftype": {
                this.getModel().deleteEntryData("entry_a");
                this.getModel().deleteEntryData("entry_b");
                break;
            }
            case "entrustunverifyqty_cur_a": {
                for (int i = 0; i < changeSet.length; ++i) {
                    if (!CommonUtils.isRealChanged((ChangeData)changeSet[i])) continue;
                    int rowIndex = changeSet[i].getRowIndex();
                    this.calBaseCurQty(changeSet[i], rowIndex, name, "entrustunverifybaseqty_cur_a", "unit_a", "baseunit_a", "material_a", "entrustunverifybaseqty_a");
                }
                break;
            }
            case "entrustunverifyqty_cur_b": {
                for (int i = 0; i < changeSet.length; ++i) {
                    if (!CommonUtils.isRealChanged((ChangeData)changeSet[i])) continue;
                    int rowIndex = changeSet[i].getRowIndex();
                    this.calBaseCurQty(changeSet[i], rowIndex, name, "entrustunverifybaseqty_cur_b", "unit_b", "baseunit_b", "material_B", "entrustunverifybaseqty_b");
                }
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String key = operate.getOperateKey();
        if (!(!"wfmanual".equals(key) || this.checkSelectedEntry("entry_a") && this.checkSelectedEntry("entry_b"))) {
            args.setCancel(true);
        }
    }

    private void calBaseCurQty(ChangeData changeData, int rowIndex, String qtyCurField, String baseQtyCurField, String unitField, String baseUnitField, String materialField, String baseQtyUnField) {
        DynamicObject unitA;
        BigDecimal baseQty = BigDecimal.ZERO;
        BigDecimal qtyCurA = (BigDecimal)changeData.getNewValue();
        BigDecimal baseQtyA = (BigDecimal)this.getModel().getValue(baseQtyCurField, rowIndex);
        if (qtyCurA != null && baseQtyA != null && (unitA = (DynamicObject)this.getModel().getValue(unitField, rowIndex)) != null) {
            DynamicObject materialA;
            int precision = unitA.getInt("precision");
            int precisionaccount = BillTplHelper.getRoundMode((DynamicObject)unitA);
            qtyCurA = qtyCurA.setScale(precision, precisionaccount);
            DynamicObject baseUnitA = (DynamicObject)this.getModel().getValue(baseUnitField, rowIndex);
            if (baseUnitA != null && (materialA = (DynamicObject)this.getModel().getValue(materialField, rowIndex)) != null) {
                DynamicObject masterMaterial = materialA.getDynamicObject("masterid");
                if (qtyCurA.compareTo(BigDecimal.ZERO) != 0) {
                    baseQty = BillTplHelper.getDesQtyConv((DynamicObject)masterMaterial, (DynamicObject)unitA, (BigDecimal)qtyCurA, (DynamicObject)baseUnitA);
                }
            }
        }
        BigDecimal baseQtyUnA = (BigDecimal)this.getModel().getValue(baseQtyUnField, rowIndex);
        if (baseQty.compareTo(BigDecimal.ZERO) == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u6b21\u7ed3\u7b97\u57fa\u672c\u6570\u91cf\u6362\u7b97\u5931\u8d25\u3002", (String)"SalesAgencyMatchPlugin_0", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
            this.revertEntryValue(changeData, rowIndex, qtyCurField);
        } else if (baseQty.compareTo(baseQtyUnA) > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u6b21\u7ed3\u7b97\u57fa\u672c\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7\u672a\u7ed3\u7b97\u57fa\u672c\u6570\u91cf\u3002", (String)"SalesAgencyMatchPlugin_1", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
            this.revertEntryValue(changeData, rowIndex, qtyCurField);
        } else {
            this.getModel().setValue(baseQtyCurField, (Object)baseQty, rowIndex);
        }
    }

    private void revertEntryValue(ChangeData changeData, int rowIndex, String propName) {
        PropertyChangeHelper.stopPropertyChange((IPageCache)this.getPageCache());
        this.getModel().setValue(propName, changeData.getOldValue(), rowIndex);
        PropertyChangeHelper.releasePropertyChange((IPageCache)this.getPageCache());
    }

    private boolean checkSelectedEntry(String entry) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(entry);
        int[] rows = entryGrid.getSelectRows();
        if (rows.length <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u59d4\u6258\u4ee3\u9500\u6e05\u5355\u548c\u9500\u552e\u51fa\u5e93\u5355\u9700\u8981\u6267\u884c\u7ed3\u7b97\u7684\u6570\u636e\u3002", (String)"SalesAgencyMatchPlugin_2", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public String wfManualConfirmMessage() {
        return ResManager.loadKDString((String)"\u5b58\u5728\u5339\u914d\u53cc\u65b9\u672c\u6b21\u7ed3\u7b97\u57fa\u672c\u6570\u91cf\u4e0d\u4e00\u81f4\u7684\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SalesAgencyMatchPlugin_3", (String)"scmc-sm-formplugin", (Object[])new Object[0]);
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Object fieldValue = e.getValue();
        String key = ((Control)e.getSource()).getKey();
        if ("entrustunverifyqty_cur_a".equalsIgnoreCase(key) || "entrustunverifyqty_cur_b".equalsIgnoreCase(key)) {
            if (fieldValue != null) {
                BigDecimal value = new BigDecimal(String.valueOf(fieldValue));
                if (BigDecimal.ZERO.compareTo(value) == 0) {
                    e.setCancel(true);
                    int rowCount = 0;
                    rowCount = "entrustunverifyqty_cur_a".equalsIgnoreCase(key) ? this.getModel().getEntryRowCount("entry_a") : this.getModel().getEntryRowCount("entry_b");
                    if (rowCount > e.getRowIndex()) {
                        this.getView().updateView(key, e.getRowIndex());
                    }
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672c\u6b21\u7ed3\u7b97\u6570\u91cf\u5e94\u5927\u4e8e0\u3002", (String)"SalesAgencyMatchPlugin_4", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    return;
                }
            } else {
                e.setCancel(true);
                int rowCount = 0;
                rowCount = "entrustunverifyqty_cur_a".equalsIgnoreCase(key) ? this.getModel().getEntryRowCount("entry_a") : this.getModel().getEntryRowCount("entry_b");
                if (rowCount > e.getRowIndex()) {
                    this.getView().updateView(key, e.getRowIndex());
                }
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672c\u6b21\u7ed3\u7b97\u6570\u91cf\u5e94\u5927\u4e8e0\u3002", (String)"SalesAgencyMatchPlugin_4", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                return;
            }
        }
    }

    public String wfQueryCheckMessage(String name, String number) {
        return ResManager.loadKDString((String)"\u9700\u8981\u7ef4\u62a4\u9500\u552e\u7ec4\u7ec7\u548c\u65e5\u671f\u8303\u56f4\u8fc7\u6ee4\u6761\u4ef6\u3002", (String)"SalesAgencyMatchPlugin_5", (String)"scmc-sm-formplugin", (Object[])new Object[0]);
    }
}

