/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.formplugin.agency;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.sm.business.helper.BillImportHelper;
import kd.scmc.sm.business.helper.BillTplHelper;
import kd.scmc.sm.business.helper.LotCacheHelper;
import kd.scmc.sm.business.helper.PropertyChangeHelper;
import kd.scmc.sm.business.helper.SystemCallParamHelper;
import kd.scmc.sm.enums.StatusEnum;
import kd.scmc.sm.util.CommonUtils;

public class SalesAgencyPlugin
extends AbstractBillPlugIn
implements EntryGridBindDataListener,
BeforeF7SelectListener {
    public static final String CACHE_ENABLE_LOT = "enable_lot";
    public static final String TAXRATE_FILTER = "taxrate_filter";
    private static String[] propKeys = new String[]{"totalallamount", "totaltaxamount", "totalamount", "curtotalallamount", "curtotaltaxamount", "curtotalamount"};

    public void registerListener(EventObject e) {
        BasedataEdit material;
        BasedataEdit taxrateid;
        BasedataEdit reccustomer;
        BasedataEdit customer;
        BasedataEdit stockorg;
        super.registerListener(e);
        EntryGrid entry = (EntryGrid)this.getControl("billentry");
        if (entry != null) {
            entry.addDataBindListener((EntryGridBindDataListener)this);
        }
        if ((stockorg = (BasedataEdit)this.getView().getControl("e_stockorg")) != null) {
            stockorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((customer = (BasedataEdit)this.getView().getControl("customer")) != null) {
            customer.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((reccustomer = (BasedataEdit)this.getView().getControl("reccustomer")) != null) {
            reccustomer.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((taxrateid = (BasedataEdit)this.getView().getControl("taxrateid")) != null) {
            taxrateid.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((material = (BasedataEdit)this.getView().getControl("material")) != null) {
            material.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        String billCreType = this.getPageCache().get("billcretype");
        if (!BillImportHelper.isManual((String)billCreType)) {
            return;
        }
        this.setDefaultBookDate();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billentry");
        if (entryGrid != null) {
            entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        try (TraceSpan span = Tracer.create((String)"SalesAgencyPlugin", (String)"afterBindData");){
            if (SystemCallParamHelper.isBookDateEqBizDate()) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"bookdate"});
            }
            if (StatusEnum.SAVE.getValue().equals(this.getModel().getValue("billstatus"))) {
                BillTplHelper.calculateAmount4WholeBill((DynamicObject)this.getModel().getDataEntity(true), (IDataModel)this.getModel());
                this.doRefreshHeadAmount();
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey;
        super.afterDoOperation(e);
        switch (operateKey = e.getOperateKey()) {
            case "unsubmit": 
            case "unaudit": {
                BillTplHelper.calculateAmount4WholeBill((DynamicObject)this.getModel().getDataEntity(true), (IDataModel)this.getModel());
                this.doRefreshHeadAmount();
                break;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        try (TraceSpan span = Tracer.create((String)"SalesAgencyPlugin", (String)("beforeF7Select: " + e.getProperty().getName()));){
            switch (fieldKey) {
                case "e_stockorg": {
                    DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                    if (org != null) return;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalesOrderPlugin_3", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                case "customer": {
                    QFilter bizfunction = new QFilter("bizfunction", "like", (Object)"%1%");
                    QFilter consignment = new QFilter("consignment", "=", (Object)Boolean.TRUE);
                    showParameter.getListFilterParameter().getQFilters().add(bizfunction.and(consignment));
                    return;
                }
                case "material": {
                    QFilter q = new QFilter("masterid.enableconsign", "=", (Object)Boolean.TRUE);
                    q.and(new QFilter("masterid.serviceattribute.fbasedataid_id", "=", (Object)1194029484878120960L));
                    showParameter.getListFilterParameter().getQFilters().add(q);
                    return;
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String billcretype = this.getPageCache().get("billcretype");
        if (!BillImportHelper.isManual((String)billcretype)) {
            return;
        }
        if (PropertyChangeHelper.isStopPropertyChange((IPageCache)this.getPageCache())) {
            return;
        }
        ChangeData[] valueSet = e.getChangeSet();
        if (!CommonUtils.isRealChanged((ChangeData)valueSet[0])) {
            return;
        }
        try (TraceSpan span = Tracer.create((String)"SalesAgencyPlugin", (String)("propertyChanged: " + e.getProperty().getName()));){
            Object newValue = valueSet[0].getNewValue();
            String propName = e.getProperty().getName();
            int rowIndex = valueSet[0].getRowIndex();
            switch (propName) {
                case "qty": 
                case "auxqty": {
                    this.setLotEnable(rowIndex);
                    this.setUnEntrustQty(rowIndex);
                    return;
                }
                case "e_stockorg": {
                    this.setLotEnable(rowIndex);
                    return;
                }
                case "unit": {
                    this.setUnEntrustQty(rowIndex);
                    return;
                }
                case "material": {
                    this.changeMaterial(newValue, rowIndex);
                    return;
                }
                case "bizdate": {
                    this.getModel().setValue("bookdate", newValue);
                    return;
                }
            }
            return;
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        try (TraceSpan span = Tracer.create((String)"SalesAgencyPlugin", (String)"afterCopyData");){
            this.setDefaultBookDate();
            BillModel model = (BillModel)e.getSource();
            DynamicObjectCollection entry = model.getEntryEntity("billentry");
            if (entry == null || entry.isEmpty()) {
                return;
            }
            for (DynamicObject row : entry) {
                row.set("entrustunverifyqty", (Object)row.getBigDecimal("qty"));
                row.set("entrustunverifybaseqty", (Object)row.getBigDecimal("baseqty"));
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        RowDataEntity[] rowDataEntities = e.getRowDataEntities();
        switch (entryName) {
            case "billentry": {
                for (RowDataEntity rowDataEntity : rowDataEntities) {
                    int rowIndex = rowDataEntity.getRowIndex();
                    this.setUnEntrustQty(rowIndex);
                }
                break;
            }
        }
    }

    private void changeMaterial(Object newValue, int rowIndex) {
        if (newValue != null && this.getModel().getValue("taxrateid", rowIndex) != null) {
            String[] taxrateIds;
            DynamicObject taxrate = (DynamicObject)this.getModel().getValue("taxrateid", rowIndex);
            String taxrateFilter = this.getPageCache().get(TAXRATE_FILTER);
            if (taxrateFilter != null && (taxrateIds = (taxrateFilter = taxrateFilter.substring(1, taxrateFilter.length() - 1)).split("_")) != null && taxrate != null && taxrateIds.length > 0 && !Arrays.asList(taxrateIds).contains(taxrate.getPkValue().toString())) {
                this.getModel().beginInit();
                this.getModel().setValue("taxrateid", null, rowIndex);
                this.getModel().setValue("taxrate", null, rowIndex);
                this.getModel().endInit();
                this.getView().updateView("taxrateid", rowIndex);
                this.getView().updateView("taxrate", rowIndex);
            }
        }
    }

    private void setUnEntrustQty(int rowIndex) {
        this.getModel().setValue("entrustunverifyqty", this.getModel().getValue("qty", rowIndex), rowIndex);
        this.getModel().setValue("entrustunverifybaseqty", this.getModel().getValue("baseqty", rowIndex), rowIndex);
    }

    private void setLotEnable(int rowIndex) {
        ArrayList<RowDataEntity> rows = new ArrayList<RowDataEntity>();
        RowDataEntity rowDataEntity = new RowDataEntity(rowIndex, this.getModel().getEntryRowEntity("billentry", rowIndex));
        rows.add(rowDataEntity);
        LotCacheHelper.setLotEnable(rows, (IFormView)this.getView(), (IPageCache)this.getPageCache());
    }

    private void doRefreshHeadAmount() {
        this.getView().updateView("totalallamount");
        this.getView().updateView("totaltaxamount");
        this.getView().updateView("totalamount");
        this.getView().updateView("curtotalallamount");
        this.getView().updateView("curtotaltaxamount");
        this.getView().updateView("curtotalamount");
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DataEntityState dataEntityState = dataEntity.getDataEntityState();
        DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
        for (String propKey : propKeys) {
            IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)propKey);
            if (property == null) continue;
            dataEntityState.setBizChanged(property.getOrdinal(), false);
        }
    }

    private void setDefaultBookDate() {
        IDataModel model = this.getModel();
        if (model.getValue("bookdate") == null) {
            model.setValue("bookdate", model.getValue("bizdate"));
        }
    }
}

