/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.formplugin.analyse;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.sm.business.helper.CurrencyHelper;
import kd.scmc.sm.business.helper.SalesOrgHelper;
import kd.scmc.sm.formplugin.analyse.AbstractAnalysePlugin;

public class SalseAnalysePlugin
extends AbstractAnalysePlugin
implements BeforeF7SelectListener {
    private static final String BTN_CHANGE = "change";
    private static final String KEY_ORG = "org";
    private static final String ENTITY_ANALYSE = "sm_analyse";
    private String currency;
    private long orgId;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getControl(KEY_ORG);
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{BTN_CHANGE});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Button btn = (Button)evt.getSource();
        switch (key = btn.getKey()) {
            case "change": {
                BasedataEdit org = (BasedataEdit)this.getControl(KEY_ORG);
                org.click();
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List pks = SalesOrgHelper.getHasPermissionSalesOrgId((String)ENTITY_ANALYSE);
        if (pks == null || pks.size() < 1) {
            return;
        }
        this.getPageCache().put("HasPermissionOrg", SerializationUtils.toJsonString((Object)pks));
        this.orgId = RequestContext.get().getOrgId();
        this.orgId = pks.contains(this.orgId + "") ? this.orgId : Long.parseLong(pks.get(0).toString());
        this.getModel().setValue(KEY_ORG, (Object)this.orgId);
        this.refresh();
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldKey = evt.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        switch (fieldKey) {
            case "org": {
                String pkSet = this.getPageCache().get("HasPermissionOrg");
                List jsonList = (List)SerializationUtils.fromJsonString((String)pkSet, List.class);
                ArrayList<Long> ids = new ArrayList<Long>(jsonList.size());
                for (String id : jsonList) {
                    ids.add(Long.valueOf(id));
                }
                if (ids.size() <= 0) break;
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", ids));
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "org": {
                Object org = e.getChangeSet()[0].getNewValue();
                if (ObjectUtils.isEmpty((Object)org) || !(org instanceof DynamicObject)) break;
                this.orgId = ((DynamicObject)org).getLong("id");
                this.refresh();
                break;
            }
        }
    }

    private void refresh() {
        this.setCurrency();
        this.showFormView("sm_dayview", "flaxtoday", null, null);
        this.showFormView("sm_analyseview", "flaxbar", null, null);
        this.showFormView("sm_analysepiechart", "flexpie", null, null);
        String selector = "id,customer as cid,customer.name as cname,curtotalallamount as amount";
        this.showFormView("sm_topview", "flexsupplier", this.getDataMap(selector), ResManager.loadKDString((String)"\u5ba2\u6237\u4ef7\u503c\u6392\u540d", (String)"SalseAnalysePlugin_0", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
        selector = "id,billentry.material.masterid as cid,billentry.material.masterid.name as cname,billentry.amountandtax as amount";
        this.showFormView("sm_topview", "flexproduce", this.getDataMap(selector), ResManager.loadKDString((String)"\u70ed\u9500\u4ea7\u54c1\u6392\u540d", (String)"SalseAnalysePlugin_1", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
        selector = "id,operator.operatorid as cid,operator.operatorid.name as cname,curtotalallamount as amount";
        this.showFormView("sm_topview", "flexamount", this.getDataMap(selector), ResManager.loadKDString((String)"\u9500\u552e\u989d\u6392\u540d", (String)"SalseAnalysePlugin_2", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
    }

    private void setCurrency() {
        DynamicObject currency = CurrencyHelper.getCurrency((Long)this.orgId);
        if (currency != null) {
            this.currency = currency.getString("name");
        }
    }

    private void showFormView(String formId, String targetKey, Map<String, Object> param, String caption) {
        FormShowParameter formParam = new FormShowParameter();
        if (caption != null) {
            formParam.setCaption(caption);
        }
        formParam.setFormId(formId);
        formParam.getOpenStyle().setShowType(ShowType.InContainer);
        formParam.getOpenStyle().setTargetKey(targetKey);
        if (param != null) {
            formParam.setCustomParams(param);
        }
        if (this.orgId != 0L) {
            formParam.setCustomParam("orgId", (Object)this.orgId);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.currency)) {
            formParam.setCustomParam("curName", (Object)this.currency);
        }
        this.getView().showForm(formParam);
    }

    private Map<String, Object> getDataMap(String selector) {
        DynamicObjectCollection doc = this.getSalseData(selector);
        HashMap<Long, BigDecimal> amountMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, String> mappingMap = new HashMap<Long, String>();
        this.buildInitData(doc, amountMap, mappingMap);
        List<Map<Long, BigDecimal>> arraysAmout = this.arraysSort(amountMap);
        Map<String, Object> param = this.buildReturnData(arraysAmout, mappingMap);
        return param;
    }

    private void buildInitData(DynamicObjectCollection doc, Map<Long, BigDecimal> amountMap, Map<Long, String> mappingMap) {
        for (DynamicObject dd : doc) {
            Long cid = dd.getLong("cid");
            if (cid == 0L) continue;
            BigDecimal value = amountMap.get(cid);
            if (value == null) {
                value = dd.getBigDecimal("amount");
                amountMap.put(cid, value);
                mappingMap.put(cid, dd.getString("cname"));
                continue;
            }
            amountMap.put(cid, value.add(dd.getBigDecimal("amount")));
        }
    }

    private List<Map<Long, BigDecimal>> arraysSort(Map<Long, BigDecimal> amountMap) {
        ArrayList<Map<Long, BigDecimal>> arraysAmout = new ArrayList<Map<Long, BigDecimal>>(amountMap.size());
        Iterator<Map.Entry<Long, BigDecimal>> iterator = amountMap.entrySet().iterator();
        while (iterator.hasNext()) {
            HashMap<Long, BigDecimal> map1 = new HashMap<Long, BigDecimal>();
            Map.Entry<Long, BigDecimal> entry = iterator.next();
            map1.put(entry.getKey(), entry.getValue());
            arraysAmout.add(map1);
        }
        if (arraysAmout.size() > 1) {
            arraysAmout.sort((m1, m2) -> ((BigDecimal)m2.get(m2.keySet().iterator().next())).compareTo((BigDecimal)m1.get(m1.keySet().iterator().next())));
        }
        return arraysAmout;
    }

    private Map<String, Object> buildReturnData(List<Map<Long, BigDecimal>> arraysAmout, Map<Long, String> mappingMap) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        ArrayList<String> nameArrays = new ArrayList<String>();
        ArrayList<String> amountArrays = new ArrayList<String>();
        BigDecimal toDivide = new BigDecimal(10000);
        int index = 0;
        for (Map<Long, BigDecimal> map : arraysAmout) {
            for (Map.Entry<Long, BigDecimal> entry : map.entrySet()) {
                BigDecimal value = entry.getValue().divide(toDivide, 1, RoundingMode.HALF_UP);
                if (value.compareTo(BigDecimal.ZERO) == 0) continue;
                nameArrays.add(mappingMap.get(entry.getKey()));
                amountArrays.add(value.toString());
            }
            if (++index != 5) continue;
            break;
        }
        param.put("name", nameArrays);
        param.put("amount", amountArrays);
        return param;
    }

    private DynamicObjectCollection getSalseData(String selector) {
        QFilter filter1 = new QFilter(KEY_ORG, "=", (Object)this.orgId);
        QFilter filter2 = new QFilter("billstatus", "=", (Object)"C");
        QFilter filter3 = new QFilter("bizdate", ">=", (Object)this.parseDate(this.getThisYer(), "yyyy"));
        QFilter[] filters = new QFilter[]{filter1, filter2, filter3};
        return QueryServiceHelper.query((String)"sm_salorder", (String)selector, (QFilter[])filters);
    }
}

