/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.formplugin.analyse;

import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.BindingContext;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.control.Label;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.sm.consts.HomePageConst;
import kd.scmc.sm.formplugin.analyse.AbstractAnalysePlugin;
import org.apache.commons.lang.time.DateFormatUtils;

public class SellAnalyseBarChartPlugin
extends AbstractAnalysePlugin {
    private String leftName = ResManager.loadKDString((String)"\u5143", (String)"SellAnalyseBarChartPlugin_0", (String)"scmc-sm-formplugin", (Object[])new Object[0]);
    private BigDecimal maxLastAmount = new BigDecimal(0);
    private BigDecimal maxThistAmount = new BigDecimal(0);
    private BigDecimal toDivide = new BigDecimal(1000);
    private long maxAxis;
    private BigDecimal[] lastAmount = new BigDecimal[12];
    private BigDecimal[] thisAmount = new BigDecimal[12];
    private BigDecimal[] averageAmount = new BigDecimal[12];
    private String thousand = ResManager.loadKDString((String)"\u5343", (String)"SellAnalyseBarChartPlugin_1", (String)"scmc-sm-formplugin", (Object[])new Object[0]);
    private String milion = ResManager.loadKDString((String)"\u767e\u4e07", (String)"SellAnalyseBarChartPlugin_2", (String)"scmc-sm-formplugin", (Object[])new Object[0]);

    public SellAnalyseBarChartPlugin() {
        this.initNumbers(this.lastAmount);
        this.initNumbers(this.thisAmount);
        this.initNumbers(this.averageAmount);
    }

    public void afterCreateNewData(EventObject e) {
        Chart customchart = (Chart)this.getControl("analysechartap");
        String curName = (String)this.getView().getFormShowParameter().getCustomParam("curName");
        if (StringUtils.isNotEmpty((CharSequence)curName)) {
            Label cur = (Label)this.getControl("currency");
            cur.setText(curName);
        }
        this.setCustomchart(customchart);
    }

    private void initNumbers(BigDecimal[] numbers) {
        for (int i = 0; i < numbers.length; ++i) {
            numbers[i] = BigDecimal.ZERO;
        }
    }

    private void setCustomchart(Chart customchart) {
        customchart.clearData();
        this.setHandlechartXaxisTick(customchart);
        this.setHandleChartData(customchart);
        customchart.setMargin(Position.right, "30px");
        customchart.setMargin(Position.top, "30px");
        customchart.setLegendPropValue("itemWidth", (Object)10);
        customchart.setLegendPropValue("itemHeight", (Object)10);
    }

    private Axis setHandlechartXaxisTick(Chart customchart) {
        Axis xaxis = customchart.createXAxis("", AxisType.category);
        ArrayList<String> xDimensions = new ArrayList<String>();
        xDimensions.add(ResManager.loadKDString((String)"1\u6708", (String)"SellAnalyseBarChartPlugin_3", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
        xDimensions.add(ResManager.loadKDString((String)"2\u6708", (String)"SellAnalyseBarChartPlugin_4", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
        xDimensions.add(ResManager.loadKDString((String)"3\u6708", (String)"SellAnalyseBarChartPlugin_5", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
        xDimensions.add(ResManager.loadKDString((String)"4\u6708", (String)"SellAnalyseBarChartPlugin_6", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
        xDimensions.add(ResManager.loadKDString((String)"5\u6708", (String)"SellAnalyseBarChartPlugin_7", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
        xDimensions.add(ResManager.loadKDString((String)"6\u6708", (String)"SellAnalyseBarChartPlugin_8", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
        xDimensions.add(ResManager.loadKDString((String)"7\u6708", (String)"SellAnalyseBarChartPlugin_9", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
        xDimensions.add(ResManager.loadKDString((String)"8\u6708", (String)"SellAnalyseBarChartPlugin_10", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
        xDimensions.add(ResManager.loadKDString((String)"9\u6708", (String)"SellAnalyseBarChartPlugin_11", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
        xDimensions.add(ResManager.loadKDString((String)"10\u6708", (String)"SellAnalyseBarChartPlugin_12", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
        xDimensions.add(ResManager.loadKDString((String)"11\u6708", (String)"SellAnalyseBarChartPlugin_13", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
        xDimensions.add(ResManager.loadKDString((String)"12\u6708", (String)"SellAnalyseBarChartPlugin_14", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
        xaxis.setCategorys(xDimensions);
        xaxis.setPosition(Position.bottom);
        xaxis.setPropValue("nameGap", (Object)"3");
        HashMap<String, int[]> map = new HashMap<String, int[]>();
        int[] aa = new int[]{0, 0, -25, -35};
        map.put("padding", aa);
        xaxis.setPropValue("nameTextStyle", map);
        HashMap<String, Constable> axisTick = new HashMap<String, Constable>();
        axisTick.put("interval", Integer.valueOf(0));
        axisTick.put("show", Boolean.FALSE);
        xaxis.setPropValue("axisTick", axisTick);
        this.setLineColor(xaxis, "#FFFFFF");
        return xaxis;
    }

    private void setHandleChartData(Chart customchart) {
        HashMap<String, String> map = new HashMap<String, String>();
        customchart.setShowLegend(true);
        customchart.setLegendAlign(XAlign.center, YAlign.top);
        map = new HashMap();
        map.put("color", "#FFFFFF");
        customchart.setLegendPropValue("textStyle", map);
        customchart.bindData((BindingContext)null);
        this.buildChartData();
        this.dealCurrency();
        this.maxLastAmount = this.getMaxNum(this.lastAmount);
        this.maxThistAmount = this.getMaxNum(this.thisAmount);
        this.maxAxis = this.getMaxSize(this.maxLastAmount, this.maxThistAmount);
        this.buildLineData();
        this.createAxis(customchart, this.leftName, this.maxAxis);
        this.setBarSeries(customchart, this.getLastYer(), "#1890FF", this.lastAmount);
        this.setBarSeries(customchart, this.getThisYer(), "#34BC7F", this.thisAmount);
        this.setLineSeries(customchart, ResManager.loadKDString((String)"\u5f53\u5e74\u9500\u552e\u8d8b\u52bf", (String)"SellAnalyseBarChartPlugin_15", (String)"scmc-sm-formplugin", (Object[])new Object[0]), "#39bdb9", this.averageAmount);
    }

    private void dealCurrency() {
        long value = this.maxThistAmount.setScale(0, 0).longValue();
        int length = String.valueOf(value).length();
        this.leftName = length > 7 ? this.milion : this.thousand;
        this.toDivide = length > 7 ? new BigDecimal(1000000) : new BigDecimal(1000);
        this.leftName = "(" + this.leftName + ")";
        this.amountFormat(this.lastAmount);
        this.amountFormat(this.thisAmount);
    }

    private void buildLineData() {
        BigDecimal mbd = BigDecimal.valueOf(1.1);
        BigDecimal abd = BigDecimal.valueOf((double)this.maxAxis * 0.05);
        for (int i = 0; i < this.averageAmount.length; ++i) {
            this.averageAmount[i] = this.thisAmount[i].multiply(mbd).add(abd);
        }
    }

    private void setLineSeries(Chart customchart, String name, String color, Number[] number) {
        LineSeries lineSeries = customchart.createLineSeries(name);
        lineSeries.setItemColor(color);
        lineSeries.setData(number);
    }

    private void createAxis(Chart customchart, String name, long max) {
        Axis axis = customchart.createYAxis(name, AxisType.value);
        axis.setPropValue("nameGap", (Object)"5");
        axis.setMax((Number)max);
        axis.setInterval((Number)(max / 5L));
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>();
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", axisTick);
        HashMap splitLine = new HashMap();
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put("color", "#D8D8D8");
        splitLine.put("lineStyle", lineStyle);
        axis.setPropValue("splitLine", splitLine);
        this.setLineColor(axis, "#FFFFFF");
    }

    private void setBarSeries(Chart customchart, String year, String color, Number[] number) {
        String yearString = ResManager.loadKDString((String)"\u5e74", (String)"SellAnalyseBarChartPlugin_16", (String)"scmc-sm-formplugin", (Object[])new Object[0]);
        BarSeries yearSeries = customchart.createBarSeries(year + yearString);
        yearSeries.setAnimationDuration(2000);
        yearSeries.setBarWidth("25%");
        yearSeries.setData(number);
        yearSeries.setItemColor(color);
        ArrayList<String> list = new ArrayList<String>();
        list.add("itemStyle");
        list.add("normal");
        list.add("color");
        yearSeries.addFuncPath(list);
    }

    private long getMaxSize(BigDecimal amount1, BigDecimal amount2) {
        BigDecimal max = amount1.compareTo(amount2) > 0 ? amount1 : amount2;
        BigDecimal mbd = BigDecimal.valueOf(1.1);
        BigDecimal abd = max.multiply(BigDecimal.valueOf(0.05));
        max = max.multiply(mbd).add(abd);
        long maxNum = max.setScale(0, 0).longValue();
        for (int num : HomePageConst.getMAXSIZE()) {
            if ((long)num <= maxNum) continue;
            maxNum = num;
            break;
        }
        return maxNum;
    }

    private void buildChartData() {
        QFilter filter3;
        QFilter filter2;
        QFilter filter1 = new QFilter("org", "=", this.getView().getFormShowParameter().getCustomParam("orgId"));
        QFilter[] filters = new QFilter[]{filter1, filter2 = new QFilter("billstatus", "=", (Object)"C"), filter3 = new QFilter("bizdate", ">=", (Object)this.parseDate(this.getLastYer() + "-01", "yyyy-MM"))};
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"sm_salorder", (String)"id,billno,bizdate,currency.name as cname,curtotalallamount as amount", (QFilter[])filters);
        if (doc != null && doc.size() > 0) {
            this.leftName = ((DynamicObject)doc.get(0)).getString("cname");
            this.buildChartDate(doc);
        }
    }

    private void amountFormat(BigDecimal[] amount) {
        for (int i = 0; i < amount.length; ++i) {
            amount[i] = amount[i].divide(this.toDivide, 0, RoundingMode.HALF_UP);
        }
    }

    private BigDecimal getMaxNum(BigDecimal[] arrays) {
        BigDecimal value = new BigDecimal(0);
        for (BigDecimal num : arrays) {
            if (value.compareTo(num) >= 0) continue;
            value = num;
        }
        return value;
    }

    private void buildChartDate(DynamicObjectCollection doc) {
        for (DynamicObject entity : doc) {
            Date date = entity.getDate("bizdate");
            String dateValue = DateFormatUtils.format((Date)date, (String)"yyyy-MM");
            String lastYear = this.getLastYer();
            String key = dateValue.substring(dateValue.indexOf(45) + 1);
            int value = Integer.parseInt(key);
            if (dateValue.indexOf(lastYear) > -1) {
                this.lastAmount[value - 1] = this.lastAmount[value - 1].add(entity.getBigDecimal("amount"));
                continue;
            }
            this.thisAmount[value - 1] = this.thisAmount[value - 1].add(entity.getBigDecimal("amount"));
        }
    }

    private void setLineColor(Axis axix, String color) {
        HashMap axisLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", color);
        axisLineMap.put("lineStyle", lineStyleMap);
        axix.setPropValue("axisLine", axisLineMap);
    }
}

