/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.formplugin.analyse;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.sm.formplugin.analyse.AbstractAnalysePlugin;

public class SellAnalysePieChartPlugin
extends AbstractAnalysePlugin {
    private Map<String, String> groupNameMap = new HashMap<String, String>();
    private Map<String, BigDecimal> groupAmountMap = new HashMap<String, BigDecimal>();
    private static String[] pieColors = new String[]{"#1890FF", "#4DD7C0", "#96D552", "#ff7f00", "#FFCE3F", "#FFFFFF"};

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        PieChart pieChart = (PieChart)this.getControl("piechartap");
        this.setPieChartLegend(pieChart);
        this.setPieChartSeries(pieChart);
    }

    private void setPieChartSeries(PieChart pieChart) {
        PieSeries series = pieChart.createPieSeries(ResManager.loadKDString((String)"\u9500\u552e\u603b\u989d", (String)"SellAnalysePieChartPlugin_0", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
        Label label = new Label();
        label.setShow(true);
        label.setFontSize("14");
        label.setFormatter("{b}\uff1a{d}%");
        series.setLabel(label);
        List<Map<String, BigDecimal>> arraysAmout = this.buildDatas();
        ItemValue[] items = this.getProfitData(arraysAmout);
        series.setData(items);
    }

    private void setPieChartLegend(PieChart pieChart) {
        pieChart.setShowTooltip(true);
        pieChart.setShowLegend(true);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("color", "#FFFFFF");
        map.put("fontSize", 14);
        pieChart.setLegendPropValue("textStyle", map);
        pieChart.setLegendVertical(true);
        pieChart.setLegendPropValue("orient", (Object)"horizontal");
        pieChart.setLegendPropValue("icon", (Object)"circle");
        pieChart.setLegendPropValue("itemGap", (Object)20);
        pieChart.setLegendAlign(XAlign.center, YAlign.bottom);
    }

    private ItemValue[] getProfitData(List<Map<String, BigDecimal>> arraysAmout) {
        ItemValue[] items = arraysAmout.size() > 5 ? new ItemValue[6] : new ItemValue[arraysAmout.size()];
        BigDecimal others = new BigDecimal(0);
        for (int i = 0; i < items.length; ++i) {
            Map<String, BigDecimal> map = arraysAmout.get(i);
            String groupKey = map.keySet().iterator().next();
            if (i < 5) {
                items[i] = new ItemValue(this.groupNameMap.get(groupKey), (Number)this.groupAmountMap.get(groupKey), pieColors[i]);
                continue;
            }
            others = others.add(this.groupAmountMap.get(groupKey));
        }
        if (items.length > 5) {
            items[5] = new ItemValue(ResManager.loadKDString((String)"\u5176\u4ed6", (String)"SellAnalysePieChartPlugin_1", (String)"scmc-sm-formplugin", (Object[])new Object[0]), (Number)others, pieColors[5]);
        }
        return items;
    }

    private List<Map<String, BigDecimal>> buildDatas() {
        QFilter filter1 = new QFilter("org", "=", this.getView().getFormShowParameter().getCustomParam("orgId"));
        QFilter filter2 = new QFilter("billstatus", "=", (Object)"C");
        QFilter filter3 = new QFilter("bizdate", ">=", (Object)this.parseDate(this.getThisYer() + "-01", "yyyy-MM"));
        QFilter[] filters = new QFilter[]{filter1, filter2, filter3};
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"sm_salorder", (String)"id,billno,bizdate,currency.name as cname,curtotalallamount as amount,customer.group as group,customer.group.name as ctname", (QFilter[])filters);
        HashMap map = new HashMap();
        this.groupNameMap.clear();
        for (DynamicObject entity : doc) {
            String key = entity.getString("group");
            if (StringUtils.isEmpty((CharSequence)key) || "0".equals(key)) continue;
            List<Object> arrays = (List)map.get(key);
            if (arrays == null) {
                arrays = new ArrayList<DynamicObject>();
                arrays.add(entity);
                map.put(key, arrays);
                this.groupNameMap.put(key, entity.getString("ctname"));
                continue;
            }
            arrays.add(entity);
        }
        this.groupAmountMap.clear();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            BigDecimal bd = new BigDecimal(0);
            Map.Entry entry = iterator.next();
            for (DynamicObject dd : (List)entry.getValue()) {
                bd = bd.add(dd.getBigDecimal("amount"));
            }
            this.groupAmountMap.put((String)entry.getKey(), bd);
        }
        ArrayList<Map<String, BigDecimal>> arraysAmout = new ArrayList<Map<String, BigDecimal>>(this.groupAmountMap.size());
        for (Map.Entry<String, BigDecimal> entry1 : this.groupAmountMap.entrySet()) {
            HashMap<String, BigDecimal> map1 = new HashMap<String, BigDecimal>();
            map1.put(entry1.getKey(), this.groupAmountMap.get(entry1.getKey()));
            arraysAmout.add(map1);
        }
        if (arraysAmout.size() > 1) {
            arraysAmout.sort((m1, m2) -> ((BigDecimal)m2.get(m2.keySet().iterator().next())).compareTo((BigDecimal)m1.get(m1.keySet().iterator().next())));
        }
        return arraysAmout;
    }
}

