/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.formplugin.botp;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterGetSourceDataEventArgs;
import kd.mpscmm.msbd.common.enums.PriceModelEnum;
import kd.scmc.sm.business.helper.KitSalesHelper;
import kd.scmc.sm.business.pojo.KitStructureParentInfo;
import kd.scmc.sm.business.pojo.KitStructureResultInfo;
import kd.scmc.sm.enums.DiscountTypeEnum;
import kd.scmc.sm.enums.ProductTypeEnum;

public class SalOrder2FiKitParentConvertPlugin
extends AbstractConvertPlugIn {
    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        super.afterBuildQueryParemeter(e);
        e.addSrcField("producttype");
        e.addSrcField("pricemodel");
        e.addSrcField("price");
        e.addSrcField("priceandtax");
        e.addSrcField("amount");
        e.addSrcField("curamount");
        e.addSrcField("amountandtax");
        e.addSrcField("discountamount");
        e.addSrcField("discountrate");
        e.addSrcField("discounttype");
        e.addSrcField("taxamount");
    }

    public void afterGetSourceData(AfterGetSourceDataEventArgs e) {
        if (!KitSalesHelper.isKitSale()) {
            return;
        }
        e.getSourceRows();
        List sourceRows = e.getSourceRows();
        Map fldProperties = e.getFldProperties();
        for (DynamicObject sourceRow : sourceRows) {
            KitStructureParentInfo parentInfo;
            KitStructureResultInfo resultInfo;
            String productType = sourceRow.getString((IDataEntityProperty)fldProperties.get("producttype"));
            String priceModel = sourceRow.getString((IDataEntityProperty)fldProperties.get("pricemodel"));
            Long billId = sourceRow.getLong((IDataEntityProperty)fldProperties.get("id"));
            Long billEntryId = sourceRow.getLong((IDataEntityProperty)fldProperties.get("billentry.id"));
            if (!ProductTypeEnum.KITPARENT.getValue().equals(productType) || !PriceModelEnum.CHILD.getValue().equals(priceModel) || (resultInfo = KitSalesHelper.expandKitStructure((String)"sm_salorder", (Long)billId, (Long)billEntryId, (BigDecimal)BigDecimal.ZERO)) == null || !"SUCCESS".equals(resultInfo.getStatus()) || (parentInfo = resultInfo.getParent()) == null) continue;
            sourceRow.set((IDataEntityProperty)fldProperties.get("price"), (Object)parentInfo.getPrice());
            sourceRow.set((IDataEntityProperty)fldProperties.get("priceandtax"), (Object)parentInfo.getPriceAndTax());
            sourceRow.set((IDataEntityProperty)fldProperties.get("amount"), (Object)parentInfo.getAmount());
            sourceRow.set((IDataEntityProperty)fldProperties.get("curamount"), (Object)parentInfo.getCurAmount());
            sourceRow.set((IDataEntityProperty)fldProperties.get("amountandtax"), (Object)parentInfo.getAmountAndTax());
            sourceRow.set((IDataEntityProperty)fldProperties.get("taxamount"), (Object)parentInfo.getTaxAmount());
            if (parentInfo.getDiscountAmount() == null || parentInfo.getDiscountAmount().compareTo(BigDecimal.ZERO) == 0) continue;
            sourceRow.set((IDataEntityProperty)fldProperties.get("discountamount"), (Object)parentInfo.getDiscountAmount());
            sourceRow.set((IDataEntityProperty)fldProperties.get("discountrate"), (Object)parentInfo.getDiscountRate());
            sourceRow.set((IDataEntityProperty)fldProperties.get("discounttype"), (Object)DiscountTypeEnum.UNITDIS.getValue());
        }
    }
}

