/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.formplugin.botp;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.mpscmm.msbd.business.helper.botp.PurOrderDefValueHelper;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.scmc.sm.business.helper.BillTplHelper;

public class SalOrder2PurOrderConvertPlugin
extends AbstractConvertPlugIn {
    private static final Log log = LogFactory.getLog(SalOrder2PurOrderConvertPlugin.class);

    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entitys = entitySet.FindByEntityKey(this.getTgtMainType().toString());
        if (entitys == null || entitys.length < 1) {
            return;
        }
        ArrayList<DynamicObject> bills = new ArrayList<DynamicObject>(8);
        for (ExtendedDataEntity entity : entitys) {
            DynamicObject bill = entity.getDataEntity();
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            boolean supplytrans = bill.getBoolean("supplytrans");
            for (DynamicObject entry : entrys) {
                DynamicObject material = entry.getDynamicObject("material");
                if (material == null) {
                    log.info("\u7269\u6599\u4e3a\u7a7a");
                    continue;
                }
                DynamicObject master = material.getDynamicObject("masterid");
                if (master == null) {
                    log.info("\u4e3b\u7269\u6599\u4e3a\u7a7a");
                    continue;
                }
                DynamicObject supplier = bill.getDynamicObject("supplier");
                BigDecimal taxRate = entry.getBigDecimal("taxrate");
                DynamicObject taxRateId = entry.getDynamicObject("taxrateid");
                if (taxRateId == null || taxRate == null || BigDecimal.ZERO.compareTo(taxRate) == 0) {
                    DynamicObject taxRateDynamicObject = null;
                    if (master != null && master.getDynamicObject("taxrate") != null) {
                        taxRateDynamicObject = master.getDynamicObject("taxrate");
                    }
                    if (taxRateDynamicObject == null && supplier != null) {
                        taxRateDynamicObject = supplier.getDynamicObject("taxrate");
                    }
                    if (taxRateDynamicObject != null) {
                        Long taxRateID = (Long)taxRateDynamicObject.getPkValue();
                        taxRateDynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_taxrate", (String)"id, taxrate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)taxRateID)});
                    }
                    if (taxRateDynamicObject != null) {
                        entry.set("taxrateid", (Object)taxRateDynamicObject);
                        entry.set("taxrate", (Object)taxRateDynamicObject.getBigDecimal("taxrate"));
                    }
                }
                if (!supplytrans) continue;
                DynamicObject unit = entry.getDynamicObject("unit");
                BigDecimal qty = entry.getBigDecimal("qty");
                DynamicObject baseUnit = entry.getDynamicObject("baseunit");
                BigDecimal baseQty = entry.getBigDecimal("baseqty");
                if (BigDecimalUtil.isNotBlank((BigDecimal)qty) && BigDecimalUtil.isNotBlank((BigDecimal)baseQty)) continue;
                if (BigDecimalUtil.isBlank((BigDecimal)qty) && BigDecimalUtil.isBlank((BigDecimal)baseQty)) {
                    log.info("\u6570\u91cf\u90fd\u6ca1\u503c");
                    continue;
                }
                if (baseUnit == null) {
                    baseUnit = master.getDynamicObject("baseunit");
                    entry.set("baseunit", (Object)baseUnit);
                }
                if (unit == null) {
                    unit = material.getDynamicObject("purchaseunit");
                    entry.set("unit", (Object)unit);
                }
                if (unit == null || baseUnit == null) {
                    log.info("\u5355\u4f4d\u6ca1\u503c");
                    continue;
                }
                if (BigDecimalUtil.isBlank((BigDecimal)qty) && BigDecimalUtil.isNotBlank((BigDecimal)baseQty)) {
                    qty = SalOrder2PurOrderConvertPlugin.getDesQtyConv((Long)master.getPkValue(), baseUnit, baseQty, unit);
                    entry.set("qty", (Object)qty);
                } else if (BigDecimalUtil.isBlank((BigDecimal)baseQty) && BigDecimalUtil.isNotBlank((BigDecimal)qty)) {
                    baseQty = SalOrder2PurOrderConvertPlugin.getDesQtyConv((Long)master.getPkValue(), unit, qty, baseUnit);
                    entry.set("baseqty", (Object)baseQty);
                }
                boolean isControlQty = entry.getBoolean("iscontrolqty");
                BigDecimal receiveQtyUp = qty;
                BigDecimal receiveQtyDown = qty;
                BigDecimal receiveBaseQtyUp = baseQty;
                BigDecimal receiveBaseQtyDown = baseQty;
                if (isControlQty) {
                    BigDecimal receiveRateUp = entry.getBigDecimal("receiverateup");
                    BigDecimal receiveRateDown = entry.getBigDecimal("receiveratedown");
                    if (receiveRateUp != null && receiveRateDown != null) {
                        receiveQtyUp = qty.multiply(BigDecimalUtil.ONE.add(BigDecimalUtil.div100((BigDecimal)receiveRateUp, (int)10))).setScale(SalOrder2PurOrderConvertPlugin.getPrecision(unit), BillTplHelper.getRoundMode((DynamicObject)unit));
                        receiveQtyDown = qty.multiply(BigDecimalUtil.ONE.subtract(BigDecimalUtil.div100((BigDecimal)receiveRateDown, (int)10))).setScale(SalOrder2PurOrderConvertPlugin.getPrecision(unit), BillTplHelper.getRoundMode((DynamicObject)unit));
                        receiveBaseQtyUp = baseQty.multiply(BigDecimalUtil.ONE.add(BigDecimalUtil.div100((BigDecimal)receiveRateUp, (int)10))).setScale(SalOrder2PurOrderConvertPlugin.getPrecision(baseUnit), BillTplHelper.getRoundMode((DynamicObject)baseUnit));
                        receiveBaseQtyDown = baseQty.multiply(BigDecimalUtil.ONE.subtract(BigDecimalUtil.div100((BigDecimal)receiveRateDown, (int)10))).setScale(SalOrder2PurOrderConvertPlugin.getPrecision(baseUnit), BillTplHelper.getRoundMode((DynamicObject)baseUnit));
                    }
                }
                entry.set("receiveqtyup", (Object)receiveQtyUp);
                entry.set("receiveqtydown", (Object)receiveQtyDown);
                entry.set("receivebaseqtyup", (Object)receiveBaseQtyUp);
                entry.set("receivebaseqtydown", (Object)receiveBaseQtyDown);
            }
            bills.add(bill);
        }
        PurOrderDefValueHelper.batchSetPurOrderDefValue(bills);
    }

    private static BigDecimal getDesQtyConv(Long materialId, DynamicObject srcUnit, BigDecimal srcQty, DynamicObject desUnit) {
        BigDecimal desQty = BigDecimalUtil.ZERO;
        if (materialId == null || srcUnit == null || desUnit == null || srcQty == null) {
            return BigDecimalUtil.ZERO;
        }
        if (srcUnit.getPkValue().equals(desUnit.getPkValue())) {
            desQty = srcQty;
        } else {
            DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)((Long)srcUnit.getPkValue()), (Long)((Long)desUnit.getPkValue()));
            if (muConv != null) {
                int numerator = muConv.getInt("numerator");
                int denominator = muConv.getInt("denominator");
                if (denominator != 0) {
                    int unitPrecision = desUnit.getInt("precision");
                    desQty = srcQty.multiply(new BigDecimal(numerator)).divide(new BigDecimal(denominator), unitPrecision, BillTplHelper.getRoundMode((DynamicObject)desUnit));
                }
            }
        }
        return desQty;
    }

    private static int getPrecision(DynamicObject unit) {
        int precision = 10;
        if (unit != null) {
            precision = unit.getInt("precision");
        }
        return precision;
    }
}

