/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.formplugin.botp;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class SalOrder2RecBillConvertPlugin
extends AbstractConvertPlugIn {
    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        BillEntityType tgtMainType = this.getTgtMainType();
        ExtendedDataEntitySet tgt = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entitys = tgt.FindByEntityKey(tgtMainType.toString());
        Map<Long, DynamicObject> srcBillMap = this.getSrcBillMap(entitys);
        for (int i = 0; i < entitys.length; ++i) {
            ExtendedDataEntity entity = entitys[i];
            DynamicObject obj = entity.getDataEntity();
            DynamicObjectCollection billentry = obj.getDynamicObjectCollection("entry");
            for (DynamicObject entry : billentry) {
                DynamicObjectCollection srcBillentry;
                DynamicObject srcBill = srcBillMap.get(entry.getLong("e_corebillid"));
                if (srcBill == null || (srcBillentry = srcBill.getDynamicObjectCollection("billentry")) == null) continue;
                DynamicObject firstEntry = (DynamicObject)srcBillentry.get(0);
                entry.set("conbillnumber", (Object)firstEntry.getString("conbillnumber"));
                entry.set("conbillid", (Object)firstEntry.getLong("conbillid"));
                entry.set("conbillentity", (Object)firstEntry.getDynamicObject("conbillentity"));
            }
        }
    }

    private Map<Long, DynamicObject> getSrcBillMap(ExtendedDataEntity[] entitys) {
        HashMap<Long, DynamicObject> srcBillMap = new HashMap<Long, DynamicObject>(8);
        HashSet<Long> coreBillIds = new HashSet<Long>(8);
        for (int i = 0; i < entitys.length; ++i) {
            ExtendedDataEntity entity = entitys[i];
            DynamicObject obj = entity.getDataEntity();
            DynamicObjectCollection billentry = obj.getDynamicObjectCollection("entry");
            for (DynamicObject entry : billentry) {
                coreBillIds.add(entry.getLong("e_corebillid"));
            }
        }
        DynamicObject[] salorderBills = BusinessDataServiceHelper.load((String)"sm_salorder", (String)String.join((CharSequence)",", "conbillnumber", "conbillid", "conbillentity"), (QFilter[])new QFilter[]{new QFilter("id", "in", coreBillIds)});
        if (salorderBills == null) {
            return srcBillMap;
        }
        for (DynamicObject bill : salorderBills) {
            srcBillMap.put((Long)bill.getPkValue(), bill);
        }
        return srcBillMap;
    }
}

