/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.formplugin.botp;

import java.util.HashMap;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.sm.business.helper.CustomerConvertInitHelper;
import kd.scmc.sm.business.helper.KitSalesHelper;
import kd.scmc.sm.business.helper.OrgHelper;
import kd.scmc.sm.enums.ProductTypeEnum;

public class SalOrder2SalReturnApplyConvertPlugin
extends AbstractConvertPlugIn {
    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] entitys;
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        for (ExtendedDataEntity entity : entitys = entitySet.FindByEntityKey(this.getTgtMainType().toString())) {
            DynamicObject bill = entity.getDataEntity();
            if (bill == null) continue;
            CustomerConvertInitHelper.setDefaultCustomerValue((DynamicObject)bill, (String)"customer");
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject row = (DynamicObject)entrys.get(i);
                if (row == null || row.getDynamicObject("entryinvorg") == null) continue;
                long stockOrgID = (Long)row.getDynamicObject("entryinvorg").getPkValue();
                long inspectOrgID = OrgHelper.getDefaultOrgRelation((String)"", (String)"06", (Long)stockOrgID, (String)"toorg");
                DynamicObject inspectOrgDO = null;
                if (inspectOrgID > 0L) {
                    inspectOrgDO = BusinessDataServiceHelper.loadSingleFromCache((Object)inspectOrgID, (String)"bos_org");
                }
                row.set("inspectorg", inspectOrgDO);
            }
            if (!KitSalesHelper.isKitSale()) continue;
            String kittransfermodel = "";
            Long currentKitPid = -1L;
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject entryInfo = (DynamicObject)entrys.get(i);
                if (ProductTypeEnum.KITPARENT.getValue().equals(entryInfo.getString("producttype"))) {
                    kittransfermodel = entryInfo.getString("kittransfermodel");
                    currentKitPid = entryInfo.getLong("kitpid");
                }
                if (!ProductTypeEnum.KITCHILD.getValue().equals(entryInfo.getString("producttype")) || !currentKitPid.equals(entryInfo.getLong("kitpid"))) continue;
                entryInfo.set("kittransfermodel", (Object)kittransfermodel);
            }
            HashSet<Long> srcOrderIdSet = new HashSet<Long>(8);
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject returnEntryInfo = (DynamicObject)entrys.get(i);
                String returnProductType = returnEntryInfo.getString("producttype");
                DynamicObject[] returnKitTransferModel = returnEntryInfo.getString("kittransfermodel");
                if (!ProductTypeEnum.KITCHILD.getValue().equals(returnProductType) || !StringUtils.isEmpty((CharSequence)returnKitTransferModel)) continue;
                Long srcOrderId = returnEntryInfo.getLong("srcbillid");
                srcOrderIdSet.add(srcOrderId);
            }
            if (srcOrderIdSet == null || srcOrderIdSet.isEmpty()) continue;
            QFilter orderFilter = new QFilter("id", "in", srcOrderIdSet);
            DynamicObject[] srcOrders = BusinessDataServiceHelper.load((String)"sm_salorder", (String)"id,billentry.id,billentry.producttype,billentry.material,billentry.kitpid", (QFilter[])new QFilter[]{orderFilter});
            HashMap<Long, DynamicObject> srcOrderMap = new HashMap<Long, DynamicObject>(8);
            if (srcOrders != null && srcOrders.length > 0) {
                for (DynamicObject order : srcOrders) {
                    Long id = order.getLong("id");
                    if (id == null) continue;
                    srcOrderMap.put(id, order);
                }
            }
            block5: for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject salOrder;
                DynamicObject returnEntryInfo = (DynamicObject)entrys.get(i);
                String returnProductType = returnEntryInfo.getString("producttype");
                String returnKitTransferModel = returnEntryInfo.getString("kittransfermodel");
                if (!ProductTypeEnum.KITCHILD.getValue().equals(returnProductType) || !StringUtils.isEmpty((CharSequence)returnKitTransferModel)) continue;
                Long childPId = returnEntryInfo.getLong("kitpid");
                Long srcOrderId = returnEntryInfo.getLong("srcbillid");
                if (srcOrderId == null || (salOrder = (DynamicObject)srcOrderMap.get(srcOrderId)) == null) continue;
                DynamicObjectCollection salEntrys = salOrder.getDynamicObjectCollection("billentry");
                for (DynamicObject salEntry : salEntrys) {
                    DynamicObject material;
                    Long pid = salEntry.getLong("kitpid");
                    String orderProductType = salEntry.getString("producttype");
                    if (!ProductTypeEnum.KITPARENT.getValue().equals(orderProductType) || childPId.longValue() != pid.longValue() || (material = salEntry.getDynamicObject("material")) == null) continue;
                    String materialTransferModel = material.getString("kitreturnmodel");
                    returnEntryInfo.set("kittransfermodel", (Object)materialTransferModel);
                    continue block5;
                }
            }
        }
    }
}

