/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.formplugin.botp;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.sm.business.helper.CurrencyHelper;

public class SalOrder2TransApplyPlugin
extends AbstractConvertPlugIn {
    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entitys = entitySet.FindByEntityKey(this.getTgtMainType().toString());
        HashMap<Object, Object> currencyCache = new HashMap<Object, Object>();
        for (ExtendedDataEntity entity : entitys) {
            DynamicObject bill = entity.getDataEntity();
            DynamicObject org = bill.getDynamicObject("org");
            if (org == null) {
                bill.set("settlecurrency", null);
            } else if (currencyCache.containsKey(org.getPkValue())) {
                bill.set("settlecurrency", currencyCache.get(org.getPkValue()));
            } else {
                Map map = CurrencyHelper.getCurrencyAndExRateTable((Long)org.getLong("id"));
                if (map == null) {
                    bill.set("settlecurrency", null);
                } else {
                    this.setRefObj(bill, (Long)map.get("baseCurrencyID"), "settlecurrency");
                }
                currencyCache.put(org.getPkValue(), bill.get("settlecurrency"));
            }
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject row = (DynamicObject)entrys.get(i);
                String keeperType = row.getString("keepertype");
                if (!"bos_org".equals(keeperType)) continue;
                row.set("keeper", (Object)org);
            }
        }
    }

    private void setRefObj(DynamicObject targetObject, Long refObjID, String property) {
        BasedataProp bdp = (BasedataProp)this.getTgtMainType().findProperty(property);
        DynamicObject refObj = BusinessDataServiceHelper.loadSingleFromCache((Object)refObjID, (DynamicObjectType)((DynamicObjectType)bdp.getComplexType((Object)targetObject)));
        targetObject.set(property, (Object)refObj);
    }
}

