/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.formplugin.botp;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.mpscmm.msbd.business.helper.BizTypeHelper;

public class SalOrderPurApplyConvertPlugin
extends AbstractConvertPlugIn {
    private static final Log log = LogFactory.getLog(SalOrderPurApplyConvertPlugin.class);
    private static final BigDecimal ZERO = BigDecimal.ZERO;
    private static final BigDecimal ONE = BigDecimal.ONE;

    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        BillEntityType tgtMainType = this.getTgtMainType();
        ExtendedDataEntitySet tgt = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entitys = tgt.FindByEntityKey(tgtMainType.toString());
        for (int i = 0; i < entitys.length; ++i) {
            ExtendedDataEntity entity = entitys[i];
            DynamicObject obj = entity.getDataEntity();
            DynamicObjectCollection billentry = obj.getDynamicObjectCollection("billentry");
            for (int j = 0; j < billentry.size(); ++j) {
                DynamicObject master;
                DynamicObject entry = (DynamicObject)billentry.get(j);
                DynamicObject material = entry.getDynamicObject("material");
                if (material == null) continue;
                DynamicObject supplier = entry.getDynamicObject("supplier");
                BigDecimal taxRate = entry.getBigDecimal("taxrate");
                DynamicObject taxRateId = entry.getDynamicObject("taxrateid");
                if (taxRateId != null && taxRate != null && BigDecimal.ZERO.compareTo(taxRate) != 0) continue;
                DynamicObject taxRateDynamicObject = null;
                if (material != null && (master = material.getDynamicObject("masterid")) != null && master.getDynamicObject("taxrate") != null) {
                    taxRateDynamicObject = master.getDynamicObject("taxrate");
                }
                if (taxRateDynamicObject == null && supplier != null) {
                    taxRateDynamicObject = supplier.getDynamicObject("taxrate");
                }
                if (taxRateDynamicObject != null) {
                    Long taxRateID = (Long)taxRateDynamicObject.getPkValue();
                    taxRateDynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_taxrate", (String)"id, taxrate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)taxRateID)});
                }
                if (taxRateDynamicObject == null) continue;
                entry.set("taxrateid", (Object)taxRateDynamicObject);
                entry.set("taxrate", (Object)taxRateDynamicObject.getBigDecimal("taxrate"));
            }
        }
        this.mserviceDeal(entitys);
    }

    private void mserviceDeal(ExtendedDataEntity[] entities) {
        if (entities == null || entities.length == 0) {
            return;
        }
        List bills = Arrays.stream(entities).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
        List contBills = (List)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"pm", (String)"PurApplyService", (String)"batchSetPRDefValue", (Object[])new Object[]{bills});
        int billSize = entities.length;
        for (int i = 0; i < contBills.size() && i < billSize; ++i) {
            DynamicObject contBill = (DynamicObject)contBills.get(i);
            DynamicObject bill = entities[i].getDataEntity();
            if (contBill == null || bill == null) continue;
            DynamicObject billType = bill.getDynamicObject("billtype");
            if (billType == null) {
                log.info("\u5355\u636e\u7c7b\u578b\u4e3a\u7a7a");
                continue;
            }
            DynamicObject bizType = bill.getDynamicObject("biztype");
            if (bizType == null) {
                bizType = SalOrderPurApplyConvertPlugin.getDefaultBizType(billType);
                bill.set("biztype", (Object)bizType);
            }
            bill.set("currency", contBill.get("currency"));
            DynamicObjectCollection billEntry = bill.getDynamicObjectCollection("billentry");
            DynamicObjectCollection contEntry = contBill.getDynamicObjectCollection("billentry");
            if (billEntry != null && billEntry.size() > 0) {
                for (int j = 0; j < billEntry.size(); ++j) {
                    DynamicObject contRow = (DynamicObject)contEntry.get(j);
                    DynamicObject row = (DynamicObject)billEntry.get(j);
                    row.set("unit", contRow.get("unit"));
                    row.set("qty", contRow.get("qty"));
                    row.set("applyqty", contRow.get("applyqty"));
                    row.set("price", contRow.get("price"));
                    row.set("priceandtax", contRow.get("priceandtax"));
                    row.set("amount", contRow.get("amount"));
                    row.set("taxamount", contRow.get("taxamount"));
                    row.set("amountandtax", contRow.get("amountandtax"));
                }
            }
            bill.set("totalallamount", contBill.get("totalallamount"));
        }
    }

    protected static DynamicObject getDefaultBizType(DynamicObject billType) {
        DynamicObject bizType = null;
        Long bizTypeId = BizTypeHelper.getDefaultBizType((String)"pm_purapplybill", (Long)((Long)billType.getPkValue()), (String)"pm_billtypeparameter");
        if (bizTypeId != null) {
            bizType = BusinessDataServiceHelper.loadSingleFromCache((Object)bizTypeId, (String)"bd_biztype");
        }
        return bizType;
    }
}

