/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.formplugin.botp;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msbd.business.helper.botp.SalContractDefValueHelper;
import kd.scmc.sm.business.helper.BillTplHelper;

public class SalQuotaSalConmConvertPlugin
extends AbstractConvertPlugIn {
    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        BillEntityType tgtMainType = this.getTgtMainType();
        ExtendedDataEntitySet tgt = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entitys = tgt.FindByEntityKey(tgtMainType.toString());
        for (int i = 0; i < entitys.length; ++i) {
            ExtendedDataEntity entity = entitys[i];
            DynamicObject obj = entity.getDataEntity();
            DynamicObjectCollection billentry = obj.getDynamicObjectCollection("billentry");
            for (int j = 0; j < billentry.size(); ++j) {
                BillTplHelper.calcQtyAndBaseQty((int)j, (DynamicObject)obj);
            }
        }
        this.mserviceDeal(entitys);
    }

    private void mserviceDeal(ExtendedDataEntity[] entities) {
        if (entities == null || entities.length == 0) {
            return;
        }
        List bills = Arrays.stream(entities).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
        List contBills = SalContractDefValueHelper.batchSetSalContractDefValue(bills);
        int billSize = entities.length;
        for (int i = 0; i < contBills.size() && i < billSize; ++i) {
            DynamicObject contBill = (DynamicObject)contBills.get(i);
            DynamicObject bill = entities[i].getDataEntity();
            if (contBill == null || bill == null) continue;
            Date biztime = (Date)contBill.get("biztime");
            bill.set("category", contBill.get("category"));
            bill.set("conmprop", contBill.get("conmprop"));
            bill.set("reviewstatus", contBill.get("reviewstatus"));
            bill.set("signstatus", contBill.get("signstatus"));
            bill.set("filingstatus", contBill.get("filingstatus"));
            bill.set("contparties", contBill.get("contparties"));
            bill.set("party1st", contBill.get("party1st"));
            bill.set("contactperson1st", contBill.get("contactperson1st"));
            bill.set("phone1st", contBill.get("phone1st"));
            bill.set("party2nd", contBill.get("party2nd"));
            bill.set("contactperson2nd", contBill.get("contactperson2nd"));
            bill.set("phone2nd", contBill.get("phone2nd"));
            bill.set("reccustomer", contBill.get("reccustomer"));
            bill.set("settlecustomer", contBill.get("settlecustomer"));
            bill.set("payingcustomer", contBill.get("payingcustomer"));
            bill.set("settletype", contBill.get("settletype"));
            bill.set("currency", contBill.get("currency"));
            bill.set("settlecurrency", contBill.get("settlecurrency"));
            bill.set("exratedate", contBill.get("exratedate"));
            bill.set("exchangerate", contBill.get("exchangerate"));
            bill.set("exratetable", contBill.get("exratetable"));
            bill.set("exchangetype", contBill.get("exchangetype"));
            bill.set("totalallamount", contBill.get("totalallamount"));
            bill.set("totalamount", contBill.get("totalamount"));
            bill.set("totaltaxamount", contBill.get("totaltaxamount"));
            bill.set("reclinkman", contBill.get("reclinkman"));
            bill.set("receiveaddress", contBill.get("receiveaddress"));
            bill.set("operator", contBill.get("operator"));
            bill.set("operatorgroup", contBill.get("operatorgroup"));
            bill.set("dept", contBill.get("dept"));
            DynamicObjectCollection billEntry = bill.getDynamicObjectCollection("billentry");
            DynamicObjectCollection contEntry = contBill.getDynamicObjectCollection("billentry");
            if (billEntry == null || billEntry.size() <= 0) continue;
            for (int j = 0; j < billEntry.size(); ++j) {
                DynamicObject contRow = (DynamicObject)contEntry.get(j);
                DynamicObject row = (DynamicObject)billEntry.get(j);
                row.set("price", contRow.get("price"));
                row.set("priceandtax", contRow.get("priceandtax"));
                row.set("discountamount", contRow.get("discountamount"));
                row.set("amount", contRow.get("amount"));
                row.set("taxamount", contRow.get("taxamount"));
                row.set("amountandtax", contRow.get("amountandtax"));
                row.set("productline", contRow.get("productline"));
                row.set("auxunit", contRow.get("auxunit"));
                row.set("auxqty", contRow.get("auxqty"));
                row.set("curamount", contRow.get("curamount"));
                row.set("curtaxamount", contRow.get("curtaxamount"));
                row.set("curamountandtax", contRow.get("curamountandtax"));
                Long srcbillid = (Long)row.get("srcbillid");
                if (row.get("srcbillid") == null || srcbillid == 0L) continue;
                DynamicObject source = BusinessDataServiceHelper.loadSingle((Object)row.get("srcbillid"), (String)this.getSrcMainType().getName());
                DynamicObjectCollection sourceDynamicObjectCollection = source.getDynamicObjectCollection("billentry");
                for (int t = 0; t < sourceDynamicObjectCollection.size(); ++t) {
                    DynamicObject entry = (DynamicObject)sourceDynamicObjectCollection.get(t);
                    if (!row.get("srcbillentryid").equals(entry.getPkValue())) continue;
                    int delivdays = (Integer)((DynamicObject)sourceDynamicObjectCollection.get(t)).get("delivdays");
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(biztime);
                    calendar.add(5, delivdays);
                    row.set("deliverydate", (Object)calendar.getTime());
                }
            }
        }
    }
}

