/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.formplugin.botp;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msbd.business.helper.botp.SalOrderDefValueHelper;
import kd.scmc.sm.business.helper.BillTplHelper;
import kd.scmc.sm.business.helper.KitSalesHelper;
import kd.scmc.sm.enums.ProductTypeEnum;

public class SalQuotaSalOrderConvertPlugin
extends AbstractConvertPlugIn {
    public void afterConvert(AfterConvertEventArgs e) {
        int i;
        super.afterConvert(e);
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        String tgtMainType = this.getTgtMainType().toString();
        ExtendedDataEntity[] entitys = entitySet.FindByEntityKey(tgtMainType);
        List<DynamicObject> bills = new ArrayList(8);
        for (i = 0; i < entitys.length; ++i) {
            ExtendedDataEntity entity = entitys[i];
            DynamicObject bill = entity.getDataEntity();
            bills.add(bill);
        }
        bills = SalOrderDefValueHelper.batchSetSalOrdeDefValue(bills, (Boolean)Boolean.TRUE, (Boolean)Boolean.TRUE);
        for (i = 0; i < bills.size(); ++i) {
            Long pID;
            String productType;
            DynamicObject bill = (DynamicObject)bills.get(i);
            DynamicObjectCollection entrycols = bill.getDynamicObjectCollection("billentry");
            if (entrycols.size() > 0) {
                entrycols.forEach(entry -> this.processDeliDate((DynamicObject)entry, bill));
            }
            if (!KitSalesHelper.isKitSale() || entrycols.size() <= 0) continue;
            HashMap<Long, DynamicObject> parentRowMap = new HashMap<Long, DynamicObject>(8);
            for (DynamicObject entry2 : entrycols) {
                productType = entry2.getString("producttype");
                pID = entry2.getLong("kitpid");
                if (pID == null || !ProductTypeEnum.KITPARENT.getValue().equals(productType) || Long.valueOf("0").equals(pID)) continue;
                parentRowMap.put(pID, entry2);
            }
            for (DynamicObject entry2 : entrycols) {
                DynamicObject parentRow;
                productType = entry2.getString("producttype");
                pID = entry2.getLong("kitpid");
                if (pID == null || !ProductTypeEnum.KITCHILD.getValue().equals(productType) || Long.valueOf("0").equals(pID) || (parentRow = (DynamicObject)parentRowMap.get(pID)) == null) continue;
                entry2.set("iscontrolday", parentRow.get("iscontrolday"));
                entry2.set("deliveradvdays", parentRow.get("deliveradvdays"));
                entry2.set("deliverdelaydays", parentRow.get("deliverdelaydays"));
                entry2.set("iscontrolqty", parentRow.get("iscontrolqty"));
                entry2.set("deliverratedown", parentRow.get("deliverratedown"));
                entry2.set("deliverrateup", parentRow.get("deliverrateup"));
                this.deliverUpAndDownCalc(entry2);
            }
        }
    }

    private void processDeliDate(DynamicObject entrycol, DynamicObject obj) {
        if (entrycol != null) {
            DynamicObject source = BusinessDataServiceHelper.loadSingle((Object)entrycol.get("srcbillid"), (String)this.getSrcMainType().getName());
            DynamicObjectCollection sourceDynamicObjectCollection = source.getDynamicObjectCollection("billentry");
            for (int i = 0; i < sourceDynamicObjectCollection.size(); ++i) {
                DynamicObject entry = (DynamicObject)sourceDynamicObjectCollection.get(i);
                if (!entrycol.get("srcbillentryid").equals(entry.getPkValue())) continue;
                Date bizdate = (Date)obj.get("bizdate");
                int delivdays = (Integer)((DynamicObject)sourceDynamicObjectCollection.get(i)).get("delivdays");
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(bizdate);
                calendar.add(5, delivdays);
                entrycol.set("deliverydate", (Object)calendar.getTime());
            }
        }
    }

    private void deliverUpAndDownCalc(DynamicObject entry) {
        BigDecimal qty = entry.getBigDecimal("qty");
        BigDecimal baseQty = entry.getBigDecimal("baseqty");
        DynamicObject baseUnit = entry.getDynamicObject("baseunit");
        DynamicObject unit = entry.getDynamicObject("unit");
        if (unit == null || baseUnit == null) {
            entry.set("deliverqtyup", null);
            entry.set("deliverbaseqtyup", null);
            entry.set("deliverqtydown", null);
            entry.set("deliverbaseqtydown", null);
        } else {
            int precision = unit.getInt("precision");
            int precisionAccount = BillTplHelper.getRoundMode((DynamicObject)unit);
            int basePrecision = baseUnit.getInt("precision");
            int basePrecisionAccount = BillTplHelper.getRoundMode((DynamicObject)baseUnit);
            BigDecimal deliverRateUp = entry.getBigDecimal("deliverrateup");
            BigDecimal deliverRateDown = entry.getBigDecimal("deliverratedown");
            BigDecimal deliverQtyUp = qty.multiply(new BigDecimal(100).add(deliverRateUp)).divide(new BigDecimal(100), precision, precisionAccount);
            BigDecimal deliverBaseQtyUp = baseQty.multiply(new BigDecimal(100).add(deliverRateUp)).divide(new BigDecimal(100), basePrecision, basePrecisionAccount);
            BigDecimal deliverQtyDown = qty.multiply(new BigDecimal(100).subtract(deliverRateDown)).divide(new BigDecimal(100), precision, precisionAccount);
            BigDecimal deliverBaseQtyDown = baseQty.multiply(new BigDecimal(100).subtract(deliverRateDown)).divide(new BigDecimal(100), basePrecision, basePrecisionAccount);
            entry.set("deliverqtyup", (Object)deliverQtyUp);
            entry.set("deliverbaseqtyup", (Object)deliverBaseQtyUp);
            entry.set("deliverqtydown", (Object)deliverQtyDown);
            entry.set("deliverbaseqtydown", (Object)deliverBaseQtyDown);
        }
    }
}

