/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.formplugin.notice;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.sm.business.helper.KitSalesHelper;
import kd.scmc.sm.business.provider.MateriaListDataProvider;
import kd.scmc.sm.enums.ProductTypeEnum;
import kd.scmc.sm.formplugin.tpl.BillTplListPlugin;

public class DeliverNoticeListPlugin
extends BillTplListPlugin {
    private static final Log log = LogFactory.getLog(DeliverNoticeListPlugin.class);

    @Override
    public void setFilter(SetFilterEvent e) {
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new MateriaListDataProvider("billentry.materialname", "billentry.material"));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        block23: {
            if (!KitSalesHelper.isKitSale()) {
                return;
            }
            try (TraceSpan span = Tracer.create((String)"DeliverNoticeListPlugin", (String)("beforeDoOperation: " + args.getSource()));){
                ListSelectedRow listSelectedRow;
                String opKey;
                if (!(args.getSource() instanceof FormOperate) || !"copy".equals(opKey = ((FormOperate)args.getSource()).getOperateKey())) break block23;
                BillList billList = (BillList)this.getControl("billlistap");
                if (billList.getSelectedRows() != null && billList.getSelectedRows().size() > 1) {
                    Object firstPrimaryKey = billList.getSelectedRows().get(0).getPrimaryKeyValue();
                    ListSelectedRowCollection listSelectedRows = billList.getSelectedRows();
                    for (int i = 1; i < listSelectedRows.size(); ++i) {
                        if (firstPrimaryKey.equals(listSelectedRows.get(i).getPrimaryKeyValue())) continue;
                        args.setCancel(true);
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u590d\u5236\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"DeliverNoticeListPlugin_0", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        return;
                    }
                }
                if ((listSelectedRow = billList.getCurrentSelectedRowInfo()) == null || listSelectedRow.getPrimaryKeyValue() == null) {
                    return;
                }
                DynamicObject currRowData = BusinessDataServiceHelper.loadSingle((Object)listSelectedRow.getPrimaryKeyValue(), (String)"sm_delivernotice", (String)"producttype");
                DynamicObjectCollection entry = currRowData.getDynamicObjectCollection("billentry");
                if (entry == null || entry.size() <= 0) break block23;
                for (DynamicObject entryInfo : entry) {
                    String productType = entryInfo.getString("producttype");
                    if (ProductTypeEnum.STANDARD.getValue().equals(productType)) continue;
                    args.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u4e2d\u5b58\u5728\u5957\u4ef6\u7269\u6599\uff0c\u4e0d\u5141\u8bb8\u6574\u5355\u590d\u5236\u3002", (String)"DeliverNoticeListPlugin_1", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    break;
                }
            }
        }
        super.beforeDoOperation(args);
    }
}

