/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.formplugin.notice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msbd.common.enums.KitTransferModelEnum;
import kd.scmc.sm.business.helper.KitSalesHelper;
import kd.scmc.sm.business.helper.RowOPHelper;
import kd.scmc.sm.business.pojo.RowCloseActionResult;
import kd.scmc.sm.enums.ProductTypeEnum;
import kd.scmc.sm.enums.RowCloseStatusEnum;
import kd.scmc.sm.enums.RowTerminateStatusEnum;
import kd.scmc.sm.formplugin.notice.DeliverNoticeRowClosePlugin;
import kd.scmc.sm.formplugin.tpl.BillTplListPlugin;

public class DeliverNoticeListRowOPPlugin
extends BillTplListPlugin {
    private static Log log = LogFactory.getLog(DeliverNoticeRowClosePlugin.class);

    @Override
    public void setFilter(SetFilterEvent e) {
        e.setOrderBy("bizdate desc,billno desc");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        boolean isKitSale = KitSalesHelper.isKitSale();
        if ("rowclose".equals(evt.getItemKey())) {
            if (selectedRows != null && selectedRows.size() > 0) {
                log.info("\u5217\u8868\u884c\u5173\u95ed-\u6267\u884c\u5f00\u59cb" + evt.getItemKey());
                DynamicObject[] billColl = this.getSelBillColl();
                if (billColl == null || billColl.length <= 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"DeliverNoticeRowClosePlugin_10", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    return;
                }
                List<Long> selEntryIDs = this.getSelEntryIDs();
                if (isKitSale && ((selEntryIDs = this.changeKitEntryIDs(billColl, selEntryIDs, evt.getItemKey())) == null || selEntryIDs.isEmpty())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u5206\u5f55\u884c\u4e0d\u53ef\u5173\u95ed\u3002", (String)"DeliverNoticeRowClosePlugin_2", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    return;
                }
                RowCloseActionResult rowCloseActionResult = RowOPHelper.checkRowClose((DynamicObject[])billColl, selEntryIDs);
                String msg = RowOPHelper.doRowClose((DynamicObject[])billColl, (RowCloseActionResult)rowCloseActionResult);
                log.info("\u5217\u8868\u884c\u53cd\u5173\u95ed" + msg + ", rowCloseActionResult" + rowCloseActionResult);
                this.showMsg(rowCloseActionResult, msg);
                billList.refresh();
                List billNos = Arrays.asList(billColl).stream().filter(e -> rowCloseActionResult.getSuccessBillID().contains(e.getPkValue())).map(e -> e.getString("billno")).collect(Collectors.toList());
                OperationResult operationResult = RowOPHelper.createOperationResult();
                RowOPHelper.writeLog((OperationResult)operationResult, (DynamicObject)billColl[0].getDynamicObject("org"), (String)evt.getItemKey(), (String)(rowCloseActionResult.getSuccessBillID().size() > 0 ? billNos + ":" + msg : msg), (String)"sm_delivernotice");
                log.info("\u5217\u8868\u884c\u5173\u95ed-\u6267\u884c\u7ed3\u675f" + evt.getItemKey());
            } else {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"DeliverNoticeListRowOPPlugin_1", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
            }
        } else if ("rowunclose".equals(evt.getItemKey())) {
            if (selectedRows != null && selectedRows.size() > 0) {
                log.info("\u5217\u8868\u884c\u53cd\u5173\u95ed-\u6267\u884c\u5f00\u59cb" + evt.getItemKey());
                DynamicObject[] billColl = this.getSelBillColl();
                if (billColl == null || billColl.length <= 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"DeliverNoticeRowClosePlugin_10", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    return;
                }
                List<Long> selEntryIDs = this.getSelEntryIDs();
                if (isKitSale && ((selEntryIDs = this.changeKitEntryIDs(billColl, selEntryIDs, evt.getItemKey())) == null || selEntryIDs.isEmpty())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u5206\u5f55\u884c\u4e2d\u6ca1\u6709\u53ef\u53cd\u5173\u95ed\u7684\u884c\u3002", (String)"DeliverNoticeRowUnClosePlugin_3", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    return;
                }
                RowCloseActionResult rowCloseActionResult = RowOPHelper.checkRowUnClose((DynamicObject[])billColl, selEntryIDs);
                String msg = RowOPHelper.doRowUnClose((DynamicObject[])billColl, (RowCloseActionResult)rowCloseActionResult);
                log.info("\u5217\u8868\u884c\u53cd\u5173\u95ed" + msg + ", rowCloseActionResult" + rowCloseActionResult);
                this.showMsg(rowCloseActionResult, msg);
                billList.refresh();
                List billNos = Arrays.asList(billColl).stream().filter(e -> rowCloseActionResult.getSuccessBillID().contains(e.getPkValue())).map(e -> e.getString("billno")).collect(Collectors.toList());
                OperationResult operationResult = RowOPHelper.createOperationResult();
                RowOPHelper.writeLog((OperationResult)operationResult, (DynamicObject)billColl[0].getDynamicObject("org"), (String)evt.getItemKey(), (String)(rowCloseActionResult.getSuccessBillID().size() > 0 ? billNos + ":" + msg : msg), (String)"sm_delivernotice");
                log.info("\u5217\u8868\u884c\u53cd\u5173\u95ed-\u6267\u884c\u7ed3\u675f" + evt.getItemKey());
            } else {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"DeliverNoticeListRowOPPlugin_1", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    protected DynamicObject[] getSelBillColl() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows != null && selectedRows.size() > 0) {
            HashSet<Long> billIDs = new HashSet<Long>();
            for (int i = 0; i < selectedRows.size(); ++i) {
                ListSelectedRow listSelectedRow = selectedRows.get(i);
                if (listSelectedRow == null || listSelectedRow.getPrimaryKeyValue() == null) continue;
                Long billId = (Long)listSelectedRow.getPrimaryKeyValue();
                billIDs.add(billId);
            }
            DynamicObject[] billColl = RowOPHelper.getDeliverBills(billIDs, (boolean)true);
            return billColl;
        }
        return null;
    }

    protected List<Long> getSelEntryIDs() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows != null && selectedRows.size() > 0) {
            ArrayList<Long> selEntryIDs = new ArrayList<Long>();
            for (int i = 0; i < selectedRows.size(); ++i) {
                ListSelectedRow listSelectedRow = selectedRows.get(i);
                if (listSelectedRow == null || listSelectedRow.getPrimaryKeyValue() == null) continue;
                Long entryID = (Long)listSelectedRow.getEntryPrimaryKeyValue();
                selEntryIDs.add(entryID);
            }
            return selEntryIDs;
        }
        return null;
    }

    protected void showMsg(RowCloseActionResult rowCloseActionResult, String msg) {
        if (rowCloseActionResult.getSuccessBillID().size() > 0) {
            if (rowCloseActionResult.getErrorReslt().size() > 0) {
                this.getView().showMessage(msg, rowCloseActionResult.getErrorMsg(), MessageTypes.Commit);
            } else {
                this.getView().showSuccessNotification(msg);
            }
        } else {
            this.getView().showMessage(msg, rowCloseActionResult.getErrorMsg(), MessageTypes.Commit);
        }
    }

    private Boolean isCanRowUnClose(DynamicObject billEntry) {
        String rowCloseStatus = billEntry.getString("rowclosestatus");
        String rowTerminateStatus = billEntry.getString("rowterminatestatus");
        if ((rowTerminateStatus == null || RowTerminateStatusEnum.UNROWTERMINATE.getValue().equals(rowTerminateStatus)) && RowCloseStatusEnum.ROWCLOSE.getValue().equals(rowCloseStatus)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private Boolean isCanRowUnClose(Long childId, DynamicObjectCollection billEntrys) {
        Boolean isCanRowUnClose = Boolean.FALSE;
        if (childId == null || billEntrys == null) {
            return isCanRowUnClose;
        }
        for (DynamicObject billEntry : billEntrys) {
            Long pkId = (Long)billEntry.getPkValue();
            if (pkId.longValue() != childId.longValue()) continue;
            return this.isCanRowUnClose(billEntry);
        }
        return isCanRowUnClose;
    }

    private Boolean isCanRowClose(DynamicObject billEntry) {
        String rowCloseStatus = billEntry.getString("rowclosestatus");
        String rowTerminateStatus = billEntry.getString("rowterminatestatus");
        if ((rowTerminateStatus == null || RowTerminateStatusEnum.UNROWTERMINATE.getValue().equals(rowTerminateStatus)) && RowCloseStatusEnum.UNROWCLOSE.getValue().equals(rowCloseStatus)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private Boolean isCanRowClose(Long childId, DynamicObjectCollection billEntrys) {
        Boolean isCanRowClose = Boolean.FALSE;
        if (childId == null || billEntrys == null) {
            return isCanRowClose;
        }
        for (DynamicObject billEntry : billEntrys) {
            Long pkId = (Long)billEntry.getPkValue();
            if (pkId.longValue() != childId.longValue()) continue;
            return this.isCanRowClose(billEntry);
        }
        return isCanRowClose;
    }

    private List<Long> changeKitEntryIDs(DynamicObject[] billColl, List<Long> selEntryIDs, String evtKey) {
        if (billColl != null && selEntryIDs != null) {
            HashSet<Long> selectedRows = new HashSet<Long>(8);
            selectedRows.addAll(selEntryIDs);
            for (DynamicObject bill : billColl) {
                DynamicObjectCollection billEntrys = bill.getDynamicObjectCollection("billentry");
                for (DynamicObject billEntry : billEntrys) {
                    Long entryID = (Long)billEntry.getPkValue();
                    if (!selEntryIDs.contains(entryID)) continue;
                    String productType = billEntry.getString("producttype");
                    String transferModel = billEntry.getString("kittransfermodel");
                    if (!KitTransferModelEnum.KIT.getValue().equals(transferModel)) continue;
                    if (ProductTypeEnum.KITPARENT.getValue().equals(productType)) {
                        Boolean isCanAddAllChild = Boolean.TRUE;
                        if ("rowunclose".equals(evtKey)) {
                            if (!this.isCanRowUnClose(billEntry).booleanValue()) {
                                isCanAddAllChild = Boolean.FALSE;
                            }
                        } else if ("rowclose".equals(evtKey) && !this.isCanRowClose(billEntry).booleanValue()) {
                            isCanAddAllChild = Boolean.FALSE;
                        }
                        if (isCanAddAllChild.booleanValue()) {
                            List<Long> allChildIds = this.getAllChildIds(billEntry, billEntrys);
                            if (allChildIds == null || allChildIds.isEmpty()) continue;
                            if ("rowunclose".equals(evtKey)) {
                                for (Long childId : allChildIds) {
                                    if (this.isCanRowUnClose(childId, billEntrys).booleanValue()) continue;
                                    isCanAddAllChild = Boolean.FALSE;
                                }
                            } else if ("rowclose".equals(evtKey)) {
                                for (Long childId : allChildIds) {
                                    if (this.isCanRowClose(childId, billEntrys).booleanValue()) continue;
                                    isCanAddAllChild = Boolean.FALSE;
                                }
                            }
                            if (isCanAddAllChild.booleanValue()) {
                                selectedRows.addAll(allChildIds);
                                continue;
                            }
                            selectedRows.remove((Long)billEntry.getPkValue());
                            continue;
                        }
                        selectedRows.remove((Long)billEntry.getPkValue());
                        continue;
                    }
                    if (!ProductTypeEnum.KITCHILD.getValue().equals(productType)) continue;
                    DynamicObject parentEntry = this.getParentEntry(billEntry, billEntrys);
                    Boolean isCanAddAllChild = Boolean.TRUE;
                    if (parentEntry == null) continue;
                    if ("rowunclose".equals(evtKey)) {
                        if (!this.isCanRowUnClose(parentEntry).booleanValue()) {
                            isCanAddAllChild = Boolean.FALSE;
                        } else {
                            selectedRows.add((Long)parentEntry.getPkValue());
                        }
                    } else if ("rowclose".equals(evtKey)) {
                        if (!this.isCanRowClose(parentEntry).booleanValue()) {
                            isCanAddAllChild = Boolean.FALSE;
                        } else {
                            selectedRows.add((Long)parentEntry.getPkValue());
                        }
                    }
                    if (isCanAddAllChild.booleanValue()) {
                        List<Long> allChildIds = this.getAllChildIds(parentEntry, billEntrys);
                        if (allChildIds == null || allChildIds.isEmpty()) continue;
                        if ("rowunclose".equals(evtKey)) {
                            for (Long childId : allChildIds) {
                                if (this.isCanRowUnClose(childId, billEntrys).booleanValue()) continue;
                                isCanAddAllChild = Boolean.FALSE;
                            }
                        } else if ("rowclose".equals(evtKey)) {
                            for (Long childId : allChildIds) {
                                if (this.isCanRowClose(childId, billEntrys).booleanValue()) continue;
                                isCanAddAllChild = Boolean.FALSE;
                            }
                        }
                        if (isCanAddAllChild.booleanValue()) {
                            selectedRows.addAll(allChildIds);
                            continue;
                        }
                        selectedRows.remove((Long)parentEntry.getPkValue());
                        selectedRows.remove((Long)billEntry.getPkValue());
                        continue;
                    }
                    selectedRows.remove((Long)billEntry.getPkValue());
                }
            }
            selEntryIDs = selectedRows != null && !selectedRows.isEmpty() ? new ArrayList<Long>(selectedRows) : null;
        }
        return selEntryIDs;
    }

    private List<Long> getAllChildIds(DynamicObject parentEntry, DynamicObjectCollection billEntrys) {
        ArrayList<Long> allChildIds = new ArrayList<Long>();
        if (parentEntry == null || billEntrys == null) {
            return allChildIds;
        }
        Long parentPID = parentEntry.getLong("kitpid");
        for (DynamicObject billEntry : billEntrys) {
            Long pID = billEntry.getLong("kitpid");
            String productType = billEntry.getString("producttype");
            if (!ProductTypeEnum.KITCHILD.getValue().equals(productType) || parentPID.longValue() != pID.longValue()) continue;
            allChildIds.add((Long)billEntry.getPkValue());
        }
        return allChildIds;
    }

    private DynamicObject getParentEntry(DynamicObject childEntry, DynamicObjectCollection billEntrys) {
        if (childEntry == null || billEntrys == null) {
            return null;
        }
        Long parentPID = childEntry.getLong("kitpid");
        for (DynamicObject billEntry : billEntrys) {
            Long pID = billEntry.getLong("kitpid");
            String productType = billEntry.getString("producttype");
            if (!ProductTypeEnum.KITPARENT.getValue().equals(productType) || parentPID.longValue() != pID.longValue()) continue;
            return billEntry;
        }
        return null;
    }
}

