/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.formplugin.notice;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bd.sbd.enums.OperatorGrpTypeEnum;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.LinkSetElement;
import kd.bos.entity.LinkSetItemElement;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mpscmm.msbd.business.helper.BaseDataHelper;
import kd.mpscmm.msbd.common.enums.KitTransferModelEnum;
import kd.scmc.sm.business.helper.BillTplHelper;
import kd.scmc.sm.business.helper.IMServiceHelper;
import kd.scmc.sm.business.helper.KitSalesHelper;
import kd.scmc.sm.business.helper.LotCacheHelper;
import kd.scmc.sm.business.helper.OrgHelper;
import kd.scmc.sm.business.helper.PluginConnectControllHelper;
import kd.scmc.sm.business.helper.PriceListF7Helper;
import kd.scmc.sm.business.helper.PropertyChangeHelper;
import kd.scmc.sm.business.helper.SalesOrgHelper;
import kd.scmc.sm.enums.EnableStatusEnum;
import kd.scmc.sm.enums.OwnerTypeEnum;
import kd.scmc.sm.enums.ProductTypeEnum;
import kd.scmc.sm.util.CommonUtils;

public class DeliverNoticePlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
RowClickEventListener,
EntryGridBindDataListener {
    private static final String BLANK = " ";

    public void registerListener(EventObject e) {
        BasedataEdit inspectOrgEdit;
        BasedataEdit priceList;
        EntryGrid entry;
        BasedataEdit deliverorg;
        BasedataEdit deliverdept;
        BasedataEdit reccustomer;
        BasedataEdit customer;
        BasedataEdit deliveroperatorEdit;
        BasedataEdit invgroupEdit;
        BasedataEdit materialEdit;
        BasedataEdit ownerEdit;
        BasedataEdit warehouseEdit;
        super.registerListener(e);
        BasedataEdit settleOrgEdit = (BasedataEdit)this.getView().getControl("entrysettleorg");
        if (settleOrgEdit != null) {
            settleOrgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((warehouseEdit = (BasedataEdit)this.getView().getControl("warehouse")) != null) {
            warehouseEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((ownerEdit = (BasedataEdit)this.getView().getControl("owner")) != null) {
            ownerEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((materialEdit = (BasedataEdit)this.getView().getControl("material")) != null) {
            materialEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((invgroupEdit = (BasedataEdit)this.getView().getControl("invgroup")) != null) {
            invgroupEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((deliveroperatorEdit = (BasedataEdit)this.getView().getControl("deliveroperator")) != null) {
            deliveroperatorEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((customer = (BasedataEdit)this.getView().getControl("customer")) != null) {
            customer.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((reccustomer = (BasedataEdit)this.getView().getControl("reccustomer")) != null) {
            reccustomer.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((deliverdept = (BasedataEdit)this.getView().getControl("deliverdept")) != null) {
            deliverdept.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((deliverorg = (BasedataEdit)this.getView().getControl("deliverorg")) != null) {
            deliverorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((entry = (EntryGrid)this.getControl("billentry")) != null) {
            entry.addDataBindListener((EntryGridBindDataListener)this);
        }
        if ((priceList = (BasedataEdit)this.getView().getControl("pricelist")) != null) {
            priceList.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((inspectOrgEdit = (BasedataEdit)this.getView().getControl("inspectorg")) != null) {
            inspectOrgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeBindData(EventObject e) {
        try (TraceSpan span = Tracer.create((String)"DeliverNoticePlugin", (String)"beforeBindData");){
            this.setUIDeliverOrgStatus();
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billentry");
            if (entryGrid != null) {
                entryGrid.addDataBindListener((EntryGridBindDataListener)this);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        try (TraceSpan span = Tracer.create((String)"DeliverNoticePlugin", (String)"afterBindData");){
            this.setOwnerTypeEnable();
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"addrow"});
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        try (TraceSpan span = Tracer.create((String)"DeliverNoticePlugin", (String)"entryGridBindData");){
            if (KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) {
                this.setKitColumnEnables(e.getRows());
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        block14: {
            if (!KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) {
                return;
            }
            try (TraceSpan span = Tracer.create((String)"DeliverNoticePlugin", (String)("beforeDoOperation: " + args.getSource()));){
                DynamicObject currRowData;
                DynamicObjectCollection entry;
                String opKey;
                if (!(args.getSource() instanceof FormOperate) || !"copy".equals(opKey = ((FormOperate)args.getSource()).getOperateKey()) || (entry = (currRowData = this.getModel().getDataEntity(true)).getDynamicObjectCollection("billentry")) == null || entry.size() <= 0) break block14;
                for (DynamicObject entryInfo : entry) {
                    String productType = entryInfo.getString("producttype");
                    if (ProductTypeEnum.STANDARD.getValue().equals(productType)) continue;
                    args.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u4e2d\u5b58\u5728\u5957\u4ef6\u7269\u6599\uff0c\u4e0d\u5141\u8bb8\u6574\u5355\u590d\u5236\u3002", (String)"DeliverNoticeListPlugin_1", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    break;
                }
            }
        }
        super.beforeDoOperation(args);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void beforeF7Select(BeforeF7SelectEvent e) {
        try (TraceSpan span = Tracer.create((String)"DeliverNoticePlugin", (String)("beforeF7Select: " + e.getProperty().getName()));){
            String fieldKey = e.getProperty().getName();
            IDataModel bill = this.getModel();
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            int rowIndex = this.getModel().getEntryCurrentRowIndex("billentry");
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            DynamicObject deliverOrg = (DynamicObject)bill.getValue("deliverorg");
            DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
            switch (fieldKey) {
                case "material": 
                case "dept": 
                case "operator": 
                case "customer": 
                case "entrysettleorg": 
                case "owner": 
                case "project": 
                case "taxrateid": {
                    boolean stopListener = PluginConnectControllHelper.isStopListener((IPageCache)this.getPageCache(), (String)"beforeF7Select");
                    if (!stopListener) break;
                    return;
                }
            }
            switch (fieldKey) {
                case "warehouse": {
                    if (deliverOrg == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53d1\u8d27\u7ec4\u7ec7\u3002", (String)"DeliverNoticePlugin_0", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        e.setCancel(true);
                        return;
                    }
                    Long[] allWhs = (Long[])IMServiceHelper.invokeBizService((String)"InvService", (String)"getAllWarehouseIDs", (Object[])new Object[]{deliverOrg.getString("number")});
                    showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)allWhs));
                    return;
                }
                case "material": {
                    if (bizType != null && "6".equals(bizType.getString("domain"))) {
                        QFilter q1 = new QFilter("masterid.enablevmi", "=", (Object)Boolean.TRUE);
                        showParameter.getListFilterParameter().setFilter(q1);
                    }
                    if (!KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) return;
                    String productType = (String)this.getModel().getValue("producttype", rowIndex);
                    if (ProductTypeEnum.KITPARENT.getValue().equals(productType)) {
                        QFilter suiteFilter = new QFilter("kittransfermodel", "!=", (Object)BLANK);
                        showParameter.getListFilterParameter().getQFilters().add(suiteFilter);
                        return;
                    }
                    if (!ProductTypeEnum.KITCHILD.getValue().equals(productType)) {
                        if (!ProductTypeEnum.STANDARD.getValue().equals(productType)) return;
                    }
                    QFilter suiteFilter = new QFilter("kittransfermodel", "=", (Object)BLANK);
                    showParameter.getListFilterParameter().getQFilters().add(suiteFilter);
                    return;
                }
                case "owner": {
                    if (!"bos_org".equals(bill.getValue("ownertype", rowIndex))) {
                        if (!OwnerTypeEnum.SUPPLIER.getValue().equals(bill.getValue("ownertype", rowIndex))) return;
                        QFilter q1 = new QFilter("enablevmi", "=", (Object)Boolean.TRUE);
                        QFilter q2 = new QFilter("status", "=", (Object)"C");
                        QFilter q3 = new QFilter("enable", "=", (Object)"1");
                        QFilter q4 = new QFilter("supplier_status.number", "=", (Object)"ZCGYS");
                        QFilter q5 = BaseDataHelper.getBaseDataFilterByOrg((String)OwnerTypeEnum.SUPPLIER.getValue(), (Long)((Long)org.getPkValue()), (boolean)false);
                        showParameter.getListFilterParameter().setQFilters(Arrays.asList(q1, q2, q3, q4, q5));
                        return;
                    }
                    if (deliverOrg == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53d1\u8d27\u7ec4\u7ec7\u3002", (String)"DeliverNoticePlugin_0", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        e.setCancel(true);
                        return;
                    }
                    List ownerArray = SalesOrgHelper.getAccountOrgRange((Long)((Long)deliverOrg.getPkValue()));
                    if (ownerArray != null && ownerArray.size() != 0) {
                        QFilter ownerFilter = new QFilter("id", "in", (Object)ownerArray);
                        showParameter.getListFilterParameter().setFilter(ownerFilter);
                        return;
                    }
                    QFilter ownerFilter = new QFilter("fisaccounting", "=", (Object)Boolean.TRUE);
                    showParameter.getListFilterParameter().setFilter(ownerFilter);
                    return;
                }
                case "invgroup": {
                    if (deliverOrg == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53d1\u8d27\u7ec4\u7ec7\u3002", (String)"DeliverNoticePlugin_0", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        e.setCancel(true);
                        return;
                    }
                    QFilter qFilter01 = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", (Long)((Long)deliverOrg.getPkValue()));
                    QFilter qFilter02 = new QFilter("operatorgrouptype", "=", (Object)OperatorGrpTypeEnum.INVENTORYGRP.getValue());
                    Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (QFilter[])new QFilter[]{qFilter01, qFilter02});
                    ArrayList operatorGrps = new ArrayList(map.size());
                    map.forEach((key, value) -> operatorGrps.add((Long)key));
                    showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", operatorGrps));
                    return;
                }
                case "deliveroperator": {
                    if (deliverOrg == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53d1\u8d27\u7ec4\u7ec7\u3002", (String)"DeliverNoticePlugin_0", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        e.setCancel(true);
                        return;
                    }
                    QFilter qFilter1 = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", (Long)((Long)deliverOrg.getPkValue()));
                    QFilter qFilter2 = new QFilter("operatorgrouptype", "=", (Object)OperatorGrpTypeEnum.INVENTORYGRP.getValue());
                    QFilter qFilter3 = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
                    Map maps = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3});
                    QFilter qFilter11 = new QFilter("operatorgrpid", "in", maps.keySet());
                    Map mapOperators = BusinessDataServiceHelper.loadFromCache((String)"bd_operator", (QFilter[])new QFilter[]{qFilter11});
                    ArrayList operators = new ArrayList(mapOperators.size());
                    mapOperators.forEach((key, value) -> operators.add((Long)key));
                    showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", operators));
                    return;
                }
                case "customer": {
                    QFilter bizfunction;
                    QFilter customerFilter = bizfunction = new QFilter("bizfunction", "like", (Object)"%1%");
                    if (bizType != null && "230".equals(bizType.getString("number"))) {
                        QFilter consignment = new QFilter("consignment", "=", (Object)Boolean.TRUE);
                        customerFilter = customerFilter.and(consignment);
                    }
                    showParameter.getListFilterParameter().getQFilters().add(customerFilter);
                    return;
                }
                case "reccustomer": {
                    QFilter blockedshipment = new QFilter("blockedshipment", "=", (Object)"0");
                    showParameter.getListFilterParameter().getQFilters().add(blockedshipment);
                    return;
                }
                case "deliverorg": {
                    if (org != null) return;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"DeliverNoticePlugin_3", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                case "deliverdept": {
                    DynamicObject user;
                    if (deliverOrg == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53d1\u8d27\u7ec4\u7ec7\u3002", (String)"DeliverNoticePlugin_0", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        e.setCancel(true);
                        return;
                    }
                    List deliverDeptIDs = OrgHelper.getAllToOrg((String)"15", (String)"01", (Long)((Long)deliverOrg.getPkValue()), (boolean)true);
                    DynamicObject deliverOperator = (DynamicObject)this.getModel().getValue("deliveroperator");
                    if (deliverOperator != null && (user = deliverOperator.getDynamicObject("operatorid")) != null) {
                        Long userID = (Long)user.getPkValue();
                        Long deptID = UserServiceHelper.getUserMainOrgId((long)userID);
                        deliverDeptIDs.add(deptID);
                    }
                    QFilter deliverDeptFilter = new QFilter("id", "in", (Object)deliverDeptIDs);
                    showParameter.getListFilterParameter().getQFilters().add(deliverDeptFilter);
                    return;
                }
                case "inspectorg": {
                    if (deliverOrg != null) return;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53d1\u8d27\u7ec4\u7ec7\u3002", (String)"DeliverNoticePlugin_0", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                case "pricelist": {
                    DynamicObject customer = (DynamicObject)this.getModel().getValue("customer");
                    if (customer == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ba2\u8d27\u5ba2\u6237\u3002", (String)"DeliverNoticePlugin_6", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        e.setCancel(true);
                        return;
                    }
                    showParameter.getListFilterParameter().setFilter(PriceListF7Helper.getPriceListFilter((DynamicObject)this.getModel().getDataEntity(true)));
                    return;
                }
            }
            return;
        }
    }

    public void afterCreateNewData(EventObject e) {
        try (TraceSpan span = Tracer.create((String)"DeliverNoticePlugin", (String)"afterCreateNewData");){
            this.initDeliverOrgDefaultValue();
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            int entryRowCount = this.getModel().getEntryRowCount("billentry");
            for (int i = 0; i < entryRowCount; ++i) {
                this.initNewDataEntry(i, org);
            }
            this.setOwnerTypeDefault();
        }
    }

    public void afterCopyData(EventObject e) {
        try (TraceSpan span = Tracer.create((String)"DeliverNoticePlugin", (String)"afterCopyData");){
            int entryRowCount = this.getModel().getEntryRowCount("billentry");
            for (int i = 0; i < entryRowCount; ++i) {
                this.getModel().setValue("invqty", (Object)BigDecimal.ZERO, i);
                this.getModel().setValue("invbaseqty", (Object)BigDecimal.ZERO, i);
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        try (TraceSpan span = Tracer.create((String)"DeliverNoticePlugin", (String)("afterAddRow: " + entryName));){
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            RowDataEntity[] rowDataEntities = e.getRowDataEntities();
            if ("billentry".equals(entryName)) {
                ArrayList<Integer> rowIndexList = new ArrayList<Integer>(8);
                for (RowDataEntity rowDataEntity : rowDataEntities) {
                    int rowIndex = rowDataEntity.getRowIndex();
                    rowIndexList.add(rowIndex);
                    this.initNewDataEntry(rowIndex, org);
                }
                if (KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) {
                    this.setKitColumnEnable(rowIndexList);
                    this.setKitDeliverColumnDefault(rowIndexList);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        int entryRowCount = this.getModel().getEntryRowCount("billentry");
        try (TraceSpan span = Tracer.create((String)"DeliverNoticePlugin", (String)("propertyChanged: " + e.getProperty().getName()));){
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (!CommonUtils.isRealChanged((ChangeData)changeSet[0])) return;
            switch (fieldKey) {
                case "deliverorg": {
                    Object newValue = changeSet[0].getNewValue();
                    ArrayList<RowDataEntity> rows = new ArrayList<RowDataEntity>(entryRowCount);
                    DynamicObject deliverorg = (DynamicObject)changeSet[0].getNewValue();
                    this.getModel().setValue("invgroup", null);
                    this.getModel().setValue("deliveroperator", null);
                    int i = 0;
                    while (true) {
                        if (i >= entryRowCount) {
                            LotCacheHelper.setLotEnable(rows, (IFormView)this.getView(), (IPageCache)this.getPageCache());
                            return;
                        }
                        if (deliverorg == null) {
                            this.getModel().setValue("inspectorg", null, i);
                        }
                        this.getModel().setValue("e_deliverorg", newValue, i);
                        this.getModel().setValue("warehouse", null, i);
                        SalesOrgHelper.setOwner((int)i, (IDataModel)this.getModel(), (DynamicObject)org, (DynamicObject)((DynamicObject)this.getModel().getValue("deliverorg")), (IPageCache)this.getPageCache());
                        RowDataEntity rowDataEntity = new RowDataEntity(i, this.getModel().getEntryRowEntity("billentry", i));
                        rows.add(rowDataEntity);
                        ++i;
                    }
                }
                case "iscontrolqty": {
                    this.changeIsControlQty(changeSet);
                    if (!KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) return;
                    int i = 0;
                    while (i < changeSet.length) {
                        int parentRowIndex = changeSet[i].getRowIndex();
                        String productType = (String)this.getModel().getValue("producttype", parentRowIndex);
                        if (ProductTypeEnum.KITPARENT.getValue().equals(productType)) {
                            List<Integer> childIndexList = this.getAllChildEntry(parentRowIndex);
                            this.setKitDeliverColumnValue(childIndexList, parentRowIndex, "iscontrolqty");
                        }
                        ++i;
                    }
                    return;
                }
                case "material": {
                    int i = 0;
                    while (i < changeSet.length) {
                        int row = changeSet[i].getRowIndex();
                        this.getModel().setValue("deliverqtydown", null, row);
                        this.getModel().setValue("deliverqtyup", null, row);
                        this.getModel().setValue("deliverbaseqtydown", null, row);
                        this.getModel().setValue("deliverbaseqtyup", null, row);
                        if (changeSet[i].getNewValue() != null) {
                            DynamicObject material = (DynamicObject)changeSet[i].getNewValue();
                            boolean isControlQty = material.getBoolean("iscontrolqty");
                            this.getModel().setValue("iscontrolqty", (Object)isControlQty, row);
                            if (isControlQty) {
                                BigDecimal delieveRateUp = material.getBigDecimal("dlivrateceiling");
                                BigDecimal delieveRateDown = material.getBigDecimal("dlivratefloor");
                                this.getModel().setValue("deliverrateup", (Object)delieveRateUp, row);
                                this.getModel().setValue("deliverratedown", (Object)delieveRateDown, row);
                            }
                        }
                        if (KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) {
                            this.setOneKitColumnEnable(row);
                            this.setKitDeliverColumnDefault(Collections.singletonList(row));
                        }
                        ++i;
                    }
                    return;
                }
                case "qty": 
                case "auxqty": {
                    ArrayList<RowDataEntity> rows_1 = new ArrayList<RowDataEntity>();
                    int i = 0;
                    while (true) {
                        if (i >= changeSet.length) {
                            LotCacheHelper.setLotEnable(rows_1, (IFormView)this.getView(), (IPageCache)this.getPageCache());
                            return;
                        }
                        if (CommonUtils.isRealChanged((ChangeData)changeSet[i])) {
                            RowDataEntity rowDataEntity;
                            int row = changeSet[i].getRowIndex();
                            this.deliverUpAndDown(row);
                            BigDecimal newQty = (BigDecimal)changeSet[i].getNewValue();
                            BigDecimal oldQty = (BigDecimal)changeSet[i].getOldValue();
                            if (newQty == null) {
                                newQty = BigDecimal.ZERO;
                            }
                            if (oldQty == null) {
                                oldQty = BigDecimal.ZERO;
                            }
                            if (BigDecimal.ZERO.compareTo(newQty) == 0) {
                                rowDataEntity = new RowDataEntity(row, this.getModel().getEntryRowEntity("billentry", row));
                                rows_1.add(rowDataEntity);
                            } else if (BigDecimal.ZERO.compareTo(oldQty) == 0) {
                                rowDataEntity = new RowDataEntity(row, this.getModel().getEntryRowEntity("billentry", row));
                                rows_1.add(rowDataEntity);
                            }
                            if (KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) {
                                this.calcChildRowQty(row);
                            }
                        }
                        ++i;
                    }
                }
                case "billtype": 
                case "biztype": 
                case "org": {
                    this.setOwnerTypeDefault();
                    this.setOwnerTypeEnable();
                    return;
                }
                case "ownertype": {
                    int i = 0;
                    while (i < changeSet.length) {
                        if (changeSet[i].getNewValue() == null || "".equals(changeSet[i].getNewValue())) {
                            PropertyChangeHelper.stopPropertyChange((IPageCache)this.getPageCache());
                            this.getModel().setValue("ownertype", changeSet[i].getOldValue(), changeSet[i].getRowIndex());
                            PropertyChangeHelper.releasePropertyChange((IPageCache)this.getPageCache());
                        } else {
                            this.getModel().setValue("owner", null, changeSet[i].getRowIndex());
                        }
                        ++i;
                    }
                    return;
                }
                case "unit": {
                    int i = 0;
                    while (i < changeSet.length) {
                        int row = changeSet[i].getRowIndex();
                        this.deliverUpAndDown(row);
                        if (KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) {
                            this.calcChildRowQty(row);
                        }
                        ++i;
                    }
                    return;
                }
                case "deliverrateup": 
                case "deliverratedown": {
                    int i = 0;
                    while (i < changeSet.length) {
                        int row = changeSet[i].getRowIndex();
                        this.deliverUpAndDown(row);
                        if (KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) {
                            int parentRowIndex = changeSet[i].getRowIndex();
                            String productType = (String)this.getModel().getValue("producttype", parentRowIndex);
                            if (ProductTypeEnum.KITPARENT.getValue().equals(productType)) {
                                List<Integer> childIndexList = this.getAllChildEntry(parentRowIndex);
                                this.setKitDeliverColumnValue(childIndexList, parentRowIndex, fieldKey);
                            }
                        }
                        ++i;
                    }
                    return;
                }
                case "deliveroperator": {
                    this.changeOperator((DynamicObject)changeSet[0].getNewValue());
                    return;
                }
                case "customer": {
                    this.getModel().setValue("pricelist", null);
                    return;
                }
                case "kittransfermodel": {
                    if (!KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) return;
                    int i = 0;
                    while (i < changeSet.length) {
                        if (CommonUtils.isRealChanged((ChangeData)changeSet[i])) {
                            int parentRowIndex = changeSet[i].getRowIndex();
                            String productType = (String)this.getModel().getValue("producttype", parentRowIndex);
                            if (ProductTypeEnum.KITPARENT.getValue().equals(productType)) {
                                List<Integer> childIndexList = this.getAllChildEntry(parentRowIndex);
                                String kitTransferModel = changeSet[i].getNewValue() == null ? null : changeSet[i].getNewValue().toString();
                                this.setChildDeliverColumnEnable(childIndexList, kitTransferModel);
                                this.setKitDeliverColumnDefault(childIndexList, parentRowIndex);
                            }
                        }
                        ++i;
                    }
                    return;
                }
                case "deliverydate1": {
                    if (!KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) return;
                    int i = 0;
                    while (i < changeSet.length) {
                        if (CommonUtils.isRealChanged((ChangeData)changeSet[i])) {
                            int parentRowIndex = changeSet[i].getRowIndex();
                            String productType = (String)this.getModel().getValue("producttype", parentRowIndex);
                            if (ProductTypeEnum.KITPARENT.getValue().equals(productType)) {
                                List<Integer> childIndexList = this.getAllChildEntry(parentRowIndex);
                                this.setKitDeliverColumnValue(childIndexList, parentRowIndex, "deliverydate1");
                            }
                        }
                        ++i;
                    }
                    return;
                }
            }
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey;
        super.afterDoOperation(e);
        switch (operateKey = e.getOperateKey()) {
            case "save": {
                this.setOwnerTypeEnable();
                break;
            }
        }
    }

    private void changeIsControlQty(ChangeData[] changeSet) {
        for (int i = 0; i < changeSet.length; ++i) {
            ChangeData changeData = changeSet[i];
            Object newValue = changeData.getNewValue();
            int rowIndex = changeData.getRowIndex();
            IDataModel model = this.getModel();
            if (!(newValue instanceof Boolean)) continue;
            boolean isControlQty = (Boolean)newValue;
            if (isControlQty) {
                DynamicObject material = (DynamicObject)model.getValue("material", rowIndex);
                if (material == null) continue;
                BigDecimal receiveRateUp = material.getBigDecimal("dlivrateceiling");
                BigDecimal receiveRateDown = material.getBigDecimal("dlivratefloor");
                model.setValue("deliverrateup", (Object)receiveRateUp, rowIndex);
                model.setValue("deliverratedown", (Object)receiveRateDown, rowIndex);
                continue;
            }
            model.setValue("deliverrateup", (Object)BigDecimal.ZERO, rowIndex);
            model.setValue("deliverratedown", (Object)BigDecimal.ZERO, rowIndex);
        }
    }

    private void initDeliverOrgDefaultValue() {
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        DynamicObject billType = (DynamicObject)model.getValue("billtype");
        if (org != null && billType != null) {
            Long deliverOrg;
            DynamicObject deliverOrgObj = (DynamicObject)model.getValue("deliverorg");
            Long l = deliverOrg = deliverOrgObj == null ? null : (Long)deliverOrgObj.getPkValue();
            if (deliverOrg != null && deliverOrg != 0L) {
                QFilter qFilter13;
                QFilter qFilter12;
                QFilter qFilter03;
                QFilter qFilter02;
                long userID = UserServiceHelper.getCurrentUserId();
                String operatorGrpType = OperatorGrpTypeEnum.INVENTORYGRP.getValue();
                QFilter qFilter01 = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", (Long)deliverOrg);
                Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (QFilter[])new QFilter[]{qFilter01, qFilter02 = new QFilter("operatorgrouptype", "=", (Object)operatorGrpType), qFilter03 = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue())});
                if (map.size() == 0) {
                    return;
                }
                QFilter qFilter11 = new QFilter("operatorgrpid", "in", map.keySet());
                DynamicObject operator = BusinessDataServiceHelper.loadSingle((String)"bd_operator", (String)"operatorid,operatornumber,operatorname,operatorgrpid,opergrpnumber,opergrpname,opergrptype", (QFilter[])new QFilter[]{qFilter11, qFilter12 = new QFilter("operatorid", "=", (Object)userID), qFilter13 = new QFilter("invalid", "=", (Object)Boolean.FALSE)});
                if (!CommonUtils.isNull((Object)operator)) {
                    this.getModel().setValue("deliveroperator", (Object)operator.getLong("id"));
                    Long deptId = UserServiceHelper.getUserMainOrgId((long)userID);
                    this.getModel().setValue("deliverdept", (Object)deptId);
                    this.getModel().setValue("invgroup", (Object)operator.getLong("operatorgrpid"));
                    this.getView().setEnable(Boolean.TRUE, new String[]{"invgroup"});
                } else {
                    this.getModel().setValue("deliveroperator", null);
                    this.getModel().setValue("deliverdept", null);
                    this.getModel().setValue("invgroup", null);
                    this.getView().setEnable(Boolean.FALSE, new String[]{"invgroup"});
                }
            }
        }
    }

    private void setUIDeliverOrgStatus() {
        IDataModel model = this.getModel();
        if (model.getValue("deliverorg") != null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"adddeliverpanel"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"changedeliverpanel"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"adddeliverpanel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"changedeliverpanel"});
        }
    }

    private void initNewDataEntry(int rowIndex, DynamicObject org) {
        Object deliverOrg = this.getModel().getValue("deliverorg");
        this.getModel().setValue("e_deliverorg", deliverOrg, rowIndex);
        DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
        if (bizType != null && "6".equals(bizType.getString("domain"))) {
            this.getModel().setValue("ownertype", (Object)OwnerTypeEnum.SUPPLIER.getValue(), rowIndex);
        } else {
            this.getModel().setValue("ownertype", (Object)OwnerTypeEnum.ORG.getValue(), rowIndex);
            if (this.getModel().getValue("owner", rowIndex) == null) {
                SalesOrgHelper.setOwner((int)rowIndex, (IDataModel)this.getModel(), (DynamicObject)org, (DynamicObject)((DynamicObject)this.getModel().getValue("deliverorg")), (IPageCache)this.getPageCache());
            }
        }
    }

    private void deliverUpAndDown(int row) {
        BigDecimal qty = (BigDecimal)this.getModel().getValue("qty", row);
        BigDecimal baseQty = (BigDecimal)this.getModel().getValue("baseqty", row);
        Object sourceBillID = this.getModel().getValue("srcbillid", row);
        Object sourceBillEntryID = this.getModel().getValue("srcbillentryid", row);
        if (qty != null && qty.compareTo(BigDecimal.ZERO) > 0) {
            if ((sourceBillID == null || Long.valueOf(0L).equals(sourceBillID)) && (sourceBillEntryID == null || Long.valueOf(0L).equals(sourceBillEntryID)) || !this.isDraw()) {
                BigDecimal deliverrateup = (BigDecimal)this.getModel().getValue("deliverrateup", row);
                BigDecimal deliverratedown = (BigDecimal)this.getModel().getValue("deliverratedown", row);
                BigDecimal deliverqtyup = qty.multiply(new BigDecimal(100).add(deliverrateup)).divide(new BigDecimal(100));
                BigDecimal deliverbaseqtyup = baseQty.multiply(new BigDecimal(100).add(deliverrateup)).divide(new BigDecimal(100));
                BigDecimal deliverqtydown = qty.multiply(new BigDecimal(100).subtract(deliverratedown)).divide(new BigDecimal(100));
                BigDecimal deliverbaseqtydown = baseQty.multiply(new BigDecimal(100).subtract(deliverratedown)).divide(new BigDecimal(100));
                this.getModel().setValue("deliverqtyup", (Object)deliverqtyup, row);
                this.getModel().setValue("deliverbaseqtyup", (Object)deliverbaseqtyup, row);
                this.getModel().setValue("deliverqtydown", (Object)deliverqtydown, row);
                this.getModel().setValue("deliverbaseqtydown", (Object)deliverbaseqtydown, row);
            } else {
                this.getModel().setValue("deliverqtydown", (Object)qty, row);
                this.getModel().setValue("deliverqtyup", (Object)qty, row);
                this.getModel().setValue("deliverbaseqtydown", (Object)baseQty, row);
                this.getModel().setValue("deliverbaseqtyup", (Object)baseQty, row);
            }
        } else {
            this.getModel().setValue("deliverqtyup", (Object)BigDecimal.ZERO, row);
            this.getModel().setValue("deliverbaseqtyup", (Object)BigDecimal.ZERO, row);
            this.getModel().setValue("deliverqtydown", (Object)BigDecimal.ZERO, row);
            this.getModel().setValue("deliverbaseqtydown", (Object)BigDecimal.ZERO, row);
        }
    }

    private boolean isDraw() {
        String isDrawCache = this.getPageCache().get("isdraw");
        if (StringUtils.isNotEmpty((CharSequence)isDrawCache)) {
            return Boolean.parseBoolean(isDrawCache);
        }
        boolean isDraw = this.getIsDraw();
        this.getPageCache().put("isdraw", String.valueOf(isDraw));
        return isDraw;
    }

    private boolean getIsDraw() {
        String formId = this.getView().getEntityId();
        LinkSetElement linkSet = ConvertMetaServiceHelper.loadLinkSet((String)formId);
        if (linkSet == null || linkSet.getItems() == null || linkSet.getItems().isEmpty()) {
            return false;
        }
        ExtendedDataEntitySet dataSet = new ExtendedDataEntitySet();
        DynamicObject billObj = this.getModel().getDataEntity();
        dataSet.Parse(new DynamicObject[]{billObj}, (MainEntityType)billObj.getDataEntityType());
        for (LinkSetItemElement linkEntry : linkSet.getItems()) {
            ExtendedDataEntity[] rows = dataSet.FindByEntityKey(linkEntry.getLinkEntityKey());
            if (rows == null || rows.length <= 0) continue;
            for (ExtendedDataEntity row : rows) {
                if (!this.haveSourceBillId(row.getDataEntity())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean haveSourceBillId(DynamicObject linkRow) {
        LinkEntryType linkType = (LinkEntryType)linkRow.getDataEntityType();
        Long sBillId = (Long)linkType.getSBillIdProp().getValueFast((Object)linkRow);
        return sBillId != null && sBillId != 0L;
    }

    private void changeOperator(DynamicObject operator) {
        if (!CommonUtils.isNull((Object)operator)) {
            this.getModel().setValue("deliveroperator", (Object)operator.getLong("id"));
            DynamicObject user = operator.getDynamicObject("operatorid");
            if (user != null) {
                Long userID = (Long)user.getPkValue();
                Long deptID = UserServiceHelper.getUserMainOrgId((long)userID);
                this.getModel().setValue("deliverdept", (Object)deptID);
            }
            this.getModel().setValue("invgroup", (Object)operator.getLong("operatorgrpid"));
            this.getView().setEnable(Boolean.TRUE, new String[]{"invgroup"});
        } else {
            this.getModel().setValue("deliveroperator", null);
            this.getModel().setValue("deliverdept", null);
            this.getModel().setValue("invgroup", null);
            this.getView().setEnable(Boolean.FALSE, new String[]{"invgroup"});
        }
    }

    private void setOwnerTypeEnable() {
        DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
        if (bizType != null && !"210".equals(bizType.getString("number"))) {
            this.getView().setEnable(Boolean.FALSE, -1, new String[]{"ownertype"});
        } else {
            this.getView().setEnable(Boolean.TRUE, -1, new String[]{"ownertype"});
        }
    }

    private void setOwnerTypeDefault() {
        DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
        if (bizType != null && "6".equals(bizType.getString("domain"))) {
            int entryRowCount = this.getModel().getEntryRowCount("billentry");
            for (int i = 0; i < entryRowCount; ++i) {
                this.getModel().setValue("ownertype", (Object)OwnerTypeEnum.SUPPLIER.getValue(), i);
            }
        } else {
            int entryRowCount = this.getModel().getEntryRowCount("billentry");
            for (int i = 0; i < entryRowCount; ++i) {
                this.getModel().setValue("ownertype", (Object)OwnerTypeEnum.ORG.getValue(), i);
            }
        }
    }

    private void setKitColumnEnables(List<RowDataEntity> currencyRows) {
        if (currencyRows == null || currencyRows.size() == 0) {
            return;
        }
        for (RowDataEntity row : currencyRows) {
            int rowIndex = row.getRowIndex();
            this.setKitDeliverColumnEnable(rowIndex, null);
        }
    }

    private void setOneKitColumnEnable(int rowIndex) {
        this.setKitDeliverColumnEnable(rowIndex, null);
    }

    private void setKitColumnEnable(List<Integer> rows) {
        if (rows == null || rows.size() == 0) {
            return;
        }
        for (int rowIndex : rows) {
            this.setKitDeliverColumnEnable(rowIndex, null);
        }
    }

    private void setKitDeliverColumnEnable(int rowIndex, String transfermodel) {
        String productType = (String)this.getModel().getValue("producttype", rowIndex);
        if (ProductTypeEnum.KITCHILD.getValue().equals(productType)) {
            if (transfermodel == null) {
                transfermodel = (String)this.getModel().getValue("kittransfermodel", rowIndex);
            }
            if (KitTransferModelEnum.KIT.getValue().equals(transfermodel)) {
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"deliverydate1"});
            } else if (KitTransferModelEnum.NONKIT.getValue().equals(transfermodel)) {
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"deliverydate1"});
            }
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"iscontrolqty", "deliverratedown", "deliverrateup"});
        }
    }

    private void setKitDeliverColumnDefault(List<Integer> childIndexList) {
        if (childIndexList == null || childIndexList.size() == 0) {
            return;
        }
        HashMap<Long, DynamicObject> parentMap = new HashMap<Long, DynamicObject>();
        for (int childRowIndex : childIndexList) {
            String productType = (String)this.getModel().getValue("producttype", childRowIndex);
            if (!ProductTypeEnum.KITCHILD.getValue().equals(productType)) continue;
            Long pID = (Long)this.getModel().getValue("kitpid", childRowIndex);
            DynamicObject parentEntry = (DynamicObject)parentMap.get(pID);
            if (parentEntry == null) {
                parentEntry = this.getParentEntry(childRowIndex);
                parentMap.put(pID, parentEntry);
            }
            if (parentEntry == null) continue;
            this.setKitDeliverOneColumnDefault(childRowIndex, parentEntry);
        }
    }

    private void setChildDeliverColumnEnable(List<Integer> childEntryList, String transferModel) {
        if (childEntryList == null || childEntryList.size() == 0) {
            return;
        }
        for (Integer childEntryIndex : childEntryList) {
            this.setKitDeliverColumnEnable(childEntryIndex, transferModel);
        }
    }

    private void setKitDeliverColumnValue(List<Integer> childIndexList, int parentRowIndex, String column) {
        if (childIndexList == null || childIndexList.size() == 0) {
            return;
        }
        DynamicObject parentEntry = this.getModel().getEntryRowEntity("billentry", parentRowIndex);
        for (int childRowIndex : childIndexList) {
            this.getModel().setValue(column, parentEntry.get(column), childRowIndex);
        }
    }

    private void setKitDeliverColumnDefault(List<Integer> childIndexList, int parentRowIndex) {
        if (childIndexList == null || childIndexList.size() == 0) {
            return;
        }
        DynamicObject parentEntry = this.getModel().getEntryRowEntity("billentry", parentRowIndex);
        for (int childRowIndex : childIndexList) {
            this.setKitDeliverOneColumnDefault(childRowIndex, parentEntry);
        }
    }

    private void setKitDeliverOneColumnDefault(Integer childRowIndex, DynamicObject parentEntry) {
        this.getModel().setValue("deliverydate1", parentEntry.get("deliverydate1"), childRowIndex.intValue());
        this.getModel().setValue("iscontrolqty", parentEntry.get("iscontrolqty"), childRowIndex.intValue());
        this.getModel().setValue("deliverratedown", parentEntry.get("deliverratedown"), childRowIndex.intValue());
        this.getModel().setValue("deliverrateup", parentEntry.get("deliverrateup"), childRowIndex.intValue());
    }

    private DynamicObject getParentEntry(int childRowIndex) {
        DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("billentry");
        Long pID = (Long)this.getModel().getValue("kitpid", childRowIndex);
        DynamicObject parentEntry = null;
        for (DynamicObject entry : entrys) {
            Long entryPid = entry.getLong("kitpid");
            String productType = entry.getString("producttype");
            if (!ProductTypeEnum.KITPARENT.getValue().equals(productType) || entryPid.longValue() != pID.longValue()) continue;
            parentEntry = entry;
            break;
        }
        return parentEntry;
    }

    private List<Integer> getAllChildEntry(int parentRowIndex) {
        DynamicObject parentEntry = this.getModel().getEntryRowEntity("billentry", parentRowIndex);
        Long parentPid = parentEntry.getLong("kitpid");
        ArrayList<Integer> childEntryList = new ArrayList<Integer>();
        int rowCount = this.getModel().getEntryRowCount("billentry");
        for (int i = 0; i < rowCount; ++i) {
            Long pID = (Long)this.getModel().getValue("kitpid", i);
            String productType = (String)this.getModel().getValue("producttype", i);
            if (!ProductTypeEnum.KITCHILD.getValue().equals(productType) || parentPid.longValue() != pID.longValue()) continue;
            childEntryList.add(i);
        }
        return childEntryList;
    }

    private void calcChildRowQty(Integer parentRowIndex) {
        if (KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) {
            String productType = (String)this.getModel().getValue("producttype", parentRowIndex.intValue());
            String transferModel = (String)this.getModel().getValue("kittransfermodel", parentRowIndex.intValue());
            if (ProductTypeEnum.KITPARENT.getValue().equals(productType) && KitTransferModelEnum.KIT.getValue().equals(transferModel)) {
                List<Integer> allChildIndexList = this.getAllChildEntry(parentRowIndex);
                for (Integer childRowIndex : allChildIndexList) {
                    BigDecimal parentBaseQty = (BigDecimal)this.getModel().getValue("baseqty", parentRowIndex.intValue());
                    BigDecimal kitQty = (BigDecimal)this.getModel().getValue("kitqty", childRowIndex.intValue());
                    BigDecimal parentQty = (BigDecimal)this.getModel().getValue("parentqty", childRowIndex.intValue());
                    DynamicObject baseUnit = (DynamicObject)this.getModel().getValue("baseunit", childRowIndex.intValue());
                    DynamicObject material = (DynamicObject)this.getModel().getValue("material", childRowIndex.intValue());
                    DynamicObject unit = (DynamicObject)this.getModel().getValue("unit", childRowIndex.intValue());
                    if (parentBaseQty == null || parentBaseQty.compareTo(BigDecimal.ZERO) == 0 || parentQty == null || parentQty.compareTo(BigDecimal.ZERO) == 0 || kitQty == null || unit == null || baseUnit == null || material == null) continue;
                    DynamicObject masterMaterial = material.getDynamicObject("masterid");
                    int precision = KitSalesHelper.getUnitPrecision((DynamicObject)baseUnit);
                    RoundingMode roundingMode = KitSalesHelper.getUnitRoundingMode((DynamicObject)baseUnit);
                    BigDecimal baseQty = parentBaseQty.multiply(kitQty).divide(parentQty, precision, roundingMode);
                    BigDecimal qty = BillTplHelper.getDesQtyConv((DynamicObject)masterMaterial, (DynamicObject)baseUnit, (BigDecimal)baseQty, (DynamicObject)unit);
                    this.getModel().setValue("qty", (Object)qty, childRowIndex.intValue());
                }
            }
        }
    }
}

