/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.formplugin.order;

import java.math.BigDecimal;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msbd.business.helper.SysParamHelper;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.mpscmm.msbd.formplugin.AbstractAutoQuotePlugin;
import kd.scmc.sm.business.helper.BillTplHelper;
import kd.scmc.sm.business.helper.PropertyChangeHelper;
import kd.scmc.sm.consts.Constants;
import kd.scmc.sm.enums.DiscountTypeEnum;

public class SalesOrderAutoQuotePlugin
extends AbstractAutoQuotePlugin {
    private static Log log = LogFactory.getLog(SalesOrderAutoQuotePlugin.class);

    protected String getMainOrgKey() {
        return "org";
    }

    protected boolean isAutoQuote() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            return false;
        }
        Boolean isautoquote = (Boolean)SysParamHelper.getSysParam4sm((Long)((Long)org.getPkValue()), (String)"isautoquote");
        if (isautoquote == null) {
            return false;
        }
        return isautoquote;
    }

    protected String getQuoteBillEntryNumber() {
        return "billentry";
    }

    protected void addSpecialListenFields(Set<String> specialListenKeys) {
        specialListenKeys.add("pricelist");
    }

    protected boolean cancelAutoQuote() {
        Boolean inputAmount = (Boolean)this.getModel().getValue("inputamount");
        if (inputAmount == null) {
            return false;
        }
        if ("stop".equals(this.getPageCache().get("cancelAutoQuote"))) {
            return true;
        }
        return inputAmount;
    }

    protected void afterUpdateView() {
        String taxRateKey = "taxrate";
        IDataModel model = this.getModel();
        IPageCache pageCache = this.getPageCache();
        int entryRowCount = model.getEntryRowCount("billentry");
        boolean isTax = (Boolean)model.getValue("istax");
        PropertyChangeHelper.stopPropertyChange((IPageCache)pageCache);
        int[] rowIndexs = new int[entryRowCount];
        for (int i = 0; i < entryRowCount; ++i) {
            BigDecimal value;
            rowIndexs[i] = i;
            DynamicObject taxRate = (DynamicObject)model.getValue("taxrateid", i);
            BigDecimal taxRateValue = (BigDecimal)model.getValue("taxrate", i);
            if (taxRate != null && BigDecimalUtil.isBlank((BigDecimal)taxRateValue) && BigDecimalUtil.isNotBlank((BigDecimal)(value = taxRate.getBigDecimal(taxRateKey)))) {
                model.setValue("taxrate", (Object)value, i);
            }
            boolean isPresent = (Boolean)model.getValue("ispresent", i);
            BigDecimal price = (BigDecimal)model.getValue("price", i);
            BigDecimal priceAndTax = (BigDecimal)model.getValue("priceandtax", i);
            if (!isPresent) continue;
            if (isTax) {
                if (BigDecimalUtil.isZero((BigDecimal)priceAndTax)) {
                    model.setValue("discounttype", (Object)DiscountTypeEnum.NULL.getValue(), i);
                    model.setValue("discountrate", (Object)Constants.ZERO, i);
                    continue;
                }
                model.setValue("discounttype", (Object)DiscountTypeEnum.DISRATE.getValue(), i);
                model.setValue("discountrate", (Object)Constants.ONE_HUNDRED, i);
                continue;
            }
            if (BigDecimalUtil.isZero((BigDecimal)price)) {
                model.setValue("discounttype", (Object)DiscountTypeEnum.NULL.getValue(), i);
                model.setValue("discountrate", (Object)Constants.ZERO, i);
                continue;
            }
            model.setValue("discounttype", (Object)DiscountTypeEnum.DISRATE.getValue(), i);
            model.setValue("discountrate", (Object)Constants.ONE_HUNDRED, i);
        }
        PropertyChangeHelper.releasePropertyChange((IPageCache)pageCache);
        long begin = System.currentTimeMillis();
        BillTplHelper.calculateAmount((DynamicObject)this.getModel().getDataEntity(true), (int[])rowIndexs, (IDataModel)model);
        this.doRefresh(rowIndexs, this.getView());
        this.doRefreshHeadAmount(this.getView());
        long end = System.currentTimeMillis();
        log.info("\u8ba1\u7b97\u903b\u8f91\u8017\u65f6\uff1a" + (end - begin) + "\u6beb\u79d2");
    }

    private void doRefresh(int[] selectRows, IFormView view) {
        boolean batchRefresh = false;
        if (selectRows == null) {
            view.updateView("billentry");
        } else {
            if (selectRows.length > BigDecimal.TEN.intValue()) {
                batchRefresh = true;
            }
            if (batchRefresh) {
                view.updateView("billentry");
            } else {
                String[] propNames = BillTplHelper.getEntryRefreshFields((String)"quote");
                if (propNames == null) {
                    return;
                }
                for (int i = 0; i < selectRows.length; ++i) {
                    for (String prop : propNames) {
                        view.updateView(prop, selectRows[i]);
                    }
                }
            }
        }
    }

    private void doRefreshHeadAmount(IFormView view) {
        view.updateView("totalallamount");
        view.updateView("totaltaxamount");
        view.updateView("totalamount");
        view.updateView("curtotalallamount");
        view.updateView("curtotaltaxamount");
        view.updateView("curtotalamount");
    }
}

