/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.formplugin.order;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.sm.business.helper.BillParameterHelper;
import kd.scmc.sm.business.helper.OrgHelper;

public class SalesOrderListPlugin
extends AbstractListPlugin {
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        try (TraceSpan span = Tracer.create((String)"SalesOrderListPlugin", (String)("afterDoOperation" + args.getOperateKey()));){
            BillList billList;
            ListSelectedRowCollection selectedRows;
            boolean success;
            OperationResult operationResult = args.getOperationResult();
            if (operationResult != null && (success = operationResult.isSuccess()) && "changelog".equals(args.getOperateKey()) && (selectedRows = (billList = (BillList)this.getView().getControl("billlistap")).getSelectedRows()) != null && selectedRows.size() > 0) {
                ArrayList<Object> scrBillIds = new ArrayList<Object>();
                ArrayList<Long> hasPerOrgs = new ArrayList<Long>();
                ArrayList<Long> noPerOrgs = new ArrayList<Long>();
                for (int i = 0; i < selectedRows.size(); ++i) {
                    Object srcBillId;
                    long mainOrgId;
                    ListSelectedRow listSelectedRow = selectedRows.get(i);
                    if (listSelectedRow == null || listSelectedRow.getPrimaryKeyValue() == null || !this.getUserPermission("01RKP4/KBG34", mainOrgId = listSelectedRow.getMainOrgId(), hasPerOrgs, noPerOrgs) || scrBillIds.contains(srcBillId = listSelectedRow.getPrimaryKeyValue())) continue;
                    scrBillIds.add(srcBillId);
                }
                if (scrBillIds.size() == 0) {
                    return;
                }
                ListShowParameter param = new ListShowParameter();
                param.setBillFormId("sm_xsalorderlog");
                param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                param.setCustomParam("srcbillids", scrBillIds);
                this.getView().showForm((FormShowParameter)param);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate op = (FormOperate)args.getSource();
        try (TraceSpan span = Tracer.create((String)"SalesOrderListPlugin", (String)("afterDoOperation" + op.getOperateKey()));){
            ListSelectedRow listSelectedRow;
            BillList billList;
            ListSelectedRowCollection selectedRows;
            if ("change".equals(op.getOperateKey()) && (selectedRows = (billList = (BillList)this.getView().getControl("billlistap")).getSelectedRows()) != null && selectedRows.size() > 0 && (listSelectedRow = selectedRows.get(0)) != null && listSelectedRow.getPrimaryKeyValue() != null) {
                Long orgID = listSelectedRow.getMainOrgId();
                int result = PermissionServiceHelper.checkPermission((Long)Long.valueOf(RequestContext.get().getUserId()), (Long)orgID, (String)"03", (String)"sm", (String)"sm_xsalorder", (String)"47156aff000000ac");
                if (result == 0) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u65e0\u9500\u552e\u8ba2\u5355\u53d8\u66f4\u5355\u65b0\u589e\u6743\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SalesOrderListPlugin_0", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
            }
        }
    }

    private boolean getUserPermission(String permissionId, long mainOrgId, List<Long> hasPerOrgs, List<Long> noPerOrgs) {
        if (hasPerOrgs.contains(mainOrgId)) {
            return true;
        }
        if (noPerOrgs.contains(mainOrgId)) {
            return false;
        }
        long userId = Long.parseLong(RequestContext.get().getUserId());
        BillList billList = (BillList)this.getView().getControl("billlistap");
        String formId = billList.getBillFormId();
        String appId = this.getView().getFormShowParameter().getAppId();
        int checkPermission = OrgHelper.checkPermission((Long)userId, (Long)mainOrgId, (String)appId, (String)formId, (String)permissionId);
        if (1 == checkPermission) {
            hasPerOrgs.add(mainOrgId);
        } else {
            noPerOrgs.add(mainOrgId);
        }
        return 1 == checkPermission;
    }

    public void afterBindData(EventObject e) {
        Boolean enablexssalorderbill = (Boolean)BillParameterHelper.getSalesOrderParameter((String)"enablexssalorderbill");
        if (enablexssalorderbill.booleanValue()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bizchange"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bizchangelog"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblchange"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblchanglog"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"tblbizchangeresume"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bizchange"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bizchangelog"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"tblchange"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"tblchanglog"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblbizchangeresume"});
        }
    }
}

