/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.formplugin.order;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.ExceptionUtils;
import kd.mpscmm.msbd.business.helper.BaseDataHelper;
import kd.mpscmm.msbd.business.helper.MaterialHelper;
import kd.mpscmm.msbd.changemodel.business.helper.ChangeModelHelper;
import kd.mpscmm.msbd.common.enums.KitStructCtlEnum;
import kd.mpscmm.msbd.common.enums.KitTransferModelEnum;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.scmc.sm.business.helper.BillImportHelper;
import kd.scmc.sm.business.helper.BillParameterHelper;
import kd.scmc.sm.business.helper.BillTplHelper;
import kd.scmc.sm.business.helper.BotpHelper;
import kd.scmc.sm.business.helper.IMServiceHelper;
import kd.scmc.sm.business.helper.KitSalesHelper;
import kd.scmc.sm.business.helper.LotCacheHelper;
import kd.scmc.sm.business.helper.MetaDataHelper;
import kd.scmc.sm.business.helper.PluginConnectControllHelper;
import kd.scmc.sm.business.helper.PriceListF7Helper;
import kd.scmc.sm.business.helper.PropertyChangeHelper;
import kd.scmc.sm.business.helper.SalOrderBillHelper;
import kd.scmc.sm.business.helper.SalOrderRecPlanHelper;
import kd.scmc.sm.business.helper.SaleDataCtrlHelper;
import kd.scmc.sm.business.helper.SalesOrgHelper;
import kd.scmc.sm.business.pojo.ReturnResultInfo;
import kd.scmc.sm.consts.BizKitConst;
import kd.scmc.sm.consts.Constants;
import kd.scmc.sm.enums.ChangeTypeEnum;
import kd.scmc.sm.enums.MaterialConfigPropertiesEnum;
import kd.scmc.sm.enums.OwnerTypeEnum;
import kd.scmc.sm.enums.ProductTypeEnum;
import kd.scmc.sm.util.CommonUtils;

public class SalesOrderPlugin
extends AbstractBillPlugIn
implements RowClickEventListener,
BeforeF7SelectListener,
EntryGridBindDataListener {
    private static final Log log = LogFactory.getLog(SalesOrderPlugin.class);
    private static final BigDecimal ZERO = BigDecimal.ZERO;
    private static final BigDecimal ONE = BigDecimal.ONE;
    private static final BigDecimal HUNDRED = new BigDecimal(100);
    private static final String BLANK = " ";
    private static final String[] deliverColumns = new String[]{"e_stockorg", "deliverydate", "iscontrolday", "deliveradvdays", "deliverdelaydays"};
    public static final String TAXRATE_FILTER = "taxrate_filter";
    public static final String GENDELIVERPLAN = "gendeliverplan";
    public static final String SELCONFIG = "selconfig";
    private static final String EXPANDKITPARENTROW = "expandKitParentRow";

    public void registerListener(EventObject e) {
        BasedataEdit priceList;
        Toolbar bar_new;
        Toolbar audit;
        BasedataEdit purorg;
        BasedataEdit supplier;
        BasedataEdit e_stockorg;
        BasedataEdit payCustomer;
        BasedataEdit settleCustmer;
        BasedataEdit reccustomer;
        BasedataEdit customer;
        BasedataEdit material;
        BasedataEdit taxrateid;
        BasedataEdit warehoudeEdit;
        BasedataEdit ownerEdit;
        Toolbar deliverToolbar;
        BasedataEdit entrySettleOrg;
        Toolbar toolbar;
        super.registerListener(e);
        EntryGrid entry = (EntryGrid)this.getControl("billentry");
        if (entry != null) {
            entry.addRowClickListener((RowClickEventListener)this);
            entry.addDataBindListener((EntryGridBindDataListener)this);
        }
        if ((toolbar = (Toolbar)this.getView().getControl("tbmainentry")) != null) {
            toolbar.addItemClickListener((ItemClickListener)this);
        }
        if ((entrySettleOrg = (BasedataEdit)this.getView().getControl("entrysettleorg")) != null) {
            entrySettleOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((deliverToolbar = (Toolbar)this.getView().getControl("tbdeliverentry")) != null) {
            deliverToolbar.addItemClickListener((ItemClickListener)this);
        }
        if ((ownerEdit = (BasedataEdit)this.getView().getControl("owner")) != null) {
            ownerEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((warehoudeEdit = (BasedataEdit)this.getView().getControl("warehouse")) != null) {
            warehoudeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((taxrateid = (BasedataEdit)this.getView().getControl("taxrateid")) != null) {
            taxrateid.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((material = (BasedataEdit)this.getView().getControl("material")) != null) {
            material.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((customer = (BasedataEdit)this.getView().getControl("customer")) != null) {
            customer.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((reccustomer = (BasedataEdit)this.getView().getControl("reccustomer")) != null) {
            reccustomer.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((settleCustmer = (BasedataEdit)this.getView().getControl("settlecustomer")) != null) {
            settleCustmer.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((payCustomer = (BasedataEdit)this.getView().getControl("payingcustomer")) != null) {
            payCustomer.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((e_stockorg = (BasedataEdit)this.getView().getControl("e_stockorg")) != null) {
            e_stockorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((supplier = (BasedataEdit)this.getView().getControl("supplier")) != null) {
            supplier.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((purorg = (BasedataEdit)this.getView().getControl("purorg")) != null) {
            purorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((audit = (Toolbar)this.getView().getControl("bar_audit")) != null) {
            audit.addItemClickListener((ItemClickListener)this);
        }
        if ((bar_new = (Toolbar)this.getView().getControl("bar_new")) != null) {
            bar_new.addItemClickListener((ItemClickListener)this);
        }
        if ((priceList = (BasedataEdit)this.getView().getControl("pricelist")) != null) {
            priceList.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billentry");
        if (entryGrid != null) {
            entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        }
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        try (TraceSpan span = Tracer.create((String)"SalesOrderPlugin", (String)"entryGridBindData");){
            if (KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) {
                this.setKitColumnEnables(e.getRows());
            }
            this.setSupplytransDefaultEntry(e.getRows());
        }
    }

    public void afterCreateNewData(EventObject e) {
        try (TraceSpan span = Tracer.create((String)"SalesOrderPlugin", (String)"afterCreateNewData");){
            String billcretype = this.getPageCache().get("billcretype");
            if (!BillImportHelper.isManual((String)billcretype)) {
                return;
            }
            SalesOrgHelper.setOwner((IDataModel)this.getModel());
            this.getModel().setValue("billcretype", (Object)"0");
            this.setOwnerTypeDefault();
            this.setSupplytransDefault();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String key = operate.getOperateKey();
        try (TraceSpan span = Tracer.create((String)"SalesOrderPlugin", (String)("beforeDoOperation: " + key));){
            if ("plan_newentry".equals(key)) {
                if (!this.isMatSelected()) {
                    args.setCancel(true);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u5b9a\u7269\u6599\u660e\u7ec6\u884c\uff0c\u518d\u65b0\u589e\u53d1\u8d27\u8ba1\u5212\u3002", (String)"SalesOrderPlugin_0", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                } else {
                    EntryGrid entry = (EntryGrid)this.getControl("billentry");
                    for (int selectRowIndex : entry.getSelectRows()) {
                        String entryChangeType = (String)this.getModel().getValue("entrychangetype", selectRowIndex);
                        if (!ChangeTypeEnum.CANCEL.getValue().equals(entryChangeType)) continue;
                        args.setCancel(true);
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7269\u6599\u660e\u7ec6\u7684\u53d8\u66f4\u65b9\u5f0f\u4e3a\u201c\u53d6\u6d88\u201d\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"SalesOrderPlugin_38", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) {
                        for (int selectRowIndex : entry.getSelectRows()) {
                            String productType = (String)this.getModel().getValue("producttype", selectRowIndex);
                            if (ProductTypeEnum.STANDARD.getValue().equals(productType)) continue;
                            args.setCancel(true);
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7684\u4ea7\u54c1\u7c7b\u522b\u4e3a\u201c\u6807\u51c6\u4ea7\u54c1\u201d\u65f6\uff0c\u624d\u5141\u8bb8\u5bf9\u53d1\u8d27\u8ba1\u5212\u5206\u5f55\u8fdb\u884c\u201c\u589e\u884c\u201d\u64cd\u4f5c\u3002", (String)"SalesOrderPlugin_30", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                            return;
                        }
                    }
                }
            } else if ("plan_deleteentry".equals(key)) {
                int materialEntryIndex;
                if (KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) {
                    materialEntryIndex = this.getModel().getEntryCurrentRowIndex("billentry");
                    if (materialEntryIndex < 0) {
                        args.setCancel(true);
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u5b9a\u7269\u6599\u660e\u7ec6\u884c\u540e\u518d\u5220\u9664\u53d1\u8d27\u8ba1\u5212\u3002", (String)"SalesOrderPlugin_32", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    String productType = (String)this.getModel().getValue("producttype", materialEntryIndex);
                    if (!ProductTypeEnum.STANDARD.getValue().equals(productType)) {
                        args.setCancel(true);
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7684\u4ea7\u54c1\u7c7b\u522b\u4e3a\u201c\u6807\u51c6\u4ea7\u54c1\u201d\u65f6\uff0c\u624d\u5141\u8bb8\u5bf9\u53d1\u8d27\u8ba1\u5212\u5206\u5f55\u8fdb\u884c\u201c\u5220\u884c\u201d\u64cd\u4f5c\u3002", (String)"SalesOrderPlugin_31", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        return;
                    }
                }
                if ((materialEntryIndex = this.getModel().getEntryCurrentRowIndex("billentry")) < 0) {
                    args.setCancel(true);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u5b9a\u7269\u6599\u660e\u7ec6\u884c\u540e\u518d\u5220\u9664\u53d1\u8d27\u8ba1\u5212\u3002", (String)"SalesOrderPlugin_32", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    return;
                }
                String entryChangeType = (String)this.getModel().getValue("entrychangetype", materialEntryIndex);
                if (ChangeTypeEnum.CANCEL.getValue().equals(entryChangeType)) {
                    args.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7269\u6599\u660e\u7ec6\u7684\u53d8\u66f4\u65b9\u5f0f\u4e3a\u201c\u53d6\u6d88\u201d\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"SalesOrderPlugin_38", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    return;
                }
            } else if ("change".equals(key)) {
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                if (org != null) {
                    Long orgId = (Long)org.getPkValue();
                    int result = PermissionServiceHelper.checkPermission((Long)Long.valueOf(RequestContext.get().getUserId()), (Long)orgId, (String)"03", (String)"sm", (String)"sm_xsalorder", (String)"47156aff000000ac");
                    if (result == 0) {
                        this.getView().showMessage(ResManager.loadKDString((String)"\u65e0\u9500\u552e\u8ba2\u5355\u53d8\u66f4\u5355\u65b0\u589e\u6743\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SalesOrderPlugin_1", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                    }
                }
            } else if ("matchamount".equals(key)) {
                DynamicObject billEntry = this.getModel().getEntryRowEntity("recplanentry", 0);
                if (billEntry == null || billEntry.getDynamicObject("r_recsettleorg") == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u6536\u6b3e\u8ba1\u5212\u5206\u5f55\u884c\u7684\u7ed3\u7b97\u7ec4\u7ec7\u540e\u518d\u5339\u914d\u9884\u6536\u6b3e\u3002", (String)"SalesOrderPlugin_23", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
            } else if ("expandkit".equals(key)) {
                Date bizDate = (Date)this.getModel().getValue("bizdate");
                if (bizDate == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u201c\u8ba2\u5355\u65e5\u671f\u201d\u5b57\u6bb5\u3002", (String)"SalesOrderPlugin_36", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
            } else {
                super.beforeDoOperation(args);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        FormOperate operate = (FormOperate)e.getSource();
        switch (operateKey) {
            case "rec_deleteentry": {
                SalOrderRecPlanHelper.reCalcuRecPlanAmount((IFormView)this.getView());
                SalOrderRecPlanHelper.changeUnRemainAmount((IDataModel)this.getModel());
                break;
            }
            case "matchamount": {
                DynamicObjectCollection recEntrys;
                DynamicObject settlecurrency;
                FormShowParameter param = new FormShowParameter();
                param.setFormId("sm_recmatch");
                param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                param.setCustomParam("wftypenumber", (Object)"HXLB_YSKPP_Recplanentry");
                param.setCustomParam("billno", this.getModel().getValue("billno"));
                DynamicObject customer = (DynamicObject)this.getModel().getValue("payingcustomer");
                if (customer != null) {
                    param.setCustomParam("customer", (Object)customer.getString("name"));
                }
                if ((settlecurrency = (DynamicObject)this.getModel().getValue("settlecurrency")) != null) {
                    param.setCustomParam("settlecurrency", (Object)settlecurrency.getString("name"));
                }
                if ((recEntrys = this.getModel().getEntryEntity("recplanentry")) != null && recEntrys.size() > 0 && ((DynamicObject)recEntrys.get(0)).getDynamicObject("r_recsettleorg") != null) {
                    param.setCustomParam("r_recsettleorg", (Object)((DynamicObject)recEntrys.get(0)).getDynamicObject("r_recsettleorg").getString("name"));
                }
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                Date bizDate = (Date)this.getModel().getValue("bizdate");
                if (bizDate != null) {
                    String formatDate = simpleDateFormat.format(bizDate);
                    param.setCustomParam("bizdate", (Object)formatDate);
                }
                this.getView().showForm(param);
                break;
            }
            case "matchrecord": {
                ListShowParameter recordParam = new ListShowParameter();
                recordParam.setBillFormId("sm_somatch");
                recordParam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                recordParam.setCustomParam("billno", this.getModel().getValue("billno"));
                this.getView().showForm((FormShowParameter)recordParam);
                break;
            }
            case "save": {
                this.setOwnerTypeEnable();
                break;
            }
            case "preinvoicing": {
                String preParam;
                OperationResult opRes = e.getOperationResult();
                if (opRes == null || !opRes.isSuccess() || StringUtils.isEmpty((Object)(preParam = operate.getOption().getVariableValue("PreOriginalParam", "")))) break;
                if ("onlytax".equals(preParam)) {
                    ArrayList<Long> srcBillIdList = new ArrayList<Long>(16);
                    for (Object pkID : opRes.getSuccessPkIds()) {
                        srcBillIdList.add((Long)pkID);
                    }
                    try {
                        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ar", (String)"AutoGenerateOriginalService", (String)"getOriginalIds", (Object[])new Object[]{srcBillIdList, "sm_salorder"});
                        if (result == null) break;
                        if (Boolean.TRUE.equals(result.get("success"))) {
                            Set originalIdSet = (Set)result.get("originalIds");
                            this.showPreInvoicingTargetBillForm("sim_original_bill", originalIdSet);
                            break;
                        }
                        String errMsg = result.get("errMsg").toString();
                        this.getView().showTipNotification(errMsg);
                    }
                    catch (KDException ke1) {
                        String ke1Msg = ExceptionUtils.getExceptionStackTraceMessage((Exception)((Object)ke1));
                        log.info("\u8c03\u7528 \u5e94\u6536 AutoGenerateOriginalService\u63a5\u53e3\u751f\u6210\u5f00\u7968\u7533\u8bf7\u5f02\u5e38\uff0c\u8fd4\u56de\u4e3a\uff1a" + ke1Msg);
                        this.getView().showTipNotification(ke1Msg);
                    }
                    catch (Exception ex1) {
                        String ex1Msg = ExceptionUtils.getExceptionStackTraceMessage((Exception)ex1);
                        log.error("\u8c03\u7528 \u5e94\u6536 AutoGenerateOriginalService\u63a5\u53e3\u751f\u6210\u5f00\u7968\u7533\u8bf7\u5f02\u5e38\uff0c\u8fd4\u56de\u4e3a\uff1a", (Object)ex1Msg);
                        this.getView().showTipNotification(ex1Msg);
                    }
                    break;
                }
                if (!"allamount".equals(preParam)) break;
                String ruleId = "1683415860846315520";
                Long billID = (Long)this.getModel().getValue("id");
                DynamicObjectCollection matEntrys1 = this.getModel().getEntryEntity("billentry");
                if (matEntrys1 == null || matEntrys1.size() <= 0) break;
                HashMap<Long, Long> sourceIdMap = new HashMap<Long, Long>(matEntrys1.size());
                for (DynamicObject row : matEntrys1) {
                    sourceIdMap.put((Long)row.getPkValue(), billID);
                }
                ReturnResultInfo rrInfo = BotpHelper.botpGenerateTargetBill(sourceIdMap, (String)ruleId, (String)"sm_salorder", (String)"billentry", (String)"ar_finarbill", (String)"save", null, (boolean)true);
                if (rrInfo.isSuccess() && rrInfo.getSuccessList() != null) {
                    List finarBillList = rrInfo.getSuccessList();
                    HashSet<Long> finarBillIdSet = new HashSet<Long>(finarBillList.size());
                    for (Object tb : finarBillList) {
                        if (tb instanceof Long) {
                            finarBillIdSet.add((Long)tb);
                            continue;
                        }
                        if (tb instanceof String) {
                            if (!kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)((String)tb))) continue;
                            finarBillIdSet.add(Long.valueOf((String)tb));
                            continue;
                        }
                        if (!(tb instanceof DynamicObject)) continue;
                        finarBillIdSet.add((Long)((DynamicObject)tb).getPkValue());
                    }
                    this.showPreInvoicingTargetBillForm("ar_finarbill", finarBillIdSet);
                    break;
                }
                String errMsg = "";
                if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)rrInfo.getMessage())) {
                    log.info("\u9500\u552e\u8ba2\u5355\u4e0b\u63a8\u8d22\u52a1\u5e94\u6536\u5355\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + rrInfo.getMessage());
                    errMsg = rrInfo.getMessage();
                } else if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)rrInfo.getDetailMessage())) {
                    log.info("\u9500\u552e\u8ba2\u5355\u4e0b\u63a8\u8d22\u52a1\u5e94\u6536\u5355\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + rrInfo.getDetailMessage());
                    errMsg = rrInfo.getDetailMessage();
                }
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u9500\u552e\u8ba2\u5355\u4e0b\u63a8\u8d22\u52a1\u5e94\u6536\u5355\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s\u3002", (String)"SalesOrderPlugin_34", (String)"scmc-sm-formplugin", (Object[])new Object[0]), errMsg));
                break;
            }
        }
    }

    private void showPreInvoicingTargetBillForm(String targetEntityKey, Set<Long> targetBillIdSet) {
        if (targetBillIdSet != null && targetBillIdSet.size() > 1) {
            ListShowParameter targetBillListParam = new ListShowParameter();
            targetBillListParam.setBillFormId(targetEntityKey);
            targetBillListParam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            targetBillListParam.getCustomParams().put("preoriginal", Boolean.TRUE);
            targetBillListParam.getListFilterParameter().getQFilters().add(new QFilter("id", "in", targetBillIdSet));
            this.getView().showForm((FormShowParameter)targetBillListParam);
        } else if (targetBillIdSet != null && targetBillIdSet.size() == 1) {
            Long targetBillId = 0L;
            Iterator<Long> iterator = targetBillIdSet.iterator();
            while (iterator.hasNext()) {
                Long tid;
                targetBillId = tid = iterator.next();
            }
            BillShowParameter targetBillEditParam = new BillShowParameter();
            targetBillEditParam.setFormId(targetEntityKey);
            targetBillEditParam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            targetBillEditParam.setPkId((Object)targetBillId);
            this.getView().showForm((FormShowParameter)targetBillEditParam);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
        switch (fieldKey) {
            case "material": 
            case "dept": 
            case "operator": 
            case "customer": 
            case "entrysettleorg": 
            case "owner": 
            case "project": 
            case "taxrateid": {
                boolean stopListener = PluginConnectControllHelper.isStopListener((IPageCache)this.getPageCache(), (String)"beforeF7Select");
                if (!stopListener) break;
                return;
            }
        }
        try (TraceSpan span = Tracer.create((String)"SalesOrderPlugin", (String)("beforeF7Select: " + e.getProperty().getName()));){
            switch (fieldKey) {
                case "e_stockorg": {
                    if (org != null) return;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalesOrderPlugin_3", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                case "material": {
                    QFilter allowMaterialQFilter;
                    if (bizType != null && "6".equals(bizType.getString("domain"))) {
                        QFilter q1 = new QFilter("masterid.enablevmi", "=", (Object)Boolean.TRUE);
                        showParameter.getListFilterParameter().setFilter(q1);
                    }
                    if ((allowMaterialQFilter = SaleDataCtrlHelper.getAllowMaterialQFilter((DynamicObject)this.getModel().getDataEntity(false))) != null) {
                        showParameter.getListFilterParameter().getQFilters().add(allowMaterialQFilter);
                    }
                    if (!KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) return;
                    int rowIndex = this.getModel().getEntryCurrentRowIndex("billentry");
                    String productType = (String)this.getModel().getValue("producttype", rowIndex);
                    if (ProductTypeEnum.KITPARENT.getValue().equals(productType)) {
                        QFilter suiteFilter = new QFilter("kittransfermodel", "!=", (Object)BLANK);
                        showParameter.getListFilterParameter().getQFilters().add(suiteFilter);
                        return;
                    }
                    if (!ProductTypeEnum.KITCHILD.getValue().equals(productType)) {
                        if (!ProductTypeEnum.STANDARD.getValue().equals(productType)) return;
                    }
                    QFilter suiteFilter = new QFilter("kittransfermodel", "=", (Object)BLANK);
                    showParameter.getListFilterParameter().getQFilters().add(suiteFilter);
                    return;
                }
                case "owner": {
                    int rowIndex = this.getModel().getEntryCurrentRowIndex("billentry");
                    if (!"bos_org".equals(this.getModel().getValue("ownertype", rowIndex))) {
                        if (!OwnerTypeEnum.SUPPLIER.getValue().equals(this.getModel().getValue("ownertype", rowIndex))) return;
                        QFilter q1 = new QFilter("enablevmi", "=", (Object)Boolean.TRUE);
                        QFilter q2 = new QFilter("status", "=", (Object)"C");
                        QFilter q3 = new QFilter("enable", "=", (Object)"1");
                        QFilter q4 = new QFilter("supplier_status.number", "=", (Object)"ZCGYS");
                        QFilter q5 = BaseDataHelper.getBaseDataFilterByOrg((String)OwnerTypeEnum.SUPPLIER.getValue(), (Long)((Long)org.getPkValue()), (boolean)false);
                        showParameter.getListFilterParameter().setQFilters(Arrays.asList(q1, q2, q3, q4, q5));
                        return;
                    }
                    DynamicObject deliverOrg = (DynamicObject)this.getModel().getValue("e_stockorg", e.getRow());
                    if (deliverOrg == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53d1\u8d27\u7ec4\u7ec7\u3002", (String)"SalesOrderPlugin_4", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        e.setCancel(true);
                        return;
                    }
                    List ownerArray = SalesOrgHelper.getAccountOrgRange((Long)((Long)deliverOrg.getPkValue()));
                    if (ownerArray != null && ownerArray.size() != 0) {
                        QFilter ownerFilter = new QFilter("id", "in", (Object)ownerArray);
                        showParameter.getListFilterParameter().setFilter(ownerFilter);
                        return;
                    }
                    QFilter ownerFilter = new QFilter("fisaccounting", "=", (Object)Boolean.TRUE);
                    showParameter.getListFilterParameter().setFilter(ownerFilter);
                    return;
                }
                case "warehouse": {
                    DynamicObject entryinvOrg = (DynamicObject)this.getModel().getValue("e_stockorg", e.getRow());
                    if (entryinvOrg == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53d1\u8d27\u7ec4\u7ec7\u3002", (String)"SalesOrderPlugin_4", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        e.setCancel(true);
                        return;
                    }
                    Long[] allWhs = (Long[])IMServiceHelper.invokeBizService((String)"InvService", (String)"getAllWarehouseIDs", (Object[])new Object[]{entryinvOrg.getString("number")});
                    showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)allWhs));
                    return;
                }
                case "customer": {
                    QFilter allowCusQFilter;
                    QFilter blockedorder = new QFilter("blockedorder", "=", (Object)"0");
                    QFilter bizfunction = new QFilter("bizfunction", "like", (Object)"%1%");
                    QFilter customerFilter = blockedorder.and(bizfunction);
                    if (bizType != null && "230".equals(bizType.getString("number"))) {
                        QFilter consignment = new QFilter("consignment", "=", (Object)Boolean.TRUE);
                        customerFilter = customerFilter.and(consignment);
                    }
                    if ((allowCusQFilter = SaleDataCtrlHelper.getAllowCustomerQFilter((DynamicObject)this.getModel().getDataEntity(false))) != null) {
                        customerFilter.and(allowCusQFilter);
                    }
                    showParameter.getListFilterParameter().getQFilters().add(customerFilter);
                    return;
                }
                case "supplier": {
                    DynamicObject purOrg = (DynamicObject)this.getModel().getValue("purorg");
                    if (purOrg == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"SalesOrderPlugin_16", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        e.setCancel(true);
                        return;
                    }
                    QFilter purchasehold = new QFilter("purchasehold", "=", (Object)Boolean.FALSE);
                    purchasehold.and(QFilter.like((String)"bizfunction", (String)"%1%"));
                    purchasehold.and(new QFilter("status", "=", (Object)"C"));
                    purchasehold.and(new QFilter("enable", "=", (Object)"1"));
                    purchasehold.and(new QFilter("supplier_status", "=", (Object)880835462149703680L));
                    QFilter supplierOrgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_supplier", (Long)((Long)purOrg.getPkValue()));
                    showParameter.getListFilterParameter().getQFilters().add(purchasehold.and(supplierOrgFilter));
                    return;
                }
                case "purorg": {
                    Boolean supplytrans = (Boolean)this.getModel().getValue("supplytrans", e.getRow());
                    if (!supplytrans.booleanValue()) {
                        return;
                    }
                    DynamicObject entrysettleorg = (DynamicObject)this.getModel().getValue("entrysettleorg", e.getRow());
                    if (entrysettleorg == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ed3\u7b97\u7ec4\u7ec7\u3002", (String)"SalesOrderPlugin_17", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        e.setCancel(true);
                        return;
                    }
                    Set orgs = SalesOrgHelper.getAllPurOrgs((Long)((Long)org.getPkValue()), (Long)((Long)entrysettleorg.getPkValue()));
                    if (orgs == null) return;
                    if (orgs.size() <= 0) return;
                    QFilter orgAll = new QFilter("id", "in", (Object)orgs);
                    showParameter.getListFilterParameter().getQFilters().add(orgAll);
                    return;
                }
                case "pricelist": {
                    DynamicObject customer = (DynamicObject)this.getModel().getValue("customer");
                    if (customer == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ba2\u8d27\u5ba2\u6237\u3002", (String)"SalesOrderPlugin_22", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        e.setCancel(true);
                        return;
                    }
                    showParameter.getListFilterParameter().setFilter(PriceListF7Helper.getPriceListFilter((DynamicObject)this.getModel().getDataEntity(true)));
                    return;
                }
            }
            return;
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "bar_logistics": {
                Long orderId = (Long)this.getModel().getValue("id");
                BillShowParameter fsp = new BillShowParameter();
                fsp.setFormId("sm_logisticsinfo");
                QFilter filter = new QFilter("id", "=", (Object)orderId);
                DynamicObject object = BusinessDataServiceHelper.loadSingle((String)"sm_logisticsinfo", (String)"id", (QFilter[])new QFilter[]{filter});
                if (object == null) {
                    fsp.setStatus(OperationStatus.ADDNEW);
                } else {
                    fsp.setStatus(OperationStatus.EDIT);
                    fsp.setPkId(object.getPkValue());
                }
                fsp.setCustomParam("id", (Object)orderId);
                fsp.setCustomParam("billno", this.getModel().getValue("billno"));
                if (fsp.getOpenStyle() != null) {
                    fsp.getOpenStyle().setShowType(ShowType.Modal);
                }
                this.getView().showForm((FormShowParameter)fsp);
                break;
            }
            case "historicalpricequery": {
                this.showHistoricalPriceRpt();
                break;
            }
            case "selconfig": {
                this.showProductConfigForm();
                break;
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent e) {
        String itemKey;
        switch (itemKey = e.getItemKey()) {
            case "rowterminate": {
                IDataModel bill = this.getModel();
                AbstractGrid entrys = (AbstractGrid)this.getControl("billentry");
                int focusRows = entrys.getEntryState().getFocusRow();
                if (focusRows == -1 || !((Boolean)bill.getValue("isvirtualbill")).booleanValue()) break;
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u4e3a\u865a\u5355\uff0c\u4e0d\u5141\u8bb8%2$s\u3002", (String)"SalesOrderPlugin_11", (String)"scmc-sm-formplugin", (Object[])new Object[0]), bill.getValue("billno"), ResManager.loadKDString((String)"\u7ec8\u6b62", (String)"SalesOrderPlugin_6", (String)"scmc-sm-formplugin", (Object[])new Object[0])));
                e.setCancel(true);
                return;
            }
            case "plan_addrow": {
                AbstractGrid entry = (AbstractGrid)this.getControl("billentry");
                int focusRow = entry.getEntryState().getFocusRow();
                if (focusRow != -1) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u660e\u7ec6\u5206\u5f55\u884c\u3002", (String)"SalesOrderPlugin_2", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            case "gendeliverplan": {
                int i;
                AbstractGrid entry1 = (AbstractGrid)this.getControl("billentry");
                int focusRow1 = entry1.getEntryState().getFocusRow();
                if (focusRow1 == -1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u660e\u7ec6\u5206\u5f55\u884c\u3002", (String)"SalesOrderPlugin_2", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                int[] selectMaterialRows = ((EntryGrid)this.getControl("billentry")).getSelectRows();
                DynamicObject dataEntity = this.getModel().getDataEntity(true);
                if (selectMaterialRows == null || selectMaterialRows.length <= 0) break;
                IDataModel model = this.getModel();
                for (int i2 = 0; i2 < selectMaterialRows.length; ++i2) {
                    int rowIndex = selectMaterialRows[i2];
                    String entryChangeType = (String)model.getValue("entrychangetype", rowIndex);
                    if (!ChangeTypeEnum.CANCEL.getValue().equals(entryChangeType)) continue;
                    String tip = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u5f53\u524d\u53d8\u66f4\u65b9\u5f0f\u4e3a\u201c\u53d6\u6d88\u201d\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"SalesOrderPlugin_37", (String)"scmc-sm-formplugin", (Object[])new Object[0]), rowIndex + 1);
                    this.getView().showTipNotification(tip);
                    e.setCancel(true);
                    return;
                }
                ArrayList<Integer> rowIndexList = new ArrayList<Integer>(16);
                for (i = 0; i < selectMaterialRows.length; ++i) {
                    int rowIndex = selectMaterialRows[i];
                    DynamicObject unit = (DynamicObject)model.getValue("unit", selectMaterialRows[i]);
                    BigDecimal qty = (BigDecimal)model.getValue("qty", selectMaterialRows[i]);
                    DynamicObject material = (DynamicObject)model.getValue("material", selectMaterialRows[i]);
                    if (unit != null && qty != null && qty.compareTo(BigDecimal.ZERO) != 0 && material != null) continue;
                    rowIndexList.add(rowIndex + 1);
                }
                if (rowIndexList.size() > 0) {
                    String errorRows = rowIndexList.stream().map(String::valueOf).collect(Collectors.joining("\u3001"));
                    String tip = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%s\u884c\u7684\u7269\u6599\u7f16\u7801\u3001\u8ba1\u91cf\u5355\u4f4d\u3001\u6570\u91cf\u5b58\u5728\u7a7a\u503c\u3002", (String)"SalesOrderPlugin_10", (String)"scmc-sm-formplugin", (Object[])new Object[0]), errorRows);
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801\u3001\u8ba1\u91cf\u5355\u4f4d\u548c\u6570\u91cf\u5b58\u5728\u7a7a\u503c\u3002", (String)"SalesOrderPlugin_8", (String)"scmc-sm-formplugin", (Object[])new Object[0]), tip, MessageBoxOptions.OK, ConfirmTypes.Default, null);
                    return;
                }
                if (KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) {
                    for (i = 0; i < selectMaterialRows.length; ++i) {
                        int rowIndex = selectMaterialRows[i];
                        String productType = (String)this.getModel().getValue("producttype", rowIndex);
                        if (ProductTypeEnum.STANDARD.getValue().equals(productType)) continue;
                        DynamicObject material = (DynamicObject)model.getValue("material", rowIndex);
                        String materialCode = KitSalesHelper.getMaterialCode((DynamicObject)material);
                        String materialName = KitSalesHelper.getMaterialName((DynamicObject)material);
                        String tip = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c%2$s\uff08%3$s\uff09\uff0c\u4ea7\u54c1\u7c7b\u522b=\u201c\u6807\u51c6\u4ea7\u54c1\u201d\uff0c\u624d\u5141\u8bb8\u751f\u6210\u53d1\u8d27\u8ba1\u5212\u3002", (String)"SalesOrderPlugin_29", (String)"scmc-sm-formplugin", (Object[])new Object[0]), rowIndex + 1, materialName, materialCode);
                        this.getView().showTipNotification(tip);
                        e.setCancel(true);
                        return;
                    }
                }
                Map<Integer, String> deliverEntryAndMaterialName = SalesOrderPlugin.getDeliverEntry(dataEntity, selectMaterialRows);
                DynamicObjectCollection billentrys = dataEntity.getDynamicObjectCollection("billentry");
                for (int i3 = 0; i3 < selectMaterialRows.length; ++i3) {
                    int rowIndex = selectMaterialRows[i3];
                    DynamicObject billentry = (DynamicObject)billentrys.get(rowIndex);
                    DynamicObjectCollection deliverEntry = billentry.getDynamicObjectCollection("orderdeliverentry");
                    if (deliverEntry == null || deliverEntry.size() <= 0) continue;
                    rowIndexList.add(rowIndex + 1);
                }
                if (deliverEntryAndMaterialName != null && rowIndexList.size() > 0) {
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(GENDELIVERPLAN, (IFormPlugin)this);
                    String errorRows = rowIndexList.stream().map(String::valueOf).collect(Collectors.joining("\u3001"));
                    String tips = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%s\u884c\u5df2\u5b58\u5728\u53d1\u8d27\u8ba1\u5212\u3002", (String)"SalesOrderPlugin_7", (String)"scmc-sm-formplugin", (Object[])new Object[0]), errorRows);
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5206\u5f55\u884c\u7269\u6599\u5df2\u7ecf\u5b58\u5728\u53d1\u8d27\u8ba1\u5212\uff0c\u662f\u5426\u91cd\u65b0\u751f\u6210\uff1f", (String)"SalesOrderPlugin_9", (String)"scmc-sm-formplugin", (Object[])new Object[0]), tips, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                    e.setCancel(true);
                    break;
                }
                this.generateDeliverPlan();
                break;
            }
            case "selconfig": {
                if (e.isCancel()) break;
                AbstractGrid billentry = (AbstractGrid)this.getControl("billentry");
                int focusEntryRow = billentry.getEntryState().getFocusRow();
                if (focusEntryRow == -1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u7269\u6599\u5206\u5f55\uff0c\u518d\u8fdb\u884c\u9009\u914d\u3002", (String)"SalesOrderPlugin_25", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                int[] selectrows = ((EntryGrid)billentry).getSelectRows();
                if (selectrows != null && selectrows.length > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u7269\u6599\u5206\u5f55\uff0c\u518d\u8fdb\u884c\u9009\u914d\u3002", (String)"SalesOrderPlugin_25", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                DynamicObject material = (DynamicObject)this.getModel().getValue("material", focusEntryRow);
                if (material == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u7269\u6599\uff0c\u518d\u8fdb\u884c\u9009\u914d\u3002", (String)"SalesOrderPlugin_26", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                if (MaterialConfigPropertiesEnum.CONFIG.getValue().equals(material.getDynamicObject("masterid").getString("configproperties"))) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u914d\u7f6e\u5c5e\u6027\u4e3a\u201c\u914d\u7f6e\u4ef6\u201d\u7684\u7269\u6599\uff0c\u518d\u8fdb\u884c\u9009\u914d\u3002", (String)"SalesOrderPlugin_27", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String key;
        super.confirmCallBack(messageBoxClosedEvent);
        switch (key = messageBoxClosedEvent.getCallBackId()) {
            case "gendeliverplan": {
                if (!"Yes".equals(messageBoxClosedEvent.getResultValue())) break;
                this.generateDeliverPlan();
                break;
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        RowDataEntity[] rowDataEntities = e.getRowDataEntities();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        try (TraceSpan span = Tracer.create((String)"SalesOrderPlugin", (String)("afterAddRow: " + entryName));){
            AbstractGrid entry;
            int focusRow;
            if ("billentry".equals(entryName)) {
                ArrayList<Integer> rowIndexList = new ArrayList<Integer>(8);
                for (RowDataEntity rowDataEntity : rowDataEntities) {
                    int rowIndex = rowDataEntity.getRowIndex();
                    rowIndexList.add(rowIndex);
                    DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
                    if (bizType != null && "6".equals(bizType.getString("domain"))) {
                        this.getModel().setValue("ownertype", (Object)OwnerTypeEnum.SUPPLIER.getValue(), rowIndex);
                        continue;
                    }
                    this.getModel().setValue("ownertype", (Object)OwnerTypeEnum.ORG.getValue(), rowIndex);
                    if (this.getModel().getValue("owner", rowIndex) != null) continue;
                    SalesOrgHelper.setOwner((int)rowIndex, (IDataModel)this.getModel(), (DynamicObject)org, (DynamicObject)rowDataEntity.getDataEntity().getDynamicObject("e_stockorg"), (IPageCache)this.getPageCache());
                }
                if (KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) {
                    this.setKitColumnEnable(rowIndexList);
                    this.setKitDeliverColumnDefault(rowIndexList);
                }
                this.setSupplytransDefaultAndEnable(rowIndexList);
            }
            if ("recplanentry".equals(entryName)) {
                if (this.getModel().getValue("ispayrate").equals(Boolean.FALSE)) {
                    this.getView().setEnable(Boolean.TRUE, -1, new String[]{"r_recadvanceamount"});
                } else {
                    this.getView().setEnable(Boolean.FALSE, -1, new String[]{"r_recadvanceamount"});
                }
                SalOrderRecPlanHelper.reCalcuRecPlanAmount((IFormView)this.getView());
                SalOrderRecPlanHelper.changeUnRemainAmount((IDataModel)this.getModel());
            } else if ("orderdeliverentry".equals(entryName) && (focusRow = (entry = (AbstractGrid)this.getControl("billentry")).getEntryState().getFocusRow()) > -1) {
                int rowIndex;
                IDataModel model = this.getModel();
                DynamicObject unit = (DynamicObject)model.getValue("unit", focusRow);
                BigDecimal qty = (BigDecimal)model.getValue("qty", focusRow);
                Date deliveryDate = (Date)model.getValue("deliverydate", focusRow);
                if (unit != null && rowDataEntities != null && rowDataEntities.length > 0 && (rowIndex = rowDataEntities[0].getRowIndex()) > -1) {
                    int entryRowCount = model.getEntryRowCount("orderdeliverentry");
                    for (int i = 0; i < entryRowCount - 1; ++i) {
                        if (rowIndex <= i || ChangeTypeEnum.CANCEL.getValue().equals(model.getValue("delentrychangetype", i))) continue;
                        BigDecimal plantQty = (BigDecimal)model.getValue("d_planqty", i);
                        qty = qty.subtract(plantQty);
                    }
                    model.setValue("d_planunit", unit.getPkValue(), rowIndex);
                    if (qty.doubleValue() < 0.0) {
                        qty = Constants.ZERO;
                    }
                    model.setValue("d_planqty", (Object)qty, rowIndex);
                    model.setValue("d_plandeliverydate", (Object)deliveryDate, rowIndex);
                    model.setValue("d_plandate", (Object)deliveryDate, rowIndex);
                    this.getModel().updateCache();
                }
            }
        }
    }

    public void initialize() {
        EntryGrid entry = (EntryGrid)this.getControl("billentry");
        if (entry != null) {
            entry.addDataBindListener((EntryGridBindDataListener)this);
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        this.getView().updateView("billentry");
    }

    public void entryRowClick(RowClickEvent e) {
        IDataModel model;
        DynamicObject unit;
        Control c = (Control)e.getSource();
        int row = e.getRow();
        String key = c.getKey();
        if (row > -1 && "billentry".equals(key) && (unit = (DynamicObject)(model = this.getModel()).getValue("unit", row)) != null) {
            int entryRowCount = model.getEntryRowCount("orderdeliverentry");
            for (int i = 0; i < entryRowCount; ++i) {
                model.setValue("d_planunit", unit.getPkValue(), i);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        try (TraceSpan span = Tracer.create((String)"SalesOrderPlugin", (String)"afterBindData");){
            Boolean enablexssalorderbill;
            this.changeIsPayRate(this.getModel().getValue("ispayrate"));
            this.quotaDrawChangeCus();
            if (!"1".equals(this.getPageCache().get("inputamount"))) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"inputamount"});
            }
            if ((enablexssalorderbill = (Boolean)BillParameterHelper.getSalesOrderParameter((String)"enablexssalorderbill")).booleanValue()) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"bizchange"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_change"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_bizchangeresume"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bizchange"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_change"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_bizchangeresume"});
            }
            this.setOwnerTypeEnable();
            this.setSupplytransDefault();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void propertyChanged(PropertyChangedArgs e) {
        String billcretype = this.getPageCache().get("billcretype");
        if (!BillImportHelper.isManual((String)billcretype)) {
            return;
        }
        if (PropertyChangeHelper.isStopPropertyChange((IPageCache)this.getPageCache())) {
            return;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        try (TraceSpan span = Tracer.create((String)"SalesOrderPlugin", (String)("propertyChanged: " + e.getProperty().getName()));){
            String fieldKey = e.getProperty().getName();
            ChangeData[] changeSet = e.getChangeSet();
            Object newValue = changeSet[0].getNewValue();
            switch (fieldKey) {
                case "totalallamount": {
                    if (!CommonUtils.isRealChanged((ChangeData)changeSet[0])) return;
                    SalOrderRecPlanHelper.reCalcuRecPlanAmount((IFormView)this.getView());
                    SalOrderRecPlanHelper.changeUnRemainAmount((IDataModel)this.getModel());
                    return;
                }
                case "reccondition": {
                    if (!CommonUtils.isRealChanged((ChangeData)changeSet[0])) return;
                    SalOrderRecPlanHelper.reCalcuRecPlanAmountByContion((IFormView)this.getView());
                    SalOrderRecPlanHelper.changeUnRemainAmount((IDataModel)this.getModel());
                    this.setRecChangeLineEnable();
                    return;
                }
                case "ispayrate": {
                    if (!CommonUtils.isRealChanged((ChangeData)changeSet[0])) return;
                    this.changeIsPayRate(newValue);
                    return;
                }
                case "r_recadvancerate": {
                    int i = 0;
                    while (i < changeSet.length) {
                        if (CommonUtils.isRealChanged((ChangeData)changeSet[i])) {
                            SalOrderRecPlanHelper.reCalcuRecPlanAmount((IFormView)this.getView());
                            SalOrderRecPlanHelper.changeUnRemainAmount((IDataModel)this.getModel());
                        }
                        ++i;
                    }
                    return;
                }
                case "r_recadvanceamount": {
                    int i = 0;
                    while (i < changeSet.length) {
                        if (CommonUtils.isRealChanged((ChangeData)changeSet[i])) {
                            SalOrderRecPlanHelper.reCalcuRecPlanAmount((IFormView)this.getView());
                            int rowIndex1 = changeSet[i].getRowIndex();
                            BigDecimal needRemainAmount = this.getModel().getValue("r_remainamount", rowIndex1) == null ? BigDecimal.ZERO : (BigDecimal)this.getModel().getValue("r_remainamount", rowIndex1);
                            this.getModel().setValue("r_unremainamount", (Object)((BigDecimal)newValue).subtract(needRemainAmount), rowIndex1);
                        }
                        ++i;
                    }
                    return;
                }
                case "r_needrecadvance": {
                    int i = 0;
                    while (i < changeSet.length) {
                        if (CommonUtils.isRealChanged((ChangeData)changeSet[i])) {
                            int rowIndex1 = changeSet[i].getRowIndex();
                            if (changeSet[i].getNewValue() instanceof Boolean && !changeSet[i].getNewValue().equals(Boolean.TRUE)) {
                                this.getModel().setValue("r_relbillno", null, rowIndex1);
                            }
                        }
                        ++i;
                    }
                    return;
                }
                case "d_plandate": {
                    int i = 0;
                    while (i < changeSet.length) {
                        if (CommonUtils.isRealChanged((ChangeData)changeSet[i])) {
                            int rowIndex1 = changeSet[i].getRowIndex();
                            this.getModel().setValue("d_plandeliverydate", changeSet[i].getNewValue(), rowIndex1);
                        }
                        ++i;
                    }
                    return;
                }
                case "e_stockorg": {
                    ArrayList<RowDataEntity> rows = new ArrayList<RowDataEntity>();
                    int i = 0;
                    while (true) {
                        if (i >= changeSet.length) {
                            LotCacheHelper.setLotEnable(rows, (IFormView)this.getView(), (IPageCache)this.getPageCache());
                            return;
                        }
                        if (CommonUtils.isRealChanged((ChangeData)changeSet[i])) {
                            RowDataEntity rowDataEntity = new RowDataEntity(changeSet[i].getRowIndex(), this.getModel().getEntryRowEntity("billentry", changeSet[i].getRowIndex()));
                            rows.add(rowDataEntity);
                            this.getModel().setValue("warehouse", null, changeSet[i].getRowIndex());
                            DynamicObject stock = (DynamicObject)this.getModel().getValue("e_stockorg", changeSet[i].getRowIndex());
                            SalesOrgHelper.setOwner((int)changeSet[i].getRowIndex(), (IDataModel)this.getModel(), (DynamicObject)org, (DynamicObject)stock, (IPageCache)this.getPageCache());
                            if (KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) {
                                int parentRowIndex = changeSet[i].getRowIndex();
                                String productType = (String)this.getModel().getValue("producttype", parentRowIndex);
                                if (ProductTypeEnum.KITPARENT.getValue().equals(productType)) {
                                    List<Integer> childIndexList = this.getAllChildEntry(parentRowIndex);
                                    this.setKitDeliverColumnValue(childIndexList, parentRowIndex, "e_stockorg");
                                }
                            }
                        }
                        ++i;
                    }
                }
                case "entrysettleorg": {
                    int i = 0;
                    while (i < changeSet.length) {
                        if (CommonUtils.isRealChanged((ChangeData)changeSet[i])) {
                            Boolean supplytrans = (Boolean)this.getModel().getValue("supplytrans", changeSet[i].getRowIndex());
                            if (fieldKey.equals("entrysettleorg") && supplytrans.booleanValue()) {
                                this.getModel().setValue("purorg", (Object)"", changeSet[i].getRowIndex());
                            }
                        }
                        ++i;
                    }
                    return;
                }
                case "ownertype": {
                    int i = 0;
                    while (i < changeSet.length) {
                        if (changeSet[i].getNewValue() == null || "".equals(changeSet[i].getNewValue())) {
                            PropertyChangeHelper.stopPropertyChange((IPageCache)this.getPageCache());
                            this.getModel().setValue("ownertype", changeSet[i].getOldValue(), changeSet[i].getRowIndex());
                            PropertyChangeHelper.releasePropertyChange((IPageCache)this.getPageCache());
                        } else {
                            this.getModel().setValue("owner", null, changeSet[i].getRowIndex());
                            if (OwnerTypeEnum.SUPPLIER.getValue().equals(changeSet[i].getNewValue())) {
                                this.getModel().setValue("supplytrans", (Object)Boolean.FALSE, changeSet[i].getRowIndex());
                                this.getView().setEnable(Boolean.FALSE, changeSet[i].getRowIndex(), new String[]{"supplytrans"});
                            } else {
                                this.getView().setEnable(Boolean.TRUE, changeSet[i].getRowIndex(), new String[]{"supplytrans"});
                            }
                        }
                        ++i;
                    }
                    return;
                }
                case "billtype": 
                case "biztype": 
                case "org": {
                    this.setOwnerTypeDefault();
                    this.setOwnerTypeEnable();
                    return;
                }
                case "material": {
                    int i = 0;
                    while (i < changeSet.length) {
                        DynamicObjectCollection salOrderEntryDeliver;
                        ChangeData changeData = changeSet[i];
                        DynamicObject dataEntity = changeData.getDataEntity();
                        if (changeSet[i].getNewValue() != null) {
                            DynamicObject material = (DynamicObject)changeSet[i].getNewValue();
                            boolean iscontrolday = material.getBoolean("iscontrolday");
                            int row = changeSet[i].getRowIndex();
                            if (iscontrolday) {
                                int deliveradvanceddays = material.getInt("deliveradvdays");
                                int deliverdelaydays = material.getInt("deliverdelaydays");
                                this.getModel().setValue("iscontrolday", (Object)Boolean.TRUE, row);
                                this.getModel().setValue("deliveradvdays", (Object)deliveradvanceddays, row);
                                this.getModel().setValue("deliverdelaydays", (Object)deliverdelaydays, row);
                            } else {
                                this.getModel().setValue("iscontrolday", (Object)Boolean.FALSE, row);
                                this.getModel().setValue("deliveradvdays", (Object)0, row);
                                this.getModel().setValue("deliverdelaydays", (Object)0, row);
                            }
                        }
                        if ((salOrderEntryDeliver = (DynamicObjectCollection)dataEntity.get("orderdeliverentry")) != null) {
                            for (DynamicObject entry : salOrderEntryDeliver) {
                                entry.set("d_planunit", (Object)dataEntity.getDynamicObject("unit"));
                            }
                            this.getView().updateView("orderdeliverentry");
                        }
                        if (CommonUtils.isRealChanged((ChangeData)changeSet[i])) {
                            int row = changeSet[i].getRowIndex();
                            Object newvalue = changeSet[i].getNewValue();
                            this.changeMaterial(newvalue, row);
                            this.getModel().setValue("deliverqtydown", null, row);
                            this.getModel().setValue("deliverqtyup", null, row);
                            this.getModel().setValue("deliverbaseqtydown", null, row);
                            this.getModel().setValue("deliverbaseqtyup", null, row);
                            if (changeSet[i].getNewValue() != null) {
                                DynamicObject material = (DynamicObject)changeSet[i].getNewValue();
                                boolean isControlQty = material.getBoolean("iscontrolqty");
                                this.getModel().setValue("iscontrolqty", (Object)isControlQty, row);
                                if (isControlQty) {
                                    BigDecimal delieveRateUp = material.getBigDecimal("dlivrateceiling");
                                    BigDecimal delieveRateDown = material.getBigDecimal("dlivratefloor");
                                    this.getModel().setValue("deliverrateup", (Object)delieveRateUp, row);
                                    this.getModel().setValue("deliverratedown", (Object)delieveRateDown, row);
                                }
                            }
                            this.getModel().setValue("minorderbaseqty", (Object)BigDecimal.ZERO, row);
                            this.getModel().setValue("supplytrans", (Object)Boolean.FALSE, row);
                            this.getModel().setValue("purorg", null, row);
                            this.getModel().setValue("supplier", null, row);
                            if (KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) {
                                this.setOneKitColumnEnable(row);
                                this.setKitDeliverColumnDefault(Collections.singletonList(row));
                            }
                        }
                        ++i;
                    }
                    return;
                }
                case "qty": 
                case "auxqty": {
                    ArrayList<RowDataEntity> rows_1 = new ArrayList<RowDataEntity>();
                    int i = 0;
                    while (true) {
                        if (i >= changeSet.length) {
                            LotCacheHelper.setLotEnable(rows_1, (IFormView)this.getView(), (IPageCache)this.getPageCache());
                            return;
                        }
                        if (CommonUtils.isRealChanged((ChangeData)changeSet[i])) {
                            int row = changeSet[i].getRowIndex();
                            if ("sm_salorder".equals(this.getModel().getDataEntityType().getName()) || ChangeTypeEnum.ADDNEW.getValue().equals(this.getModel().getValue("entrychangetype", row))) {
                                RowDataEntity rowDataEntity;
                                BigDecimal newQty = (BigDecimal)changeSet[i].getNewValue();
                                BigDecimal oldQty = (BigDecimal)changeSet[i].getOldValue();
                                if (newQty == null) {
                                    newQty = BigDecimal.ZERO;
                                }
                                if (oldQty == null) {
                                    oldQty = BigDecimal.ZERO;
                                }
                                if (BigDecimal.ZERO.compareTo(newQty) == 0) {
                                    rowDataEntity = new RowDataEntity(row, this.getModel().getEntryRowEntity("billentry", row));
                                    rows_1.add(rowDataEntity);
                                } else if (BigDecimal.ZERO.compareTo(oldQty) == 0) {
                                    rowDataEntity = new RowDataEntity(row, this.getModel().getEntryRowEntity("billentry", row));
                                    rows_1.add(rowDataEntity);
                                }
                            }
                            this.deliverUpAndDownCalc(row);
                            this.calcMinOrderBaseQty(row);
                            if (KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) {
                                this.calcChildRowQty(row);
                            }
                        }
                        ++i;
                    }
                }
                case "deliverrateup": 
                case "deliverratedown": {
                    int i = 0;
                    while (i < changeSet.length) {
                        if (CommonUtils.isRealChanged((ChangeData)changeSet[i])) {
                            int row = changeSet[i].getRowIndex();
                            this.deliverUpAndDownCalc(row);
                            if (KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) {
                                int parentRowIndex = changeSet[i].getRowIndex();
                                String productType = (String)this.getModel().getValue("producttype", parentRowIndex);
                                if (ProductTypeEnum.KITPARENT.getValue().equals(productType)) {
                                    List<Integer> childIndexList = this.getAllChildEntry(parentRowIndex);
                                    this.setKitDeliverColumnValue(childIndexList, parentRowIndex, fieldKey);
                                }
                            }
                        }
                        ++i;
                    }
                    return;
                }
                case "iscontrolqty": {
                    this.changeIsControlQty(changeSet);
                    if (!KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) return;
                    int i = 0;
                    while (i < changeSet.length) {
                        int parentRowIndex = changeSet[i].getRowIndex();
                        String productType = (String)this.getModel().getValue("producttype", parentRowIndex);
                        if (ProductTypeEnum.KITPARENT.getValue().equals(productType)) {
                            List<Integer> childIndexList = this.getAllChildEntry(parentRowIndex);
                            this.setKitDeliverColumnValue(childIndexList, parentRowIndex, "iscontrolqty");
                        }
                        ++i;
                    }
                    return;
                }
                case "istax": {
                    EntryGrid entry = (EntryGrid)this.getControl("billentry");
                    if (entry != null) {
                        entry.addDataBindListener((EntryGridBindDataListener)this);
                    }
                    this.changeIsTax();
                    this.doRefresh(null);
                    return;
                }
                case "unit": {
                    int i = 0;
                    while (i < changeSet.length) {
                        if (CommonUtils.isRealChanged((ChangeData)changeSet[i])) {
                            DynamicObject dataEntity = changeSet[i].getDataEntity();
                            this.changeDeliverUnit(dataEntity);
                            this.changeDeliverQty(dataEntity);
                            int row = changeSet[i].getRowIndex();
                            this.deliverUpAndDownCalc(row);
                            if (KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) {
                                this.calcChildRowQty(row);
                            }
                        }
                        ++i;
                    }
                    return;
                }
                case "iscontrolday": {
                    if (KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) {
                        int parentRowIndex = changeSet[0].getRowIndex();
                        String productType = (String)this.getModel().getValue("producttype", parentRowIndex);
                        if (ProductTypeEnum.KITPARENT.getValue().equals(productType)) {
                            List<Integer> childIndexList = this.getAllChildEntry(parentRowIndex);
                            this.setKitDeliverColumnValue(childIndexList, parentRowIndex, "iscontrolday");
                            this.setKitDeliverColumnValue(childIndexList, parentRowIndex, "deliveradvdays");
                            this.setKitDeliverColumnValue(childIndexList, parentRowIndex, "deliverdelaydays");
                        }
                    }
                    if (!(changeSet[0].getNewValue() instanceof Boolean)) return;
                    if (changeSet[0].getNewValue().equals(Boolean.FALSE)) {
                        this.getModel().setValue("deliveradvdays", null, changeSet[0].getRowIndex());
                        this.getModel().setValue("deliverdelaydays", null, changeSet[0].getRowIndex());
                        return;
                    }
                    if (!CommonUtils.isRealChanged((ChangeData)changeSet[0])) return;
                    String productType = (String)this.getModel().getValue("producttype", changeSet[0].getRowIndex());
                    if (KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName()) && ProductTypeEnum.KITCHILD.getValue().equals(productType)) {
                        DynamicObject parentEntry = this.getParentEntry(changeSet[0].getRowIndex());
                        if (parentEntry == null) return;
                        this.getModel().setValue("deliveradvdays", (Object)parentEntry.getInt("deliveradvdays"), changeSet[0].getRowIndex());
                        this.getModel().setValue("deliverdelaydays", (Object)parentEntry.getInt("deliverdelaydays"), changeSet[0].getRowIndex());
                        return;
                    }
                    DynamicObject material = (DynamicObject)this.getModel().getValue("material", changeSet[0].getRowIndex());
                    if (material == null) return;
                    int deliveradvanceddays = material.getInt("deliveradvdays");
                    int deliverdelaydays = material.getInt("deliverdelaydays");
                    this.getModel().setValue("deliveradvdays", (Object)deliveradvanceddays, changeSet[0].getRowIndex());
                    this.getModel().setValue("deliverdelaydays", (Object)deliverdelaydays, changeSet[0].getRowIndex());
                    return;
                }
                case "supplier": {
                    int i = 0;
                    while (i < changeSet.length) {
                        if (CommonUtils.isRealChanged((ChangeData)changeSet[i]) && KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) {
                            int parentRowIndex = changeSet[i].getRowIndex();
                            String productType = (String)this.getModel().getValue("producttype", parentRowIndex);
                            if (ProductTypeEnum.KITPARENT.getValue().equals(productType)) {
                                List<Integer> childIndexList = this.getAllChildEntry(parentRowIndex);
                                this.setKitDeliverColumnValue(childIndexList, parentRowIndex, "supplier");
                            }
                        }
                        ++i;
                    }
                    return;
                }
                case "purorg": {
                    int i = 0;
                    while (i < changeSet.length) {
                        if (CommonUtils.isRealChanged((ChangeData)changeSet[i])) {
                            this.getModel().setValue("supplier", null, changeSet[i].getRowIndex());
                            if (KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) {
                                int parentRowIndex = changeSet[i].getRowIndex();
                                String productType = (String)this.getModel().getValue("producttype", parentRowIndex);
                                if (ProductTypeEnum.KITPARENT.getValue().equals(productType)) {
                                    List<Integer> childIndexList = this.getAllChildEntry(parentRowIndex);
                                    this.setKitDeliverColumnValue(childIndexList, parentRowIndex, "purorg");
                                }
                            }
                        }
                        ++i;
                    }
                    return;
                }
                case "supplytrans": {
                    int i = 0;
                    while (i < changeSet.length) {
                        if (CommonUtils.isRealChanged((ChangeData)changeSet[i])) {
                            Boolean supplytrans;
                            if (changeSet[i].getNewValue() instanceof Boolean && (supplytrans = (Boolean)changeSet[i].getNewValue()).booleanValue()) {
                                this.getModel().setValue("purorg", null, changeSet[i].getRowIndex());
                            }
                            if (KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) {
                                int parentRowIndex = changeSet[i].getRowIndex();
                                String productType = (String)this.getModel().getValue("producttype", parentRowIndex);
                                if (ProductTypeEnum.KITPARENT.getValue().equals(productType)) {
                                    List<Integer> childIndexList = this.getAllChildEntry(parentRowIndex);
                                    this.setKitDeliverColumnValue(childIndexList, parentRowIndex, "supplytrans");
                                }
                            }
                        }
                        ++i;
                    }
                    return;
                }
                case "settlecurrency": {
                    if (!CommonUtils.isRealChanged((ChangeData)changeSet[0])) return;
                    SalOrderRecPlanHelper.reCalcuRecAmountByCurrency((IDataModel)this.getModel());
                    SalOrderRecPlanHelper.reCalcuRecPlanAmount((IFormView)this.getView());
                    SalOrderRecPlanHelper.changeUnRemainAmount((IDataModel)this.getModel());
                    return;
                }
                case "customer": {
                    this.getModel().setValue("pricelist", null);
                    return;
                }
                case "kittransfermodel": {
                    if (!KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) return;
                    int i = 0;
                    while (i < changeSet.length) {
                        if (CommonUtils.isRealChanged((ChangeData)changeSet[i])) {
                            int parentRowIndex = changeSet[i].getRowIndex();
                            String productType = (String)this.getModel().getValue("producttype", parentRowIndex);
                            if (ProductTypeEnum.KITPARENT.getValue().equals(productType)) {
                                List<Integer> childIndexList = this.getAllChildEntry(parentRowIndex);
                                String entityId = this.getView().getEntityId();
                                if ("sm_xsalorder".equals(entityId) || "sm_xssalorder".equals(entityId)) {
                                    boolean isCanChange = true;
                                    BigDecimal parentAssociatedBaseQty = (BigDecimal)this.getModel().getValue("associatedbaseqty", parentRowIndex);
                                    BigDecimal parentBaseBackQty = (BigDecimal)this.getModel().getValue("basebackqty", parentRowIndex);
                                    if (parentAssociatedBaseQty.compareTo(BigDecimal.ZERO) != 0 || parentAssociatedBaseQty.compareTo(BigDecimal.ZERO) == 0 && parentBaseBackQty.compareTo(BigDecimal.ZERO) != 0) {
                                        isCanChange = false;
                                    }
                                    for (Integer childIndex : childIndexList) {
                                        BigDecimal childAssociatedBaseQty = (BigDecimal)this.getModel().getValue("associatedbaseqty", childIndex.intValue());
                                        BigDecimal childBaseBackQty = (BigDecimal)this.getModel().getValue("basebackqty", childIndex.intValue());
                                        if (childAssociatedBaseQty.compareTo(BigDecimal.ZERO) == 0 && (childAssociatedBaseQty.compareTo(BigDecimal.ZERO) != 0 || childBaseBackQty.compareTo(BigDecimal.ZERO) == 0)) continue;
                                        isCanChange = false;
                                        break;
                                    }
                                    if (!isCanChange) {
                                        return;
                                    }
                                }
                                String kitTransferModel = changeSet[i].getNewValue() == null ? null : changeSet[i].getNewValue().toString();
                                this.setChildDeliverColumnEnable(childIndexList, kitTransferModel);
                                this.setKitDeliverColumnDefault(childIndexList, parentRowIndex);
                            }
                        }
                        ++i;
                    }
                    return;
                }
                case "deliverydate": {
                    if (!KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) return;
                    int i = 0;
                    while (i < changeSet.length) {
                        if (CommonUtils.isRealChanged((ChangeData)changeSet[i])) {
                            int parentRowIndex = changeSet[i].getRowIndex();
                            String productType = (String)this.getModel().getValue("producttype", parentRowIndex);
                            if (ProductTypeEnum.KITPARENT.getValue().equals(productType)) {
                                List<Integer> childIndexList = this.getAllChildEntry(parentRowIndex);
                                this.setKitDeliverColumnValue(childIndexList, parentRowIndex, "deliverydate");
                            }
                        }
                        ++i;
                    }
                    return;
                }
                case "deliveradvdays": 
                case "deliverdelaydays": {
                    if (!KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) return;
                    int i = 0;
                    while (i < changeSet.length) {
                        if (CommonUtils.isRealChanged((ChangeData)changeSet[i])) {
                            int parentRowIndex = changeSet[i].getRowIndex();
                            String productType = (String)this.getModel().getValue("producttype", parentRowIndex);
                            if (ProductTypeEnum.KITPARENT.getValue().equals(productType)) {
                                List<Integer> childIndexList = this.getAllChildEntry(parentRowIndex);
                                this.setKitDeliverColumnValue(childIndexList, parentRowIndex, fieldKey);
                                this.setKitDeliverColumnValue(childIndexList, parentRowIndex, "iscontrolday");
                            }
                        }
                        ++i;
                    }
                    return;
                }
                case "producttype": {
                    if (!KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) return;
                    int i = 0;
                    while (i < changeSet.length) {
                        if (CommonUtils.isRealChanged((ChangeData)changeSet[i])) {
                            DynamicObject lineType;
                            String productType;
                            if (ProductTypeEnum.KITPARENT.getValue().equals(changeSet[i].getNewValue())) {
                                this.getModel().deleteEntryData("orderdeliverentry");
                                this.getModel().setValue("supplytrans", (Object)Boolean.FALSE, changeSet[i].getRowIndex());
                            }
                            if (!StringUtils.isEmpty((Object)(productType = (String)changeSet[i].getNewValue())) && ProductTypeEnum.STANDARD.getValue().equals(productType) && (lineType = (DynamicObject)this.getModel().getValue("linetype", changeSet[i].getRowIndex())) != null) {
                                Boolean storageout = lineType.getBoolean("storageout");
                                if (!storageout.booleanValue()) {
                                    this.getView().setEnable(Boolean.FALSE, changeSet[i].getRowIndex(), new String[]{"supplytrans"});
                                    this.getModel().setValue("supplytrans", (Object)Boolean.FALSE, changeSet[i].getRowIndex());
                                } else {
                                    this.getView().setEnable(Boolean.TRUE, changeSet[i].getRowIndex(), new String[]{"supplytrans"});
                                }
                            }
                        }
                        ++i;
                    }
                    return;
                }
                case "linetype": {
                    int i = 0;
                    while (i < changeSet.length) {
                        if (CommonUtils.isRealChanged((ChangeData)changeSet[i]) && newValue != null) {
                            DynamicObject lineType = (DynamicObject)newValue;
                            if (lineType != null && !lineType.getBoolean("storageout")) {
                                this.getView().setEnable(Boolean.FALSE, changeSet[i].getRowIndex(), new String[]{"supplytrans"});
                            } else {
                                this.getView().setEnable(Boolean.TRUE, changeSet[i].getRowIndex(), new String[]{"supplytrans"});
                            }
                        }
                        ++i;
                    }
                    return;
                }
            }
            return;
        }
    }

    private void changeIsControlQty(ChangeData[] changeSet) {
        for (int i = 0; i < changeSet.length; ++i) {
            ChangeData changeData = changeSet[i];
            Object newValue = changeData.getNewValue();
            int rowIndex = changeData.getRowIndex();
            IDataModel model = this.getModel();
            if (!(newValue instanceof Boolean)) continue;
            boolean isControlQty = (Boolean)newValue;
            if (isControlQty) {
                String productType = (String)model.getValue("producttype", rowIndex);
                if (KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)model.getDataEntityType().getName()) && ProductTypeEnum.KITCHILD.getValue().equals(productType)) {
                    DynamicObject parentEntry = this.getParentEntry(rowIndex);
                    if (parentEntry == null) continue;
                    model.setValue("deliverrateup", (Object)parentEntry.getBigDecimal("deliverrateup"), rowIndex);
                    model.setValue("deliverratedown", (Object)parentEntry.getBigDecimal("deliverratedown"), rowIndex);
                    continue;
                }
                DynamicObject material = (DynamicObject)model.getValue("material", rowIndex);
                if (material != null) {
                    BigDecimal receiveRateUp = material.getBigDecimal("dlivrateceiling");
                    BigDecimal receiveRateDown = material.getBigDecimal("dlivratefloor");
                    model.setValue("deliverrateup", (Object)receiveRateUp, rowIndex);
                    model.setValue("deliverratedown", (Object)receiveRateDown, rowIndex);
                    continue;
                }
                model.setValue("deliverrateup", (Object)ZERO, rowIndex);
                model.setValue("deliverratedown", (Object)ZERO, rowIndex);
                continue;
            }
            model.setValue("deliverrateup", (Object)ZERO, rowIndex);
            model.setValue("deliverratedown", (Object)ZERO, rowIndex);
        }
    }

    private void changeIsPayRate(Object newValue) {
        if (newValue instanceof Boolean) {
            boolean isPayRate = (Boolean)newValue;
            if (isPayRate) {
                this.getView().setEnable(Boolean.FALSE, -1, new String[]{"r_recadvanceamount"});
                this.getView().setEnable(Boolean.TRUE, -1, new String[]{"r_recadvancerate"});
            } else {
                this.getView().setEnable(Boolean.TRUE, -1, new String[]{"r_recadvanceamount"});
                this.getView().setEnable(Boolean.FALSE, -1, new String[]{"r_recadvancerate"});
            }
        }
    }

    private void changeIsTax() {
        boolean isTax = (Boolean)this.getModel().getValue("istax");
        if (!"1".equals(this.getPageCache().get("inputamount"))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"inputamount"});
        } else {
            Boolean inputamount = (Boolean)this.getModel().getValue("inputamount");
            if (isTax && !inputamount.booleanValue()) {
                this.getView().setEnable(Boolean.TRUE, -1, new String[]{"priceandtax"});
                this.getView().setEnable(Boolean.FALSE, -1, new String[]{"price"});
            } else if (!isTax && !inputamount.booleanValue()) {
                this.getView().setEnable(Boolean.FALSE, -1, new String[]{"priceandtax"});
                this.getView().setEnable(Boolean.TRUE, -1, new String[]{"price"});
            }
        }
    }

    private boolean isMatSelected() {
        return this.getModel().getEntryCurrentRowIndex("billentry") >= 0;
    }

    private void changeMaterial(Object newValue, int rowIndex) {
        if (newValue != null && this.getModel().getValue("taxrateid", rowIndex) != null) {
            String[] taxrateIds;
            DynamicObject taxrate = (DynamicObject)this.getModel().getValue("taxrateid", rowIndex);
            String taxrate_filter = this.getPageCache().get(TAXRATE_FILTER);
            if (kd.bos.util.StringUtils.isNotEmpty((String)taxrate_filter) && taxrate_filter.length() > 1 && (taxrateIds = (taxrate_filter = taxrate_filter.substring(1, taxrate_filter.length() - 1)).split("_")).length > 0 && !Arrays.asList(taxrateIds).contains(taxrate.getPkValue().toString())) {
                this.getModel().beginInit();
                this.getModel().setValue("taxrateid", null, rowIndex);
                this.getModel().setValue("taxrate", null, rowIndex);
                this.getModel().endInit();
                this.getView().updateView("taxrateid", rowIndex);
                this.getView().updateView("taxrate", rowIndex);
            }
        }
    }

    private void deliverUpAndDownCalc(int row) {
        BigDecimal qty = (BigDecimal)this.getModel().getValue("qty", row);
        BigDecimal baseQty = (BigDecimal)this.getModel().getValue("baseqty", row);
        DynamicObject baseUnit = (DynamicObject)this.getModel().getValue("baseunit", row);
        DynamicObject unit = (DynamicObject)this.getModel().getValue("unit", row);
        if (unit == null || baseUnit == null) {
            this.getModel().setValue("deliverqtyup", null, row);
            this.getModel().setValue("deliverbaseqtyup", null, row);
            this.getModel().setValue("deliverqtydown", null, row);
            this.getModel().setValue("deliverbaseqtydown", null, row);
            return;
        }
        int precision = unit.getInt("precision");
        int precisionaccount = BillTplHelper.getRoundMode((DynamicObject)unit);
        int basePrecision = baseUnit.getInt("precision");
        int basePrecisionaccount = BillTplHelper.getRoundMode((DynamicObject)baseUnit);
        BigDecimal deliverrateup = (BigDecimal)this.getModel().getValue("deliverrateup", row);
        BigDecimal deliverratedown = (BigDecimal)this.getModel().getValue("deliverratedown", row);
        BigDecimal deliverqtyup = qty.multiply(new BigDecimal(100).add(deliverrateup)).divide(new BigDecimal(100), precision, precisionaccount);
        BigDecimal deliverbaseqtyup = baseQty.multiply(new BigDecimal(100).add(deliverrateup)).divide(new BigDecimal(100), basePrecision, basePrecisionaccount);
        BigDecimal deliverqtydown = qty.multiply(new BigDecimal(100).subtract(deliverratedown)).divide(new BigDecimal(100), precision, precisionaccount);
        BigDecimal deliverbaseqtydown = baseQty.multiply(new BigDecimal(100).subtract(deliverratedown)).divide(new BigDecimal(100), basePrecision, basePrecisionaccount);
        this.getModel().setValue("deliverqtyup", (Object)deliverqtyup, row);
        this.getModel().setValue("deliverbaseqtyup", (Object)deliverbaseqtyup, row);
        this.getModel().setValue("deliverqtydown", (Object)deliverqtydown, row);
        this.getModel().setValue("deliverbaseqtydown", (Object)deliverbaseqtydown, row);
    }

    private void calcMinOrderBaseQty(int row) {
        BigDecimal minOrderBaseQty = BigDecimal.ZERO;
        DynamicObject masterMat = (DynamicObject)this.getModel().getValue("material", row);
        if (masterMat != null) {
            BigDecimal minOrderQty = masterMat.getBigDecimal("minorderqty");
            DynamicObject salesUnit = masterMat.getDynamicObject("salesunit");
            DynamicObject baseUnit = (DynamicObject)this.getModel().getValue("baseunit", row);
            if (baseUnit != null && salesUnit != null && minOrderQty != null && BigDecimal.ZERO.compareTo(minOrderQty) != 0) {
                minOrderBaseQty = BillTplHelper.getDesQtyConv((DynamicObject)masterMat.getDynamicObject("masterid"), (DynamicObject)salesUnit, (BigDecimal)minOrderQty, (DynamicObject)baseUnit);
            }
        }
        this.getModel().setValue("minorderbaseqty", (Object)minOrderBaseQty, row);
    }

    private void doRefresh(int[] selectRows) {
        boolean batchRefresh = false;
        if (selectRows == null) {
            this.getView().updateView("billentry");
        } else {
            if (selectRows.length > BigDecimal.TEN.intValue()) {
                batchRefresh = true;
            }
            if (batchRefresh) {
                this.getView().updateView("billentry");
            } else {
                String[] propNames = BillTplHelper.getEntryRefreshFields((String)"quote");
                if (propNames == null) {
                    return;
                }
                for (int i = 0; i < selectRows.length; ++i) {
                    for (String prop : propNames) {
                        this.getView().updateView(prop, selectRows[i]);
                    }
                }
            }
        }
    }

    private void doRefreshHeadAmount() {
        this.getView().updateView("totalallamount");
        this.getView().updateView("totaltaxamount");
        this.getView().updateView("totalamount");
        this.getView().updateView("curtotalallamount");
        this.getView().updateView("curtotaltaxamount");
        this.getView().updateView("curtotalamount");
    }

    public static Map<Integer, String> getDeliverEntry(DynamicObject dataEntity, int[] selectRows) {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        for (int i = 0; i < selectRows.length; ++i) {
            DynamicObject parent = (DynamicObject)dataEntity.getDynamicObjectCollection("billentry").get(selectRows[i]);
            DynamicObjectCollection deliverEntry = parent.getDynamicObjectCollection("orderdeliverentry");
            String materialName = parent.getString("materialname");
            int rowInt = parent.getInt("seq");
            if (deliverEntry.size() <= 0) continue;
            map.put(rowInt, materialName);
        }
        return map;
    }

    private void generateDeliverPlan() {
        int[] selectRows = ((EntryGrid)this.getControl("billentry")).getSelectRows();
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        String entityName = this.getModel().getDataEntityType().getName();
        for (int i = 0; i < selectRows.length; ++i) {
            DynamicObject parent = (DynamicObject)dataEntity.getDynamicObjectCollection("billentry").get(selectRows[i]);
            DynamicObject unit = parent.getDynamicObject("unit");
            BigDecimal qty = parent.getBigDecimal("qty");
            Date deliverydate = parent.getDate("deliverydate");
            DynamicObjectCollection deliver = parent.getDynamicObjectCollection("orderdeliverentry");
            if (deliver == null) continue;
            if ("sm_xsalorder".equals(entityName) || "sm_xssalorder".equals(entityName)) {
                Iterator it = deliver.iterator();
                while (it.hasNext()) {
                    DynamicObject deliverEntry = (DynamicObject)it.next();
                    if (ChangeTypeEnum.ADDNEW.getValue().equals(deliverEntry.getString("delentrychangetype"))) {
                        it.remove();
                        continue;
                    }
                    deliverEntry.set("delentrychangetype", (Object)ChangeTypeEnum.CANCEL.getValue());
                }
            } else {
                deliver.clear();
            }
            DynamicObject deliverEntry = deliver.addNew();
            deliverEntry.set("seq", (Object)1);
            deliverEntry.set("d_planunit", (Object)unit);
            deliverEntry.set("d_planqty", (Object)qty);
            deliverEntry.set("d_plandate", (Object)deliverydate);
            deliverEntry.set("d_plandeliverydate", (Object)deliverydate);
            if ("sm_salorder".equals(this.getModel().getDataEntityType().getName())) {
                deliverEntry.set("delentrychangetype", (Object)ChangeTypeEnum.UPDATE.getValue());
            }
            if (!"sm_xsalorder".equals(entityName) && !"sm_xssalorder".equals(entityName)) continue;
            deliverEntry.set("delentrychangetype", (Object)ChangeTypeEnum.ADDNEW.getValue());
        }
        this.getView().updateView("orderdeliverentry");
    }

    private void changeDeliverUnit(DynamicObject dataEntity) {
        DynamicObjectCollection salOrderEntryDeliver = (DynamicObjectCollection)dataEntity.get("orderdeliverentry");
        if (salOrderEntryDeliver != null) {
            for (int i = 0; i < salOrderEntryDeliver.size(); ++i) {
                this.getModel().setValue("d_planunit", (Object)dataEntity.getDynamicObject("unit"), i);
            }
            this.getView().updateView("orderdeliverentry");
        }
    }

    private void changeDeliverQty(DynamicObject dataEntity) {
        DynamicObjectCollection salOrderEntryDeliver = (DynamicObjectCollection)dataEntity.get("orderdeliverentry");
        if (salOrderEntryDeliver != null) {
            for (int i = 0; i < salOrderEntryDeliver.size(); ++i) {
                DynamicObject entryInfo = (DynamicObject)salOrderEntryDeliver.get(i);
                BigDecimal qty = entryInfo.getBigDecimal("d_planqty");
                DynamicObject unit = dataEntity.getDynamicObject("unit");
                if (unit == null) continue;
                int precision = unit.getInt("precision");
                int precisionaccount = BillTplHelper.getRoundMode((DynamicObject)unit);
                qty = qty.setScale(precision, precisionaccount);
                this.getModel().setValue("d_planqty", (Object)qty, i);
            }
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        long start = System.currentTimeMillis();
        try (TraceSpan span = Tracer.create((String)"SalesOrderPlugin", (String)"afterImportData");){
            String url = RequestContext.get().getClientUrl();
            if (url != null && url.contains("appendentryrows")) {
                return;
            }
            String billcretype = this.getPageCache().get("billcretype");
            IDataModel model = this.getModel();
            DynamicObject bill = model.getDataEntity(true);
            if (BillImportHelper.isImport((String)billcretype)) {
                model.setValue("billcretype", (Object)"1");
                DynamicObjectCollection billentrys = (DynamicObjectCollection)model.getValue("billentry");
                boolean isKitTransfer = false;
                DynamicObject currentParentInfo = null;
                boolean isKitSales = KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName());
                DynamicObject billType = (DynamicObject)model.getValue("billtype");
                for (int i = 0; i < billentrys.size(); ++i) {
                    DynamicObject billentry = (DynamicObject)billentrys.get(i);
                    if (isKitSales) {
                        boolean hasKitProduct = false;
                        String productType = billentry.getString("producttype");
                        if (ProductTypeEnum.KITPARENT.getValue().equals(productType)) {
                            Iterator transferModel = billentry.getString("kittransfermodel");
                            if (KitTransferModelEnum.KIT.getValue().equals(transferModel)) {
                                isKitTransfer = true;
                            }
                            currentParentInfo = billentry;
                            hasKitProduct = true;
                        } else if (ProductTypeEnum.KITCHILD.getValue().equals(productType)) {
                            if (isKitTransfer && currentParentInfo != null && currentParentInfo.getLong("kitpid") == billentry.getLong("kitpid")) {
                                for (String field : BizKitConst.getSycKitParentFields_suite()) {
                                    billentry.set(field, currentParentInfo.get(field));
                                }
                            }
                            if (currentParentInfo != null && currentParentInfo.getLong("kitpid") == billentry.getLong("kitpid")) {
                                for (String field : BizKitConst.getSycKitParentFields()) {
                                    billentry.set(field, currentParentInfo.get(field));
                                }
                            }
                            hasKitProduct = true;
                        }
                        if (billType != null && hasKitProduct && BizKitConst.getNotSupportBillType().contains(billType.getString("number"))) {
                            String msg = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u4e3a\u8d39\u7528\u7c7b\u9500\u552e\u3001\u59d4\u6258\u4ee3\u9500\u548cVMI\u9500\u552e\uff0c\u4ea7\u54c1\u7c7b\u522b\u4ec5\u9650\u4e8e\u6807\u51c6\u4ea7\u54c1\uff0c\u8bf7\u91cd\u65b0\u5c1d\u8bd5\u4fee\u6539\u3002", (String)"SalesOrderPlugin_35", (String)"scmc-sm-formplugin", (Object[])new Object[0]), new Object[0]);
                            e.setCancel(true);
                            e.setCancelMessages(Integer.valueOf(i), Integer.valueOf(0), Collections.singletonList(msg));
                            continue;
                        }
                        if (OwnerTypeEnum.SUPPLIER.getValue().equals(billentry.get("ownertype"))) {
                            billentry.set("owner", null);
                            billentry.set("ownertype", (Object)OwnerTypeEnum.ORG.getValue());
                        }
                    }
                    Calendar instance = Calendar.getInstance();
                    instance.set(11, 0);
                    instance.set(12, 0);
                    instance.set(13, 0);
                    instance.set(14, 0);
                    Date time = instance.getTime();
                    Date deliverdate = (Date)billentry.get("deliverydate");
                    if (deliverdate == null || time.compareTo(deliverdate) == 0) {
                        Date bizdate = (Date)model.getValue("bizdate");
                        billentry.set("deliverydate", (Object)bizdate);
                    }
                    DynamicObject owner = billentry.getDynamicObject("owner");
                    DynamicObject unit = billentry.getDynamicObject("unit");
                    BigDecimal qty = billentry.getBigDecimal("qty");
                    BigDecimal baseQty = billentry.getBigDecimal("baseqty");
                    Boolean isControlQty = (Boolean)billentry.get("iscontrolqty");
                    DynamicObject baseUnit = billentry.getDynamicObject("baseunit");
                    if (isControlQty.booleanValue() && unit != null && baseUnit != null) {
                        BigDecimal deliverRateUp = billentry.getBigDecimal("deliverrateup");
                        BigDecimal deliverRateDown = billentry.getBigDecimal("deliverratedown");
                        if (deliverRateUp != null && deliverRateDown != null) {
                            int precision = unit.getInt("precision");
                            int baseprecision = baseUnit.getInt("precision");
                            BigDecimal deliverQtyUp = qty.multiply(ONE.add(deliverRateUp.divide(HUNDRED, 10, 4))).setScale(precision, BillTplHelper.getRoundMode((DynamicObject)unit));
                            BigDecimal deliverQtyDown = qty.multiply(ONE.subtract(deliverRateDown.divide(HUNDRED, 10, 4))).setScale(precision, BillTplHelper.getRoundMode((DynamicObject)unit));
                            BigDecimal deliverBaseQtyUp = baseQty.multiply(ONE.add(deliverRateUp.divide(HUNDRED, 10, 4))).setScale(baseprecision, BillTplHelper.getRoundMode((DynamicObject)baseUnit));
                            BigDecimal deliverBaseQtyDown = baseQty.multiply(ONE.subtract(deliverRateDown.divide(HUNDRED, 10, 4))).setScale(baseprecision, BillTplHelper.getRoundMode((DynamicObject)baseUnit));
                            billentry.set("iscontrolqty", (Object)Boolean.TRUE);
                            billentry.set("deliverrateup", (Object)deliverRateUp);
                            billentry.set("deliverratedown", (Object)deliverRateDown);
                            billentry.set("deliverqtyup", (Object)deliverQtyUp);
                            billentry.set("deliverqtydown", (Object)deliverQtyDown);
                            billentry.set("deliverbaseqtyup", (Object)deliverBaseQtyUp);
                            billentry.set("deliverbaseqtydown", (Object)deliverBaseQtyDown);
                        }
                    } else {
                        billentry.set("deliverrateup", (Object)ZERO);
                        billentry.set("deliverratedown", (Object)ZERO);
                        billentry.set("deliverqtyup", (Object)qty);
                        billentry.set("deliverqtydown", (Object)qty);
                        billentry.set("deliverbaseqtyup", (Object)baseQty);
                        billentry.set("deliverbaseqtydown", (Object)baseQty);
                    }
                    Boolean ISCONTROLDAY = (Boolean)billentry.get("iscontrolday");
                    if (!ISCONTROLDAY.booleanValue()) {
                        billentry.set("deliveradvdays", (Object)ZERO);
                        billentry.set("deliverdelaydays", (Object)ZERO);
                    }
                    BigDecimal minOrderBaseQty = BigDecimal.ZERO;
                    DynamicObject masterMat = billentry.getDynamicObject("material.masterid");
                    BigDecimal minOrderQty = billentry.getBigDecimal("material.minorderqty");
                    DynamicObject salesUnit = billentry.getDynamicObject("material.salesunit");
                    if (masterMat != null && baseUnit != null && salesUnit != null && minOrderQty != null && BigDecimal.ZERO.compareTo(minOrderQty) != 0) {
                        BigDecimal muConv = MaterialHelper.getMUConv((Long)((Long)masterMat.getPkValue()), (DynamicObject)salesUnit, (DynamicObject)baseUnit, (boolean)true);
                        minOrderBaseQty = minOrderQty.multiply(muConv);
                    }
                    billentry.set("minorderbaseqty", (Object)minOrderBaseQty);
                }
                long end1 = System.currentTimeMillis();
                log.info("setMaterialEntry time:" + (end1 - start));
                SalOrderRecPlanHelper.reCalcuRecPlanAmountByContion((DynamicObject)model.getDataEntity(true));
                long end2 = System.currentTimeMillis();
                log.info("calculateAmount time:" + (end2 - end1));
                Object billEntrySettleOrg = null;
                if (billentrys != null && billentrys.size() > 0) {
                    billEntrySettleOrg = ((DynamicObject)billentrys.get(0)).get("entrysettleorg");
                }
                SalesOrderPlugin.setDefaultRecPlanEntry(this.getModel().getDataEntity(true), billEntrySettleOrg);
            } else if (BillImportHelper.isApi((String)billcretype)) {
                SalOrderBillHelper.completeBillInfo(Collections.singletonList(bill));
            }
        }
    }

    private static void setDefaultRecPlanEntry(DynamicObject bill, Object billEntrySettleOrg) {
        if (bill == null) {
            return;
        }
        DynamicObjectCollection payEntrys = bill.getDynamicObjectCollection("recplanentry");
        for (DynamicObject entry : payEntrys) {
            if (entry == null) continue;
            entry.set("recentrychangetype", (Object)ChangeTypeEnum.UPDATE.getValue());
            DynamicObject entrySettleOrg = entry.getDynamicObject("r_recsettleorg");
            if (entrySettleOrg == null && billEntrySettleOrg != null) {
                entry.set("r_recsettleorg", billEntrySettleOrg);
            }
            BigDecimal unRemainAmount = entry.getBigDecimal("r_unremainamount");
            BigDecimal recAmount = entry.getBigDecimal("r_recadvanceamount");
            if (!BigDecimalUtil.isBlank((BigDecimal)unRemainAmount) || !BigDecimalUtil.isNotBlank((BigDecimal)recAmount)) continue;
            BigDecimal remainAmount = entry.getBigDecimal("r_remainamount");
            unRemainAmount = recAmount.subtract(remainAmount);
            entry.set("r_unremainamount", (Object)unRemainAmount);
        }
    }

    private void quotaDrawChangeCus() {
        DynamicObjectCollection billentry = this.getModel().getEntryEntity("billentry");
        if (billentry != null && billentry.size() != 0) {
            String srcbillentity = (String)((DynamicObject)billentry.get(0)).get("srcbillentity");
            if (srcbillentity.equals("sm_quotationbill")) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"customer"});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"customer"});
            }
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        long start = System.currentTimeMillis();
        try (TraceSpan span = Tracer.create((String)"SalesOrderPlugin", (String)"beforeImportData");){
            String url = RequestContext.get().getClientUrl();
            if (url != null && url.contains("appendentryrows")) {
                return;
            }
            String billcretype = this.getPageCache().get("billcretype");
            if (!BillImportHelper.isImport((String)billcretype)) {
                return;
            }
            Map billtypeMap = BillImportHelper.format4ImportAndApi(e.getSourceData().get("billtype"));
            if (billtypeMap == null) {
                return;
            }
            String billType = (String)billtypeMap.get("number");
            String payMode = (String)e.getSourceData().get("paymode");
            if (payMode != null && billType != null) {
                if (billType.equals("sm_SalesOrder_SERV_BT_S") && payMode.equals("CASH")) {
                    e.setCancel(true);
                    e.setCancelMessage(ResManager.loadKDString((String)"\u670d\u52a1\u7c7b\u9500\u552e\u8ba2\u5355\u7684\u4ed8\u6b3e\u65b9\u5f0f\u5e94\u4e3a\u8d4a\u9500\u3002", (String)"SalesOrderPlugin_12", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    e.setFireAfterImportData(false);
                }
                if (billType.equalsIgnoreCase("sm_SalesOrder_Agency_BT_S") && payMode.equals("CASH")) {
                    e.setCancel(true);
                    e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u59d4\u6258\u4ee3\u9500\u8ba2\u5355\u7684\u4ed8\u6b3e\u65b9\u5f0f\u5e94\u4e3a\u8d4a\u9500\u3002", (String)"SalesOrderPlugin_19", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    e.setFireAfterImportData(false);
                }
            }
        }
        long end2 = System.currentTimeMillis();
        log.info("saleorder beforeImportData time:" + (end2 - start));
    }

    private void setRecChangeLineEnable() {
        String entityId = this.getView().getEntityId();
        if (entityId != null && "sm_xssalorder".equals(entityId)) {
            IDataEntityType dt = this.getModel().getDataEntity().getDataEntityType();
            String[] allEntryProperties = MetaDataHelper.getAllPropertyName4Entry((IDataEntityType)dt, (String)"recplanentry");
            int entryRowCount = this.getModel().getEntryRowCount("recplanentry");
            for (int i = 0; i < entryRowCount; ++i) {
                if (this.getModel().getValue("recentrychangetype", i) == null || !ChangeTypeEnum.CANCEL.getValue().equals(this.getModel().getValue("recentrychangetype", i))) continue;
                this.getView().setEnable(Boolean.FALSE, i, allEntryProperties);
            }
        }
    }

    private void setOwnerTypeEnable() {
        DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
        if (bizType != null && !"210".equals(bizType.getString("number"))) {
            this.getView().setEnable(Boolean.FALSE, -1, new String[]{"ownertype"});
        } else {
            this.getView().setEnable(Boolean.TRUE, -1, new String[]{"ownertype"});
        }
    }

    private void setOwnerTypeDefault() {
        DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
        if (bizType != null && "6".equals(bizType.getString("domain"))) {
            int entryRowCount = this.getModel().getEntryRowCount("billentry");
            for (int i = 0; i < entryRowCount; ++i) {
                this.getModel().setValue("ownertype", (Object)OwnerTypeEnum.SUPPLIER.getValue(), i);
            }
        } else {
            int entryRowCount = this.getModel().getEntryRowCount("billentry");
            for (int i = 0; i < entryRowCount; ++i) {
                this.getModel().setValue("ownertype", (Object)OwnerTypeEnum.ORG.getValue(), i);
            }
        }
    }

    private void setSupplytransDefault() {
        int entryRowCount = this.getModel().getEntryRowCount("billentry");
        for (int i = 0; i < entryRowCount; ++i) {
            DynamicObject lineType = (DynamicObject)this.getModel().getValue("linetype", entryRowCount);
            if (lineType != null && !lineType.getBoolean("storageout")) {
                this.setSupplytans(i);
            }
            if (!KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) continue;
            String productType = (String)this.getModel().getValue("producttype", i);
            if (!ProductTypeEnum.KITPARENT.getValue().equals(productType) && !ProductTypeEnum.KITCHILD.getValue().equals(productType)) continue;
            this.setSupplytans(i);
        }
        this.getView().updateView("billentry");
    }

    public void setSupplytans(int rowIndex) {
        this.getModel().setValue("supplytrans", (Object)Boolean.FALSE, rowIndex);
        this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"supplytrans"});
    }

    private void setSupplytransDefaultAndEnable(List<Integer> rows) {
        if (rows == null || rows.size() == 0) {
            return;
        }
        for (Integer rowIndex : rows) {
            DynamicObject lineType = (DynamicObject)this.getModel().getValue("linetype", rowIndex.intValue());
            if (lineType != null && !lineType.getBoolean("storageout")) {
                this.setSupplytans(rowIndex);
            }
            if (!KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) continue;
            String productType = (String)this.getModel().getValue("producttype", rowIndex.intValue());
            if (!ProductTypeEnum.KITPARENT.getValue().equals(productType) && !ProductTypeEnum.KITCHILD.getValue().equals(productType)) continue;
            this.setSupplytans(rowIndex);
        }
    }

    private void setSupplytransDefaultEntry(List<RowDataEntity> currencyRows) {
        if (currencyRows == null || currencyRows.size() == 0) {
            return;
        }
        for (RowDataEntity row : currencyRows) {
            int rowIndex = row.getRowIndex();
            DynamicObject lineType = (DynamicObject)this.getModel().getValue("linetype", rowIndex);
            if (lineType != null && !lineType.getBoolean("storageout")) {
                this.setSupplytans(rowIndex);
            }
            if (!KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) continue;
            String productType = (String)this.getModel().getValue("producttype", rowIndex);
            if (!ProductTypeEnum.KITPARENT.getValue().equals(productType) && !ProductTypeEnum.KITCHILD.getValue().equals(productType)) continue;
            this.setSupplytans(rowIndex);
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        DynamicObjectCollection recEntrys = this.getModel().getEntryEntity("recplanentry");
        if (recEntrys != null && !recEntrys.isEmpty()) {
            for (DynamicObject recEntry : recEntrys) {
                BigDecimal recAdvanceAmount = recEntry.getBigDecimal("r_recadvanceamount") == null ? BigDecimal.ZERO : recEntry.getBigDecimal("r_recadvanceamount");
                BigDecimal needRemainAmount = recEntry.getBigDecimal("r_remainamount") == null ? BigDecimal.ZERO : recEntry.getBigDecimal("r_remainamount");
                recEntry.set("r_unremainamount", (Object)recAdvanceAmount.subtract(needRemainAmount));
            }
        }
    }

    private void showHistoricalPriceRpt() {
        if (CollectionUtils.isEmpty(this.getSelectedMaterialIdList())) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("billentry");
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows != null && selectRows.length > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SalesOrderPlugin_18", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u660e\u7ec6\u5206\u5f55\u884c\u3002", (String)"SalesOrderPlugin_2", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
            }
            return;
        }
        ReportShowParameter parameter = new ReportShowParameter();
        parameter.setFormId("sal_historicalprice_new");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setQueryParam(this.createHistoricalPriceRptParams());
        this.getView().showForm((FormShowParameter)parameter);
    }

    private ReportQueryParam createHistoricalPriceRptParams() {
        ReportQueryParam queryParam = new ReportQueryParam();
        queryParam.getCustomParam().put("isFormBill", "1");
        FilterInfo filter = queryParam.getFilter();
        DynamicObject billData = this.getModel().getDataEntity();
        filter.addFilterItem("orgfield", this.getBaseDataPkValue("org"));
        Date date = billData.getDate("bizdate");
        if (date != null) {
            filter.addFilterItem("startdate", (Object)DateUtils.addDays((Date)DateUtils.addYears((Date)date, (int)-1), (int)1));
            filter.addFilterItem("enddate", (Object)date);
        }
        filter.addFilterItem("biztypefield", this.getBaseDataPkValue("biztype"));
        filter.addFilterItem("customerfield", this.getBaseDataPkValue("customer"));
        filter.addFilterItem("deptfield", this.getBaseDataPkValue("dept"));
        filter.addFilterItem("operatorgroupfield", this.getBaseDataPkValue("operatorgroup"));
        filter.addFilterItem("operatorfield", this.getBaseDataPkValue("operator"));
        filter.addFilterItem("virtualfield", (Object)Boolean.TRUE);
        filter.addFilterItem("pricesourceentityfield", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)this.getView().getEntityId(), (String)"bos_entityobject"));
        filter.addFilterItem("materialfield", this.getSelectedMaterialIdList());
        return queryParam;
    }

    private Set<Object> getSelectedMaterialIdList() {
        HashSet<Object> ids = new HashSet<Object>();
        EntryGrid entryGrid = (EntryGrid)this.getControl("billentry");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows == null) {
            return ids;
        }
        for (int index : selectRows) {
            DynamicObject material = (DynamicObject)this.getModel().getValue("material", index);
            if (material == null) continue;
            ids.add(material.getDynamicObject("masterid").getPkValue());
        }
        return ids;
    }

    private Object getBaseDataPkValue(String field) {
        DynamicObject obj = (DynamicObject)this.getModel().getValue(field);
        return obj != null ? obj.getPkValue() : null;
    }

    private void showProductConfigForm() {
        AbstractGrid billentry = (AbstractGrid)this.getControl("billentry");
        int focusEntryRow = billentry.getEntryState().getFocusRow();
        if (focusEntryRow == -1) {
            return;
        }
        IDataModel model = this.getModel();
        FormShowParameter param = new FormShowParameter();
        param.setFormId("pdm_productconfig");
        param.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss style = new StyleCss();
        style.setWidth("1000");
        style.setHeight("780");
        param.getOpenStyle().setInlineStyleCss(style);
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        DynamicObject materialsalinfo = (DynamicObject)model.getValue("material", focusEntryRow);
        DynamicObject material = materialsalinfo != null ? materialsalinfo.getDynamicObject("masterid") : null;
        String materialid = material == null ? "" : String.valueOf(material.getPkValue());
        DynamicObject deliveryOrg = (DynamicObject)model.getValue("e_stockorg", focusEntryRow);
        String orgid = deliveryOrg == null ? "" : String.valueOf(deliveryOrg.getPkValue());
        Object datetime = model.getValue("bizdate");
        Object deliverydatetime = model.getValue("deliverydate", focusEntryRow);
        DynamicObject configuredcode = (DynamicObject)model.getValue("configuredcode", focusEntryRow);
        long configcodeid = configuredcode == null ? 0L : (Long)configuredcode.getPkValue();
        customParams.put("org", orgid);
        customParams.put("material", materialid);
        customParams.put("datetime", datetime);
        customParams.put("deliverdatetime", deliverydatetime);
        customParams.put("configcode", configcodeid);
        customParams.put("issale", "2");
        param.setCustomParams(customParams);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SELCONFIG));
        this.getView().showForm(param);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (e.getReturnData() != null && SELCONFIG.equals(actionId)) {
            HashMap returnData = (HashMap)e.getReturnData();
            Long configCode = (Long)returnData.get("configCodeBack");
            AbstractGrid billentry = (AbstractGrid)this.getControl("billentry");
            int focusEntryRow = billentry.getEntryState().getFocusRow();
            this.getModel().setValue("configuredcode", (Object)configCode, focusEntryRow);
        }
    }

    private void setKitColumnEnables(List<RowDataEntity> currencyRows) {
        if (currencyRows == null || currencyRows.size() == 0) {
            return;
        }
        for (RowDataEntity row : currencyRows) {
            int rowIndex = row.getRowIndex();
            this.setKitDeliverColumnEnable(rowIndex, null);
        }
    }

    private void setOneKitColumnEnable(int rowIndex) {
        this.setKitDeliverColumnEnable(rowIndex, null);
    }

    private void setKitColumnEnable(List<Integer> rows) {
        if (rows == null || rows.size() == 0) {
            return;
        }
        for (int rowIndex : rows) {
            this.setKitDeliverColumnEnable(rowIndex, null);
        }
    }

    private void setChildDeliverColumnEnable(List<Integer> childEntryList, String transferModel) {
        if (childEntryList == null || childEntryList.size() == 0) {
            return;
        }
        for (Integer childEntryIndex : childEntryList) {
            this.setKitDeliverColumnEnable(childEntryIndex, transferModel);
        }
    }

    private void setKitDeliverColumnValue(List<Integer> childIndexList, int parentRowIndex, String column) {
        if (childIndexList == null || childIndexList.size() == 0) {
            return;
        }
        DynamicObject parentEntry = this.getModel().getEntryRowEntity("billentry", parentRowIndex);
        for (int childRowIndex : childIndexList) {
            this.getModel().setValue(column, parentEntry.get(column), childRowIndex);
        }
    }

    private void setKitDeliverColumnEnable(int rowIndex, String transfermodel) {
        String changeType;
        DynamicObject parentRow;
        String productType = (String)this.getModel().getValue("producttype", rowIndex);
        String entityId = this.getView().getEntityId();
        if ("sm_xsalorder".equals(entityId)) {
            return;
        }
        if (!StringUtils.isEmpty((Object)this.getPageCache().get(EXPANDKITPARENTROW))) {
            return;
        }
        if (ProductTypeEnum.KITCHILD.getValue().equals(productType) && (parentRow = this.getParentEntry(rowIndex)) != null) {
            DynamicObject kitBom = parentRow.getDynamicObject("bom");
            DynamicObject material = parentRow.getDynamicObject("material");
            if (kitBom != null && material != null && KitStructCtlEnum.NONADJ.getValue().equals(material.getString("kitstructctl"))) {
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"qty"});
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"auxqty"});
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"unit"});
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"material"});
            } else if ("sm_xsalorder".equals(entityId)) {
                DynamicObject auxUnit;
                changeType = (String)this.getModel().getValue("entrychangetype", rowIndex);
                if (!ChangeTypeEnum.CANCEL.getValue().equals(changeType) && (auxUnit = (DynamicObject)this.getModel().getValue("auxunit", rowIndex)) != null) {
                    this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"auxqty"});
                }
            } else if ("sm_xssalorder".equals(entityId)) {
                DynamicObject auxUnit;
                IDataEntityType dt = this.getModel().getDataEntity().getDataEntityType();
                String[] unEnableProperty = ChangeModelHelper.getUnEnableProperty((IDataEntityType)dt, (String)"billentry");
                HashSet<String> unEnableColumns = new HashSet<String>(8);
                if (unEnableProperty != null && unEnableProperty.length > 0) {
                    unEnableColumns.addAll(Arrays.asList(unEnableProperty));
                }
                String changeType2 = (String)this.getModel().getValue("entrychangetype", rowIndex);
                if ((!ChangeTypeEnum.CANCEL.getValue().equals(changeType2) && !unEnableColumns.contains("auxunit") || ChangeTypeEnum.ADDNEW.getValue().equals(changeType2)) && (auxUnit = (DynamicObject)this.getModel().getValue("auxunit", rowIndex)) != null) {
                    this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"auxqty"});
                }
            } else {
                DynamicObject auxUnit = (DynamicObject)this.getModel().getValue("auxunit", rowIndex);
                if (auxUnit != null) {
                    this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"auxqty"});
                }
            }
        }
        if (ProductTypeEnum.KITCHILD.getValue().equals(productType)) {
            if (transfermodel == null) {
                transfermodel = (String)this.getModel().getValue("kittransfermodel", rowIndex);
            }
            if (KitTransferModelEnum.KIT.getValue().equals(transfermodel)) {
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"e_stockorg", "deliverydate", "iscontrolday", "deliveradvdays", "deliverdelaydays"});
            } else if (KitTransferModelEnum.NONKIT.getValue().equals(transfermodel)) {
                if ("sm_xssalorder".equals(entityId)) {
                    IDataEntityType dt = this.getModel().getDataEntity().getDataEntityType();
                    String[] unEnableProperty = ChangeModelHelper.getUnEnableProperty((IDataEntityType)dt, (String)"billentry");
                    HashSet<String> unEnableColumns = new HashSet<String>(8);
                    if (unEnableProperty != null && unEnableProperty.length > 0) {
                        unEnableColumns.addAll(Arrays.asList(unEnableProperty));
                    }
                    changeType = (String)this.getModel().getValue("entrychangetype", rowIndex);
                    for (String column : deliverColumns) {
                        if (ChangeTypeEnum.CANCEL.getValue().equals(changeType)) {
                            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{column});
                            continue;
                        }
                        if (!unEnableColumns.contains(column) || ChangeTypeEnum.ADDNEW.getValue().equals(changeType)) {
                            this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{column});
                            continue;
                        }
                        this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{column});
                    }
                } else if ("sm_xsalorder".equals(entityId)) {
                    String changeType3 = (String)this.getModel().getValue("entrychangetype", rowIndex);
                    for (String column : deliverColumns) {
                        if (!ChangeTypeEnum.CANCEL.getValue().equals(changeType3)) continue;
                        this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{column});
                    }
                } else {
                    this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"e_stockorg", "deliverydate", "iscontrolday", "deliveradvdays", "deliverdelaydays"});
                }
            }
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"iscontrolqty", "deliverratedown", "deliverrateup", "supplytrans", "purorg", "supplier"});
        }
    }

    private void setKitDeliverColumnDefault(List<Integer> childIndexList) {
        if (childIndexList == null || childIndexList.size() == 0) {
            return;
        }
        HashMap<Long, DynamicObject> parentMap = new HashMap<Long, DynamicObject>();
        for (int childRowIndex : childIndexList) {
            String productType = (String)this.getModel().getValue("producttype", childRowIndex);
            if (!ProductTypeEnum.KITCHILD.getValue().equals(productType)) continue;
            Long pID = (Long)this.getModel().getValue("kitpid", childRowIndex);
            DynamicObject parentEntry = (DynamicObject)parentMap.get(pID);
            if (parentEntry == null) {
                parentEntry = this.getParentEntry(childRowIndex);
                parentMap.put(pID, parentEntry);
            }
            if (parentEntry == null) continue;
            this.setKitDeliverOneColumnDefault(childRowIndex, parentEntry);
        }
    }

    private void setKitDeliverColumnDefault(List<Integer> childIndexList, int parentRowIndex) {
        if (childIndexList == null || childIndexList.size() == 0) {
            return;
        }
        DynamicObject parentEntry = this.getModel().getEntryRowEntity("billentry", parentRowIndex);
        for (int childRowIndex : childIndexList) {
            this.setKitDeliverOneColumnDefault(childRowIndex, parentEntry);
        }
    }

    private void setKitDeliverOneColumnDefault(Integer childRowIndex, DynamicObject parentEntry) {
        this.getModel().setValue("entrysettleorg", parentEntry.get("entrysettleorg"), childRowIndex.intValue());
        this.getModel().setValue("e_stockorg", parentEntry.get("e_stockorg"), childRowIndex.intValue());
        this.getModel().setValue("deliverydate", parentEntry.get("deliverydate"), childRowIndex.intValue());
        this.getModel().setValue("iscontrolday", parentEntry.get("iscontrolday"), childRowIndex.intValue());
        this.getModel().setValue("deliveradvdays", parentEntry.get("deliveradvdays"), childRowIndex.intValue());
        this.getModel().setValue("deliverdelaydays", parentEntry.get("deliverdelaydays"), childRowIndex.intValue());
        this.getModel().setValue("iscontrolqty", parentEntry.get("iscontrolqty"), childRowIndex.intValue());
        this.getModel().setValue("deliverratedown", parentEntry.get("deliverratedown"), childRowIndex.intValue());
        this.getModel().setValue("deliverrateup", parentEntry.get("deliverrateup"), childRowIndex.intValue());
        this.getModel().setValue("supplytrans", parentEntry.get("supplytrans"), childRowIndex.intValue());
        this.getModel().setValue("purorg", parentEntry.get("purorg"), childRowIndex.intValue());
        this.getModel().setValue("supplier", parentEntry.get("supplier"), childRowIndex.intValue());
        this.getModel().setValue("ownertype", parentEntry.get("ownertype"), childRowIndex.intValue());
        this.getModel().setValue("owner", parentEntry.get("owner"), childRowIndex.intValue());
    }

    private DynamicObject getParentEntry(int childRowIndex) {
        DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("billentry");
        Long pID = (Long)this.getModel().getValue("kitpid", childRowIndex);
        DynamicObject parentEntry = null;
        for (DynamicObject entry : entrys) {
            Long entryPid = entry.getLong("kitpid");
            String productType = entry.getString("producttype");
            if (!ProductTypeEnum.KITPARENT.getValue().equals(productType) || entryPid.longValue() != pID.longValue()) continue;
            parentEntry = entry;
            break;
        }
        return parentEntry;
    }

    private List<Integer> getAllChildEntry(int parentRowIndex) {
        DynamicObject parentEntry = this.getModel().getEntryRowEntity("billentry", parentRowIndex);
        Long parentPid = parentEntry.getLong("kitpid");
        ArrayList<Integer> childEntryList = new ArrayList<Integer>();
        int rowCount = this.getModel().getEntryRowCount("billentry");
        for (int i = 0; i < rowCount; ++i) {
            Long pID = (Long)this.getModel().getValue("kitpid", i);
            String productType = (String)this.getModel().getValue("producttype", i);
            if (!ProductTypeEnum.KITCHILD.getValue().equals(productType) || parentPid.longValue() != pID.longValue()) continue;
            childEntryList.add(i);
        }
        return childEntryList;
    }

    private void calcChildRowQty(Integer parentRowIndex) {
        if (KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) {
            String productType = (String)this.getModel().getValue("producttype", parentRowIndex.intValue());
            if (ProductTypeEnum.KITPARENT.getValue().equals(productType)) {
                DynamicObject kitBom = (DynamicObject)this.getModel().getValue("bom", parentRowIndex.intValue());
                DynamicObject parentMaterial = (DynamicObject)this.getModel().getValue("material", parentRowIndex.intValue());
                if (kitBom != null && parentMaterial != null && KitStructCtlEnum.NONADJ.getValue().equals(parentMaterial.getString("kitstructctl"))) {
                    List<Integer> allChildIndexList = this.getAllChildEntry(parentRowIndex);
                    for (Integer childRowIndex : allChildIndexList) {
                        BigDecimal parentBaseQty = (BigDecimal)this.getModel().getValue("baseqty", parentRowIndex.intValue());
                        BigDecimal kitQty = (BigDecimal)this.getModel().getValue("kitqty", childRowIndex.intValue());
                        BigDecimal parentQty = (BigDecimal)this.getModel().getValue("parentqty", childRowIndex.intValue());
                        DynamicObject baseUnit = (DynamicObject)this.getModel().getValue("baseunit", childRowIndex.intValue());
                        DynamicObject material = (DynamicObject)this.getModel().getValue("material", childRowIndex.intValue());
                        DynamicObject unit = (DynamicObject)this.getModel().getValue("unit", childRowIndex.intValue());
                        if (parentBaseQty == null || parentBaseQty.compareTo(BigDecimal.ZERO) == 0 || parentQty == null || parentQty.compareTo(BigDecimal.ZERO) == 0 || kitQty == null || unit == null || baseUnit == null || material == null) continue;
                        DynamicObject masterMaterial = material.getDynamicObject("masterid");
                        int precision = KitSalesHelper.getUnitPrecision((DynamicObject)baseUnit);
                        RoundingMode roundingMode = KitSalesHelper.getUnitRoundingMode((DynamicObject)baseUnit);
                        BigDecimal baseQty = parentBaseQty.multiply(kitQty).divide(parentQty, precision, roundingMode);
                        BigDecimal qty = BillTplHelper.getDesQtyConv((DynamicObject)masterMaterial, (DynamicObject)baseUnit, (BigDecimal)baseQty, (DynamicObject)unit);
                        this.getModel().setValue("qty", (Object)qty, childRowIndex.intValue());
                    }
                }
            }
        }
    }
}

