/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.formplugin.order;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.mpscmm.msbd.changemodel.business.helper.ChangeModelHelper;
import kd.mpscmm.msbd.common.enums.KitStructCtlEnum;
import kd.mpscmm.msbd.common.enums.KitTransferModelEnum;
import kd.mpscmm.msbd.common.enums.PriceModelEnum;
import kd.scmc.sm.business.helper.BillImportHelper;
import kd.scmc.sm.business.helper.KitSalesHelper;
import kd.scmc.sm.business.helper.PluginConnectControllHelper;
import kd.scmc.sm.business.helper.PropertyChangeHelper;
import kd.scmc.sm.business.helper.SalOrderRecPlanHelper;
import kd.scmc.sm.consts.BillTplEntryConst;
import kd.scmc.sm.enums.ChangeTypeEnum;
import kd.scmc.sm.enums.ProductTypeEnum;
import kd.scmc.sm.util.CommonUtils;

public class XSSalesOrderPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
EntryGridBindDataListener,
RowClickEventListener {
    public static final String SELCONFIG = "selconfig";
    private static final String ISCONFIRMDELETEKITROW = "isConfirmDeleteKitRow";
    private static final String CONFIRM_LINETYPE = "confirm_linetype";
    private static final String CACHE_LINETYPE = "cache_linetype";
    private static final String ISCANCELDELROWBECBOM = "isCancelDelRowBecBom";
    private static final String CONFIRM_KITLINETYPE = "confirmXKitLineType";
    private static final String CACHE_KITLINETYPE = "cacheXKitLineType";
    private static final String[] deliverColumns = new String[]{"e_stockorg", "deliverydate", "iscontrolday", "deliveradvdays", "deliverdelaydays"};

    public void registerListener(EventObject e) {
        Toolbar deliverToolbar;
        EntryGrid entry;
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap2"});
        Toolbar tbmainentry = (Toolbar)this.getView().getControl("tbmainentry");
        if (tbmainentry != null) {
            tbmainentry.addItemClickListener((ItemClickListener)this);
        }
        if ((entry = (EntryGrid)this.getControl("billentry")) != null) {
            entry.addRowClickListener((RowClickEventListener)this);
            entry.addDataBindListener((EntryGridBindDataListener)this);
        }
        if ((deliverToolbar = (Toolbar)this.getView().getControl("tbdeliverentry")) != null) {
            deliverToolbar.addItemClickListener((ItemClickListener)this);
        }
    }

    public void initialize() {
        EntryGrid entry = (EntryGrid)this.getControl("billentry");
        if (entry != null) {
            entry.addDataBindListener((EntryGridBindDataListener)this);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent e) {
        String itemKey;
        switch (itemKey = e.getItemKey()) {
            case "selconfig": {
                AbstractGrid billentry;
                int focusEntryRow;
                if (e.isCancel() || (focusEntryRow = (billentry = (AbstractGrid)this.getControl("billentry")).getEntryState().getFocusRow()) == -1) break;
                String changetype = (String)this.getModel().getValue("entrychangetype", focusEntryRow);
                if (ChangeTypeEnum.CANCEL.getValue().equals(changetype)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u884c\u4e0d\u5141\u8bb8\u9009\u914d\u3002", (String)"XSSalesOrderPlugin_0", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                if (!ChangeTypeEnum.UPDATE.getValue().equals(changetype)) break;
                BigDecimal associatedQty = (BigDecimal)this.getModel().getValue("associatedqty", focusEntryRow);
                BigDecimal purJoinQty = (BigDecimal)this.getModel().getValue("purjoinqty", focusEntryRow);
                BigDecimal arJoinQty = (BigDecimal)this.getModel().getValue("arjoinqty", focusEntryRow);
                BigDecimal cfmJoinQty = (BigDecimal)this.getModel().getValue("cfmjoinqty", focusEntryRow);
                BigDecimal transapplyqty = (BigDecimal)this.getModel().getValue("transapplyqty", focusEntryRow);
                BigDecimal backqty = (BigDecimal)this.getModel().getValue("backqty", focusEntryRow);
                if (!(associatedQty != null && associatedQty.compareTo(BigDecimal.ZERO) != 0 || purJoinQty != null && purJoinQty.compareTo(BigDecimal.ZERO) != 0 || arJoinQty != null && arJoinQty.compareTo(BigDecimal.ZERO) != 0 || cfmJoinQty != null && cfmJoinQty.compareTo(BigDecimal.ZERO) != 0 || transapplyqty != null && transapplyqty.compareTo(BigDecimal.ZERO) != 0) && (backqty == null || backqty.compareTo(BigDecimal.ZERO) == 0)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5173\u8054\u6570\u91cf/\u5173\u8054\u5e94\u6536\u6570\u91cf/\u5173\u8054\u786e\u8ba4\u6570\u91cf/\u5173\u8054\u91c7\u8d2d\u6570\u91cf/\u5df2\u8c03\u62e8\u7533\u8bf7\u6570\u91cf/\u5df2\u9000\u5e93\u6570\u91cf\u7b49\u4e8e0\u65f6\uff0c\u624d\u5141\u8bb8\u53d8\u66f4\u914d\u7f6e\u53f7\u3002", (String)"XSSalesOrderPlugin_1", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            case "plan_modifyrow": {
                if (e.isCancel()) break;
                int materialEntryIndex = this.getModel().getEntryCurrentRowIndex("billentry");
                if (materialEntryIndex < 0) {
                    e.setCancel(true);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u5b9a\u7269\u6599\u660e\u7ec6\u884c\u540e\u518d\u4fee\u6539\u53d1\u8d27\u8ba1\u5212\u3002", (String)"XSalesOrderPlugin_12", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    return;
                }
                String entryChangeType = (String)this.getModel().getValue("entrychangetype", materialEntryIndex);
                if (!ChangeTypeEnum.CANCEL.getValue().equals(entryChangeType)) break;
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7269\u6599\u660e\u7ec6\u7684\u53d8\u66f4\u65b9\u5f0f\u4e3a\u201c\u53d6\u6d88\u201d\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"XSalesOrderPlugin_13", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                return;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String billcretype = this.getPageCache().get("billcretype");
        if (!BillImportHelper.isManual((String)billcretype)) {
            return;
        }
        if (PropertyChangeHelper.isStopPropertyChange((IPageCache)this.getPageCache())) {
            return;
        }
        String fieldKey = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        switch (fieldKey) {
            case "linetype": {
                for (int i = 0; i < changeSet.length; ++i) {
                    if (!CommonUtils.isRealChanged((ChangeData)changeSet[i])) continue;
                    this.changeLineType(changeSet[i].getOldValue(), changeSet[i].getNewValue(), changeSet[i].getRowIndex());
                }
                break;
            }
            case "entrychangetype": {
                for (int i = 0; i < changeSet.length; ++i) {
                    if (!CommonUtils.isRealChanged((ChangeData)changeSet[i])) continue;
                    this.changeEntryChangeType(changeSet[i]);
                }
                break;
            }
        }
    }

    private void changeLineType(Object oldValue, Object newValue, int rowIndex) {
        if (oldValue != null && newValue == null) {
            PropertyChangeHelper.stopPropertyChange((IPageCache)this.getPageCache());
            this.getModel().setValue("linetype", ((DynamicObject)oldValue).getPkValue(), rowIndex);
            PropertyChangeHelper.releasePropertyChange((IPageCache)this.getPageCache());
            return;
        }
        if (ChangeTypeEnum.ADDNEW.getValue().equals(this.getModel().getValue("entrychangetype", rowIndex))) {
            if (KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) {
                String productType = (String)this.getModel().getValue("producttype", rowIndex);
                if (ProductTypeEnum.KITPARENT.getValue().equals(productType)) {
                    String msg = ResManager.loadKDString((String)"\u5207\u6362\u201c\u884c\u7c7b\u578b\u201d\u5c06\u6e05\u9664\u5f53\u524d\u5206\u5f55\u7269\u6599\u4fe1\u606f\u5e76\u8054\u52a8\u5220\u9664\u5bf9\u5e94\u5957\u4ef6\u5b50\u9879\u7269\u6599\uff0c\u662f\u5426\u5207\u6362\uff1f", (String)"XSSalesOrderPlugin_3", (String)"scmc-sm-formplugin", (Object[])new Object[0]);
                    ConfirmCallBackListener callBack = new ConfirmCallBackListener(CONFIRM_KITLINETYPE, (IFormPlugin)this);
                    this.getView().showConfirm(msg, MessageBoxOptions.YesNo, ConfirmTypes.Default, callBack);
                    this.getView().getPageCache().put(CACHE_KITLINETYPE, oldValue == null ? null : ((DynamicObject)oldValue).getPkValue().toString());
                    return;
                }
                if (ProductTypeEnum.KITCHILD.getValue().equals(productType)) {
                    DynamicObject parentRow = this.getParentEntry(rowIndex);
                    if (parentRow != null) {
                        DynamicObject kitBom = parentRow.getDynamicObject("bom");
                        DynamicObject material = parentRow.getDynamicObject("material");
                        if (kitBom != null && material != null && KitStructCtlEnum.NONADJ.getValue().equals(material.getString("kitstructctl"))) {
                            return;
                        }
                    }
                    String msg = ResManager.loadKDString((String)"\u5207\u6362\u201c\u884c\u7c7b\u578b\u201d\u5c06\u6e05\u9664\u5f53\u524d\u5206\u5f55\u7269\u6599\u4fe1\u606f\uff0c\u662f\u5426\u5207\u6362\uff1f", (String)"XSSalesOrderPlugin_2", (String)"scmc-sm-formplugin", (Object[])new Object[0]);
                    ConfirmCallBackListener callBack = new ConfirmCallBackListener(CONFIRM_KITLINETYPE, (IFormPlugin)this);
                    this.getView().showConfirm(msg, MessageBoxOptions.YesNo, ConfirmTypes.Default, callBack);
                    this.getView().getPageCache().put(CACHE_KITLINETYPE, oldValue == null ? null : ((DynamicObject)oldValue).getPkValue().toString());
                    return;
                }
            }
            ConfirmCallBackListener callBack = new ConfirmCallBackListener(CONFIRM_LINETYPE, (IFormPlugin)this);
            this.getView().showConfirm(null, ResManager.loadKDString((String)"\u5207\u6362\u201c\u884c\u7c7b\u578b\u201d\u5c06\u6e05\u9664\u5f53\u524d\u5206\u5f55\u7269\u6599\u4fe1\u606f\uff0c\u662f\u5426\u5207\u6362\uff1f", (String)"XSSalesOrderPlugin_2", (String)"scmc-sm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, callBack, null, String.valueOf(rowIndex));
            this.getView().getPageCache().put(CACHE_LINETYPE, oldValue == null ? null : ((DynamicObject)oldValue).getPkValue().toString());
        } else {
            this.setSupplytransEnable(rowIndex);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "rec_modifyrow": {
                SalOrderRecPlanHelper.reCalcuRecPlanAmount((IFormView)this.getView());
                SalOrderRecPlanHelper.changeUnRemainAmount((IDataModel)this.getModel());
                break;
            }
            case "modifyrow": {
                EntryGrid entryGrid;
                int[] rows;
                if (!KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName()) || (rows = (entryGrid = (EntryGrid)this.getView().getControl("billentry")).getSelectRows()).length <= 0) break;
                IDataEntityType dt = this.getModel().getDataEntity().getDataEntityType();
                String[] unEnableProperty = ChangeModelHelper.getUnEnableProperty((IDataEntityType)dt, (String)"billentry");
                String[] enableProperty = ChangeModelHelper.getEnableProperty((IDataEntityType)dt, (String)"billentry");
                HashSet<Integer> changedRows = new HashSet<Integer>(8);
                for (int rowIndex : rows) {
                    changedRows.add(rowIndex);
                }
                for (int rowIndex : rows) {
                    Integer parentRowIndex;
                    String productType = (String)this.getModel().getValue("producttype", rowIndex);
                    if (ProductTypeEnum.KITPARENT.getValue().equals(productType)) {
                        List<Integer> childIndexList = this.getAllChildEntry(rowIndex);
                        for (Integer childRowIndex : childIndexList) {
                            String changeType = (String)this.getModel().getValue("entrychangetype", childRowIndex.intValue());
                            if (!ChangeTypeEnum.CANCEL.getValue().equals(changeType) || !changedRows.add(childRowIndex)) continue;
                            this.getModel().setValue("entrychangetype", (Object)ChangeTypeEnum.UPDATE.getValue(), childRowIndex.intValue());
                            this.getView().setEnable(Boolean.FALSE, childRowIndex.intValue(), unEnableProperty);
                            this.getView().setEnable(Boolean.TRUE, childRowIndex.intValue(), enableProperty);
                        }
                        continue;
                    }
                    if (!ProductTypeEnum.KITCHILD.getValue().equals(productType) || (parentRowIndex = this.getParentRowIndex(rowIndex)) == null) continue;
                    String changeType = (String)this.getModel().getValue("entrychangetype", parentRowIndex.intValue());
                    if (!ChangeTypeEnum.CANCEL.getValue().equals(changeType) || !changedRows.add(parentRowIndex)) continue;
                    this.getModel().setValue("entrychangetype", (Object)ChangeTypeEnum.UPDATE.getValue(), parentRowIndex.intValue());
                    this.getView().setEnable(Boolean.FALSE, parentRowIndex.intValue(), unEnableProperty);
                    this.getView().setEnable(Boolean.TRUE, parentRowIndex.intValue(), enableProperty);
                }
                if (changedRows == null || changedRows.isEmpty()) break;
                Integer[] temp = changedRows.toArray(new Integer[0]);
                rows = new int[temp.length];
                for (int i = 0; i < temp.length; ++i) {
                    rows[i] = temp[i];
                }
                this.setKitRowEnable(rows);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String backId = event.getCallBackId();
        MessageBoxResult result = event.getResult();
        switch (backId) {
            case "confirm_linetype": {
                if (event.getCustomVaule() == null) {
                    return;
                }
                int rowIndex = Integer.parseInt(event.getCustomVaule());
                if (event.getResult() == MessageBoxResult.Yes) {
                    Boolean storageout;
                    DynamicObject lineType;
                    this.getPageCache().put("changeForceRowMaterial", "true");
                    this.getModel().setValue("material", null, rowIndex);
                    this.getPageCache().remove("changeForceRowMaterial");
                    if (this.getControl("supplytrans") == null || (lineType = (DynamicObject)this.getModel().getValue("linetype", rowIndex)) == null || (storageout = Boolean.valueOf(lineType.getBoolean("storageout"))).booleanValue()) break;
                    this.getModel().setValue("supplytrans", (Object)Boolean.FALSE, rowIndex);
                    break;
                }
                String lineTypeId = this.getView().getPageCache().get(CACHE_LINETYPE);
                this.getModel().beginInit();
                this.getModel().setValue("linetype", (Object)(lineTypeId == null ? null : Long.valueOf(Long.parseLong(lineTypeId))), rowIndex);
                this.getModel().endInit();
                this.getView().updateView("linetype", rowIndex);
                this.setSupplytransEnable(rowIndex);
                break;
            }
            case "confirmXKitLineType": {
                int kitRowIndex = this.getModel().getEntryCurrentRowIndex("billentry");
                if (MessageBoxResult.Yes.equals((Object)result)) {
                    List<Integer> childIndexList;
                    String productType = (String)this.getModel().getValue("producttype", kitRowIndex);
                    if (ProductTypeEnum.KITPARENT.getValue().equals(productType) && (childIndexList = this.getAllChildEntry(kitRowIndex)) != null && !childIndexList.isEmpty()) {
                        Integer[] temp = childIndexList.toArray(new Integer[0]);
                        int[] intArray = new int[temp.length];
                        for (int i = 0; i < temp.length; ++i) {
                            intArray[i] = temp[i];
                        }
                        this.getPageCache().put(ISCONFIRMDELETEKITROW, "true");
                        this.getModel().deleteEntryRows("billentry", intArray);
                        this.getPageCache().put(ISCONFIRMDELETEKITROW, "false");
                    }
                    this.getPageCache().put("changeForceRowMaterial", "true");
                    this.getModel().setValue("material", null, kitRowIndex);
                    this.getPageCache().remove("changeForceRowMaterial");
                    this.getView().updateView();
                    break;
                }
                String lineTypeId = this.getView().getPageCache().get(CACHE_KITLINETYPE);
                this.getModel().beginInit();
                this.getModel().setValue("linetype", (Object)(lineTypeId == null ? null : Long.valueOf(Long.parseLong(lineTypeId))), kitRowIndex);
                this.getModel().endInit();
                this.getView().updateView("linetype", kitRowIndex);
                break;
            }
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        if (KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) {
            String entryName = e.getEntryProp().getName();
            if ("billentry".equals(entryName)) {
                int[] rows = e.getRowIndexs();
                boolean hasParents = false;
                for (int rowIndex : rows) {
                    String productType = (String)this.getModel().getValue("producttype", rowIndex);
                    if (!ProductTypeEnum.KITPARENT.getValue().equals(productType)) continue;
                    hasParents = true;
                    break;
                }
                if (hasParents && !"true".equals(this.getPageCache().get(ISCONFIRMDELETEKITROW)) || "true".equals(this.getPageCache().get(ISCANCELDELROWBECBOM))) {
                    ArrayList<String> oldCancelRows = new ArrayList<String>();
                    if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get("XOrderOldCancelRows"))) {
                        String[] oldCancelRowsStr;
                        String oldCancelRowsString = this.getPageCache().get("XOrderOldCancelRows");
                        for (String rowString : oldCancelRowsStr = oldCancelRowsString.split(",")) {
                            oldCancelRows.add(rowString);
                        }
                    }
                    IDataEntityType dt = this.getModel().getDataEntity().getDataEntityType();
                    String[] unEnableProperty = ChangeModelHelper.getUnEnableProperty((IDataEntityType)dt, (String)"billentry");
                    String[] enableProperty = ChangeModelHelper.getEnableProperty((IDataEntityType)dt, (String)"billentry");
                    for (int rowIndex : rows) {
                        if (oldCancelRows != null && !oldCancelRows.isEmpty() && oldCancelRows.contains(String.valueOf(rowIndex))) continue;
                        String changeType = (String)this.getModel().getValue("entrychangetype", rowIndex);
                        if (!ChangeTypeEnum.CANCEL.getValue().equals(changeType)) continue;
                        this.getModel().setValue("entrychangetype", (Object)ChangeTypeEnum.UPDATE.getValue(), rowIndex);
                        this.getView().setEnable(Boolean.FALSE, rowIndex, unEnableProperty);
                        this.getView().setEnable(Boolean.TRUE, rowIndex, enableProperty);
                    }
                    this.setKitRowEnable(rows);
                }
            }
            this.setEntryEnable();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        boolean stopListener = PluginConnectControllHelper.isStopListener((IPageCache)this.getPageCache(), (String)"beforeF7Select");
        if (stopListener) {
            return;
        }
        String fieldKey = e.getProperty().getName();
    }

    private List<Integer> getAllChildEntry(int parentRowIndex) {
        DynamicObject parentEntry = this.getModel().getEntryRowEntity("billentry", parentRowIndex);
        Long parentPid = parentEntry.getLong("kitpid");
        ArrayList<Integer> childEntryList = new ArrayList<Integer>();
        int rowCount = this.getModel().getEntryRowCount("billentry");
        for (int i = 0; i < rowCount; ++i) {
            Long pID = (Long)this.getModel().getValue("kitpid", i);
            String productType = (String)this.getModel().getValue("producttype", i);
            if (!ProductTypeEnum.KITCHILD.getValue().equals(productType) || parentPid.longValue() != pID.longValue()) continue;
            childEntryList.add(i);
        }
        return childEntryList;
    }

    private List<Integer> getAllNotCancelChildEntry(int parentRowIndex) {
        DynamicObject parentEntry = this.getModel().getEntryRowEntity("billentry", parentRowIndex);
        Long parentPid = parentEntry.getLong("kitpid");
        ArrayList<Integer> childEntryList = new ArrayList<Integer>();
        int rowCount = this.getModel().getEntryRowCount("billentry");
        for (int i = 0; i < rowCount; ++i) {
            Long pID = (Long)this.getModel().getValue("kitpid", i);
            String productType = (String)this.getModel().getValue("producttype", i);
            String changeType = (String)this.getModel().getValue("entrychangetype", i);
            if (!ProductTypeEnum.KITCHILD.getValue().equals(productType) || parentPid.longValue() != pID.longValue() || ChangeTypeEnum.CANCEL.getValue().equals(changeType)) continue;
            childEntryList.add(i);
        }
        return childEntryList;
    }

    private DynamicObject getParentEntry(int childRowIndex) {
        DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("billentry");
        Long pID = (Long)this.getModel().getValue("kitpid", childRowIndex);
        DynamicObject parentEntry = null;
        for (DynamicObject entry : entrys) {
            Long entryPid = entry.getLong("kitpid");
            String productType = entry.getString("producttype");
            if (!ProductTypeEnum.KITPARENT.getValue().equals(productType) || entryPid.longValue() != pID.longValue()) continue;
            parentEntry = entry;
            break;
        }
        return parentEntry;
    }

    private Integer getParentRowIndex(int childRowIndex) {
        DynamicObject childRowEntry = this.getModel().getEntryRowEntity("billentry", childRowIndex);
        Long parentPid = childRowEntry.getLong("kitpid");
        int rowCount = this.getModel().getEntryRowCount("billentry");
        for (int i = 0; i < rowCount; ++i) {
            Long pID = (Long)this.getModel().getValue("kitpid", i);
            String productType = (String)this.getModel().getValue("producttype", i);
            if (!ProductTypeEnum.KITPARENT.getValue().equals(productType) || parentPid.longValue() != pID.longValue()) continue;
            return i;
        }
        return null;
    }

    private void setKitRowEnable(int[] rowIndexs) {
        if (rowIndexs == null) {
            return;
        }
        for (int rowIndex : rowIndexs) {
            this.setKitPriceColumnEnable(rowIndex);
        }
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        if (KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName()) && e.getRows() != null && !e.getRows().isEmpty()) {
            for (RowDataEntity row : e.getRows()) {
                int rowIndex = row.getRowIndex();
                this.setKitPriceColumnEnable(rowIndex);
                this.setSupplytransEnable(rowIndex);
            }
        }
    }

    public void afterBindData(EventObject e) {
        if (KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) {
            int rowCount = this.getModel().getEntryRowCount("billentry");
            for (int i = 0; i < rowCount; ++i) {
                this.setKitPriceColumnEnable(i);
                this.setSupplytransEnable(i);
            }
        }
    }

    private void setEntryEnable() {
        if (KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) {
            int rowCount = this.getModel().getEntryRowCount("billentry");
            for (int i = 0; i < rowCount; ++i) {
                this.setKitPriceColumnEnable(i);
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs evt) {
        if (KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) {
            int rowCount = this.getModel().getEntryRowCount("billentry");
            for (int i = 0; i < rowCount; ++i) {
                this.setKitPriceColumnEnable(i);
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        String key;
        int row = evt.getRow();
        if (evt.getSource() instanceof EntryGrid && row > -1 && "billentry".equals(key = ((EntryGrid)evt.getSource()).getKey())) {
            this.setKitPriceColumnEnable(row);
            this.setSupplytransEnable(row);
        }
    }

    private void setSupplytransEnable(int rowIndex) {
        DynamicObject lineType;
        if (this.getControl("supplytrans") != null && (lineType = (DynamicObject)this.getModel().getValue("linetype", rowIndex)) != null) {
            Boolean storageout = lineType.getBoolean("storageout");
            if (!storageout.booleanValue()) {
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"supplytrans"});
                this.getModel().setValue("supplytrans", (Object)Boolean.FALSE, rowIndex);
            } else {
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"supplytrans"});
            }
        }
    }

    private void setKitPriceColumnEnable(int rowIndex) {
        DynamicObject parentRow;
        ArrayList lockColumns = new ArrayList(8);
        ArrayList<String> unlockColumns = new ArrayList<String>(8);
        IDataEntityType dt = this.getModel().getDataEntity().getDataEntityType();
        String[] unEnableProperty = ChangeModelHelper.getUnEnableProperty((IDataEntityType)dt, (String)"billentry");
        HashSet<String> unEnableColumns = new HashSet<String>(8);
        if (unEnableProperty != null && unEnableProperty.length > 0) {
            unEnableColumns.addAll(Arrays.asList(unEnableProperty));
        }
        HashSet<String> enableColumn = new HashSet<String>();
        enableColumn.addAll(Arrays.asList(BillTplEntryConst.KITAMOUNTANDPRICEFIELDS));
        List wer = KitSalesHelper.getAmountAndQtyFieldList((DynamicObject)this.getModel().getDataEntity(true), (String)"billentry");
        enableColumn.addAll(wer);
        boolean isLock = false;
        boolean isUnLock = false;
        String productType = (String)this.getModel().getValue("producttype", rowIndex);
        String priceModel = (String)this.getModel().getValue("pricemodel", rowIndex);
        if (ProductTypeEnum.KITPARENT.getValue().equals(productType)) {
            if (PriceModelEnum.CHILD.getValue().equals(priceModel)) {
                isLock = true;
            } else {
                isUnLock = true;
            }
        } else if (ProductTypeEnum.KITCHILD.getValue().equals(productType)) {
            if (PriceModelEnum.PARENT.getValue().equals(priceModel)) {
                isLock = true;
            } else {
                isUnLock = true;
            }
        }
        if (isLock) {
            lockColumns.addAll(enableColumn);
        }
        if (isUnLock) {
            String changeType = (String)this.getModel().getValue("entrychangetype", rowIndex);
            for (String column : enableColumn) {
                if (ChangeTypeEnum.CANCEL.getValue().equals(changeType)) {
                    lockColumns.add(column);
                    continue;
                }
                if (unEnableColumns.contains(column) && !ChangeTypeEnum.ADDNEW.getValue().equals(changeType)) continue;
                unlockColumns.add(column);
            }
        }
        if (ProductTypeEnum.KITCHILD.getValue().equals(productType) && (parentRow = this.getParentEntry(rowIndex)) != null) {
            DynamicObject kitBom = parentRow.getDynamicObject("bom");
            DynamicObject material = parentRow.getDynamicObject("material");
            if (kitBom != null && material != null && KitStructCtlEnum.NONADJ.getValue().equals(material.getString("kitstructctl"))) {
                lockColumns.add("qty");
                lockColumns.add("auxqty");
                lockColumns.add("unit");
                lockColumns.add("material");
            } else {
                DynamicObject auxUnit;
                String changeType = (String)this.getModel().getValue("entrychangetype", rowIndex);
                if ((!ChangeTypeEnum.CANCEL.getValue().equals(changeType) && !unEnableColumns.contains("auxunit") || ChangeTypeEnum.ADDNEW.getValue().equals(changeType)) && (auxUnit = (DynamicObject)this.getModel().getValue("auxunit", rowIndex)) != null) {
                    unlockColumns.add("auxqty");
                }
            }
        }
        if (ProductTypeEnum.KITCHILD.getValue().equals(productType)) {
            String transfermodel = (String)this.getModel().getValue("kittransfermodel", rowIndex);
            if (KitTransferModelEnum.KIT.getValue().equals(transfermodel)) {
                lockColumns.add("e_stockorg");
                lockColumns.add("deliverydate");
                lockColumns.add("iscontrolday");
                lockColumns.add("deliveradvdays");
                lockColumns.add("deliverdelaydays");
            } else if (KitTransferModelEnum.NONKIT.getValue().equals(transfermodel)) {
                String changeType = (String)this.getModel().getValue("entrychangetype", rowIndex);
                for (String column : deliverColumns) {
                    if (ChangeTypeEnum.CANCEL.getValue().equals(changeType)) {
                        lockColumns.add(column);
                        continue;
                    }
                    if (!unEnableColumns.contains(column) || ChangeTypeEnum.ADDNEW.getValue().equals(changeType)) {
                        unlockColumns.add(column);
                        continue;
                    }
                    lockColumns.add(column);
                }
            }
            lockColumns.add("iscontrolqty");
            lockColumns.add("deliverratedown");
            lockColumns.add("deliverrateup");
            lockColumns.add("supplytrans");
            lockColumns.add("purorg");
            lockColumns.add("supplier");
        }
        if (lockColumns != null && !lockColumns.isEmpty()) {
            for (String column : lockColumns) {
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{column});
            }
        }
        if (unlockColumns != null && !unlockColumns.isEmpty()) {
            for (String column : unlockColumns) {
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{column});
            }
        }
    }

    private void changeEntryChangeType(ChangeData changeSet) {
        int rowIndex = changeSet.getRowIndex();
        DynamicObject entry = this.getModel().getEntryRowEntity("billentry", rowIndex);
        DynamicObjectCollection deliverEntrys = entry.getDynamicObjectCollection("orderdeliverentry");
        if (!deliverEntrys.isEmpty()) {
            if (ChangeTypeEnum.CANCEL.getValue().equals(changeSet.getNewValue())) {
                ArrayList<DynamicObject> needDelete = new ArrayList<DynamicObject>(8);
                for (DynamicObject dEntry : deliverEntrys) {
                    String dChangeType = dEntry.getString("delentrychangetype");
                    if (ChangeTypeEnum.UPDATE.getValue().equals(dChangeType)) {
                        dEntry.set("delentrychangetype", (Object)ChangeTypeEnum.CANCEL.getValue());
                        continue;
                    }
                    if (!ChangeTypeEnum.ADDNEW.getValue().equals(dChangeType)) continue;
                    needDelete.add(dEntry);
                }
                if (!needDelete.isEmpty()) {
                    deliverEntrys.removeAll(needDelete);
                }
            } else if (ChangeTypeEnum.UPDATE.getValue().equals(changeSet.getNewValue())) {
                for (DynamicObject dEntry : deliverEntrys) {
                    String dChangeType = dEntry.getString("delentrychangetype");
                    if (!ChangeTypeEnum.CANCEL.getValue().equals(dChangeType)) continue;
                    dEntry.set("delentrychangetype", (Object)ChangeTypeEnum.UPDATE.getValue());
                }
            }
            this.getView().updateView("orderdeliverentry");
        }
    }
}

