/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.formplugin.order;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.SubEntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.EntityOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mpscmm.msbd.common.enums.KitStructCtlEnum;
import kd.mpscmm.msbd.common.enums.KitTransferModelEnum;
import kd.mpscmm.msbd.common.enums.PriceModelEnum;
import kd.scmc.sm.business.helper.BillImportHelper;
import kd.scmc.sm.business.helper.KitSalesHelper;
import kd.scmc.sm.business.helper.MetaDataHelper;
import kd.scmc.sm.business.helper.OrgHelper;
import kd.scmc.sm.business.helper.PropertyChangeHelper;
import kd.scmc.sm.business.helper.RowOPHelper;
import kd.scmc.sm.business.helper.SalOrderRecPlanHelper;
import kd.scmc.sm.consts.BillTplEntryConst;
import kd.scmc.sm.consts.SalesOrderEntryConst;
import kd.scmc.sm.enums.ChangeTypeEnum;
import kd.scmc.sm.enums.DiscountTypeEnum;
import kd.scmc.sm.enums.ProductTypeEnum;
import kd.scmc.sm.util.CommonUtils;

public class XSalesOrderPlugin
extends AbstractBillPlugIn
implements RowClickEventListener,
ClickListener,
EntryGridBindDataListener {
    public static final String BTN_MODIFY_ENTRY = "modify_entry";
    public static final String BTN_MODIFY_PAY = "modify_rec";
    public static final String BTN_MODIFY_TERM = "modify_clause";
    public static final String BTN_MODIFY_DELIVER = "modify_deliver";
    public static final String BTN_DELETEROW_ENTRY = "deleterow";
    public static final String BTN_DELETEROW_PAY = "rec_deleteentry";
    public static final String REC_DELETEROW = "rec_deleterow";
    public static final String BTN_DELETEROW_TERM = "cond_deleteentry";
    public static final String BTN_DELETEROW_DELIVER = "plan_deleteentry";
    public static final String PLAN_DELETEROW = "plan_deleterow";
    public static final String BTN_SEELOG = "seelog";
    public static final String BTN_PLAN_ADDROW = "plan_addrow";
    public static final String BAR_CHANGEDETAIL = "bar_changedetail";
    public static final String BAR_REFRESH = "bar_refresh";
    private static final String CONFIRM_LINETYPE = "confirm_linetype";
    private static final String CACHE_LINETYPE = "cache_linetype";
    private static final String ISCONFIRMDELETEKITROW = "isConfirmDeleteKitRow";
    private static final String CONFIRM_KITLINETYPE = "confirmXKitLineType";
    private static final String CACHE_KITLINETYPE = "cacheXKitLineType";
    private static final String EXPANDKITPARENTROW = "expandKitParentRow";
    private static final String EXPANDKITBEFOREDELETE = "expandKitBeforeDelete";
    private static final String[] getEnableField = new String[]{"biztime", "reason", "comment", "receiveaddress", "reclinkman", "bizdate", "operator", "dept", "linkman", "address"};
    private static final String[] getEnableBillEntryField = new String[]{"qty", "auxqty", "price", "taxrate", "priceandtax", "remark", "iscontrolqty", "deliverratedown", "deliverrateup", "deliverqtydown", "deliverqtyup", "supplier"};
    private static final String[] getBackEnableBillEntryField = new String[]{"qty", "auxqty", "taxrateid", "discountrate", "discounttype", "amount", "amountandtax", "iscontrolqty", "deliverratedown", "deliverrateup", "deliverqtydown", "deliverqtyup", "remark", "supplier"};
    private static final String[] getEnableDeliverEntryField = new String[]{"d_plandeliverydate", "d_planqty", "d_remark", "d_plandate"};
    private static final String[] isPayRateTrue = new String[]{"r_itemname", "r_duedate", "r_recadvancerate"};
    private static final String[] isPayRateFalse = new String[]{"r_itemname", "r_duedate", "r_recadvanceamount"};
    private static final String[] deliverColumns = new String[]{"e_stockorg", "deliverydate", "iscontrolday", "deliveradvdays", "deliverdelaydays"};

    public void registerListener(EventObject e) {
        EntryGrid deliverEntryGrid;
        EntryGrid recEntryGrid;
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billentry");
        if (entryGrid != null) {
            entryGrid.addRowClickListener((RowClickEventListener)this);
            entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        }
        if ((recEntryGrid = (EntryGrid)this.getView().getControl("recplanentry")) != null) {
            recEntryGrid.addRowClickListener((RowClickEventListener)this);
        }
        if ((deliverEntryGrid = (EntryGrid)this.getView().getControl("orderdeliverentry")) != null) {
            deliverEntryGrid.addRowClickListener((RowClickEventListener)this);
        }
        this.addItemClickListeners(new String[]{"advcontoolbarap2"});
    }

    public void initialize() {
        EntryGrid entry = (EntryGrid)this.getControl("billentry");
        if (entry != null) {
            entry.addDataBindListener((EntryGridBindDataListener)this);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billentry");
        if (entryGrid != null) {
            entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent e) {
        String itemKey = e.getItemKey();
        boolean checkPermission = this.checkPermission(itemKey);
        if (!checkPermission) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u64cd\u4f5c\u6743\u9650\u3002", (String)"XSalesOrderPlugin_6", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        switch (itemKey) {
            case "bar_save": {
                Date bizdate = (Date)this.getModel().getValue("bizdate");
                if (bizdate != null) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53d8\u66f4\u5355\u65e5\u671f\u3002", (String)"XSalesOrderPlugin_7", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            case "bar_refresh": 
            case "bar_changedetail": {
                Long pk = (Long)this.getModel().getValue("id");
                HashSet<Long> pkSet = new HashSet<Long>();
                pkSet.add(pk);
                DynamicObject[] deliverBills = RowOPHelper.getBills(pkSet, (String)this.getView().getEntityId());
                if (deliverBills.length != 0) break;
                String tips = ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664\u3002", (String)"DeliverNoticeRowClosePlugin_9", (String)"scmc-sm-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(tips);
                e.setCancel(true);
                return;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "modify_rec": {
                SalOrderRecPlanHelper.reCalcuRecPlanAmount((IFormView)this.getView());
                SalOrderRecPlanHelper.changeUnRemainAmount((IDataModel)this.getModel());
                break;
            }
        }
    }

    private boolean checkPermission(String itemKey) {
        boolean hasPer = true;
        switch (itemKey) {
            case "bar_changedetail": {
                hasPer = this.getUserPermission("01RKP4/KBG34");
                break;
            }
        }
        return hasPer;
    }

    private boolean getUserPermission(String permissionId) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        DynamicObject value = (DynamicObject)this.getModel().getValue("org");
        String formId = this.getView().getEntityId();
        String appId = this.getModel().getDataEntityType().getAppId();
        int checkPermission = OrgHelper.checkPermission((Long)userId, (Long)((Long)value.getPkValue()), (String)appId, (String)formId, (String)permissionId);
        return 1 == checkPermission;
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(EXPANDKITPARENTROW)) || StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(EXPANDKITBEFOREDELETE))) {
            return;
        }
        try (TraceSpan span = Tracer.create((String)"XSalesOrderPlugin", (String)"entryGridBindData");){
            IDataEntityType dt = this.getModel().getDataEntity().getDataEntityType();
            this.getView().setEnable(Boolean.FALSE, MetaDataHelper.getAllPropertyNameNoEntry((IDataEntityType)dt));
            this.getView().setEnable(Boolean.TRUE, this.getEnableField());
            String[] billEntry1 = MetaDataHelper.getAllPropertyName4Entry((IDataEntityType)dt, (String)"billentry");
            String[] billEntry2 = this.getEntryEnableField();
            String[] billEntry3 = this.getDifferentFromString(billEntry1, billEntry2);
            for (RowDataEntity row : e.getRows()) {
                int i = row.getRowIndex();
                Boolean inputMount = (Boolean)this.getModel().getValue("inputamount");
                if (ChangeTypeEnum.UPDATE.getValue().equals(this.getModel().getValue("entrychangetype", i))) {
                    if (inputMount.booleanValue()) {
                        String[] billEntry4 = getBackEnableBillEntryField;
                        billEntry3 = this.getDifferentFromString(billEntry1, billEntry4);
                    }
                    this.getView().setEnable(Boolean.FALSE, i, billEntry3);
                } else if (ChangeTypeEnum.CANCEL.getValue().equals(this.getModel().getValue("entrychangetype", i))) {
                    this.getView().setEnable(Boolean.FALSE, i, billEntry1);
                }
                int rowIndex = row.getRowIndex();
                this.setKitPriceColumnEnable(rowIndex);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.beforeBindData(e);
        try (TraceSpan span = Tracer.create((String)"XSalesOrderPlugin", (String)"afterBindData");){
            this.getModel().clearNoDataRow();
            this.getModel().forceClearNoDataRow();
            IDataEntityType dt = this.getModel().getDataEntity().getDataEntityType();
            int recEntryCount = this.getModel().getEntryRowCount("recplanentry");
            String[] payEntry1 = MetaDataHelper.getAllPropertyName4Entry((IDataEntityType)dt, (String)"recplanentry");
            String[] payEntry2 = this.getEnablePayEntryField(Boolean.parseBoolean(this.getModel().getValue("ispayrate").toString()));
            String[] payEntry3 = this.getDifferentFromString(payEntry1, payEntry2);
            for (int i = 0; i < recEntryCount; ++i) {
                String changeType = (String)this.getModel().getValue("recentrychangetype", i);
                if (ChangeTypeEnum.UPDATE.getValue().equals(changeType)) {
                    this.getView().setEnable(Boolean.FALSE, i, payEntry3);
                    continue;
                }
                if (!ChangeTypeEnum.CANCEL.getValue().equals(changeType)) continue;
                this.getView().setEnable(Boolean.FALSE, i, payEntry1);
            }
            int deliverEntryCount = this.getModel().getEntryRowCount("orderdeliverentry");
            String[] deliverEntry1 = MetaDataHelper.getAllPropertyName4Entry((IDataEntityType)dt, (String)"orderdeliverentry");
            String[] deliverEntry2 = getEnableDeliverEntryField;
            String[] deliverEntry3 = this.getDifferentFromString(deliverEntry1, deliverEntry2);
            for (int i = 0; i < deliverEntryCount; ++i) {
                String changeType = (String)this.getModel().getValue("delentrychangetype", i);
                if (ChangeTypeEnum.UPDATE.getValue().equals(changeType)) {
                    this.getView().setEnable(Boolean.FALSE, i, deliverEntry3);
                    continue;
                }
                if (!ChangeTypeEnum.CANCEL.getValue().equals(changeType)) continue;
                this.getView().setEnable(Boolean.FALSE, i, deliverEntry1);
            }
            this.getView().setVisible(Boolean.FALSE, this.getUnVisibleField());
            if (!"1".equals(this.getPageCache().get("inputamount")) && ((Boolean)this.getModel().getValue("inputamount")).booleanValue()) {
                Boolean istax = (Boolean)this.getModel().getValue("istax");
                if (istax.booleanValue()) {
                    this.getView().setEnable(Boolean.TRUE, -1, new String[]{"amountandtax"});
                    this.getView().setEnable(Boolean.FALSE, -1, new String[]{"amount"});
                } else {
                    this.getView().setEnable(Boolean.FALSE, -1, new String[]{"amountandtax"});
                    this.getView().setEnable(Boolean.TRUE, -1, new String[]{"amount"});
                }
            }
            int rowCount = this.getModel().getEntryRowCount("billentry");
            for (int i = 0; i < rowCount; ++i) {
                this.setKitPriceColumnEnable(i);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        if (afterDoOperationEventArgs.getSource() instanceof EntityOperate) {
            try (TraceSpan span = Tracer.create((String)"XSalesOrderPlugin", (String)("beforeDoOperation: " + ((EntityOperate)afterDoOperationEventArgs.getSource()).getOperateKey()));){
                if ("unaudit".equals(((EntityOperate)afterDoOperationEventArgs.getSource()).getOperateKey())) {
                    this.getView().updateView();
                }
                if ("changedetail".equals(((EntityOperate)afterDoOperationEventArgs.getSource()).getOperateKey())) {
                    IDataModel bill = this.getModel();
                    Long srcBillID = (Long)bill.getValue("srcid");
                    String version = (String)bill.getValue("version");
                    QFilter qFilter1 = new QFilter("srcbillid", "=", (Object)srcBillID);
                    QFilter qFilter2 = new QFilter("xbillid", "=", bill.getValue("id"));
                    QFilter qFilter3 = new QFilter("srcbillversion", "=", (Object)version);
                    DynamicObject xSalOrderBillLog = BusinessDataServiceHelper.loadSingleFromCache((String)"sm_xsalorderlog", (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3});
                    String xMDJson = (String)xSalOrderBillLog.get("xmdjson_tag");
                    FormShowParameter fsp = new FormShowParameter();
                    fsp.setFormId("sm_mdlogshow");
                    fsp.getOpenStyle().setShowType(ShowType.Modal);
                    fsp.setCaption("");
                    fsp.setCustomParam("mdlog", (Object)xMDJson);
                    this.getView().showForm(fsp);
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        block44: {
            if (args.getSource() instanceof EntityOperate) {
                IDataModel bill = this.getModel();
                IDataEntityType dt = this.getModel().getDataEntity().getDataEntityType();
                try (TraceSpan span = Tracer.create((String)"XSalesOrderPlugin", (String)("beforeDoOperation: " + ((EntityOperate)args.getSource()).getOperateKey()));){
                    EntryGrid entryGrid;
                    if (BTN_MODIFY_ENTRY.equals(((EntityOperate)args.getSource()).getOperateKey())) {
                        entryGrid = (EntryGrid)this.getView().getControl("billentry");
                        int[] rows = entryGrid.getSelectRows();
                        if (rows.length == 0) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"XSalesOrderPlugin_8", (String)"scmc-sm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                            args.setCancel(true);
                            return;
                        }
                        if (KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) {
                            HashSet<Integer> needChangeRows = new HashSet<Integer>(8);
                            for (int rowIndex : rows) {
                                Integer parentRowIndex;
                                needChangeRows.add(rowIndex);
                                String productType = (String)this.getModel().getValue("producttype", rowIndex);
                                if (ProductTypeEnum.KITPARENT.getValue().equals(productType)) {
                                    List<Integer> childIndexList = this.getAllChildEntry(rowIndex);
                                    for (Integer childRowIndex : childIndexList) {
                                        String changeType = (String)this.getModel().getValue("entrychangetype", childRowIndex.intValue());
                                        if (!ChangeTypeEnum.CANCEL.getValue().equals(changeType)) continue;
                                        needChangeRows.add(childRowIndex);
                                    }
                                    continue;
                                }
                                if (!ProductTypeEnum.KITCHILD.getValue().equals(productType) || (parentRowIndex = this.getParentRowIndex(rowIndex)) == null) continue;
                                String changeType = (String)this.getModel().getValue("entrychangetype", parentRowIndex.intValue());
                                if (!ChangeTypeEnum.CANCEL.getValue().equals(changeType)) continue;
                                needChangeRows.add(parentRowIndex);
                            }
                            if (needChangeRows != null && !needChangeRows.isEmpty()) {
                                Integer[] temp = needChangeRows.toArray(new Integer[0]);
                                rows = new int[temp.length];
                                for (int i = 0; i < temp.length; ++i) {
                                    rows[i] = temp[i];
                                }
                            }
                        }
                        for (int i = 0; i < rows.length; ++i) {
                            bill.setValue("entrychangetype", (Object)ChangeTypeEnum.UPDATE.getValue(), rows[i]);
                            DynamicObject parent = (DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("billentry").get(rows[i]);
                            DynamicObjectCollection delivers = parent.getDynamicObjectCollection("orderdeliverentry");
                            String[] deliverEntry = MetaDataHelper.getAllPropertyName4Entry((IDataEntityType)dt, (String)"orderdeliverentry");
                            if (delivers == null || delivers.size() <= 0) continue;
                            for (int j = 0; j < delivers.size(); ++j) {
                                DynamicObject deliver = (DynamicObject)delivers.get(j);
                                int seq = deliver.getInt("seq");
                                if (!ChangeTypeEnum.CANCEL.getValue().equals(deliver.getString("delentrychangetype"))) continue;
                                deliver.set("delentrychangetype", (Object)ChangeTypeEnum.UPDATE.getValue());
                                this.getView().setEnable(Boolean.TRUE, seq - 1, deliverEntry);
                            }
                            this.getView().setEnable(Boolean.TRUE, new String[]{BTN_PLAN_ADDROW});
                            this.getView().updateView("orderdeliverentry");
                        }
                        String[] billEntry1 = MetaDataHelper.getAllPropertyName4Entry((IDataEntityType)dt, (String)"billentry");
                        String[] billEntry2 = getEnableBillEntryField;
                        String[] billEntry3 = this.getDifferentFromString(billEntry1, billEntry2);
                        Boolean inputMount = (Boolean)this.getModel().getValue("inputamount");
                        if (inputMount.booleanValue() && "1".equals(this.getPageCache().get("inputamount"))) {
                            String[] billEntry4 = getBackEnableBillEntryField;
                            billEntry3 = this.getDifferentFromString(billEntry1, billEntry4);
                            billEntry2 = billEntry4;
                        }
                        for (int i = 0; i < rows.length; ++i) {
                            this.getView().setEnable(Boolean.FALSE, rows[i], billEntry3);
                            this.getView().setEnable(Boolean.TRUE, rows[i], billEntry2);
                        }
                        if (KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) {
                            this.setKitRowEnable(rows);
                        }
                        this.getView().setEnable(Boolean.TRUE, new String[]{BTN_DELETEROW_ENTRY});
                        this.getView().setEnable(Boolean.FALSE, new String[]{BTN_MODIFY_ENTRY});
                        this.getView().setEnable(Boolean.TRUE, new String[]{BTN_PLAN_ADDROW});
                        break block44;
                    }
                    if (BTN_MODIFY_PAY.equals(((EntityOperate)args.getSource()).getOperateKey())) {
                        entryGrid = (EntryGrid)this.getView().getControl("recplanentry");
                        int[] rows = entryGrid.getSelectRows();
                        if (rows.length == 0) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"XSalesOrderPlugin_8", (String)"scmc-sm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                            args.setCancel(true);
                            return;
                        }
                        for (int i = 0; i < rows.length; ++i) {
                            bill.setValue("recentrychangetype", (Object)ChangeTypeEnum.UPDATE.getValue(), rows[i]);
                        }
                        String[] payEntry1 = MetaDataHelper.getAllPropertyName4Entry((IDataEntityType)dt, (String)"recplanentry");
                        String[] payEntry2 = this.getEnablePayEntryField(Boolean.parseBoolean(this.getModel().getValue("ispayrate").toString()));
                        String[] payEntry3 = this.getDifferentFromString(payEntry1, payEntry2);
                        for (int i = 0; i < rows.length; ++i) {
                            this.getView().setEnable(Boolean.FALSE, rows[i], payEntry3);
                            this.getView().setEnable(Boolean.TRUE, rows[i], payEntry2);
                        }
                        this.getView().setEnable(Boolean.TRUE, new String[]{BTN_DELETEROW_PAY});
                        this.getView().setEnable(Boolean.FALSE, new String[]{BTN_MODIFY_PAY});
                        this.getView().setEnable(Boolean.TRUE, new String[]{REC_DELETEROW});
                    } else if (BTN_MODIFY_DELIVER.equals(((EntityOperate)args.getSource()).getOperateKey())) {
                        entryGrid = (EntryGrid)this.getView().getControl("orderdeliverentry");
                        int[] rows = entryGrid.getSelectRows();
                        if (rows.length == 0) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"XSalesOrderPlugin_8", (String)"scmc-sm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                            args.setCancel(true);
                            return;
                        }
                        for (int i = 0; i < rows.length; ++i) {
                            bill.setValue("delentrychangetype", (Object)ChangeTypeEnum.UPDATE.getValue(), rows[i]);
                        }
                        String[] deliverEntry1 = MetaDataHelper.getAllPropertyName4Entry((IDataEntityType)dt, (String)"orderdeliverentry");
                        String[] deliverEntry2 = getEnableDeliverEntryField;
                        String[] deliverEntry3 = this.getDifferentFromString(deliverEntry1, deliverEntry2);
                        for (int i = 0; i < rows.length; ++i) {
                            this.getView().setEnable(Boolean.FALSE, rows[i], deliverEntry3);
                            this.getView().setEnable(Boolean.TRUE, rows[i], deliverEntry2);
                        }
                        this.getView().setEnable(Boolean.TRUE, new String[]{BTN_DELETEROW_DELIVER});
                        this.getView().setEnable(Boolean.FALSE, new String[]{BTN_MODIFY_DELIVER});
                        this.getView().setEnable(Boolean.TRUE, new String[]{PLAN_DELETEROW});
                    }
                }
            }
        }
        super.beforeDoOperation(args);
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        IDataModel bill = this.getModel();
        String entryName = e.getEntryProp().getName();
        IDataEntityType dt = this.getModel().getDataEntity().getDataEntityType();
        int[] rows = e.getRowIndexs();
        DynamicObject billtype = (DynamicObject)bill.getValue("billtype");
        if (!(KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName()) && "true".equals(this.getPageCache().get(ISCONFIRMDELETEKITROW)) || rows.length <= 1)) {
            e.setCancel(true);
        }
        if (e.isCancel()) {
            e.setCancel(true);
            return;
        }
        try (TraceSpan span = Tracer.create((String)"XSalesOrderPlugin", (String)("beforeDeleteRow: " + entryName));){
            if ("billentry".equals(entryName)) {
                if (!KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName()) || !"true".equals(this.getPageCache().get(ISCONFIRMDELETEKITROW))) {
                    String productType = (String)this.getModel().getValue("producttype", e.getRowIndexs()[0]);
                    if (ProductTypeEnum.KITPARENT.getValue().equals(productType)) {
                        e.setCancel(true);
                        return;
                    }
                    if (ChangeTypeEnum.UPDATE.getValue().equals(bill.getValue("entrychangetype", e.getRowIndexs()[0]))) {
                        boolean check = true;
                        for (int s = 0; s < SalesOrderEntryConst.getJoinQtyFields().size(); ++s) {
                            String field = (String)SalesOrderEntryConst.getJoinQtyFields().get(s);
                            if (!(((BigDecimal)this.getModel().getValue(field, e.getRowIndexs()[0])).doubleValue() > 0.0) && (!billtype.get("number").equals("sm_XSalesOrder_SERV_BT_S") || !(((BigDecimal)this.getModel().getValue("arjoinqty", e.getRowIndexs()[0])).doubleValue() > 0.0))) continue;
                            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7269\u6599\u660e\u7ec6\u5df2\u53d1\u751f\u4e1a\u52a1\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"XSalesOrderPlugin_2", (String)"scmc-sm-formplugin", (Object[])new Object[0]), e.getRowIndexs()[0] + 1));
                            check = false;
                            break;
                        }
                        if (check) {
                            this.getModel().setValue("entrychangetype", (Object)ChangeTypeEnum.CANCEL.getValue(), e.getRowIndexs()[0]);
                            DynamicObject parent = (DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("billentry").get(e.getRowIndexs()[0]);
                            DynamicObjectCollection delivers = parent.getDynamicObjectCollection("orderdeliverentry");
                            String[] deliverEntry = MetaDataHelper.getAllPropertyName4Entry((IDataEntityType)dt, (String)"orderdeliverentry");
                            if (delivers != null && delivers.size() > 0) {
                                for (int i = 0; i < delivers.size(); ++i) {
                                    DynamicObject deliver = (DynamicObject)delivers.get(i);
                                    int seq = deliver.getInt("seq");
                                    if (ChangeTypeEnum.UPDATE.getValue().equals(deliver.getString("delentrychangetype")) || ChangeTypeEnum.CANCEL.getValue().equals(deliver.getString("delentrychangetype"))) {
                                        deliver.set("delentrychangetype", (Object)ChangeTypeEnum.CANCEL.getValue());
                                        this.getView().setEnable(Boolean.FALSE, seq - 1, deliverEntry);
                                        continue;
                                    }
                                    if (!ChangeTypeEnum.ADDNEW.getValue().equals(deliver.getString("delentrychangetype"))) continue;
                                    delivers.remove((Object)deliver);
                                    --i;
                                }
                                this.getView().setEnable(Boolean.FALSE, new String[]{BTN_PLAN_ADDROW});
                                this.getView().updateView("orderdeliverentry");
                            }
                            this.getView().setEnable(Boolean.FALSE, new String[]{BTN_DELETEROW_ENTRY});
                            this.getView().setEnable(Boolean.TRUE, new String[]{BTN_MODIFY_ENTRY});
                            String[] billEntry1 = MetaDataHelper.getAllPropertyName4Entry((IDataEntityType)this.getModel().getDataEntity().getDataEntityType(), (String)"billentry");
                            this.getView().setEnable(Boolean.FALSE, e.getRowIndexs()[0], billEntry1);
                        }
                        e.setCancel(true);
                    } else if (ChangeTypeEnum.ADDNEW.getValue().equals(bill.getValue("entrychangetype", e.getRowIndexs()[0]))) {
                    } else {
                        e.setCancel(true);
                    }
                } else {
                    ArrayList<Integer> needRealDelete = new ArrayList<Integer>(8);
                    boolean isDelete = false;
                    boolean isShowTipMsg = false;
                    for (int deleteRowIndex : rows) {
                        if (ChangeTypeEnum.UPDATE.getValue().equals(bill.getValue("entrychangetype", deleteRowIndex))) {
                            boolean check = true;
                            for (int s = 0; s < SalesOrderEntryConst.getJoinQtyFields().size(); ++s) {
                                String field = (String)SalesOrderEntryConst.getJoinQtyFields().get(s);
                                if (!(((BigDecimal)this.getModel().getValue(field, deleteRowIndex)).doubleValue() > 0.0) && (!billtype.get("number").equals("sm_XSalesOrder_SERV_BT_S") || !(((BigDecimal)this.getModel().getValue("arjoinqty", deleteRowIndex)).doubleValue() > 0.0))) continue;
                                if (!isShowTipMsg) {
                                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7269\u6599\u660e\u7ec6\u5df2\u53d1\u751f\u4e1a\u52a1\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"XSalesOrderPlugin_2", (String)"scmc-sm-formplugin", (Object[])new Object[0]), deleteRowIndex + 1));
                                    isShowTipMsg = true;
                                }
                                check = false;
                                break;
                            }
                            if (check) {
                                this.getModel().setValue("entrychangetype", (Object)ChangeTypeEnum.CANCEL.getValue(), deleteRowIndex);
                                this.getView().setEnable(Boolean.FALSE, new String[]{BTN_DELETEROW_ENTRY});
                                this.getView().setEnable(Boolean.TRUE, new String[]{BTN_MODIFY_ENTRY});
                                String[] billEntry1 = MetaDataHelper.getAllPropertyName4Entry((IDataEntityType)this.getModel().getDataEntity().getDataEntityType(), (String)"billentry");
                                this.getView().setEnable(Boolean.FALSE, deleteRowIndex, billEntry1);
                            }
                            e.setCancel(true);
                            isDelete = true;
                            continue;
                        }
                        if (ChangeTypeEnum.ADDNEW.getValue().equals(bill.getValue("entrychangetype", deleteRowIndex))) {
                            needRealDelete.add(deleteRowIndex);
                            continue;
                        }
                        e.setCancel(true);
                        isDelete = true;
                    }
                    if (isDelete && !needRealDelete.isEmpty()) {
                        Integer[] temp = needRealDelete.toArray(new Integer[0]);
                        int[] needDeleteRows = new int[temp.length];
                        for (int i = 0; i < temp.length; ++i) {
                            needDeleteRows[i] = temp[i];
                        }
                        this.getPageCache().put(EXPANDKITBEFOREDELETE, "true");
                        this.getModel().deleteEntryRows("billentry", needDeleteRows);
                        this.getPageCache().remove(EXPANDKITBEFOREDELETE);
                    } else {
                        int rowCount = this.getModel().getEntryRowCount("billentry");
                        for (int i = 0; i < rowCount; ++i) {
                            this.setKitPriceColumnEnable(i);
                        }
                    }
                }
            } else if ("recplanentry".equals(entryName)) {
                if (ChangeTypeEnum.UPDATE.getValue().equals(bill.getValue("recentrychangetype", e.getRowIndexs()[0]))) {
                    BigDecimal recamount = (BigDecimal)this.getModel().getValue("r_recamount", e.getRowIndexs()[0]);
                    BigDecimal remainamount = (BigDecimal)this.getModel().getValue("r_remainamount", e.getRowIndexs()[0]);
                    if (recamount.doubleValue() > 0.0 || remainamount.doubleValue() > 0.0) {
                        bill.setValue("recentrychangetype", (Object)ChangeTypeEnum.UPDATE.getValue(), e.getRowIndexs()[0]);
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u6536\u6b3e\u8ba1\u5212\u5df2\u53d1\u751f\u4e1a\u52a1\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"XSalesOrderPlugin_3", (String)"scmc-sm-formplugin", (Object[])new Object[0]), e.getRowIndexs()[0] + 1));
                    } else {
                        bill.setValue("recentrychangetype", (Object)ChangeTypeEnum.CANCEL.getValue(), e.getRowIndexs()[0]);
                        this.getView().setEnable(Boolean.TRUE, e.getRowIndexs()[0], new String[]{"recentrychangetype"});
                        this.getView().setEnable(Boolean.FALSE, new String[]{BTN_DELETEROW_PAY});
                        this.getView().setEnable(Boolean.TRUE, new String[]{BTN_MODIFY_PAY});
                        String[] recEntry = MetaDataHelper.getAllPropertyName4Entry((IDataEntityType)dt, (String)"recplanentry");
                        for (int i = 0; i < rows.length; ++i) {
                            this.getView().setEnable(Boolean.FALSE, rows[i], recEntry);
                        }
                        this.getView().setEnable(Boolean.FALSE, new String[]{REC_DELETEROW});
                    }
                    e.setCancel(true);
                } else if (ChangeTypeEnum.ADDNEW.getValue().equals(bill.getValue("recentrychangetype", e.getRowIndexs()[0]))) {
                    this.getView().setEnable(Boolean.FALSE, e.getRowIndexs()[0], new String[]{"recentrychangetype"});
                } else {
                    e.setCancel(true);
                }
            } else if ("orderdeliverentry".equals(entryName)) {
                if (ChangeTypeEnum.UPDATE.getValue().equals(bill.getValue("delentrychangetype", e.getRowIndexs()[0]))) {
                    if (((BigDecimal)this.getModel().getValue("d_actqty", e.getRowIndexs()[0])).doubleValue() > 0.0) {
                        bill.setValue("delentrychangetype", (Object)ChangeTypeEnum.UPDATE.getValue(), e.getRowIndexs()[0]);
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u53d1\u8d27\u8ba1\u5212\u5df2\u53d1\u751f\u4e1a\u52a1\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"XSalesOrderPlugin_4", (String)"scmc-sm-formplugin", (Object[])new Object[0]), e.getRowIndexs()[0] + 1));
                    } else {
                        bill.setValue("delentrychangetype", (Object)ChangeTypeEnum.CANCEL.getValue(), e.getRowIndexs()[0]);
                        this.getView().setEnable(Boolean.TRUE, e.getRowIndexs()[0], new String[]{"delentrychangetype"});
                        this.getView().setEnable(Boolean.FALSE, new String[]{BTN_DELETEROW_DELIVER});
                        this.getView().setEnable(Boolean.TRUE, new String[]{BTN_MODIFY_DELIVER});
                        this.getView().setEnable(Boolean.FALSE, new String[]{PLAN_DELETEROW});
                        String[] deliverEntry = MetaDataHelper.getAllPropertyName4Entry((IDataEntityType)dt, (String)"orderdeliverentry");
                        for (int i = 0; i < rows.length; ++i) {
                            this.getView().setEnable(Boolean.FALSE, rows[i], deliverEntry);
                        }
                    }
                    e.setCancel(true);
                } else if (ChangeTypeEnum.ADDNEW.getValue().equals(bill.getValue("delentrychangetype", e.getRowIndexs()[0]))) {
                    this.getView().setEnable(Boolean.FALSE, e.getRowIndexs()[0], new String[]{"delentrychangetype"});
                } else {
                    e.setCancel(true);
                }
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        this.getPageCache().remove(EXPANDKITBEFOREDELETE);
        this.getView().updateView("billentry");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String billcretype = this.getPageCache().get("billcretype");
        if (!BillImportHelper.isManual((String)billcretype)) {
            return;
        }
        if (PropertyChangeHelper.isStopPropertyChange((IPageCache)this.getPageCache())) {
            return;
        }
        String fieldKey = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        switch (fieldKey) {
            case "linetype": {
                for (int i = 0; i < changeSet.length; ++i) {
                    if (!CommonUtils.isRealChanged((ChangeData)changeSet[i])) continue;
                    this.changeLineType(changeSet[i].getOldValue(), changeSet[i].getNewValue(), changeSet[i].getRowIndex());
                }
                break;
            }
            case "discounttype": {
                for (int i = 0; i < changeSet.length; ++i) {
                    if (!CommonUtils.isRealChanged((ChangeData)changeSet[i]) || !DiscountTypeEnum.FIXEDDIS.getValue().equals(changeSet[i].getNewValue())) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e7\u53d8\u66f4\u4e0d\u652f\u6301\u6298\u6263\u65b9\u5f0f\u4e3a\u201c\u6298\u6263\u989d\u201d\uff0c\u8bf7\u5207\u6362\u5230\u65b0\u53d8\u66f4\u3002", (String)"XSalesOrderPlugin_9", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("discounttype", changeSet[i].getOldValue(), changeSet[i].getRowIndex());
                }
                break;
            }
        }
    }

    private void changeLineType(Object oldValue, Object newValue, int rowIndex) {
        DynamicObject lineType;
        if (oldValue != null && newValue == null) {
            PropertyChangeHelper.stopPropertyChange((IPageCache)this.getPageCache());
            this.getModel().setValue("linetype", ((DynamicObject)oldValue).getPkValue(), rowIndex);
            PropertyChangeHelper.releasePropertyChange((IPageCache)this.getPageCache());
            return;
        }
        if (ChangeTypeEnum.ADDNEW.getValue().equals(this.getModel().getValue("entrychangetype", rowIndex))) {
            if (KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) {
                String productType = (String)this.getModel().getValue("producttype", rowIndex);
                if (ProductTypeEnum.KITPARENT.getValue().equals(productType)) {
                    String msg = ResManager.loadKDString((String)"\u5207\u6362\u201c\u884c\u7c7b\u578b\u201d\u5c06\u6e05\u9664\u5f53\u524d\u5206\u5f55\u7269\u6599\u4fe1\u606f\u5e76\u8054\u52a8\u5220\u9664\u5bf9\u5e94\u5957\u4ef6\u5b50\u9879\u7269\u6599\uff0c\u662f\u5426\u5207\u6362\uff1f", (String)"XSalesOrderPlugin_11", (String)"scmc-sm-formplugin", (Object[])new Object[0]);
                    ConfirmCallBackListener callBack = new ConfirmCallBackListener(CONFIRM_KITLINETYPE, (IFormPlugin)this);
                    this.getView().showConfirm(msg, MessageBoxOptions.YesNo, ConfirmTypes.Default, callBack);
                    this.getView().getPageCache().put(CACHE_KITLINETYPE, oldValue == null ? null : ((DynamicObject)oldValue).getPkValue().toString());
                    return;
                }
                if (ProductTypeEnum.KITCHILD.getValue().equals(productType)) {
                    DynamicObject parentRow = this.getParentEntry(rowIndex);
                    if (parentRow != null) {
                        DynamicObject kitBom = parentRow.getDynamicObject("bom");
                        DynamicObject material = parentRow.getDynamicObject("material");
                        if (kitBom != null && material != null && KitStructCtlEnum.NONADJ.getValue().equals(material.getString("kitstructctl"))) {
                            return;
                        }
                    }
                    String msg = ResManager.loadKDString((String)"\u5207\u6362\u201c\u884c\u7c7b\u578b\u201d\u5c06\u6e05\u9664\u5f53\u524d\u5206\u5f55\u7269\u6599\u4fe1\u606f\uff0c\u662f\u5426\u5207\u6362\uff1f", (String)"XSalesOrderPlugin_10", (String)"scmc-sm-formplugin", (Object[])new Object[0]);
                    ConfirmCallBackListener callBack = new ConfirmCallBackListener(CONFIRM_KITLINETYPE, (IFormPlugin)this);
                    this.getView().showConfirm(msg, MessageBoxOptions.YesNo, ConfirmTypes.Default, callBack);
                    this.getView().getPageCache().put(CACHE_KITLINETYPE, oldValue == null ? null : ((DynamicObject)oldValue).getPkValue().toString());
                    return;
                }
            }
            ConfirmCallBackListener callBack = new ConfirmCallBackListener(CONFIRM_LINETYPE, (IFormPlugin)this);
            this.getView().showConfirm(null, ResManager.loadKDString((String)"\u5207\u6362\u201c\u884c\u7c7b\u578b\u201d\u5c06\u6e05\u9664\u5f53\u524d\u5206\u5f55\u7269\u6599\u4fe1\u606f\uff0c\u662f\u5426\u5207\u6362\uff1f", (String)"XSalesOrderPlugin_10", (String)"scmc-sm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, callBack, null, String.valueOf(rowIndex));
            this.getView().getPageCache().put(CACHE_LINETYPE, oldValue == null ? null : ((DynamicObject)oldValue).getPkValue().toString());
        } else if (this.getControl("supplytrans") != null && (lineType = (DynamicObject)this.getModel().getValue("linetype", rowIndex)) != null) {
            Boolean storageout = lineType.getBoolean("storageout");
            if (!storageout.booleanValue()) {
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"supplytrans"});
                this.getModel().setValue("supplytrans", (Object)Boolean.FALSE, rowIndex);
            } else {
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"supplytrans"});
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String key = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        switch (key) {
            case "confirm_linetype": {
                DynamicObject lineType;
                if (messageBoxClosedEvent.getCustomVaule() == null) {
                    return;
                }
                int rowIndex = Integer.parseInt(messageBoxClosedEvent.getCustomVaule());
                if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                    Boolean storageout;
                    DynamicObject lineType2;
                    this.getPageCache().put("changeForceRowMaterial", "true");
                    this.getModel().setValue("material", null, rowIndex);
                    this.getPageCache().remove("changeForceRowMaterial");
                    if (this.getControl("supplytrans") == null || (lineType2 = (DynamicObject)this.getModel().getValue("linetype", rowIndex)) == null || (storageout = Boolean.valueOf(lineType2.getBoolean("storageout"))).booleanValue()) break;
                    this.getModel().setValue("supplytrans", (Object)Boolean.FALSE, rowIndex);
                    break;
                }
                String lineTypeId = this.getView().getPageCache().get(CACHE_LINETYPE);
                this.getModel().beginInit();
                this.getModel().setValue("linetype", (Object)(lineTypeId == null ? null : Long.valueOf(Long.parseLong(lineTypeId))), rowIndex);
                this.getModel().endInit();
                this.getView().updateView("linetype", rowIndex);
                this.getView().getPageCache().remove(CACHE_LINETYPE);
                if (this.getControl("supplytrans") == null || (lineType = (DynamicObject)this.getModel().getValue("linetype", rowIndex)) == null) break;
                Boolean storageout = lineType.getBoolean("storageout");
                if (!storageout.booleanValue()) {
                    this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"supplytrans"});
                    this.getModel().setValue("supplytrans", (Object)Boolean.FALSE, rowIndex);
                    break;
                }
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"supplytrans"});
                break;
            }
            case "confirmXKitLineType": {
                int kitRowIndex = this.getModel().getEntryCurrentRowIndex("billentry");
                if (MessageBoxResult.Yes.equals((Object)result)) {
                    List<Integer> childIndexList;
                    String productType = (String)this.getModel().getValue("producttype", kitRowIndex);
                    if (ProductTypeEnum.KITPARENT.getValue().equals(productType) && (childIndexList = this.getAllChildEntry(kitRowIndex)) != null && !childIndexList.isEmpty()) {
                        Integer[] temp = childIndexList.toArray(new Integer[0]);
                        int[] intArray = new int[temp.length];
                        for (int i = 0; i < temp.length; ++i) {
                            intArray[i] = temp[i];
                        }
                        this.getPageCache().put(ISCONFIRMDELETEKITROW, "true");
                        this.getModel().deleteEntryRows("billentry", intArray);
                        this.getPageCache().put(ISCONFIRMDELETEKITROW, "false");
                    }
                    this.getPageCache().put("changeForceRowMaterial", "true");
                    this.getModel().setValue("material", null, kitRowIndex);
                    this.getPageCache().remove("changeForceRowMaterial");
                    this.getView().updateView();
                    break;
                }
                String lineTypeId = this.getView().getPageCache().get(CACHE_KITLINETYPE);
                this.getModel().beginInit();
                this.getModel().setValue("linetype", (Object)(lineTypeId == null ? null : Long.valueOf(Long.parseLong(lineTypeId))), kitRowIndex);
                this.getModel().endInit();
                this.getView().updateView("linetype", kitRowIndex);
                break;
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        IDataModel bill = this.getModel();
        String entryName = e.getEntryProp().getName();
        RowDataEntity[] rows = e.getRowDataEntities();
        if ("billentry".equals(entryName)) {
            if (rows != null) {
                IDataEntityType dt = this.getModel().getDataEntity().getDataEntityType();
                Boolean inputMount = (Boolean)this.getModel().getValue("inputamount");
                String[] billEntry1 = MetaDataHelper.getAllPropertyName4Entry((IDataEntityType)dt, (String)"billentry");
                String[] billEntry2 = this.getEntryEnableField();
                String[] billEntry3 = this.getDifferentFromString(billEntry1, billEntry2);
                for (RowDataEntity row : rows) {
                    String[] kitEnableField;
                    bill.setValue("entrychangetype", (Object)ChangeTypeEnum.ADDNEW.getValue(), row.getRowIndex());
                    this.getView().setEnable(Boolean.FALSE, row.getRowIndex(), new String[]{"entrychangetype"});
                    if (inputMount.booleanValue()) {
                        String[] billEntry4 = getBackEnableBillEntryField;
                        billEntry3 = this.getDifferentFromString(billEntry1, billEntry4);
                    }
                    if (KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName()) && (kitEnableField = this.getKitEnableField(row.getRowIndex())) != null && kitEnableField.length > 0) {
                        billEntry3 = this.getDifferentFromString(billEntry3, kitEnableField);
                    }
                    this.getView().setEnable(Boolean.TRUE, row.getRowIndex(), billEntry3);
                }
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{BTN_MODIFY_ENTRY});
            if (!"1".equals(this.getPageCache().get("inputamount"))) {
                this.getView().setEnable(Boolean.FALSE, -1, new String[]{"amountandtax"});
                this.getView().setEnable(Boolean.FALSE, -1, new String[]{"amount"});
            }
            if (rows != null && rows.length > 0 && KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) {
                int[] rowIndexs = new int[rows.length];
                for (int i = 0; i < rows.length; ++i) {
                    rowIndexs[i] = rows[i].getRowIndex();
                }
                this.setKitRowEnable(rowIndexs);
            }
        } else if ("recplanentry".equals(entryName)) {
            for (RowDataEntity row : rows) {
                bill.setValue("recentrychangetype", (Object)ChangeTypeEnum.ADDNEW.getValue(), row.getRowIndex());
                this.getView().setEnable(Boolean.FALSE, row.getRowIndex(), new String[]{"recentrychangetype"});
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{BTN_MODIFY_PAY});
        } else if ("orderdeliverentry".equals(entryName)) {
            for (RowDataEntity row : rows) {
                bill.setValue("delentrychangetype", (Object)ChangeTypeEnum.ADDNEW.getValue(), row.getRowIndex());
                this.getView().setEnable(Boolean.FALSE, row.getRowIndex(), new String[]{"delentrychangetype"});
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{BTN_MODIFY_DELIVER});
        }
    }

    private String[] getEnablePayEntryField(boolean isPayRate) {
        if (isPayRate) {
            String[] fields = isPayRateTrue;
            return fields;
        }
        String[] fields = isPayRateFalse;
        return fields;
    }

    private String[] getDifferentFromString(String[] s1, String[] s2) {
        HashSet<String> hs1 = new HashSet<String>(Arrays.asList(s1));
        HashSet<String> hs2 = new HashSet<String>(Arrays.asList(s2));
        hs1.removeAll(hs2);
        return hs1.toArray(new String[0]);
    }

    private String[] getUnVisibleField() {
        String[] fields = new String[]{};
        return fields;
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        int row = evt.getRow();
        if (evt.getSource() instanceof EntryGrid && row != -1) {
            String key = ((EntryGrid)evt.getSource()).getKey();
            if ("billentry".equals(key)) {
                String changeType = (String)this.getModel().getValue("entrychangetype", row);
                if (ChangeTypeEnum.CANCEL.getValue().equals(changeType)) {
                    this.getView().setEnable(Boolean.TRUE, new String[]{BTN_MODIFY_ENTRY});
                    this.getView().setEnable(Boolean.FALSE, new String[]{BTN_DELETEROW_ENTRY});
                    this.getView().setEnable(Boolean.FALSE, new String[]{BTN_PLAN_ADDROW});
                    this.getModel().setEntryCurrentRowIndex("billentry", row);
                    SubEntryGrid control = (SubEntryGrid)this.getControl("orderdeliverentry");
                    String[] deliverEntry = MetaDataHelper.getAllPropertyName4Entry((IDataEntityType)this.getModel().getDataEntityType(), (String)"orderdeliverentry");
                    if (control != null) {
                        int entryRowCount = this.getModel().getEntryRowCount("orderdeliverentry");
                        for (int i = 0; i < entryRowCount; ++i) {
                            this.getView().setEnable(Boolean.FALSE, i, deliverEntry);
                        }
                    }
                } else {
                    this.getModel().setEntryCurrentRowIndex("billentry", row);
                    SubEntryGrid control = (SubEntryGrid)this.getControl("orderdeliverentry");
                    String[] deliverEntry = MetaDataHelper.getAllPropertyName4Entry((IDataEntityType)this.getModel().getDataEntityType(), (String)"orderdeliverentry");
                    if (control != null) {
                        int entryRowCount = this.getModel().getEntryRowCount("orderdeliverentry");
                        for (int i = 0; i < entryRowCount; ++i) {
                            String deliverChangeType = (String)this.getModel().getValue("delentrychangetype", i);
                            if (!ChangeTypeEnum.CANCEL.getValue().equals(deliverChangeType)) continue;
                            this.getView().setEnable(Boolean.FALSE, i, deliverEntry);
                        }
                    }
                    this.getView().setEnable(Boolean.FALSE, new String[]{BTN_MODIFY_ENTRY});
                    this.getView().setEnable(Boolean.TRUE, new String[]{BTN_DELETEROW_ENTRY});
                    this.getView().setEnable(Boolean.TRUE, new String[]{BTN_PLAN_ADDROW});
                }
            } else if ("recplanentry".equals(key)) {
                String changeType = (String)this.getModel().getValue("recentrychangetype", row);
                if (ChangeTypeEnum.CANCEL.getValue().equals(changeType)) {
                    this.getView().setEnable(Boolean.TRUE, new String[]{BTN_MODIFY_PAY});
                    this.getView().setEnable(Boolean.FALSE, new String[]{BTN_DELETEROW_PAY});
                    this.getView().setEnable(Boolean.FALSE, new String[]{REC_DELETEROW});
                } else {
                    this.getView().setEnable(Boolean.FALSE, new String[]{BTN_MODIFY_PAY});
                    this.getView().setEnable(Boolean.TRUE, new String[]{BTN_DELETEROW_PAY});
                    this.getView().setEnable(Boolean.TRUE, new String[]{REC_DELETEROW});
                }
            } else if ("orderdeliverentry".equals(key)) {
                String changeType = (String)this.getModel().getValue("delentrychangetype", row);
                Optional<Object> op = Optional.ofNullable(((DynamicObject)this.getModel().getEntryEntity("orderdeliverentry").get(row)).getParent());
                if (op.isPresent() && ChangeTypeEnum.CANCEL.getValue().equals(((DynamicObject)op.get()).getString("entrychangetype"))) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{BTN_MODIFY_DELIVER});
                    this.getView().setEnable(Boolean.FALSE, new String[]{BTN_DELETEROW_DELIVER});
                    this.getView().setEnable(Boolean.FALSE, new String[]{PLAN_DELETEROW});
                    return;
                }
                if (ChangeTypeEnum.CANCEL.getValue().equals(changeType)) {
                    this.getView().setEnable(Boolean.TRUE, new String[]{BTN_MODIFY_DELIVER});
                    this.getView().setEnable(Boolean.FALSE, new String[]{BTN_DELETEROW_DELIVER});
                    this.getView().setEnable(Boolean.FALSE, new String[]{PLAN_DELETEROW});
                } else {
                    this.getView().setEnable(Boolean.FALSE, new String[]{BTN_MODIFY_DELIVER});
                    this.getView().setEnable(Boolean.TRUE, new String[]{BTN_DELETEROW_DELIVER});
                    this.getView().setEnable(Boolean.TRUE, new String[]{PLAN_DELETEROW});
                }
            }
        }
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        super.entryRowDoubleClick(evt);
    }

    protected String[] getEnableField() {
        return getEnableField;
    }

    protected String[] getEntryEnableField() {
        return getEnableBillEntryField;
    }

    protected String[] getEnableDeliverEntrySynField() {
        return getEnableDeliverEntryField;
    }

    private List<Integer> getAllChildEntry(int parentRowIndex) {
        DynamicObject parentEntry = this.getModel().getEntryRowEntity("billentry", parentRowIndex);
        Long parentPid = parentEntry.getLong("kitpid");
        ArrayList<Integer> childEntryList = new ArrayList<Integer>();
        int rowCount = this.getModel().getEntryRowCount("billentry");
        for (int i = 0; i < rowCount; ++i) {
            Long pID = (Long)this.getModel().getValue("kitpid", i);
            String productType = (String)this.getModel().getValue("producttype", i);
            if (!ProductTypeEnum.KITCHILD.getValue().equals(productType) || parentPid.longValue() != pID.longValue()) continue;
            childEntryList.add(i);
        }
        return childEntryList;
    }

    private List<Integer> getAllNotCancelChildEntry(int parentRowIndex) {
        DynamicObject parentEntry = this.getModel().getEntryRowEntity("billentry", parentRowIndex);
        Long parentPid = parentEntry.getLong("kitpid");
        ArrayList<Integer> childEntryList = new ArrayList<Integer>();
        int rowCount = this.getModel().getEntryRowCount("billentry");
        for (int i = 0; i < rowCount; ++i) {
            Long pID = (Long)this.getModel().getValue("kitpid", i);
            String productType = (String)this.getModel().getValue("producttype", i);
            String changeType = (String)this.getModel().getValue("entrychangetype", i);
            if (!ProductTypeEnum.KITCHILD.getValue().equals(productType) || parentPid.longValue() != pID.longValue() || ChangeTypeEnum.CANCEL.getValue().equals(changeType)) continue;
            childEntryList.add(i);
        }
        return childEntryList;
    }

    private DynamicObject getParentEntry(int childRowIndex) {
        DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("billentry");
        Long pID = (Long)this.getModel().getValue("kitpid", childRowIndex);
        DynamicObject parentEntry = null;
        for (DynamicObject entry : entrys) {
            Long entryPid = entry.getLong("kitpid");
            String productType = entry.getString("producttype");
            if (!ProductTypeEnum.KITPARENT.getValue().equals(productType) || entryPid.longValue() != pID.longValue()) continue;
            parentEntry = entry;
            break;
        }
        return parentEntry;
    }

    private Integer getParentRowIndex(int childRowIndex) {
        DynamicObject childRowEntry = this.getModel().getEntryRowEntity("billentry", childRowIndex);
        Long parentPid = childRowEntry.getLong("kitpid");
        int rowCount = this.getModel().getEntryRowCount("billentry");
        for (int i = 0; i < rowCount; ++i) {
            Long pID = (Long)this.getModel().getValue("kitpid", i);
            String productType = (String)this.getModel().getValue("producttype", i);
            if (!ProductTypeEnum.KITPARENT.getValue().equals(productType) || parentPid.longValue() != pID.longValue()) continue;
            return i;
        }
        return null;
    }

    private String[] getKitEnableField(int rowIndex) {
        HashSet enableField = new HashSet(8);
        HashSet<String> enableColumn = new HashSet<String>();
        enableColumn.addAll(Arrays.asList(BillTplEntryConst.KITAMOUNTANDPRICEFIELDS));
        List wer = KitSalesHelper.getAmountAndQtyFieldList((DynamicObject)this.getModel().getDataEntity(true), (String)"billentry");
        enableColumn.addAll(wer);
        String productType = (String)this.getModel().getValue("producttype", rowIndex);
        String priceModel = (String)this.getModel().getValue("pricemodel", rowIndex);
        String transferModel = (String)this.getModel().getValue("kittransfermodel", rowIndex);
        if (ProductTypeEnum.KITPARENT.getValue().equals(productType) && PriceModelEnum.CHILD.getValue().equals(priceModel)) {
            enableField.addAll(enableColumn);
        } else if (ProductTypeEnum.KITCHILD.getValue().equals(productType)) {
            if (PriceModelEnum.PARENT.getValue().equals(priceModel)) {
                enableField.addAll(enableColumn);
            }
            if (KitTransferModelEnum.KIT.getValue().equals(transferModel)) {
                enableField.addAll(Arrays.asList("entrysettleorg", "e_stockorg", "deliverydate", "iscontrolday", "deliveradvdays", "deliverdelaydays"));
            }
            enableField.addAll(Arrays.asList("iscontrolqty", "deliverratedown", "deliverrateup", "supplytrans", "purorg", "supplier"));
        }
        return enableField.toArray(new String[0]);
    }

    private void setEntryEnable() {
        if (KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) {
            int rowCount = this.getModel().getEntryRowCount("billentry");
            for (int i = 0; i < rowCount; ++i) {
                this.setKitPriceColumnEnable(i);
            }
        }
    }

    private void setKitPriceColumnEnable(int rowIndex) {
        DynamicObject parentRow;
        String changeType;
        if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(EXPANDKITPARENTROW)) || StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(EXPANDKITBEFOREDELETE))) {
            return;
        }
        ArrayList lockColumns = new ArrayList(8);
        ArrayList<String> unlockColumns = new ArrayList<String>(8);
        HashSet<String> enableColumn = new HashSet<String>();
        enableColumn.addAll(Arrays.asList(BillTplEntryConst.KITAMOUNTANDPRICEFIELDS));
        List wer = KitSalesHelper.getAmountAndQtyFieldList((DynamicObject)this.getModel().getDataEntity(true), (String)"billentry");
        enableColumn.addAll(wer);
        boolean isLock = false;
        boolean isUnLock = false;
        String productType = (String)this.getModel().getValue("producttype", rowIndex);
        String priceModel = (String)this.getModel().getValue("pricemodel", rowIndex);
        if (ProductTypeEnum.KITPARENT.getValue().equals(productType)) {
            if (PriceModelEnum.CHILD.getValue().equals(priceModel)) {
                isLock = true;
            } else {
                isUnLock = true;
            }
        } else if (ProductTypeEnum.KITCHILD.getValue().equals(productType)) {
            if (PriceModelEnum.PARENT.getValue().equals(priceModel)) {
                isLock = true;
            } else {
                isUnLock = true;
            }
        }
        if (isLock) {
            lockColumns.addAll(enableColumn);
        }
        if (isUnLock) {
            changeType = (String)this.getModel().getValue("entrychangetype", rowIndex);
            for (String column : enableColumn) {
                if (ChangeTypeEnum.CANCEL.getValue().equals(changeType)) {
                    lockColumns.add(column);
                    continue;
                }
                unlockColumns.add(column);
            }
        }
        if (ProductTypeEnum.KITCHILD.getValue().equals(productType) && (parentRow = this.getParentEntry(rowIndex)) != null) {
            DynamicObject kitBom = parentRow.getDynamicObject("bom");
            String[] material = parentRow.getDynamicObject("material");
            if (kitBom != null && material != null && KitStructCtlEnum.NONADJ.getValue().equals(material.getString("kitstructctl"))) {
                lockColumns.add("qty");
                lockColumns.add("auxqty");
                lockColumns.add("unit");
                lockColumns.add("material");
            } else {
                DynamicObject auxUnit;
                String changeType2 = (String)this.getModel().getValue("entrychangetype", rowIndex);
                if (!ChangeTypeEnum.CANCEL.getValue().equals(changeType2) && (auxUnit = (DynamicObject)this.getModel().getValue("auxunit", rowIndex)) != null) {
                    unlockColumns.add("auxqty");
                }
            }
        }
        if (ProductTypeEnum.KITCHILD.getValue().equals(productType)) {
            String transfermodel = (String)this.getModel().getValue("kittransfermodel", rowIndex);
            if (KitTransferModelEnum.KIT.getValue().equals(transfermodel)) {
                lockColumns.add("e_stockorg");
                lockColumns.add("deliverydate");
                lockColumns.add("iscontrolday");
                lockColumns.add("deliveradvdays");
                lockColumns.add("deliverdelaydays");
            } else if (KitTransferModelEnum.NONKIT.getValue().equals(transfermodel)) {
                String changeType3 = (String)this.getModel().getValue("entrychangetype", rowIndex);
                for (String column : deliverColumns) {
                    if (ChangeTypeEnum.CANCEL.getValue().equals(changeType3)) {
                        lockColumns.add(column);
                        continue;
                    }
                    unlockColumns.add(column);
                }
            }
            lockColumns.add("iscontrolqty");
            lockColumns.add("deliverratedown");
            lockColumns.add("deliverrateup");
            lockColumns.add("supplytrans");
            lockColumns.add("purorg");
            lockColumns.add("supplier");
        }
        changeType = (String)this.getModel().getValue("entrychangetype", rowIndex);
        if (ChangeTypeEnum.CANCEL.getValue().equals(changeType)) {
            IDataEntityType dt = this.getModel().getDataEntity().getDataEntityType();
            String[] billEntry = MetaDataHelper.getAllPropertyName4Entry((IDataEntityType)dt, (String)"billentry");
            lockColumns.addAll(Arrays.asList(billEntry));
        }
        if (lockColumns != null && !lockColumns.isEmpty()) {
            for (String column : lockColumns) {
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{column});
            }
        }
        if (unlockColumns != null && !unlockColumns.isEmpty()) {
            for (String column : unlockColumns) {
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{column});
            }
        }
    }

    private void setKitRowEnable(int[] rowIndexs) {
        if (rowIndexs == null) {
            return;
        }
        for (int rowIndex : rowIndexs) {
            this.setKitPriceColumnEnable(rowIndex);
        }
    }
}

