/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.formplugin.quote;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.AmountEdit;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.bill.BillModel;
import kd.bos.mvc.form.ClientViewProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.common.enums.KitStructCtlEnum;
import kd.mpscmm.msbd.common.enums.KitTransferModelEnum;
import kd.mpscmm.msbd.common.enums.PriceModelEnum;
import kd.scmc.sm.business.helper.BillTplHelper;
import kd.scmc.sm.business.helper.KitSalesHelper;
import kd.scmc.sm.business.helper.OperationBizStatusHelper;
import kd.scmc.sm.business.helper.PriceListF7Helper;
import kd.scmc.sm.business.helper.PropertyChangeHelper;
import kd.scmc.sm.consts.Constants;
import kd.scmc.sm.consts.SimpleBillTplEntryConst;
import kd.scmc.sm.enums.DiscountTypeEnum;
import kd.scmc.sm.enums.MaterialConfigPropertiesEnum;
import kd.scmc.sm.enums.ProductTypeEnum;
import kd.scmc.sm.util.CommonUtils;
import kd.scmc.sm.util.QFBuilder;

public class QuotationBillPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
EntryGridBindDataListener {
    public static final String TAXRATE_FILTER = "taxrate_filter";
    public static final String EXPIRYDATE = "expirydate";
    public static final String SELCONFIG = "selconfig";
    private static final String EXPANDKITPARENTROW = "expandKitParentRow";

    public void registerListener(EventObject e) {
        Toolbar tbmainentry;
        BasedataEdit configuredcode;
        BasedataEdit priceList;
        BasedataEdit project;
        BasedataEdit operator;
        BasedataEdit dept;
        BasedataEdit taxrateid;
        BasedataEdit customer;
        super.registerListener(e);
        EntryGrid entry = (EntryGrid)this.getControl("billentry");
        if (entry != null) {
            entry.addDataBindListener((EntryGridBindDataListener)this);
        }
        if ((customer = (BasedataEdit)this.getView().getControl("customer")) != null) {
            customer.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((taxrateid = (BasedataEdit)this.getView().getControl("taxrateid")) != null) {
            taxrateid.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((dept = (BasedataEdit)this.getView().getControl("dept")) != null) {
            dept.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((operator = (BasedataEdit)this.getView().getControl("operator")) != null) {
            operator.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((project = (BasedataEdit)this.getView().getControl("project")) != null) {
            project.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((priceList = (BasedataEdit)this.getView().getControl("pricelist")) != null) {
            priceList.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((configuredcode = (BasedataEdit)this.getView().getControl("configuredcode")) != null) {
            configuredcode.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((tbmainentry = (Toolbar)this.getView().getControl("advcontoolbarap")) != null) {
            tbmainentry.addItemClickListener((ItemClickListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.setExpirydate();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        OperationBizStatusHelper.setEnableByBizStatus((IFormView)this.getView());
        this.queryTaxrate();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billentry");
        if (entryGrid != null) {
            entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        }
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        Boolean istax = (Boolean)this.getModel().getValue("istax");
        this.setPriceMustInput(istax);
        this.setKitColumnEnables(e.getRows());
        this.setDiscountRateScale(this.getModel().getValue("settlecurrency"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String key = operate.getOperateKey();
        try (TraceSpan span = Tracer.create((String)"QuotationBillPlugin", (String)("beforeDoOperation: " + key));){
            switch (key) {
                case "expandkit": {
                    Date bizDate = (Date)this.getModel().getValue("bizdate");
                    if (bizDate != null) return;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u201c\u62a5\u4ef7\u65e5\u671f\u201d\u5b57\u6bb5\u3002", (String)"QuotationBillPlugin_10", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            }
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("bizclose".equals(e.getOperateKey()) || "bizunclose".equals(e.getOperateKey())) {
            OperationBizStatusHelper.setEnableByBizStatus((IFormView)this.getView());
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"QuotationBillPlugin_5", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        switch (fieldKey) {
            case "customer": {
                QFilter bizfunction = new QFilter("bizfunction", "like", (Object)"%1%");
                showParameter.getListFilterParameter().getQFilters().add(bizfunction);
                break;
            }
            case "taxrateid": {
                String taxrateFilter = this.getPageCache().get(TAXRATE_FILTER);
                taxrateFilter = taxrateFilter.substring(1, taxrateFilter.length() - 1);
                if (StringUtils.isNotEmpty((String)taxrateFilter)) {
                    String[] taxrateIds = taxrateFilter.split("_");
                    ArrayList<Long> taxrateIdList = new ArrayList<Long>(taxrateIds.length);
                    for (String id : taxrateIds) {
                        if (id == null || "".equals(id)) continue;
                        taxrateIdList.add(Long.valueOf(id));
                    }
                    QFilter filter = new QFilter("id", "in", taxrateIdList);
                    showParameter.getListFilterParameter().setFilter(filter);
                    break;
                }
                QFilter filter = QFilter.of((String)"1=-1", (Object[])new Object[0]);
                showParameter.getListFilterParameter().setFilter(filter);
                break;
            }
            case "pricelist": {
                DynamicObject customer = (DynamicObject)this.getModel().getValue("customer");
                if (customer == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ba2\u8d27\u5ba2\u6237\u3002", (String)"QuotationBillPlugin_6", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                showParameter.getListFilterParameter().setFilter(PriceListF7Helper.getPriceListFilter((DynamicObject)this.getModel().getDataEntity(true)));
                break;
            }
            case "configuredcode": {
                int rowIndex = this.getModel().getEntryCurrentRowIndex("billentry");
                DynamicObject material = (DynamicObject)this.getModel().getValue("material", rowIndex);
                if (material == null || material.getDynamicObject("masterid") == null) break;
                QFilter qFilter = new QFilter("material", "=", material.getDynamicObject("masterid").getPkValue());
                showParameter.getListFilterParameter().getQFilters().add(qFilter);
                break;
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String entryName;
        super.afterAddRow(e);
        if (KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName()) && "billentry".equals(entryName = e.getEntryProp().getName())) {
            RowDataEntity[] rowDataEntities = e.getRowDataEntities();
            ArrayList<Integer> rowIndexs = new ArrayList<Integer>(rowDataEntities.length);
            for (int i = 0; i < rowDataEntities.length; ++i) {
                RowDataEntity rowDataEntity = rowDataEntities[i];
                rowIndexs.add(rowDataEntity.getRowIndex());
            }
            this.setKitColumnEnable(rowIndexs);
            this.setKitDeliverColumnDefault(rowIndexs);
        }
    }

    public void initialize() {
        EntryGrid entry = (EntryGrid)this.getControl("billentry");
        if (entry != null) {
            entry.addDataBindListener((EntryGridBindDataListener)this);
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        this.getView().updateView("billentry");
    }

    public void afterCopyData(EventObject e) {
        BillModel model = (BillModel)e.getSource();
        if (model.getValue("operator") != null) {
            DynamicObject operator = (DynamicObject)model.getValue("operator");
            QFBuilder qf = new QFBuilder();
            qf.add("id", "=", operator.getPkValue());
            qf.and("invalid", "=", (Object)Boolean.FALSE);
            operator = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_operator", (QFilter[])qf.toArray());
            if (operator == null) {
                model.setValue("operator", null);
                model.setValue("operatorgroup", null);
            }
        }
        this.setExpirydate();
    }

    public void beforeItemClick(BeforeItemClickEvent e) {
        String itemKey;
        switch (itemKey = e.getItemKey()) {
            case "selconfig": {
                if (e.isCancel()) break;
                AbstractGrid billentry = (AbstractGrid)this.getControl("billentry");
                int focusEntryRow = billentry.getEntryState().getFocusRow();
                if (focusEntryRow == -1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u7269\u6599\u5206\u5f55\uff0c\u518d\u8fdb\u884c\u9009\u914d\u3002", (String)"QuotationBillPlugin_7", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                int[] selectrows = ((EntryGrid)billentry).getSelectRows();
                if (selectrows != null && selectrows.length > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u7269\u6599\u5206\u5f55\uff0c\u518d\u8fdb\u884c\u9009\u914d\u3002", (String)"QuotationBillPlugin_7", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                DynamicObject material = (DynamicObject)this.getModel().getValue("material", focusEntryRow);
                if (material == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u7269\u6599\uff0c\u518d\u8fdb\u884c\u9009\u914d\u3002", (String)"QuotationBillPlugin_8", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                if (MaterialConfigPropertiesEnum.CONFIG.getValue().equals(material.getDynamicObject("masterid").getString("configproperties"))) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u914d\u7f6e\u5c5e\u6027\u4e3a\u201c\u914d\u7f6e\u4ef6\u201d\u7684\u7269\u6599\uff0c\u518d\u8fdb\u884c\u9009\u914d\u3002", (String)"QuotationBillPlugin_9", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "selconfig": {
                this.showProductConfigForm();
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (PropertyChangeHelper.isStopPropertyChange((IPageCache)this.getPageCache())) {
            return;
        }
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        switch (propName) {
            case "price": 
            case "priceandtax": {
                for (int i = 0; i < valueSet.length; ++i) {
                    int rowIndex;
                    if (!CommonUtils.isRealChanged((ChangeData)valueSet[i]) || !this.changeDiscountInfo(rowIndex = valueSet[i].getRowIndex(), valueSet[i], propName)) continue;
                    this.calculatePrice(rowIndex);
                }
                break;
            }
            case "taxrateid": {
                for (int i = 0; i < valueSet.length; ++i) {
                    if (!CommonUtils.isRealChanged((ChangeData)valueSet[i])) continue;
                    int rowIndex = valueSet[i].getRowIndex();
                    DynamicObject taxRateID = (DynamicObject)valueSet[i].getNewValue();
                    if (taxRateID != null) {
                        this.getModel().setValue("taxrate", taxRateID.get("taxrate"), rowIndex);
                    } else {
                        this.getModel().setValue("taxrate", (Object)0, rowIndex);
                    }
                    this.calculatePrice(rowIndex);
                }
                break;
            }
            case "delivdays": {
                for (int i = 0; i < valueSet.length; ++i) {
                    if (!CommonUtils.isRealChanged((ChangeData)valueSet[i])) continue;
                    int rowIndex = valueSet[i].getRowIndex();
                    int delivdays = (Integer)valueSet[i].getNewValue();
                    if (delivdays < 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ea4\u8d27\u5929\u6570\u4e0d\u80fd\u4e3a\u8d1f\u6570\u3002", (String)"QuotationBillPlugin_1", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        this.getModel().setValue("delivdays", (Object)BigDecimal.ZERO, rowIndex);
                    }
                    if (!KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) continue;
                    int parentRowIndex = valueSet[i].getRowIndex();
                    String productType = (String)this.getModel().getValue("producttype", parentRowIndex);
                    if (!ProductTypeEnum.KITPARENT.getValue().equals(productType)) continue;
                    List<Integer> childIndexList = this.getAllChildEntry(parentRowIndex);
                    this.setKitDeliverColumnValue(childIndexList, parentRowIndex, "delivdays");
                }
                break;
            }
            case "discounttype": 
            case "discountrate": {
                for (int i = 0; i < valueSet.length; ++i) {
                    if (!CommonUtils.isRealChanged((ChangeData)valueSet[i])) continue;
                    int rowIndex = valueSet[i].getRowIndex();
                    this.changeDiscountInfo(rowIndex, valueSet[i], propName);
                }
                break;
            }
            case "material": {
                for (int i = 0; i < valueSet.length; ++i) {
                    if (!CommonUtils.isRealChanged((ChangeData)valueSet[i])) continue;
                    int rowIndex = valueSet[i].getRowIndex();
                    this.changeMaterial((DynamicObject)valueSet[i].getNewValue(), rowIndex);
                    if (!KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) continue;
                    this.setOneKitColumnEnable(rowIndex);
                    this.setKitDeliverColumnDefault(Collections.singletonList(rowIndex));
                }
                break;
            }
            case "bizdate": {
                for (int i = 0; i < valueSet.length; ++i) {
                    if (!CommonUtils.isRealChanged((ChangeData)valueSet[i])) continue;
                    this.queryTaxrate();
                }
                break;
            }
            case "qty": 
            case "auxqty": {
                for (int i = 0; i < valueSet.length; ++i) {
                    if (!CommonUtils.isRealChanged((ChangeData)valueSet[i])) continue;
                    int row = valueSet[i].getRowIndex();
                    if (!KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) continue;
                    this.calcChildRowQty(row);
                }
                break;
            }
            case "unit": {
                for (int i = 0; i < valueSet.length; ++i) {
                    if (!CommonUtils.isRealChanged((ChangeData)valueSet[i])) continue;
                    int rowIndex = valueSet[i].getRowIndex();
                    DynamicObject unit = (DynamicObject)valueSet[i].getNewValue();
                    if (valueSet[i].getNewValue() != null) {
                        int precision = unit.getInt("precision");
                        int precisionaccount = BillTplHelper.getRoundMode((DynamicObject)unit);
                        BigDecimal qty = (BigDecimal)this.getModel().getValue("qty", rowIndex);
                        qty = qty.setScale(precision, precisionaccount);
                        this.getModel().setValue("qty", (Object)qty, rowIndex);
                        this.getView().updateView("qty", rowIndex);
                    }
                    if (!KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) continue;
                    this.calcChildRowQty(rowIndex);
                }
                break;
            }
            case "istax": {
                if (!CommonUtils.isRealChanged((ChangeData)valueSet[0])) {
                    return;
                }
                Boolean istax = (Boolean)valueSet[0].getNewValue();
                if (this.checkDiscount(istax)) {
                    this.setPriceMustInput((Boolean)valueSet[0].getNewValue());
                    break;
                }
                this.getModel().setValue("istax", (Object)Boolean.TRUE);
                break;
            }
            case "settlecurrency": {
                this.setDiscountRateScale(valueSet[0].getNewValue());
                break;
            }
            case "customer": {
                this.getModel().setValue("pricelist", null);
                break;
            }
            case "kittransfermodel": {
                if (!KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) break;
                for (int i = 0; i < valueSet.length; ++i) {
                    if (!CommonUtils.isRealChanged((ChangeData)valueSet[i])) continue;
                    int parentRowIndex = valueSet[i].getRowIndex();
                    String productType = (String)this.getModel().getValue("producttype", parentRowIndex);
                    if (!ProductTypeEnum.KITPARENT.getValue().equals(productType)) continue;
                    List<Integer> childIndexList = this.getAllChildEntry(parentRowIndex);
                    String kitTransferModel = valueSet[i].getNewValue() == null ? null : valueSet[i].getNewValue().toString();
                    this.setChildDeliverColumnEnable(childIndexList, kitTransferModel);
                    this.setKitDeliverColumnDefault(childIndexList, parentRowIndex);
                }
                break;
            }
        }
    }

    private void setPriceMustInput(Boolean istax) {
        AmountEdit priceAndTaxControl = (AmountEdit)this.getView().getControl("priceandtax");
        AmountEdit priceControl = (AmountEdit)this.getView().getControl("price");
        if (istax.booleanValue()) {
            priceAndTaxControl.setMustInput(true);
            priceControl.setMustInput(false);
        } else {
            priceAndTaxControl.setMustInput(false);
            priceControl.setMustInput(true);
        }
    }

    private void queryTaxrate() {
        Date bizTime = (Date)this.getModel().getValue("bizdate");
        QFilter q1 = new QFilter("activedate", "<=", (Object)bizTime);
        QFilter q2 = new QFilter("expdate", ">", (Object)bizTime);
        QFilter q3 = q2.or(QFilter.isNull((String)"expdate"));
        q1.and(q3).and(new QFilter("enable", "=", (Object)"1"));
        Map bdTaxrate = BusinessDataServiceHelper.loadFromCache((String)"bd_taxrate", (String)"id", (QFilter[])new QFilter[]{q1});
        ArrayList<String> taxratelist = new ArrayList<String>(bdTaxrate.size());
        for (Map.Entry next : bdTaxrate.entrySet()) {
            Object pkValue = ((DynamicObject)next.getValue()).getPkValue();
            taxratelist.add(pkValue.toString());
        }
        if (taxratelist.size() > 0) {
            this.getPageCache().put(TAXRATE_FILTER, SerializationUtils.toJsonString((Object)String.join((CharSequence)"_", taxratelist)));
        }
    }

    private void changeMaterial(DynamicObject newValue, int rowIndex) {
        PropertyChangeHelper.stopPropertyChange((IPageCache)this.getPageCache());
        this.getModel().setValue("price", null, rowIndex);
        this.getModel().setValue("priceandtax", null, rowIndex);
        this.getModel().setValue("discountrate", null, rowIndex);
        this.getModel().setValue("taxrateid", null, rowIndex);
        this.getModel().setValue("taxrate", null, rowIndex);
        this.getModel().setValue("delivdays", (Object)0, rowIndex);
        this.getModel().setValue("project", null, rowIndex);
        this.getModel().setValue("configuredcode", null, rowIndex);
        if (newValue != null) {
            DynamicObject taxrate;
            DynamicObject masterMaterial = newValue.getDynamicObject("masterid");
            if (masterMaterial != null && masterMaterial.getDynamicObject("taxrate") != null) {
                this.getModel().setValue("taxrateid", masterMaterial.getDynamicObject("taxrate").getPkValue(), rowIndex);
                taxrate = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_taxrate", (String)"taxrate", (QFilter[])new QFilter[]{new QFilter("id", "=", masterMaterial.getDynamicObject("taxrate").getPkValue())});
                this.getModel().setValue("taxrate", (Object)taxrate.getBigDecimal("taxrate"), rowIndex);
            } else {
                DynamicObject customer = (DynamicObject)this.getModel().getValue("customer");
                if (customer != null && customer.getDynamicObject("taxrate") != null) {
                    this.getModel().setValue("taxrateid", customer.getDynamicObject("taxrate").getPkValue(), rowIndex);
                    DynamicObject customerTaxrate = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_taxrate", (String)"taxrate", (QFilter[])new QFilter[]{new QFilter("id", "=", customer.getDynamicObject("taxrate").getPkValue())});
                    this.getModel().setValue("taxrate", (Object)customerTaxrate.getBigDecimal("taxrate"), rowIndex);
                }
            }
            if (newValue != null && this.getModel().getValue("taxrateid", rowIndex) != null) {
                taxrate = (DynamicObject)this.getModel().getValue("taxrateid", rowIndex);
                String taxrate_filter = this.getPageCache().get(TAXRATE_FILTER);
                String[] taxrateIds = (taxrate_filter = taxrate_filter.substring(1, taxrate_filter.length() - 1)).split("_");
                if (taxrateIds.length > 0 && !Arrays.asList(taxrateIds).contains(taxrate.getPkValue().toString())) {
                    this.getModel().beginInit();
                    this.getModel().setValue("taxrateid", null, rowIndex);
                    this.getModel().setValue("taxrate", null, rowIndex);
                    this.getModel().endInit();
                    this.getView().updateView("taxrateid", rowIndex);
                    this.getView().updateView("taxrate", rowIndex);
                }
            }
        }
        PropertyChangeHelper.releasePropertyChange((IPageCache)this.getPageCache());
    }

    private boolean changeDiscountInfo(int rowIndex, ChangeData changeData, String propName) {
        String discountType = (String)this.getModel().getValue("discounttype", rowIndex);
        if (DiscountTypeEnum.NULL.getValue().equals(discountType)) {
            this.getModel().setValue("discountrate", (Object)BigDecimal.ZERO, rowIndex);
        } else if (DiscountTypeEnum.DISRATE.getValue().equals(discountType)) {
            BigDecimal discountRate = (BigDecimal)this.getModel().getValue("discountrate", rowIndex);
            if (discountRate != null && discountRate.compareTo(Constants.ONE_HUNDRED) > 0) {
                this.revertEntryValue(changeData, rowIndex, propName);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u201c\u6298\u6263\u7387(%)\u201d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u8303\u56f4\u4e3a\uff1a0\u2264\u5355\u4f4d\u6298\u6263(\u7387)\u2264100\u3002", (String)"QuotationBillPlugin_2", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                return false;
            }
        } else if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType)) {
            BigDecimal discountAmount = (BigDecimal)this.getModel().getValue("discountrate", rowIndex);
            boolean isTax = (Boolean)this.getModel().getValue("istax");
            if (isTax) {
                BigDecimal priceAndTax = (BigDecimal)this.getModel().getValue("priceandtax", rowIndex);
                if (discountAmount.compareTo(priceAndTax) > 0) {
                    this.revertEntryValue(changeData, rowIndex, propName);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u201c\u5355\u4f4d\u6298\u6263\u989d\u201d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e\u542b\u7a0e\u5355\u4ef7\u3002", (String)"QuotationBillPlugin_3", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    return false;
                }
            } else {
                BigDecimal price = (BigDecimal)this.getModel().getValue("price", rowIndex);
                if (discountAmount.compareTo(price) > 0) {
                    this.revertEntryValue(changeData, rowIndex, propName);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u201c\u5355\u4f4d\u6298\u6263\u989d\u201d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e\u5355\u4ef7\u3002", (String)"QuotationBillPlugin_4", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    return false;
                }
            }
        }
        return true;
    }

    private void revertEntryValue(ChangeData changeData, int rowIndex, String propName) {
        PropertyChangeHelper.stopPropertyChange((IPageCache)this.getPageCache());
        this.getModel().setValue(propName, changeData.getOldValue(), rowIndex);
        PropertyChangeHelper.releasePropertyChange((IPageCache)this.getPageCache());
    }

    private void calculatePrice(int rowIndex) {
        BigDecimal price = (BigDecimal)this.getModel().getValue("price", rowIndex);
        BigDecimal priceAndTax = (BigDecimal)this.getModel().getValue("priceandtax", rowIndex);
        BigDecimal taxRate = (BigDecimal)this.getModel().getValue("taxrate", rowIndex);
        taxRate = taxRate.divide(new BigDecimal(100));
        Boolean istax = (Boolean)this.getModel().getValue("istax");
        this.getModel().beginInit();
        if (istax.booleanValue()) {
            price = priceAndTax.divide(BigDecimal.ONE.add(taxRate), 10, 4);
            this.getModel().setValue("price", (Object)price, rowIndex);
        } else {
            priceAndTax = price.multiply(BigDecimal.ONE.add(taxRate));
            this.getModel().setValue("priceandtax", (Object)priceAndTax, rowIndex);
        }
        this.getModel().endInit();
        this.getView().updateView("price", rowIndex);
        this.getView().updateView("priceandtax", rowIndex);
    }

    private void setExpirydate() {
        LocalDate expirydate = LocalDate.now().plusMonths(1L);
        this.getModel().setValue(EXPIRYDATE, (Object)expirydate);
    }

    private boolean checkDiscount(Boolean isTax) {
        Boolean checkResult = Boolean.TRUE;
        if (!isTax.booleanValue()) {
            DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("billentry");
            ArrayList<String> errorMsgList = new ArrayList<String>(8);
            for (DynamicObject entry : entrys) {
                BigDecimal price;
                BigDecimal dicountRate;
                String discountType = entry.getString("discounttype");
                if (!DiscountTypeEnum.UNITDIS.getValue().equals(discountType) || (dicountRate = entry.getBigDecimal("discountrate")).compareTo(price = entry.getBigDecimal("price")) <= 0) continue;
                checkResult = Boolean.FALSE;
                errorMsgList.add(entry.getString("seq"));
            }
            if (!checkResult.booleanValue() && errorMsgList.size() > 0) {
                String errorRows = errorMsgList.stream().map(String::valueOf).collect(Collectors.joining("\u3001"));
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c\u542b\u7a0e\u201d\u5207\u6362\u4e3a\u201c\u5426\u201d\u65f6\uff0c\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\u201c\u5355\u4f4d\u6298\u6263(\u7387)\u201d\u4e0d\u80fd\u5927\u4e8e\u201c\u5355\u4ef7\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BillTplPlugin_28", (String)"scmc-sm-formplugin", (Object[])new Object[0]), errorRows));
            }
        }
        return checkResult;
    }

    private void showProductConfigForm() {
        AbstractGrid billentry = (AbstractGrid)this.getControl("billentry");
        int focusEntryRow = billentry.getEntryState().getFocusRow();
        if (focusEntryRow == -1) {
            return;
        }
        IDataModel model = this.getModel();
        FormShowParameter param = new FormShowParameter();
        param.setFormId("pdm_productconfig");
        param.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss style = new StyleCss();
        style.setWidth("1000");
        style.setHeight("780");
        param.getOpenStyle().setInlineStyleCss(style);
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        DynamicObject materialsalinfo = (DynamicObject)model.getValue("material", focusEntryRow);
        DynamicObject material = materialsalinfo != null ? materialsalinfo.getDynamicObject("masterid") : null;
        String materialid = material == null ? "" : String.valueOf(material.getPkValue());
        Object datetime = model.getValue("bizdate");
        DynamicObject configuredcode = (DynamicObject)model.getValue("configuredcode", focusEntryRow);
        long configcodeid = configuredcode == null ? 0L : (Long)configuredcode.getPkValue();
        customParams.put("org", 0L);
        customParams.put("material", materialid);
        customParams.put("datetime", datetime);
        customParams.put("configcode", configcodeid);
        customParams.put("issale", "2");
        param.setCustomParams(customParams);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SELCONFIG));
        this.getView().showForm(param);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (e.getReturnData() != null && SELCONFIG.equals(actionId)) {
            HashMap returnData = (HashMap)e.getReturnData();
            Long configCode = (Long)returnData.get("configCodeBack");
            AbstractGrid billentry = (AbstractGrid)this.getControl("billentry");
            int focusEntryRow = billentry.getEntryState().getFocusRow();
            this.getModel().setValue("configuredcode", (Object)configCode, focusEntryRow);
        }
    }

    private void setKitColumnEnables(List<RowDataEntity> currencyRows) {
        if (currencyRows == null || currencyRows.size() == 0) {
            return;
        }
        for (RowDataEntity row : currencyRows) {
            int rowIndex = row.getRowIndex();
            this.setKitPriceColumnEnable(rowIndex, null);
            this.setKitDeliverColumnEnable(rowIndex, null);
        }
    }

    private void setOneKitColumnEnable(int rowIndex) {
        this.setKitPriceColumnEnable(rowIndex, null);
        this.setKitDeliverColumnEnable(rowIndex, null);
    }

    private void setKitColumnEnable(List<Integer> rows) {
        if (rows == null || rows.size() == 0) {
            return;
        }
        for (int rowIndex : rows) {
            this.setKitPriceColumnEnable(rowIndex, null);
            this.setKitDeliverColumnEnable(rowIndex, null);
        }
    }

    private void setChildDeliverColumnEnable(List<Integer> childEntryList, String transferModel) {
        if (childEntryList == null || childEntryList.size() == 0) {
            return;
        }
        for (Integer childEntryIndex : childEntryList) {
            this.setKitDeliverColumnEnable(childEntryIndex, transferModel);
        }
    }

    private void setKitDeliverColumnDefault(List<Integer> childIndexList) {
        if (childIndexList == null || childIndexList.size() == 0) {
            return;
        }
        HashMap<Long, DynamicObject> parentMap = new HashMap<Long, DynamicObject>();
        for (int childRowIndex : childIndexList) {
            String productType = (String)this.getModel().getValue("producttype", childRowIndex);
            if (!ProductTypeEnum.KITCHILD.getValue().equals(productType)) continue;
            Long pID = (Long)this.getModel().getValue("kitpid", childRowIndex);
            DynamicObject parentEntry = (DynamicObject)parentMap.get(pID);
            if (parentEntry == null) {
                parentEntry = this.getParentEntry(childRowIndex);
                parentMap.put(pID, parentEntry);
            }
            if (parentEntry == null) continue;
            this.setKitDeliverOneColumnDefault(childRowIndex, parentEntry);
        }
    }

    private DynamicObject getParentEntry(int childRowIndex) {
        DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("billentry");
        Long pID = (Long)this.getModel().getValue("kitpid", childRowIndex);
        DynamicObject parentEntry = null;
        for (DynamicObject entry : entrys) {
            Long entryPid = entry.getLong("kitpid");
            String productType = entry.getString("producttype");
            if (!ProductTypeEnum.KITPARENT.getValue().equals(productType) || entryPid.longValue() != pID.longValue()) continue;
            parentEntry = entry;
            break;
        }
        return parentEntry;
    }

    private void setKitDeliverColumnDefault(List<Integer> childIndexList, int parentRowIndex) {
        if (childIndexList == null || childIndexList.size() == 0) {
            return;
        }
        DynamicObject parentEntry = this.getModel().getEntryRowEntity("billentry", parentRowIndex);
        for (int childRowIndex : childIndexList) {
            this.setKitDeliverOneColumnDefault(childRowIndex, parentEntry);
        }
    }

    private void setKitDeliverOneColumnDefault(Integer childRowIndex, DynamicObject parentEntry) {
        this.getModel().setValue("delivdays", parentEntry.get("delivdays"), childRowIndex.intValue());
    }

    private void setKitPriceColumnEnable(int rowIndex, String priceModel) {
        block10: {
            String productType;
            HashSet<String> enableColumn;
            block9: {
                enableColumn = new HashSet<String>();
                enableColumn.addAll(Arrays.asList(SimpleBillTplEntryConst.KITAMOUNTANDPRICEFIELDS));
                productType = (String)this.getModel().getValue("producttype", rowIndex);
                if (!ProductTypeEnum.KITPARENT.getValue().equals(productType)) break block9;
                DynamicObject parentEntry = this.getModel().getEntryRowEntity("billentry", rowIndex);
                priceModel = parentEntry.getString("pricemodel");
                if (PriceModelEnum.CHILD.getValue().equals(priceModel)) {
                    for (String column : enableColumn) {
                        this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{column});
                    }
                } else {
                    for (String column : enableColumn) {
                        this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{column});
                    }
                }
                break block10;
            }
            if (!ProductTypeEnum.KITCHILD.getValue().equals(productType)) break block10;
            if (priceModel == null) {
                priceModel = (String)this.getModel().getValue("pricemodel", rowIndex);
            }
            if (PriceModelEnum.PARENT.getValue().equals(priceModel)) {
                for (String column : enableColumn) {
                    this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{column});
                }
            } else {
                for (String column : enableColumn) {
                    this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{column});
                }
            }
        }
    }

    private void setKitDeliverColumnValue(List<Integer> childIndexList, int parentRowIndex, String column) {
        if (childIndexList == null || childIndexList.size() == 0) {
            return;
        }
        DynamicObject parentEntry = this.getModel().getEntryRowEntity("billentry", parentRowIndex);
        for (int childRowIndex : childIndexList) {
            this.getModel().setValue(column, parentEntry.get(column), childRowIndex);
        }
    }

    private void setKitDeliverColumnEnable(int rowIndex, String transfermodel) {
        DynamicObject parentRow;
        String productType = (String)this.getModel().getValue("producttype", rowIndex);
        if (!StringUtils.isEmpty((String)this.getPageCache().get(EXPANDKITPARENTROW))) {
            return;
        }
        if (ProductTypeEnum.KITCHILD.getValue().equals(productType) && (parentRow = this.getParentEntry(rowIndex)) != null) {
            DynamicObject kitBom = parentRow.getDynamicObject("bom");
            DynamicObject material = parentRow.getDynamicObject("material");
            if (kitBom != null && material != null && KitStructCtlEnum.NONADJ.getValue().equals(material.getString("kitstructctl"))) {
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"qty"});
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"unit"});
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"material"});
            }
        }
        if (ProductTypeEnum.KITCHILD.getValue().equals(productType)) {
            if (transfermodel == null) {
                transfermodel = (String)this.getModel().getValue("kittransfermodel", rowIndex);
            }
            if (KitTransferModelEnum.KIT.getValue().equals(transfermodel)) {
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"delivdays"});
            } else if (KitTransferModelEnum.NONKIT.getValue().equals(transfermodel)) {
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"delivdays"});
            }
        }
    }

    private List<Integer> getAllChildEntry(int parentRowIndex) {
        DynamicObject parentEntry = this.getModel().getEntryRowEntity("billentry", parentRowIndex);
        Long parentPid = parentEntry.getLong("kitpid");
        ArrayList<Integer> childEntryList = new ArrayList<Integer>();
        int rowCount = this.getModel().getEntryRowCount("billentry");
        for (int i = 0; i < rowCount; ++i) {
            Long pID = (Long)this.getModel().getValue("kitpid", i);
            String productType = (String)this.getModel().getValue("producttype", i);
            if (!ProductTypeEnum.KITCHILD.getValue().equals(productType) || parentPid.longValue() != pID.longValue()) continue;
            childEntryList.add(i);
        }
        return childEntryList;
    }

    private void calcChildRowQty(Integer parentRowIndex) {
        if (KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) {
            String productType = (String)this.getModel().getValue("producttype", parentRowIndex.intValue());
            if (ProductTypeEnum.KITPARENT.getValue().equals(productType)) {
                DynamicObject kitBom = (DynamicObject)this.getModel().getValue("bom", parentRowIndex.intValue());
                DynamicObject parentMaterial = (DynamicObject)this.getModel().getValue("material", parentRowIndex.intValue());
                if (kitBom != null && parentMaterial != null && KitStructCtlEnum.NONADJ.getValue().equals(parentMaterial.getString("kitstructctl"))) {
                    List<Integer> allChildIndexList = this.getAllChildEntry(parentRowIndex);
                    for (Integer childRowIndex : allChildIndexList) {
                        BigDecimal parentBaseQty = (BigDecimal)this.getModel().getValue("baseqty", parentRowIndex.intValue());
                        BigDecimal kitQty = (BigDecimal)this.getModel().getValue("kitqty", childRowIndex.intValue());
                        BigDecimal parentQty = (BigDecimal)this.getModel().getValue("parentqty", childRowIndex.intValue());
                        DynamicObject baseUnit = (DynamicObject)this.getModel().getValue("baseunit", childRowIndex.intValue());
                        DynamicObject material = (DynamicObject)this.getModel().getValue("material", childRowIndex.intValue());
                        DynamicObject unit = (DynamicObject)this.getModel().getValue("unit", childRowIndex.intValue());
                        if (parentBaseQty == null || parentBaseQty.compareTo(BigDecimal.ZERO) == 0 || parentQty == null || parentQty.compareTo(BigDecimal.ZERO) == 0 || kitQty == null || unit == null || baseUnit == null || material == null) continue;
                        DynamicObject masterMaterial = material.getDynamicObject("masterid");
                        int precision = KitSalesHelper.getUnitPrecision((DynamicObject)baseUnit);
                        RoundingMode roundingMode = KitSalesHelper.getUnitRoundingMode((DynamicObject)baseUnit);
                        BigDecimal baseQty = parentBaseQty.multiply(kitQty).divide(parentQty, precision, roundingMode);
                        BigDecimal qty = BillTplHelper.getDesQtyConv((DynamicObject)masterMaterial, (DynamicObject)baseUnit, (BigDecimal)baseQty, (DynamicObject)unit);
                        this.getModel().setValue("qty", (Object)qty, childRowIndex.intValue());
                    }
                }
            }
        }
    }

    private void setDiscountRateScale(Object newValue) {
        int priceRecision = 4;
        if (newValue instanceof DynamicObject) {
            DynamicObject settleCurrency = (DynamicObject)newValue;
            priceRecision = settleCurrency.getInt("priceprecision");
        }
        ClientViewProxy clientViewProxy = (ClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod("billentry", "setColEditorProp", new Object[]{"discountrate", "sc", priceRecision});
    }
}

