/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.formplugin.quote;

import java.lang.invoke.LambdaMetafactory;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mpscmm.msbd.business.helper.BizTypeHelper;
import kd.scmc.sm.business.helper.BillImportHelper;
import kd.scmc.sm.business.helper.BillTplHelper;
import kd.scmc.sm.business.helper.BillTypeParameterHelper;
import kd.scmc.sm.business.helper.CurrencyHelper;
import kd.scmc.sm.business.helper.CustomerHelper;
import kd.scmc.sm.business.helper.MaterialHelper;
import kd.scmc.sm.business.helper.MetaDataHelper;
import kd.scmc.sm.business.helper.OperationBizStatusHelper;
import kd.scmc.sm.business.helper.PropertyChangeHelper;
import kd.scmc.sm.business.helper.SimulateQuoteHelper;
import kd.scmc.sm.formplugin.tpl.CustomerPlugin;
import kd.scmc.sm.util.CommonUtils;

public class SimulateQuotePlugin
extends AbstractBillPlugIn
implements RowClickEventListener,
BeforeF7SelectListener,
EntryGridBindDataListener {
    private static final String CACHE_KEY_DEF_LINETYPEID = "SimulateQuotePlugin_def_linetype";
    private static final String CACHE_SUMAMOUNT = "SimulateQuotePlugin_sumAmount";
    public static final String TAXRATE_FILTER = "taxrate_filter";
    private static final String CACHE_KEY_BIZTYPEID = "cache_key_biztype_id";
    private static final String CONFIRM_LINETYPE = "confirm_linetype";
    private static final String CACHE_LINETYPE = "cache_linetype";

    public void registerListener(EventObject e) {
        BasedataEdit subUnitEdit;
        BasedataEdit subMaterialEdit;
        EntryGrid subEntry;
        BasedataEdit taxrateEdit;
        BasedataEdit unitEdit;
        BasedataEdit materialEdit;
        BasedataEdit linetype;
        EntryGrid entry;
        BasedataEdit linkaddressf7;
        BasedataEdit linkMan;
        BasedataEdit customer;
        BasedataEdit bizTypeEdit;
        Toolbar detailToolbar;
        super.registerListener(e);
        Toolbar entityToolbar = (Toolbar)this.getView().getControl("entrytoolbar");
        if (entityToolbar != null) {
            entityToolbar.addItemClickListener((ItemClickListener)this);
        }
        if ((detailToolbar = (Toolbar)this.getView().getControl("detailtoolbar")) != null) {
            detailToolbar.addItemClickListener((ItemClickListener)this);
        }
        if ((bizTypeEdit = (BasedataEdit)this.getView().getControl("biztype")) != null) {
            bizTypeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((customer = (BasedataEdit)this.getView().getControl("customer")) != null) {
            customer.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((linkMan = (BasedataEdit)this.getControl("linkman")) != null) {
            linkMan.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (this.getView().getControl("address") != null) {
            this.addClickListeners(new String[]{"address"});
        }
        if ((linkaddressf7 = (BasedataEdit)this.getControl("linkaddressf7")) != null) {
            linkaddressf7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((entry = (EntryGrid)this.getControl("billentry")) != null) {
            entry.addRowClickListener((RowClickEventListener)this);
            entry.addDataBindListener((EntryGridBindDataListener)this);
        }
        if ((linetype = (BasedataEdit)this.getControl("linetype")) != null) {
            linetype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((materialEdit = (BasedataEdit)this.getView().getControl("material")) != null) {
            materialEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((unitEdit = (BasedataEdit)this.getView().getControl("unit")) != null) {
            unitEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((taxrateEdit = (BasedataEdit)this.getView().getControl("taxrateid")) != null) {
            taxrateEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((subEntry = (EntryGrid)this.getControl("subentry")) != null) {
            subEntry.addRowClickListener((RowClickEventListener)this);
            subEntry.addDataBindListener((EntryGridBindDataListener)this);
        }
        if ((subMaterialEdit = (BasedataEdit)this.getView().getControl("submaterial")) != null) {
            subMaterialEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((subUnitEdit = (BasedataEdit)this.getView().getControl("subunit")) != null) {
            subUnitEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        try (TraceSpan span = Tracer.create((String)"SimulateQuotePlugin", (String)"afterCreateNewData");){
            String billCreType = this.getPageCache().get("billcretype");
            if (!BillImportHelper.isManual((String)billCreType)) {
                return;
            }
            this.initCurrencyDefaultValue();
            DynamicObject billType = (DynamicObject)this.getModel().getValue("billtype");
            this.changeBillType(billType);
            int entryRowCount = this.getModel().getEntryRowCount("billentry");
            for (int i = 0; i < entryRowCount; ++i) {
                this.initNewDataEntry(i);
            }
            this.getPageCache().remove(CACHE_KEY_DEF_LINETYPEID);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billentry");
        if (entryGrid != null) {
            entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        try (TraceSpan span = Tracer.create((String)"SimulateQuotePlugin", (String)"afterBindData");){
            OperationBizStatusHelper.setEnableByBizStatus((IFormView)this.getView());
            if (this.getModel().getValue("customer") == null) {
                DynamicObject quoteCurrency = (DynamicObject)this.getModel().getValue("settlecurrency");
                DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
                if (quoteCurrency == null && currency != null) {
                    this.getModel().setValue("settlecurrency", currency.getPkValue());
                }
            }
            this.queryTaxRate();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void beforeF7Select(BeforeF7SelectEvent e) {
        key = e.getProperty().getName();
        bill = this.getModel();
        showParameter = (ListShowParameter)e.getFormShowParameter();
        org = null;
        billType = (DynamicObject)bill.getValue("billtype");
        if (billType == null && !"linkman".equals(key) && !"linkaddressf7".equals(key)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u7c7b\u578b\u3002", (String)"SimulateQuotePlugin_1", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        entry = (AbstractGrid)this.getControl("billentry");
        entryFocusRow = entry.getEntryState().getFocusRow();
        if (entryFocusRow == -1) {
            entryFocusRow = 0;
        }
        span = Tracer.create((String)"SimulateQuotePlugin", (String)("beforeF7Select: " + e.getProperty().getName()));
        var10_10 = null;
        try {
            var11_11 = key;
            var12_14 = -1;
            switch (var11_11.hashCode()) {
                case 606175198: {
                    if (!var11_11.equals("customer")) break;
                    var12_14 = 0;
                    break;
                }
                case 177093408: {
                    if (!var11_11.equals("linkman")) break;
                    var12_14 = 1;
                    break;
                }
                case 272311499: {
                    if (!var11_11.equals("linkaddressf7")) break;
                    var12_14 = 2;
                    break;
                }
                case 1189618990: {
                    if (!var11_11.equals("linetype")) break;
                    var12_14 = 3;
                    break;
                }
                case 299066663: {
                    if (!var11_11.equals("material")) break;
                    var12_14 = 4;
                    break;
                }
                case 3594628: {
                    if (!var11_11.equals("unit")) break;
                    var12_14 = 5;
                    break;
                }
                case 525710694: {
                    if (!var11_11.equals("taxrateid")) break;
                    var12_14 = 6;
                    break;
                }
                case -96646451: {
                    if (!var11_11.equals("biztype")) break;
                    var12_14 = 7;
                    break;
                }
                case 1548936039: {
                    if (!var11_11.equals("submaterial")) break;
                    var12_14 = 8;
                    break;
                }
                case -1867548732: {
                    if (!var11_11.equals("subunit")) break;
                    var12_14 = 9;
                }
            }
            switch (var12_14) {
                case 0: {
                    org = (DynamicObject)bill.getValue("org");
                    if (org == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u62a5\u4ef7\u7ec4\u7ec7\u3002", (String)"SimulateQuotePlugin_0", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        e.setCancel(true);
                        return;
                    }
                    bizfunction = new QFilter("bizfunction", "like", (Object)"%1%");
                    showParameter.getListFilterParameter().getQFilters().add(bizfunction);
                    ** break;
lbl70:
                    // 1 sources

                    break;
                }
                case 1: {
                    customers = (DynamicObject)this.getModel().getValue("customer");
                    if (customers == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ba2\u8d27\u5ba2\u6237\u3002", (String)"SimulateQuotePlugin_2", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        e.setCancel(true);
                        ** break;
lbl77:
                        // 1 sources

                    } else {
                        linkman = customers.getDynamicObjectCollection("entry_linkman");
                        invalid = linkman.stream().filter((Predicate<DynamicObject>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$beforeF7Select$0(kd.bos.dataentity.entity.DynamicObject ), (Lkd/bos/dataentity/entity/DynamicObject;)Z)()).map((Function<DynamicObject, Long>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$beforeF7Select$1(kd.bos.dataentity.entity.DynamicObject ), (Lkd/bos/dataentity/entity/DynamicObject;)Ljava/lang/Long;)()).collect(Collectors.toList());
                        customerid = new QFilter("customerid", "=", customers.getPkValue());
                        ids = new QFilter("id", "in", invalid);
                        showParameter.getListFilterParameter().setFilter(customerid.and(ids));
                        ** break;
                    }
lbl84:
                    // 1 sources

                    break;
                }
                case 2: {
                    customer = (DynamicObject)this.getModel().getValue("customer");
                    if (customer == null) ** break;
                    id1 = new QFilter("customerid", "in", (Object)customer.getPkValue().toString());
                    id2 = new QFilter("invalid", "=", (Object)"0");
                    showParameter.getListFilterParameter().setQFilters(Arrays.asList(new QFilter[]{id1, id2}));
                    ** break;
lbl92:
                    // 1 sources

                    break;
                }
                case 3: {
                    biztype = (DynamicObject)this.getModel().getValue("biztype");
                    if (biztype != null) {
                        lineTypeId = BizTypeHelper.getAllLineTypes((Long)((Long)biztype.getPkValue()));
                        showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)lineTypeId));
                        ** break;
lbl100:
                        // 1 sources

                    } else {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"SimulateQuotePlugin_3", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        e.setCancel(true);
                        ** break;
                    }
lbl104:
                    // 1 sources

                    break;
                }
                case 4: {
                    org = (DynamicObject)bill.getValue("org");
                    if (org == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u62a5\u4ef7\u7ec4\u7ec7\u3002", (String)"SimulateQuotePlugin_0", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        e.setCancel(true);
                        return;
                    }
                    bizType = (DynamicObject)this.getModel().getValue("biztype");
                    if (bizType == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"SimulateQuotePlugin_3", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        e.setCancel(true);
                        return;
                    }
                    lineType = (DynamicObject)this.getModel().getValue("linetype", e.getRow());
                    if (lineType == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u884c\u7c7b\u578b\u3002", (String)"SimulateQuotePlugin_4", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        e.setCancel(true);
                        return;
                    }
                    if (billType == null) {
                        return;
                    }
                    qf = MaterialHelper.getQFilterByLineType((Long)((Long)billType.getPkValue()), (Long)((Long)bizType.getPkValue()), (Long)((Long)lineType.getPkValue()), (boolean)true);
                    if (qf != null && qf.size() > 0) {
                        showParameter.getListFilterParameter().getQFilters().addAll(qf);
                        ** break;
                    }
lbl128:
                    // 3 sources

                    break;
                }
                case 5: {
                    rowIndex = this.getModel().getEntryCurrentRowIndex("billentry");
                    material = (DynamicObject)bill.getValue("material", rowIndex);
                    if (material == null || material.getDynamicObject("masterid") == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u7f16\u7801\u3002", (String)"SimulateQuotePlugin_5", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        e.setCancel(true);
                        ** break;
lbl136:
                        // 1 sources

                    } else {
                        masterMaterial = material.getDynamicObject("masterid");
                        baseUnit = (DynamicObject)bill.getValue("baseunit", rowIndex);
                        srcmuId = baseUnit == null ? Long.valueOf(0L) : (Long)baseUnit.getPkValue();
                        masterMaterialId = (Long)masterMaterial.getPkValue();
                        unitIds = BaseDataServiceHelper.getAssistMUListResult((Long)masterMaterialId, (Long)srcmuId, (String)"1");
                        qFilter = new QFilter("id", "in", (Object)unitIds);
                        showParameter.getListFilterParameter().setFilter(qFilter);
                        ** break;
                    }
lbl145:
                    // 1 sources

                    break;
                }
                case 6: {
                    org = (DynamicObject)bill.getValue("org");
                    if (org == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u62a5\u4ef7\u7ec4\u7ec7\u3002", (String)"SimulateQuotePlugin_0", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        e.setCancel(true);
                        return;
                    }
                    taxRateFilter = this.getPageCache().get("taxrate_filter");
                    if (kd.bos.util.StringUtils.isNotEmpty((String)(taxRateFilter = taxRateFilter.substring(1, taxRateFilter.length() - 1)))) {
                        taxRateIds = taxRateFilter.split("_");
                        taxRateIdList = new ArrayList<Long>(taxRateIds.length);
                        for (String id : taxRateIds) {
                            if (id == null || "".equals(id)) continue;
                            taxRateIdList.add(Long.valueOf(id));
                        }
                        filter = new QFilter("id", "in", taxRateIdList);
                        showParameter.getListFilterParameter().setFilter(filter);
                        ** break;
lbl164:
                        // 1 sources

                    } else {
                        filter = QFilter.of((String)"1=-1", (Object[])new Object[0]);
                        showParameter.getListFilterParameter().setFilter(filter);
                        ** break;
                    }
lbl168:
                    // 1 sources

                    break;
                }
                ** case 7:
                case 8: {
                    org = (DynamicObject)bill.getValue("org");
                    if (org == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u62a5\u4ef7\u7ec4\u7ec7\u3002", (String)"SimulateQuotePlugin_0", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        e.setCancel(true);
                        return;
                    }
                    if (entryFocusRow != -1) ** break;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u62a5\u4ef7\u7269\u6599\u5206\u5f55\u884c\u3002", (String)"SimulateQuotePlugin_6", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    ** break;
lbl180:
                    // 1 sources

                    break;
                }
                case 9: {
                    if (entryFocusRow == -1) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u62a5\u4ef7\u7269\u6599\u5206\u5f55\u884c\u3002", (String)"SimulateQuotePlugin_6", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        e.setCancel(true);
                    }
                    if ((subMaterial = (DynamicObject)bill.getValue("submaterial", subRowIndex = this.getModel().getEntryCurrentRowIndex("subentry"))) == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u7f16\u7801\u3002", (String)"SimulateQuotePlugin_5", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        e.setCancel(true);
                        ** break;
lbl189:
                        // 1 sources

                    } else {
                        baseUnit = (DynamicObject)bill.getValue("subbaseunit", subRowIndex);
                        srcmuId = baseUnit == null ? Long.valueOf(0L) : (Long)baseUnit.getPkValue();
                        masterMaterialId = (Long)subMaterial.getPkValue();
                        unitIds = BaseDataServiceHelper.getAssistMUListResult((Long)masterMaterialId, (Long)srcmuId, (String)"1");
                        qFilter = new QFilter("id", "in", (Object)unitIds);
                        showParameter.getListFilterParameter().setFilter(qFilter);
                        ** break;
                    }
lbl197:
                    // 1 sources

                    break;
                }
                ** default:
lbl199:
                // 1 sources

                break;
            }
        }
        catch (Throwable var11_13) {
            var10_10 = var11_13;
            throw var11_13;
        }
        finally {
            if (span != null) {
                if (var10_10 != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable var13_15) {
                        var10_10.addSuppressed(var13_15);
                    }
                } else {
                    span.close();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void propertyChanged(PropertyChangedArgs e) {
        String billcretype = this.getPageCache().get("billcretype");
        if (!BillImportHelper.isManual((String)billcretype)) {
            return;
        }
        if (PropertyChangeHelper.isStopPropertyChange((IPageCache)this.getPageCache())) {
            return;
        }
        AbstractGrid entry = (AbstractGrid)this.getControl("billentry");
        int entryFocusRow = entry.getEntryState().getFocusRow();
        if (entryFocusRow == -1) {
            entryFocusRow = 0;
        }
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        try (TraceSpan span = Tracer.create((String)"SimulateQuotePlugin", (String)("propertyChanged: " + e.getProperty().getName()));){
            switch (propName) {
                case "biztype": {
                    DynamicObject oldValue = (DynamicObject)valueSet[0].getOldValue();
                    DynamicObject newValue = (DynamicObject)valueSet[0].getNewValue();
                    if (Objects.equals(newValue, oldValue)) return;
                    this.getPageCache().put(CACHE_KEY_BIZTYPEID, String.valueOf(oldValue == null ? Long.valueOf(0L) : oldValue.getPkValue()));
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u201c\u4e1a\u52a1\u7c7b\u578b\u201d\u5207\u6362\uff0c\u5c06\u6e05\u9664\u5f53\u524d\u5355\u636e\u62a5\u4ef7\u7269\u6599\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"SimulateQuotePlugin_7", (String)"scmc-sm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(propName, (IFormPlugin)this));
                    return;
                }
                case "bizdate": {
                    int i = 0;
                    while (i < valueSet.length) {
                        if (CommonUtils.isRealChanged((ChangeData)valueSet[i])) {
                            this.queryTaxRate();
                        }
                        ++i;
                    }
                    return;
                }
                case "customer": {
                    int i = 0;
                    while (i < valueSet.length) {
                        if (CommonUtils.isRealChanged((ChangeData)valueSet[i])) {
                            this.customerChanged((DynamicObject)valueSet[i].getNewValue());
                        }
                        ++i;
                    }
                    return;
                }
                case "linkaddressf7": {
                    int i = 0;
                }
                case "settlecurrency": {
                    int i = 0;
                }
                case "material": {
                    int i = 0;
                    while (i < valueSet.length) {
                        if (CommonUtils.isRealChanged((ChangeData)valueSet[i])) {
                            int curRow;
                            int rowIndex = valueSet[i].getRowIndex();
                            this.changeMaterial((DynamicObject)valueSet[i].getNewValue(), rowIndex);
                            if (valueSet[i].getNewValue() != null && (curRow = this.getModel().getEntryCurrentRowIndex("billentry")) != rowIndex) {
                                PropertyChangeHelper.stopPropertyChange((IPageCache)this.getPageCache());
                                this.getModel().setValue("linetype", this.getModel().getValue("linetype", curRow), rowIndex);
                                PropertyChangeHelper.releasePropertyChange((IPageCache)this.getPageCache());
                            }
                        }
                        ++i;
                    }
                    return;
                }
                case "taxrateid": {
                    int i = 0;
                    while (i < valueSet.length) {
                        if (CommonUtils.isRealChanged((ChangeData)valueSet[i])) {
                            int rowIndex = valueSet[i].getRowIndex();
                            DynamicObject taxRateID = (DynamicObject)valueSet[i].getNewValue();
                            if (taxRateID != null) {
                                this.getModel().setValue("taxrate", taxRateID.get("taxrate"), rowIndex);
                            } else {
                                this.getModel().setValue("taxrate", (Object)0, rowIndex);
                            }
                            this.calculatePrice(rowIndex);
                        }
                        ++i;
                    }
                    return;
                }
                case "costuprate": {
                    int i = 0;
                    while (i < valueSet.length) {
                        if (CommonUtils.isRealChanged((ChangeData)valueSet[i])) {
                            int rowIndex = valueSet[i].getRowIndex();
                            this.calculatePrice(rowIndex);
                        }
                        ++i;
                    }
                    return;
                }
                case "qty": 
                case "unit": {
                    int i = 0;
                    while (true) {
                        if (i >= valueSet.length) {
                            this.doRefresh(valueSet);
                            return;
                        }
                        if (CommonUtils.isRealChanged((ChangeData)valueSet[i])) {
                            int rowIndex = valueSet[i].getRowIndex();
                            BillTplHelper.calcQtyAndBaseQty((int)rowIndex, (IDataModel)this.getModel());
                        }
                        ++i;
                    }
                }
                case "linetype": {
                    int i = 0;
                    while (i < valueSet.length) {
                        if (CommonUtils.isRealChanged((ChangeData)valueSet[i])) {
                            this.changeLineType(valueSet[i].getOldValue(), valueSet[i].getNewValue(), valueSet[i].getRowIndex());
                        }
                        ++i;
                    }
                    return;
                }
                case "submaterial": {
                    if (entryFocusRow == -1) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u62a5\u4ef7\u7269\u6599\u5206\u5f55\u884c\u3002", (String)"SimulateQuotePlugin_6", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    int i = 0;
                    while (i < valueSet.length) {
                        if (CommonUtils.isRealChanged((ChangeData)valueSet[i])) {
                            int rowIndex = valueSet[i].getRowIndex();
                            ChangeData changeData = valueSet[i];
                            DynamicObject dataEntity = changeData.getDataEntity();
                            this.changeSubMaterial(entryFocusRow, dataEntity, (DynamicObject)valueSet[i].getNewValue(), rowIndex);
                            SimulateQuoteHelper.calcSubAmount((int)entryFocusRow, (int)rowIndex, (IDataModel)this.getModel());
                        }
                        ++i;
                    }
                    return;
                }
                case "subqty": 
                case "subunit": {
                    if (entryFocusRow == -1) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u62a5\u4ef7\u7269\u6599\u5206\u5f55\u884c\u3002", (String)"SimulateQuotePlugin_6", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    int i = 0;
                    while (true) {
                        if (i >= valueSet.length) {
                            this.doRefreshSub(valueSet);
                            return;
                        }
                        if (CommonUtils.isRealChanged((ChangeData)valueSet[i])) {
                            int rowIndex = valueSet[i].getRowIndex();
                            SimulateQuoteHelper.calcSubQtyAndBaseQty((int)rowIndex, (IDataModel)this.getModel());
                            SimulateQuoteHelper.calcSubAmount((int)entryFocusRow, (int)rowIndex, (IDataModel)this.getModel());
                        }
                        ++i;
                    }
                }
                case "submaterialprice": 
                case "subprocessprice": 
                case "subworkhours": 
                case "subworkprice": 
                case "submanufactureprice": 
                case "subpieceworkprice": {
                    if (entryFocusRow == -1) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u62a5\u4ef7\u7269\u6599\u5206\u5f55\u884c\u3002", (String)"SimulateQuotePlugin_6", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    int i = 0;
                    while (i < valueSet.length) {
                        if (CommonUtils.isRealChanged((ChangeData)valueSet[i])) {
                            int rowIndex = valueSet[i].getRowIndex();
                            SimulateQuoteHelper.calcSubAmount((int)entryFocusRow, (int)rowIndex, (IDataModel)this.getModel());
                        }
                        ++i;
                    }
                    return;
                }
            }
            return;
        }
    }

    private void changeLineType(Object oldValue, Object newValue, int rowIndex) {
        if (oldValue != null && newValue == null) {
            PropertyChangeHelper.stopPropertyChange((IPageCache)this.getPageCache());
            this.getModel().setValue("linetype", ((DynamicObject)oldValue).getPkValue(), rowIndex);
            PropertyChangeHelper.releasePropertyChange((IPageCache)this.getPageCache());
            return;
        }
        ConfirmCallBackListener callBack = new ConfirmCallBackListener(CONFIRM_LINETYPE, (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u201c\u884c\u7c7b\u578b\u201d\u5c06\u6e05\u9664\u5f53\u524d\u5206\u5f55\u7269\u6599\u4fe1\u606f\uff0c\u662f\u5426\u5207\u6362\uff1f", (String)"SimulateQuotePlugin_8", (String)"scmc-sm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, callBack);
        this.getView().getPageCache().put(CACHE_LINETYPE, oldValue == null ? null : ((DynamicObject)oldValue).getPkValue().toString());
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        if (c.getKey().equalsIgnoreCase("address")) {
            DynamicObject customer = (DynamicObject)this.getModel().getValue("customer");
            if (customer == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ba2\u8d27\u5ba2\u6237\u3002", (String)"SimulateQuotePlugin_2", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                return;
            }
            BasedataEdit linkAddressF7 = (BasedataEdit)this.getControl("linkaddressf7");
            linkAddressF7.click();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key;
        super.afterDoOperation(e);
        switch (key = e.getOperateKey()) {
            case "bizclose": 
            case "bizunclose": {
                OperationBizStatusHelper.setEnableByBizStatus((IFormView)this.getView());
                break;
            }
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        if ("subentry".equals(e.getEntryProp().getName())) {
            AbstractGrid entry = (AbstractGrid)this.getControl("billentry");
            int entryFocusRow = entry.getEntryState().getFocusRow();
            if (entryFocusRow == -1) {
                entryFocusRow = 0;
            }
            Map sumAmount = SimulateQuoteHelper.getHeadAmount((int)entryFocusRow, (IDataModel)this.getModel(), (int[])e.getRowIndexs());
            this.getPageCache().put(CACHE_SUMAMOUNT, SerializationUtils.toJsonString((Object)sumAmount));
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        Map amountMap;
        String sumAmount;
        super.afterDeleteRow(e);
        if ("subentry".equals(e.getEntryProp().getName()) && (sumAmount = this.getPageCache().get(CACHE_SUMAMOUNT)) != null && !"".equals(sumAmount) && (amountMap = (Map)SerializationUtils.fromJsonString((String)sumAmount, HashMap.class)) != null && amountMap.size() > 0) {
            AbstractGrid entry = (AbstractGrid)this.getControl("billentry");
            int entryFocusRow = entry.getEntryState().getFocusRow();
            if (entryFocusRow == -1) {
                entryFocusRow = 0;
            }
            this.getModel().setValue("materialcost", amountMap.get("materialcost"), entryFocusRow);
            this.getModel().setValue("processcost", amountMap.get("processcost"), entryFocusRow);
            this.getModel().setValue("manufacturecost", amountMap.get("manufacturecost"), entryFocusRow);
            this.getModel().setValue("laborcost", amountMap.get("laborcost"), entryFocusRow);
            this.getModel().setValue("pieceworkamount", amountMap.get("pieceworkamount"), entryFocusRow);
            this.getModel().setValue("quotecost", amountMap.get("quotecost"), entryFocusRow);
            this.getModel().setValue("price", amountMap.get("price"), entryFocusRow);
            this.getModel().setValue("priceandtax", amountMap.get("priceandtax"), entryFocusRow);
            this.getPageCache().remove(CACHE_SUMAMOUNT);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        if ("billentry".equals(entryName)) {
            RowDataEntity[] rowDataEntities;
            for (RowDataEntity rowDataEntity : rowDataEntities = e.getRowDataEntities()) {
                int rowIndex = rowDataEntity.getRowIndex();
                DynamicObject lineType = (DynamicObject)this.getModel().getValue("linetype", rowIndex);
                if (!CommonUtils.isNull((Object)lineType)) continue;
                this.initNewDataEntry(rowIndex);
            }
            this.getPageCache().remove(CACHE_KEY_DEF_LINETYPEID);
        } else if ("subentry".equals(entryName)) {
            RowDataEntity[] rowDataEntities;
            AbstractGrid entry = (AbstractGrid)this.getControl("billentry");
            int entryFocusRow = entry.getEntryState().getFocusRow();
            if (entryFocusRow == -1) {
                entryFocusRow = 0;
            }
            for (RowDataEntity rowDataEntity : rowDataEntities = e.getRowDataEntities()) {
                int rowIndex = rowDataEntity.getRowIndex();
                this.getModel().setValue("submaterialamount", null, rowIndex);
                this.getModel().setValue("subprocessamount", null, rowIndex);
                this.getModel().setValue("sublaborcost", null, rowIndex);
                this.getModel().setValue("submanufacturecost", null, rowIndex);
                this.getModel().setValue("subpieceworkamount", null, rowIndex);
                SimulateQuoteHelper.calcSubAmount((int)entryFocusRow, (int)rowIndex, (IDataModel)this.getModel());
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent e) {
        String itemKey;
        switch (itemKey = e.getItemKey()) {
            case "bar_save": {
                DynamicObject billType = (DynamicObject)this.getModel().getValue("billtype");
                if (billType == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u7c7b\u578b\u3002", (String)"SimulateQuotePlugin_1", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                if (org != null) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u62a5\u4ef7\u7ec4\u7ec7\u3002", (String)"SimulateQuotePlugin_0", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            case "addsubrow": {
                AbstractGrid entry = (AbstractGrid)this.getControl("billentry");
                int focusRow = entry.getEntryState().getFocusRow();
                if (focusRow != -1) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u62a5\u4ef7\u7269\u6599\u5206\u5f55\u884c\u3002", (String)"SimulateQuotePlugin_6", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if ("biztype".equals(event.getCallBackId())) {
            String bizTypeId;
            if (event.getResult() == MessageBoxResult.Yes) {
                this.getModel().deleteEntryData("billentry");
                this.getModel().deleteEntryData("subentry");
                this.getModel().createNewEntryRow("billentry");
                this.initNewDataEntry(0);
            } else if (event.getResult() == MessageBoxResult.Cancel && kd.bos.util.StringUtils.isNotEmpty((String)(bizTypeId = this.getPageCache().get(CACHE_KEY_BIZTYPEID)))) {
                this.getModel().beginInit();
                if ("0".equals(bizTypeId)) {
                    this.getModel().setValue("biztype", null);
                } else {
                    this.getModel().setValue("biztype", (Object)Long.parseLong(bizTypeId));
                }
                this.getModel().endInit();
                this.getView().updateView("biztype");
            }
            this.getPageCache().remove(CACHE_KEY_DEF_LINETYPEID);
        } else if (StringUtils.equals((CharSequence)CONFIRM_LINETYPE, (CharSequence)event.getCallBackId())) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("billentry");
            if (event.getResult() == MessageBoxResult.Yes) {
                this.getModel().setValue("material", null, rowIndex);
            } else {
                String lineTypeId = this.getView().getPageCache().get(CACHE_LINETYPE);
                this.getModel().beginInit();
                this.getModel().setValue("linetype", (Object)(lineTypeId == null ? null : Long.valueOf(Long.parseLong(lineTypeId))), rowIndex);
                this.getModel().endInit();
                this.getView().updateView("linetype", rowIndex);
                this.getView().getPageCache().remove(CACHE_LINETYPE);
            }
        }
    }

    private void changeMaterial(DynamicObject material, int rowIndex) {
        PropertyChangeHelper.stopPropertyChange((IPageCache)this.getPageCache());
        this.getModel().setValue("unit", null, rowIndex);
        this.getModel().setValue("baseunit", null, rowIndex);
        this.getModel().setValue("qty", (Object)new BigDecimal(1L), rowIndex);
        this.getModel().setValue("baseqty", null, rowIndex);
        this.getModel().setValue("price", null, rowIndex);
        this.getModel().setValue("priceandtax", null, rowIndex);
        this.getModel().setValue("taxrateid", null, rowIndex);
        this.getModel().setValue("taxrate", null, rowIndex);
        if (material != null) {
            DynamicObject taxrate;
            DynamicObject masterMaterial = material.getDynamicObject("masterid");
            if (masterMaterial != null && masterMaterial.getDynamicObject("baseunit") != null) {
                this.getModel().setValue("baseunit", masterMaterial.getDynamicObject("baseunit").getPkValue(), rowIndex);
            }
            if (material.getDynamicObject("salesunit") != null) {
                this.getModel().setValue("unit", material.getDynamicObject("salesunit").getPkValue(), rowIndex);
            }
            BigDecimal qty = new BigDecimal(1L);
            DynamicObject unit = (DynamicObject)this.getModel().getValue("unit", rowIndex);
            DynamicObject baseUnit = (DynamicObject)this.getModel().getValue("baseunit", rowIndex);
            if (unit != null && baseUnit != null) {
                int precision = unit.getInt("precision");
                int precisionaccount = BillTplHelper.getRoundMode((DynamicObject)unit);
                qty = qty.setScale(precision, precisionaccount);
                this.getModel().setValue("qty", (Object)qty, rowIndex);
                BigDecimal baseQty = BigDecimal.ZERO;
                if (qty.compareTo(BigDecimal.ZERO) != 0) {
                    baseQty = BillTplHelper.getDesQtyConv((DynamicObject)masterMaterial, (DynamicObject)unit, (BigDecimal)qty, (DynamicObject)baseUnit);
                }
                this.getModel().setValue("baseqty", (Object)baseQty, rowIndex);
            }
            if (masterMaterial != null && masterMaterial.getDynamicObject("taxrate") != null) {
                this.getModel().setValue("taxrateid", masterMaterial.getDynamicObject("taxrate").getPkValue(), rowIndex);
                taxrate = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_taxrate", (String)"taxrate", (QFilter[])new QFilter[]{new QFilter("id", "=", masterMaterial.getDynamicObject("taxrate").getPkValue())});
                this.getModel().setValue("taxrate", (Object)taxrate.getBigDecimal("taxrate"), rowIndex);
            } else {
                DynamicObject customer = (DynamicObject)this.getModel().getValue("customer");
                if (customer != null && customer.getDynamicObject("taxrate") != null) {
                    this.getModel().setValue("taxrateid", customer.getDynamicObject("taxrate").getPkValue(), rowIndex);
                    DynamicObject customerTaxrate = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_taxrate", (String)"taxrate", (QFilter[])new QFilter[]{new QFilter("id", "=", customer.getDynamicObject("taxrate").getPkValue())});
                    this.getModel().setValue("taxrate", (Object)customerTaxrate.getBigDecimal("taxrate"), rowIndex);
                }
            }
            if (this.getModel().getValue("taxrateid", rowIndex) != null) {
                taxrate = (DynamicObject)this.getModel().getValue("taxrateid", rowIndex);
                String taxrate_filter = this.getPageCache().get(TAXRATE_FILTER);
                String[] taxrateIds = (taxrate_filter = taxrate_filter.substring(1, taxrate_filter.length() - 1)).split("_");
                if (taxrateIds.length > 0 && !Arrays.asList(taxrateIds).contains(taxrate.getPkValue().toString())) {
                    this.getModel().setValue("taxrateid", null, rowIndex);
                    this.getModel().setValue("taxrate", null, rowIndex);
                }
            }
        }
        PropertyChangeHelper.releasePropertyChange((IPageCache)this.getPageCache());
        this.calculatePrice(rowIndex);
    }

    private void changeSubMaterial(int parentFocusRow, DynamicObject subRowData, DynamicObject material, int rowIndex) {
        PropertyChangeHelper.stopPropertyChange((IPageCache)this.getPageCache());
        this.getModel().setValue("subunit", null, rowIndex);
        this.getModel().setValue("subbaseunit", null, rowIndex);
        this.getModel().setValue("subqtynumerator", null, rowIndex);
        this.getModel().setValue("subqtydenominator", (Object)new BigDecimal(1L), rowIndex);
        this.getModel().setValue("subqty", null, rowIndex);
        this.getModel().setValue("subbaseqty", null, rowIndex);
        if (material != null && material.getDynamicObject("baseunit") != null) {
            this.getModel().setValue("subbaseunit", material.getDynamicObject("baseunit").getPkValue(), rowIndex);
            this.getModel().setValue("subunit", material.getDynamicObject("baseunit").getPkValue(), rowIndex);
        }
        PropertyChangeHelper.releasePropertyChange((IPageCache)this.getPageCache());
    }

    private void customerChanged(DynamicObject customer) {
        IDataModel model = this.getModel();
        if (customer == null) {
            this.getModel().setValue("linkman", null);
            this.getModel().setValue("address", null);
            this.setValueIfExists("settlecurrency", () -> model.getValue("currency"));
            return;
        }
        model.beginInit();
        this.setValueIfExists("linkman", () -> CustomerHelper.getLinkman((DynamicObject)customer));
        this.setValueIfExists("address", () -> CustomerHelper.getAddress((DynamicObject)customer));
        model.endInit();
        if (customer.getDynamicObject("settlementcyid") != null) {
            this.setValueIfExists("settlecurrency", () -> BusinessDataServiceHelper.loadSingleFromCache((Object)customer.getDynamicObject("settlementcyid").getPkValue(), (String)"bd_currency", (String)"id, number, name, amtprecision,priceprecision,sign,isshowsign"));
        } else {
            this.setValueIfExists("settlecurrency", () -> model.getValue("currency"));
        }
        this.getView().updateView("linkman");
        this.getView().updateView("address");
        this.getView().updateView("linkmanphone");
    }

    private void setValueIfExists(String property, CustomerPlugin.ValueHandle handle) {
        if (MetaDataHelper.isExistField((IDataEntityType)this.getModel().getDataEntityType(), (String)property)) {
            if (handle.getValue() != null && handle.getValue() instanceof DynamicObject) {
                this.getModel().setValue(property, ((DynamicObject)handle.getValue()).getPkValue());
            } else {
                this.getModel().setValue(property, handle.getValue());
            }
        }
    }

    private void doRefresh(ChangeData[] valueSet) {
        for (int i = 0; i < valueSet.length; ++i) {
            this.getView().updateView("price", valueSet[i].getRowIndex());
            this.getView().updateView("priceandtax", valueSet[i].getRowIndex());
            this.getView().updateView("qty", valueSet[i].getRowIndex());
            this.getView().updateView("baseqty", valueSet[i].getRowIndex());
            this.getView().updateView("baseunit", valueSet[i].getRowIndex());
        }
    }

    private void doRefreshSub(ChangeData[] valueSet) {
        for (int i = 0; i < valueSet.length; ++i) {
            this.getView().updateView("subqtynumerator", valueSet[i].getRowIndex());
            this.getView().updateView("subqtydenominator", valueSet[i].getRowIndex());
            this.getView().updateView("subqty", valueSet[i].getRowIndex());
            this.getView().updateView("subunit", valueSet[i].getRowIndex());
            this.getView().updateView("subbaseqty", valueSet[i].getRowIndex());
            this.getView().updateView("subbaseunit", valueSet[i].getRowIndex());
        }
    }

    private void initNewDataEntry(int rowIndex) {
        DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
        PropertyChangeHelper.stopPropertyChange((IPageCache)this.getPageCache());
        this.getModel().setValue("linetype", (Object)this.getDefLineTypeFromPageCache(bizType), rowIndex);
        PropertyChangeHelper.releasePropertyChange((IPageCache)this.getPageCache());
    }

    private Long getDefLineTypeFromPageCache(DynamicObject biztype) {
        if (biztype == null || Objects.equals(0L, biztype.getPkValue())) {
            return null;
        }
        String lineTypeIDCache = this.getPageCache().get(CACHE_KEY_DEF_LINETYPEID);
        if (kd.bos.util.StringUtils.isNotEmpty((String)lineTypeIDCache)) {
            return Long.valueOf(lineTypeIDCache);
        }
        Long lineTypeID = BizTypeHelper.getDefaultLineType((Long)((Long)biztype.getPkValue()));
        if (lineTypeID != null && !Objects.equals(0L, lineTypeID)) {
            this.getPageCache().put(CACHE_KEY_DEF_LINETYPEID, String.valueOf(lineTypeID));
            return lineTypeID;
        }
        return null;
    }

    private void initCurrencyDefaultValue() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            DynamicObject exRateTable;
            Map map = CurrencyHelper.getCurrencyAndExRateTable((Long)((Long)org.getPkValue()));
            if (map == null) {
                return;
            }
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            if (currency == null) {
                this.getModel().setValue("currency", map.get("baseCurrencyID"));
            }
            if ((exRateTable = (DynamicObject)this.getModel().getValue("exratetable")) == null) {
                this.getModel().setValue("exratetable", map.get("exchangeRateTableID"));
            }
        }
    }

    private void changeBillType(DynamicObject billType) {
        String formid = this.getView().getEntityId();
        if (billType == null) {
            this.getModel().setValue("biztype", null);
        } else {
            Long biztype;
            DynamicObject billTypeParam = BillTypeParameterHelper.getBillTypeParameter((String)formid, (long)((Long)billType.getPkValue()));
            if (billTypeParam != null && (biztype = BizTypeHelper.getDefaultBizType((String)formid, (Long)((Long)billType.getPkValue()), (String)"sm_billtypeparam")) != null) {
                this.getModel().setValue("biztype", (Object)biztype);
            }
        }
    }

    private void calculatePrice(int rowIndex) {
        BigDecimal taxRate = (BigDecimal)this.getModel().getValue("taxrate", rowIndex);
        taxRate = taxRate.divide(new BigDecimal(100));
        BigDecimal quotecost = (BigDecimal)this.getModel().getValue("quotecost", rowIndex);
        BigDecimal costuprate = (BigDecimal)this.getModel().getValue("costuprate", rowIndex);
        costuprate = costuprate.divide(new BigDecimal(100));
        BigDecimal qty = (BigDecimal)this.getModel().getValue("qty", rowIndex);
        if (BigDecimal.ZERO.compareTo(qty) >= 0) {
            qty = new BigDecimal(1L);
        }
        this.getModel().beginInit();
        BigDecimal price = quotecost.multiply(BigDecimal.ONE.add(costuprate)).divide(qty, 10, 4);
        BigDecimal priceAndTax = quotecost.multiply(BigDecimal.ONE.add(costuprate)).multiply(BigDecimal.ONE.add(taxRate)).divide(qty, 10, 4);
        this.getModel().setValue("price", (Object)price, rowIndex);
        this.getModel().setValue("priceandtax", (Object)priceAndTax, rowIndex);
        this.getModel().endInit();
        this.getView().updateView("price", rowIndex);
        this.getView().updateView("priceandtax", rowIndex);
    }

    private void queryTaxRate() {
        Date bizTime = (Date)this.getModel().getValue("bizdate");
        QFilter q1 = new QFilter("activedate", "<=", (Object)bizTime);
        QFilter q2 = new QFilter("expdate", ">", (Object)bizTime);
        QFilter q3 = q2.or(QFilter.isNull((String)"expdate"));
        q1.and(q3).and(new QFilter("enable", "=", (Object)"1"));
        Map bdTaxRate = BusinessDataServiceHelper.loadFromCache((String)"bd_taxrate", (String)"id", (QFilter[])new QFilter[]{q1});
        ArrayList<String> taxRateList = new ArrayList<String>(bdTaxRate.size());
        for (Map.Entry next : bdTaxRate.entrySet()) {
            Object pkValue = ((DynamicObject)next.getValue()).getPkValue();
            taxRateList.add(pkValue.toString());
        }
        if (taxRateList.size() > 0) {
            this.getPageCache().put(TAXRATE_FILTER, SerializationUtils.toJsonString((Object)String.join((CharSequence)"_", taxRateList)));
        }
    }

    private static /* synthetic */ Long lambda$beforeF7Select$1(DynamicObject a) {
        return (Long)a.getPkValue();
    }

    private static /* synthetic */ boolean lambda$beforeF7Select$0(DynamicObject a) {
        return !a.getBoolean("invalid");
    }
}

