/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.formplugin.receivematch;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.mpscmm.mscommon.writeoff.form.manual.IWfManualExtService;

public class ReceiveMatchWriteOffPlugin
extends AbstractFormPlugin
implements IWfManualExtService {
    private static final Log log = LogFactory.getLog(ReceiveMatchWriteOffPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterBindData(EventObject e) {
        long start = System.currentTimeMillis();
        super.afterBindData(e);
        long end = System.currentTimeMillis();
        log.info("\u521d\u59cb\u5316\u8fc7\u6ee4\u6761\u4ef6\u63a7\u4ef6\u8017\u65f6\uff1a" + (end - start));
        Object wfscheme = this.getModel().getValue("wfscheme");
        if (wfscheme != null) {
            this.getView().invokeOperation("query");
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Object fieldValue = e.getValue();
        String key = ((Control)e.getSource()).getKey();
        if (fieldValue != null) {
            BigDecimal value = new BigDecimal(String.valueOf(fieldValue));
            if (("r_unremainamount_cur_a".equalsIgnoreCase(key) || "e_unlockamt_cur_b".equalsIgnoreCase(key)) && BigDecimal.ZERO.compareTo(value) >= 0) {
                e.setCancel(true);
                this.getView().updateView(key, e.getRowIndex());
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672c\u6b21\u5339\u914d\u91d1\u989d\u5e94\u5927\u4e8e0\u3002", (String)"ReceiveMatchWriteOffPlugin_0", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                return;
            }
        } else {
            e.setCancel(true);
            this.getView().updateView(key, e.getRowIndex());
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672c\u6b21\u5339\u914d\u91d1\u989d\u5e94\u5927\u4e8e0\u3002", (String)"ReceiveMatchWriteOffPlugin_0", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
            return;
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("btn_matchhistory".equals(itemKey)) {
            this.viewHistorys();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String key = operate.getOperateKey();
        if (!(!"wfmanual".equals(key) || this.checkSelectedEntry("entry_a") && this.checkSelectedEntry("entry_b"))) {
            args.setCancel(true);
        }
    }

    public void addBillFilter(String curEntryKey, String entityNumber, List<QFilter> billFilters, Map<String, Object> pageDataMap) {
        Map customParams = ((IFormView)pageDataMap.get("view")).getFormShowParameter().getCustomParams();
        String billno = (String)customParams.get("billno");
        if ("sm_salorder".equalsIgnoreCase(entityNumber) && StringUtils.isNotEmpty((String)billno)) {
            QFilter qFilter = new QFilter("billno", "=", (Object)billno);
            billFilters.add(qFilter);
        }
    }

    public String addDefaultPageFilterConditon(IFormView iFormView, String curEntryKey) {
        FilterCondition filterCondition = null;
        log.info("\u5f00\u59cb\u6dfb\u52a0\u8fc7\u6ee4\u6761\u4ef6");
        Map customParams = iFormView.getFormShowParameter().getCustomParams();
        String customer = (String)customParams.get("customer");
        String settlecurrency = (String)customParams.get("settlecurrency");
        String org = (String)customParams.get("r_recsettleorg");
        if ("entry_a".equalsIgnoreCase(curEntryKey)) {
            String formatDate;
            log.info("\u5355\u636e\u7f16\u7801\uff1a" + curEntryKey + "\uff0c\u5ba2\u6237\uff1a" + customer + "\uff0c\u7ed3\u7b97\u5e01\uff1a" + settlecurrency + "\uff0c\u7ec4\u7ec7\u540d\u79f0\uff1a" + org);
            ArrayList<FilterItem> list = new ArrayList<FilterItem>();
            String billno = (String)customParams.get("billno");
            if (StringUtils.isNotEmpty((String)billno)) {
                list.add(new FilterItem("billno", CompareTypeEnum.EQUAL.getId(), billno));
            }
            if (StringUtils.isNotEmpty((String)org)) {
                list.add(new FilterItem("r_recsettleorg.name", CompareTypeEnum.ORGEQUAL.getId(), org));
            }
            if (StringUtils.isNotEmpty((String)(formatDate = (String)customParams.get("bizdate")))) {
                list.add(new FilterItem("bizdate", CompareTypeEnum.EQUAL.getId(), formatDate));
            }
            filterCondition = this.getFilterConition(list);
        } else if ("entry_b".equalsIgnoreCase(curEntryKey)) {
            log.info("\u5355\u636e\u7f16\u7801\uff1a" + curEntryKey + "\uff0c\u5ba2\u6237\uff1a" + customer + "\uff0c\u7ed3\u7b97\u5e01\uff1a" + settlecurrency + "\uff0c\u7ec4\u7ec7\u540d\u79f0\uff1a" + org);
            ArrayList<FilterItem> list = new ArrayList<FilterItem>();
            list.add(new FilterItem("bizdate", CompareTypeEnum.LESSTHANOREQUALTODAY.getId(), ""));
            if (StringUtils.isNotEmpty((String)customer)) {
                list.add(new FilterItem("payername", CompareTypeEnum.EQUAL.getId(), customer));
            }
            if (StringUtils.isNotEmpty((String)settlecurrency)) {
                list.add(new FilterItem("currency.name", CompareTypeEnum.EQUAL.getId(), settlecurrency));
            }
            if (StringUtils.isNotEmpty((String)org)) {
                list.add(new FilterItem("e_settleorg.name", CompareTypeEnum.ORGEQUAL.getId(), org));
            }
            filterCondition = this.getFilterConition(list);
        }
        if (filterCondition != null) {
            return SerializationUtils.toJsonString(filterCondition);
        }
        return null;
    }

    private boolean checkSelectedEntry(String entry) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(entry);
        int[] rows = entryGrid.getSelectRows();
        if (rows.length <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u8ba2\u5355\u548c\u6536\u6b3e\u5904\u7406\u9700\u8981\u6267\u884c\u5339\u914d\u7684\u6570\u636e\u3002", (String)"ReceiveMatchWriteOffPlugin_2", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public String wfManualConfirmMessage() {
        return ResManager.loadKDString((String)"\u672c\u6b21\u5339\u914d\u91d1\u989d\u4e0d\u76f8\u7b49\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ReceiveMatchWriteOffPlugin_1", (String)"scmc-sm-formplugin", (Object[])new Object[0]);
    }

    public String wfQueryCheckMessage(String name, String number) {
        if ("sm_salorder".equals(number)) {
            return String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u9700\u8981\u7ef4\u62a4\u7ed3\u7b97\u7ec4\u7ec7\u548c\u8ba2\u5355\u65e5\u671f\u8fc7\u6ee4\u6761\u4ef6\u3002", (String)"ReceiveMatchWriteOffPlugin_5", (String)"scmc-sm-formplugin", (Object[])new Object[0]), name);
        }
        if ("cas_recbill".equals(number)) {
            return String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u9700\u8981\u7ef4\u62a4\u7ed3\u7b97\u7ec4\u7ec7\u548c\u4e1a\u52a1\u65e5\u671f\u8fc7\u6ee4\u6761\u4ef6\u3002", (String)"ReceiveMatchWriteOffPlugin_6", (String)"scmc-sm-formplugin", (Object[])new Object[0]), name);
        }
        return String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u9700\u8981\u7ef4\u62a4\u7ec4\u7ec7\u548c\u65e5\u671f\u8fc7\u6ee4\u6761\u4ef6\u3002", (String)"ReceiveMatchWriteOffPlugin_7", (String)"scmc-sm-formplugin", (Object[])new Object[0]), name);
    }

    private void viewHistorys() {
        String billno = (String)this.getView().getFormShowParameter().getCustomParams().get("billno");
        if (StringUtils.isNotEmpty((String)billno)) {
            ListShowParameter parameter = new ListShowParameter();
            parameter.setBillFormId("sm_somatch");
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setCustomParam("billno", (Object)billno);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    private FilterCondition getFilterConition(List<FilterItem> items) {
        if (items == null || items.size() <= 0) {
            return null;
        }
        FilterCondition filterCondition = new FilterCondition();
        for (FilterItem item : items) {
            SimpleFilterRow filterRow = new SimpleFilterRow();
            ArrayList<FilterValue> list = new ArrayList<FilterValue>();
            FilterValue value = new FilterValue();
            value.setValue((Object)item.getValue());
            list.add(value);
            filterRow.setValue(list);
            String key = item.getFieldName();
            filterRow.setFieldName(key);
            filterRow.setCompareType(item.getCompareType());
            filterRow.setLogic("0");
            filterCondition.getFilterRow().add(filterRow);
        }
        return filterCondition;
    }

    public static class FilterItem {
        private String fieldName;
        private String compareType;
        private String value;

        public FilterItem(String fieldName, String compareType, String value) {
            this.fieldName = fieldName;
            this.compareType = compareType;
            this.value = value;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getCompareType() {
            return this.compareType;
        }

        public void setCompareType(String compareType) {
            this.compareType = compareType;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

