/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.formplugin.returnap;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.LinkSetElement;
import kd.bos.entity.LinkSetItemElement;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mpscmm.msbd.business.helper.BaseDataHelper;
import kd.mpscmm.msbd.common.enums.KitStructCtlEnum;
import kd.mpscmm.msbd.common.enums.KitTransferModelEnum;
import kd.scmc.sm.business.helper.BillImportHelper;
import kd.scmc.sm.business.helper.BillTplHelper;
import kd.scmc.sm.business.helper.CustomerHelper;
import kd.scmc.sm.business.helper.IMServiceHelper;
import kd.scmc.sm.business.helper.KitSalesHelper;
import kd.scmc.sm.business.helper.LotCacheHelper;
import kd.scmc.sm.business.helper.PluginConnectControllHelper;
import kd.scmc.sm.business.helper.PropertyChangeHelper;
import kd.scmc.sm.business.helper.SalesOrgHelper;
import kd.scmc.sm.enums.OwnerTypeEnum;
import kd.scmc.sm.enums.ProductTypeEnum;
import kd.scmc.sm.util.CommonUtils;

public class ReturnApplyEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
EntryGridBindDataListener {
    private static final Log LOG = LogFactory.getLog(ReturnApplyEditPlugin.class);
    private static final String BLANK = " ";
    private static final String NEWCHILD_OP = "newchild";
    private static final String SELECT_MATERIALROW = "SELECT_MATERIALROW";
    private static final String EXPANDKITPARENTROW = "expandKitParentRow";
    private static final String CHANGECHILDPRODTYPE = "changeChildProdType";

    public void registerListener(EventObject e) {
        EntryGrid entry;
        BasedataEdit inspectOrgEdit;
        BasedataEdit entryinvorg;
        BasedataEdit recustomerEdit;
        BasedataEdit customerEdit;
        BasedataEdit warehouseEdit;
        BasedataEdit materialEdit;
        BasedataEdit ownerEdit;
        super.registerListener(e);
        BasedataEdit settleOrgEdit = (BasedataEdit)this.getView().getControl("entrysettleorg");
        if (settleOrgEdit != null) {
            settleOrgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((ownerEdit = (BasedataEdit)this.getView().getControl("owner")) != null) {
            ownerEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((materialEdit = (BasedataEdit)this.getView().getControl("material")) != null) {
            materialEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((warehouseEdit = (BasedataEdit)this.getView().getControl("warehouse")) != null) {
            warehouseEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((customerEdit = (BasedataEdit)this.getView().getControl("customer")) != null) {
            customerEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((recustomerEdit = (BasedataEdit)this.getView().getControl("reccustomer")) != null) {
            recustomerEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((entryinvorg = (BasedataEdit)this.getView().getControl("entryinvorg")) != null) {
            entryinvorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((inspectOrgEdit = (BasedataEdit)this.getView().getControl("inspectorg")) != null) {
            inspectOrgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((entry = (EntryGrid)this.getControl("billentry")) != null) {
            entry.addDataBindListener((EntryGridBindDataListener)this);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billentry");
        if (entryGrid != null) {
            entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        }
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        try (TraceSpan span = Tracer.create((String)"ReturnApplyEditPlugin", (String)"entryGridBindData");){
            if (KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) {
                this.setKitColumnEnables(e.getRows());
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        try (TraceSpan span = Tracer.create((String)"ReturnApplyEditPlugin", (String)"afterBindData");){
            this.setOwnerTypeEnable();
            String isDraw = this.getPageCache().get("isdraw");
            if (isDraw == null) {
                isDraw = String.valueOf(this.isDraw());
            }
            if (KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName()) && "true".equals(isDraw)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{NEWCHILD_OP});
                this.getView().setVisible(Boolean.FALSE, new String[]{"addrowx"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"addrow"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"expandkit"});
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        try (TraceSpan span = Tracer.create((String)"ReturnApplyEditPlugin", (String)"afterCreateNewData");){
            String importFlag = this.getPageCache().get("importFlag");
            if ("true".equals(importFlag)) {
                return;
            }
            super.afterCreateNewData(e);
            int entryRowCount = this.getModel().getEntryRowCount("billentry");
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            for (int i = 0; i < entryRowCount; ++i) {
                this.initOrgDefaultValue(i, org);
            }
            this.setOwnerTypeDefault();
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        try (TraceSpan span = Tracer.create((String)"ReturnApplyEditPlugin", (String)("afterAddRow: " + entryName));){
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            RowDataEntity[] rowDataEntities = e.getRowDataEntities();
            if ("billentry".equals(entryName)) {
                ArrayList<Integer> rowIndexList = new ArrayList<Integer>(8);
                for (RowDataEntity rowDataEntity : rowDataEntities) {
                    int rowIndex = rowDataEntity.getRowIndex();
                    rowIndexList.add(rowIndex);
                    this.initOrgDefaultValue(rowIndex, org);
                }
                if (KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) {
                    this.setKitColumnEnable(rowIndexList);
                    this.setKitDeliverColumnDefault(rowIndexList);
                }
            }
        }
    }

    public void initialize() {
        EntryGrid entry = (EntryGrid)this.getControl("billentry");
        if (entry != null) {
            entry.addDataBindListener((EntryGridBindDataListener)this);
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        this.getView().updateView("billentry");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String key = operate.getOperateKey();
        try (TraceSpan span = Tracer.create((String)"ReturnApplyEditPlugin", (String)("beforeDoOperation: " + key));){
            switch (key) {
                case "expandkit": {
                    Date bizDate = (Date)this.getModel().getValue("bizdate");
                    if (bizDate != null) return;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u201c\u7533\u8bf7\u65e5\u671f\u201d\u5b57\u6bb5\u3002", (String)"ReturnApplyEditPlugin_2", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            }
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey;
        super.afterDoOperation(e);
        switch (operateKey = e.getOperateKey()) {
            case "save": {
                this.setOwnerTypeEnable();
                break;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        switch (fieldKey) {
            case "material": 
            case "dept": 
            case "operator": 
            case "customer": 
            case "entrysettleorg": 
            case "owner": 
            case "project": 
            case "taxrateid": {
                boolean stopListener = PluginConnectControllHelper.isStopListener((IPageCache)this.getPageCache(), (String)"beforeF7Select");
                if (!stopListener) break;
                return;
            }
        }
        try (TraceSpan span = Tracer.create((String)"ReturnApplyEditPlugin", (String)("beforeF7Select: " + e.getProperty().getName()));){
            switch (fieldKey) {
                case "warehouse": {
                    DynamicObject entryinvOrg = (DynamicObject)this.getModel().getValue("entryinvorg", e.getRow());
                    if (entryinvOrg == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"ReturnApplyEditPlugin_0", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        e.setCancel(true);
                        return;
                    }
                    Long[] allWhs = (Long[])IMServiceHelper.invokeBizService((String)"InvService", (String)"getAllWarehouseIDs", (Object[])new Object[]{entryinvOrg.getString("number")});
                    showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)allWhs));
                    return;
                }
                case "material": {
                    DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
                    if (bizType != null && "6".equals(bizType.getString("domain"))) {
                        QFilter q1 = new QFilter("masterid.enablevmi", "=", (Object)Boolean.TRUE);
                        showParameter.getListFilterParameter().setFilter(q1);
                    }
                    if (!KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) return;
                    int rowIndex = this.getModel().getEntryCurrentRowIndex("billentry");
                    String productType = (String)this.getModel().getValue("producttype", rowIndex);
                    if (ProductTypeEnum.KITPARENT.getValue().equals(productType)) {
                        QFilter suiteFilter = new QFilter("kitreturnmodel", "!=", (Object)BLANK);
                        showParameter.getListFilterParameter().getQFilters().add(suiteFilter);
                        return;
                    }
                    if (!ProductTypeEnum.KITCHILD.getValue().equals(productType)) {
                        if (!ProductTypeEnum.STANDARD.getValue().equals(productType)) return;
                    }
                    QFilter suiteFilter = new QFilter("kitreturnmodel", "=", (Object)BLANK);
                    showParameter.getListFilterParameter().getQFilters().add(suiteFilter);
                    return;
                }
                case "owner": {
                    if (!"bos_org".equals(this.getModel().getValue("ownertype", e.getRow()))) {
                        if (!OwnerTypeEnum.SUPPLIER.getValue().equals(this.getModel().getValue("ownertype", e.getRow()))) return;
                        QFilter q1 = new QFilter("enablevmi", "=", (Object)Boolean.TRUE);
                        QFilter q2 = new QFilter("status", "=", (Object)"C");
                        QFilter q3 = new QFilter("enable", "=", (Object)"1");
                        QFilter q4 = new QFilter("supplier_status.number", "=", (Object)"ZCGYS");
                        QFilter q5 = BaseDataHelper.getBaseDataFilterByOrg((String)OwnerTypeEnum.SUPPLIER.getValue(), (Long)((Long)org.getPkValue()), (boolean)false);
                        showParameter.getListFilterParameter().setQFilters(Arrays.asList(q1, q2, q3, q4, q5));
                        return;
                    }
                    DynamicObject entryinvorg = (DynamicObject)this.getModel().getValue("entryinvorg", e.getRow());
                    if (entryinvorg == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"ReturnApplyEditPlugin_0", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        e.setCancel(true);
                        return;
                    }
                    List ownerArray = SalesOrgHelper.getAccountOrgRange((Long)((Long)entryinvorg.getPkValue()));
                    if (ownerArray != null && ownerArray.size() != 0) {
                        QFilter ownerFilter = new QFilter("id", "in", (Object)ownerArray);
                        showParameter.getListFilterParameter().setFilter(ownerFilter);
                        return;
                    }
                    QFilter ownerFilter = new QFilter("fisaccounting", "=", (Object)Boolean.TRUE);
                    showParameter.getListFilterParameter().setFilter(ownerFilter);
                    return;
                }
                case "customer": {
                    QFilter bizfunction = new QFilter("bizfunction", "like", (Object)"%1%");
                    showParameter.getListFilterParameter().getQFilters().add(bizfunction);
                    return;
                }
                case "entryinvorg": {
                    if (org != null) return;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"ReturnApplyEditPlugin_1", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                case "inspectorg": {
                    DynamicObject e_invOrg = (DynamicObject)this.getModel().getValue("entryinvorg", e.getRow());
                    if (e_invOrg == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"ReturnApplyEditPlugin_0", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        e.setCancel(true);
                    }
                    showParameter.setMultiSelect(false);
                    return;
                }
            }
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void propertyChanged(PropertyChangedArgs e) {
        block71: {
            billcretype = this.getPageCache().get("billcretype");
            if (!BillImportHelper.isManual((String)billcretype)) {
                return;
            }
            importFlag = this.getPageCache().get("importFlag");
            if ("true".equals(importFlag)) {
                return;
            }
            if (PropertyChangeHelper.isStopPropertyChange((IPageCache)this.getPageCache())) {
                return;
            }
            fieldKey = e.getProperty().getName();
            changeSet = e.getChangeSet();
            span = Tracer.create((String)"ReturnApplyEditPlugin", (String)("propertyChanged: " + e.getProperty().getName()));
            var7_7 = null;
            try {
                org = (DynamicObject)this.getModel().getValue("org");
                if (!CommonUtils.isRealChanged((ChangeData)changeSet[0])) break block71;
                var9_11 = fieldKey;
                var10_12 = -1;
                switch (var9_11.hashCode()) {
                    case -514478011: {
                        if (!var9_11.equals("entryinvorg")) break;
                        var10_12 = 0;
                        break;
                    }
                    case 18608237: {
                        if (!var9_11.equals("ownertype")) break;
                        var10_12 = 1;
                        break;
                    }
                    case 890591169: {
                        if (!var9_11.equals("billtype")) break;
                        var10_12 = 2;
                        break;
                    }
                    case -96646451: {
                        if (!var9_11.equals("biztype")) break;
                        var10_12 = 3;
                        break;
                    }
                    case 110308: {
                        if (!var9_11.equals("org")) break;
                        var10_12 = 4;
                        break;
                    }
                    case 3594628: {
                        if (!var9_11.equals("unit")) break;
                        var10_12 = 5;
                        break;
                    }
                    case 112310: {
                        if (!var9_11.equals("qty")) break;
                        var10_12 = 6;
                        break;
                    }
                    case -1406200462: {
                        if (!var9_11.equals("auxqty")) break;
                        var10_12 = 7;
                        break;
                    }
                    case 606175198: {
                        if (!var9_11.equals("customer")) break;
                        var10_12 = 8;
                        break;
                    }
                    case 299066663: {
                        if (!var9_11.equals("material")) break;
                        var10_12 = 9;
                        break;
                    }
                    case 70134536: {
                        if (!var9_11.equals("kittransfermodel")) break;
                        var10_12 = 10;
                        break;
                    }
                    case -1490662231: {
                        if (!var9_11.equals("producttype")) break;
                        var10_12 = 11;
                    }
                }
                switch (var10_12) {
                    case 0: {
                        rows = new ArrayList<RowDataEntity>();
                        for (i = 0; i < changeSet.length; ++i) {
                            if (!CommonUtils.isRealChanged((ChangeData)changeSet[i])) continue;
                            rowIndex = changeSet[i].getRowIndex();
                            entryInvOrg = (DynamicObject)this.getModel().getValue("entryinvorg", rowIndex);
                            if (entryInvOrg == null) {
                                this.getModel().setValue("inspectorg", null, rowIndex);
                            }
                            this.getModel().setValue("warehouse", null, rowIndex);
                            SalesOrgHelper.setOwner((int)changeSet[i].getRowIndex(), (IDataModel)this.getModel(), (DynamicObject)org, (DynamicObject)entryInvOrg, (IPageCache)this.getPageCache());
                            rowDataEntity = new RowDataEntity(changeSet[i].getRowIndex(), this.getModel().getEntryRowEntity("billentry", rowIndex));
                            rows.add(rowDataEntity);
                            if (!KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) continue;
                            parentRowIndex = changeSet[i].getRowIndex();
                            productType = (String)this.getModel().getValue("producttype", parentRowIndex);
                            if (!ProductTypeEnum.KITPARENT.getValue().equals(productType)) continue;
                            childIndexList = this.getAllChildEntry(parentRowIndex);
                            this.setKitDeliverColumnValue(childIndexList, parentRowIndex, "entryinvorg");
                        }
                        LotCacheHelper.setLotEnable(rows, (IFormView)this.getView(), (IPageCache)this.getPageCache());
                        ** break;
lbl89:
                        // 1 sources

                        break;
                    }
                    case 1: {
                        for (i = 0; i < changeSet.length; ++i) {
                            if (changeSet[i].getNewValue() == null || "".equals(changeSet[i].getNewValue())) {
                                PropertyChangeHelper.stopPropertyChange((IPageCache)this.getPageCache());
                                this.getModel().setValue("ownertype", changeSet[i].getOldValue(), changeSet[i].getRowIndex());
                                PropertyChangeHelper.releasePropertyChange((IPageCache)this.getPageCache());
                                continue;
                            }
                            this.getModel().setValue("owner", null, changeSet[i].getRowIndex());
                        }
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        this.setOwnerTypeDefault();
                        this.setOwnerTypeEnable();
                        ** break;
lbl104:
                        // 1 sources

                        break;
                    }
                    case 5: {
                        for (i = 0; i < changeSet.length; ++i) {
                            rowIndex = changeSet[i].getRowIndex();
                            if (!KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) continue;
                            this.calcChildRowQty(rowIndex);
                        }
                        break;
                    }
                    case 6: 
                    case 7: {
                        rows_1 = new ArrayList<RowDataEntity>();
                        for (i = 0; i < changeSet.length; ++i) {
                            if (!CommonUtils.isRealChanged((ChangeData)changeSet[i])) continue;
                            row = changeSet[i].getRowIndex();
                            newQty = (BigDecimal)changeSet[i].getNewValue();
                            oldQty = (BigDecimal)changeSet[i].getOldValue();
                            if (newQty == null) {
                                newQty = BigDecimal.ZERO;
                            }
                            if (oldQty == null) {
                                oldQty = BigDecimal.ZERO;
                            }
                            if (BigDecimal.ZERO.compareTo(newQty) == 0) {
                                rowDataEntity = new RowDataEntity(row, this.getModel().getEntryRowEntity("billentry", row));
                                rows_1.add(rowDataEntity);
                            } else if (BigDecimal.ZERO.compareTo(oldQty) == 0) {
                                rowDataEntity = new RowDataEntity(row, this.getModel().getEntryRowEntity("billentry", row));
                                rows_1.add(rowDataEntity);
                            }
                            if (!KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) continue;
                            this.calcChildRowQty(row);
                        }
                        LotCacheHelper.setLotEnable(rows_1, (IFormView)this.getView(), (IPageCache)this.getPageCache());
                        ** break;
lbl137:
                        // 1 sources

                        break;
                    }
                    case 8: {
                        customer = (DynamicObject)changeSet[0].getNewValue();
                        if (customer == null) ** break;
                        reccustomer = customer.getDynamicObject("delivercustomerid");
                        if (reccustomer == null) {
                            this.getModel().setValue("reccustomer", customer.getPkValue());
                            this.getModel().setValue("reclinkman", (Object)CustomerHelper.getLinkman((DynamicObject)customer));
                            this.getModel().setValue("receiveaddress", (Object)CustomerHelper.getAddress((DynamicObject)customer));
                            ** break;
lbl147:
                            // 1 sources

                        } else {
                            this.getModel().setValue("reccustomer", reccustomer.getPkValue());
                            this.getModel().setValue("reclinkman", (Object)CustomerHelper.getLinkman((DynamicObject)reccustomer));
                            this.getModel().setValue("receiveaddress", (Object)CustomerHelper.getAddress((DynamicObject)reccustomer));
                            ** break;
                        }
lbl152:
                        // 1 sources

                        break;
                    }
                    case 9: {
                        for (i = 0; i < changeSet.length; ++i) {
                            changeData = changeSet[i];
                            if (changeSet[i].getNewValue() != null) {
                                material = (DynamicObject)changeSet[i].getNewValue();
                                rowIndex = changeData.getRowIndex();
                                entry = (AbstractGrid)this.getControl("billentry");
                                foucsRow = entry.getEntryState().getFocusRow();
                                if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get("SELECT_MATERIALROW"))) {
                                    foucsRow = Integer.parseInt(this.getPageCache().get("SELECT_MATERIALROW"));
                                }
                                if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get("expandKitParentRow"))) {
                                    foucsRow = rowIndex;
                                }
                                pID = (Long)this.getModel().getValue("kitpid", foucsRow);
                                productType = (String)this.getModel().getValue("producttype", foucsRow);
                                PropertyChangeHelper.stopPropertyChange((IPageCache)this.getPageCache());
                                if (pID == null || Long.valueOf("0").equals(pID) || ProductTypeEnum.KITPARENT.getValue().equals(productType)) {
                                    if (material != null && (masterMaterial = material.getDynamicObject("masterid")) != null) {
                                        this.getModel().setValue("kittransfermodel", (Object)material.getString("kitreturnmodel"), rowIndex);
                                    }
                                } else if (foucsRow != rowIndex) {
                                    kitTransferModel = (String)this.getModel().getValue("kittransfermodel", foucsRow);
                                    this.getModel().setValue("kittransfermodel", (Object)kitTransferModel, rowIndex);
                                }
                                PropertyChangeHelper.releasePropertyChange((IPageCache)this.getPageCache());
                            }
                            if (!CommonUtils.isRealChanged((ChangeData)changeSet[i])) continue;
                            rowIndex = changeSet[i].getRowIndex();
                            if (!KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) continue;
                            this.setOneKitColumnEnable(rowIndex);
                            this.setKitDeliverColumnDefault(Collections.singletonList(rowIndex));
                        }
                        break;
                    }
                    case 10: {
                        if (!KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) ** break;
                        for (i = 0; i < changeSet.length; ++i) {
                            if (!CommonUtils.isRealChanged((ChangeData)changeSet[i])) continue;
                            parentRowIndex = changeSet[i].getRowIndex();
                            productType = (String)this.getModel().getValue("producttype", parentRowIndex);
                            if (!ProductTypeEnum.KITPARENT.getValue().equals(productType)) continue;
                            childIndexList = this.getAllChildEntry(parentRowIndex);
                            kitTransferModel = changeSet[i].getNewValue() == null ? null : changeSet[i].getNewValue().toString();
                            this.setChildDeliverColumnEnable(childIndexList, kitTransferModel);
                            this.setKitDeliverColumnDefault(childIndexList, parentRowIndex);
                        }
                        break;
                    }
                    case 11: {
                        if (!KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) ** break;
                        isDraw = this.getPageCache().get("isdraw");
                        if (isDraw == null) {
                            isDraw = String.valueOf(this.isDraw());
                        }
                        if (!"true".equals(isDraw)) {
                            return;
                        }
                        for (i = 0; i < changeSet.length; ++i) {
                            if (!CommonUtils.isRealChanged((ChangeData)changeSet[i])) continue;
                            rowIndex = changeSet[i].getRowIndex();
                            oldProductType = (String)changeSet[i].getOldValue();
                            newProductType = (String)changeSet[i].getNewValue();
                            if (StringUtils.isEmpty((CharSequence)newProductType)) continue;
                            if (ProductTypeEnum.KITCHILD.getValue().equals(oldProductType)) {
                                if (ProductTypeEnum.KITPARENT.getValue().equals(newProductType)) {
                                    PropertyChangeHelper.stopPropertyChange((IPageCache)this.getPageCache());
                                    this.getModel().setValue("producttype", (Object)oldProductType, rowIndex);
                                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u5957\u4ef6\u5b50\u9879\u201d\u4e0d\u5141\u8bb8\u5207\u6362\u6210\u201c\u5957\u4ef6\u7236\u9879\u201d\u3002", (String)"ReturnApplyEditPlugin_4", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                                    PropertyChangeHelper.releasePropertyChange((IPageCache)this.getPageCache());
                                    continue;
                                }
                                parentEntry = this.getParentEntry(rowIndex);
                                if (parentEntry != null) {
                                    PropertyChangeHelper.stopPropertyChange((IPageCache)this.getPageCache());
                                    this.getModel().setValue("producttype", (Object)oldProductType, rowIndex);
                                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u5957\u4ef6\u5b50\u9879\u201d\u5b58\u5728\u7236\u9879\uff0c\u4e0d\u5141\u8bb8\u5207\u6362\u4ea7\u54c1\u7c7b\u522b\u3002", (String)"ReturnApplyEditPlugin_5", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                                    PropertyChangeHelper.releasePropertyChange((IPageCache)this.getPageCache());
                                    continue;
                                }
                                PropertyChangeHelper.stopPropertyChange((IPageCache)this.getPageCache());
                                this.getModel().setValue("producttype", (Object)oldProductType, rowIndex);
                                PropertyChangeHelper.releasePropertyChange((IPageCache)this.getPageCache());
                                confirmCallBacks = new ConfirmCallBackListener("changeChildProdType", (IFormPlugin)this);
                                options = MessageBoxOptions.OKCancel;
                                msg = ResManager.loadKDString((String)"\u4ea7\u54c1\u7c7b\u522b\u5207\u6362\u540e\uff0c\u5c06\u6309\u7167\u6807\u51c6\u4ea7\u54c1\u6d41\u7a0b\u9000\u8d27\uff0c\u5e76\u4e14\u4e0d\u5141\u8bb8\u518d\u8c03\u6574\u6210\u5b50\u9879\u4ea7\u54c1\uff0c\u786e\u5b9a\u5207\u6362\uff1f", (String)"ReturnApplyEditPlugin_6", (String)"scmc-sm-formplugin", (Object[])new Object[0]);
                                this.getView().showConfirm(msg, "", options, ConfirmTypes.Default, confirmCallBacks, null, Integer.toString(rowIndex));
                                continue;
                            }
                            PropertyChangeHelper.stopPropertyChange((IPageCache)this.getPageCache());
                            this.getModel().setValue("producttype", (Object)oldProductType, rowIndex);
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u201c\u5957\u4ef6\u5b50\u9879\u201d\u4e0d\u5141\u8bb8\u5207\u6362\u4ea7\u54c1\u7c7b\u522b\u3002", (String)"ReturnApplyEditPlugin_3", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                            PropertyChangeHelper.releasePropertyChange((IPageCache)this.getPageCache());
                        }
                        break;
                    }
                    ** default:
lbl238:
                    // 1 sources

                    break;
                }
            }
            catch (Throwable var8_10) {
                var7_7 = var8_10;
                throw var8_10;
            }
            finally {
                if (span != null) {
                    if (var7_7 != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable var8_9) {
                            var7_7.addSuppressed(var8_9);
                        }
                    } else {
                        span.close();
                    }
                }
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if (!KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) {
            return;
        }
        String backId = event.getCallBackId();
        MessageBoxResult result = event.getResult();
        switch (backId) {
            case "changeChildProdType": {
                String rowIndexString;
                if (!MessageBoxResult.Yes.equals((Object)result) || (rowIndexString = event.getCustomVaule()) == null || !StringUtils.isNotBlank((CharSequence)rowIndexString)) break;
                try {
                    int rowIndex = Integer.parseInt(rowIndexString);
                    PropertyChangeHelper.stopPropertyChange((IPageCache)this.getPageCache());
                    this.getModel().setValue("producttype", (Object)ProductTypeEnum.STANDARD.getValue(), rowIndex);
                    this.getModel().setValue("kitproduct", null, rowIndex);
                    this.getModel().setValue("kitpid", (Object)Long.valueOf("0"), rowIndex);
                    this.getModel().setValue("kitqty", (Object)BigDecimal.ZERO, rowIndex);
                    this.getModel().setValue("parentqty", (Object)BigDecimal.ZERO, rowIndex);
                    this.getModel().setValue("kittransfermodel", null, rowIndex);
                    this.getModel().setValue("pricemodel", null, rowIndex);
                    PropertyChangeHelper.releasePropertyChange((IPageCache)this.getPageCache());
                    this.getView().updateView("billentry");
                }
                catch (NumberFormatException e) {
                    LOG.info("CHANGECHILDPRODTYPE NumberFormatException" + e.getMessage());
                }
                break;
            }
        }
    }

    private void initOrgDefaultValue(int rowIndex, DynamicObject org) {
        DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
        if (bizType != null && "6".equals(bizType.getString("domain"))) {
            this.getModel().setValue("ownertype", (Object)OwnerTypeEnum.SUPPLIER.getValue(), rowIndex);
        } else {
            this.getModel().setValue("ownertype", (Object)OwnerTypeEnum.ORG.getValue(), rowIndex);
            if (this.getModel().getValue("owner", rowIndex) == null) {
                SalesOrgHelper.setOwner((int)rowIndex, (IDataModel)this.getModel(), (DynamicObject)org, (DynamicObject)((DynamicObject)this.getModel().getValue("entryinvorg", rowIndex)), (IPageCache)this.getPageCache());
            }
        }
    }

    private void setOwnerTypeEnable() {
        DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
        if (bizType != null && !"2101".equals(bizType.getString("number")) && !"2102".equals(bizType.getString("number"))) {
            this.getView().setEnable(Boolean.FALSE, -1, new String[]{"ownertype"});
        } else {
            this.getView().setEnable(Boolean.TRUE, -1, new String[]{"ownertype"});
        }
    }

    private void setOwnerTypeDefault() {
        DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
        if (bizType != null && "6".equals(bizType.getString("domain"))) {
            int entryRowCount = this.getModel().getEntryRowCount("billentry");
            for (int i = 0; i < entryRowCount; ++i) {
                this.getModel().setValue("ownertype", (Object)OwnerTypeEnum.SUPPLIER.getValue(), i);
            }
        } else {
            int entryRowCount = this.getModel().getEntryRowCount("billentry");
            for (int i = 0; i < entryRowCount; ++i) {
                this.getModel().setValue("ownertype", (Object)OwnerTypeEnum.ORG.getValue(), i);
            }
        }
    }

    private void setKitColumnEnables(List<RowDataEntity> currencyRows) {
        if (currencyRows == null || currencyRows.size() == 0) {
            return;
        }
        for (RowDataEntity row : currencyRows) {
            int rowIndex = row.getRowIndex();
            this.setKitDeliverColumnEnable(rowIndex, null);
        }
    }

    private void setKitColumnEnable(List<Integer> rows) {
        if (rows == null || rows.size() == 0) {
            return;
        }
        for (int rowIndex : rows) {
            this.setKitDeliverColumnEnable(rowIndex, null);
        }
    }

    private void setOneKitColumnEnable(int rowIndex) {
        this.setKitDeliverColumnEnable(rowIndex, null);
    }

    private void setChildDeliverColumnEnable(List<Integer> childEntryList, String transferModel) {
        if (childEntryList == null || childEntryList.size() == 0) {
            return;
        }
        for (Integer childEntryIndex : childEntryList) {
            this.setKitDeliverColumnEnable(childEntryIndex, transferModel);
        }
    }

    private void setKitDeliverColumnDefault(List<Integer> childIndexList, int parentRowIndex) {
        if (childIndexList == null || childIndexList.size() == 0) {
            return;
        }
        DynamicObject parentEntry = this.getModel().getEntryRowEntity("billentry", parentRowIndex);
        for (int childRowIndex : childIndexList) {
            this.setKitDeliverOneColumnDefault(childRowIndex, parentEntry);
        }
    }

    private void setKitDeliverColumnDefault(List<Integer> childIndexList) {
        if (childIndexList == null || childIndexList.size() == 0) {
            return;
        }
        HashMap<Long, DynamicObject> parentMap = new HashMap<Long, DynamicObject>();
        for (int childRowIndex : childIndexList) {
            String productType = (String)this.getModel().getValue("producttype", childRowIndex);
            if (!ProductTypeEnum.KITCHILD.getValue().equals(productType)) continue;
            Long pID = (Long)this.getModel().getValue("kitpid", childRowIndex);
            DynamicObject parentEntry = (DynamicObject)parentMap.get(pID);
            if (parentEntry == null) {
                parentEntry = this.getParentEntry(childRowIndex);
                parentMap.put(pID, parentEntry);
            }
            if (parentEntry == null) continue;
            this.setKitDeliverOneColumnDefault(childRowIndex, parentEntry);
        }
    }

    private void setKitDeliverOneColumnDefault(Integer childRowIndex, DynamicObject parentEntry) {
        this.getModel().setValue("entrysettleorg", parentEntry.get("entrysettleorg"), childRowIndex.intValue());
        this.getModel().setValue("entryinvorg", parentEntry.get("entryinvorg"), childRowIndex.intValue());
        this.getModel().setValue("ownertype", parentEntry.get("ownertype"), childRowIndex.intValue());
        this.getModel().setValue("owner", parentEntry.get("owner"), childRowIndex.intValue());
    }

    private void setKitDeliverColumnEnable(int rowIndex, String transfermodel) {
        DynamicObject parentRow;
        String productType = (String)this.getModel().getValue("producttype", rowIndex);
        String isDraw = this.getPageCache().get("isdraw");
        if (isDraw == null) {
            isDraw = String.valueOf(this.isDraw());
        }
        if (!StringUtils.isEmpty((CharSequence)this.getPageCache().get(EXPANDKITPARENTROW))) {
            return;
        }
        if (ProductTypeEnum.KITCHILD.getValue().equals(productType) && !"true".equals(isDraw) && (parentRow = this.getParentEntry(rowIndex)) != null) {
            DynamicObject kitBom = parentRow.getDynamicObject("bom");
            DynamicObject material = parentRow.getDynamicObject("material");
            if (kitBom != null && material != null && KitStructCtlEnum.NONADJ.getValue().equals(material.getString("kitstructctl"))) {
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"qty"});
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"auxqty"});
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"unit"});
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"material"});
            } else {
                DynamicObject auxUnit = (DynamicObject)this.getModel().getValue("auxunit", rowIndex);
                if (auxUnit != null) {
                    this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"auxqty"});
                }
            }
        }
        if (ProductTypeEnum.KITCHILD.getValue().equals(productType)) {
            if (transfermodel == null) {
                transfermodel = (String)this.getModel().getValue("kittransfermodel", rowIndex);
            }
            if (KitTransferModelEnum.KIT.getValue().equals(transfermodel)) {
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"entryinvorg"});
            } else if (KitTransferModelEnum.NONKIT.getValue().equals(transfermodel)) {
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"entryinvorg"});
            }
        }
    }

    private void setKitDeliverColumnValue(List<Integer> childIndexList, int parentRowIndex, String column) {
        if (childIndexList == null || childIndexList.size() == 0) {
            return;
        }
        DynamicObject parentEntry = this.getModel().getEntryRowEntity("billentry", parentRowIndex);
        for (int childRowIndex : childIndexList) {
            this.getModel().setValue(column, parentEntry.get(column), childRowIndex);
        }
    }

    private DynamicObject getParentEntry(int childRowIndex) {
        DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("billentry");
        Long pID = (Long)this.getModel().getValue("kitpid", childRowIndex);
        DynamicObject parentEntry = null;
        for (DynamicObject entry : entrys) {
            Long entryPid = entry.getLong("kitpid");
            String productType = entry.getString("producttype");
            if (!ProductTypeEnum.KITPARENT.getValue().equals(productType) || entryPid.longValue() != pID.longValue()) continue;
            parentEntry = entry;
            break;
        }
        return parentEntry;
    }

    private List<Integer> getAllChildEntry(int parentRowIndex) {
        DynamicObject parentEntry = this.getModel().getEntryRowEntity("billentry", parentRowIndex);
        Long parentPid = parentEntry.getLong("kitpid");
        ArrayList<Integer> childEntryList = new ArrayList<Integer>();
        int rowCount = this.getModel().getEntryRowCount("billentry");
        for (int i = 0; i < rowCount; ++i) {
            Long pID = (Long)this.getModel().getValue("kitpid", i);
            String productType = (String)this.getModel().getValue("producttype", i);
            if (!ProductTypeEnum.KITCHILD.getValue().equals(productType) || parentPid.longValue() != pID.longValue()) continue;
            childEntryList.add(i);
        }
        return childEntryList;
    }

    private boolean isDraw() {
        String formId = this.getView().getEntityId();
        LinkSetElement linkSet = ConvertMetaServiceHelper.loadLinkSet((String)formId);
        if (linkSet == null || linkSet.getItems() == null || linkSet.getItems().isEmpty()) {
            return false;
        }
        ExtendedDataEntitySet dataSet = new ExtendedDataEntitySet();
        DynamicObject billObj = this.getModel().getDataEntity();
        dataSet.Parse(new DynamicObject[]{billObj}, (MainEntityType)billObj.getDataEntityType());
        for (LinkSetItemElement linkEntry : linkSet.getItems()) {
            ExtendedDataEntity[] rows = dataSet.FindByEntityKey(linkEntry.getLinkEntityKey());
            if (rows == null || rows.length <= 0) continue;
            for (ExtendedDataEntity row : rows) {
                if (!this.haveSourceBillId(row.getDataEntity())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean haveSourceBillId(DynamicObject linkRow) {
        LinkEntryType linkType = (LinkEntryType)linkRow.getDataEntityType();
        Long sBillId = (Long)linkType.getSBillIdProp().getValueFast((Object)linkRow);
        return sBillId != null && sBillId != 0L;
    }

    private void calcChildRowQty(Integer parentRowIndex) {
        String isDraw = this.getPageCache().get("isdraw");
        if (isDraw == null) {
            isDraw = String.valueOf(this.isDraw());
        }
        if (KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) {
            String productType = (String)this.getModel().getValue("producttype", parentRowIndex.intValue());
            String transferModel = (String)this.getModel().getValue("kittransfermodel", parentRowIndex.intValue());
            DynamicObject kitBom = (DynamicObject)this.getModel().getValue("bom", parentRowIndex.intValue());
            DynamicObject parentMaterial = (DynamicObject)this.getModel().getValue("material", parentRowIndex.intValue());
            if (ProductTypeEnum.KITPARENT.getValue().equals(productType) && (KitTransferModelEnum.KIT.getValue().equals(transferModel) && "true".equals(isDraw) || !"true".equals(isDraw) && kitBom != null && parentMaterial != null && KitStructCtlEnum.NONADJ.getValue().equals(parentMaterial.getString("kitstructctl")))) {
                List<Integer> allChildIndexList = this.getAllChildEntry(parentRowIndex);
                for (Integer childRowIndex : allChildIndexList) {
                    BigDecimal parentBaseQty = (BigDecimal)this.getModel().getValue("baseqty", parentRowIndex.intValue());
                    BigDecimal kitQty = (BigDecimal)this.getModel().getValue("kitqty", childRowIndex.intValue());
                    BigDecimal parentQty = (BigDecimal)this.getModel().getValue("parentqty", childRowIndex.intValue());
                    DynamicObject baseUnit = (DynamicObject)this.getModel().getValue("baseunit", childRowIndex.intValue());
                    DynamicObject material = (DynamicObject)this.getModel().getValue("material", childRowIndex.intValue());
                    DynamicObject unit = (DynamicObject)this.getModel().getValue("unit", childRowIndex.intValue());
                    if (parentBaseQty == null || parentBaseQty.compareTo(BigDecimal.ZERO) == 0 || parentQty == null || parentQty.compareTo(BigDecimal.ZERO) == 0 || kitQty == null || unit == null || baseUnit == null || material == null) continue;
                    DynamicObject masterMaterial = material.getDynamicObject("masterid");
                    int precision = KitSalesHelper.getUnitPrecision((DynamicObject)baseUnit);
                    RoundingMode roundingMode = KitSalesHelper.getUnitRoundingMode((DynamicObject)baseUnit);
                    BigDecimal baseQty = parentBaseQty.multiply(kitQty).divide(parentQty, precision, roundingMode);
                    BigDecimal qty = BillTplHelper.getDesQtyConv((DynamicObject)masterMaterial, (DynamicObject)baseUnit, (BigDecimal)baseQty, (DynamicObject)unit);
                    this.getModel().setValue("qty", (Object)qty, childRowIndex.intValue());
                }
            }
        }
    }
}

