/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.formplugin.returnap;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.common.enums.BillCreTypeEnum;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.scmc.sm.business.helper.BillImportHelper;
import kd.scmc.sm.business.helper.OrgHelper;
import kd.scmc.sm.business.helper.SaleReturnApplyHelper;
import kd.scmc.sm.formplugin.agency.SalesAgencyImportPlugin;

public class SaleReturnApplyImportPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(SalesAgencyImportPlugin.class);
    private Map<String, Object> tempCache = new HashMap<String, Object>();

    public void initImportData(InitImportDataEventArgs e) {
        long start = System.currentTimeMillis();
        try (TraceSpan span = Tracer.create((String)"SaleReturnApplyImportPlugin", (String)"initImportData");){
            String billcretype = "";
            List sourceDataList = e.getSourceDataList();
            if (sourceDataList.isEmpty()) {
                return;
            }
            for (Map data : sourceDataList) {
                if (data.get("billcretype") == null || !StringUtils.isBlank((String)billcretype)) continue;
                billcretype = (String)data.get("billcretype");
            }
            if (!StringUtils.isEmpty((String)billcretype)) {
                this.getPageCache().put("billcretype", billcretype);
            } else {
                billcretype = "1";
                this.getPageCache().put("billcretype", billcretype);
            }
            if (!BillImportHelper.isImport((String)billcretype) && !BillImportHelper.isApi((String)billcretype)) {
                return;
            }
            IDataModel model = (IDataModel)e.getSource();
            List hasPermissionOrg = (List)this.tempCache.get("hasPermissionOrg");
            if (hasPermissionOrg == null) {
                hasPermissionOrg = OrgHelper.getHasPermissionOrg((String)model.getDataEntityType().getName(), (String)"03");
                this.tempCache.put("hasPermissionOrg", hasPermissionOrg);
            }
        }
        long end = System.currentTimeMillis();
        log.info("initImportData tims\uff1a" + (end - start));
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        Object tempOrg;
        Map propMap;
        String billcretype = this.getPageCache().get("billcretype");
        if (!BillImportHelper.isImport((String)billcretype) && !BillImportHelper.isApi((String)billcretype)) {
            return;
        }
        Map data = e.getSourceData();
        if (data == null) {
            return;
        }
        DynamicObject org = BillImportHelper.getBaseDataFromCache((Map)e.getSourceData(), (String)"org", (String)"bos_org", (String)"id,fissale", null, this.tempCache);
        if (org == null) {
            log.info(" org is null ");
            return;
        }
        List hasPermissionOrg = (List)this.tempCache.get("hasPermissionOrg");
        if (!(hasPermissionOrg != null && hasPermissionOrg.contains(org.getPkValue()) || (propMap = BillImportHelper.format4ImportAndApi(tempOrg = data.get("org"))) == null)) {
            e.setCancel(true);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u9500\u552e\u7ec4\u7ec7\u201c%1$s\u201d\u4e0d\u5728\u7528\u6237\u6743\u9650\u8303\u56f4\u5185\u3002", (String)"SalePriceListImportPlugin_0", (String)"scmc-sm-formplugin", (Object[])new Object[0]), org.get("number")));
            e.setFireAfterImportData(false);
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        String billCreType = this.getPageCache().get("billcretype");
        DynamicObject bill = this.getModel().getDataEntity(true);
        if (BillImportHelper.isImport((String)billCreType) || BillImportHelper.isApi((String)billCreType)) {
            billCreType = bill.getString("billcretype");
            if (CommonUtils.isNull((Object)billCreType)) {
                bill.set("billcretype", (Object)BillCreTypeEnum.IMPORTNEW.getValue());
            }
            SaleReturnApplyHelper.completeBillInfo(Collections.singletonList(bill));
        }
    }
}

