/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.formplugin.tpl;

import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.business.helper.BizTypeHelper;
import kd.scmc.sm.business.helper.BillImportHelper;
import kd.scmc.sm.business.helper.SalesAgencyHelper;

public class AgencyTplPlugin
extends AbstractBillPlugIn {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        try (TraceSpan span = Tracer.create((String)"AgencyTplPlugin", (String)"afterBindData");){
            boolean isAgency = SalesAgencyHelper.isAgencyBiz((IFormView)this.getView());
            String appid = this.getView().getFormShowParameter().getAppId();
            if ("csm".equals(appid)) {
                this.getView().setEnable(Boolean.valueOf(!isAgency), new String[]{"billtype", "biztype", "paymode"});
            } else {
                this.getView().setEnable(Boolean.valueOf(!isAgency), new String[]{"paymode"});
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        try (TraceSpan span = Tracer.create((String)"AgencyTplPlugin", (String)"afterCreateNewData");){
            String billcretype = this.getPageCache().get("billcretype");
            if (!BillImportHelper.isManual((String)billcretype)) {
                return;
            }
            if (!SalesAgencyHelper.isAgencyBiz((IFormView)this.getView())) {
                return;
            }
            Object billType = SalesAgencyHelper.getBillTypeID((IFormView)this.getView());
            if (StringUtils.isNotEmpty((String)((String)billType))) {
                this.getModel().setValue("billtype", billType);
                String formId = this.getView().getEntityId();
                Long biztype = BizTypeHelper.getDefaultBizType((String)formId, (Long)Long.valueOf((String)billType), (String)"sm_billtypeparam");
                this.getModel().setValue("biztype", (Object)biztype);
                DynamicObject linetype = BizTypeHelper.getDefaultLineTypeObject((Long)biztype);
                DynamicObjectCollection entrys = this.getModel().getEntryEntity("billentry");
                entrys.forEach(row -> row.set("linetype", (Object)linetype));
            }
            this.getModel().setValue("paymode", (Object)"CREDIT");
        }
    }
}

