/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.formplugin.tpl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bd.sbd.enums.EnableStatusEnum;
import kd.bd.sbd.enums.OperatorGrpTypeEnum;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class BillBizInfoListPlugin
extends AbstractListPlugin {
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        try (TraceSpan span = Tracer.create((String)"BillBizInfoListPlugin", (String)"setFilter");){
            long userId = UserServiceHelper.getCurrentUserId();
            List qFilters = e.getQFilters();
            for (QFilter qf : qFilters) {
                if (!"id".equals(qf.getProperty()) || null == qf.getValue()) continue;
                return;
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
    }

    private List<Long> getValidOperatorGroup(List<Long> orgGrpList, List<Long> userGrpList) {
        ArrayList<Long> grpList = new ArrayList<Long>();
        if (orgGrpList == null || orgGrpList.size() == 0) {
            return userGrpList;
        }
        if (userGrpList == null || userGrpList.size() == 0) {
            return null;
        }
        for (Long orgGrp : orgGrpList) {
            if (!userGrpList.contains(orgGrp)) continue;
            grpList.add(orgGrp);
        }
        return grpList;
    }

    private List<Long> getOperatorGroupByUser(long userID) {
        QFilter q3;
        QFilter q2;
        ArrayList<Long> operatorGroupList = null;
        QFilter q1 = new QFilter("operatorid", "=", (Object)userID);
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operator", (String)"id,operatorid,opergrptype,operatorgrpid", (QFilter[])new QFilter[]{q1, q2 = new QFilter("opergrptype", "=", (Object)OperatorGrpTypeEnum.SALEGRP.getValue()), q3 = new QFilter("invalid", "=", (Object)Boolean.FALSE)});
        if (map != null && map.size() > 0) {
            operatorGroupList = new ArrayList<Long>(map.size());
            for (DynamicObject dyn : map.values()) {
                if (dyn == null) continue;
                operatorGroupList.add(dyn.getLong("operatorgrpid"));
            }
        }
        return operatorGroupList;
    }

    private List<Long> getOperatorGroupByOrg(long orgId) {
        QFilter q3;
        QFilter q2;
        ArrayList<Long> operatorGroupList = null;
        QFilter q1 = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", (Long)orgId);
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (String)"id,createorg,operatorgrouptype,enable", (QFilter[])new QFilter[]{q1, q2 = new QFilter("operatorgrouptype", "=", (Object)OperatorGrpTypeEnum.SALEGRP.getValue()), q3 = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue())});
        if (map != null && map.size() > 0) {
            operatorGroupList = new ArrayList<Long>(map.size());
            for (DynamicObject dyn : map.values()) {
                if (dyn == null) continue;
                operatorGroupList.add((Long)dyn.getPkValue());
            }
        }
        return operatorGroupList;
    }
}

