/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.formplugin.tpl;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.LinkSetElement;
import kd.bos.entity.LinkSetItemElement;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Audit;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.Submit;
import kd.bos.form.control.Label;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.sm.business.helper.AppParameterHelper;
import kd.scmc.sm.business.helper.BillImportHelper;
import kd.scmc.sm.business.helper.OperGrpHelper;
import kd.scmc.sm.business.helper.OrgHelper;
import kd.scmc.sm.enums.EnableStatusEnum;

public class BillBizInfoPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(BillBizInfoPlugin.class);

    public void registerListener(EventObject e) {
        BasedataEdit deptEdit;
        BasedataEdit operatorEdit;
        super.registerListener(e);
        BasedataEdit operatorGroupEdit = (BasedataEdit)this.getView().getControl("operatorgroup");
        if (operatorGroupEdit != null) {
            operatorGroupEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((operatorEdit = (BasedataEdit)this.getView().getControl("operator")) != null) {
            operatorEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((deptEdit = (BasedataEdit)this.getView().getControl("dept")) != null) {
            deptEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void beforeF7Select(BeforeF7SelectEvent e) {
        try (TraceSpan span = Tracer.create((String)"BillBizInfoPlugin", (String)("beforeF7Select: " + e.getProperty().getName()));){
            String key = e.getProperty().getName();
            IDataModel bill = this.getModel();
            long userId = UserServiceHelper.getCurrentUserId();
            DynamicObject org = (DynamicObject)bill.getValue("org");
            if (org == null) {
                return;
            }
            Long orgId = (Long)org.getPkValue();
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            switch (key) {
                case "operator": {
                    try {
                        showParameter.getListFilterParameter().setQFilters(OperGrpHelper.buildOperatorFilter((Long)userId, (DynamicObject)org, (ListShowParameter)showParameter));
                        return;
                    }
                    catch (Exception ee) {
                        log.error(ee.getMessage());
                        showParameter.getListFilterParameter().setFilter(new QFilter("opergrptype", "=", (Object)OperGrpHelper.getOperatorGroupType()));
                        return;
                    }
                }
                case "operatorgroup": {
                    DynamicObject operator = (DynamicObject)bill.getValue("operator");
                    showParameter.getListFilterParameter().setQFilters(OperGrpHelper.buildOperatorGrpFilter((DynamicObject)org, (DynamicObject)operator));
                    return;
                }
                case "dept": {
                    DynamicObject user;
                    List deptIDs = OrgHelper.getAllToOrg((String)"15", (String)"01", (Long)orgId, (boolean)true);
                    DynamicObject operator2 = (DynamicObject)this.getModel().getValue("operator");
                    if (operator2 != null && (user = operator2.getDynamicObject("operatorid")) != null) {
                        Long userID = (Long)user.getPkValue();
                        Long deptID = UserServiceHelper.getUserMainOrgId((long)userID);
                        deptIDs.add(deptID);
                    }
                    QFilter q6 = new QFilter("id", "in", (Object)deptIDs);
                    showParameter.getListFilterParameter().getQFilters().add(q6);
                    return;
                }
            }
            return;
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String billcretype = this.getPageCache().get("billcretype");
        if (!BillImportHelper.isManual((String)billcretype)) {
            return;
        }
        super.propertyChanged(e);
        try (TraceSpan span = Tracer.create((String)"BillBizInfoPlugin", (String)("propertyChanged: " + e.getProperty().getName()));){
            String propName = e.getProperty().getName();
            ChangeData[] valueSet = e.getChangeSet();
            Object newValue = valueSet[0].getNewValue();
            Object oldValue = valueSet[0].getOldValue();
            if (newValue != null && oldValue != null && newValue instanceof DynamicObject && oldValue instanceof DynamicObject && ((DynamicObject)newValue).getPkValue().equals(((DynamicObject)oldValue).getPkValue())) {
                return;
            }
            if (propName.equalsIgnoreCase("operatorgroup")) {
                this.changeOperatorGroup((DynamicObject)newValue);
            } else if (propName.equalsIgnoreCase("operator")) {
                this.changeOperator((DynamicObject)newValue);
            }
        }
    }

    private void changeOperator(DynamicObject operator) {
        if (operator != null) {
            Long userID;
            operator = BusinessDataServiceHelper.loadSingleFromCache((Object)operator.getPkValue(), (String)"bd_operator");
            this.getModel().setValue("operatorgroup", operator.get("operatorgrpid"));
            this.getView().setEnable(Boolean.TRUE, new String[]{"operatorgroup"});
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org == null) {
                return;
            }
            Long l = userID = operator.get("operatorid") != null ? (Long)((DynamicObject)operator.get("operatorid")).getPkValue() : null;
            if (userID != null) {
                Long deptID = UserServiceHelper.getUserMainOrgId((long)userID);
                this.getModel().setValue("dept", (Object)deptID);
            }
            if (this.getView().getControl("operatorphone") != null) {
                ((Label)this.getView().getControl("operatorphone")).setText((String)operator.getDynamicObject("operatorid").get("phone"));
            }
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"operatorgroup"});
            this.getModel().setValue("operatorgroup", null);
            this.getModel().setValue("dept", null);
            if (this.getView().getControl("operatorphone") != null) {
                ((Label)this.getView().getControl("operatorphone")).setText(null);
            }
        }
    }

    private void changeOperatorGroup(DynamicObject operatorGroup) {
        if (operatorGroup == null) {
            this.getModel().setValue("operator", null);
            this.getModel().setValue("dept", null);
        }
    }

    public void afterCreateNewData(EventObject e) {
        try (TraceSpan span = Tracer.create((String)"BillBizInfoPlugin", (String)"afterCreateNewData");){
            String billcretype = this.getPageCache().get("billcretype");
            if (!BillImportHelper.isManual((String)billcretype)) {
                return;
            }
            super.afterCreateNewData(e);
            IDataModel model = this.getModel();
            long userId = UserServiceHelper.getCurrentUserId();
            DynamicObject org = (DynamicObject)model.getValue("org");
            if (org == null) {
                return;
            }
            if (model.getValue("operator") == null && model.getValue("operatorgroup") == null) {
                QFilter qFilter13;
                QFilter qFilter12;
                QFilter qFilter11;
                DynamicObject[] operators;
                QFilter qFilter03;
                QFilter qFilter02;
                String operatorGrpType = OperGrpHelper.getOperatorGroupType();
                QFilter qFilter01 = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", (Long)((Long)org.getPkValue()));
                Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (QFilter[])new QFilter[]{qFilter01, qFilter02 = new QFilter("operatorgrouptype", "=", (Object)operatorGrpType), qFilter03 = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue())});
                if (map.size() != 0 && (operators = BusinessDataServiceHelper.load((String)"bd_operator", (String)"operatorid,operatornumber,operatorname,operatorgrpid,opergrpnumber,opergrpname,opergrptype", (QFilter[])new QFilter[]{qFilter11 = new QFilter("operatorgrpid", "in", map.keySet()), qFilter12 = new QFilter("operatorid", "=", (Object)userId), qFilter13 = new QFilter("invalid", "=", (Object)Boolean.FALSE)})) != null && operators.length > 0) {
                    model.setValue("operator", operators[0].getPkValue());
                    Long operatorGrpId = (Long)operators[0].get("operatorgrpid");
                    model.setValue("operatorgroup", (Object)operatorGrpId);
                    Long deptId = UserServiceHelper.getUserMainOrgId((long)userId);
                    model.setValue("dept", (Object)deptId);
                }
            }
        }
    }

    public void afterBindData(EventObject e) {
        try (TraceSpan span = Tracer.create((String)"BillBizInfoPlugin", (String)"afterBindData");){
            IDataModel model = this.getModel();
            Object value = model.getValue("operator");
            if (value != null) {
                DynamicObject operator = (DynamicObject)value;
                operator = BusinessDataServiceHelper.loadSingleFromCache((Object)operator.getPkValue(), (String)"bd_operator");
                this.getView().setEnable(Boolean.TRUE, new String[]{"operatorgroup"});
                if (this.getView().getControl("operatorphone") != null) {
                    ((Label)this.getView().getControl("operatorphone")).setText((String)operator.getDynamicObject("operatorid").get("phone"));
                }
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"operatorgroup"});
                if (this.getView().getControl("operatorphone") != null) {
                    ((Label)this.getView().getControl("operatorphone")).setText(null);
                }
            }
            this.getPageCache().put("isdraw", String.valueOf(this.isDraw()));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        IDataModel bill = this.getModel();
        if (args.getSource() instanceof Save || args.getSource() instanceof Submit || args.getSource() instanceof Audit) {
            DynamicObject org = (DynamicObject)bill.getValue("org");
            if (org == null) {
                return;
            }
            Object operatorGroupIsolate = AppParameterHelper.getSmAppParameter((Long)((Long)org.getPkValue()), (String)"foperatorgroupisolate");
            if (operatorGroupIsolate instanceof Boolean && ((Boolean)operatorGroupIsolate).booleanValue()) {
                if (bill.getValue("operatorgroup") == null) {
                    args.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9500\u552e\u7ec4\u7ec7\u5df2\u542f\u7528\u4e1a\u52a1\u7ec4\u6570\u636e\u9694\u79bb\uff0c\u8bf7\u586b\u5199\u9500\u552e\u5458\u3002", (String)"BillBizInfoPlugin_1", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (bill.getValue("operator") == null) {
                    args.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9500\u552e\u7ec4\u7ec7\u5df2\u542f\u7528\u4e1a\u52a1\u7ec4\u6570\u636e\u9694\u79bb\uff0c\u8bf7\u586b\u5199\u9500\u552e\u5458\u3002", (String)"BillBizInfoPlugin_1", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
        }
    }

    private boolean isDraw() {
        String formId = this.getView().getEntityId();
        LinkSetElement linkSet = ConvertMetaServiceHelper.loadLinkSet((String)formId);
        if (linkSet == null || linkSet.getItems() == null || linkSet.getItems().isEmpty()) {
            return false;
        }
        ExtendedDataEntitySet dataSet = new ExtendedDataEntitySet();
        DynamicObject billObj = this.getModel().getDataEntity();
        dataSet.Parse(new DynamicObject[]{billObj}, (MainEntityType)billObj.getDataEntityType());
        for (LinkSetItemElement linkEntry : linkSet.getItems()) {
            ExtendedDataEntity[] rows = dataSet.FindByEntityKey(linkEntry.getLinkEntityKey());
            if (rows == null || rows.length <= 0) continue;
            for (ExtendedDataEntity row : rows) {
                if (!this.haveSourceBillId(row.getDataEntity())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean haveSourceBillId(DynamicObject linkRow) {
        LinkEntryType linkType = (LinkEntryType)linkRow.getDataEntityType();
        Long sBillId = (Long)linkType.getSBillIdProp().getValueFast((Object)linkRow);
        return sBillId != null && sBillId != 0L;
    }
}

