/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.formplugin.tpl;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;

public class BillPricePlugin
extends AbstractBillPlugIn {
    private static final String VIEWPRICING = "viewpricing";
    private static final String DELETEPRICINGPROCESS = "_delete_pricing_process_";
    private static final String PRICINGPROCESSIDLIST = "_pricing_process_id_list_";

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        Boolean inputAmount;
        String operateKey = ((FormOperate)e.getSource()).getOperateKey();
        IDataModel model = this.getModel();
        if (VIEWPRICING.equals(operateKey) && this.getControl("inputamount") != null && (inputAmount = (Boolean)model.getValue("inputamount")) == Boolean.TRUE) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u628a\u201c\u5f55\u5165\u91d1\u989d\u201d\u5f00\u5173\u7f6e\u4e3a\u201c\u5426\u201d\uff0c\u518d\u67e5\u770b\u5b9a\u4ef7\u8fc7\u7a0b\u3002", (String)"BillPricePlugin_1", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject[] pricingProcessList;
        super.beforePropertyChanged(e);
        if ("inputamount".equals(e.getProperty().getName()) && Boolean.TRUE.equals(e.getChangeSet()[0].getNewValue()) && (pricingProcessList = this.getPricingProcessList()) != null && pricingProcessList.length > 0) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u201c\u5f55\u5165\u91d1\u989d\u201d\u5f00\u5173\u7f6e\u4e3a\u201c\u662f\u201d\u5c06\u5220\u9664\u73b0\u6709\u5b9a\u4ef7\u8fc7\u7a0b\uff0c\u662f\u5426\u786e\u8ba4\uff1f", (String)"BillPricePlugin_2", (String)"scmc-sm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Wait, new ConfirmCallBackListener(DELETEPRICINGPROCESS, (IFormPlugin)this));
            this.getPageCache().put(PRICINGPROCESSIDLIST, String.valueOf(Arrays.stream(pricingProcessList).map(row -> (Long)row.getPkValue()).collect(Collectors.toList())));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        IPageCache pageCache = this.getPageCache();
        if (StringUtils.equals((CharSequence)DELETEPRICINGPROCESS, (CharSequence)callBackId)) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                String pricingProcessIdListStr = pageCache.get(PRICINGPROCESSIDLIST);
                List pricingProcessIdList = SerializationUtils.fromJsonStringToList((String)pricingProcessIdListStr, Long.class);
                QFilter qFilter = new QFilter("id", "in", (Object)pricingProcessIdList);
                DeleteServiceHelper.delete((String)"msbd_pricingprocess", (QFilter[])qFilter.toArray());
            } else {
                this.getModel().setValue("inputamount", (Object)Boolean.FALSE);
            }
        }
    }

    private DynamicObject[] getPricingProcessList() {
        DynamicObject bill = this.getModel().getDataEntity(true);
        Long id = (Long)bill.getPkValue();
        if (id == null || id.equals(48L)) {
            return null;
        }
        QFilter qFilter = new QFilter("billid", "=", (Object)id);
        return BusinessDataServiceHelper.load((String)"msbd_pricingprocess", (String)"id", (QFilter[])qFilter.toArray());
    }
}

