/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.formplugin.tpl;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.business.helper.BizTypeHelper;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.scmc.sm.business.helper.BillImportHelper;
import kd.scmc.sm.business.helper.BillTplHelper;
import kd.scmc.sm.business.helper.CurrencyHelper;
import kd.scmc.sm.business.helper.KitSalesHelper;
import kd.scmc.sm.business.helper.OrgHelper;
import kd.scmc.sm.business.helper.SalesOrgHelper;
import kd.scmc.sm.consts.Constants;
import kd.scmc.sm.enums.DiscountTypeEnum;
import kd.scmc.sm.enums.OwnerTypeEnum;
import kd.scmc.sm.enums.StatusEnum;

public class BillTplImportPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(BillTplImportPlugin.class);
    private static final String BILLCRETYPE = "1";
    private static final String BASECURRRENCY = "baseCurrencyID";
    private static final String EXRATETABLE = "exchangeRateTableID";
    private static final String PARAMFORMID = "sm_billtypeparam";
    private Map<String, Object> tempCache = new HashMap<String, Object>();

    public void initImportData(InitImportDataEventArgs e) {
        long start = System.currentTimeMillis();
        try (TraceSpan span = Tracer.create((String)"BillTplImportPlugin", (String)"initImportData");){
            String billcretype = "";
            List sourceDataList = e.getSourceDataList();
            if (sourceDataList.isEmpty()) {
                return;
            }
            for (Map data : sourceDataList) {
                if (data.get("billcretype") == null || !StringUtils.isBlank((String)billcretype)) continue;
                billcretype = (String)data.get("billcretype");
            }
            if (!StringUtils.isEmpty((String)billcretype)) {
                this.getPageCache().put("billcretype", billcretype);
            } else {
                billcretype = BILLCRETYPE;
                this.getPageCache().put("billcretype", billcretype);
            }
            if (!BillImportHelper.isImport((String)billcretype) && !BillImportHelper.isApi((String)billcretype)) {
                return;
            }
            IDataModel model = (IDataModel)e.getSource();
            List hasPermissionOrg = (List)this.tempCache.get("hasPermissionOrg");
            if (hasPermissionOrg == null) {
                hasPermissionOrg = OrgHelper.getHasPermissionOrg((String)model.getDataEntityType().getName(), (String)"03");
                this.tempCache.put("hasPermissionOrg", hasPermissionOrg);
            }
        }
        long end = System.currentTimeMillis();
        log.info("initImportData tims\uff1a" + (end - start));
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        try (TraceSpan span = Tracer.create((String)"BillTplImportPlugin", (String)"beforeImportData");){
            QFilter q2;
            QFilter q1;
            log.info("start beforeImportData ");
            String url = RequestContext.get().getClientUrl();
            if (url != null && url.contains("appendentryrows")) {
                return;
            }
            String billcretype = this.getPageCache().get("billcretype");
            if (!BillImportHelper.isImport((String)billcretype) && !BillImportHelper.isApi((String)billcretype)) {
                return;
            }
            IDataModel model = this.getModel();
            long t1 = System.currentTimeMillis();
            log.info("try to get org ");
            DynamicObject org = BillImportHelper.getBaseDataFromCache((Map)e.getSourceData(), (String)"org", (String)"bos_org", (String)"id,fissale", null, this.tempCache);
            if (org == null) {
                log.info(" org is null ");
                return;
            }
            List hasPermissionOrg = (List)this.tempCache.get("hasPermissionOrg");
            if (hasPermissionOrg == null || !hasPermissionOrg.contains(org.getPkValue())) {
                Map orgMap = BillImportHelper.format4ImportAndApi(e.getSourceData().get("org"));
                e.setCancel(true);
                e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u9500\u552e\u7ec4\u7ec7\u201c%s\u201d\u4e0d\u5728\u7528\u6237\u6743\u9650\u8303\u56f4\u5185\u3002", (String)"BillTplImportPlugin_0", (String)"scmc-sm-formplugin", (Object[])new Object[0]), org.get("number")));
                e.setFireAfterImportData(false);
                return;
            }
            if (!((Boolean)org.get("fissale")).booleanValue()) {
                e.setCancel(true);
                e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u9500\u552e\u7ec4\u7ec7\u201c%s\u201d\u65e0\u9500\u552e\u804c\u80fd\u3002", (String)"BillTplImportPlugin_1", (String)"scmc-sm-formplugin", (Object[])new Object[0]), org.get("number")));
                e.setFireAfterImportData(false);
                return;
            }
            long t2 = System.currentTimeMillis();
            log.info("cachePermission time :" + (t2 - t1));
            if (BillImportHelper.isImport((String)billcretype)) {
                Map billtypeMap;
                DynamicObject billtype = BillImportHelper.getBaseDataFromCache((Map)e.getSourceData(), (String)"billtype", (String)"bos_billtype", (String)"billformid", null, this.tempCache);
                if (billtype == null) {
                    return;
                }
                String formId = this.getView().getFormShowParameter().getFormId();
                String formName = this.getView().getFormShowParameter().getFormName();
                String number = billtype.getString("number");
                if (!billtype.getDynamicObject("billformid").getPkValue().equals(formId)) {
                    e.setCancel(true);
                    e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u201c%1$s\u201d\u4e0d\u662f\u201c%2$s\u201d\u53ef\u7528\u6216\u5df2\u5ba1\u6838\u72b6\u6001\u7684\u5355\u636e\u7c7b\u578b\u3002", (String)"BillTplImportPlugin_13", (String)"scmc-sm-formplugin", (Object[])new Object[0]), number, formName));
                    e.setFireAfterImportData(false);
                }
                if ((billtypeMap = BillImportHelper.format4ImportAndApi(e.getSourceData().get("billtype"))) != null) {
                    DynamicObject billtypeparameter = (DynamicObject)this.tempCache.get("billtypeparameter" + billtypeMap.get(billtypeMap.get("importprop")));
                    if (billtype != null && billtypeparameter == null && billtypeMap != null) {
                        billtypeparameter = (DynamicObject)SystemParamServiceHelper.getBillTypeParameter((String)model.getDataEntityType().getName(), (String)PARAMFORMID, (long)((Long)billtype.getPkValue()));
                        this.tempCache.put("billtypeparameter" + billtypeMap.get(billtypeMap.get("importprop")), billtypeparameter);
                    }
                }
                long t3 = System.currentTimeMillis();
                log.info("cacheBillType time :" + (t3 - t2));
                Map customerMap = BillImportHelper.format4ImportAndApi(e.getSourceData().get("customer"));
                if (customerMap != null) {
                    DynamicObject payingCustomer;
                    DynamicObject settleCustomer;
                    DynamicObject recCustomer;
                    String customerBizFunction;
                    DynamicObject customer = BillImportHelper.getBaseDataFromCache((Map)e.getSourceData(), (String)"customer", (String)"bd_customer", (String)"id,bizfunction,delivercustomerid,paymentcustomerid,invoicecustomerid,consignment", (QFilter[])new QFilter[]{new QFilter((String)customerMap.get("importprop"), "=", customerMap.get(customerMap.get("importprop")))}, this.tempCache);
                    if (customer == null) {
                        e.setCancel(true);
                        e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u8ba2\u8d27\u5ba2\u6237\u201c%1$s\u201d\u672a\u5206\u914d\u7ed9\u9500\u552e\u7ec4\u7ec7\u201c%2$s\u201d\u3002", (String)"BillTplImportPlugin_2", (String)"scmc-sm-formplugin", (Object[])new Object[0]), customerMap.get(customerMap.get("importprop")), org.get("number")));
                        e.setFireAfterImportData(false);
                        return;
                    }
                    Boolean consignment = customer.getBoolean("consignment");
                    if ("sm_SalesOrder_Agency_BT_S".equalsIgnoreCase(billtype.getString("number")) && !consignment.booleanValue()) {
                        e.setCancel(true);
                        e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u8ba2\u8d27\u5ba2\u6237\u201c%s\u201d\u4e0d\u662f\u53ef\u5bc4\u552e\u5ba2\u6237\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"BillTplImportPlugin_14", (String)"scmc-sm-formplugin", (Object[])new Object[0]), customerMap.get(customerMap.get("importprop"))));
                        e.setFireAfterImportData(false);
                    }
                    if (StringUtils.isEmpty((String)(customerBizFunction = customer.getString("bizfunction"))) || !customerBizFunction.contains(BILLCRETYPE)) {
                        e.setCancel(true);
                        e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u8ba2\u8d27\u5ba2\u6237\u201c%s\u201d\u6ca1\u6709\u9500\u552e\u804c\u80fd\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"BillTplImportPlugin_12", (String)"scmc-sm-formplugin", (Object[])new Object[0]), customerMap.get(customerMap.get("importprop"))));
                        e.setFireAfterImportData(false);
                        return;
                    }
                    Map recCustomerMap = BillImportHelper.format4ImportAndApi(e.getSourceData().get("reccustomer"));
                    if (recCustomerMap != null) {
                        recCustomer = BillImportHelper.getBaseDataFromCache((Map)e.getSourceData(), (String)"reccustomer", (String)"bd_customer", (String)"id,bizfunction", (QFilter[])new QFilter[]{new QFilter((String)recCustomerMap.get("importprop"), "=", recCustomerMap.get(recCustomerMap.get("importprop")))}, this.tempCache);
                        if (recCustomer == null) {
                            e.setCancel(true);
                            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u6536\u8d27\u5ba2\u6237\u201c%1$s\u201d\u672a\u5206\u914d\u7ed9\u9500\u552e\u7ec4\u7ec7\u201c%2$s\u201d\u3002", (String)"BillTplImportPlugin_6", (String)"scmc-sm-formplugin", (Object[])new Object[0]), recCustomerMap.get(recCustomerMap.get("importprop")), org.get("number")));
                            e.setFireAfterImportData(false);
                            return;
                        }
                        String bizFunction = recCustomer.getString("bizfunction");
                        if (StringUtils.isEmpty((String)bizFunction) || !bizFunction.contains("4")) {
                            e.setCancel(true);
                            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u6536\u8d27\u5ba2\u6237\u201c%s\u201d\u6ca1\u6709\u6536\u8d27\u804c\u80fd\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"BillTplImportPlugin_7", (String)"scmc-sm-formplugin", (Object[])new Object[0]), recCustomerMap.get(recCustomerMap.get("importprop"))));
                            e.setFireAfterImportData(false);
                            return;
                        }
                    } else {
                        recCustomer = customer.getDynamicObject("delivercustomerid");
                        if (recCustomer != null) {
                            HashMap<String, Object> newOperator = new HashMap<String, Object>();
                            newOperator.put("id", recCustomer.getPkValue());
                            e.getSourceData().put("reccustomer", newOperator);
                        }
                    }
                    Map settleCustomerMap = BillImportHelper.format4ImportAndApi(e.getSourceData().get("settlecustomer"));
                    if (settleCustomerMap != null) {
                        settleCustomer = BillImportHelper.getBaseDataFromCache((Map)e.getSourceData(), (String)"settlecustomer", (String)"bd_customer", (String)"id,bizfunction", (QFilter[])new QFilter[]{new QFilter((String)settleCustomerMap.get("importprop"), "=", settleCustomerMap.get(settleCustomerMap.get("importprop")))}, this.tempCache);
                        if (settleCustomer == null) {
                            e.setCancel(true);
                            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u5ba2\u6237\u201c%1$s\u201d\u672a\u5206\u914d\u7ed9\u9500\u552e\u7ec4\u7ec7\u201c%2$s\u201d\u3002", (String)"BillTplImportPlugin_8", (String)"scmc-sm-formplugin", (Object[])new Object[0]), settleCustomerMap.get(settleCustomerMap.get("importprop")), org.get("number")));
                            e.setFireAfterImportData(false);
                            return;
                        }
                        String bizFunction = settleCustomer.getString("bizfunction");
                        if (StringUtils.isEmpty((String)bizFunction) || !bizFunction.contains("2")) {
                            e.setCancel(true);
                            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u5ba2\u6237\u201c%s\u201d\u6ca1\u6709\u7ed3\u7b97\u804c\u80fd\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"BillTplImportPlugin_9", (String)"scmc-sm-formplugin", (Object[])new Object[0]), settleCustomerMap.get(settleCustomerMap.get("importprop"))));
                            e.setFireAfterImportData(false);
                            return;
                        }
                    } else {
                        settleCustomer = customer.getDynamicObject("invoicecustomerid");
                        if (settleCustomer != null) {
                            HashMap<String, Object> newOperator = new HashMap<String, Object>();
                            newOperator.put("id", settleCustomer.getPkValue());
                            e.getSourceData().put("settlecustomer", newOperator);
                        }
                    }
                    Map payingCustomerMap = BillImportHelper.format4ImportAndApi(e.getSourceData().get("payingcustomer"));
                    if (payingCustomerMap != null) {
                        payingCustomer = BillImportHelper.getBaseDataFromCache((Map)e.getSourceData(), (String)"payingcustomer", (String)"bd_customer", (String)"id,bizfunction", (QFilter[])new QFilter[]{new QFilter((String)payingCustomerMap.get("importprop"), "=", payingCustomerMap.get(payingCustomerMap.get("importprop")))}, this.tempCache);
                        if (payingCustomer == null) {
                            e.setCancel(true);
                            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5ba2\u6237\u201c%1$s\u201d\u672a\u5206\u914d\u7ed9\u9500\u552e\u7ec4\u7ec7\u201c%2$s\u201d\u3002", (String)"BillTplImportPlugin_10", (String)"scmc-sm-formplugin", (Object[])new Object[0]), payingCustomerMap.get(payingCustomerMap.get("importprop")), org.get("number")));
                            e.setFireAfterImportData(false);
                            return;
                        }
                        String bizFunction = payingCustomer.getString("bizfunction");
                        if (StringUtils.isEmpty((String)bizFunction) || !bizFunction.contains("3")) {
                            e.setCancel(true);
                            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5ba2\u6237\u201c%s\u201d\u6ca1\u6709\u4ed8\u6b3e\u804c\u80fd\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"BillTplImportPlugin_11", (String)"scmc-sm-formplugin", (Object[])new Object[0]), payingCustomerMap.get(payingCustomerMap.get("importprop"))));
                            e.setFireAfterImportData(false);
                            return;
                        }
                    } else {
                        payingCustomer = customer.getDynamicObject("paymentcustomerid");
                        if (payingCustomer != null) {
                            HashMap<String, Object> newOperator = new HashMap<String, Object>();
                            newOperator.put("id", payingCustomer.getPkValue());
                            e.getSourceData().put("payingcustomer", newOperator);
                        }
                    }
                    Map linkmanMap = BillImportHelper.format4ImportAndApi(e.getSourceData().get("linkman"));
                    if (linkmanMap != null && "phone".equals(linkmanMap.get("importprop"))) {
                        Map providerLinkMans = BusinessDataServiceHelper.loadFromCache((String)"bd_customerlinkman", (String)"customerid,id,contactperson,phone", (QFilter[])new QFilter[]{new QFilter("customerid", "=", customer.getPkValue()), new QFilter("phone", "=", linkmanMap.get(linkmanMap.get("importprop")))});
                        if (providerLinkMans == null || providerLinkMans.size() == 0) {
                            e.setCancel(true);
                            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u8ba2\u8d27\u5ba2\u6237\u201c%1$s\u201d\u4e0b\u8054\u7cfb\u4eba\u7535\u8bdd\u201c%2$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"BillTplImportPlugin_4", (String)"scmc-sm-formplugin", (Object[])new Object[0]), customerMap.get(customerMap.get("importprop")), linkmanMap.get(linkmanMap.get("importprop"))));
                            e.setFireAfterImportData(false);
                            return;
                        }
                        if (providerLinkMans.size() != 1) {
                            e.setCancel(true);
                            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u8ba2\u8d27\u5ba2\u6237\u201c%1$s\u201d\u4e0b\u8054\u7cfb\u4eba\u7535\u8bdd\u201c%2$s\u201d\u91cd\u590d\u3002", (String)"BillTplImportPlugin_5", (String)"scmc-sm-formplugin", (Object[])new Object[0]), customerMap.get(customerMap.get("importprop")), linkmanMap.get(linkmanMap.get("importprop"))));
                            e.setFireAfterImportData(false);
                            return;
                        }
                        HashMap<String, Object> newOperator = new HashMap<String, Object>();
                        newOperator.put("id", ((DynamicObject)providerLinkMans.values().stream().findFirst().get()).getPkValue());
                        e.getSourceData().put("linkman", newOperator);
                    }
                }
                long t4 = System.currentTimeMillis();
                log.info("cacheCustomerPermission time :" + (t4 - t3));
            }
            Map operatorGroupMap = BillImportHelper.format4ImportAndApi(e.getSourceData().get("operatorgroup"));
            Map operatorMap = BillImportHelper.format4ImportAndApi(e.getSourceData().get("operator"));
            if (operatorGroupMap == null && operatorMap == null) {
                return;
            }
            boolean isCheck = false;
            if (operatorGroupMap != null && operatorMap != null) {
                q1 = BillImportHelper.getBaseDataOrgFilterFromCache((DynamicObject)org, (String)"operatorgroup", (String)"bd_operatorgroup", this.tempCache);
                q2 = new QFilter((String)operatorGroupMap.get("importprop"), "=", operatorGroupMap.get(operatorGroupMap.get("importprop")));
                QFilter q3 = new QFilter("entryentity.invalid", "=", (Object)Boolean.FALSE);
                DynamicObject operatorGroup = BillImportHelper.getBaseDataFromCache((Map)e.getSourceData(), (String)"operatorgroup", (String)"bd_operatorgroup", (String)"id,operatornumber,operatorname,operator,invalid", (QFilter[])new QFilter[]{q1, q2, q3}, this.tempCache);
                if (operatorGroup != null && operatorMap != null && operatorMap.get(operatorMap.get("importprop")) != null) {
                    DynamicObjectCollection entryentity = operatorGroup.getDynamicObjectCollection("entryentity");
                    for (DynamicObject operator : entryentity) {
                        if (!operatorMap.get(operatorMap.get("importprop")).equals(operator.getString((String)operatorMap.get("importprop"))) && !operatorMap.get(operatorMap.get("importprop")).equals(operator.getDynamicObject("operator") != null ? operator.getDynamicObject("operator").getPkValue() : "0")) continue;
                        HashMap<String, Object> newOperator = new HashMap<String, Object>();
                        newOperator.put("id", operator.getPkValue());
                        e.getSourceData().put("operator", newOperator);
                        isCheck = true;
                        break;
                    }
                }
            } else if (operatorMap != null) {
                q1 = BillImportHelper.getBaseDataOrgFilterFromCache((DynamicObject)org, (String)"operatorgroup", (String)"bd_operatorgroup", this.tempCache);
                q2 = new QFilter("operatorgrouptype", "=", (Object)"XSZ");
                QFilter q3 = new QFilter("entryentity.invalid", "=", (Object)Boolean.FALSE);
                Map operatorgroups = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (String)"id,operator,operatornumber,operatorname,invalid", (QFilter[])new QFilter[]{q1, q2, q3});
                block63: for (DynamicObject operatorGroup : operatorgroups.values()) {
                    DynamicObjectCollection entryentity = operatorGroup.getDynamicObjectCollection("entryentity");
                    for (DynamicObject operator : entryentity) {
                        if (!operatorMap.get(operatorMap.get("importprop")).equals(operator.getString((String)operatorMap.get("importprop"))) && !operatorMap.get(operatorMap.get("importprop")).equals(operator.getDynamicObject("operator") != null ? operator.getDynamicObject("operator").getPkValue() : "0")) continue;
                        HashMap<String, Object> newOperator = new HashMap<String, Object>();
                        newOperator.put("id", operator.getPkValue());
                        e.getSourceData().put("operator", newOperator);
                        HashMap<String, Object> newOperatorGroup = new HashMap<String, Object>();
                        newOperatorGroup.put("id", operatorGroup.getPkValue());
                        e.getSourceData().put("operatorgroup", newOperatorGroup);
                        isCheck = true;
                        continue block63;
                    }
                }
            }
            if (!isCheck) {
                e.setCancel(true);
                e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u9500\u552e\u7ec4\u7ec7\u201c%s\u201d\u4e0b\u672a\u627e\u5230\u5339\u914d\u7684\u9500\u552e\u7ec4\u6216\u9500\u552e\u5458\u3002", (String)"BillTplImportPlugin_3", (String)"scmc-sm-formplugin", (Object[])new Object[0]), org.get("number")));
                e.setFireAfterImportData(false);
                return;
            }
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        try (TraceSpan span = Tracer.create((String)"BillTplImportPlugin", (String)"afterImportData");){
            String url = RequestContext.get().getClientUrl();
            if (url != null && url.contains("appendentryrows")) {
                return;
            }
            String billcretype = this.getPageCache().get("billcretype");
            if (BillImportHelper.isImport((String)billcretype)) {
                Date bizdate;
                Long lineTypeId;
                String formid = this.getView().getEntityId();
                IDataModel model = this.getModel();
                model.setValue("billcretype", (Object)BILLCRETYPE);
                model.setValue("billstatus", (Object)StatusEnum.SAVE.getValue());
                DynamicObject org = (DynamicObject)model.getValue("org");
                if (org == null) {
                    return;
                }
                long t2 = System.currentTimeMillis();
                DynamicObject billType = (DynamicObject)model.getValue("billtype");
                DynamicObject bizType = (DynamicObject)model.getValue("biztype");
                Long bizTypeId = null;
                if (billType != null) {
                    if (bizType == null) {
                        Long billTypeId = (Long)billType.getPkValue();
                        bizTypeId = this.getDefaultBizTypeIdFromCache(formid, billTypeId);
                        this.getModel().setValue("biztype", (Object)bizTypeId);
                    } else {
                        bizTypeId = (Long)bizType.getPkValue();
                    }
                }
                if (((lineTypeId = (Long)this.tempCache.get("import_dafaultLineType_" + bizTypeId)) == null || lineTypeId.compareTo(0L) == 0) && (lineTypeId = BizTypeHelper.getDefaultLineType((Long)bizTypeId)) != null && lineTypeId.compareTo(0L) != 0) {
                    this.tempCache.put("import_dafaultLineType_" + bizTypeId, lineTypeId);
                }
                DynamicObject lineType = null;
                if (lineTypeId != null) {
                    lineType = BusinessDataServiceHelper.loadSingleFromCache((Object)lineTypeId, (String)"bd_linetype");
                }
                if ((bizdate = (Date)model.getValue("bizdate")) == null) {
                    bizdate = TimeServiceHelper.today();
                    model.setValue("bizdate", (Object)bizdate);
                }
                Date exratedate = (Date)model.getValue("exratedate");
                Calendar instance = Calendar.getInstance();
                instance.set(11, 0);
                instance.set(12, 0);
                instance.set(13, 0);
                instance.set(14, 0);
                Date time = instance.getTime();
                if (exratedate == null || exratedate.compareTo(time) == 0) {
                    model.setValue("exratedate", (Object)bizdate);
                }
                DynamicObject currency = (DynamicObject)model.getValue("currency");
                DynamicObject exRateTable = (DynamicObject)model.getValue("exratetable");
                Long currencyId = 0L;
                if (currency == null || exRateTable == null) {
                    Map currencyAndExRateMap = (Map)this.tempCache.get(org.getPkValue() + "-currencyAndExRateMap");
                    if (currencyAndExRateMap == null) {
                        currencyAndExRateMap = CurrencyHelper.getCurrencyAndExRateTable((Long)((Long)org.getPkValue()));
                        if (currencyAndExRateMap != null) {
                            this.tempCache.put(org.getPkValue() + "-currencyAndExRateMap", currencyAndExRateMap);
                            model.setValue("currency", currencyAndExRateMap.get(BASECURRRENCY));
                            model.setValue("exratetable", currencyAndExRateMap.get(EXRATETABLE));
                        }
                    } else {
                        model.setValue("currency", currencyAndExRateMap.get(BASECURRRENCY));
                        model.setValue("exratetable", currencyAndExRateMap.get(EXRATETABLE));
                    }
                    if (currencyAndExRateMap != null) {
                        currencyId = (Long)currencyAndExRateMap.get(BASECURRRENCY);
                    }
                } else {
                    currencyId = (Long)currency.getPkValue();
                }
                DynamicObject settleCurrency = (DynamicObject)model.getValue("settlecurrency");
                if (settleCurrency == null) {
                    DynamicObject customer = (DynamicObject)model.getValue("customer");
                    if (customer != null && customer.getDynamicObject("settlementcyid") != null) {
                        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)customer.getDynamicObject("settlementcyid").getPkValue(), (String)"bd_currency", (String)"id, number, name, amtprecision,priceprecision,sign,isshowsign");
                        model.setValue("settlecurrency", dynamicObject != null ? dynamicObject.getPkValue() : currencyId);
                    } else {
                        model.setValue("settlecurrency", (Object)currencyId);
                        model.setValue("exchangerate", (Object)BigDecimal.ONE);
                    }
                }
                long settleCurrencyId = model.getValue("settlecurrency") == null ? 0L : (Long)((DynamicObject)model.getValue("settlecurrency")).getPkValue();
                long exrateTableId = model.getValue("exratetable") == null ? 0L : (Long)((DynamicObject)model.getValue("exratetable")).getPkValue();
                Date date = (Date)model.getValue("exratedate");
                String key = "import_getExChangeType_" + settleCurrencyId + "_" + currencyId + "_" + exrateTableId + "_" + date.getTime();
                String exchangeType = (String)this.tempCache.get(key);
                if (exchangeType == null && (exchangeType = CurrencyHelper.getExchangeType((Long)settleCurrencyId, (Long)currencyId, (Long)exrateTableId, (Date)date)) != null) {
                    this.tempCache.put(key, exchangeType);
                }
                model.setValue("exchangetype", (Object)exchangeType);
                BigDecimal exChangeRate = (BigDecimal)model.getValue("exchangerate");
                if (exChangeRate == null || exChangeRate.compareTo(BigDecimal.ZERO) == 0) {
                    String keyRate = "import_getExChangeRate_" + settleCurrencyId + "_" + currencyId + "_" + exrateTableId + "_" + date.getTime();
                    BigDecimal rate = (BigDecimal)this.tempCache.get(keyRate);
                    if (rate == null && (rate = CurrencyHelper.getExRate((Long)settleCurrencyId, (Long)currencyId, (Long)exrateTableId, (Date)date, (String)exchangeType)) != null) {
                        this.tempCache.put(keyRate, rate);
                    }
                    model.setValue("exchangerate", (Object)rate);
                }
                long t3 = System.currentTimeMillis();
                log.info("dealBillHead time :" + (t3 - t2));
                long t6 = 0L;
                this.setOwner(model);
                boolean istax = (Boolean)model.getValue("istax");
                DynamicObjectCollection billentrys = (DynamicObjectCollection)model.getValue("billentry");
                for (DynamicObject billentry : billentrys) {
                    DynamicObject taxRateId;
                    boolean isPresent;
                    String configproperties;
                    Boolean isuseauxpty;
                    DynamicObject material = billentry.getDynamicObject("material");
                    if (material == null || material.getDynamicObject("masterid") == null) continue;
                    if (billentry.get("linetype") == null) {
                        billentry.set("linetype", (Object)lineType);
                    }
                    billentry.set("materialmasterid", (Object)material.getDynamicObject("masterid"));
                    if (material.getDynamicObject("masterid").getBoolean("isdisposable")) {
                        if (StringUtils.isEmpty((String)billentry.getString("materialname"))) {
                            billentry.set("materialname", (Object)material.getDynamicObject("masterid").getString("name"));
                        }
                    } else {
                        billentry.set("materialname", (Object)material.getDynamicObject("masterid").getString("name"));
                    }
                    billentry.set("baseunit", (Object)material.getDynamicObject("masterid").getDynamicObject("baseunit"));
                    if (billentry.get("auxunit") == null) {
                        billentry.set("auxunit", (Object)material.getDynamicObject("masterid").getDynamicObject("auxptyunit"));
                    }
                    if (!(isuseauxpty = Boolean.valueOf(material.getDynamicObject("masterid").getBoolean("isuseauxpty"))).booleanValue()) {
                        billentry.set("auxpty", null);
                    }
                    if (billentry.get("productline") == null) {
                        billentry.set("productline", (Object)material.getDynamicObject("masterid").getDynamicObject("productline"));
                    }
                    if (!"2".equals(configproperties = material.getDynamicObject("masterid").getString("configproperties"))) {
                        billentry.set("configuredcode", null);
                    }
                    if (isPresent = billentry.getBoolean("ispresent")) {
                        if (istax) {
                            if (BigDecimalUtil.isZero((BigDecimal)billentry.getBigDecimal("priceandtax"))) {
                                billentry.set("discounttype", (Object)DiscountTypeEnum.NULL.getValue());
                                billentry.set("discountrate", (Object)Constants.ZERO);
                            } else {
                                billentry.set("discounttype", (Object)DiscountTypeEnum.DISRATE.getValue());
                                billentry.set("discountrate", (Object)Constants.ONE_HUNDRED);
                            }
                        } else if (BigDecimalUtil.isZero((BigDecimal)billentry.getBigDecimal("price"))) {
                            billentry.set("discounttype", (Object)DiscountTypeEnum.NULL.getValue());
                            billentry.set("discountrate", (Object)Constants.ZERO);
                        } else {
                            billentry.set("discounttype", (Object)DiscountTypeEnum.DISRATE.getValue());
                            billentry.set("discountrate", (Object)Constants.ONE_HUNDRED);
                        }
                        billentry.set("amount", (Object)Constants.ZERO);
                        billentry.set("curamount", (Object)Constants.ZERO);
                        billentry.set("taxamount", (Object)Constants.ZERO);
                        billentry.set("curtaxamount", (Object)Constants.ZERO);
                        billentry.set("discountamount", (Object)Constants.ZERO);
                        billentry.set("amountandtax", (Object)Constants.ZERO);
                        billentry.set("curamountandtax", (Object)Constants.ZERO);
                    }
                    Object discountType = billentry.get("discounttype");
                    if (DiscountTypeEnum.NULL.getValue().equals(discountType)) {
                        billentry.set("discountrate", (Object)Constants.ZERO);
                    }
                    if ((taxRateId = billentry.getDynamicObject("taxrateid")) == null) {
                        billentry.set("taxrate", (Object)BigDecimal.ZERO);
                    } else {
                        BigDecimal taxRate = taxRateId.getBigDecimal("taxrate");
                        billentry.set("taxrate", (Object)taxRate);
                    }
                    long t4 = System.currentTimeMillis();
                    DynamicObject unit = billentry.getDynamicObject("unit");
                    if (unit == null) {
                        unit = material.getDynamicObject("salesunit");
                        billentry.set("unit", (Object)unit);
                    }
                    if (material == null || unit == null) {
                        return;
                    }
                    DynamicObject baseUnit = null;
                    baseUnit = billentry.getDynamicObject("baseunit");
                    if (baseUnit != null) {
                        BillImportHelper.calcBaseQtyAndAuxQty((DynamicObject)billentry);
                    }
                    long t5 = System.currentTimeMillis();
                    t6 += t5 - t4;
                }
                log.info("dealQty time :" + t6);
                if (!KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) {
                    BillTplHelper.calculateAmount4WholeBill((DynamicObject)model.getDataEntity(true), (IDataModel)model);
                }
            }
        }
    }

    private Long getDefaultBizTypeIdFromCache(String formid, Long billTypeId) {
        String key = "import_dafaultBizType_" + formid + "_" + billTypeId;
        Long bizTypeId = (Long)this.tempCache.get(key);
        if ((bizTypeId == null || bizTypeId.compareTo(0L) == 0) && (bizTypeId = BizTypeHelper.getDefaultBizType((String)formid, (Long)billTypeId, (String)PARAMFORMID)) != null && bizTypeId.compareTo(0L) != 0) {
            this.tempCache.put(key, bizTypeId);
        }
        return bizTypeId;
    }

    public void setOwner(IDataModel model) {
        DynamicObject org = (DynamicObject)model.getValue("org");
        int entryRowCount = model.getEntryRowCount("billentry");
        String entityName = model.getDataEntity().getDataEntityType().getName();
        String stockOrgName = null;
        if ("sm_salorder".equals(entityName)) {
            stockOrgName = "e_stockorg";
        } else if ("sm_delivernotice".equals(entityName)) {
            stockOrgName = "deliverorg";
        } else if ("sm_returnapply".equals(entityName)) {
            stockOrgName = "entryinvorg";
        } else {
            return;
        }
        for (int i = 0; i < entryRowCount; ++i) {
            DynamicObject stockOrg = (DynamicObject)model.getValue(stockOrgName, i);
            DynamicObject owner = (DynamicObject)model.getValue("owner", i);
            Object ownerType = model.getValue("ownertype", i);
            if (stockOrg == null || owner != null || ownerType != null && !OwnerTypeEnum.ORG.getValue().equals((String)ownerType)) continue;
            Long stockOrgId = (Long)stockOrg.getPkValue();
            Long orgId = (Long)org.getPkValue();
            String key = "getOwnerDefaultValue" + orgId + "_" + stockOrgId;
            Long ownerId = (Long)this.tempCache.get(key);
            if (ownerId == null) {
                ownerId = SalesOrgHelper.getOwnerDefaultValue((Long)orgId, (Long)stockOrgId);
                if (ownerId == null) {
                    this.tempCache.put(key, 0L);
                } else {
                    this.tempCache.put(key, ownerId);
                }
            }
            if (ownerId == null || ownerId == 0L) {
                model.setValue("owner", null, i);
                continue;
            }
            model.setValue("owner", (Object)ownerId, i);
        }
    }
}

