/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.formplugin.tpl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillModel;
import kd.bos.mvc.form.ClientViewProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mpscmm.msbd.business.helper.BizTypeHelper;
import kd.mpscmm.msbd.common.enums.KitTransferModelEnum;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.scmc.sm.business.helper.AmountCalcHelper;
import kd.scmc.sm.business.helper.BillImportHelper;
import kd.scmc.sm.business.helper.BillTplHelper;
import kd.scmc.sm.business.helper.CurrencyHelper;
import kd.scmc.sm.business.helper.KitSalesHelper;
import kd.scmc.sm.business.helper.LotCacheHelper;
import kd.scmc.sm.business.helper.LotHelper;
import kd.scmc.sm.business.helper.MaterialHelper;
import kd.scmc.sm.business.helper.OperationBizStatusHelper;
import kd.scmc.sm.business.helper.PluginConnectControllHelper;
import kd.scmc.sm.business.helper.PropertyChangeHelper;
import kd.scmc.sm.business.helper.RowOPHelper;
import kd.scmc.sm.business.pojo.AmountInfo;
import kd.scmc.sm.consts.Constants;
import kd.scmc.sm.consts.SMEntityConst;
import kd.scmc.sm.enums.ChangeTypeEnum;
import kd.scmc.sm.enums.CloseStatusEnum;
import kd.scmc.sm.enums.DiscountTypeEnum;
import kd.scmc.sm.enums.ProductTypeEnum;
import kd.scmc.sm.enums.RowCloseStatusEnum;
import kd.scmc.sm.enums.RowTerminateStatusEnum;
import kd.scmc.sm.enums.StatusEnum;
import kd.scmc.sm.util.CommonUtils;
import kd.scmc.sm.util.QFBuilder;
import kd.sdk.scmc.sm.extpoint.ICleanFieldsCasePlugin;

public class BillTplPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
EntryGridBindDataListener {
    private static final String INVENTORY_QUERY = "inventory_query";
    private static final String CACHE_KEY_BIZTYPEID = "cache_key_biztype_id";
    private static final String CACHE_KEY_DEF_LINETYPEID = "cache_key_def_linetype_id";
    private static final String CONFIRM_LINETYPE = "confirm_linetype";
    private static final String CACHE_LINETYPE = "cache_linetype";
    private static final String CACHE_SUMAMOUNT = "BillTplPlugin_sumAmount";
    private static final Log LOG = LogFactory.getLog(BillTplPlugin.class);
    private static final String CUR_AMTPRECISION = "amtprecision";
    public static final String TAXRATE_FILTER = "taxrate_filter";
    private static Map<String, Object> ownerTypeCache = new HashMap<String, Object>();
    private static Map<String, Object> ownCache = new HashMap<String, Object>();

    public void initialize() {
        EntryGrid entry = (EntryGrid)this.getControl("billentry");
        if (entry != null) {
            entry.addDataBindListener((EntryGridBindDataListener)this);
        }
    }

    public void registerListener(EventObject e) {
        BasedataEdit lot;
        BasedataEdit configuredcode;
        BasedataEdit location;
        BasedataEdit linetype;
        BasedataEdit project;
        BasedataEdit owner;
        BasedataEdit entrysettleorg;
        BasedataEdit customer;
        BasedataEdit operator;
        BasedataEdit dept;
        BasedataEdit unitEdit;
        BasedataEdit materialversion;
        BasedataEdit materialEdit;
        BasedataEdit bizTypeEdit;
        Toolbar toolbar;
        super.registerListener(e);
        EntryGrid entry = (EntryGrid)this.getControl("billentry");
        if (entry != null) {
            entry.addDataBindListener((EntryGridBindDataListener)this);
        }
        if ((toolbar = (Toolbar)this.getView().getControl("tbmainentry")) != null) {
            toolbar.addItemClickListener((ItemClickListener)this);
        }
        if ((bizTypeEdit = (BasedataEdit)this.getView().getControl("biztype")) != null) {
            bizTypeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((materialEdit = (BasedataEdit)this.getView().getControl("material")) != null) {
            materialEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((materialversion = (BasedataEdit)this.getView().getControl("materialversion")) != null) {
            materialversion.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((unitEdit = (BasedataEdit)this.getView().getControl("unit")) != null) {
            unitEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((dept = (BasedataEdit)this.getControl("dept")) != null) {
            dept.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((operator = (BasedataEdit)this.getControl("operator")) != null) {
            operator.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((customer = (BasedataEdit)this.getControl("customer")) != null) {
            customer.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((entrysettleorg = (BasedataEdit)this.getControl("entrysettleorg")) != null) {
            entrysettleorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((owner = (BasedataEdit)this.getControl("owner")) != null) {
            owner.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((project = (BasedataEdit)this.getControl("project")) != null) {
            project.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((linetype = (BasedataEdit)this.getControl("linetype")) != null) {
            linetype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((location = (BasedataEdit)this.getView().getControl("location")) != null) {
            location.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((configuredcode = (BasedataEdit)this.getView().getControl("configuredcode")) != null) {
            configuredcode.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((lot = (BasedataEdit)this.getView().getControl("lot")) != null) {
            lot.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        this.addClickListeners(new String[]{"lotnumber"});
        BasedataEdit taxrateid = (BasedataEdit)this.getView().getControl("taxrateid");
        if (taxrateid != null) {
            taxrateid.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        try (TraceSpan span = Tracer.create((String)"BillTplPlugin", (String)"afterCreateNewData");){
            String billcretype = this.getPageCache().get("billcretype");
            if (!BillImportHelper.isManual((String)billcretype)) {
                return;
            }
            this.initCurrencyDefaultValue();
            DynamicObject billType = (DynamicObject)this.getModel().getValue("billtype");
            this.changeBillType(billType);
            int entryRowCount = this.getModel().getEntryRowCount("billentry");
            for (int i = 0; i < entryRowCount; ++i) {
                this.initNewDataEntry(i);
            }
            this.getPageCache().remove(CACHE_KEY_DEF_LINETYPEID);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billentry");
        if (entryGrid != null) {
            entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        }
        DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("billentry");
        for (DynamicObject entry : entrys) {
            if (!CommonUtils.isNull((Object)entry.get("materialname")) || CommonUtils.isNull((Object)entry.getDynamicObject("material"))) continue;
            DynamicObject material = entry.getDynamicObject("material");
            entry.set("materialname", (Object)material.getDynamicObject("masterid").getString("name"));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        try (TraceSpan span = Tracer.create((String)"BillTplPlugin", (String)"afterBindData");){
            this.queryTaxrate();
            OperationBizStatusHelper.setEnableByBizStatus((IFormView)this.getView());
            if (this.getModel().getValue("customer") == null) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"settlecurrency"});
            }
            this.getView().setEnable(Boolean.FALSE, -1, new String[]{"amountandtax"});
            this.getView().setEnable(Boolean.FALSE, -1, new String[]{"amount"});
        }
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        try (TraceSpan span = Tracer.create((String)"BillTplPlugin", (String)"entryGridBindData");){
            LotCacheHelper.setLotEnable((List)e.getRows(), (IFormView)this.getView(), (IPageCache)this.getPageCache());
            this.setDiscountRateScale(this.getModel().getValue("settlecurrency"));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        AbstractOperate operate = (AbstractOperate)e.getSource();
        String key = operate.getOperateKey();
        try (TraceSpan span = Tracer.create((String)"BillTplPlugin", (String)("beforeDoOperation" + key));){
            switch (key) {
                case "discountamount": {
                    if (this.isBackCalculate()) {
                        return;
                    }
                    DynamicObject settleCurrency = (DynamicObject)this.getModel().getValue("settlecurrency");
                    if (settleCurrency == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u7ed3\u7b97\u5e01\u3002", (String)"BillTplPlugin_31", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        e.setCancel(true);
                        return;
                    }
                    int rowCount = this.getModel().getEntryRowCount("billentry");
                    Boolean isHasRow = Boolean.FALSE;
                    for (int i = 0; i < rowCount; ++i) {
                        BigDecimal discountAmount = (BigDecimal)this.getModel().getValue("discountamount", i);
                        BigDecimal amountAndTax = (BigDecimal)this.getModel().getValue("amountandtax", i);
                        boolean isPresent = (Boolean)this.getModel().getValue("ispresent", i);
                        if (isPresent || amountAndTax.add(discountAmount).compareTo(BigDecimal.ZERO) <= 0) continue;
                        isHasRow = Boolean.TRUE;
                        break;
                    }
                    if (isHasRow != false) return;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d60\u54c1\u6216\u201c\u4ef7\u7a0e\u5408\u8ba1+\u6298\u6263\u989d\u201d\u4e3a0\u65f6\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165\u603b\u6298\u6263\u989d\u3002", (String)"BillTplPlugin_32", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
            }
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        try (TraceSpan span = Tracer.create((String)"BillTplPlugin", (String)("afterDoOperation" + e.getOperateKey()));){
            IDataModel model = this.getModel();
            if ("bizclose".equals(e.getOperateKey()) || "bizunclose".equals(e.getOperateKey())) {
                OperationBizStatusHelper.setEnableByBizStatus((IFormView)this.getView());
            } else if ("batchfillentry".equals(e.getOperateKey())) {
                Object value;
                EntryGrid entry = (EntryGrid)this.getControl("billentry");
                String focusField = entry.getEntryState().getFocusField();
                int focusRow = entry.getEntryState().getFocusRow();
                List<String> fields = Arrays.asList("discounttype", "discountrate", "amount", "amountandtax");
                if (focusRow > -1 && fields.contains(focusField) && (value = this.getModel().getValue(focusField, focusRow)) != null) {
                    for (int i = focusRow; i < this.getModel().getEntryRowCount("billentry"); ++i) {
                        boolean isPresent = (Boolean)this.getModel().getValue("ispresent", i);
                        if (!isPresent) continue;
                        if ("amount".equals(focusField) || "amountandtax".equals(focusField)) {
                            model.setValue(focusField, (Object)BigDecimal.ZERO, i);
                        }
                        if (!"discounttype".equals(focusField) && !"discountrate".equals(focusField)) continue;
                        BigDecimal price = (BigDecimal)model.getValue("price", i);
                        if (BigDecimalUtil.isZero((BigDecimal)price)) {
                            model.setValue("discounttype", (Object)DiscountTypeEnum.NULL.getValue(), i);
                            model.setValue("discountrate", (Object)BigDecimal.ZERO, i);
                            continue;
                        }
                        model.setValue("discounttype", (Object)DiscountTypeEnum.DISRATE.getValue(), i);
                        model.setValue("discountrate", (Object)BigDecimalUtil.HUNDRED, i);
                    }
                }
            } else if ("discountamount".equals(e.getOperateKey())) {
                if (this.isBackCalculate()) {
                    return;
                }
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("sm_discountamount");
                HashMap<String, Object> customParams = new HashMap<String, Object>(8);
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                DynamicObject settleCurrency = (DynamicObject)this.getModel().getValue("settlecurrency");
                customParams.put("currency", settleCurrency.getPkValue());
                formShowParameter.setCustomParams(customParams);
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "sm_discountamount"));
                this.getView().showForm(formShowParameter);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        try (TraceSpan span = Tracer.create((String)"BillTplPlugin", (String)("closedCallBack" + actionId));){
            switch (actionId) {
                case "sm_discountamount": {
                    BigDecimal rowDistAmount;
                    int i;
                    boolean isPresent;
                    BigDecimal amountAndTax;
                    BigDecimal discountAmount;
                    int i2;
                    if (returnData == null) return;
                    Map discountMap = (Map)returnData;
                    if (discountMap == null) return;
                    if (discountMap.isEmpty()) return;
                    if (discountMap.get("discountamount") == null) return;
                    BigDecimal totalDiscountAmount = new BigDecimal(discountMap.get("discountamount").toString());
                    BigDecimal remainDiscountAmount = new BigDecimal(discountMap.get("discountamount").toString());
                    DynamicObject settleCurrency = (DynamicObject)this.getModel().getValue("settlecurrency");
                    int settleAmtPrecision = settleCurrency == null ? 10 : settleCurrency.getInt(CUR_AMTPRECISION);
                    BigDecimal allAmountAndTaxAndDiscount = BigDecimal.ZERO;
                    int rowCount = this.getModel().getEntryRowCount("billentry");
                    for (i2 = 0; i2 < rowCount; ++i2) {
                        discountAmount = (BigDecimal)this.getModel().getValue("discountamount", i2);
                        amountAndTax = (BigDecimal)this.getModel().getValue("amountandtax", i2);
                        isPresent = (Boolean)this.getModel().getValue("ispresent", i2);
                        if (isPresent) continue;
                        allAmountAndTaxAndDiscount = allAmountAndTaxAndDiscount.add(discountAmount).add(amountAndTax);
                    }
                    if (totalDiscountAmount.compareTo(BigDecimal.ZERO) <= 0 || totalDiscountAmount.compareTo(allAmountAndTaxAndDiscount) > 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6574\u5355\u201c\u4ef7\u683c\u5408\u8ba1+\u6298\u6263\u989d\u201d\u5927\u4e8e0\u65f6\uff0c\u603b\u6298\u6263\u989d\u5fc5\u987b\u5927\u4e8e0\u4e14\u5c0f\u4e8e\u7b49\u4e8e\u6574\u5355\u201c\u4ef7\u683c\u5408\u8ba1+\u6298\u6263\u989d\u201d\uff08\u8d60\u54c1\u9664\u5916\uff09\u3002", (String)"BillTplPlugin_33", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    for (i2 = 0; i2 < rowCount; ++i2) {
                        discountAmount = (BigDecimal)this.getModel().getValue("discountamount", i2);
                        amountAndTax = (BigDecimal)this.getModel().getValue("amountandtax", i2);
                        isPresent = (Boolean)this.getModel().getValue("ispresent", i2);
                        if (isPresent || discountAmount.add(amountAndTax).compareTo(BigDecimal.ZERO) <= 0) continue;
                        this.getModel().setValue("discounttype", (Object)DiscountTypeEnum.NULL.getValue(), i2);
                    }
                    BigDecimal allAmountAndTax = BigDecimal.ZERO;
                    ArrayList<Integer> allDistRows = new ArrayList<Integer>(16);
                    for (i = 0; i < rowCount; ++i) {
                        BigDecimal amountAndTax2 = (BigDecimal)this.getModel().getValue("amountandtax", i);
                        boolean isPresent2 = (Boolean)this.getModel().getValue("ispresent", i);
                        if (isPresent2 || amountAndTax2.compareTo(BigDecimal.ZERO) <= 0) continue;
                        allAmountAndTax = allAmountAndTax.add(amountAndTax2);
                        allDistRows.add(i);
                    }
                    if (allAmountAndTax.compareTo(BigDecimal.ZERO) <= 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d60\u54c1\u6216\u201c\u4ef7\u7a0e\u5408\u8ba1+\u6298\u6263\u989d\u201d\u4e3a0\u65f6\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165\u603b\u6298\u6263\u989d\u3002", (String)"BillTplPlugin_32", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    for (i = 0; i < allDistRows.size(); remainDiscountAmount = remainDiscountAmount.subtract(rowDistAmount), ++i) {
                        int rowIndex = (Integer)allDistRows.get(i);
                        BigDecimal amountAndTax3 = (BigDecimal)this.getModel().getValue("amountandtax", rowIndex);
                        rowDistAmount = BigDecimal.ZERO;
                        rowDistAmount = i == allDistRows.size() - 1 ? remainDiscountAmount : totalDiscountAmount.multiply(amountAndTax3).divide(allAmountAndTax, settleAmtPrecision, 4);
                        if (rowDistAmount.compareTo(amountAndTax3) > 0) {
                            rowDistAmount = amountAndTax3;
                        }
                        this.getModel().setValue("discounttype", (Object)DiscountTypeEnum.FIXEDDIS.getValue(), rowIndex);
                        this.getModel().setValue("discountamount", (Object)rowDistAmount, rowIndex);
                    }
                    if (remainDiscountAmount.compareTo(BigDecimal.ZERO) <= 0) return;
                    if (allDistRows.isEmpty()) return;
                    i = allDistRows.size() - 1;
                    while (i >= 0) {
                        Integer rowIndex = (Integer)allDistRows.get(i);
                        if (remainDiscountAmount.compareTo(BigDecimal.ZERO) == 0) {
                            return;
                        }
                        BigDecimal amountAndTax4 = (BigDecimal)this.getModel().getValue("amountandtax", rowIndex.intValue());
                        rowDistAmount = (BigDecimal)this.getModel().getValue("discountamount", rowIndex.intValue());
                        if (amountAndTax4.compareTo(BigDecimal.ZERO) != 0) {
                            if (remainDiscountAmount.compareTo(amountAndTax4) < 0) {
                                remainDiscountAmount = BigDecimal.ZERO;
                                this.getModel().setValue("discountamount", (Object)rowDistAmount.add(remainDiscountAmount), rowIndex.intValue());
                            } else {
                                remainDiscountAmount = remainDiscountAmount.subtract(amountAndTax4);
                                this.getModel().setValue("discountamount", (Object)rowDistAmount.add(amountAndTax4), rowIndex.intValue());
                            }
                        }
                        --i;
                    }
                    return;
                }
            }
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void propertyChanged(PropertyChangedArgs e) {
        billcretype = this.getPageCache().get("billcretype");
        if (!BillImportHelper.isManual((String)billcretype)) {
            return;
        }
        if (PropertyChangeHelper.isStopPropertyChange((IPageCache)this.getPageCache())) {
            return;
        }
        span = Tracer.create((String)"BillTplPlugin", (String)("propertyChanged: " + e.getProperty().getName()));
        var4_4 = null;
        try {
            valueSet = e.getChangeSet();
            propName = e.getProperty().getName();
            newValue = valueSet[0].getNewValue();
            var8_10 = propName;
            var9_11 = -1;
            switch (var8_10.hashCode()) {
                case -1406200462: {
                    if (!var8_10.equals("auxqty")) break;
                    var9_11 = 0;
                    break;
                }
                case 106934601: {
                    if (!var8_10.equals("price")) break;
                    var9_11 = 1;
                    break;
                }
                case 1937848573: {
                    if (!var8_10.equals("priceandtax")) break;
                    var9_11 = 2;
                    break;
                }
                case 1732257873: {
                    if (!var8_10.equals("ispresent")) break;
                    var9_11 = 3;
                    break;
                }
                case 890591169: {
                    if (!var8_10.equals("billtype")) break;
                    var9_11 = 4;
                    break;
                }
                case 299066663: {
                    if (!var8_10.equals("material")) break;
                    var9_11 = 5;
                    break;
                }
                case 3594628: {
                    if (!var8_10.equals("unit")) break;
                    var9_11 = 6;
                    break;
                }
                case 112310: {
                    if (!var8_10.equals("qty")) break;
                    var9_11 = 7;
                    break;
                }
                case 525710694: {
                    if (!var8_10.equals("taxrateid")) break;
                    var9_11 = 8;
                    break;
                }
                case 550534139: {
                    if (!var8_10.equals("discounttype")) break;
                    var9_11 = 9;
                    break;
                }
                case 550451617: {
                    if (!var8_10.equals("discountrate")) break;
                    var9_11 = 10;
                    break;
                }
                case 227283161: {
                    if (!var8_10.equals("discountamount")) break;
                    var9_11 = 11;
                    break;
                }
                case 1430589827: {
                    if (!var8_10.equals("exchangerate")) break;
                    var9_11 = 12;
                    break;
                }
                case 1430672349: {
                    if (!var8_10.equals("exchangetype")) break;
                    var9_11 = 13;
                    break;
                }
                case 100510273: {
                    if (!var8_10.equals("istax")) break;
                    var9_11 = 14;
                    break;
                }
                case 884639324: {
                    if (!var8_10.equals("settlecurrency")) break;
                    var9_11 = 15;
                    break;
                }
                case -96646451: {
                    if (!var8_10.equals("biztype")) break;
                    var9_11 = 16;
                    break;
                }
                case -1997587773: {
                    if (!var8_10.equals("warehouse")) break;
                    var9_11 = 17;
                    break;
                }
                case 107345: {
                    if (!var8_10.equals("lot")) break;
                    var9_11 = 18;
                    break;
                }
                case 1378680282: {
                    if (!var8_10.equals("lotnumber")) break;
                    var9_11 = 19;
                    break;
                }
                case -496177956: {
                    if (!var8_10.equals("entrychangetype")) break;
                    var9_11 = 20;
                    break;
                }
                case -2114849742: {
                    if (!var8_10.equals("materialname")) break;
                    var9_11 = 21;
                    break;
                }
                case -97146047: {
                    if (!var8_10.equals("bizdate")) break;
                    var9_11 = 22;
                    break;
                }
                case 1189618990: {
                    if (!var8_10.equals("linetype")) break;
                    var9_11 = 23;
                }
            }
            switch (var9_11) {
                case 0: {
                    if (this.isBackCalculate()) {
                        return;
                    }
                    for (i = 0; i < valueSet.length; ++i) {
                        if (!CommonUtils.isRealChanged((ChangeData)valueSet[i])) continue;
                        rowIndex = valueSet[i].getRowIndex();
                        if (!BillTplHelper.calcBaseQtyAndQty((IDataModel)this.getModel(), (int)rowIndex)) continue;
                        this.calculateAmount(new int[]{rowIndex});
                    }
                    this.doRefresh(valueSet, propName);
                    this.doRefreshHeadAmount();
                    ** break;
lbl123:
                    // 1 sources

                    break;
                }
                ** case 1:
                ** case 2:
                case 3: {
                    this.getPageCache().put("ispresent", "true");
                    for (i = 0; i < valueSet.length; ++i) {
                        rowIndex = valueSet[i].getRowIndex();
                        this.changeIsPresent(valueSet[i].getNewValue(), rowIndex);
                        this.calculateAmount(new int[]{rowIndex});
                    }
                    this.getPageCache().remove("ispresent");
                    this.doRefresh(valueSet, propName);
                    this.doRefreshHeadAmount();
                    ** break;
lbl137:
                    // 1 sources

                    break;
                }
                ** case 4:
                case 5: {
                    for (i = 0; i < valueSet.length; ++i) {
                        if (!CommonUtils.isRealChanged((ChangeData)valueSet[i])) continue;
                        rowIndex = valueSet[i].getRowIndex();
                        this.changeMaterial((DynamicObject)valueSet[i].getNewValue(), (DynamicObject)valueSet[i].getOldValue(), rowIndex);
                    }
                    break;
                }
                ** case 6:
                ** case 7:
                ** case 8:
                ** case 9:
                ** case 10:
                ** case 11:
                ** case 12:
                ** case 13:
                ** case 14:
                ** case 15:
                case 16: {
                    oldValue = (DynamicObject)valueSet[0].getOldValue();
                    if (Objects.equals(newValue, oldValue)) ** break;
                    this.getPageCache().put("cache_key_biztype_id", String.valueOf(oldValue == null ? Long.valueOf(0L) : oldValue.getPkValue()));
                    entryRowCount = this.getModel().getEntryRowCount("billentry");
                    for (i = 0; i < entryRowCount; ++i) {
                        BillTplPlugin.ownerTypeCache.put("ownerType_" + i, this.getModel().getValue("ownertype", i));
                        BillTplPlugin.ownCache.put("owner_" + i, this.getModel().getValue("owner", i));
                    }
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u201c\u4e1a\u52a1\u7c7b\u578b\u201d\u5207\u6362\uff0c\u5c06\u6e05\u9664\u5f53\u524d\u5355\u636e\u7269\u6599\u660e\u7ec6\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"BillTplPlugin_24", (String)"scmc-sm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(propName, (IFormPlugin)this));
                    ** break;
lbl167:
                    // 1 sources

                    break;
                }
                case 17: {
                    this.getModel().setValue("location", null, valueSet[0].getRowIndex());
                    ** break;
lbl171:
                    // 1 sources

                    break;
                }
                case 18: {
                    for (i = 0; i < valueSet.length; ++i) {
                        LotHelper.setLotReturnInfo((IDataModel)this.getModel(), (String)"billentry", (int)valueSet[i].getRowIndex());
                    }
                    this.getView().updateView("billentry");
                    ** break;
lbl178:
                    // 1 sources

                    break;
                }
                case 19: {
                    for (i = 0; i < valueSet.length; ++i) {
                        this.getModel().beginInit();
                        this.getModel().setValue("lot", null, valueSet[i].getRowIndex());
                        this.getModel().endInit();
                        this.getView().updateView("lot", valueSet[i].getRowIndex());
                    }
                    break;
                }
                case 20: {
                    for (i = 0; i < valueSet.length; ++i) {
                        this.xChangeType(valueSet[i]);
                    }
                    break;
                }
                case 21: {
                    for (i = 0; i < valueSet.length; ++i) {
                        if (newValue != null && !kd.bos.util.StringUtils.isBlank((String)((String)newValue))) continue;
                        this.getModel().setValue("materialname", valueSet[i].getOldValue(), valueSet[i].getRowIndex());
                    }
                    break;
                }
                case 22: {
                    if (newValue == null) {
                        PropertyChangeHelper.stopPropertyChange((IPageCache)this.getPageCache());
                        this.getModel().setValue("bizdate", valueSet[0].getOldValue());
                        PropertyChangeHelper.releasePropertyChange((IPageCache)this.getPageCache());
                        ** break;
lbl204:
                        // 1 sources

                    } else {
                        if (!CommonUtils.isRealChanged((ChangeData)valueSet[0])) ** break;
                        this.queryTaxrate();
                        ** break;
                    }
lbl208:
                    // 1 sources

                    break;
                }
                case 23: {
                    entityId = this.getView().getEntityId();
                    if (!"sm_xsalorder".equals(entityId) && !"sm_xssalorder".equals(entityId)) {
                        for (i = 0; i < valueSet.length; ++i) {
                            if (!CommonUtils.isRealChanged((ChangeData)valueSet[i])) continue;
                            this.changeLineType(valueSet[i].getOldValue(), valueSet[i].getNewValue(), valueSet[i].getRowIndex());
                        }
                    }
                    break;
                }
                ** default:
lbl218:
                // 1 sources

                break;
            }
        }
        catch (Throwable var5_7) {
            var4_4 = var5_7;
            throw var5_7;
        }
        finally {
            if (span != null) {
                if (var4_4 != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable var10_12) {
                        var4_4.addSuppressed(var10_12);
                    }
                } else {
                    span.close();
                }
            }
        }
    }

    private void changeLineType(Object oldValue, Object newValue, int rowIndex) {
        if (oldValue != null && newValue == null) {
            PropertyChangeHelper.stopPropertyChange((IPageCache)this.getPageCache());
            this.getModel().setValue("linetype", ((DynamicObject)oldValue).getPkValue(), rowIndex);
            PropertyChangeHelper.releasePropertyChange((IPageCache)this.getPageCache());
            return;
        }
        if (KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) {
            String productType = (String)this.getModel().getValue("producttype", rowIndex);
            if (!ProductTypeEnum.STANDARD.getValue().equals(productType)) {
                return;
            }
        }
        Long srcBillId = (Long)this.getModel().getValue("srcbillid", rowIndex);
        Long srcBillEntryId = (Long)this.getModel().getValue("srcbillentryid", rowIndex);
        if (srcBillId != null && !srcBillId.equals(0L) || srcBillEntryId != null && !srcBillEntryId.equals(0L)) {
            DynamicObject lineType;
            if (this.getControl("supplytrans") != null && (lineType = (DynamicObject)this.getModel().getValue("linetype", rowIndex)) != null) {
                Boolean storageout = lineType.getBoolean("storageout");
                if (!storageout.booleanValue()) {
                    this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"supplytrans"});
                    this.getModel().setValue("supplytrans", (Object)Boolean.FALSE, rowIndex);
                } else {
                    this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"supplytrans"});
                }
                this.getView().updateView("supplytrans", rowIndex);
            }
            return;
        }
        ConfirmCallBackListener callBack = new ConfirmCallBackListener(CONFIRM_LINETYPE, (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u201c\u884c\u7c7b\u578b\u201d\u5c06\u6e05\u9664\u5f53\u524d\u5206\u5f55\u7269\u6599\u4fe1\u606f\uff0c\u662f\u5426\u5207\u6362\uff1f", (String)"BillTplPlugin_29", (String)"scmc-sm-formplugin", (Object[])new Object[0]), null, MessageBoxOptions.YesNo, ConfirmTypes.Default, callBack, null, String.valueOf(rowIndex));
        this.getView().getPageCache().put(CACHE_LINETYPE, oldValue == null ? null : ((DynamicObject)oldValue).getPkValue().toString());
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if ("biztype".equals(event.getCallBackId())) {
            String biztypeId;
            if (event.getResult() == MessageBoxResult.Yes) {
                this.getModel().deleteEntryData("billentry");
                if ("sm_salorder".equals(this.getView().getEntityId())) {
                    this.getModel().deleteEntryData("recplanentry");
                    this.getModel().deleteEntryData("orderdeliverentry");
                }
                this.getModel().createNewEntryRow("billentry");
                this.initNewDataEntry(0);
                BillTplHelper.calculateAmount4WholeBill((DynamicObject)this.getModel().getDataEntity(), (IDataModel)this.getModel());
                this.doRefreshHeadAmount();
            } else if (event.getResult() == MessageBoxResult.Cancel && kd.bos.util.StringUtils.isNotEmpty((String)(biztypeId = this.getPageCache().get(CACHE_KEY_BIZTYPEID)))) {
                this.getModel().beginInit();
                if ("0".equals(biztypeId)) {
                    this.getModel().setValue("biztype", null);
                } else {
                    this.getModel().setValue("biztype", (Object)Long.parseLong(biztypeId));
                }
                DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
                Boolean ownerTypeEnable = bizType != null && !"210".equals(bizType.getString("number")) && !"2101".equals(bizType.getString("number")) && !"2102".equals(bizType.getString("number")) ? Boolean.FALSE : Boolean.TRUE;
                int entryRowCount = this.getModel().getEntryRowCount("billentry");
                for (int i = 0; i < entryRowCount; ++i) {
                    this.getModel().setValue("ownertype", ownerTypeCache.get("ownerType_" + i), i);
                    this.getModel().setValue("owner", ownCache.get("owner_" + i), i);
                    this.getView().updateView("ownertype", i);
                    this.getView().updateView("owner", i);
                }
                ownerTypeCache.clear();
                ownCache.clear();
                this.getView().setEnable(ownerTypeEnable, -1, new String[]{"ownertype"});
                this.getModel().endInit();
                this.getView().updateView("biztype");
            }
            this.getPageCache().remove(CACHE_KEY_DEF_LINETYPEID);
        } else if (StringUtils.equals((CharSequence)CONFIRM_LINETYPE, (CharSequence)event.getCallBackId())) {
            if (event.getCustomVaule() == null) {
                return;
            }
            int rowIndex = Integer.parseInt(event.getCustomVaule());
            if (event.getResult() == MessageBoxResult.Yes) {
                Boolean storageout;
                DynamicObject lineType;
                this.getPageCache().put("changeForceRowMaterial", "true");
                this.getModel().setValue("material", null, rowIndex);
                this.getPageCache().remove("changeForceRowMaterial");
                if (this.getControl("supplytrans") != null && (lineType = (DynamicObject)this.getModel().getValue("linetype", rowIndex)) != null && !(storageout = Boolean.valueOf(lineType.getBoolean("storageout"))).booleanValue()) {
                    this.getModel().setValue("supplytrans", (Object)Boolean.FALSE, rowIndex);
                }
            } else {
                DynamicObject lineType;
                String lineTypeId = this.getView().getPageCache().get(CACHE_LINETYPE);
                this.getModel().beginInit();
                this.getModel().setValue("linetype", (Object)(lineTypeId == null ? null : Long.valueOf(Long.parseLong(lineTypeId))), rowIndex);
                this.getModel().endInit();
                this.getView().updateView("linetype", rowIndex);
                if (this.getControl("supplytrans") != null && (lineType = (DynamicObject)this.getModel().getValue("linetype", rowIndex)) != null) {
                    Boolean storageout = lineType.getBoolean("storageout");
                    if (!storageout.booleanValue()) {
                        this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"supplytrans"});
                        this.getModel().setValue("supplytrans", (Object)Boolean.FALSE, rowIndex);
                    } else {
                        this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"supplytrans"});
                    }
                }
            }
        }
    }

    public void afterCopyData(EventObject e) {
        BillModel model = (BillModel)e.getSource();
        if (model.getValue("operator") != null) {
            DynamicObject operator = (DynamicObject)model.getValue("operator");
            QFBuilder qf = new QFBuilder();
            qf.add("id", "=", operator.getPkValue());
            qf.and("invalid", "=", (Object)Boolean.FALSE);
            operator = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_operator", (QFilter[])qf.toArray());
            if (operator == null) {
                model.setValue("operator", null);
                model.setValue("operatorgroup", null);
            }
        }
        DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)model.getValue("billentry");
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal totalAmountAndTax = BigDecimal.ZERO;
        for (DynamicObject entry : dynamicObjects) {
            BigDecimal curAmount = entry.getBigDecimal("curamount");
            BigDecimal curAmountAndTax = entry.getBigDecimal("curamountandtax");
            totalAmount = totalAmount.add(curAmount);
            totalAmountAndTax = totalAmountAndTax.add(curAmountAndTax);
        }
        model.setValue("curtotalamount", (Object)totalAmount);
        model.setValue("curtotalallamount", (Object)totalAmountAndTax);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        IDataModel bill = this.getModel();
        String formId = this.getView().getEntityId();
        DynamicObject billType = (DynamicObject)bill.getValue("billtype");
        if (billType == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u7c7b\u578b\u3002", (String)"BillTplPlugin_17", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        int rowIndex = this.getModel().getEntryCurrentRowIndex("billentry");
        DynamicObject material = (DynamicObject)bill.getValue("material", rowIndex);
        try (TraceSpan span = Tracer.create((String)"BillTplPlugin", (String)("beforeF7Select: " + e.getProperty().getName()));){
            switch (key) {
                case "material": {
                    if (this.checkOrgIsNull(e)) return;
                    DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
                    if (bizType == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"BillTplPlugin_23", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        e.setCancel(true);
                        return;
                    }
                    DynamicObject lineType = (DynamicObject)this.getModel().getValue("linetype", e.getRow());
                    if ("sm_salesagency".equals(formId)) {
                        return;
                    }
                    if (lineType == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u884c\u7c7b\u578b\u3002", (String)"BillTplPlugin_25", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        e.setCancel(true);
                        return;
                    }
                    List qf = MaterialHelper.getQFilterByLineType((Long)((Long)billType.getPkValue()), (Long)((Long)bizType.getPkValue()), (Long)((Long)lineType.getPkValue()), (boolean)true);
                    if (qf == null) return;
                    if (qf.size() <= 0) return;
                    showParameter.getListFilterParameter().getQFilters().addAll(qf);
                    return;
                }
                case "materialversion": {
                    if (material != null && material.getDynamicObject("masterid") != null) {
                        DynamicObject masterMaterial = material.getDynamicObject("masterid");
                        Long masterMaterialId = (Long)masterMaterial.getPkValue();
                        QFilter qFilter = new QFilter("material ", "=", (Object)masterMaterialId);
                        showParameter.getListFilterParameter().getQFilters().add(qFilter);
                        return;
                    }
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u7f16\u7801\u3002", (String)"BillTplPlugin_10", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                case "unit": {
                    if (material == null || material.getDynamicObject("masterid") == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u7f16\u7801\u3002", (String)"BillTplPlugin_10", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        e.setCancel(true);
                        return;
                    }
                    DynamicObject masterMaterial = material.getDynamicObject("masterid");
                    DynamicObject baseUnit = (DynamicObject)bill.getValue("baseunit", rowIndex);
                    Long srcmuId = baseUnit == null ? Long.valueOf(0L) : (Long)baseUnit.getPkValue();
                    Long masterMaterialId = (Long)masterMaterial.getPkValue();
                    List unitIds = BaseDataServiceHelper.getAssistMUListResult((Long)masterMaterialId, (Long)srcmuId, (String)"1");
                    QFilter qFilter = new QFilter("id", "in", (Object)unitIds);
                    showParameter.getListFilterParameter().setFilter(qFilter);
                    return;
                }
                case "biztype": {
                    List bizTypes = BizTypeHelper.getAllBizTypes((String)this.getView().getEntityId(), (Long)((Long)billType.getPkValue()), (String)"sm_billtypeparam");
                    if (bizTypes != null && !bizTypes.isEmpty()) {
                        QFilter qFilter = new QFilter("id", "in", (Object)bizTypes);
                        showParameter.getListFilterParameter().getQFilters().add(qFilter);
                        return;
                    }
                    QFilter qFilter = new QFilter("id", "=", (Object)0);
                    List<QFilter> qfList = Collections.singletonList(qFilter);
                    showParameter.getListFilterParameter().setQFilters(qfList);
                    return;
                }
                case "linetype": {
                    DynamicObject biztype = (DynamicObject)this.getModel().getValue("biztype");
                    if (biztype != null) {
                        List lineTypeId = BizTypeHelper.getAllLineTypes((Long)((Long)biztype.getPkValue()));
                        showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)lineTypeId));
                        return;
                    }
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"BillTplPlugin_23", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                case "dept": 
                case "operator": 
                case "customer": 
                case "entrysettleorg": 
                case "owner": 
                case "project": {
                    this.checkOrgIsNull(e);
                    return;
                }
                case "location": {
                    DynamicObject warehouse = (DynamicObject)bill.getValue("warehouse", rowIndex);
                    if (CommonUtils.isNull((Object)warehouse)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f53\u524d\u884c\u7684\u4ed3\u5e93\u4fe1\u606f\u3002", (String)"DeliverNoticePlugin_5", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        e.setCancel(true);
                        return;
                    }
                    DynamicObjectCollection locationCol = warehouse.getDynamicObjectCollection("entryentity");
                    List<Long> ids = this.getLoactionIds(locationCol);
                    QFilter qFilter1 = new QFilter("id", "in", ids);
                    showParameter.getListFilterParameter().getQFilters().add(qFilter1);
                    return;
                }
                case "configuredcode": {
                    material = (DynamicObject)bill.getValue("material", rowIndex);
                    if (material == null) return;
                    if (material.getDynamicObject("masterid") == null) return;
                    QFilter qFilter = new QFilter("material", "=", material.getDynamicObject("masterid").getPkValue());
                    showParameter.getListFilterParameter().getQFilters().add(qFilter);
                    return;
                }
                case "lot": {
                    DynamicObject selectEntry = this.getModel().getEntryRowEntity("billentry", rowIndex);
                    QFilter qFilter = LotHelper.getLotMainfFileF7Filter((DynamicObject)bill.getDataEntity(true), (DynamicObject)selectEntry);
                    if (qFilter != null) {
                        showParameter.getListFilterParameter().getQFilters().add(qFilter);
                        return;
                    }
                    showParameter.getListFilterParameter().getQFilters().add(QFilter.of((String)"1!=1", (Object[])new Object[0]));
                    return;
                }
                case "taxrateid": {
                    if (this.checkOrgIsNull(e)) return;
                    String taxrate_filter = this.getPageCache().get(TAXRATE_FILTER);
                    if (!kd.bos.util.StringUtils.isNotEmpty((String)taxrate_filter)) {
                        QFilter filter = QFilter.of((String)"1=-1", (Object[])new Object[0]);
                        showParameter.getListFilterParameter().setFilter(filter);
                        return;
                    }
                    taxrate_filter = taxrate_filter.substring(1, taxrate_filter.length() - 1);
                    String[] taxrateIds = taxrate_filter.split("_");
                    ArrayList<Long> taxrateIdList = new ArrayList<Long>(taxrateIds.length);
                    String[] stringArray = taxrateIds;
                    int n = stringArray.length;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) {
                            QFilter filter = new QFilter("id", "in", taxrateIdList);
                            showParameter.getListFilterParameter().setFilter(filter);
                            return;
                        }
                        String id = stringArray[n2];
                        if (id != null && !"".equals(id)) {
                            taxrateIdList.add(Long.valueOf(id));
                        }
                        ++n2;
                    }
                }
            }
            return;
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        IDataModel model = this.getModel();
        String entryName = e.getEntryProp().getName();
        if ("billentry".equals(entryName)) {
            RowDataEntity[] rowDataEntities = e.getRowDataEntities();
            for (int i = 0; i < rowDataEntities.length; ++i) {
                RowDataEntity rowDataEntity = rowDataEntities[i];
                int rowIndex = rowDataEntity.getRowIndex();
                DynamicObject lineType = (DynamicObject)model.getValue("linetype", rowIndex);
                if (!CommonUtils.isNull((Object)lineType)) continue;
                this.initNewDataEntry(rowIndex);
            }
            this.calcTotalAmount();
            this.getPageCache().remove(CACHE_KEY_DEF_LINETYPEID);
            LotCacheHelper.setLotEnable(Arrays.asList(rowDataEntities), (IFormView)this.getView(), (IPageCache)this.getPageCache());
        }
    }

    private Boolean isCanRowTerminate(Integer rowIndex) {
        String rowCloseStatus = (String)this.getModel().getValue("rowclosestatus", rowIndex.intValue());
        String rowTerminateStatus = (String)this.getModel().getValue("rowterminatestatus", rowIndex.intValue());
        if (!RowCloseStatusEnum.UNROWCLOSE.getValue().equals(rowCloseStatus) || !RowTerminateStatusEnum.UNROWTERMINATE.getValue().equals(rowTerminateStatus)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Boolean isCanRowUnTerminate(Integer rowIndex) {
        String rowCloseStatus = (String)this.getModel().getValue("rowclosestatus", rowIndex.intValue());
        String rowTerminateStatus = (String)this.getModel().getValue("rowterminatestatus", rowIndex.intValue());
        if (!RowCloseStatusEnum.UNROWCLOSE.getValue().equals(rowCloseStatus) || !RowTerminateStatusEnum.ROWTERMINATE.getValue().equals(rowTerminateStatus)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    /*
     * WARNING - void declaration
     */
    public void itemClick(ItemClickEvent e) {
        super.itemClick(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("billentry");
        int[] selectRows = null;
        if (entryGrid != null) {
            selectRows = entryGrid.getSelectRows();
        }
        if (selectRows != null && KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) {
            HashSet<Integer> terminateRowIndex = new HashSet<Integer>(8);
            for (int selectRow : selectRows) {
                terminateRowIndex.add(selectRow);
                String productType = (String)this.getModel().getValue("producttype", selectRow);
                String transferModel = (String)this.getModel().getValue("kittransfermodel", selectRow);
                if (!KitTransferModelEnum.KIT.getValue().equals(transferModel)) continue;
                if (ProductTypeEnum.KITPARENT.getValue().equals(productType)) {
                    void var11_18;
                    Boolean bl = Boolean.TRUE;
                    if ("rowterminate".equals(e.getItemKey())) {
                        if (!this.isCanRowTerminate(selectRow).booleanValue()) {
                            Boolean bl2 = Boolean.FALSE;
                        }
                    } else if ("rowunterminate".equals(e.getItemKey()) && !this.isCanRowUnTerminate(selectRow).booleanValue()) {
                        Boolean bl3 = Boolean.FALSE;
                    }
                    if (var11_18.booleanValue()) {
                        void var11_23;
                        List<Integer> allChildRowIndex = this.getAllChildIndex(selectRow);
                        if (allChildRowIndex == null || allChildRowIndex.isEmpty()) continue;
                        if ("rowterminate".equals(e.getItemKey())) {
                            for (Integer n : allChildRowIndex) {
                                if (this.isCanRowTerminate(n).booleanValue()) continue;
                                Boolean bl4 = Boolean.FALSE;
                            }
                        } else if ("rowunterminate".equals(e.getItemKey())) {
                            for (Integer n : allChildRowIndex) {
                                if (this.isCanRowUnTerminate(n).booleanValue()) continue;
                                Boolean bl5 = Boolean.FALSE;
                            }
                        }
                        if (var11_23.booleanValue()) {
                            terminateRowIndex.addAll(allChildRowIndex);
                            continue;
                        }
                        terminateRowIndex.remove(selectRow);
                        continue;
                    }
                    terminateRowIndex.remove(selectRow);
                    continue;
                }
                if (!ProductTypeEnum.KITCHILD.getValue().equals(productType)) continue;
                Integer n = this.getParentIndex(selectRow);
                Boolean isCanAddAllChild = Boolean.TRUE;
                if (n != null) {
                    if ("rowterminate".equals(e.getItemKey())) {
                        if (!this.isCanRowTerminate(n).booleanValue()) {
                            isCanAddAllChild = Boolean.FALSE;
                        } else {
                            terminateRowIndex.add(n);
                        }
                    } else if ("rowunterminate".equals(e.getItemKey())) {
                        if (!this.isCanRowUnTerminate(n).booleanValue()) {
                            isCanAddAllChild = Boolean.FALSE;
                        } else {
                            terminateRowIndex.add(n);
                        }
                    }
                }
                if (isCanAddAllChild.booleanValue()) {
                    Integer childRowIndex;
                    Object allChildRowIndex = this.getAllChildIndex(selectRow);
                    if (allChildRowIndex == null || allChildRowIndex.isEmpty()) continue;
                    if ("rowterminate".equals(e.getItemKey())) {
                        Iterator iterator = allChildRowIndex.iterator();
                        while (iterator.hasNext()) {
                            childRowIndex = (Integer)iterator.next();
                            if (this.isCanRowTerminate(childRowIndex).booleanValue()) continue;
                            isCanAddAllChild = Boolean.FALSE;
                        }
                    } else if ("rowunterminate".equals(e.getItemKey())) {
                        Iterator iterator = allChildRowIndex.iterator();
                        while (iterator.hasNext()) {
                            childRowIndex = (Integer)iterator.next();
                            if (this.isCanRowUnTerminate(childRowIndex).booleanValue()) continue;
                            isCanAddAllChild = Boolean.FALSE;
                        }
                    }
                    if (isCanAddAllChild.booleanValue()) {
                        terminateRowIndex.addAll((Collection<Integer>)allChildRowIndex);
                        continue;
                    }
                    terminateRowIndex.remove(selectRow);
                    terminateRowIndex.remove(n);
                    continue;
                }
                terminateRowIndex.remove(selectRow);
            }
            if (!terminateRowIndex.isEmpty()) {
                Integer[] temp = terminateRowIndex.toArray(new Integer[0]);
                selectRows = new int[temp.length];
                for (int i = 0; i < temp.length; ++i) {
                    selectRows[i] = temp[i];
                }
            } else {
                selectRows = null;
            }
        }
        IDataModel model = this.getModel();
        String itemKey = e.getItemKey();
        String entityName = this.getModel().getDataEntityType().getName();
        String msg = "";
        boolean isSuccess = false;
        switch (itemKey) {
            case "rowterminate": {
                if (selectRows != null) {
                    for (int n : selectRows) {
                        String rowCloseStatus = (String)model.getValue("rowclosestatus", n);
                        String rowTerminateStatus = (String)model.getValue("rowterminatestatus", n);
                        if (!RowCloseStatusEnum.UNROWCLOSE.getValue().equals(rowCloseStatus) || !RowTerminateStatusEnum.UNROWTERMINATE.getValue().equals(rowTerminateStatus)) continue;
                        model.setValue("rowterminatestatus", (Object)RowTerminateStatusEnum.ROWTERMINATE.getValue(), n);
                        isSuccess = true;
                    }
                }
                if (isSuccess) {
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{model.getDataEntity(true)});
                    model.setDataChanged(false);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u884c\u7ec8\u6b62\u64cd\u4f5c\u6210\u529f\u3002", (String)"BillTplPlugin_2", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    msg = String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u201c%1$s\u201d\uff0c\u201c%2$s\u201d\u6210\u529f\u3002", (String)"DeliverNoticeRowUnClosePlugin_9", (String)"scmc-sm-formplugin", (Object[])new Object[0]), this.getModel().getValue("billno"), RowOPHelper.getOpName((String)entityName, (String)itemKey));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u5206\u5f55\u884c\u4e2d\u6ca1\u6709\u9700\u8981\u7ec8\u6b62\u7684\u884c\u3002", (String)"BillTplPlugin_3", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    msg = String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u201c%1$s\u201d\uff0c\u201c%2$s\u201d\u5931\u8d25\u3002", (String)"DeliverNoticeRowUnClosePlugin_8", (String)"scmc-sm-formplugin", (Object[])new Object[0]), this.getModel().getValue("billno"), RowOPHelper.getOpName((String)entityName, (String)itemKey));
                }
                DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue("org");
                OperationResult operationResult = RowOPHelper.createOperationResult();
                RowOPHelper.writeLog((OperationResult)operationResult, (DynamicObject)dynamicObject, (String)itemKey, (String)msg, (String)entityName);
                break;
            }
            case "rowunterminate": {
                if (selectRows != null) {
                    for (int selectRow : selectRows) {
                        String rowCloseStatus = (String)model.getValue("rowclosestatus", selectRow);
                        String rowTerminateStatus = (String)model.getValue("rowterminatestatus", selectRow);
                        if (!RowCloseStatusEnum.UNROWCLOSE.getValue().equals(rowCloseStatus) || !RowTerminateStatusEnum.ROWTERMINATE.getValue().equals(rowTerminateStatus)) continue;
                        model.setValue("rowterminatestatus", (Object)RowTerminateStatusEnum.UNROWTERMINATE.getValue(), selectRow);
                        isSuccess = true;
                    }
                }
                if (isSuccess) {
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{model.getDataEntity(true)});
                    model.setDataChanged(false);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u884c\u53cd\u7ec8\u6b62\u64cd\u4f5c\u6210\u529f\u3002", (String)"BillTplPlugin_4", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    msg = String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u201c%1$s\u201d\uff0c\u201c%2$s\u201d\u6210\u529f\u3002", (String)"DeliverNoticeRowUnClosePlugin_9", (String)"scmc-sm-formplugin", (Object[])new Object[0]), this.getModel().getValue("billno"), RowOPHelper.getOpName((String)entityName, (String)itemKey));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u5206\u5f55\u884c\u4e2d\u6ca1\u6709\u53ef\u53cd\u7ec8\u6b62\u7684\u884c\u3002", (String)"BillTplPlugin_5", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    msg = String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u201c%1$s\u201d\uff0c\u201c%2$s\u201d\u5931\u8d25\u3002", (String)"DeliverNoticeRowUnClosePlugin_8", (String)"scmc-sm-formplugin", (Object[])new Object[0]), this.getModel().getValue("billno"), RowOPHelper.getOpName((String)entityName, (String)itemKey));
                }
                DynamicObject org1 = (DynamicObject)this.getModel().getValue("org");
                OperationResult operationResult = RowOPHelper.createOperationResult();
                RowOPHelper.writeLog((OperationResult)operationResult, (DynamicObject)org1, (String)itemKey, (String)msg, (String)entityName);
                break;
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        if (SMEntityConst.getSMEntityList().contains(this.getView().getEntityId()) && "billentry".equals(e.getEntryProp().getName())) {
            this.calcTotalAmount();
        }
    }

    public void beforeItemClick(BeforeItemClickEvent e) {
        boolean checkPermission;
        EntryGrid entryGrid = (EntryGrid)this.getControl("billentry");
        int[] selectRows = null;
        if (entryGrid != null) {
            selectRows = entryGrid.getSelectRows();
        }
        String itemKey = e.getItemKey();
        DynamicObject value = (DynamicObject)this.getModel().getValue("org");
        String formId = this.getView().getEntityId();
        String appId = this.getModel().getDataEntityType().getAppId();
        if (("rowterminate".equals(itemKey) || "rowunterminate".equals(itemKey) || "rowclose".equals(itemKey) || "rowunclose".equals(itemKey)) && !(checkPermission = BillTplHelper.checkPermission((String)itemKey, (DynamicObject)value, (String)appId, (String)formId))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u64cd\u4f5c\u6743\u9650\u3002", (String)"BillTplPlugin_9", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        switch (itemKey) {
            case "rowterminate": 
            case "rowunterminate": {
                Long pk = (Long)this.getModel().getValue("id");
                HashSet<Long> pkSet = new HashSet<Long>();
                pkSet.add(pk);
                DynamicObject[] deliverBills = RowOPHelper.getBills(pkSet, (String)this.getView().getEntityId());
                if (deliverBills.length == 0) {
                    String tips = ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664\u3002", (String)"DeliverNoticeRowClosePlugin_9", (String)"scmc-sm-formplugin", (Object[])new Object[0]);
                    this.getView().showErrorNotification(tips);
                    e.setCancel(true);
                    return;
                }
                if (this.checkRowOperation(selectRows)) break;
                e.setCancel(true);
                return;
            }
            case "bar_save": {
                DynamicObject billtype = (DynamicObject)this.getModel().getValue("billtype");
                if (billtype == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u7c7b\u578b\u3002", (String)"BillTplPlugin_17", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                if (value != null) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u9500\u552e\u7ec4\u7ec7\u3002", (String)"BillTplPlugin_19", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
        }
    }

    private void queryTaxrate() {
        Date bizTime = (Date)this.getModel().getValue("bizdate");
        QFilter q1 = new QFilter("activedate", "<=", (Object)bizTime);
        QFilter q2 = new QFilter("expdate", ">", (Object)bizTime);
        QFilter q3 = q2.or(QFilter.isNull((String)"expdate"));
        q1.and(q3).and(new QFilter("enable", "=", (Object)"1"));
        Map bdTaxrate = BusinessDataServiceHelper.loadFromCache((String)"bd_taxrate", (String)"id", (QFilter[])new QFilter[]{q1});
        if (bdTaxrate != null) {
            ArrayList<String> taxratelist = new ArrayList<String>(bdTaxrate.size());
            for (Map.Entry next : bdTaxrate.entrySet()) {
                Object pkValue = ((DynamicObject)next.getValue()).getPkValue();
                taxratelist.add(pkValue.toString());
            }
            if (taxratelist.size() > 0) {
                this.getPageCache().put(TAXRATE_FILTER, SerializationUtils.toJsonString((Object)String.join((CharSequence)"_", taxratelist)));
            }
        }
    }

    private List<Long> getLoactionIds(DynamicObjectCollection locationCol) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (CommonUtils.isNull((Object)locationCol) || locationCol.isEmpty()) {
            return ids;
        }
        for (DynamicObject locDym : locationCol) {
            DynamicObject location = locDym.getDynamicObject("location");
            if (location == null) continue;
            ids.add(Long.valueOf(location.getPkValue().toString()));
        }
        return ids;
    }

    private void initNewDataEntry(int rowIndex) {
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        model.setValue("salesorg", (Object)org, rowIndex);
        DynamicObject bizType = (DynamicObject)model.getValue("biztype");
        PropertyChangeHelper.stopPropertyChange((IPageCache)this.getPageCache());
        this.getModel().setValue("linetype", (Object)this.getDefLineTypeFromPageCache(bizType), rowIndex);
        DynamicObject lineType = (DynamicObject)this.getModel().getValue("linetype", rowIndex);
        if (lineType != null) {
            Boolean storageout = lineType.getBoolean("storageout");
            if (!storageout.booleanValue()) {
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"supplytrans"});
                this.getModel().setValue("supplytrans", (Object)Boolean.FALSE, rowIndex);
            } else {
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"supplytrans"});
            }
        }
        PropertyChangeHelper.releasePropertyChange((IPageCache)this.getPageCache());
    }

    private boolean checkRowOperation(int[] selectRows) {
        boolean check = true;
        if (selectRows == null || selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u5f55\u884c\u3002", (String)"BillTplPlugin_6", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
            check = false;
        }
        String billStatus = (String)this.getModel().getValue("billstatus");
        String closeStatus = (String)this.getModel().getValue("closestatus");
        if (check && !StatusEnum.AUDIT.getValue().equals(billStatus)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u4e3a\u201c\u5df2\u5ba1\u6838\u201d\u624d\u80fd\u64cd\u4f5c\u3002", (String)"BillTplPlugin_7", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
            check = false;
        }
        if (check && !CloseStatusEnum.UNCLOSED.getValue().equals(closeStatus)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5173\u95ed\u72b6\u6001\u4e3a\u201c\u6b63\u5e38\u201d\u624d\u80fd\u64cd\u4f5c\u3002", (String)"BillTplPlugin_8", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
            check = false;
        }
        return check;
    }

    private void initCurrencyDefaultValue() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            DynamicObject exRateTable;
            Map map = CurrencyHelper.getCurrencyAndExRateTable((Long)((Long)org.getPkValue()));
            if (map == null) {
                return;
            }
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            if (currency == null) {
                this.getModel().setValue("currency", map.get("baseCurrencyID"));
            }
            if ((exRateTable = (DynamicObject)this.getModel().getValue("exratetable")) == null) {
                this.getModel().setValue("exratetable", map.get("exchangeRateTableID"));
            }
        }
    }

    private void doRefreshHeadAmount() {
        this.getView().updateView("totalallamount");
        this.getView().updateView("totaltaxamount");
        this.getView().updateView("totalamount");
        this.getView().updateView("curtotalallamount");
        this.getView().updateView("curtotaltaxamount");
        this.getView().updateView("curtotalamount");
    }

    private void doRefresh(ChangeData[] valueSet, String propName) {
        boolean batchRefresh = false;
        if (valueSet == null) {
            this.getView().updateView("billentry");
        } else {
            if (valueSet.length > BigDecimal.TEN.intValue()) {
                batchRefresh = true;
            }
            if (batchRefresh) {
                this.getView().updateView("billentry");
            } else {
                String[] propNames = BillTplHelper.getEntryRefreshFields((String)propName);
                if (propNames == null) {
                    return;
                }
                for (int i = 0; i < valueSet.length; ++i) {
                    for (String prop : propNames) {
                        this.getView().updateView(prop, valueSet[i].getRowIndex());
                    }
                }
            }
        }
    }

    private void changePrice(Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        boolean isPresent = (Boolean)model.getValue("ispresent", rowIndex);
        if (isPresent) {
            PropertyChangeHelper.stopPropertyChange((IPageCache)this.getPageCache());
            if (BigDecimalUtil.isZero((BigDecimal)((BigDecimal)newValue))) {
                model.setValue("discountrate", (Object)BigDecimal.ZERO, rowIndex);
                model.setValue("discounttype", (Object)DiscountTypeEnum.NULL.getValue(), rowIndex);
            } else {
                model.setValue("discountrate", (Object)BigDecimalUtil.HUNDRED, rowIndex);
                model.setValue("discounttype", (Object)DiscountTypeEnum.DISRATE.getValue(), rowIndex);
            }
            PropertyChangeHelper.releasePropertyChange((IPageCache)this.getPageCache());
        }
    }

    private boolean changeIsPresent(Object newValue, int rowIndex) {
        if (newValue == null) {
            return false;
        }
        boolean isPresent = (Boolean)newValue;
        IDataModel model = this.getModel();
        PropertyChangeHelper.stopPropertyChange((IPageCache)this.getPageCache());
        if (isPresent) {
            BigDecimal price = (BigDecimal)model.getValue("price", rowIndex);
            if (BigDecimalUtil.isZero((BigDecimal)price)) {
                model.setValue("discountrate", (Object)BigDecimal.ZERO, rowIndex);
                model.setValue("discounttype", (Object)DiscountTypeEnum.NULL.getValue(), rowIndex);
            } else {
                model.setValue("discountrate", (Object)BigDecimalUtil.HUNDRED, rowIndex);
                model.setValue("discounttype", (Object)DiscountTypeEnum.DISRATE.getValue(), rowIndex);
            }
            return true;
        }
        model.setValue("discountrate", (Object)BigDecimal.ZERO, rowIndex);
        model.setValue("discounttype", (Object)DiscountTypeEnum.NULL.getValue(), rowIndex);
        PropertyChangeHelper.releasePropertyChange((IPageCache)this.getPageCache());
        return false;
    }

    private boolean changeDiscountInfo(ChangeData changeData, int rowIndex, String propName) {
        String discountType = (String)this.getModel().getValue("discounttype", rowIndex);
        if (DiscountTypeEnum.NULL.getValue().equals(discountType)) {
            PropertyChangeHelper.stopPropertyChange((IPageCache)this.getPageCache());
            this.getModel().setValue("discountrate", (Object)BigDecimal.ZERO, rowIndex);
            PropertyChangeHelper.releasePropertyChange((IPageCache)this.getPageCache());
            return true;
        }
        if (DiscountTypeEnum.DISRATE.getValue().equals(discountType)) {
            BigDecimal discountRate = (BigDecimal)this.getModel().getValue("discountrate", rowIndex);
            if (discountRate != null && discountRate.compareTo(Constants.ONE_HUNDRED) > 0) {
                this.revertEntryValue(changeData, rowIndex, propName);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u201c\u6298\u6263\u7387(%)\u201d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u8303\u56f4\u4e3a\uff1a0\u2264\u5355\u4f4d\u6298\u6263(\u7387)\u2264100\u3002", (String)"BillTplPlugin_11", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                return false;
            }
            return true;
        }
        if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType) || DiscountTypeEnum.FIXEDDIS.getValue().equals(discountType)) {
            BigDecimal discountAmount = (BigDecimal)this.getModel().getValue("discountrate", rowIndex);
            boolean isTax = (Boolean)this.getModel().getValue("istax");
            if (isTax) {
                BigDecimal priceAndTax = (BigDecimal)this.getModel().getValue("priceandtax", rowIndex);
                if (discountAmount.compareTo(priceAndTax) > 0) {
                    this.revertEntryValue(changeData, rowIndex, propName);
                    if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u201c\u5355\u4f4d\u6298\u6263\u989d\u201d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e\u542b\u7a0e\u5355\u4ef7\u3002", (String)"BillTplPlugin_12", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    } else {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u201c\u6298\u6263\u989d\u201d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e\u542b\u7a0e\u5355\u4ef7\u3002", (String)"BillTplPlugin_34", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    }
                    return false;
                }
                return true;
            }
            BigDecimal price = (BigDecimal)this.getModel().getValue("price", rowIndex);
            if (discountAmount.compareTo(price) > 0) {
                this.revertEntryValue(changeData, rowIndex, propName);
                if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u201c\u5355\u4f4d\u6298\u6263\u989d\u201d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e\u5355\u4ef7\u3002", (String)"BillTplPlugin_13", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u201c\u6298\u6263\u989d\u201d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e\u5355\u4ef7\u3002", (String)"BillTplPlugin_35", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean changeDiscountAmountInfo(ChangeData changeData, int rowIndex, String propName) {
        String discountType = (String)this.getModel().getValue("discounttype", rowIndex);
        if (DiscountTypeEnum.FIXEDDIS.getValue().equals(discountType)) {
            BigDecimal qty = (BigDecimal)this.getModel().getValue("qty", rowIndex);
            DynamicObject settleCurrency = (DynamicObject)this.getModel().getValue("settlecurrency");
            int settleAmtPrecision = settleCurrency == null ? 10 : settleCurrency.getInt(CUR_AMTPRECISION);
            BigDecimal discountAmount = (BigDecimal)this.getModel().getValue("discountamount", rowIndex);
            discountAmount = discountAmount.setScale(settleAmtPrecision, 4);
            BigDecimal amountAndTax = BigDecimal.ZERO;
            boolean isTax = (Boolean)this.getModel().getValue("istax");
            if (isTax) {
                BigDecimal priceAndTax = (BigDecimal)this.getModel().getValue("priceandtax", rowIndex);
                if (qty != null && priceAndTax != null) {
                    amountAndTax = qty.multiply(priceAndTax).setScale(settleAmtPrecision, 4);
                }
            } else {
                BigDecimal price = (BigDecimal)this.getModel().getValue("price", rowIndex);
                if (qty != null && price != null) {
                    BigDecimal taxRate = (BigDecimal)this.getModel().getValue("taxrate", rowIndex);
                    if (taxRate == null) {
                        taxRate = BigDecimal.ZERO;
                    }
                    amountAndTax = qty.multiply(price).multiply(BigDecimal.ONE.add(taxRate.divide(new BigDecimal("100")))).setScale(settleAmtPrecision, 4);
                }
            }
            if (discountAmount.compareTo(amountAndTax) > 0) {
                this.revertEntryValue(changeData, rowIndex, propName);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u201c\u6298\u6263\u989d\u201d\u65f6\uff0c\u6298\u6263\u989d\u4e0d\u80fd\u5927\u4e8e\u201c\u6570\u91cf\u201d\u4e58\u4ee5\u201c\u542b\u7a0e\u5355\u4ef7\u201d\u3002", (String)"BillTplPlugin_30", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean changeTaxRateID(DynamicObject taxRateID, int rowIndex) {
        IDataModel model = this.getModel();
        if (taxRateID != null) {
            model.setValue("taxrate", taxRateID.get("taxrate"), rowIndex);
        } else {
            model.setValue("taxrate", (Object)0, rowIndex);
        }
        return true;
    }

    private void changeBillType(DynamicObject billType) {
        if (billType == null) {
            this.getModel().setValue("biztype", null);
        } else {
            BillEntityType entityType = (BillEntityType)this.getModel().getDataEntityType();
            if (entityType == null) {
                LOG.warn("BillEntityType is null.");
                return;
            }
            String formid = this.getView().getEntityId();
            Long biztype = BizTypeHelper.getDefaultBizType((String)formid, (Long)((Long)billType.getPkValue()), (String)"sm_billtypeparam");
            this.getModel().setValue("biztype", (Object)biztype);
        }
    }

    private void changeMaterial(DynamicObject material, DynamicObject oldMaterial, int rowIndex) {
        boolean isInventory = false;
        if (this.getPageCache().get(INVENTORY_QUERY) != null) {
            isInventory = true;
        }
        boolean isCleanPriceField = true;
        try {
            PluginProxy pluginProxy = PluginProxy.create(null, ICleanFieldsCasePlugin.class, (String)"SCMC_SM_BILL_ISCLEANPRICEFIELD", null);
            List isCleanSet = pluginProxy.callReplace(p -> p.isCleanPriceField(material, oldMaterial, this.getModel().getDataEntityType().getName(), new HashMap()));
            if (isCleanSet != null && isCleanSet.size() > 0) {
                DynamicObject masterMaterial;
                for (Boolean b : isCleanSet) {
                    isCleanPriceField = isCleanPriceField && b != false;
                }
                String materialName = "";
                if (material != null && (masterMaterial = material.getDynamicObject("masterid")) != null) {
                    materialName = masterMaterial.getString("name");
                }
                LOG.info(materialName + " isCleanPriceField = " + isCleanPriceField);
            }
        }
        catch (Exception e) {
            String msg = ResManager.loadKDString((String)"\u5ba2\u6237\u5316\u573a\u666f[%1$s]\u63d2\u4ef6\u6267\u884c\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u5ba2\u6237\u5316\u63d2\u4ef6\u3002", (String)"BillTplHelper_0", (String)"scmc-sm-business", (Object[])new Object[0]);
            msg = String.format(msg, "SCMC_SM_BILL_ISCLEANPRICEFIELD");
            String msgTotal = msg + e.getMessage();
            LOG.info(msgTotal);
            throw new KDBizException(msgTotal);
        }
        PropertyChangeHelper.stopPropertyChange((IPageCache)this.getPageCache());
        this.getModel().setValue("materialname", null, rowIndex);
        this.getModel().setValue("materialmasterid", null, rowIndex);
        this.getModel().setValue("materialversion", null, rowIndex);
        this.getModel().setValue("unit", null, rowIndex);
        this.getModel().setValue("baseunit", null, rowIndex);
        this.getModel().setValue("auxunit", null, rowIndex);
        this.getModel().setValue("ispresent", null, rowIndex);
        this.getModel().setValue("productline", null, rowIndex);
        this.getModel().setValue("taxamount", null, rowIndex);
        this.getModel().setValue("amount", null, rowIndex);
        this.getModel().setValue("amountandtax", null, rowIndex);
        this.getModel().setValue("curtaxamount", null, rowIndex);
        this.getModel().setValue("curamount", null, rowIndex);
        this.getModel().setValue("curamountandtax", null, rowIndex);
        this.getModel().setValue("qty", null, rowIndex);
        this.getModel().setValue("baseqty", null, rowIndex);
        this.getModel().setValue("auxqty", null, rowIndex);
        if (!isInventory && isCleanPriceField) {
            this.getModel().setValue("price", null, rowIndex);
            this.getModel().setValue("priceandtax", null, rowIndex);
            this.getModel().setValue("taxrateid", null, rowIndex);
            this.getModel().setValue("taxrate", null, rowIndex);
            this.getModel().setValue("discounttype", (Object)DiscountTypeEnum.NULL, rowIndex);
            this.getModel().setValue("discountrate", null, rowIndex);
        }
        this.getModel().setValue("discountamount", null, rowIndex);
        this.getModel().setValue("lotnumber", null, rowIndex);
        this.getModel().setValue("lot", null, rowIndex);
        this.getModel().setValue("configuredcode", null, rowIndex);
        RowDataEntity rowDataEntity = new RowDataEntity(rowIndex, this.getModel().getEntryRowEntity("billentry", rowIndex));
        LotCacheHelper.setLotEnable(Collections.singletonList(rowDataEntity), (IFormView)this.getView(), (IPageCache)this.getPageCache());
        if (material != null) {
            int curRow;
            DynamicObject masterMaterial = material.getDynamicObject("masterid");
            if (masterMaterial != null) {
                this.getModel().setValue("materialmasterid", masterMaterial.getPkValue(), rowIndex);
                this.getModel().setValue("materialname", (Object)masterMaterial.getString("name"), rowIndex);
                if (masterMaterial.getDynamicObject("taxrate") != null && this.getModel().getValue("taxrateid", rowIndex) == null) {
                    this.getModel().setValue("taxrateid", masterMaterial.getDynamicObject("taxrate").getPkValue(), rowIndex);
                    DynamicObject taxrate = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_taxrate", (String)"taxrate", (QFilter[])new QFilter[]{new QFilter("id", "=", masterMaterial.getDynamicObject("taxrate").getPkValue())});
                    this.getModel().setValue("taxrate", (Object)taxrate.getBigDecimal("taxrate"), rowIndex);
                } else {
                    DynamicObject customer = (DynamicObject)this.getModel().getValue("customer");
                    if (customer != null && customer.getDynamicObject("taxrate") != null && this.getModel().getValue("taxrateid", rowIndex) == null) {
                        this.getModel().setValue("taxrateid", customer.getDynamicObject("taxrate").getPkValue(), rowIndex);
                        DynamicObject customerTaxrate = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_taxrate", (String)"taxrate", (QFilter[])new QFilter[]{new QFilter("id", "=", customer.getDynamicObject("taxrate").getPkValue())});
                        this.getModel().setValue("taxrate", (Object)customerTaxrate.getBigDecimal("taxrate"), rowIndex);
                    }
                }
                if (masterMaterial.getDynamicObject("baseunit") != null) {
                    this.getModel().setValue("baseunit", masterMaterial.getDynamicObject("baseunit").getPkValue(), rowIndex);
                }
                if (material.getDynamicObject("salesunit") != null) {
                    this.getModel().setValue("unit", material.getDynamicObject("salesunit").getPkValue(), rowIndex);
                }
                if (masterMaterial.getDynamicObject("auxptyunit") != null) {
                    this.getModel().setValue("auxunit", masterMaterial.getDynamicObject("auxptyunit").getPkValue(), rowIndex);
                }
                if (masterMaterial.getDynamicObject("productline") != null) {
                    this.getModel().setValue("productline", masterMaterial.getDynamicObject("productline").getPkValue(), rowIndex);
                }
            }
            if ((curRow = this.getModel().getEntryCurrentRowIndex("billentry")) != rowIndex) {
                this.getModel().setValue("linetype", this.getModel().getValue("linetype", curRow), rowIndex);
            }
        }
        PropertyChangeHelper.releasePropertyChange((IPageCache)this.getPageCache());
        this.calcTotalAmount();
    }

    private void revertEntryValue(ChangeData changeData, int rowIndex, String propName) {
        PropertyChangeHelper.stopPropertyChange((IPageCache)this.getPageCache());
        this.getModel().setValue(propName, changeData.getOldValue(), rowIndex);
        PropertyChangeHelper.releasePropertyChange((IPageCache)this.getPageCache());
    }

    private boolean checkOrgIsNull(BeforeF7SelectEvent e) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"BillTplPlugin_16", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            PluginConnectControllHelper.stopListener((IPageCache)this.getPageCache(), (String)"beforeF7Select");
            return true;
        }
        return false;
    }

    private boolean isBackCalculate() {
        Boolean inputamount = Boolean.FALSE;
        if (this.getControl("inputamount") != null) {
            inputamount = (Boolean)this.getModel().getValue("inputamount");
        }
        return inputamount;
    }

    private Long getDefLineTypeFromPageCache(DynamicObject biztype) {
        if (biztype == null || Objects.equals(0L, biztype.getPkValue())) {
            return null;
        }
        String lineTypeIDCache = this.getPageCache().get(CACHE_KEY_DEF_LINETYPEID);
        if (kd.bos.util.StringUtils.isNotEmpty((String)lineTypeIDCache)) {
            return Long.valueOf(lineTypeIDCache);
        }
        Long lineTypeID = BizTypeHelper.getDefaultLineType((Long)((Long)biztype.getPkValue()));
        if (lineTypeID != null && !Objects.equals(0L, lineTypeID)) {
            this.getPageCache().put(CACHE_KEY_DEF_LINETYPEID, String.valueOf(lineTypeID));
            return lineTypeID;
        }
        return null;
    }

    private void xChangeType(ChangeData changeData) {
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        if (ChangeTypeEnum.UPDATE.getValue().equals(oldValue) && ChangeTypeEnum.CANCEL.getValue().equals(newValue)) {
            AmountCalcHelper.resetAmount((IDataModel)this.getModel(), (int[])new int[]{changeData.getRowIndex()}, (BigDecimal)BigDecimal.ONE);
        } else if (ChangeTypeEnum.CANCEL.getValue().equals(oldValue) && ChangeTypeEnum.UPDATE.getValue().equals(newValue)) {
            AmountCalcHelper.resetAmount((IDataModel)this.getModel(), (int[])new int[]{changeData.getRowIndex()}, (BigDecimal)BigDecimal.ONE.negate());
        }
    }

    public void calculateAmount(int[] rowIndexs) {
        this.calculateAmount(rowIndexs, Boolean.FALSE);
    }

    public void calculateAmount(int[] rowIndexs, Boolean isCalDiscountRate) {
        IDataModel model = this.getModel();
        DynamicObjectCollection entryInfos = model.getEntryEntity("billentry");
        for (int rowIndex : rowIndexs) {
            boolean isTax = (Boolean)model.getValue("istax");
            DynamicObject currency = (DynamicObject)model.getValue("currency");
            int currencyAmtPrecision = currency == null ? 10 : currency.getInt(CUR_AMTPRECISION);
            DynamicObject settleCurrency = (DynamicObject)model.getValue("settlecurrency");
            int settleAmtPrecision = settleCurrency == null ? 10 : settleCurrency.getInt(CUR_AMTPRECISION);
            BigDecimal exChangeRate = (BigDecimal)model.getValue("exchangerate");
            String exchangeType = (String)model.getValue("exchangetype");
            BigDecimal qty = (BigDecimal)model.getValue("qty", rowIndex);
            BigDecimal price = (BigDecimal)model.getValue("price", rowIndex);
            BigDecimal priceAndTax = (BigDecimal)model.getValue("priceandtax", rowIndex);
            BigDecimal taxRate = (BigDecimal)model.getValue("taxrate", rowIndex);
            String discountType = (String)model.getValue("discounttype", rowIndex);
            BigDecimal discountRate = (BigDecimal)model.getValue("discountrate", rowIndex);
            BigDecimal discountAmount = (BigDecimal)model.getValue("discountamount", rowIndex);
            AmountInfo amountInfo = new AmountInfo(this.getModel().getDataEntityType().getName(), (DynamicObject)entryInfos.get(rowIndex));
            amountInfo.setTax(isTax);
            amountInfo.setQty(qty);
            amountInfo.setPrice(price);
            amountInfo.setPriceAndTax(priceAndTax);
            amountInfo.setTaxRate(taxRate);
            amountInfo.setDiscountType(discountType);
            amountInfo.setDiscountRate(discountRate);
            amountInfo.setDiscountAmount(discountAmount);
            amountInfo.setExChangeRate(exChangeRate);
            amountInfo.setExchangeType(exchangeType);
            amountInfo.setSettleAmtPrecision(settleAmtPrecision);
            amountInfo.setCurrencyAmtPrecision(currencyAmtPrecision);
            amountInfo = BillTplHelper.getAmount((AmountInfo)amountInfo, (Boolean)isCalDiscountRate);
            PropertyChangeHelper.stopPropertyChange((IPageCache)this.getPageCache());
            if (isTax) {
                model.setValue("price", (Object)amountInfo.getPrice(), rowIndex);
            } else {
                model.setValue("priceandtax", (Object)amountInfo.getPriceAndTax(), rowIndex);
            }
            BigDecimal amount = amountInfo.getAmount();
            BigDecimal taxAmount = amountInfo.getTaxAmount();
            BigDecimal amountAndTax = amountInfo.getAmountAndTax();
            model.setValue("discountrate", (Object)amountInfo.getDiscountRate(), rowIndex);
            model.setValue("discountamount", (Object)amountInfo.getDiscountAmount(), rowIndex);
            model.setValue("curamount", (Object)amountInfo.getCurAmount(), rowIndex);
            model.setValue("curtaxamount", (Object)amountInfo.getCurTaxAmount(), rowIndex);
            model.setValue("curamountandtax", (Object)amountInfo.getCurAmountAndTax(), rowIndex);
            PropertyChangeHelper.releasePropertyChange((IPageCache)this.getPageCache());
            model.setValue("amount", (Object)amount, rowIndex);
            model.setValue("taxamount", (Object)taxAmount, rowIndex);
            model.setValue("amountandtax", (Object)amountAndTax, rowIndex);
        }
        this.calcTotalAmount();
    }

    private void calcTotalAmount() {
        IDataModel model = this.getModel();
        for (Map.Entry entry : AmountCalcHelper.calcTotalAmount((DynamicObject)model.getDataEntity(true)).entrySet()) {
            model.setValue((String)entry.getKey(), entry.getValue());
        }
    }

    private void calculateAmount4WholeBill() {
        IDataModel model = this.getModel();
        DynamicObjectCollection entrys = model.getEntryEntity("billentry");
        if (entrys == null || entrys.size() == 0) {
            return;
        }
        BigDecimal totaltaxamount = BigDecimal.ZERO;
        BigDecimal totalamount = BigDecimal.ZERO;
        BigDecimal curtotalamount = BigDecimal.ZERO;
        BigDecimal totalallamount = BigDecimal.ZERO;
        BigDecimal curtotalallamount = BigDecimal.ZERO;
        for (int i = 0; i < entrys.size(); ++i) {
            boolean isTax = (Boolean)model.getValue("istax");
            DynamicObject currency = (DynamicObject)model.getValue("currency");
            int currencyAmtPrecision = currency == null ? 10 : currency.getInt(CUR_AMTPRECISION);
            DynamicObject settleCurrency = (DynamicObject)model.getValue("settlecurrency");
            int settleAmtPrecision = settleCurrency == null ? 10 : settleCurrency.getInt(CUR_AMTPRECISION);
            BigDecimal exChangeRate = (BigDecimal)model.getValue("exchangerate");
            BigDecimal qty = (BigDecimal)model.getValue("qty", i);
            BigDecimal price = (BigDecimal)model.getValue("price", i);
            BigDecimal priceAndTax = (BigDecimal)model.getValue("priceandtax", i);
            BigDecimal taxRate = (BigDecimal)model.getValue("taxrate", i);
            String discountType = (String)model.getValue("discounttype", i);
            BigDecimal discountRate = (BigDecimal)model.getValue("discountrate", i);
            BigDecimal discountAmount = (BigDecimal)model.getValue("discountamount", i);
            String exchangeType = (String)model.getValue("exchangetype");
            AmountInfo amountInfo = new AmountInfo(this.getModel().getDataEntityType().getName(), (DynamicObject)entrys.get(i));
            amountInfo.setTax(isTax);
            amountInfo.setQty(qty);
            amountInfo.setPrice(price);
            amountInfo.setPriceAndTax(priceAndTax);
            amountInfo.setTaxRate(taxRate);
            amountInfo.setDiscountType(discountType);
            amountInfo.setDiscountRate(discountRate);
            amountInfo.setDiscountAmount(discountAmount);
            amountInfo.setExChangeRate(exChangeRate);
            amountInfo.setSettleAmtPrecision(settleAmtPrecision);
            amountInfo.setCurrencyAmtPrecision(currencyAmtPrecision);
            amountInfo.setExchangeType(exchangeType);
            amountInfo = BillTplHelper.getAmount((AmountInfo)amountInfo);
            PropertyChangeHelper.stopPropertyChange((IPageCache)this.getPageCache());
            if (isTax) {
                model.setValue("price", (Object)amountInfo.getPrice(), i);
            } else {
                model.setValue("priceandtax", (Object)amountInfo.getPriceAndTax(), i);
            }
            BigDecimal amount = amountInfo.getAmount();
            BigDecimal taxAmount = amountInfo.getTaxAmount();
            BigDecimal amountAndTax = amountInfo.getAmountAndTax();
            BigDecimal curAmount = amountInfo.getCurAmount();
            BigDecimal curAmountAndTax = amountInfo.getCurAmountAndTax();
            model.setValue("discountrate", (Object)amountInfo.getDiscountRate(), i);
            model.setValue("discountamount", (Object)amountInfo.getDiscountAmount(), i);
            model.setValue("curamount", (Object)curAmount, i);
            model.setValue("curtaxamount", (Object)amountInfo.getCurTaxAmount(), i);
            model.setValue("curamountandtax", (Object)curAmountAndTax, i);
            PropertyChangeHelper.releasePropertyChange((IPageCache)this.getPageCache());
            model.setValue("amount", (Object)amount, i);
            model.setValue("taxamount", (Object)taxAmount, i);
            model.setValue("amountandtax", (Object)amountAndTax, i);
            totaltaxamount = totaltaxamount.add(taxAmount);
            totalamount = totalamount.add(amount);
            curtotalamount = curtotalamount.add(curAmount);
            totalallamount = totalallamount.add(amountAndTax);
            curtotalallamount = curtotalallamount.add(curAmountAndTax);
        }
        model.setValue("totalamount", (Object)totalamount);
        model.setValue("totaltaxamount", (Object)totaltaxamount);
        model.setValue("totalallamount", (Object)totalallamount);
        model.setValue("curtotalamount", (Object)curtotalamount);
        model.setValue("curtotalallamount", (Object)curtotalallamount);
    }

    private boolean checkDiscount(Boolean isTax) {
        Boolean checkResult = Boolean.TRUE;
        if (!isTax.booleanValue()) {
            DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("billentry");
            ArrayList<String> errorMsgList = new ArrayList<String>(8);
            for (DynamicObject entry : entrys) {
                BigDecimal price;
                BigDecimal dicountRate;
                String discountType = entry.getString("discounttype");
                if (!DiscountTypeEnum.UNITDIS.getValue().equals(discountType) && !DiscountTypeEnum.FIXEDDIS.getValue().equals(discountType) || (dicountRate = entry.getBigDecimal("discountrate")).compareTo(price = entry.getBigDecimal("price")) <= 0) continue;
                checkResult = Boolean.FALSE;
                errorMsgList.add(entry.getString("seq"));
            }
            if (!checkResult.booleanValue() && errorMsgList.size() > 0) {
                String errorRows = errorMsgList.stream().map(String::valueOf).collect(Collectors.joining("\u3001"));
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c\u542b\u7a0e\u201d\u5207\u6362\u4e3a\u201c\u5426\u201d\u65f6\uff0c\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\u201c\u5355\u4f4d\u6298\u6263(\u7387)\u201d\u4e0d\u80fd\u5927\u4e8e\u201c\u5355\u4ef7\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BillTplPlugin_28", (String)"scmc-sm-formplugin", (Object[])new Object[0]), errorRows));
            }
        }
        return checkResult;
    }

    private void changeBillTypeWithBizType(DynamicObject billType) {
        if (billType != null) {
            BillEntityType entityType = (BillEntityType)this.getModel().getDataEntityType();
            if (entityType == null) {
                LOG.warn("BillEntityType is null.");
                return;
            }
            String formid = this.getView().getEntityId();
            Long biztype = BizTypeHelper.getDefaultBizType((String)formid, (Long)((Long)billType.getPkValue()), (String)"sm_billtypeparam");
            this.getModel().beginInit();
            this.getModel().setValue("biztype", (Object)biztype);
            this.getModel().endInit();
            this.getView().updateView("biztype");
            this.getModel().deleteEntryData("billentry");
            if ("sm_salorder".equals(this.getView().getEntityId())) {
                this.getModel().deleteEntryData("recplanentry");
            }
            this.getModel().createNewEntryRow("billentry");
            this.initNewDataEntry(0);
            BillTplHelper.calculateAmount4WholeBill((DynamicObject)this.getModel().getDataEntity(), (IDataModel)this.getModel());
            this.doRefreshHeadAmount();
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("lotnumber".equals(key)) {
            if (LotHelper.isUseLotMainFile()) {
                BasedataEdit lotf7 = (BasedataEdit)this.getControl("lot");
                lotf7.click();
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u542f\u7528\u6279\u53f7\u4e3b\u6863\u3002", (String)"BillTplPlugin_27", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void changeQty(int rowIndex) {
        if (this.getPageCache().get(INVENTORY_QUERY) != null) {
            this.getModel().setValue("taxamount", null, rowIndex);
            this.getModel().setValue("amount", null, rowIndex);
            this.getModel().setValue("amountandtax", null, rowIndex);
            this.getModel().setValue("curtaxamount", null, rowIndex);
            this.getModel().setValue("curamount", null, rowIndex);
            this.getModel().setValue("curamountandtax", null, rowIndex);
        }
    }

    private Integer getParentIndex(int childRowIndex) {
        int rowCount = this.getModel().getEntryRowCount("billentry");
        Long parentPid = (Long)this.getModel().getValue("kitpid", childRowIndex);
        for (int i = 0; i < rowCount; ++i) {
            Long pID = (Long)this.getModel().getValue("kitpid", i);
            String productType = (String)this.getModel().getValue("producttype", i);
            if (!ProductTypeEnum.KITPARENT.getValue().equals(productType) || parentPid.longValue() != pID.longValue()) continue;
            return i;
        }
        return null;
    }

    private List<Integer> getAllChildIndex(int parentRowIndex) {
        DynamicObject parentEntry = this.getModel().getEntryRowEntity("billentry", parentRowIndex);
        Long parentPid = parentEntry.getLong("kitpid");
        ArrayList<Integer> childEntryList = new ArrayList<Integer>();
        int rowCount = this.getModel().getEntryRowCount("billentry");
        for (int i = 0; i < rowCount; ++i) {
            Long pID = (Long)this.getModel().getValue("kitpid", i);
            String productType = (String)this.getModel().getValue("producttype", i);
            if (!ProductTypeEnum.KITCHILD.getValue().equals(productType) || parentPid.longValue() != pID.longValue()) continue;
            childEntryList.add(i);
        }
        return childEntryList;
    }

    private void setDiscountRateScale(Object newValue) {
        int priceRecision = 4;
        if (newValue instanceof DynamicObject) {
            DynamicObject settleCurrency = (DynamicObject)newValue;
            priceRecision = settleCurrency.getInt("priceprecision");
        }
        ClientViewProxy clientViewProxy = (ClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod("billentry", "setColEditorProp", new Object[]{"discountrate", "sc", priceRecision});
    }
}

