/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.formplugin.tpl;

import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bd.sbd.utils.StringUtils;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.sm.business.helper.BillImportHelper;
import kd.scmc.sm.business.helper.CustomerHelper;
import kd.scmc.sm.business.helper.MetaDataHelper;
import kd.scmc.sm.util.CommonUtils;

public class CustomerPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public static final String LINKADDRESSF7 = "linkaddressf7";
    public static final String DELIVERADDRESSF7 = "deliveraddressf7";

    public void registerListener(EventObject e) {
        BasedataEdit linkaddressf7;
        BasedataEdit linkMan;
        super.registerListener(e);
        BasedataEdit reclinkmanEdit = (BasedataEdit)this.getView().getControl("reclinkman");
        if (reclinkmanEdit != null) {
            reclinkmanEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        BasedataEdit recCustomer = (BasedataEdit)this.getView().getControl("reccustomer");
        BasedataEdit customer = (BasedataEdit)this.getView().getControl("customer");
        BasedataEdit settleCustmer = (BasedataEdit)this.getView().getControl("settlecustomer");
        BasedataEdit payCustomer = (BasedataEdit)this.getView().getControl("payingcustomer");
        if (recCustomer != null) {
            recCustomer.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (settleCustmer != null) {
            settleCustmer.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (payCustomer != null) {
            payCustomer.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (customer != null) {
            customer.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((linkMan = (BasedataEdit)this.getControl("linkman")) != null) {
            linkMan.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        this.addClickListeners(new String[]{"receiveaddress"});
        this.addClickListeners(new String[]{"address"});
        BasedataEdit deliveraddressf7 = (BasedataEdit)this.getControl(DELIVERADDRESSF7);
        if (deliveraddressf7 != null) {
            deliveraddressf7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((linkaddressf7 = (BasedataEdit)this.getControl(LINKADDRESSF7)) != null) {
            linkaddressf7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        try (TraceSpan span = Tracer.create((String)"CustomerPlugin", (String)"afterCreateNewData");){
            String billcretype = this.getPageCache().get("billcretype");
            if (!BillImportHelper.isManual((String)billcretype)) {
                return;
            }
            super.afterCreateNewData(e);
            this.cusAndSupSettletype(this.getModel(), "customer");
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        if (c.getKey().equalsIgnoreCase("receiveaddress")) {
            DynamicObject reccustomer = (DynamicObject)this.getModel().getValue("reccustomer");
            if (reccustomer == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6536\u8d27\u5ba2\u6237\u3002", (String)"BillTplPlugin_15", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                return;
            }
            BasedataEdit deliveraddressf7 = (BasedataEdit)this.getControl(DELIVERADDRESSF7);
            deliveraddressf7.click();
        } else if (c.getKey().equalsIgnoreCase("address")) {
            DynamicObject customer = (DynamicObject)this.getModel().getValue("customer");
            if (customer == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ba2\u8d27\u5ba2\u6237\u3002", (String)"BillTplPlugin_14", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                return;
            }
            BasedataEdit linkaddressf7 = (BasedataEdit)this.getControl(LINKADDRESSF7);
            linkaddressf7.click();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void beforeF7Select(BeforeF7SelectEvent e) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObject customer = (DynamicObject)this.getModel().getValue("customer");
        try (TraceSpan span = Tracer.create((String)"CustomerPlugin", (String)("beforeF7Select: " + e.getProperty().getName()));){
            switch (e.getProperty().getName()) {
                case "reclinkman": {
                    if (this.getModel().getValue("reccustomer") == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6536\u8d27\u5ba2\u6237\u3002", (String)"BillTplPlugin_15", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        e.setCancel(true);
                        return;
                    }
                    DynamicObject recCustomer = (DynamicObject)this.getModel().getValue("reccustomer");
                    if (recCustomer != null) {
                        DynamicObjectCollection linkmans = recCustomer.getDynamicObjectCollection("entry_linkman");
                        List invalid = linkmans.stream().filter(a -> !a.getBoolean("invalid")).map(a -> (Long)a.getPkValue()).collect(Collectors.toList());
                        QFilter qFilter = new QFilter("customerid", "=", recCustomer.getPkValue());
                        QFilter ids = new QFilter("id", "in", invalid);
                        showParameter.getListFilterParameter().setFilter(qFilter.and(ids));
                        return;
                    }
                    showParameter.getListFilterParameter().setQFilters(Collections.singletonList(new QFilter("customerid", "=", (Object)0)));
                    return;
                }
                case "linkman": {
                    if (customer == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ba2\u8d27\u5ba2\u6237\u3002", (String)"CustomerPlugin_0", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        e.setCancel(true);
                    }
                    if (customer != null) {
                        DynamicObjectCollection linkman = customer.getDynamicObjectCollection("entry_linkman");
                        List invalid = linkman.stream().filter(a -> !a.getBoolean("invalid")).map(a -> (Long)a.getPkValue()).collect(Collectors.toList());
                        QFilter customerid = new QFilter("customerid", "=", customer.getPkValue());
                        QFilter ids = new QFilter("id", "in", invalid);
                        showParameter.getListFilterParameter().setFilter(customerid.and(ids));
                        return;
                    }
                    showParameter.getListFilterParameter().setQFilters(Collections.singletonList(new QFilter("customerid", "=", (Object)0)));
                    return;
                }
                case "reccustomer": {
                    if (this.getModel().getValue("customer") == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ba2\u8d27\u5ba2\u6237\u3002", (String)"CustomerPlugin_0", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        e.setCancel(true);
                    }
                    QFilter bizfunction1 = new QFilter("bizfunction", "like", (Object)"%4%");
                    QFilter status = new QFilter("status", "=", (Object)"C");
                    QFilter enable = new QFilter("enable", "=", (Object)"1");
                    QFilter customerstatus = new QFilter("customerstatus.number", "=", (Object)"ZSKH");
                    QFilter filters = status.and(enable).and(bizfunction1).and(customerstatus);
                    showParameter.getListFilterParameter().getQFilters().add(filters);
                    return;
                }
                case "settlecustomer": {
                    if (this.getModel().getValue("customer") == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ba2\u8d27\u5ba2\u6237\u3002", (String)"CustomerPlugin_0", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        e.setCancel(true);
                    }
                    QFilter bizfunction = new QFilter("bizfunction", "like", (Object)"%2%");
                    showParameter.getListFilterParameter().getQFilters().add(bizfunction);
                    return;
                }
                case "payingcustomer": {
                    if (this.getModel().getValue("customer") == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ba2\u8d27\u5ba2\u6237\u3002", (String)"CustomerPlugin_0", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        e.setCancel(true);
                    }
                    QFilter bizfunction2 = new QFilter("bizfunction", "like", (Object)"%3%");
                    showParameter.getListFilterParameter().getQFilters().add(bizfunction2);
                    return;
                }
                case "deliveraddressf7": {
                    DynamicObject reccustomer = (DynamicObject)this.getModel().getValue("reccustomer");
                    if (reccustomer == null) return;
                    QFilter id1 = new QFilter("customerid", "in", (Object)reccustomer.getPkValue().toString());
                    QFilter id2 = new QFilter("invalid", "=", (Object)"0");
                    showParameter.getListFilterParameter().setQFilters(Arrays.asList(id1, id2));
                    return;
                }
                case "linkaddressf7": {
                    if (customer == null) return;
                    QFilter id1 = new QFilter("customerid", "in", (Object)customer.getPkValue().toString());
                    QFilter id2 = new QFilter("invalid", "=", (Object)"0");
                    showParameter.getListFilterParameter().setQFilters(Arrays.asList(id1, id2));
                    return;
                }
            }
            return;
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String billcretype = this.getPageCache().get("billcretype");
        if (!BillImportHelper.isManual((String)billcretype)) {
            return;
        }
        try (TraceSpan span = Tracer.create((String)"CustomerPlugin", (String)("propertyChanged: " + e.getProperty().getName()));){
            ChangeData[] valueSet = e.getChangeSet();
            String key = e.getProperty().getName();
            block24: for (int i = 0; i < valueSet.length; ++i) {
                Object newValue = valueSet[i].getNewValue();
                if (!CommonUtils.isRealChanged((ChangeData)valueSet[i])) continue;
                switch (key) {
                    case "customer": {
                        this.customerChanged((DynamicObject)newValue);
                        continue block24;
                    }
                    case "reccustomer": {
                        if (newValue == null) {
                            this.getModel().setValue("reclinkman", null);
                            this.getModel().setValue("receiveaddress", null);
                            return;
                        }
                        this.setValueIfExists("reclinkman", () -> CustomerHelper.getLinkman((DynamicObject)((DynamicObject)newValue)));
                        this.setValueIfExists("receiveaddress", () -> CustomerHelper.getAddress((DynamicObject)((DynamicObject)newValue)));
                        continue block24;
                    }
                    case "deliveraddressf7": {
                        DynamicObject newAddress = (DynamicObject)valueSet[0].getNewValue();
                        if (newAddress == null) continue block24;
                        this.getModel().setValue("receiveaddress", (Object)newAddress.getString("detailaddress"));
                        continue block24;
                    }
                    case "linkaddressf7": {
                        DynamicObject linkaddress = (DynamicObject)valueSet[0].getNewValue();
                        if (linkaddress == null) continue block24;
                        this.getModel().setValue("address", (Object)linkaddress.getString("detailaddress"));
                        continue block24;
                    }
                    default: {
                        super.propertyChanged(e);
                    }
                }
            }
        }
    }

    private void customerChanged(DynamicObject customer) {
        if (customer == null) {
            this.getModel().setValue("linkman", null);
            this.getModel().setValue("address", null);
            this.getModel().setValue("reccustomer", null);
            this.getModel().setValue("reclinkman", null);
            this.getModel().setValue("receiveaddress", null);
            this.getModel().setValue("settlecustomer", null);
            this.getModel().setValue("payingcustomer", null);
            this.getView().setEnable(Boolean.FALSE, new String[]{"settlecurrency"});
            this.getModel().setValue("settlecurrency", null);
            this.getModel().setValue("settletype", null);
            this.getModel().setValue("reccondition", null);
            return;
        }
        this.getView().setEnable(Boolean.TRUE, new String[]{"settlecurrency"});
        DynamicObject reccondition = customer.getDynamicObject("receivingcondid");
        if (reccondition != null) {
            this.setValueIfExists("reccondition", () -> ((DynamicObject)reccondition).getPkValue());
        } else {
            this.setValueIfExists("reccondition", () -> null);
        }
        IDataModel model = this.getModel();
        model.beginInit();
        this.setValueIfExists("linkman", () -> CustomerHelper.getLinkman((DynamicObject)customer));
        this.setValueIfExists("address", () -> CustomerHelper.getAddress((DynamicObject)customer));
        if (customer.getDynamicObject("delivercustomerid") == null || customer.getLong("id") == customer.getDynamicObject("delivercustomerid").getLong("id")) {
            if (this.getCustomerValueOriginal(customer, "delivercustomerid") == null) {
                this.setValueIfExists("reccustomer", () -> null);
                this.setValueIfExists("reclinkman", () -> null);
                this.setValueIfExists("receiveaddress", () -> null);
            } else {
                this.setValueIfExists("reccustomer", () -> this.getCustomerValueOriginal(customer, "delivercustomerid"));
                this.setValueIfExists("reclinkman", () -> CustomerHelper.getLinkman((DynamicObject)customer));
                this.setValueIfExists("receiveaddress", () -> CustomerHelper.getAddress((DynamicObject)customer));
            }
        } else {
            Long customerValue = this.getCustomerValueOriginal(customer, "delivercustomerid");
            if (customerValue == null) {
                this.setValueIfExists("reccustomer", () -> this.getCustomerValueOriginal(customer, "delivercustomerid"));
                this.setValueIfExists("reclinkman", () -> null);
                this.setValueIfExists("receiveaddress", () -> null);
            } else {
                this.setValueIfExists("reccustomer", () -> customerValue);
                DynamicObject recCustomer = BusinessDataServiceHelper.loadSingleFromCache((Object)customerValue, (String)"bd_customer");
                this.setValueIfExists("reclinkman", () -> CustomerHelper.getLinkman((DynamicObject)recCustomer));
                this.setValueIfExists("receiveaddress", () -> CustomerHelper.getAddress((DynamicObject)recCustomer));
            }
        }
        this.setValueIfExists("payingcustomer", () -> this.getCustomerValueOriginal(customer, "paymentcustomerid"));
        this.setValueIfExists("settlecustomer", () -> this.getCustomerValueOriginal(customer, "invoicecustomerid"));
        DynamicObject settlementType = customer.getDynamicObject("settlementtypeid");
        if (settlementType != null) {
            QFilter isenable;
            Long settlementTypeId = (Long)settlementType.getPkValue();
            QFilter id = new QFilter("id", "=", (Object)settlementTypeId);
            DynamicObject object = BusinessDataServiceHelper.loadSingle((String)"bd_settlementtype", (String)"id,", (QFilter[])new QFilter[]{id.and(isenable = new QFilter("enable", "=", (Object)"1"))});
            if (object == null) {
                this.getSettleTypeDefault(model);
            } else {
                model.setValue("settletype", settlementType.getPkValue());
            }
        } else {
            this.getSettleTypeDefault(model);
        }
        model.endInit();
        if (customer.getDynamicObject("settlementcyid") != null) {
            this.setValueIfExists("settlecurrency", () -> BusinessDataServiceHelper.loadSingleFromCache((Object)customer.getDynamicObject("settlementcyid").getPkValue(), (String)"bd_currency", (String)"id, number, name, amtprecision,priceprecision,sign,isshowsign"));
        } else {
            this.setValueIfExists("settlecurrency", () -> model.getValue("currency"));
        }
        this.getView().updateView("linkman");
        this.getView().updateView("address");
        this.getView().updateView("linkmanphone");
        this.getView().updateView("reccustomer");
        this.getView().updateView("payingcustomer");
        this.getView().updateView("settlecustomer");
        this.getView().updateView("settletype");
        this.getView().updateView("reclinkman");
        this.getView().updateView("receiveaddress");
    }

    private void getSettleTypeDefault(IDataModel bill) {
        QFilter isdefault = new QFilter("isdefault", "=", (Object)Boolean.TRUE);
        QFilter isenable = new QFilter("enable", "=", (Object)"1");
        QFilter filter = isdefault.and(isenable);
        DynamicObject defaultSettlementType = BusinessDataServiceHelper.loadSingle((String)"bd_settlementtype", (String)"id,", (QFilter[])new QFilter[]{filter});
        if (defaultSettlementType != null) {
            bill.setValue("settletype", defaultSettlementType.getPkValue());
        } else {
            bill.setValue("settletype", null);
        }
    }

    private void setValueIfExists(String property, ValueHandle handle) {
        if (MetaDataHelper.isExistField((IDataEntityType)this.getModel().getDataEntityType(), (String)property)) {
            if (handle.getValue() != null && handle.getValue() instanceof DynamicObject) {
                this.getModel().setValue(property, ((DynamicObject)handle.getValue()).getPkValue());
            } else {
                this.getModel().setValue(property, handle.getValue());
            }
        }
    }

    private void cusAndSupSettletype(IDataModel bill, String roleType) {
        QFilter isdefault = new QFilter("isdefault", "=", (Object)Boolean.TRUE);
        QFilter isenable = new QFilter("enable", "=", (Object)"1");
        QFilter filter = isdefault.and(isenable);
        DynamicObject defaultSettlementType = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_settlementtype", (QFilter[])new QFilter[]{filter});
        if (bill.getValue("settletype") == null) {
            DynamicObject role = (DynamicObject)bill.getValue(roleType);
            if (role != null) {
                DynamicObject settlementtypeid = role.getDynamicObject("settlementtypeid");
                if (settlementtypeid == null) {
                    bill.setValue("settletype", defaultSettlementType == null ? null : defaultSettlementType.getPkValue());
                } else {
                    bill.setValue("settletype", settlementtypeid.getPkValue());
                }
            } else {
                bill.setValue("settletype", defaultSettlementType == null ? null : defaultSettlementType.getPkValue());
            }
        }
    }

    private Long getCustomerValueOriginal(DynamicObject customer, String otherCustomer) {
        if (customer == null) {
            return null;
        }
        DynamicObject dynamicObject = customer.getDynamicObject(otherCustomer);
        if (dynamicObject != null) {
            return (Long)dynamicObject.getPkValue();
        }
        return null;
    }

    private Long getCustomerValue(DynamicObject customer, String otherCustomer) {
        String bizfunction;
        if (customer == null) {
            return null;
        }
        DynamicObject dynamicObject = customer.getDynamicObject(otherCustomer);
        if (dynamicObject != null) {
            QFilter id = new QFilter("id", "=", dynamicObject.getPkValue());
            QFilter status = new QFilter("status", "=", (Object)"C");
            QFilter enable = new QFilter("enable", "=", (Object)"1");
            id = id.and(status.and(enable));
            switch (otherCustomer) {
                case "invoicecustomerid": {
                    QFilter invoicehold = new QFilter("invoicehold", "=", (Object)"0");
                    QFilter bizfunction2 = new QFilter("bizfunction", "like", (Object)"%2%");
                    id = id.and(invoicehold).and(bizfunction2);
                    break;
                }
                case "delivercustomerid": {
                    QFilter purchasehold = new QFilter("blockedshipment", "=", (Object)"0");
                    QFilter bizfunction1 = new QFilter("bizfunction", "like", (Object)"%4%");
                    id = id.and(purchasehold).and(bizfunction1);
                    break;
                }
                case "paymentcustomerid": {
                    QFilter bizfunction2 = new QFilter("bizfunction", "like", (Object)"%3%");
                    id = id.and(bizfunction2);
                }
            }
            DynamicObject otCustomer = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_customer", (QFilter[])new QFilter[]{id});
            if (otCustomer != null) {
                return (Long)otCustomer.getPkValue();
            }
            if (customer.getPkValue().equals(dynamicObject.getPkValue())) {
                return null;
            }
        }
        if (StringUtils.isBlank((String)(bizfunction = customer.getString("bizfunction")))) {
            return null;
        }
        switch (otherCustomer) {
            case "invoicecustomerid": {
                if (!customer.getBoolean("invoicehold") && bizfunction.contains("2")) break;
                return null;
            }
            case "delivercustomerid": {
                if (!customer.getBoolean("blockedshipment") && bizfunction.contains("4")) break;
                return null;
            }
            case "paymentcustomerid": {
                if (bizfunction.contains("3")) break;
                return null;
            }
        }
        return (Long)customer.getPkValue();
    }

    public static interface ValueHandle {
        public Object getValue();
    }
}

