/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.formplugin.tpl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.StringUtils;
import kd.scmc.sm.business.helper.BillImportHelper;
import kd.scmc.sm.business.helper.BillTplHelper;
import kd.scmc.sm.business.helper.KitSalesHelper;
import kd.scmc.sm.consts.BillTplEntryConst;
import kd.scmc.sm.enums.ProductTypeEnum;

public class KitSalesImportPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(KitSalesImportPlugin.class);
    private static final String[] KITINFO_FIELDS = new String[]{"pricemodel", "kitstructctl", "kitreturnmodel", "kittransfermodel"};

    public void beforeImportData(BeforeImportDataEventArgs e) {
        try (TraceSpan span = Tracer.create((String)"KitSalesImportPlugin", (String)"beforeImportData");){
            log.info("start beforeImportData ");
            if (e.getSourceData() instanceof JSONObject) {
                JSONObject bill = (JSONObject)e.getSourceData();
                JSONArray entrys = bill.getJSONArray("billentry");
                if (KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) {
                    entrys.forEach(entry -> {
                        JSONObject jsonEntry = (JSONObject)entry;
                        String productType = jsonEntry.getString("producttype");
                        if (StringUtils.isEmpty((String)productType)) {
                            jsonEntry.put("producttype", (Object)ProductTypeEnum.STANDARD.getValue());
                        }
                    });
                }
            }
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        try (TraceSpan span = Tracer.create((String)"KitSalesImportPlugin", (String)"afterImportData");){
            String url = RequestContext.get().getClientUrl();
            if (url != null && url.contains("appendentryrows")) {
                return;
            }
            String billcretype = this.getPageCache().get("billcretype");
            if (BillImportHelper.isImport((String)billcretype)) {
                DynamicObjectCollection entrys = this.getModel().getEntryEntity("billentry");
                if (!KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) {
                    for (int i = 0; entrys != null && i < entrys.size(); ++i) {
                        DynamicObject entry = (DynamicObject)entrys.get(i);
                        entry.set("producttype", (Object)ProductTypeEnum.STANDARD.getValue());
                    }
                    return;
                }
                boolean hasKitParent = false;
                for (int i = 0; entrys != null && i < entrys.size(); ++i) {
                    String msg;
                    DynamicObject entry = (DynamicObject)entrys.get(i);
                    String productType = entry.getString("producttype");
                    if (entry.getDynamicObject("material") == null || entry.getDynamicObject("material").getDynamicObject("masterid") == null) {
                        String msg3 = String.format(ResManager.loadKDString((String)"\u65e0\u6548\u7269\u6599\uff0c\u8bf7\u786e\u8ba4\u7269\u6599\u4fe1\u606f\u3002", (String)"KitSalesImportPlugin_5", (String)"scmc-sm-formplugin", (Object[])new Object[0]), new Object[0]);
                        e.setCancel(true);
                        e.setCancelMessages(Integer.valueOf(i), Integer.valueOf(0), Collections.singletonList(msg3));
                        continue;
                    }
                    DynamicObject material = entry.getDynamicObject("material");
                    DynamicObject masterid = material.getDynamicObject("masterid");
                    boolean isOK = true;
                    ArrayList<String> msgs = new ArrayList<String>(3);
                    if (ProductTypeEnum.KITPARENT.getValue().equals(productType)) {
                        DynamicObject kitBomMaterial;
                        hasKitParent = true;
                        if (!masterid.getBoolean("suite")) {
                            isOK = false;
                            String string = String.format(ResManager.loadKDString((String)"%1$s\uff08%2$s\uff09\u5728\u7269\u6599\u57fa\u7840\u8d44\u6599\u4e2d\u5957\u4ef6\u4e3a\u201c\u5426\u201d\uff0c\u4e0d\u5c5e\u4e8e\u5957\u4ef6\u7236\u9879\u7269\u6599\uff0c\u8bf7\u4fee\u6539\u4ea7\u54c1\u7c7b\u522b\u6216\u7269\u6599\u57fa\u7840\u8d44\u6599\u540e\u91cd\u8bd5\u3002", (String)"KitSalesImportPlugin_0", (String)"scmc-sm-formplugin", (Object[])new Object[0]), masterid.getString("name"), masterid.getString("number"));
                            msgs.add(string);
                        } else {
                            for (String kitField : KITINFO_FIELDS) {
                                if (!StringUtils.isEmpty((String)material.getString(kitField))) continue;
                                isOK = false;
                                msg = String.format(ResManager.loadKDString((String)"%1$s\uff08%2$s\uff09\u662f\u5957\u4ef6\u7236\u9879\u7269\u6599\uff0c\u7269\u6599\u9500\u552e\u4fe1\u606f\u4e2d\u5b9a\u4ef7\u65b9\u5f0f\u3001\u5957\u4ef6\u53d1\u8d27\u65b9\u5f0f\u3001\u5957\u4ef6\u9000\u8d27\u65b9\u5f0f\u3001\u5355\u636e\u5957\u4ef6\u7ed3\u6784\u63a7\u5236\u90fd\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\u7269\u6599\u9500\u552e\u4fe1\u606f\u540e\u91cd\u8bd5\u3002", (String)"KitSalesImportPlugin_2", (String)"scmc-sm-formplugin", (Object[])new Object[0]), masterid.getString("name"), masterid.getString("number"));
                                msgs.add(msg);
                                break;
                            }
                        }
                        DynamicObject dynamicObject = entry.getDynamicObject("bom");
                        if (dynamicObject != null && dynamicObject.containsProperty("material") && (kitBomMaterial = dynamicObject.getDynamicObject("material")) != null && ((Long)masterid.getPkValue()).longValue() != ((Long)kitBomMaterial.getPkValue()).longValue()) {
                            isOK = false;
                            String msg4 = String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0cBOM\u7f16\u7801\u5fc5\u987b\u6ee1\u8db3\u5b58\u5728\u3001\u53ef\u7528\u3001\u5df2\u5ba1\u6838\uff0c\u5e76\u4e14\u662f\u5f53\u524d\u7269\u6599\u7f16\u7801%1$s\u5bf9\u5e94\u7684BOM\u7f16\u7801\u3002", (String)"KitSalesImportPlugin_6", (String)"scmc-sm-formplugin", (Object[])new Object[0]), masterid.getString("number"));
                            msgs.add(msg4);
                        }
                    } else if (ProductTypeEnum.KITCHILD.getValue().equals(productType) || ProductTypeEnum.STANDARD.getValue().equals(productType)) {
                        if (ProductTypeEnum.STANDARD.getValue().equals(productType)) {
                            hasKitParent = false;
                        }
                        if (masterid.getBoolean("suite")) {
                            isOK = false;
                            String string = String.format(ResManager.loadKDString((String)"%1$s\uff08%2$s\uff09\u5728\u7269\u6599\u57fa\u7840\u8d44\u6599\u4e2d\u5957\u4ef6\u4e3a\u201c\u662f\u201d\uff0c\u5c5e\u4e8e\u5957\u4ef6\u7236\u9879\u7269\u6599\uff0c\u8bf7\u4fee\u6539\u4ea7\u54c1\u7c7b\u522b\u6216\u7269\u6599\u57fa\u7840\u8d44\u6599\u540e\u91cd\u8bd5\u3002", (String)"KitSalesImportPlugin_1", (String)"scmc-sm-formplugin", (Object[])new Object[0]), masterid.getString("name"), masterid.getString("number"));
                            msgs.add(string);
                        } else {
                            for (String kitField : KITINFO_FIELDS) {
                                if (!StringUtils.isNotEmpty((String)material.getString(kitField))) continue;
                                isOK = false;
                                msg = String.format(ResManager.loadKDString((String)"%1$s\uff08%2$s\uff09\u4e0d\u662f\u5957\u4ef6\u7236\u9879\u7269\u6599\uff0c\u7269\u6599\u9500\u552e\u4fe1\u606f\u4e2d\u5b9a\u4ef7\u65b9\u5f0f\u3001\u5957\u4ef6\u53d1\u8d27\u65b9\u5f0f\u3001\u5957\u4ef6\u9000\u8d27\u65b9\u5f0f\u3001\u5355\u636e\u5957\u4ef6\u7ed3\u6784\u63a7\u5236\u90fd\u5fc5\u987b\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\u7269\u6599\u9500\u552e\u4fe1\u606f\u540e\u91cd\u8bd5\u3002", (String)"KitSalesImportPlugin_3", (String)"scmc-sm-formplugin", (Object[])new Object[0]), masterid.getString("name"), masterid.getString("number"));
                                msgs.add(msg);
                                break;
                            }
                        }
                        if (!hasKitParent && ProductTypeEnum.KITCHILD.getValue().equals(productType)) {
                            isOK = false;
                            String string = String.format(ResManager.loadKDString((String)"%1$s\uff08%2$s\uff09\u662f\u5957\u4ef6\u5b50\u9879\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5957\u4ef6\u7236\u9879\uff0c\u8bf7\u7ef4\u62a4\u201c\u7236\u9879\u4ea7\u54c1\u201d\u540e\u91cd\u8bd5\u3002", (String)"KitSalesImportPlugin_4", (String)"scmc-sm-formplugin", (Object[])new Object[0]), masterid.getString("name"), masterid.getString("number"));
                            msgs.add(string);
                        }
                    }
                    if (isOK) continue;
                    e.setCancel(!isOK);
                    e.setCancelMessages(Integer.valueOf(i), Integer.valueOf(0), msgs);
                }
                if (!e.isCancel()) {
                    HashSet<String> enableColumn = new HashSet<String>();
                    enableColumn.addAll(Arrays.asList(BillTplEntryConst.KITAMOUNTANDPRICEFIELDS));
                    List wer = KitSalesHelper.getAmountAndQtyFieldList((DynamicObject)this.getModel().getDataEntity(true), (String)"billentry");
                    enableColumn.addAll(wer);
                    KitSalesHelper.initEntryInfo4Kit((DynamicObjectCollection)entrys, enableColumn, new HashMap());
                    BillTplHelper.calculateAmount4WholeBill((DynamicObject)this.getModel().getDataEntity(true), (IDataModel)this.getModel());
                }
            }
        }
    }
}

