/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.formplugin.tpl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.LinkSetElement;
import kd.bos.entity.LinkSetItemElement;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mpscmm.msbd.business.helper.SCMCBomHelper;
import kd.mpscmm.msbd.changemodel.business.helper.ChangeModelHelper;
import kd.mpscmm.msbd.common.enums.KitStructCtlEnum;
import kd.mpscmm.msbd.common.enums.KitTransferModelEnum;
import kd.mpscmm.msbd.common.enums.PriceModelEnum;
import kd.mpscmm.msbd.common.pojo.SCMCBomEntryData;
import kd.mpscmm.msbd.common.pojo.SCMCBomExpandData;
import kd.scmc.sm.business.helper.BillImportHelper;
import kd.scmc.sm.business.helper.BillTplHelper;
import kd.scmc.sm.business.helper.KitSalesHelper;
import kd.scmc.sm.business.helper.PropertyChangeHelper;
import kd.scmc.sm.consts.BillTplEntryConst;
import kd.scmc.sm.enums.ChangeTypeEnum;
import kd.scmc.sm.enums.EnableStatusEnum;
import kd.scmc.sm.enums.OwnerTypeEnum;
import kd.scmc.sm.enums.ProductTypeEnum;
import kd.scmc.sm.enums.StatusEnum;
import kd.scmc.sm.util.CommonUtils;

public class KitSalesPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
EntryGridBindDataListener {
    private static final Log LOG = LogFactory.getLog(KitSalesPlugin.class);
    private static final String BLANK = " ";
    private static final String NEWCHILD_OP = "newchild";
    private static final String EXPANDKIT_OP = "expandkit";
    private static final String SELECTROW = "selectrow";
    private static final String SELECT_MATERIALROW = "SELECT_MATERIALROW";
    private static final String DELETEPARENTROW = "deleteParentRow";
    private static final String ISCONFIRMDELETEKITROW = "isConfirmDeleteKitRow";
    private static final String CHANGEPARENTBOM = "changeParentBom";
    private static final String ISCONFIRMCHANGEPARENTBOM = "isConfirmChangeParentBom";
    private static final String CHANGEPARENTBOM_ROWINDEX = "changeParentBomRowIndex";
    private static final String CHANGEPARENTBOM_VALUE = "changeParentBomValue";
    private static final String EXPANDKITBOMCONFIRM = "expandKitBomConfirm";
    private static final String EXPANDKITPARENTROW = "expandKitParentRow";
    private static final int MAXEXPANDKITROW = 500;
    private static final int MAXERRORNOTICEROW = 50;
    private static final String ISCANCELDELROWBECBOM = "isCancelDelRowBecBom";
    private static final String CONFIRM_KITLINETYPE = "confirmKitLineType";
    private static final String CACHE_KITLINETYPE = "cacheKitLineType";
    private static final String INVENTORY_QUERY = "inventory_query";
    private static final String DELETEROWNOTSHOWMSG = "deleteRowNotShowMsg";

    public void initialize() {
        EntryGrid entry = (EntryGrid)this.getControl("billentry");
        if (entry != null) {
            entry.addDataBindListener((EntryGridBindDataListener)this);
        }
    }

    public void registerListener(EventObject e) {
        BasedataEdit lineTypeEdit;
        BasedataEdit kitBomEdit;
        super.registerListener(e);
        BasedataEdit materialEdit = (BasedataEdit)this.getView().getControl("material");
        if (materialEdit != null) {
            materialEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((kitBomEdit = (BasedataEdit)this.getView().getControl("bom")) != null) {
            kitBomEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((lineTypeEdit = (BasedataEdit)this.getView().getControl("linetype")) != null) {
            lineTypeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        TraceSpan span = Tracer.create((String)"KitSalesPlugin", (String)"afterCreateNewData");
        Throwable throwable = null;
        if (span != null) {
            if (throwable != null) {
                try {
                    span.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                span.close();
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        try (TraceSpan span = Tracer.create((String)"KitSalesPlugin", (String)"afterBindData");){
            if (!KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) {
                this.getView().setVisible(Boolean.FALSE, BillTplEntryConst.KITFIELDS);
                this.getView().setVisible(Boolean.FALSE, new String[]{NEWCHILD_OP});
                this.getView().setVisible(Boolean.FALSE, new String[]{"addrowx"});
                this.getView().setVisible(Boolean.FALSE, new String[]{EXPANDKIT_OP});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"addrow"});
            }
        }
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        if (!KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) {
            return;
        }
        try (TraceSpan span = Tracer.create((String)"KitSalesPlugin", (String)"entryGridBindData");){
            List entities = e.getRows();
            IFormView view = this.getView();
            entities.forEach(entry -> {
                int rowIndex = entry.getRowIndex();
                DynamicObject entryObj = entry.getDataEntity();
                if (ProductTypeEnum.KITPARENT.getValue().equals(entryObj.getString("producttype")) && this.hasKitChild(rowIndex)) {
                    view.setEnable(Boolean.FALSE, rowIndex, new String[]{"material"});
                }
            });
            this.setKitColumnEnables(e.getRows());
        }
    }

    public void beforeAddRow(BeforeAddRowEventArgs e) {
        super.beforeAddRow(e);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void beforeF7Select(BeforeF7SelectEvent e) {
        if (!KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) {
            return;
        }
        String key = e.getProperty().getName();
        IDataModel bill = this.getModel();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        int rowIndex = this.getModel().getEntryCurrentRowIndex("billentry");
        try (TraceSpan span = Tracer.create((String)"KitSalesPlugin", (String)("beforeF7Select: " + e.getProperty().getName()));){
            switch (key) {
                case "material": {
                    this.getPageCache().put(SELECT_MATERIALROW, String.valueOf(rowIndex));
                    String productType = (String)this.getModel().getValue("producttype", rowIndex);
                    if (ProductTypeEnum.KITPARENT.getValue().equals(productType)) {
                        QFilter suiteFilter = new QFilter("masterid.suite", "=", (Object)Boolean.TRUE);
                        suiteFilter.and(new QFilter("pricemodel", "!=", (Object)BLANK));
                        suiteFilter.and(new QFilter("kitstructctl", "!=", (Object)BLANK));
                        showParameter.getListFilterParameter().getQFilters().add(suiteFilter);
                        return;
                    }
                    if (!ProductTypeEnum.KITCHILD.getValue().equals(productType)) {
                        if (!ProductTypeEnum.STANDARD.getValue().equals(productType)) return;
                    }
                    QFilter suiteFilter = new QFilter("masterid.suite", "in", (Object)Boolean.FALSE);
                    suiteFilter.and(new QFilter("pricemodel", "=", (Object)BLANK));
                    suiteFilter.and(new QFilter("kitstructctl", "=", (Object)BLANK));
                    showParameter.getListFilterParameter().getQFilters().add(suiteFilter);
                    return;
                }
                case "bom": {
                    DynamicObject material = (DynamicObject)this.getModel().getValue("material", rowIndex);
                    if (material == null) {
                        e.setCancel(true);
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u7f16\u7801\u3002", (String)"KitSalesPlugin_18", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (!material.containsProperty("masterid")) return;
                    if (material.getDynamicObject("masterid") == null) return;
                    DynamicObject masterid = material.getDynamicObject("masterid");
                    QFilter materialFilter = new QFilter("material.id", "=", masterid.getPkValue());
                    showParameter.getListFilterParameter().getQFilters().add(materialFilter);
                    showParameter.setCustomParam("ismergerows", (Object)Boolean.TRUE);
                    return;
                }
                case "linetype": {
                    String childProductType = (String)this.getModel().getValue("producttype", rowIndex);
                    if (!ProductTypeEnum.KITCHILD.getValue().equals(childProductType)) return;
                    DynamicObject childMaterial = (DynamicObject)this.getModel().getValue("material", rowIndex);
                    if (childMaterial == null) return;
                    DynamicObjectCollection materialServiceattribute = childMaterial.getDynamicObjectCollection("masterid.serviceattribute");
                    List serviceattributeIds = materialServiceattribute.stream().map(dym -> dym.get("fbasedataid_id")).collect(Collectors.toList());
                    if (serviceattributeIds.contains(BillTplEntryConst.MASTERSERVICEATTRIBUTE_1001) && !serviceattributeIds.contains(BillTplEntryConst.MASTERSERVICEATTRIBUTE_2001)) {
                        QFilter lineTypeFilter = new QFilter("id", "=", (Object)1194150915045641216L);
                        showParameter.getListFilterParameter().getQFilters().add(lineTypeFilter);
                        return;
                    }
                    if (!serviceattributeIds.contains(BillTplEntryConst.MASTERSERVICEATTRIBUTE_1001) && serviceattributeIds.contains(BillTplEntryConst.MASTERSERVICEATTRIBUTE_2001)) {
                        QFilter lineTypeFilter = new QFilter("id", "=", (Object)1194153085623127040L);
                        showParameter.getListFilterParameter().getQFilters().add(lineTypeFilter);
                        return;
                    }
                    if (serviceattributeIds.contains(BillTplEntryConst.MASTERSERVICEATTRIBUTE_1001) && serviceattributeIds.contains(BillTplEntryConst.MASTERSERVICEATTRIBUTE_2001)) {
                        QFilter lineTypeFilter = new QFilter("id", "in", Arrays.asList(1194150915045641216L, 1194153085623127040L));
                        showParameter.getListFilterParameter().getQFilters().add(lineTypeFilter);
                        return;
                    }
                    showParameter.getListFilterParameter().getQFilters().add(QFilter.of((String)"1=-1", (Object[])new Object[0]));
                    return;
                }
            }
            return;
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        block117: {
            if (!KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) {
                return;
            }
            try (TraceSpan span = Tracer.create((String)"KitSalesPlugin", (String)("beforeDoOperation: " + args.getSource()));){
                DynamicObject material;
                String materialName;
                String materialCode;
                if (!(args.getSource() instanceof FormOperate)) break block117;
                String opKey = ((FormOperate)args.getSource()).getOperateKey();
                if (NEWCHILD_OP.equals(opKey)) {
                    EntryGrid entry = (EntryGrid)this.getControl("billentry");
                    if (entry.getSelectRows() == null || entry.getSelectRows().length == 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"KitSalesPlugin_42", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    int selectRow = entry.getSelectRows()[0];
                    int actureRow = selectRow + 1;
                    String productType = (String)this.getModel().getValue("producttype", selectRow);
                    DynamicObject material2 = (DynamicObject)this.getModel().getValue("material", selectRow);
                    if (!ProductTypeEnum.KITPARENT.getValue().equals(productType)) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u4ea7\u54c1\u7c7b\u522b=\u201c\u5957\u4ef6\u7236\u9879\u201d\uff0c\u624d\u5141\u8bb8\u589e\u5b50\u884c\u3002", (String)"KitSalesPlugin_1", (String)"scmc-sm-formplugin", (Object[])new Object[0]), actureRow));
                        args.setCancel(true);
                        return;
                    }
                    if (material2 == null) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u8bf7\u9009\u62e9\u5957\u4ef6\u7236\u9879\u7269\u6599\u3002", (String)"KitSalesPlugin_2", (String)"scmc-sm-formplugin", (Object[])new Object[0]), actureRow));
                        args.setCancel(true);
                        return;
                    }
                    String entityId = this.getView().getEntityId();
                    if ("sm_xsalorder".equals(entityId) || "sm_xssalorder".equals(entityId)) {
                        String changeType = (String)this.getModel().getValue("entrychangetype", selectRow);
                        if (ChangeTypeEnum.CANCEL.getValue().equals(changeType)) {
                            if (material2.getDynamicObject("masterid") == null) {
                                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u53d8\u66f4\u65b9\u5f0f\u4e3a\u201c\u53d6\u6d88\u201d\u65f6\uff0c\u4e0d\u5141\u8bb8\u589e\u52a0\u5b50\u884c\u3002", (String)"KitSalesPlugin_12", (String)"scmc-sm-formplugin", (Object[])new Object[0]), actureRow));
                            } else {
                                DynamicObject masterid = material2.getDynamicObject("masterid");
                                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c%2$s\uff08%3$s\uff09\uff0c\u53d8\u66f4\u65b9\u5f0f\u4e3a\u201c\u53d6\u6d88\u201d\u65f6\uff0c\u4e0d\u5141\u8bb8\u589e\u52a0\u5b50\u884c\u3002", (String)"KitSalesPlugin_13", (String)"scmc-sm-formplugin", (Object[])new Object[0]), actureRow, masterid.getString("name"), masterid.getString("number")));
                            }
                            args.setCancel(true);
                            return;
                        }
                        String transferModel = (String)this.getModel().getValue("kittransfermodel", selectRow);
                        if (KitTransferModelEnum.KIT.getValue().equals(transferModel)) {
                            boolean isCanAddRow = true;
                            if (!(isCanAddRow = this.isHasPushedData(isCanAddRow, selectRow))) {
                                if (material2.getDynamicObject("masterid") == null) {
                                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u6210\u5957\u53d1\u8d27\u5e76\u4e14\u5df2\u53d1\u751f\u4e0b\u6e38\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u589e\u52a0\u5b50\u884c\u3002", (String)"KitSalesPlugin_16", (String)"scmc-sm-formplugin", (Object[])new Object[0]), actureRow));
                                } else {
                                    DynamicObject masterid = material2.getDynamicObject("masterid");
                                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c%2$s\uff08%3$s\uff09\uff0c\u6210\u5957\u53d1\u8d27\u5e76\u4e14\u5df2\u53d1\u751f\u4e0b\u6e38\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u589e\u5b50\u884c\u3002", (String)"KitSalesPlugin_17", (String)"scmc-sm-formplugin", (Object[])new Object[0]), actureRow, masterid.getString("name"), masterid.getString("number")));
                                }
                                args.setCancel(true);
                                return;
                            }
                        }
                    }
                    DynamicObject kitBom = (DynamicObject)this.getModel().getValue("bom", selectRow);
                    if (!ProductTypeEnum.KITPARENT.getValue().equals(productType) || kitBom != null && KitStructCtlEnum.NONADJ.getValue().equals(material2.getString("kitstructctl"))) {
                        if (material2.getDynamicObject("masterid") == null) {
                            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u4ea7\u54c1\u7c7b\u522b=\u201c\u5957\u4ef6\u7236\u9879\u201d\uff0c\u5e76\u4e14\u7269\u6599\u9500\u552e\u4fe1\u606f\u4e2d\u5355\u636e\u5957\u4ef6\u7ed3\u6784\u63a7\u5236=\u201c\u53ef\u8c03\u6574\u201d\uff0c\u624d\u5141\u8bb8\u589e\u5b50\u884c\u3002", (String)"KitSalesPlugin_3", (String)"scmc-sm-formplugin", (Object[])new Object[0]), actureRow));
                            args.setCancel(true);
                            return;
                        }
                        DynamicObject masterid = material2.getDynamicObject("masterid");
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c%2$s\uff08%3$s\uff09\uff0c\u4ea7\u54c1\u7c7b\u522b=\u201c\u5957\u4ef6\u7236\u9879\u201d\uff0c\u5e76\u4e14\u7269\u6599\u9500\u552e\u4fe1\u606f\u4e2d\u5355\u636e\u5957\u4ef6\u7ed3\u6784\u63a7\u5236=\u201c\u53ef\u8c03\u6574\u201d\uff0c\u624d\u5141\u8bb8\u589e\u5b50\u884c\u3002", (String)"KitSalesPlugin_4", (String)"scmc-sm-formplugin", (Object[])new Object[0]), actureRow, masterid.getString("name"), masterid.getString("number")));
                        args.setCancel(true);
                        return;
                    }
                    this.genPID(selectRow);
                    int interval = this.getKitChildInterval(selectRow);
                    int positionRow = selectRow + interval;
                    entry.getEntryState().setFocusRow(positionRow);
                    this.getPageCache().put(SELECTROW, String.valueOf(selectRow));
                    this.markNewChildOp();
                    this.getModel().appendEntryRow("billentry", positionRow, 1);
                } else {
                    this.clearMarkNewChildOp();
                }
                if (EXPANDKIT_OP.equals(opKey)) {
                    DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                    if (org == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"KitSalesPlugin_23", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
                    if (bizType == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"KitSalesPlugin_31", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    AbstractGrid billEntry = (AbstractGrid)this.getControl("billentry");
                    int[] selectRows = ((EntryGrid)billEntry).getSelectRows();
                    if (selectRows == null || selectRows.length <= 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"KitSalesPlugin_20", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                }
                if ("scmcinvquery".equals(opKey)) {
                    this.getPageCache().remove(SELECT_MATERIALROW);
                }
                if (!"deleteentry".equals(opKey)) break block117;
                if ("true".equals(this.getPageCache().get(ISCONFIRMDELETEKITROW))) {
                    return;
                }
                String entityId = this.getView().getEntityId();
                Boolean isOrderOrXOrder = "sm_salorder".equals(entityId) || "sm_xsalorder".equals(entityId) || "sm_xssalorder".equals(entityId);
                Boolean isDeliver = "sm_delivernotice".equals(entityId);
                String isDraw = this.getPageCache().get("isdraw");
                if (isDraw == null) {
                    isDraw = String.valueOf(this.isDraw());
                }
                Boolean isDrawReturn = "sm_returnapply".equals(entityId) && "true".equals(isDraw);
                Boolean isNewReturn = "sm_returnapply".equals(entityId) && !"true".equals(isDraw);
                EntryGrid entry = (EntryGrid)this.getControl("billentry");
                int[] selectRows = entry.getSelectRows();
                if (selectRows == null || selectRows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"KitSalesPlugin_42", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                ArrayList<Integer> parentsRowIndexs = new ArrayList<Integer>();
                ArrayList<String> materialList = new ArrayList<String>();
                ArrayList<Integer> childRowIndexs = new ArrayList<Integer>();
                for (int rowIndex : selectRows) {
                    String productType = (String)this.getModel().getValue("producttype", rowIndex);
                    if (ProductTypeEnum.KITPARENT.getValue().equals(productType)) {
                        parentsRowIndexs.add(rowIndex);
                        DynamicObject material3 = (DynamicObject)this.getModel().getValue("material", rowIndex);
                        if (material3 == null || material3.getDynamicObject("masterid") == null) continue;
                        DynamicObject masterid = material3.getDynamicObject("masterid");
                        materialCode = masterid.getString("number");
                        materialName = masterid.getString("name");
                        StringBuilder materialInfo = new StringBuilder();
                        materialInfo.append(materialName);
                        materialInfo.append('\uff08');
                        materialInfo.append(materialCode);
                        materialInfo.append('\uff09');
                        materialList.add(materialInfo.toString());
                        continue;
                    }
                    if (!ProductTypeEnum.KITCHILD.getValue().equals(productType)) continue;
                    childRowIndexs.add(rowIndex);
                }
                ArrayList<String> oldCancelRows = new ArrayList<String>();
                HashSet<String> changeTypeNumber = new HashSet<String>(8);
                if ("sm_xssalorder".equals(entityId)) {
                    for (int rowIndex : selectRows) {
                        String changeType = (String)this.getModel().getValue("entrychangetype", rowIndex);
                        if (ChangeTypeEnum.CANCEL.getValue().equals(changeType)) {
                            oldCancelRows.add(String.valueOf(rowIndex));
                        }
                        changeTypeNumber.add(changeType);
                    }
                }
                if (parentsRowIndexs != null && !parentsRowIndexs.isEmpty()) {
                    if (isOrderOrXOrder.booleanValue() || isNewReturn.booleanValue()) {
                        if ("sm_xssalorder".equals(entityId)) {
                            this.getPageCache().put(DELETEROWNOTSHOWMSG, "true");
                        }
                        args.setCancel(true);
                        this.showConfirmDeleteParentRow(parentsRowIndexs, materialList);
                        if (oldCancelRows != null && !oldCancelRows.isEmpty()) {
                            this.getPageCache().put("XOrderOldCancelRows", String.join((CharSequence)",", oldCancelRows));
                        } else {
                            this.getPageCache().remove("XOrderOldCancelRows");
                        }
                        return;
                    }
                    if (isDeliver.booleanValue() || isDrawReturn.booleanValue()) {
                        String materialName2;
                        String materialCode2;
                        ArrayList<Integer> kitTransferIndexs = new ArrayList<Integer>();
                        ArrayList<String> kitMaterialList = new ArrayList<String>();
                        for (Integer rowIndex : parentsRowIndexs) {
                            String transferModel = (String)this.getModel().getValue("kittransfermodel", rowIndex.intValue());
                            if (!KitTransferModelEnum.KIT.getValue().equals(transferModel)) continue;
                            kitTransferIndexs.add(rowIndex);
                            DynamicObject material4 = (DynamicObject)this.getModel().getValue("material", rowIndex.intValue());
                            if (material4 == null || material4.getDynamicObject("masterid") == null) continue;
                            DynamicObject masterid = material4.getDynamicObject("masterid");
                            materialCode2 = masterid.getString("number");
                            materialName2 = masterid.getString("name");
                            StringBuilder materialInfo = new StringBuilder();
                            materialInfo.append(materialName2);
                            materialInfo.append('\uff08');
                            materialInfo.append(materialCode2);
                            materialInfo.append('\uff09');
                            kitMaterialList.add(materialInfo.toString());
                        }
                        if (kitTransferIndexs != null && !kitTransferIndexs.isEmpty()) {
                            args.setCancel(true);
                            this.showConfirmDeleteParentRow(kitTransferIndexs, kitMaterialList);
                            return;
                        }
                        if (childRowIndexs != null && !childRowIndexs.isEmpty()) {
                            boolean isCancel = false;
                            for (Integer rowIndex : childRowIndexs) {
                                String transferModel = (String)this.getModel().getValue("kittransfermodel", rowIndex.intValue());
                                if (!KitTransferModelEnum.KIT.getValue().equals(transferModel)) continue;
                                DynamicObject material5 = (DynamicObject)this.getModel().getValue("material", rowIndex.intValue());
                                materialCode2 = KitSalesHelper.getMaterialCode((DynamicObject)material5);
                                materialName2 = KitSalesHelper.getMaterialName((DynamicObject)material5);
                                if ("sm_delivernotice".equals(entityId)) {
                                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c%2$s\uff08%3$s\uff09\uff0c\u5bf9\u5e94\u7236\u9879\u4ea7\u54c1\u7684\u5957\u4ef6\u53d1\u8d27\u65b9\u5f0f\u4e3a\u201c\u6210\u5957\u53d1\u8d27\u201d\u65f6\uff0c\u4e0d\u5141\u8bb8\u5355\u72ec\u5220\u9664\u5b50\u9879\u4ea7\u54c1\u3002", (String)"KitSalesPlugin_10", (String)"scmc-sm-formplugin", (Object[])new Object[0]), rowIndex + 1, materialName2, materialCode2));
                                } else {
                                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c%2$s\uff08%3$s\uff09\uff0c\u5bf9\u5e94\u7236\u9879\u4ea7\u54c1\u7684\u5957\u4ef6\u9000\u8d27\u65b9\u5f0f\u4e3a\u201c\u6210\u5957\u9000\u8d27\u201d\u65f6\uff0c\u4e0d\u5141\u8bb8\u5355\u72ec\u5220\u9664\u5b50\u9879\u4ea7\u54c1\u3002", (String)"KitSalesPlugin_11", (String)"scmc-sm-formplugin", (Object[])new Object[0]), rowIndex + 1, materialName2, materialCode2));
                                }
                                isCancel = true;
                                break;
                            }
                            if (isCancel) {
                                args.setCancel(true);
                                return;
                            }
                        }
                    }
                    break block117;
                }
                if (childRowIndexs == null || childRowIndexs.isEmpty()) break block117;
                if (isOrderOrXOrder.booleanValue() || isNewReturn.booleanValue()) {
                    if (changeTypeNumber.size() > 1) {
                        return;
                    }
                    Iterator kitTransferIndexs = childRowIndexs.iterator();
                    while (kitTransferIndexs.hasNext()) {
                        int rowIndex;
                        rowIndex = (Integer)kitTransferIndexs.next();
                        DynamicObject parentRow = this.getParentEntry(rowIndex);
                        if (parentRow == null) continue;
                        DynamicObject kitBom = parentRow.getDynamicObject("bom");
                        material = parentRow.getDynamicObject("material");
                        if (kitBom == null || material == null || !KitStructCtlEnum.NONADJ.getValue().equals(material.getString("kitstructctl"))) continue;
                        materialCode = KitSalesHelper.getMaterialCode((DynamicObject)material);
                        materialName = KitSalesHelper.getMaterialName((DynamicObject)material);
                        DynamicObject childMaterial = (DynamicObject)this.getModel().getValue("material", rowIndex);
                        String childMaterialCode = KitSalesHelper.getMaterialCode((DynamicObject)childMaterial);
                        String childMaterialName = KitSalesHelper.getMaterialName((DynamicObject)childMaterial);
                        String showMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff1a%2$s\uff08%3$s\uff09\uff0c\u5bf9\u5e94\u5957\u4ef6\u7236\u9879\u201c%4$s\u201d\u5728\u7269\u6599\u9500\u552e\u4fe1\u606f\u4e2d\u5355\u636e\u5957\u4ef6\u7ed3\u6784\u63a7\u5236\u4e3a\u201c\u53ef\u8c03\u6574\u201d\u65f6\uff0c\u624d\u5141\u8bb8\u5220\u884c\u3002", (String)"KitSalesPlugin_33", (String)"scmc-sm-formplugin", (Object[])new Object[0]), rowIndex + 1, childMaterialName, childMaterialCode, materialCode);
                        this.getView().showTipNotification(showMsg);
                        args.setCancel(true);
                        this.getPageCache().put(ISCANCELDELROWBECBOM, "true");
                        if (oldCancelRows != null && !oldCancelRows.isEmpty()) {
                            this.getPageCache().put("XOrderOldCancelRows", String.join((CharSequence)",", oldCancelRows));
                        } else {
                            this.getPageCache().remove("XOrderOldCancelRows");
                        }
                        return;
                    }
                    this.getPageCache().put(ISCANCELDELROWBECBOM, "false");
                    break block117;
                }
                if (isDeliver.booleanValue() || isDrawReturn.booleanValue()) {
                    boolean isCancel = false;
                    for (Integer rowIndex : childRowIndexs) {
                        String transferModel = (String)this.getModel().getValue("kittransfermodel", rowIndex.intValue());
                        if (!KitTransferModelEnum.KIT.getValue().equals(transferModel)) continue;
                        material = (DynamicObject)this.getModel().getValue("material", rowIndex.intValue());
                        materialCode = KitSalesHelper.getMaterialCode((DynamicObject)material);
                        materialName = KitSalesHelper.getMaterialName((DynamicObject)material);
                        if ("sm_delivernotice".equals(entityId)) {
                            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c%2$s\uff08%3$s\uff09\uff0c\u5bf9\u5e94\u7236\u9879\u4ea7\u54c1\u7684\u5957\u4ef6\u53d1\u8d27\u65b9\u5f0f\u4e3a\u201c\u6210\u5957\u53d1\u8d27\u201d\u65f6\uff0c\u4e0d\u5141\u8bb8\u5355\u72ec\u5220\u9664\u5b50\u9879\u4ea7\u54c1\u3002", (String)"KitSalesPlugin_10", (String)"scmc-sm-formplugin", (Object[])new Object[0]), rowIndex + 1, materialName, materialCode));
                        } else {
                            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c%2$s\uff08%3$s\uff09\uff0c\u5bf9\u5e94\u7236\u9879\u4ea7\u54c1\u7684\u5957\u4ef6\u9000\u8d27\u65b9\u5f0f\u4e3a\u201c\u6210\u5957\u9000\u8d27\u201d\u65f6\uff0c\u4e0d\u5141\u8bb8\u5355\u72ec\u5220\u9664\u5b50\u9879\u4ea7\u54c1\u3002", (String)"KitSalesPlugin_11", (String)"scmc-sm-formplugin", (Object[])new Object[0]), rowIndex + 1, materialName, materialCode));
                        }
                        isCancel = true;
                        break;
                    }
                    if (isCancel) {
                        args.setCancel(true);
                        return;
                    }
                }
            }
        }
        super.beforeDoOperation(args);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (!KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) {
            return;
        }
        try (TraceSpan span = Tracer.create((String)"KitSalesPlugin", (String)("afterDoOperation: " + afterDoOperationEventArgs.getOperateKey()));){
            String operateKey;
            switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
                case "newchild": {
                    if (!this.isNewChildOp()) {
                        return;
                    }
                    EntryGrid entry = (EntryGrid)this.getControl("billentry");
                    if (entry.getSelectRows().length > 0) {
                        int rowIndex = entry.getSelectRows()[0];
                        if (rowIndex >= 0) {
                            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"material"});
                        }
                        this.getView().updateView("orderdeliverentry");
                    }
                    this.clearMarkNewChildOp();
                    return;
                }
                case "expandkit": {
                    AbstractGrid billEntry = (AbstractGrid)this.getControl("billentry");
                    int[] selectRows = ((EntryGrid)billEntry).getSelectRows();
                    HashMap<Integer, Long> rowIndexAndBomIdMap = new HashMap<Integer, Long>();
                    HashMap<Integer, Long> rowIndexAndMalIdMap = new HashMap<Integer, Long>();
                    Boolean hasParentRow = Boolean.FALSE;
                    ArrayList<String> hasChildRowIndex = new ArrayList<String>();
                    for (int rowIndex : selectRows) {
                        String productType = (String)this.getModel().getValue("producttype", rowIndex);
                        if (!ProductTypeEnum.KITPARENT.getValue().equals(productType)) continue;
                        hasParentRow = Boolean.TRUE;
                        if (this.hasKitChild(rowIndex)) {
                            hasChildRowIndex.add(String.valueOf(rowIndex + 1));
                        }
                        DynamicObject kitBom = (DynamicObject)this.getModel().getValue("bom", rowIndex);
                        DynamicObject material = (DynamicObject)this.getModel().getValue("material", rowIndex);
                        if (kitBom != null && kitBom.getPkValue() != null) {
                            rowIndexAndBomIdMap.put(rowIndex, (Long)kitBom.getPkValue());
                            continue;
                        }
                        if (material != null && material.getPkValue() != null && material.containsProperty("masterid") && material.getDynamicObject("masterid") != null) {
                            rowIndexAndMalIdMap.put(rowIndex, (Long)material.getDynamicObject("masterid").getPkValue());
                            continue;
                        }
                        String showMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u5c55\u5f00\u5b50\u9879\u5931\u8d25\uff0c\u8bf7\u7ef4\u62a4\u7269\u6599\u7f16\u7801\u540e\u91cd\u8bd5\u3002", (String)"KitSalesPlugin_24", (String)"scmc-sm-formplugin", (Object[])new Object[0]), rowIndex + 1);
                        this.getView().showTipNotification(showMsg);
                        return;
                    }
                    if (!hasParentRow.booleanValue()) {
                        String showMsg = ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u4ea7\u54c1\u7c7b\u522b\u4e3a\u201c\u5957\u4ef6\u7236\u9879\u201d\u7684\u7269\u6599\u660e\u7ec6\u884c\u3002", (String)"KitSalesPlugin_25", (String)"scmc-sm-formplugin", (Object[])new Object[0]);
                        this.getView().showTipNotification(showMsg);
                        return;
                    }
                    if (hasChildRowIndex != null && !hasChildRowIndex.isEmpty()) {
                        String msg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u5df2\u5b58\u5728\u5b50\u9879\uff0c\u662f\u5426\u8986\u76d6\uff1f", (String)"KitSalesPlugin_26", (String)"scmc-sm-formplugin", (Object[])new Object[0]), String.join((CharSequence)"\u3001", hasChildRowIndex));
                        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(EXPANDKITBOMCONFIRM, (IFormPlugin)this);
                        MessageBoxOptions options = MessageBoxOptions.YesNo;
                        this.getView().showConfirm(msg, "", options, ConfirmTypes.Default, confirmCallBacks);
                        return;
                    }
                    this.expandkitFunction();
                    return;
                }
                case "deleteentry": {
                    String top_deleterow = this.getPageCache().get("top_deleterow");
                    if (!StringUtils.isNotEmpty((CharSequence)top_deleterow)) return;
                    int index = Integer.parseInt(top_deleterow);
                    EntryGrid entryX = (EntryGrid)this.getControl("billentry");
                    entryX.getEntryState().selectRow(index - 1);
                    entryX.selectRows(index - 1);
                    entryX.getEntryState().setFocusRow(index - 1);
                    this.getPageCache().remove("top_deleterow");
                    return;
                }
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void expandkitFunction() {
        AbstractGrid billEntry = (AbstractGrid)this.getControl("billentry");
        int[] selectRows = ((EntryGrid)billEntry).getSelectRows();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            return;
        }
        DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
        if (bizType == null) {
            return;
        }
        String bizTypeNumber = bizType.getString("number");
        String entityId = this.getView().getEntityId();
        int allErrorNumber = 0;
        ArrayList<String> allErrorMsgs = new ArrayList<String>();
        HashMap<Integer, Long> rowIndexAndMalIdMap = new HashMap<Integer, Long>();
        for (int rowIndex : selectRows) {
            String productType = (String)this.getModel().getValue("producttype", rowIndex);
            if (!ProductTypeEnum.KITPARENT.getValue().equals(productType)) continue;
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue("bom", rowIndex);
            DynamicObject material = (DynamicObject)this.getModel().getValue("material", rowIndex);
            boolean isCanExpand = true;
            if ("sm_xsalorder".equals(entityId) || "sm_xssalorder".equals(entityId)) {
                String changeType = (String)this.getModel().getValue("entrychangetype", rowIndex);
                if (ChangeTypeEnum.CANCEL.getValue().equals(changeType)) {
                    isCanExpand = false;
                }
                if (!ChangeTypeEnum.CANCEL.getValue().equals(changeType) && (isCanExpand = this.isHasPushedData(isCanExpand, rowIndex))) {
                    Integer childIndex;
                    List<Integer> childIndexList = this.getAllChildEntry(rowIndex);
                    Iterator<Integer> iterator = childIndexList.iterator();
                    while (iterator.hasNext() && (isCanExpand = this.isHasPushedData(isCanExpand, childIndex = iterator.next()))) {
                    }
                }
            }
            if (dynamicObject != null || !isCanExpand || material == null || material.getPkValue() == null || !material.containsProperty("masterid") || material.getDynamicObject("masterid") == null) continue;
            rowIndexAndMalIdMap.put(rowIndex, (Long)material.getDynamicObject("masterid").getPkValue());
        }
        HashMap<Long, Long> malToBomIDMap = new HashMap<Long, Long>();
        QFilter bomCurlFilter = BaseDataServiceHelper.getBaseDataFilter((String)"msbd_kitbom", (Long)((Long)org.getPkValue()));
        QFilter bomStatusFilter = new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue());
        QFilter bomEnableFilter = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        this.getModel().beginInit();
        if (rowIndexAndMalIdMap != null && !rowIndexAndMalIdMap.isEmpty()) {
            for (Map.Entry entry : rowIndexAndMalIdMap.entrySet()) {
                int rowIndex = (Integer)entry.getKey();
                Long materialId = (Long)entry.getValue();
                Long bomId = (Long)malToBomIDMap.get(materialId);
                if (bomId != null) {
                    this.getModel().setValue("bom", (Object)bomId, rowIndex);
                    continue;
                }
                QFilter bomMaterialFilter = new QFilter("material.id", "=", entry.getValue());
                Map result = BusinessDataServiceHelper.loadFromCache((String)"msbd_kitbom", (String)"id,material.id,createorg.id,createtime", (QFilter[])new QFilter[]{bomCurlFilter, bomStatusFilter, bomEnableFilter, bomMaterialFilter}, (String)"createtime desc");
                if (result != null && !result.isEmpty()) {
                    DynamicObject bomInfo = (DynamicObject)result.entrySet().iterator().next().getValue();
                    bomId = bomInfo.getLong("id");
                    malToBomIDMap.put(materialId, bomId);
                    this.getModel().setValue("bom", (Object)bomId, rowIndex);
                    continue;
                }
                DynamicObject material = (DynamicObject)this.getModel().getValue("material", rowIndex);
                String materialCode = KitSalesHelper.getMaterialCode((DynamicObject)material);
                String materialName = KitSalesHelper.getMaterialName((DynamicObject)material);
                String showMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff1a%2$s\uff08%3$s\uff09\uff0c\u672a\u83b7\u53d6\u5230\u53ef\u7528\u3001\u5df2\u5ba1\u6838\u7684BOM\u7f16\u7801\uff0c\u5c55\u5f00\u5b50\u9879\u5931\u8d25\uff0c\u8bf7\u7ef4\u62a4\u540e\u91cd\u8bd5\u3002", (String)"KitSalesPlugin_30", (String)"scmc-sm-formplugin", (Object[])new Object[0]), rowIndex + 1, materialName, materialCode);
                if (allErrorNumber > 50) continue;
                allErrorMsgs.add(showMsg);
                ++allErrorNumber;
            }
        }
        this.getModel().endInit();
        HashMap<Integer, Long> rowIndexAndBomIdMap = new HashMap<Integer, Long>(8);
        HashMap<Long, String> hashMap = new HashMap<Long, String>(8);
        HashSet<Long> bomIdSet = new HashSet<Long>(8);
        for (int rowIndex : selectRows) {
            DynamicObject kitBom;
            String productType = (String)this.getModel().getValue("producttype", rowIndex);
            if (!ProductTypeEnum.KITPARENT.getValue().equals(productType)) continue;
            if ("sm_xsalorder".equals(entityId) || "sm_xssalorder".equals(entityId)) {
                DynamicObject material = (DynamicObject)this.getModel().getValue("material", rowIndex);
                String materialCode = KitSalesHelper.getMaterialCode((DynamicObject)material);
                String materialName = KitSalesHelper.getMaterialName((DynamicObject)material);
                String changeType = (String)this.getModel().getValue("entrychangetype", rowIndex);
                if (ChangeTypeEnum.CANCEL.getValue().equals(changeType)) {
                    String showMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff1a%2$s\uff08%3$s\uff09\uff0c\u53d6\u6d88\u884c\u4e0d\u5141\u8bb8\u5c55\u5f00\u5b50\u9879\u3002", (String)"KitSalesPlugin_40", (String)"scmc-sm-formplugin", (Object[])new Object[0]), rowIndex + 1, materialName, materialCode);
                    if (allErrorNumber > 50) continue;
                    allErrorMsgs.add(showMsg);
                    ++allErrorNumber;
                    continue;
                }
                if (!ChangeTypeEnum.CANCEL.getValue().equals(changeType)) {
                    boolean isCanExpand = true;
                    if (isCanExpand = this.isHasPushedData(isCanExpand, rowIndex)) {
                        Integer childIndex;
                        List<Integer> childIndexList = this.getAllChildEntry(rowIndex);
                        Iterator<Integer> iterator = childIndexList.iterator();
                        while (iterator.hasNext() && (isCanExpand = this.isHasPushedData(isCanExpand, childIndex = iterator.next()))) {
                        }
                    }
                    if (!isCanExpand) {
                        String showMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff1a%2$s\uff08%3$s\uff09\uff0c\u5df2\u53d1\u751f\u4e0b\u6e38\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u5c55\u5f00\u5b50\u9879\u3002", (String)"KitSalesPlugin_41", (String)"scmc-sm-formplugin", (Object[])new Object[0]), rowIndex + 1, materialName, materialCode);
                        if (allErrorNumber > 50) continue;
                        allErrorMsgs.add(showMsg);
                        ++allErrorNumber;
                        continue;
                    }
                }
            }
            if ((kitBom = (DynamicObject)this.getModel().getValue("bom", rowIndex)) == null || kitBom.getPkValue() == null) continue;
            rowIndexAndBomIdMap.put(rowIndex, (Long)kitBom.getPkValue());
            String rowIndexStr = (String)hashMap.get((Long)kitBom.getPkValue());
            if (rowIndexStr == null) {
                rowIndexStr = "";
            }
            hashMap.put((Long)kitBom.getPkValue(), rowIndexStr + (rowIndex + 1) + ",");
            bomIdSet.add((Long)kitBom.getPkValue());
        }
        if (!rowIndexAndBomIdMap.isEmpty() && rowIndexAndBomIdMap.size() > 500) {
            String showMsg = ResManager.loadKDString((String)"\u5c55\u5f00\u884c\u6570\u8fc7\u591a\uff0c\u8bf7\u51cf\u5c11\u9009\u4e2d\u884c\u6570\u3002", (String)"KitSalesPlugin_27", (String)"scmc-sm-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(showMsg);
            return;
        }
        if (!rowIndexAndBomIdMap.isEmpty()) {
            ArrayList bomIdList = new ArrayList(bomIdSet);
            Date bizDate = (Date)this.getModel().getValue("bizdate");
            if (bizDate == null) {
                bizDate = new Date();
            }
            HashMap<String, Comparable<Integer>> parameters = new HashMap<String, Comparable<Integer>>();
            parameters.put("expandLevel", Integer.valueOf(1));
            parameters.put("expandDate", bizDate);
            parameters.put("expandOrgId", (Long)org.getPkValue());
            List expandBomDataList = SCMCBomHelper.expandKitBOM(bomIdList, parameters);
            HashMap<Long, SCMCBomExpandData> expandBomSuccessDataMap = new HashMap<Long, SCMCBomExpandData>();
            ArrayList<String> errorBomMsgs = new ArrayList<String>();
            ArrayList<Long> errorBomIds = new ArrayList<Long>();
            Boolean isError = Boolean.FALSE;
            if (expandBomDataList != null && !expandBomDataList.isEmpty()) {
                Integer[] temp;
                for (SCMCBomExpandData expandBomData : expandBomDataList) {
                    if (expandBomData == null) continue;
                    if ("FAIL".equals(expandBomData.getResultStatus())) {
                        errorBomMsgs.add(expandBomData.getResultMsg());
                        errorBomIds.add(expandBomData.getBomId());
                        isError = Boolean.TRUE;
                        continue;
                    }
                    expandBomSuccessDataMap.put(expandBomData.getBomId(), expandBomData);
                }
                if (isError.booleanValue()) {
                    int errBomLineSize = errorBomIds.size() > errorBomMsgs.size() ? errorBomMsgs.size() : errorBomIds.size();
                    for (int i = 0; i < errBomLineSize; ++i) {
                        Long bomId = (Long)errorBomIds.get(i);
                        String msg = (String)errorBomMsgs.get(i);
                        if (bomId != null && hashMap.get(bomId) != null) {
                            String rowIndexString = (String)hashMap.get(bomId);
                            rowIndexString = rowIndexString.substring(0, rowIndexString.length() - 1);
                            String showMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u5c55\u5f00\u5b50\u9879\u5931\u8d25\uff1a", (String)"KitSalesPlugin_21", (String)"scmc-sm-formplugin", (Object[])new Object[0]), rowIndexString);
                            if (allErrorNumber > 50) continue;
                            allErrorMsgs.add((String)showMsg + msg);
                            ++allErrorNumber;
                            continue;
                        }
                        String showMsg = ResManager.loadKDString((String)"\u5c55\u5f00\u5b50\u9879\u5931\u8d25\uff1a", (String)"KitSalesPlugin_22", (String)"scmc-sm-formplugin", (Object[])new Object[0]);
                        if (allErrorNumber > 50) continue;
                        allErrorMsgs.add(showMsg + msg);
                        ++allErrorNumber;
                    }
                }
                HashMap<Long, DynamicObject> materialSalInfoMap = new HashMap<Long, DynamicObject>(8);
                ArrayList<Long> materialIdList = new ArrayList<Long>();
                for (SCMCBomExpandData expandBomData : expandBomDataList) {
                    List entryDataList;
                    if (expandBomData == null || "FAIL".equals(expandBomData.getResultStatus()) || (entryDataList = expandBomData.getEntryDataList()) == null || entryDataList.isEmpty()) continue;
                    for (SCMCBomEntryData entryBomData : entryDataList) {
                        if (entryBomData.getEntryMaterialId() == null) continue;
                        materialIdList.add(entryBomData.getEntryMaterialId());
                    }
                }
                QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialsalinfo", (Long)((Long)org.getPkValue()));
                QFilter materialFilter = new QFilter("masterid.id", "in", materialIdList);
                QFilter statusFilter = new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue());
                QFilter enableFilter = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
                QFilter suiteFilter = new QFilter("masterid.suite", "=", (Object)Boolean.FALSE);
                QFilter priceModelFilter = new QFilter("pricemodel", "=", (Object)BLANK);
                QFilter kitTransferModelFilter = new QFilter("kittransfermodel", "=", (Object)BLANK);
                QFilter kitReturnModelFilter = new QFilter("kitreturnmodel", "=", (Object)BLANK);
                QFilter kitStructCtlFilter = new QFilter("kitstructctl", "=", (Object)BLANK);
                suiteFilter = suiteFilter.and(priceModelFilter).and(kitTransferModelFilter).and(kitReturnModelFilter).and(kitStructCtlFilter);
                Map result = BusinessDataServiceHelper.loadFromCache((String)"bd_materialsalinfo", (String)"id,masterid.id,masterid.serviceattribute,createorg.id", (QFilter[])new QFilter[]{baseDataFilter, materialFilter, statusFilter, enableFilter, suiteFilter});
                Set entrySet = result.entrySet();
                for (Map.Entry materialEntry : entrySet) {
                    DynamicObject materialSalInfo = (DynamicObject)materialEntry.getValue();
                    materialSalInfoMap.put(materialSalInfo.getLong("masterid.id"), materialSalInfo);
                }
                for (Map.Entry rowIndexAndBomIdEntry : rowIndexAndBomIdMap.entrySet()) {
                    int rowIndex = (Integer)rowIndexAndBomIdEntry.getKey();
                    Long rowBomId = (Long)rowIndexAndBomIdEntry.getValue();
                    DynamicObject material = (DynamicObject)this.getModel().getValue("material", rowIndex);
                    String string = KitSalesHelper.getMaterialCode((DynamicObject)material);
                    String materialName = KitSalesHelper.getMaterialName((DynamicObject)material);
                    SCMCBomExpandData expandBomData = (SCMCBomExpandData)expandBomSuccessDataMap.get(rowBomId);
                    if (expandBomData == null) continue;
                    List entryDataList = expandBomData.getEntryDataList();
                    if (entryDataList != null && !entryDataList.isEmpty()) {
                        int canExpandRow = 0;
                        for (Object entryBomData : entryDataList) {
                            String showMsg;
                            Long entryMaterialId = entryBomData.getEntryMaterialId();
                            String entryMaterialNumber = entryBomData.getEntryMaterialNumber();
                            String entryMaterialName = entryBomData.getEntryMaterialName();
                            Date validDate = entryBomData.getEntryValidDate();
                            Date invalidDate = entryBomData.getEntryInvalidDate();
                            if (validDate != null && invalidDate != null && (bizDate.before(validDate) || bizDate.after(invalidDate))) {
                                String errorRowMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff1a%2$s\uff08%3$s\uff09\uff0c\u5bf9\u5e94%4$s\uff08%5$s\uff09\u5b50\u9879\u5c55\u5f00\u5931\u8d25\uff0c\u4e0d\u5728\u751f\u6548\u65e5\u671f\u8303\u56f4\u5185\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"KitSalesPlugin_34", (String)"scmc-sm-formplugin", (Object[])new Object[0]), rowIndex + 1, materialName, string, entryMaterialName, entryMaterialNumber);
                                if (allErrorNumber > 50) continue;
                                allErrorMsgs.add(errorRowMsg);
                                ++allErrorNumber;
                                continue;
                            }
                            ++canExpandRow;
                            DynamicObject entryMaterial = (DynamicObject)materialSalInfoMap.get(entryMaterialId);
                            if (entryMaterial == null) {
                                String showMsg2 = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff1a%2$s\uff08%3$s\uff09\uff0c\u5bf9\u5e94%4$s\uff08%5$s\uff09\u5b50\u9879\u5c55\u5f00\u5931\u8d25\uff0c\u5b50\u9879\u4e0d\u6ee1\u8db3\u7269\u6599\u4e3b\u6570\u636e.\u5957\u4ef6=\u5426\uff0c\u7269\u6599\u9500\u552e\u4fe1\u606f\u5b58\u5728\u3001\u53ef\u7528\u3001\u5df2\u5ba1\u6838\u4e14\u5b9a\u4ef7\u65b9\u5f0f/\u5957\u4ef6\u53d1\u8d27\u65b9\u5f0f/\u5957\u4ef6\u9000\u8d27\u65b9\u5f0f/\u5355\u636e\u5957\u4ef6\u7ed3\u6784\u63a7\u5236\u90fd\u5fc5\u987b\u4e3a\u7a7a\uff0c\u9500\u552e\u7ec4\u7ec7\u6709\u7269\u6599\u9500\u552e\u4fe1\u606f\u7684\u4f7f\u7528\u6743\u9650\u3002", (String)"KitSalesPlugin_29", (String)"scmc-sm-formplugin", (Object[])new Object[0]), rowIndex + 1, materialName, string, entryMaterialName, entryMaterialNumber);
                                if (allErrorNumber > 50) continue;
                                allErrorMsgs.add(showMsg2);
                                ++allErrorNumber;
                                continue;
                            }
                            DynamicObjectCollection materialServiceattribute = entryMaterial.getDynamicObjectCollection("masterid.serviceattribute");
                            List serviceattributeIds = materialServiceattribute.stream().map(dym -> dym.get("fbasedataid_id")).collect(Collectors.toList());
                            if ("210".equals(bizTypeNumber) || "2101".equals(bizTypeNumber) || "2102".equals(bizTypeNumber)) {
                                if (serviceattributeIds.contains(BillTplEntryConst.MASTERSERVICEATTRIBUTE_1001) || serviceattributeIds.contains(BillTplEntryConst.MASTERSERVICEATTRIBUTE_2001)) continue;
                                showMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff1a%2$s\uff08%3$s\uff09\uff0c\u5bf9\u5e94%4$s\uff08%5$s\uff09\u5b50\u9879\u5c55\u5f00\u5931\u8d25\uff0c\u5b50\u9879\u4e0d\u7b26\u5408\u5f53\u524d\u4e1a\u52a1\u7c7b\u578b\u53ef\u9009\u7684\u884c\u7c7b\u578b\u3002", (String)"KitSalesPlugin_32", (String)"scmc-sm-formplugin", (Object[])new Object[0]), rowIndex + 1, materialName, string, entryMaterialName, entryMaterialNumber);
                                if (allErrorNumber > 50) continue;
                                allErrorMsgs.add(showMsg);
                                ++allErrorNumber;
                                continue;
                            }
                            if ("212".equals(bizTypeNumber)) {
                                if (serviceattributeIds.contains(BillTplEntryConst.MASTERSERVICEATTRIBUTE_2001)) continue;
                                showMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff1a%2$s\uff08%3$s\uff09\uff0c\u5bf9\u5e94%4$s\uff08%5$s\uff09\u5b50\u9879\u5c55\u5f00\u5931\u8d25\uff0c\u5b50\u9879\u4e0d\u7b26\u5408\u5f53\u524d\u4e1a\u52a1\u7c7b\u578b\u53ef\u9009\u7684\u884c\u7c7b\u578b\u3002", (String)"KitSalesPlugin_32", (String)"scmc-sm-formplugin", (Object[])new Object[0]), rowIndex + 1, materialName, string, entryMaterialName, entryMaterialNumber);
                                if (allErrorNumber > 50) continue;
                                allErrorMsgs.add(showMsg);
                                ++allErrorNumber;
                                continue;
                            }
                            showMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff1a%2$s\uff08%3$s\uff09\uff0c\u5bf9\u5e94%4$s\uff08%5$s\uff09\u5b50\u9879\u5c55\u5f00\u5931\u8d25\uff0c\u5b50\u9879\u4e0d\u7b26\u5408\u5f53\u524d\u4e1a\u52a1\u7c7b\u578b\u53ef\u9009\u7684\u884c\u7c7b\u578b\u3002", (String)"KitSalesPlugin_32", (String)"scmc-sm-formplugin", (Object[])new Object[0]), rowIndex + 1, materialName, string, entryMaterialName, entryMaterialNumber);
                            if (allErrorNumber > 50) continue;
                            allErrorMsgs.add(showMsg);
                            ++allErrorNumber;
                        }
                        if (canExpandRow != 0) continue;
                        String showMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff1a%2$s\uff08%3$s\uff09\uff0c\u5c55\u5f00\u5b50\u9879\u5931\u8d25\uff0c\u5fc5\u987b\u6ee1\u8db3BOM\u7f16\u7801\u5b58\u5728\u3001\u53ef\u7528\u3001\u5df2\u5ba1\u6838\u3001\u81f3\u5c11\u6709\u4e00\u884c\u5b50\u9879\u6709\u6548\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"KitSalesPlugin_28", (String)"scmc-sm-formplugin", (Object[])new Object[0]), rowIndex + 1, materialName, string);
                        if (allErrorNumber > 50) continue;
                        allErrorMsgs.add(showMsg);
                        ++allErrorNumber;
                        continue;
                    }
                    String showMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff1a%2$s\uff08%3$s\uff09\uff0c\u5c55\u5f00\u5b50\u9879\u5931\u8d25\uff0c\u5fc5\u987b\u6ee1\u8db3BOM\u7f16\u7801\u5b58\u5728\u3001\u53ef\u7528\u3001\u5df2\u5ba1\u6838\u3001\u81f3\u5c11\u6709\u4e00\u884c\u5b50\u9879\u6709\u6548\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"KitSalesPlugin_28", (String)"scmc-sm-formplugin", (Object[])new Object[0]), rowIndex + 1, materialName, string);
                    if (allErrorNumber > 50) continue;
                    allErrorMsgs.add(showMsg);
                    ++allErrorNumber;
                }
                if (allErrorMsgs != null && !allErrorMsgs.isEmpty()) {
                    String errorDateRowMsg = String.join((CharSequence)"\n", allErrorMsgs);
                    String title = ResManager.loadKDString((String)"\u5c55\u5f00\u5b50\u9879\u5b58\u5728\u5931\u8d25", (String)"KitSalesPlugin_35", (String)"scmc-sm-formplugin", (Object[])new Object[0]);
                    this.getView().showConfirm(title, errorDateRowMsg, MessageBoxOptions.OK, ConfirmTypes.Fail, null);
                }
                int addRow = 0;
                ArrayList<Integer> needDeleteChildRowList = new ArrayList<Integer>();
                ArrayList<Integer> needDeleteChildRowModiList = new ArrayList<Integer>();
                ArrayList<Integer> needDeleteChildRowAddList = new ArrayList<Integer>();
                for (Map.Entry entry : rowIndexAndBomIdMap.entrySet()) {
                    List entryDataList;
                    int rowIndex = (Integer)entry.getKey();
                    Long rowBomId = (Long)entry.getValue();
                    int parentRowIndex = rowIndex + addRow;
                    int oldChildNum = 0;
                    List<Integer> oldChildRowIndexList = this.getAllChildEntry(parentRowIndex);
                    if (oldChildRowIndexList != null && !oldChildRowIndexList.isEmpty()) {
                        oldChildNum = oldChildRowIndexList.size();
                        if ("sm_xssalorder".equals(entityId)) {
                            for (Integer childIndex : oldChildRowIndexList) {
                                String changeType = (String)this.getModel().getValue("entrychangetype", childIndex.intValue());
                                if (ChangeTypeEnum.UPDATE.getValue().equals(changeType)) {
                                    needDeleteChildRowModiList.add(childIndex);
                                    continue;
                                }
                                if (!ChangeTypeEnum.ADDNEW.getValue().equals(changeType)) continue;
                                needDeleteChildRowAddList.add(childIndex);
                            }
                        } else {
                            needDeleteChildRowList.addAll(oldChildRowIndexList);
                        }
                    }
                    this.genPID(parentRowIndex);
                    this.getView().setEnable(Boolean.FALSE, parentRowIndex, new String[]{"material"});
                    BigDecimal parentBaseQty = (BigDecimal)this.getModel().getValue("baseqty", parentRowIndex);
                    SCMCBomExpandData expandBomData = (SCMCBomExpandData)expandBomSuccessDataMap.get(rowBomId);
                    if (expandBomData == null || (entryDataList = expandBomData.getEntryDataList()) == null || entryDataList.isEmpty()) continue;
                    for (SCMCBomEntryData entryBomData : entryDataList) {
                        Long entryMaterialId = entryBomData.getEntryMaterialId();
                        BigDecimal kitQty = entryBomData.getEntryQtyNumerator();
                        BigDecimal parentQty = entryBomData.getEntryQtyDenominator();
                        Date validDate = entryBomData.getEntryValidDate();
                        Date invalidDate = entryBomData.getEntryInvalidDate();
                        if (validDate != null && invalidDate != null && (bizDate.before(validDate) || bizDate.after(invalidDate))) continue;
                        DynamicObject entryMaterial = (DynamicObject)materialSalInfoMap.get(entryMaterialId);
                        if (entryMaterial != null) {
                            DynamicObjectCollection materialServiceattribute = entryMaterial.getDynamicObjectCollection("masterid.serviceattribute");
                            List serviceattributeIds = materialServiceattribute.stream().map(dym -> dym.get("fbasedataid_id")).collect(Collectors.toList());
                            if (!"210".equals(bizTypeNumber) && !"2101".equals(bizTypeNumber) && !"2102".equals(bizTypeNumber) ? !"212".equals(bizTypeNumber) || !serviceattributeIds.contains(BillTplEntryConst.MASTERSERVICEATTRIBUTE_2001) : !serviceattributeIds.contains(BillTplEntryConst.MASTERSERVICEATTRIBUTE_1001) && !serviceattributeIds.contains(BillTplEntryConst.MASTERSERVICEATTRIBUTE_2001)) continue;
                        }
                        if (entryMaterial == null) continue;
                        int childRowIndex = rowIndex + ++addRow + oldChildNum;
                        this.getPageCache().put(EXPANDKITPARENTROW, String.valueOf(parentRowIndex));
                        this.markNewChildOp();
                        EntryGrid entry2 = (EntryGrid)this.getControl("billentry");
                        entry2.getEntryState().setFocusRow(childRowIndex - 1);
                        this.getModel().appendEntryRow("billentry", childRowIndex - 1, 1);
                        this.clearMarkNewChildOp();
                        this.getModel().setValue("material", (Object)entryMaterial, childRowIndex);
                        this.getPageCache().remove(EXPANDKITPARENTROW);
                        this.getModel().beginInit();
                        if ("210".equals(bizTypeNumber) || "2101".equals(bizTypeNumber) || "2102".equals(bizTypeNumber)) {
                            DynamicObjectCollection materialServiceattribute = entryMaterial.getDynamicObjectCollection("masterid.serviceattribute");
                            List serviceattributeIds = materialServiceattribute.stream().map(dym -> dym.get("fbasedataid_id")).collect(Collectors.toList());
                            if (!serviceattributeIds.contains(BillTplEntryConst.MASTERSERVICEATTRIBUTE_1001) && serviceattributeIds.contains(BillTplEntryConst.MASTERSERVICEATTRIBUTE_2001)) {
                                this.getModel().setValue("linetype", (Object)1194153085623127040L, childRowIndex);
                            } else {
                                this.getModel().setValue("linetype", (Object)1194150915045641216L, childRowIndex);
                            }
                        } else if ("212".equals(bizTypeNumber)) {
                            this.getModel().setValue("linetype", (Object)1194153085623127040L, childRowIndex);
                        }
                        this.getModel().endInit();
                        this.getModel().setValue("kitqty", (Object)kitQty, childRowIndex);
                        this.getModel().setValue("parentqty", (Object)parentQty, childRowIndex);
                        DynamicObject baseUnit = (DynamicObject)this.getModel().getValue("baseunit", childRowIndex);
                        DynamicObject material = (DynamicObject)this.getModel().getValue("material", childRowIndex);
                        DynamicObject unit = (DynamicObject)this.getModel().getValue("unit", childRowIndex);
                        if (parentBaseQty == null || kitQty == null || parentQty == null || unit == null || baseUnit == null || material == null || BigDecimal.ZERO.compareTo(parentBaseQty) == 0 || BigDecimal.ZERO.compareTo(parentQty) == 0) continue;
                        DynamicObject masterMaterial = material.getDynamicObject("masterid");
                        int precision = KitSalesHelper.getUnitPrecision((DynamicObject)baseUnit);
                        RoundingMode roundingMode = KitSalesHelper.getUnitRoundingMode((DynamicObject)baseUnit);
                        BigDecimal baseQty = parentBaseQty.multiply(kitQty).divide(parentQty, precision, roundingMode);
                        BigDecimal qty = BillTplHelper.getDesQtyConv((DynamicObject)masterMaterial, (DynamicObject)baseUnit, (BigDecimal)baseQty, (DynamicObject)unit);
                        this.getModel().setValue("qty", (Object)qty, childRowIndex);
                    }
                }
                if ("sm_xssalorder".equals(entityId)) {
                    if (needDeleteChildRowModiList != null && !needDeleteChildRowModiList.isEmpty() || needDeleteChildRowAddList != null && !needDeleteChildRowAddList.isEmpty()) {
                        void var43_78;
                        if (needDeleteChildRowModiList != null && !needDeleteChildRowModiList.isEmpty()) {
                            temp = needDeleteChildRowModiList.toArray(new Integer[0]);
                            int[] nArray = new int[temp.length];
                            for (int k = 0; k < temp.length; ++k) {
                                nArray[k] = temp[k];
                            }
                            this.getPageCache().put(ISCONFIRMDELETEKITROW, "true");
                            this.getModel().deleteEntryRows("billentry", nArray);
                            this.getPageCache().put(ISCONFIRMDELETEKITROW, "false");
                        }
                        if (needDeleteChildRowAddList != null && !needDeleteChildRowAddList.isEmpty()) {
                            temp = needDeleteChildRowAddList.toArray(new Integer[0]);
                            int[] nArray = new int[temp.length];
                            for (int k = 0; k < temp.length; ++k) {
                                nArray[k] = temp[k];
                            }
                            this.getPageCache().put(ISCONFIRMDELETEKITROW, "true");
                            this.getModel().deleteEntryRows("billentry", nArray);
                            this.getPageCache().put(ISCONFIRMDELETEKITROW, "false");
                        }
                        int rowCount = this.getModel().getEntryRowCount("billentry");
                        boolean bl = false;
                        while (var43_78 < rowCount) {
                            String changeType = (String)this.getModel().getValue("entrychangetype");
                            if (ChangeTypeEnum.ADDNEW.getValue().equals(changeType)) {
                                this.getView().updateView("linetype", (int)var43_78);
                            }
                            ++var43_78;
                        }
                    } else {
                        this.getView().updateView("billentry");
                    }
                } else if (needDeleteChildRowList != null && !needDeleteChildRowList.isEmpty()) {
                    temp = needDeleteChildRowList.toArray(new Integer[0]);
                    int[] nArray = new int[temp.length];
                    for (int k = 0; k < temp.length; ++k) {
                        nArray[k] = temp[k];
                    }
                    this.getPageCache().put(ISCONFIRMDELETEKITROW, "true");
                    this.getModel().deleteEntryRows("billentry", nArray);
                    this.getPageCache().put(ISCONFIRMDELETEKITROW, "false");
                    int rowCount = this.getModel().getEntryRowCount("billentry");
                    for (int i = 0; i < rowCount; ++i) {
                        String changeType = (String)this.getModel().getValue("entrychangetype");
                        if (!ChangeTypeEnum.ADDNEW.getValue().equals(changeType)) continue;
                        this.getView().updateView("linetype", i);
                    }
                } else {
                    this.getView().updateView("billentry");
                }
            }
        } else if (allErrorMsgs != null && !allErrorMsgs.isEmpty()) {
            String errorDateRowMsg = String.join((CharSequence)"\n", allErrorMsgs);
            String title = ResManager.loadKDString((String)"\u5c55\u5f00\u5b50\u9879\u5b58\u5728\u5931\u8d25", (String)"KitSalesPlugin_35", (String)"scmc-sm-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(title, errorDateRowMsg, MessageBoxOptions.OK, ConfirmTypes.Fail, null);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void propertyChanged(PropertyChangedArgs e) {
        billcretype = this.getPageCache().get("billcretype");
        if (!BillImportHelper.isManual((String)billcretype)) {
            return;
        }
        if (PropertyChangeHelper.isStopPropertyChange((IPageCache)this.getPageCache())) {
            return;
        }
        if (!KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) {
            return;
        }
        span = Tracer.create((String)"KitSalesPlugin", (String)("propertyChanged: " + e.getProperty().getName()));
        var4_4 = null;
        try {
            valueSet = e.getChangeSet();
            propName = e.getProperty().getName();
            newValue = valueSet[0].getNewValue();
            var8_10 = propName;
            var9_11 = -1;
            switch (var8_10.hashCode()) {
                case 299066663: {
                    if (!var8_10.equals("material")) break;
                    var9_11 = 0;
                    break;
                }
                case -1490662231: {
                    if (!var8_10.equals("producttype")) break;
                    var9_11 = 1;
                    break;
                }
                case 70134536: {
                    if (!var8_10.equals("kittransfermodel")) break;
                    var9_11 = 2;
                    break;
                }
                case 886402439: {
                    if (!var8_10.equals("entrysettleorg")) break;
                    var9_11 = 3;
                    break;
                }
                case 106164915: {
                    if (!var8_10.equals("owner")) break;
                    var9_11 = 4;
                    break;
                }
                case 97728: {
                    if (!var8_10.equals("bom")) break;
                    var9_11 = 5;
                    break;
                }
                case 1189618990: {
                    if (!var8_10.equals("linetype")) break;
                    var9_11 = 6;
                }
            }
            switch (var9_11) {
                case 0: {
                    for (i = 0; i < valueSet.length; ++i) {
                        if (!CommonUtils.isRealChanged((ChangeData)valueSet[i])) continue;
                        rowIndex = valueSet[i].getRowIndex();
                        this.changeMaterial((DynamicObject)valueSet[i].getNewValue(), (DynamicObject)valueSet[i].getOldValue(), rowIndex);
                        this.setOneKitColumnEnable(rowIndex);
                        this.setKitDeliverColumnDefault(Collections.singletonList(rowIndex));
                    }
                    break;
                }
                case 1: {
                    for (i = 0; i < valueSet.length; ++i) {
                        if (!CommonUtils.isRealChanged((ChangeData)valueSet[i])) continue;
                        if (valueSet[i].getNewValue() == null || "".equals(valueSet[i].getNewValue())) {
                            PropertyChangeHelper.stopPropertyChange((IPageCache)this.getPageCache());
                            this.revertEntryValue(valueSet[i], valueSet[i].getRowIndex(), propName);
                            PropertyChangeHelper.releasePropertyChange((IPageCache)this.getPageCache());
                            continue;
                        }
                        if (ProductTypeEnum.KITCHILD.getValue().equals(valueSet[i].getNewValue())) {
                            PropertyChangeHelper.stopPropertyChange((IPageCache)this.getPageCache());
                            this.revertEntryValue(valueSet[i], valueSet[i].getRowIndex(), propName);
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u76f4\u63a5\u5207\u6362\u4ea7\u54c1\u7c7b\u522b=\u201c\u5957\u4ef6\u5b50\u9879\u201d\uff0c\u8bf7\u8fdb\u884c\u589e\u5b50\u884c\u64cd\u4f5c\u3002", (String)"KitSalesPlugin_5", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                            PropertyChangeHelper.releasePropertyChange((IPageCache)this.getPageCache());
                            continue;
                        }
                        if (ProductTypeEnum.STANDARD.getValue().equals(valueSet[i].getNewValue())) {
                            if (!ProductTypeEnum.KITPARENT.getValue().equals(valueSet[i].getOldValue())) continue;
                            if (this.hasKitChild(valueSet[i].getRowIndex())) {
                                PropertyChangeHelper.stopPropertyChange((IPageCache)this.getPageCache());
                                this.revertEntryValue(valueSet[i], valueSet[i].getRowIndex(), propName);
                                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u5b58\u5728\u5957\u4ef6\u5b50\u9879\uff0c\u4e0d\u5141\u8bb8\u5207\u6362\u4ea7\u54c1\u7c7b\u522b\u3002", (String)"KitSalesPlugin_6", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                                PropertyChangeHelper.releasePropertyChange((IPageCache)this.getPageCache());
                                continue;
                            }
                            PropertyChangeHelper.stopPropertyChange((IPageCache)this.getPageCache());
                            this.getModel().setValue("kitpid", (Object)Long.valueOf("0"), valueSet[i].getRowIndex());
                            this.getModel().setValue("kitqty", (Object)BigDecimal.ZERO, valueSet[i].getRowIndex());
                            this.getModel().setValue("parentqty", (Object)BigDecimal.ZERO, valueSet[i].getRowIndex());
                            this.getModel().setValue("kittransfermodel", null, valueSet[i].getRowIndex());
                            PropertyChangeHelper.releasePropertyChange((IPageCache)this.getPageCache());
                            continue;
                        }
                        if (!ProductTypeEnum.KITPARENT.getValue().equals(valueSet[i].getNewValue()) || !ProductTypeEnum.STANDARD.getValue().equals(valueSet[i].getOldValue())) continue;
                        this.genPID(valueSet[i].getRowIndex());
                        this.getModel().setValue("ownertype", (Object)OwnerTypeEnum.ORG.getValue(), valueSet[i].getRowIndex());
                        this.getView().updateView("billentry");
                    }
                    break;
                }
                case 2: {
                    for (i = 0; i < valueSet.length; ++i) {
                        if (!CommonUtils.isRealChanged((ChangeData)valueSet[i])) continue;
                        if (valueSet[i].getNewValue() == null || "".equals(valueSet[i].getNewValue())) {
                            PropertyChangeHelper.stopPropertyChange((IPageCache)this.getPageCache());
                            this.revertEntryValue(valueSet[i], valueSet[i].getRowIndex(), propName);
                            PropertyChangeHelper.releasePropertyChange((IPageCache)this.getPageCache());
                            continue;
                        }
                        parentRowIndex = valueSet[i].getRowIndex();
                        productType = (String)this.getModel().getValue("producttype", parentRowIndex);
                        if (!ProductTypeEnum.KITPARENT.getValue().equals(productType)) continue;
                        childIndexList = this.getAllChildEntry(parentRowIndex);
                        entityId = this.getView().getEntityId();
                        if ("sm_xsalorder".equals(entityId) || "sm_xssalorder".equals(entityId)) {
                            isCanChange = true;
                            if (isCanChange = this.isHasPushedData(isCanChange, parentRowIndex)) {
                                var16_36 = childIndexList.iterator();
                                while (var16_36.hasNext() && (isCanChange = this.isHasPushedData(isCanChange, childIndex = var16_36.next()))) {
                                }
                            }
                            if (!isCanChange) {
                                PropertyChangeHelper.stopPropertyChange((IPageCache)this.getPageCache());
                                this.revertEntryValue(valueSet[i], valueSet[i].getRowIndex(), propName);
                                material = (DynamicObject)this.getModel().getValue("material", parentRowIndex);
                                if (material != null && material.getDynamicObject("masterid") != null) {
                                    masterid = material.getDynamicObject("masterid");
                                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c%2$s\uff08%3$s\uff09\uff0c\u6240\u5728\u5957\u4ef6\u7ed3\u6784\u4e2d\u6709\u7236\u9879\u6216\u5b50\u9879\u5b58\u5728\u4e0b\u6e38\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5207\u6362\u201c\u5957\u4ef6\u53d1\u8d27\u65b9\u5f0f\u201d\u3002", (String)"KitSalesPlugin_14", (String)"scmc-sm-formplugin", (Object[])new Object[0]), new Object[]{parentRowIndex + 1, masterid.getString("name"), masterid.getString("number")}));
                                } else {
                                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u6240\u5728\u5957\u4ef6\u7ed3\u6784\u4e2d\u6709\u7236\u9879\u6216\u5b50\u9879\u5b58\u5728\u4e0b\u6e38\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5207\u6362\u201c\u5957\u4ef6\u53d1\u8d27\u65b9\u5f0f\u201d\u3002", (String)"KitSalesPlugin_15", (String)"scmc-sm-formplugin", (Object[])new Object[0]), new Object[]{parentRowIndex + 1}));
                                }
                                PropertyChangeHelper.releasePropertyChange((IPageCache)this.getPageCache());
                                return;
                            }
                        }
                        this.setKitDeliverColumnValue(childIndexList, parentRowIndex, "kittransfermodel");
                        kitTransferModel = valueSet[i].getNewValue() == null ? null : valueSet[i].getNewValue().toString();
                        this.setChildDeliverColumnEnable(childIndexList, kitTransferModel);
                        this.setKitDeliverColumnDefault(childIndexList, parentRowIndex);
                    }
                    break;
                }
                case 3: 
                case 4: {
                    for (i = 0; i < valueSet.length; ++i) {
                        if (!CommonUtils.isRealChanged((ChangeData)valueSet[i])) continue;
                        parentRowIndex = valueSet[i].getRowIndex();
                        productType = (String)this.getModel().getValue("producttype", parentRowIndex);
                        if (!ProductTypeEnum.KITPARENT.getValue().equals(productType)) continue;
                        childIndexList = this.getAllChildEntry(parentRowIndex);
                        this.setKitDeliverColumnValue(childIndexList, parentRowIndex, propName);
                    }
                    break;
                }
                case 5: {
                    for (i = 0; i < valueSet.length; ++i) {
                        if (!CommonUtils.isRealChanged((ChangeData)valueSet[i])) continue;
                        rowIndex = valueSet[i].getRowIndex();
                        productType = (String)this.getModel().getValue("producttype", rowIndex);
                        if (ProductTypeEnum.KITPARENT.getValue().equals(productType) && ("sm_xsalorder".equals(entityId = this.getView().getEntityId()) || "sm_xssalorder".equals(entityId))) {
                            isCanChange = true;
                            if (isCanChange = this.isHasPushedData(isCanChange, rowIndex)) {
                                childIndexList = this.getAllChildEntry(rowIndex);
                                material = childIndexList.iterator();
                                while (material.hasNext() && (isCanChange = this.isHasPushedData(isCanChange, childIndex = material.next()))) {
                                }
                            }
                            if (!isCanChange) {
                                PropertyChangeHelper.stopPropertyChange((IPageCache)this.getPageCache());
                                this.revertEntryValue(valueSet[i], valueSet[i].getRowIndex(), propName);
                                material = (DynamicObject)this.getModel().getValue("material", rowIndex);
                                if (material != null && material.getDynamicObject("masterid") != null) {
                                    masterid = material.getDynamicObject("masterid");
                                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff1a%2$s\uff08%3$s\uff09\uff0c\u6240\u5728\u5957\u4ef6\u7ed3\u6784\u4e2d\u6709\u7236\u9879\u6216\u5b50\u9879\u5b58\u5728\u4e0b\u6e38\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5207\u6362\u201cBOM\u7f16\u7801\u201d\u3002", (String)"KitSalesPlugin_36", (String)"scmc-sm-formplugin", (Object[])new Object[0]), new Object[]{rowIndex + 1, masterid.getString("name"), masterid.getString("number")}));
                                } else {
                                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u6240\u5728\u5957\u4ef6\u7ed3\u6784\u4e2d\u6709\u7236\u9879\u6216\u5b50\u9879\u5b58\u5728\u4e0b\u6e38\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5207\u6362\u201cBOM\u7f16\u7801\u201d\u3002", (String)"KitSalesPlugin_37", (String)"scmc-sm-formplugin", (Object[])new Object[0]), new Object[]{rowIndex + 1}));
                                }
                                PropertyChangeHelper.releasePropertyChange((IPageCache)this.getPageCache());
                                return;
                            }
                        }
                        if (valueSet[i].getNewValue() == null) continue;
                        kitBom = (DynamicObject)valueSet[i].getNewValue();
                        if (!"true".equals(this.getPageCache().get("isConfirmChangeParentBom"))) {
                            this.getPageCache().put("changeParentBomRowIndex", Integer.toString(rowIndex));
                            this.getPageCache().put("changeParentBomValue", kitBom.getPkValue().toString());
                            PropertyChangeHelper.stopPropertyChange((IPageCache)this.getPageCache());
                            this.revertEntryValue(valueSet[i], valueSet[i].getRowIndex(), propName);
                            PropertyChangeHelper.releasePropertyChange((IPageCache)this.getPageCache());
                            confirmCallBacks = new ConfirmCallBackListener("changeParentBom", (IFormPlugin)this);
                            options = MessageBoxOptions.YesNo;
                            msg = ResManager.loadKDString((String)"\u5207\u6362BOM\u7f16\u7801\u540e\u5c06\u6e05\u7a7a\u5bf9\u5e94\u5b50\u9879\uff0c\u662f\u5426\u5207\u6362\uff1f", (String)"KitSalesPlugin_19", (String)"scmc-sm-formplugin", (Object[])new Object[0]);
                            this.getView().showConfirm(msg, "", options, ConfirmTypes.Default, confirmCallBacks);
                            continue;
                        }
                        childIndexList = this.getAllChildEntry(rowIndex);
                        entityId = this.getView().getEntityId();
                        if ("sm_xssalorder".equals(entityId)) {
                            if (childIndexList == null || childIndexList.isEmpty()) continue;
                            needDeleteChildRowModiList = new ArrayList<Integer>();
                            needDeleteChildRowAddList = new ArrayList<Integer>();
                            for (Integer childIndex : childIndexList) {
                                changeType = (String)this.getModel().getValue("entrychangetype", childIndex.intValue());
                                if (ChangeTypeEnum.UPDATE.getValue().equals(changeType)) {
                                    needDeleteChildRowModiList.add(childIndex);
                                    continue;
                                }
                                if (!ChangeTypeEnum.ADDNEW.getValue().equals(changeType)) continue;
                                needDeleteChildRowAddList.add(childIndex);
                            }
                            if (needDeleteChildRowModiList != null && !needDeleteChildRowModiList.isEmpty()) {
                                temp = needDeleteChildRowModiList.toArray(new Integer[0]);
                                intArray = new int[temp.length];
                                for (k = 0; k < temp.length; ++k) {
                                    intArray[k] = temp[k];
                                }
                                this.getPageCache().put("isConfirmDeleteKitRow", "true");
                                this.getModel().deleteEntryRows("billentry", intArray);
                                this.getPageCache().put("isConfirmDeleteKitRow", "false");
                            }
                            if (needDeleteChildRowAddList != null && !needDeleteChildRowAddList.isEmpty()) {
                                temp = needDeleteChildRowAddList.toArray(new Integer[0]);
                                intArray = new int[temp.length];
                                for (k = 0; k < temp.length; ++k) {
                                    intArray[k] = temp[k];
                                }
                                this.getPageCache().put("isConfirmDeleteKitRow", "true");
                                this.getModel().deleteEntryRows("billentry", intArray);
                                this.getPageCache().put("isConfirmDeleteKitRow", "false");
                            }
                            this.getView().updateView();
                            continue;
                        }
                        if (childIndexList == null || childIndexList.isEmpty()) continue;
                        temp = childIndexList.toArray(new Integer[0]);
                        intArray = new int[temp.length];
                        for (k = 0; k < temp.length; ++k) {
                            intArray[k] = temp[k];
                        }
                        this.getPageCache().put("isConfirmDeleteKitRow", "true");
                        this.getModel().deleteEntryRows("billentry", intArray);
                        this.getPageCache().put("isConfirmDeleteKitRow", "false");
                        this.getView().updateView();
                    }
                    break;
                }
                case 6: {
                    entityId = this.getView().getEntityId();
                    if (!"sm_xsalorder".equals(entityId) && !"sm_xssalorder".equals(entityId)) {
                        for (i = 0; i < valueSet.length; ++i) {
                            if (!CommonUtils.isRealChanged((ChangeData)valueSet[i])) continue;
                            this.changeLineType(valueSet[i].getOldValue(), valueSet[i].getNewValue(), valueSet[i].getRowIndex());
                        }
                    }
                    break;
                }
                ** default:
lbl228:
                // 1 sources

                break;
            }
        }
        catch (Throwable var5_7) {
            var4_4 = var5_7;
            throw var5_7;
        }
        finally {
            if (span != null) {
                if (var4_4 != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable masterid) {
                        var4_4.addSuppressed(masterid);
                    }
                } else {
                    span.close();
                }
            }
        }
    }

    private void changeLineType(Object oldValue, Object newValue, int rowIndex) {
        DynamicObject parentRow;
        if (oldValue != null && newValue == null) {
            PropertyChangeHelper.stopPropertyChange((IPageCache)this.getPageCache());
            this.getModel().setValue("linetype", ((DynamicObject)oldValue).getPkValue(), rowIndex);
            PropertyChangeHelper.releasePropertyChange((IPageCache)this.getPageCache());
            return;
        }
        Long srcBillId = (Long)this.getModel().getValue("srcbillid", rowIndex);
        Long srcBillEntryId = (Long)this.getModel().getValue("srcbillentryid", rowIndex);
        if (srcBillId != null && !srcBillId.equals(0L) || srcBillEntryId != null && !srcBillEntryId.equals(0L)) {
            return;
        }
        String msg = ResManager.loadKDString((String)"\u5207\u6362\u201c\u884c\u7c7b\u578b\u201d\u5c06\u6e05\u9664\u5f53\u524d\u5206\u5f55\u7269\u6599\u4fe1\u606f\uff0c\u662f\u5426\u5207\u6362\uff1f", (String)"KitSalesPlugin_38", (String)"scmc-sm-formplugin", (Object[])new Object[0]);
        String productType = (String)this.getModel().getValue("producttype", rowIndex);
        if (ProductTypeEnum.STANDARD.getValue().equals(productType)) {
            return;
        }
        if (ProductTypeEnum.KITPARENT.getValue().equals(productType)) {
            msg = ResManager.loadKDString((String)"\u5207\u6362\u201c\u884c\u7c7b\u578b\u201d\u5c06\u6e05\u9664\u5f53\u524d\u5206\u5f55\u7269\u6599\u4fe1\u606f\uff0c\u5e76\u8054\u52a8\u5220\u9664\u5bf9\u5e94\u5957\u4ef6\u5b50\u9879\u7269\u6599\uff0c\u662f\u5426\u5207\u6362\uff1f", (String)"KitSalesPlugin_39", (String)"scmc-sm-formplugin", (Object[])new Object[0]);
        } else if (ProductTypeEnum.KITCHILD.getValue().equals(productType) && (parentRow = this.getParentEntry(rowIndex)) != null) {
            DynamicObject kitBom = parentRow.getDynamicObject("bom");
            DynamicObject material = parentRow.getDynamicObject("material");
            if (kitBom != null && material != null && KitStructCtlEnum.NONADJ.getValue().equals(material.getString("kitstructctl"))) {
                return;
            }
        }
        ConfirmCallBackListener callBack = new ConfirmCallBackListener(CONFIRM_KITLINETYPE, (IFormPlugin)this);
        this.getView().showConfirm(msg, MessageBoxOptions.YesNo, ConfirmTypes.Default, callBack);
        this.getView().getPageCache().put(CACHE_KITLINETYPE, oldValue == null ? null : ((DynamicObject)oldValue).getPkValue().toString());
    }

    public void afterCopyData(EventObject e) {
        if (!KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) {
            return;
        }
        try (TraceSpan span = Tracer.create((String)"KitSalesPlugin", (String)"afterCopyData:");){
            int count = this.getModel().getEntryRowCount("billentry");
            Long newKitPid = -1L;
            Long currentKitPid = -1L;
            for (int i = 0; i < count; ++i) {
                DynamicObject entryInfo = this.getModel().getEntryRowEntity("billentry", i);
                if (ProductTypeEnum.KITPARENT.getValue().equals(this.getModel().getValue("producttype", i))) {
                    this.genPKValue(entryInfo);
                    newKitPid = entryInfo.getLong("id");
                    currentKitPid = entryInfo.getLong("kitpid");
                    entryInfo.set("id", (Object)newKitPid);
                    entryInfo.set("kitpid", (Object)newKitPid);
                    if (entryInfo.getBigDecimal("kitqty").compareTo(BigDecimal.ZERO) == 0) {
                        entryInfo.set("kitqty", (Object)BigDecimal.ONE);
                    }
                    if (entryInfo.getBigDecimal("parentqty").compareTo(BigDecimal.ZERO) == 0) {
                        entryInfo.set("parentqty", (Object)BigDecimal.ONE);
                    }
                }
                if (!ProductTypeEnum.KITCHILD.getValue().equals(this.getModel().getValue("producttype", i))) continue;
                if (currentKitPid.equals(this.getModel().getValue("kitpid", i))) {
                    entryInfo.set("kitpid", (Object)newKitPid);
                }
                if (entryInfo.getBigDecimal("kitqty").compareTo(BigDecimal.ZERO) == 0) {
                    entryInfo.set("kitqty", (Object)BigDecimal.ONE);
                }
                if (entryInfo.getBigDecimal("parentqty").compareTo(BigDecimal.ZERO) != 0) continue;
                entryInfo.set("parentqty", (Object)BigDecimal.ONE);
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        if (!KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) {
            return;
        }
        if (!this.isNewChildOp()) {
            return;
        }
        String entryName = e.getEntryProp().getName();
        if ("billentry".equals(entryName)) {
            RowDataEntity[] rowDataEntities = e.getRowDataEntities();
            EntryGrid entry = (EntryGrid)this.getControl("billentry");
            int selectRow = 0;
            if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(EXPANDKITPARENTROW))) {
                selectRow = Integer.parseInt(this.getPageCache().get(EXPANDKITPARENTROW));
            } else if (entry.getSelectRows().length > 0) {
                selectRow = entry.getSelectRows()[0];
            } else if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(SELECTROW))) {
                selectRow = Integer.parseInt(this.getPageCache().get(SELECTROW));
            }
            Object pid = this.getModel().getValue("kitpid", selectRow);
            Object priceModel = this.getModel().getValue("pricemodel", selectRow);
            Object kitTransferModel = this.getModel().getValue("kittransfermodel", selectRow);
            Object lineType = this.getModel().getValue("linetype", selectRow);
            DynamicObject material = (DynamicObject)this.getModel().getValue("material", selectRow);
            if (material != null && material.getDynamicObject("masterid") != null) {
                ArrayList<Integer> rowIndexs = new ArrayList<Integer>(rowDataEntities.length);
                for (int i = 0; i < rowDataEntities.length; ++i) {
                    RowDataEntity rowDataEntity = rowDataEntities[i];
                    PropertyChangeHelper.stopPropertyChange((IPageCache)this.getPageCache());
                    this.getModel().setValue("producttype", (Object)ProductTypeEnum.KITCHILD.getValue(), rowDataEntity.getRowIndex());
                    this.getModel().setValue("kitpid", pid, rowDataEntity.getRowIndex());
                    this.getModel().setValue("pricemodel", priceModel, rowDataEntity.getRowIndex());
                    this.getModel().setValue("kittransfermodel", kitTransferModel, rowDataEntity.getRowIndex());
                    this.getModel().setValue("linetype", lineType, rowDataEntity.getRowIndex());
                    this.getModel().setValue("kitproduct", (Object)material.getDynamicObject("masterid"), rowDataEntity.getRowIndex());
                    PropertyChangeHelper.releasePropertyChange((IPageCache)this.getPageCache());
                    rowIndexs.add(rowDataEntity.getRowIndex());
                }
                this.setKitColumnEnable(rowIndexs);
                this.setKitDeliverColumnDefault(rowIndexs);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if (!KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) {
            return;
        }
        String entityId = this.getView().getEntityId();
        Boolean isOrderOrXOrder = "sm_salorder".equals(entityId) || "sm_xsalorder".equals(entityId) || "sm_xssalorder".equals(entityId);
        Boolean isDeliver = "sm_delivernotice".equals(entityId);
        String isDraw = this.getPageCache().get("isdraw");
        if (isDraw == null) {
            isDraw = String.valueOf(this.isDraw());
        }
        Boolean isDrawReturn = "sm_returnapply".equals(entityId) && "true".equals(isDraw);
        Boolean isNewReturn = "sm_returnapply".equals(entityId) && !"true".equals(isDraw);
        String backId = event.getCallBackId();
        MessageBoxResult result = event.getResult();
        switch (backId) {
            case "deleteParentRow": {
                if (MessageBoxResult.Yes.equals((Object)result)) {
                    EntryGrid entryGrid = (EntryGrid)this.getControl("billentry");
                    int[] selectRows = entryGrid.getSelectRows();
                    HashSet<Integer> needDeleteRowIndexes = new HashSet<Integer>(8);
                    ArrayList<Integer> parentRowIndexes = new ArrayList<Integer>(8);
                    ArrayList<Integer> childRowIndexes = new ArrayList<Integer>(8);
                    if (isOrderOrXOrder.booleanValue() || isNewReturn.booleanValue()) {
                        for (int rowIndex : selectRows) {
                            needDeleteRowIndexes.add(rowIndex);
                            String productType = (String)this.getModel().getValue("producttype", rowIndex);
                            if (ProductTypeEnum.KITPARENT.getValue().equals(productType)) {
                                parentRowIndexes.add(rowIndex);
                                continue;
                            }
                            if (!ProductTypeEnum.KITCHILD.getValue().equals(productType)) continue;
                            childRowIndexes.add(rowIndex);
                        }
                        if (parentRowIndexes != null && !parentRowIndexes.isEmpty()) {
                            Object object = parentRowIndexes.iterator();
                            while (object.hasNext()) {
                                Integer rowIndex2 = (Integer)object.next();
                                List<Integer> allChildIndexes = this.getAllChildEntry(rowIndex2);
                                if (allChildIndexes == null || allChildIndexes.isEmpty()) continue;
                                needDeleteRowIndexes.addAll(allChildIndexes);
                                childRowIndexes.removeAll(allChildIndexes);
                            }
                        }
                        if (childRowIndexes != null && !childRowIndexes.isEmpty()) {
                            int rowIndex;
                            ArrayList<String> oldCancelRows = new ArrayList<String>();
                            if ("sm_xssalorder".equals(entityId)) {
                                Iterator rowIndex2 = childRowIndexes.iterator();
                                while (rowIndex2.hasNext()) {
                                    rowIndex = (Integer)rowIndex2.next();
                                    String changeType = (String)this.getModel().getValue("entrychangetype", rowIndex);
                                    if (!ChangeTypeEnum.CANCEL.getValue().equals(changeType)) continue;
                                    oldCancelRows.add(String.valueOf(rowIndex));
                                }
                            }
                            Iterator rowIndex2 = childRowIndexes.iterator();
                            while (rowIndex2.hasNext()) {
                                rowIndex = (Integer)rowIndex2.next();
                                DynamicObject parentRow = this.getParentEntry(rowIndex);
                                if (parentRow == null) continue;
                                DynamicObject kitBom = parentRow.getDynamicObject("bom");
                                DynamicObject material = parentRow.getDynamicObject("material");
                                if (kitBom == null || material == null || !KitStructCtlEnum.NONADJ.getValue().equals(material.getString("kitstructctl"))) continue;
                                String materialCode = KitSalesHelper.getMaterialCode((DynamicObject)material);
                                String materialName = KitSalesHelper.getMaterialName((DynamicObject)material);
                                DynamicObject childMaterial = (DynamicObject)this.getModel().getValue("material", rowIndex);
                                String childMaterialCode = KitSalesHelper.getMaterialCode((DynamicObject)childMaterial);
                                String childMaterialName = KitSalesHelper.getMaterialName((DynamicObject)childMaterial);
                                String showMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff1a%2$s\uff08%3$s\uff09\uff0c\u5bf9\u5e94\u5957\u4ef6\u7236\u9879\u201c%4$s\u201d\u5728\u7269\u6599\u9500\u552e\u4fe1\u606f\u4e2d\u5355\u636e\u5957\u4ef6\u7ed3\u6784\u63a7\u5236\u4e3a\u201c\u53ef\u8c03\u6574\u201d\u65f6\uff0c\u624d\u5141\u8bb8\u5220\u884c\u3002", (String)"KitSalesPlugin_33", (String)"scmc-sm-formplugin", (Object[])new Object[0]), rowIndex + 1, childMaterialName, childMaterialCode, materialCode);
                                this.getView().showTipNotification(showMsg);
                                this.getPageCache().put(ISCANCELDELROWBECBOM, "true");
                                if (oldCancelRows != null && !oldCancelRows.isEmpty()) {
                                    this.getPageCache().put("XOrderOldCancelRows", String.join((CharSequence)",", oldCancelRows));
                                } else {
                                    this.getPageCache().remove("XOrderOldCancelRows");
                                }
                                return;
                            }
                        }
                        this.getPageCache().put(ISCANCELDELROWBECBOM, "false");
                        if ("sm_xssalorder".equals(entityId)) {
                            ArrayList<Integer> needDeleteChildRowModiList = new ArrayList<Integer>();
                            ArrayList<Integer> needDeleteChildRowAddList = new ArrayList<Integer>();
                            if (!needDeleteRowIndexes.isEmpty()) {
                                for (Integer childIndex : needDeleteRowIndexes) {
                                    String changeType = (String)this.getModel().getValue("entrychangetype", childIndex.intValue());
                                    if (ChangeTypeEnum.UPDATE.getValue().equals(changeType)) {
                                        needDeleteChildRowModiList.add(childIndex);
                                        continue;
                                    }
                                    if (!ChangeTypeEnum.ADDNEW.getValue().equals(changeType)) continue;
                                    needDeleteChildRowAddList.add(childIndex);
                                }
                            }
                            if (!needDeleteChildRowModiList.isEmpty()) {
                                Integer[] temp = needDeleteChildRowModiList.toArray(new Integer[0]);
                                int[] intArray = new int[temp.length];
                                for (int i = 0; i < temp.length; ++i) {
                                    intArray[i] = temp[i];
                                }
                                this.getPageCache().put(ISCONFIRMDELETEKITROW, "true");
                                this.getModel().deleteEntryRows("billentry", intArray);
                                this.getPageCache().put(ISCONFIRMDELETEKITROW, "false");
                            }
                            if (!needDeleteChildRowAddList.isEmpty()) {
                                Integer[] temp = needDeleteChildRowAddList.toArray(new Integer[0]);
                                int[] intArray = new int[temp.length];
                                for (int i = 0; i < temp.length; ++i) {
                                    intArray[i] = temp[i];
                                }
                                this.getPageCache().put(ISCONFIRMDELETEKITROW, "true");
                                this.getModel().deleteEntryRows("billentry", intArray);
                                this.getPageCache().put(ISCONFIRMDELETEKITROW, "false");
                            }
                        } else if (!needDeleteRowIndexes.isEmpty()) {
                            Integer[] temp = needDeleteRowIndexes.toArray(new Integer[0]);
                            int[] intArray = new int[temp.length];
                            for (int i = 0; i < temp.length; ++i) {
                                intArray[i] = temp[i];
                            }
                            this.getPageCache().put(ISCONFIRMDELETEKITROW, "true");
                            this.getModel().deleteEntryRows("billentry", intArray);
                            this.getPageCache().put(ISCONFIRMDELETEKITROW, "false");
                        }
                    } else if (isDeliver.booleanValue() || isDrawReturn.booleanValue()) {
                        for (int rowIndex : selectRows) {
                            String productType = (String)this.getModel().getValue("producttype", rowIndex);
                            String transferModel = (String)this.getModel().getValue("kittransfermodel", rowIndex);
                            if (ProductTypeEnum.KITPARENT.getValue().equals(productType)) {
                                if (KitTransferModelEnum.KIT.getValue().equals(transferModel)) {
                                    parentRowIndexes.add(rowIndex);
                                }
                                needDeleteRowIndexes.add(rowIndex);
                                continue;
                            }
                            if (ProductTypeEnum.KITCHILD.getValue().equals(productType)) {
                                childRowIndexes.add(rowIndex);
                                continue;
                            }
                            if (!ProductTypeEnum.STANDARD.getValue().equals(productType)) continue;
                            childRowIndexes.add(rowIndex);
                            needDeleteRowIndexes.add(rowIndex);
                        }
                        if (parentRowIndexes != null && !parentRowIndexes.isEmpty()) {
                            Object temp = parentRowIndexes.iterator();
                            while (temp.hasNext()) {
                                Integer rowIndex = (Integer)temp.next();
                                List<Integer> allChildIndexes = this.getAllChildEntry(rowIndex);
                                if (allChildIndexes == null || allChildIndexes.isEmpty()) continue;
                                needDeleteRowIndexes.addAll(allChildIndexes);
                            }
                        }
                        boolean isCanDelete = true;
                        if (childRowIndexes != null && !childRowIndexes.isEmpty()) {
                            for (Integer rowIndex : childRowIndexes) {
                                if (needDeleteRowIndexes.contains(rowIndex)) continue;
                                String transferModel = (String)this.getModel().getValue("kittransfermodel", rowIndex.intValue());
                                if (KitTransferModelEnum.KIT.getValue().equals(transferModel)) {
                                    DynamicObject material = (DynamicObject)this.getModel().getValue("material", rowIndex.intValue());
                                    String materialCode = KitSalesHelper.getMaterialCode((DynamicObject)material);
                                    String materialName = KitSalesHelper.getMaterialName((DynamicObject)material);
                                    if ("sm_delivernotice".equals(entityId)) {
                                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c%2$s\uff08%3$s\uff09\uff0c\u5bf9\u5e94\u7236\u9879\u4ea7\u54c1\u7684\u5957\u4ef6\u53d1\u8d27\u65b9\u5f0f\u4e3a\u201c\u6210\u5957\u53d1\u8d27\u201d\u65f6\uff0c\u4e0d\u5141\u8bb8\u5355\u72ec\u5220\u9664\u5b50\u9879\u4ea7\u54c1\u3002", (String)"KitSalesPlugin_10", (String)"scmc-sm-formplugin", (Object[])new Object[0]), rowIndex + 1, materialName, materialCode));
                                    } else {
                                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c%2$s\uff08%3$s\uff09\uff0c\u5bf9\u5e94\u7236\u9879\u4ea7\u54c1\u7684\u5957\u4ef6\u9000\u8d27\u65b9\u5f0f\u4e3a\u201c\u6210\u5957\u9000\u8d27\u201d\u65f6\uff0c\u4e0d\u5141\u8bb8\u5355\u72ec\u5220\u9664\u5b50\u9879\u4ea7\u54c1\u3002", (String)"KitSalesPlugin_11", (String)"scmc-sm-formplugin", (Object[])new Object[0]), rowIndex + 1, materialName, materialCode));
                                    }
                                    isCanDelete = false;
                                    break;
                                }
                                needDeleteRowIndexes.add(rowIndex);
                            }
                        }
                        if (isCanDelete && !needDeleteRowIndexes.isEmpty()) {
                            Integer[] temp = needDeleteRowIndexes.toArray(new Integer[0]);
                            int[] intArray = new int[temp.length];
                            for (int i = 0; i < temp.length; ++i) {
                                intArray[i] = temp[i];
                            }
                            this.getPageCache().put(ISCONFIRMDELETEKITROW, "true");
                            this.getModel().deleteEntryRows("billentry", intArray);
                            this.getPageCache().put(ISCONFIRMDELETEKITROW, "false");
                        }
                    }
                    String top_deleterow = this.getPageCache().get("top_deleterow");
                    if (!StringUtils.isNotEmpty((CharSequence)top_deleterow)) break;
                    int index = Integer.parseInt(top_deleterow);
                    EntryGrid entryX = (EntryGrid)this.getControl("billentry");
                    entryX.getEntryState().selectRow(index - 1);
                    entryX.selectRows(index - 1);
                    entryX.getEntryState().setFocusRow(index - 1);
                    this.getPageCache().remove("top_deleterow");
                    break;
                }
                if (!MessageBoxResult.Cancel.equals((Object)result)) break;
                break;
            }
            case "changeParentBom": {
                if (!MessageBoxResult.Yes.equals((Object)result)) break;
                String rowIndexString = this.getPageCache().get(CHANGEPARENTBOM_ROWINDEX);
                String valueString = this.getPageCache().get(CHANGEPARENTBOM_VALUE);
                if (rowIndexString == null || valueString == null || StringUtils.isEmpty((CharSequence)valueString) || StringUtils.isEmpty((CharSequence)rowIndexString)) break;
                try {
                    int rowIndex = Integer.parseInt(rowIndexString);
                    Long value = Long.parseLong(valueString);
                    this.getPageCache().put(ISCONFIRMCHANGEPARENTBOM, "true");
                    this.getModel().setValue("bom", (Object)value, rowIndex);
                    this.getPageCache().put(ISCONFIRMCHANGEPARENTBOM, "false");
                }
                catch (NumberFormatException e) {
                    LOG.info("CHANGEPARENTBOM NumberFormatException" + e.getMessage());
                }
                break;
            }
            case "expandKitBomConfirm": {
                if (!MessageBoxResult.Yes.equals((Object)result)) break;
                this.expandkitFunction();
                break;
            }
            case "confirmKitLineType": {
                int rowIndex = this.getModel().getEntryCurrentRowIndex("billentry");
                if (MessageBoxResult.Yes.equals((Object)result)) {
                    List<Integer> childIndexList;
                    String productType = (String)this.getModel().getValue("producttype", rowIndex);
                    if (ProductTypeEnum.KITPARENT.getValue().equals(productType) && (childIndexList = this.getAllChildEntry(rowIndex)) != null && !childIndexList.isEmpty()) {
                        Integer[] temp = childIndexList.toArray(new Integer[0]);
                        int[] intArray = new int[temp.length];
                        for (int i = 0; i < temp.length; ++i) {
                            intArray[i] = temp[i];
                        }
                        this.getPageCache().put(ISCONFIRMDELETEKITROW, "true");
                        this.getModel().deleteEntryRows("billentry", intArray);
                        this.getPageCache().put(ISCONFIRMDELETEKITROW, "false");
                    }
                    this.getPageCache().put("changeForceRowMaterial", "true");
                    this.getModel().setValue("material", null, rowIndex);
                    this.getPageCache().remove("changeForceRowMaterial");
                    this.getView().updateView();
                    break;
                }
                String lineTypeId = this.getView().getPageCache().get(CACHE_KITLINETYPE);
                this.getModel().beginInit();
                this.getModel().setValue("linetype", (Object)(lineTypeId == null ? null : Long.valueOf(Long.parseLong(lineTypeId))), rowIndex);
                this.getModel().endInit();
                this.getView().updateView("linetype", rowIndex);
                break;
            }
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        int[] deleteIndexs = e.getRowIndexs();
        if (!KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) {
            return;
        }
        if ("billentry".equals(e.getEntryProp().getName()) && deleteIndexs.length > 0) {
            this.getPageCache().put("top_deleterow", String.valueOf(deleteIndexs[0]));
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        if (!KitSalesHelper.isKitSale((IPageCache)this.getPageCache(), (String)this.getModel().getDataEntityType().getName())) {
            return;
        }
        String entryName = e.getEntryProp().getName();
        if ("billentry".equals(entryName)) {
            HashMap<Long, Integer> parentRowInfo = new HashMap<Long, Integer>();
            HashSet<Long> childRowInfo = new HashSet<Long>();
            int rowCount = this.getModel().getEntryRowCount("billentry");
            for (int i = 0; i < rowCount; ++i) {
                Long pID = (Long)this.getModel().getValue("kitpid", i);
                String productType = (String)this.getModel().getValue("producttype", i);
                if (ProductTypeEnum.KITPARENT.getValue().equals(productType)) {
                    parentRowInfo.put(pID, i);
                    continue;
                }
                if (!ProductTypeEnum.KITCHILD.getValue().equals(productType)) continue;
                childRowInfo.add(pID);
            }
            if (parentRowInfo != null && !parentRowInfo.isEmpty()) {
                for (Map.Entry entry : parentRowInfo.entrySet()) {
                    if (childRowInfo.contains(entry.getKey())) continue;
                    this.getView().setEnable(Boolean.TRUE, ((Integer)entry.getValue()).intValue(), new String[]{"material"});
                }
            }
        }
    }

    private void showConfirmDeleteParentRow(List<Integer> rowIndexes, List<String> materialList) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(DELETEPARENTROW, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"KitSalesPlugin_7", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u5220\u9664", (String)"KitSalesPlugin_8", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String materialInfos = "";
        if (materialList != null && !materialList.isEmpty()) {
            materialInfos = String.join((CharSequence)"\u3001", materialList) + "\uff0c";
        }
        StringBuilder rowIndexInfos = new StringBuilder();
        for (Integer rowIndex : rowIndexes) {
            rowIndexInfos.append(rowIndex + 1);
            rowIndexInfos.append('\u3001');
        }
        String msg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c%2$s\u5220\u9664\u540e\u5c06\u8054\u52a8\u5220\u9664\u5bf9\u5e94\u5957\u4ef6\u5b50\u9879\u7269\u6599\uff0c\u662f\u5426\u5220\u9664\uff1f", (String)"KitSalesPlugin_9", (String)"scmc-sm-formplugin", (Object[])new Object[0]), rowIndexInfos.substring(0, rowIndexInfos.length() - 1), materialInfos);
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Delete, confirmCallBacks, btnNameMaps);
    }

    private boolean isHasPushedData(boolean isCanChange, int rowIndex) {
        BigDecimal parentAssociatedBaseQty = (BigDecimal)this.getModel().getValue("associatedbaseqty", rowIndex);
        BigDecimal parentBaseBackQty = (BigDecimal)this.getModel().getValue("basebackqty", rowIndex);
        BigDecimal parentArJoinBaseQty = (BigDecimal)this.getModel().getValue("basearjoinqty", rowIndex);
        BigDecimal parentBasePurJoinQty = (BigDecimal)this.getModel().getValue("basepurjoinqty", rowIndex);
        BigDecimal parentCfmJoinBaseQty = (BigDecimal)this.getModel().getValue("cfmjoinbaseqty", rowIndex);
        if (parentAssociatedBaseQty.compareTo(BigDecimal.ZERO) != 0 || parentCfmJoinBaseQty.compareTo(BigDecimal.ZERO) != 0 || parentAssociatedBaseQty.compareTo(BigDecimal.ZERO) == 0 && parentBaseBackQty.compareTo(BigDecimal.ZERO) != 0 || parentArJoinBaseQty.compareTo(BigDecimal.ZERO) != 0 || parentBasePurJoinQty.compareTo(BigDecimal.ZERO) != 0) {
            isCanChange = false;
        }
        return isCanChange;
    }

    private void changeMaterial(DynamicObject material, DynamicObject oldMaterial, int rowIndex) {
        String billcretype = this.getPageCache().get("billcretype");
        if (!BillImportHelper.isManual((String)billcretype)) {
            return;
        }
        if (PropertyChangeHelper.isStopPropertyChange((IPageCache)this.getPageCache())) {
            return;
        }
        AbstractGrid entry = (AbstractGrid)this.getControl("billentry");
        int foucsRow = entry.getEntryState().getFocusRow();
        if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(SELECT_MATERIALROW))) {
            foucsRow = Integer.parseInt(this.getPageCache().get(SELECT_MATERIALROW));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(EXPANDKITPARENTROW))) {
            foucsRow = rowIndex;
        }
        if ("true".equals(this.getPageCache().get("changeForceRowMaterial"))) {
            foucsRow = rowIndex;
        }
        if (foucsRow == -1 || this.getPageCache().get(INVENTORY_QUERY) != null) {
            foucsRow = rowIndex;
        }
        Long pID = (Long)this.getModel().getValue("kitpid", foucsRow);
        String productType = (String)this.getModel().getValue("producttype", foucsRow);
        PropertyChangeHelper.stopPropertyChange((IPageCache)this.getPageCache());
        if (ProductTypeEnum.KITPARENT.getValue().equals(productType)) {
            this.genPID(rowIndex);
        }
        if (ProductTypeEnum.STANDARD.getValue().equals(productType)) {
            this.getModel().setValue("kitqty", (Object)BigDecimal.ZERO, rowIndex);
            this.getModel().setValue("parentqty", (Object)BigDecimal.ZERO, rowIndex);
        } else {
            this.getModel().setValue("kitqty", (Object)BigDecimal.ONE, rowIndex);
            this.getModel().setValue("parentqty", (Object)BigDecimal.ONE, rowIndex);
        }
        this.getModel().setValue("bom", null, rowIndex);
        if (pID == null || Long.valueOf("0").equals(pID) || ProductTypeEnum.KITPARENT.getValue().equals(productType)) {
            DynamicObject masterMaterial;
            this.getModel().setValue("pricemodel", null, rowIndex);
            this.getModel().setValue("kittransfermodel", null, rowIndex);
            if (material != null && (masterMaterial = material.getDynamicObject("masterid")) != null) {
                this.getModel().setValue("pricemodel", (Object)material.getString("pricemodel"), rowIndex);
                this.getModel().setValue("kittransfermodel", (Object)material.getString("kittransfermodel"), rowIndex);
            }
            if (foucsRow != rowIndex) {
                this.getModel().setValue("producttype", (Object)productType, rowIndex);
            }
        } else if (foucsRow != rowIndex) {
            this.getModel().setValue("producttype", (Object)productType, rowIndex);
            this.getModel().setValue("kitpid", (Object)pID, rowIndex);
            DynamicObject kitProduct = (DynamicObject)this.getModel().getValue("kitproduct", foucsRow);
            this.getModel().setValue("kitproduct", (Object)kitProduct, rowIndex);
            String priceModel = (String)this.getModel().getValue("pricemodel", foucsRow);
            this.getModel().setValue("pricemodel", (Object)priceModel, rowIndex);
            String kitTransferModel = (String)this.getModel().getValue("kittransfermodel", foucsRow);
            this.getModel().setValue("kittransfermodel", (Object)kitTransferModel, rowIndex);
            this.getView().updateView("billentry", rowIndex);
        }
        PropertyChangeHelper.releasePropertyChange((IPageCache)this.getPageCache());
    }

    private void genPID(int rowIndex) {
        if (this.getModel().getValue("kitpid", rowIndex) == null || Long.valueOf("0").equals(this.getModel().getValue("kitpid", rowIndex))) {
            DynamicObject entryInfo = this.getModel().getEntryRowEntity("billentry", rowIndex);
            this.genPKValue(entryInfo);
            this.getModel().setValue(BillTplEntryConst.ENTRYID, entryInfo.get("id"), rowIndex);
            this.getModel().setValue("kitpid", entryInfo.get("id"), rowIndex);
        }
    }

    private void revertEntryValue(ChangeData changeData, int rowIndex, String propName) {
        PropertyChangeHelper.stopPropertyChange((IPageCache)this.getPageCache());
        this.getModel().setValue(propName, changeData.getOldValue(), rowIndex);
        PropertyChangeHelper.releasePropertyChange((IPageCache)this.getPageCache());
    }

    private boolean isBackCalculate() {
        Boolean inputamount = Boolean.FALSE;
        if (this.getControl("inputamount") != null) {
            inputamount = (Boolean)this.getModel().getValue("inputamount");
        }
        return inputamount;
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
    }

    private Long genPKValue(DynamicObject curObj) {
        if (curObj.getPkValue() == null || Long.valueOf("0").equals(curObj.getPkValue())) {
            curObj.set("id", (Object)DBServiceHelper.genGlobalLongId());
            return (Long)curObj.get("id");
        }
        return (Long)curObj.getPkValue();
    }

    private void setKitColumnEnables(List<RowDataEntity> currencyRows) {
        if (currencyRows == null || currencyRows.size() == 0) {
            return;
        }
        for (RowDataEntity row : currencyRows) {
            int rowIndex = row.getRowIndex();
            this.setKitPriceColumnEnable(rowIndex);
            this.setKitDeliverColumnEnable(rowIndex, null);
        }
    }

    private void setKitColumnEnable(List<Integer> rows) {
        if (rows == null || rows.size() == 0) {
            return;
        }
        for (int rowIndex : rows) {
            this.setKitPriceColumnEnable(rowIndex);
            this.setKitDeliverColumnEnable(rowIndex, null);
        }
    }

    private void setOneKitColumnEnable(int rowIndex) {
        this.setKitPriceColumnEnable(rowIndex);
        this.setKitDeliverColumnEnable(rowIndex, null);
    }

    private void setChildDeliverColumnEnable(List<Integer> childEntryList, String transferModel) {
        if (childEntryList == null || childEntryList.size() == 0) {
            return;
        }
        for (Integer childEntryIndex : childEntryList) {
            this.setKitDeliverColumnEnable(childEntryIndex, transferModel);
        }
    }

    private void setKitPriceColumnEnable(int rowIndex) {
        block19: {
            HashSet<String> enableColumn = new HashSet<String>();
            enableColumn.addAll(Arrays.asList(BillTplEntryConst.KITAMOUNTANDPRICEFIELDS));
            List wer = KitSalesHelper.getAmountAndQtyFieldList((DynamicObject)this.getModel().getDataEntity(true), (String)"billentry");
            enableColumn.addAll(wer);
            boolean isLock = false;
            boolean isUnLock = false;
            String productType = (String)this.getModel().getValue("producttype", rowIndex);
            String priceModel = (String)this.getModel().getValue("pricemodel", rowIndex);
            if (ProductTypeEnum.KITPARENT.getValue().equals(productType)) {
                if (PriceModelEnum.CHILD.getValue().equals(priceModel)) {
                    isLock = true;
                } else {
                    isUnLock = true;
                }
            } else if (ProductTypeEnum.KITCHILD.getValue().equals(productType)) {
                if (PriceModelEnum.PARENT.getValue().equals(priceModel)) {
                    isLock = true;
                } else {
                    isUnLock = true;
                }
            }
            if (isLock) {
                for (String column : enableColumn) {
                    this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{column});
                }
            }
            if (!isUnLock) break block19;
            String entityId = this.getView().getEntityId();
            if ("sm_xssalorder".equals(entityId)) {
                IDataEntityType dt = this.getModel().getDataEntity().getDataEntityType();
                String[] unEnableProperty = ChangeModelHelper.getUnEnableProperty((IDataEntityType)dt, (String)"billentry");
                HashSet<String> unEnableColumns = new HashSet<String>(8);
                if (unEnableProperty != null && unEnableProperty.length > 0) {
                    unEnableColumns.addAll(Arrays.asList(unEnableProperty));
                }
                String changeType = (String)this.getModel().getValue("entrychangetype", rowIndex);
                for (String column : enableColumn) {
                    if (ChangeTypeEnum.CANCEL.getValue().equals(changeType)) {
                        this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{column});
                        continue;
                    }
                    if (!unEnableColumns.contains(column) || ChangeTypeEnum.ADDNEW.getValue().equals(changeType)) {
                        this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{column});
                        continue;
                    }
                    this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{column});
                }
            } else if ("sm_xsalorder".equals(entityId)) {
                String changeType = (String)this.getModel().getValue("entrychangetype", rowIndex);
                for (String column : enableColumn) {
                    if (!ChangeTypeEnum.CANCEL.getValue().equals(changeType)) continue;
                    this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{column});
                }
            } else {
                for (String column : enableColumn) {
                    this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{column});
                }
            }
        }
    }

    private void setKitDeliverColumnEnable(int rowIndex, String transfermodel) {
        String productType = (String)this.getModel().getValue("producttype", rowIndex);
        if (ProductTypeEnum.KITCHILD.getValue().equals(productType)) {
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"entrysettleorg"});
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"owner"});
        }
    }

    private void setKitDeliverColumnDefault(List<Integer> childIndexList) {
        if (childIndexList == null || childIndexList.size() == 0) {
            return;
        }
        HashMap<Long, DynamicObject> parentMap = new HashMap<Long, DynamicObject>();
        for (int childRowIndex : childIndexList) {
            String productType = (String)this.getModel().getValue("producttype", childRowIndex);
            if (!ProductTypeEnum.KITCHILD.getValue().equals(productType)) continue;
            Long pID = (Long)this.getModel().getValue("kitpid", childRowIndex);
            DynamicObject parentEntry = (DynamicObject)parentMap.get(pID);
            if (parentEntry == null) {
                parentEntry = this.getParentEntry(childRowIndex);
                parentMap.put(pID, parentEntry);
            }
            if (parentEntry == null) continue;
            this.setKitDeliverOneColumnDefault(childRowIndex, parentEntry);
        }
    }

    private void setKitDeliverColumnDefault(List<Integer> childIndexList, int parentRowIndex) {
        if (childIndexList == null || childIndexList.size() == 0) {
            return;
        }
        DynamicObject parentEntry = this.getModel().getEntryRowEntity("billentry", parentRowIndex);
        for (int childRowIndex : childIndexList) {
            this.setKitDeliverOneColumnDefault(childRowIndex, parentEntry);
        }
    }

    private void setKitDeliverOneColumnDefault(Integer childRowIndex, DynamicObject parentEntry) {
        this.getModel().setValue("entrysettleorg", parentEntry.get("entrysettleorg"), childRowIndex.intValue());
        this.getModel().setValue("ownertype", parentEntry.get("ownertype"), childRowIndex.intValue());
        this.getModel().setValue("owner", parentEntry.get("owner"), childRowIndex.intValue());
    }

    private void setKitDeliverColumnValue(List<Integer> childIndexList, int parentRowIndex, String column) {
        if (childIndexList == null || childIndexList.size() == 0) {
            return;
        }
        DynamicObject parentEntry = this.getModel().getEntryRowEntity("billentry", parentRowIndex);
        for (int childRowIndex : childIndexList) {
            this.getModel().setValue(column, parentEntry.get(column), childRowIndex);
        }
    }

    private DynamicObject getParentEntry(int childRowIndex) {
        DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("billentry");
        Long pID = (Long)this.getModel().getValue("kitpid", childRowIndex);
        DynamicObject parentEntry = null;
        for (DynamicObject entry : entrys) {
            Long entryPid = entry.getLong("kitpid");
            String productType = entry.getString("producttype");
            if (!ProductTypeEnum.KITPARENT.getValue().equals(productType) || entryPid.longValue() != pID.longValue()) continue;
            parentEntry = entry;
            break;
        }
        return parentEntry;
    }

    private List<Integer> getAllChildEntry(int parentRowIndex) {
        DynamicObject parentEntry = this.getModel().getEntryRowEntity("billentry", parentRowIndex);
        Long parentPid = parentEntry.getLong("kitpid");
        ArrayList<Integer> childEntryList = new ArrayList<Integer>();
        int rowCount = this.getModel().getEntryRowCount("billentry");
        for (int i = 0; i < rowCount; ++i) {
            Long pID = (Long)this.getModel().getValue("kitpid", i);
            String productType = (String)this.getModel().getValue("producttype", i);
            if (!ProductTypeEnum.KITCHILD.getValue().equals(productType) || parentPid.longValue() != pID.longValue()) continue;
            childEntryList.add(i);
        }
        return childEntryList;
    }

    private int getKitChildInterval(int parentRow) {
        DynamicObject entryInfo = this.getModel().getEntryRowEntity("billentry", parentRow);
        DynamicObjectCollection entryColl = this.getModel().getEntryEntity("billentry");
        int interval = 0;
        for (int i = parentRow + 1; i < entryColl.size(); ++i) {
            if (entryInfo.get("kitpid") == null || !entryInfo.get("kitpid").equals(((DynamicObject)entryColl.get(i)).getLong("kitpid"))) continue;
            ++interval;
        }
        return interval;
    }

    private boolean hasKitChild(int parentRow) {
        Object pid = this.getModel().getValue("kitpid", parentRow);
        if (pid == null || Long.valueOf("0").equals(pid)) {
            return false;
        }
        DynamicObjectCollection entryColl = this.getModel().getEntryEntity("billentry");
        for (int i = parentRow + 1; i < entryColl.size(); ++i) {
            if (!pid.equals(((DynamicObject)entryColl.get(i)).getLong("kitpid"))) continue;
            return true;
        }
        return false;
    }

    private int getParentRowIndex(int rowIndex) {
        int parentIndex = -1;
        Long pid = (Long)this.getModel().getValue("kitpid", rowIndex);
        if (pid != null) {
            for (int i = 0; i < rowIndex; ++i) {
                if (!pid.equals(this.getModel().getValue("kitpid", i))) continue;
                parentIndex = i;
                break;
            }
        }
        return parentIndex;
    }

    private boolean isDraw() {
        String formId = this.getView().getEntityId();
        LinkSetElement linkSet = ConvertMetaServiceHelper.loadLinkSet((String)formId);
        if (linkSet == null || linkSet.getItems() == null || linkSet.getItems().isEmpty()) {
            return false;
        }
        ExtendedDataEntitySet dataSet = new ExtendedDataEntitySet();
        DynamicObject billObj = this.getModel().getDataEntity();
        dataSet.Parse(new DynamicObject[]{billObj}, (MainEntityType)billObj.getDataEntityType());
        for (LinkSetItemElement linkEntry : linkSet.getItems()) {
            ExtendedDataEntity[] rows = dataSet.FindByEntityKey(linkEntry.getLinkEntityKey());
            if (rows == null || rows.length <= 0) continue;
            for (ExtendedDataEntity row : rows) {
                if (!this.haveSourceBillId(row.getDataEntity())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean haveSourceBillId(DynamicObject linkRow) {
        LinkEntryType linkType = (LinkEntryType)linkRow.getDataEntityType();
        Long sBillId = (Long)linkType.getSBillIdProp().getValueFast((Object)linkRow);
        return sBillId != null && sBillId != 0L;
    }

    private void markNewChildOp() {
        this.getPageCache().put(NEWCHILD_OP, "1");
    }

    private boolean isNewChildOp() {
        return "1".equals(this.getPageCache().get(NEWCHILD_OP));
    }

    private void clearMarkNewChildOp() {
        this.getPageCache().remove(NEWCHILD_OP);
    }
}

