/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.formplugin.tpl;

import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.business.helper.BizTypeHelper;
import kd.scmc.sm.business.helper.BillImportHelper;
import kd.scmc.sm.business.helper.BillTplHelper;
import kd.scmc.sm.business.helper.BillTypeParameterHelper;
import kd.scmc.sm.business.helper.CurrencyHelper;
import kd.scmc.sm.business.helper.CustomerHelper;
import kd.scmc.sm.business.helper.MaterialHelper;
import kd.scmc.sm.business.helper.MetaDataHelper;
import kd.scmc.sm.business.helper.PropertyChangeHelper;
import kd.scmc.sm.enums.DiscountTypeEnum;
import kd.scmc.sm.formplugin.tpl.CustomerPlugin;
import kd.scmc.sm.util.CommonUtils;

public class SimpleBillTplPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public static final String LINKADDRESSF7 = "linkaddressf7";
    private static final String CACHE_KEY_BIZTYPEID = "cache_key_biztype_id";
    private static final String CACHE_KEY_DEF_LINETYPEID = "cache_key_def_linetype_id";

    public void registerListener(EventObject e) {
        BasedataEdit linetype;
        BasedataEdit linkaddressf7;
        BasedataEdit linkMan;
        BasedataEdit customer;
        BasedataEdit bizTypeEdit;
        super.registerListener(e);
        Toolbar toolbar = (Toolbar)this.getView().getControl("tbmainentry");
        if (toolbar != null) {
            toolbar.addItemClickListener((ItemClickListener)this);
        }
        if ((bizTypeEdit = (BasedataEdit)this.getView().getControl("biztype")) != null) {
            bizTypeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        BasedataEdit materialEdit = (BasedataEdit)this.getView().getControl("material");
        materialEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit materialversion = (BasedataEdit)this.getView().getControl("materialversion");
        materialversion.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit unitEdit = (BasedataEdit)this.getView().getControl("unit");
        unitEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        if (this.getView().getControl("address") != null) {
            this.addClickListeners(new String[]{"address"});
        }
        if ((customer = (BasedataEdit)this.getView().getControl("customer")) != null) {
            customer.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((linkMan = (BasedataEdit)this.getControl("linkman")) != null) {
            linkMan.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((linkaddressf7 = (BasedataEdit)this.getControl(LINKADDRESSF7)) != null) {
            linkaddressf7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((linetype = (BasedataEdit)this.getControl("linetype")) != null) {
            linetype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        try (TraceSpan span = Tracer.create((String)"SimpleBillTplPlugin", (String)"afterCreateNewData");){
            String billcretype = this.getPageCache().get("billcretype");
            if (!BillImportHelper.isManual((String)billcretype)) {
                return;
            }
            this.initCurrencyDefaultValue();
            DynamicObject billType = (DynamicObject)this.getModel().getValue("billtype");
            this.changeBillType(billType);
            int entryRowCount = this.getModel().getEntryRowCount("billentry");
            for (int i = 0; i < entryRowCount; ++i) {
                this.initNewDataEntry(i);
            }
            this.getPageCache().remove(CACHE_KEY_DEF_LINETYPEID);
            this.cusAndSupSettletype(this.getModel(), "customer");
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        try (TraceSpan span = Tracer.create((String)"SimpleBillTplPlugin", (String)"afterBindData");){
            if (this.getModel().getValue("customer") == null) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"settlecurrency"});
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void propertyChanged(PropertyChangedArgs e) {
        String billcretype = this.getPageCache().get("billcretype");
        if (!BillImportHelper.isManual((String)billcretype)) {
            return;
        }
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        try (TraceSpan span = Tracer.create((String)"SimpleBillTplPlugin", (String)("propertyChanged: " + e.getProperty().getName()));){
            switch (propName) {
                case "material": {
                    int i = 0;
                    while (i < valueSet.length) {
                        if (CommonUtils.isRealChanged((ChangeData)valueSet[i])) {
                            int curRow;
                            int rowIndex = valueSet[i].getRowIndex();
                            this.changeMaterial((DynamicObject)valueSet[i].getNewValue(), rowIndex);
                            if (valueSet[i].getNewValue() != null && (curRow = this.getModel().getEntryCurrentRowIndex("billentry")) != rowIndex) {
                                this.getModel().setValue("linetype", this.getModel().getValue("linetype", curRow), rowIndex);
                            }
                        }
                        ++i;
                    }
                    return;
                }
                case "linkaddressf7": {
                    int i = 0;
                }
                case "qty": 
                case "unit": {
                    int i = 0;
                    while (true) {
                        if (i >= valueSet.length) {
                            this.doRefresh(valueSet);
                            return;
                        }
                        if (CommonUtils.isRealChanged((ChangeData)valueSet[i])) {
                            int rowIndex = valueSet[i].getRowIndex();
                            BillTplHelper.calcQtyAndBaseQty((int)rowIndex, (IDataModel)this.getModel());
                        }
                        ++i;
                    }
                }
                case "customer": {
                    int i = 0;
                    while (i < valueSet.length) {
                        if (CommonUtils.isRealChanged((ChangeData)valueSet[i])) {
                            this.customerChanged((DynamicObject)valueSet[i].getNewValue());
                        }
                        ++i;
                    }
                    return;
                }
                case "biztype": {
                    DynamicObject oldValue = (DynamicObject)valueSet[0].getOldValue();
                    DynamicObject newValue = (DynamicObject)valueSet[0].getNewValue();
                    if (Objects.equals(newValue, oldValue)) return;
                    this.getPageCache().put(CACHE_KEY_BIZTYPEID, String.valueOf(oldValue == null ? Long.valueOf(0L) : oldValue.getPkValue()));
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u201c\u4e1a\u52a1\u7c7b\u578b\u201d\u5207\u6362\uff0c\u5c06\u6e05\u9664\u5f53\u524d\u5355\u636e\u7269\u6599\u660e\u7ec6\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"SimpleBillTplPlugin_7", (String)"scmc-sm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(propName, (IFormPlugin)this));
                    return;
                }
                case "linetype": {
                    int i = 0;
                    while (i < valueSet.length) {
                        if (CommonUtils.isRealChanged((ChangeData)valueSet[i])) {
                            Object oldValueX = valueSet[i].getOldValue();
                            Object newValueY = valueSet[i].getNewValue();
                            if (oldValueX != null && newValueY == null) {
                                PropertyChangeHelper.stopPropertyChange((IPageCache)this.getPageCache());
                                this.getModel().setValue("linetype", ((DynamicObject)oldValueX).getPkValue(), valueSet[i].getRowIndex());
                                PropertyChangeHelper.releasePropertyChange((IPageCache)this.getPageCache());
                                return;
                            }
                        }
                        ++i;
                    }
                    return;
                }
            }
            return;
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if ("biztype".equals(event.getCallBackId())) {
            String biztypeId;
            if (event.getResult() == MessageBoxResult.Yes) {
                this.getModel().deleteEntryData("billentry");
                this.getModel().createNewEntryRow("billentry");
                this.initNewDataEntry(0);
            } else if (event.getResult() == MessageBoxResult.Cancel && StringUtils.isNotEmpty((String)(biztypeId = this.getPageCache().get(CACHE_KEY_BIZTYPEID)))) {
                this.getModel().beginInit();
                if ("0".equals(biztypeId)) {
                    this.getModel().setValue("biztype", null);
                } else {
                    this.getModel().setValue("biztype", (Object)Long.parseLong(biztypeId));
                }
                this.getModel().endInit();
                this.getView().updateView("biztype");
            }
            this.getPageCache().remove(CACHE_KEY_DEF_LINETYPEID);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        IDataModel bill = this.getModel();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObject org = (DynamicObject)bill.getValue("org");
        int rowIndex = this.getModel().getEntryCurrentRowIndex("billentry");
        DynamicObject material = (DynamicObject)bill.getValue("material", rowIndex);
        String formId = this.getView().getFormShowParameter().getFormId();
        DynamicObject billType = (DynamicObject)bill.getValue("billtype");
        if (billType == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u7c7b\u578b\u3002", (String)"BaseBillTplPlugin_4", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        try (TraceSpan span = Tracer.create((String)"SimpleBillTplPlugin", (String)("beforeF7Select: " + e.getProperty().getName()));){
            switch (key) {
                case "material": {
                    if (org == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"BaseBillTplPlugin_1", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        e.setCancel(true);
                        return;
                    }
                    DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
                    if (bizType == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"SimpleBillTplPlugin_5", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        e.setCancel(true);
                        return;
                    }
                    DynamicObject lineType = (DynamicObject)this.getModel().getValue("linetype", e.getRow());
                    if (lineType == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u884c\u7c7b\u578b\u3002", (String)"SimpleBillTplPlugin_6", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        e.setCancel(true);
                        return;
                    }
                    List qf = MaterialHelper.getQFilterByLineType((Long)((Long)billType.getPkValue()), (Long)((Long)bizType.getPkValue()), (Long)((Long)lineType.getPkValue()), (boolean)true);
                    if (qf == null) return;
                    if (qf.size() <= 0) return;
                    showParameter.getListFilterParameter().getQFilters().addAll(qf);
                    return;
                }
                case "materialversion": {
                    if (material != null && material.getDynamicObject("masterid") != null) {
                        DynamicObject masterMaterial = material.getDynamicObject("masterid");
                        Long masterMaterialId = (Long)masterMaterial.getPkValue();
                        QFilter qFilter = new QFilter("material ", "=", (Object)masterMaterialId);
                        showParameter.getListFilterParameter().getQFilters().add(qFilter);
                        return;
                    }
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u7f16\u7801\u3002", (String)"BaseBillTplPlugin_2", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                case "unit": {
                    if (material == null || material.getDynamicObject("masterid") == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u7f16\u7801\u3002", (String)"BaseBillTplPlugin_2", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        e.setCancel(true);
                        return;
                    }
                    DynamicObject masterMaterial = material.getDynamicObject("masterid");
                    DynamicObject baseUnit = (DynamicObject)bill.getValue("baseunit", rowIndex);
                    Long srcmuId = baseUnit == null ? Long.valueOf(0L) : (Long)baseUnit.getPkValue();
                    Long masterMaterialId = (Long)masterMaterial.getPkValue();
                    List unitIds = BaseDataServiceHelper.getAssistMUListResult((Long)masterMaterialId, (Long)srcmuId, (String)"1");
                    QFilter qFilter = new QFilter("id", "in", (Object)unitIds);
                    showParameter.getListFilterParameter().setFilter(qFilter);
                    return;
                }
                case "biztype": {
                    List bizTypes = BizTypeHelper.getAllBizTypes((String)this.getView().getEntityId(), (Long)((Long)billType.getPkValue()), (String)"sm_billtypeparam");
                    if (bizTypes != null && !bizTypes.isEmpty()) {
                        QFilter qFilter = new QFilter("id", "in", (Object)bizTypes);
                        showParameter.getListFilterParameter().getQFilters().add(qFilter);
                        return;
                    }
                    QFilter qFilter = new QFilter("id", "=", (Object)0);
                    List<QFilter> qfList = Collections.singletonList(qFilter);
                    showParameter.getListFilterParameter().setQFilters(qfList);
                    return;
                }
                case "linetype": {
                    DynamicObject biztype = (DynamicObject)this.getModel().getValue("biztype");
                    if (biztype != null) {
                        List lineTypeId = BizTypeHelper.getAllLineTypes((Long)((Long)biztype.getPkValue()));
                        showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)lineTypeId));
                        return;
                    }
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"SimpleBillTplPlugin_5", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                case "linkaddressf7": {
                    DynamicObject customer = (DynamicObject)this.getModel().getValue("customer");
                    if (customer == null) return;
                    QFilter id1 = new QFilter("customerid", "in", (Object)customer.getPkValue().toString());
                    QFilter id2 = new QFilter("invalid", "=", (Object)"0");
                    showParameter.getListFilterParameter().setQFilters(Arrays.asList(id1, id2));
                    return;
                }
                case "linkman": {
                    DynamicObject customers = (DynamicObject)this.getModel().getValue("customer");
                    if (customers == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ba2\u8d27\u5ba2\u6237\u3002", (String)"BaseBillTplPlugin_3", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                        e.setCancel(true);
                    }
                    if (customers != null) {
                        DynamicObjectCollection linkman = customers.getDynamicObjectCollection("entry_linkman");
                        List invalid = linkman.stream().filter(a -> !a.getBoolean("invalid")).map(a -> (Long)a.getPkValue()).collect(Collectors.toList());
                        QFilter customerid = new QFilter("customerid", "=", customers.getPkValue());
                        QFilter ids = new QFilter("id", "in", invalid);
                        showParameter.getListFilterParameter().setFilter(customerid.and(ids));
                        return;
                    }
                    showParameter.getListFilterParameter().setQFilters(Collections.singletonList(new QFilter("customerid", "=", (Object)0)));
                    return;
                }
            }
            return;
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        if ("billentry".equals(entryName)) {
            RowDataEntity[] rowDataEntities;
            for (RowDataEntity rowDataEntity : rowDataEntities = e.getRowDataEntities()) {
                int rowIndex = rowDataEntity.getRowIndex();
                DynamicObject lineType = (DynamicObject)this.getModel().getValue("linetype", rowIndex);
                if (!CommonUtils.isNull((Object)lineType)) continue;
                this.initNewDataEntry(rowIndex);
            }
            this.getPageCache().remove(CACHE_KEY_DEF_LINETYPEID);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        if (c.getKey().equalsIgnoreCase("address")) {
            DynamicObject customer = (DynamicObject)this.getModel().getValue("customer");
            if (customer == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ba2\u8d27\u5ba2\u6237\u3002", (String)"BaseBillTplPlugin_3", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                return;
            }
            BasedataEdit linkaddressf7 = (BasedataEdit)this.getControl(LINKADDRESSF7);
            linkaddressf7.click();
        }
    }

    public void beforeItemClick(BeforeItemClickEvent e) {
        String itemKey;
        switch (itemKey = e.getItemKey()) {
            case "bar_save": {
                DynamicObject billtype = (DynamicObject)this.getModel().getValue("billtype");
                if (billtype == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u7c7b\u578b\u3002", (String)"BaseBillTplPlugin_4", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                if (org != null) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"BaseBillTplPlugin_1", (String)"scmc-sm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
        }
    }

    private void initCurrencyDefaultValue() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            DynamicObject exRateTable;
            Map map = CurrencyHelper.getCurrencyAndExRateTable((Long)((Long)org.getPkValue()));
            if (map == null) {
                return;
            }
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            if (currency == null) {
                this.getModel().setValue("currency", map.get("baseCurrencyID"));
            }
            if ((exRateTable = (DynamicObject)this.getModel().getValue("exratetable")) == null) {
                this.getModel().setValue("exratetable", map.get("exchangeRateTableID"));
            }
        }
    }

    private void changeBillType(DynamicObject billType) {
        String formid = this.getView().getEntityId();
        if (billType == null) {
            this.getModel().setValue("biztype", null);
        } else {
            Long biztype;
            DynamicObject billTypeParam = BillTypeParameterHelper.getBillTypeParameter((String)formid, (long)((Long)billType.getPkValue()));
            if (billTypeParam != null && (biztype = BizTypeHelper.getDefaultBizType((String)formid, (Long)((Long)billType.getPkValue()), (String)"sm_billtypeparam")) != null) {
                this.getModel().setValue("biztype", (Object)biztype);
            }
        }
    }

    private void changeMaterial(DynamicObject material, int rowIndex) {
        PropertyChangeHelper.stopPropertyChange((IPageCache)this.getPageCache());
        this.getModel().setValue("materialversion", null, rowIndex);
        this.getModel().setValue("unit", null, rowIndex);
        this.getModel().setValue("baseunit", null, rowIndex);
        this.getModel().setValue("qty", null, rowIndex);
        this.getModel().setValue("baseqty", null, rowIndex);
        this.getModel().setValue("discounttype", (Object)DiscountTypeEnum.NULL, rowIndex);
        if (material != null) {
            DynamicObject masterMaterial = material.getDynamicObject("masterid");
            if (masterMaterial != null && masterMaterial.getDynamicObject("baseunit") != null) {
                this.getModel().setValue("baseunit", masterMaterial.getDynamicObject("baseunit").getPkValue(), rowIndex);
            }
            if (material.getDynamicObject("salesunit") != null) {
                this.getModel().setValue("unit", material.getDynamicObject("salesunit").getPkValue(), rowIndex);
            }
        }
        PropertyChangeHelper.releasePropertyChange((IPageCache)this.getPageCache());
    }

    private void setValueIfExists(String property, CustomerPlugin.ValueHandle handle) {
        if (MetaDataHelper.isExistField((IDataEntityType)this.getModel().getDataEntityType(), (String)property)) {
            if (handle.getValue() != null && handle.getValue() instanceof DynamicObject) {
                this.getModel().setValue(property, ((DynamicObject)handle.getValue()).getPkValue());
            } else {
                this.getModel().setValue(property, handle.getValue());
            }
        }
    }

    private void cusAndSupSettletype(IDataModel bill, String roleType) {
        QFilter isdefault = new QFilter("isdefault", "=", (Object)Boolean.TRUE);
        QFilter isenable = new QFilter("enable", "=", (Object)"1");
        QFilter filter = isdefault.and(isenable);
        DynamicObject defaultSettlementType = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_settlementtype", (QFilter[])new QFilter[]{filter});
        DynamicObject role = (DynamicObject)bill.getValue(roleType);
        if (role != null) {
            DynamicObject settlementtypeid = role.getDynamicObject("settlementtypeid");
            if (settlementtypeid == null) {
                bill.setValue("settletype", defaultSettlementType == null ? null : defaultSettlementType.getPkValue());
            } else {
                bill.setValue("settletype", settlementtypeid.getPkValue());
            }
        } else {
            bill.setValue("settletype", defaultSettlementType == null ? null : defaultSettlementType.getPkValue());
        }
    }

    private void customerChanged(DynamicObject customer) {
        if (customer == null) {
            this.getModel().setValue("linkman", null);
            this.getModel().setValue("address", null);
            this.getView().setEnable(Boolean.FALSE, new String[]{"settlecurrency"});
            this.getModel().setValue("settlecurrency", null);
            this.getModel().setValue("settletype", null);
            this.getModel().setValue("exchangerate", null);
            return;
        }
        this.getView().setEnable(Boolean.TRUE, new String[]{"settlecurrency"});
        IDataModel model = this.getModel();
        model.beginInit();
        this.setValueIfExists("linkman", () -> CustomerHelper.getLinkman((DynamicObject)customer));
        this.setValueIfExists("address", () -> CustomerHelper.getAddress((DynamicObject)customer));
        DynamicObject settlementType = customer.getDynamicObject("settlementtypeid");
        if (settlementType != null) {
            Long settlementTypeId = (Long)settlementType.getPkValue();
            QFilter isenable = new QFilter("enable", "=", (Object)"1");
            QFilter id = new QFilter("id", "=", (Object)settlementTypeId);
            DynamicObject object = BusinessDataServiceHelper.loadSingle((String)"bd_settlementtype", (String)"id,", (QFilter[])new QFilter[]{id.and(isenable)});
            if (object == null) {
                this.cusAndSupSettletype(model, "customer");
            } else {
                model.setValue("settletype", settlementType.getPkValue());
            }
        } else {
            this.cusAndSupSettletype(model, "customer");
        }
        model.endInit();
        if (customer.getDynamicObject("settlementcyid") != null) {
            this.setValueIfExists("settlecurrency", () -> BusinessDataServiceHelper.loadSingleFromCache((Object)customer.getDynamicObject("settlementcyid").getPkValue(), (String)"bd_currency", (String)"id, number, name, amtprecision,priceprecision,sign,isshowsign"));
        } else {
            this.setValueIfExists("settlecurrency", () -> model.getValue("currency"));
        }
        this.getView().updateView("linkman");
        this.getView().updateView("address");
        this.getView().updateView("linkmanphone");
        this.getView().updateView("settletype");
    }

    private void doRefresh(ChangeData[] valueSet) {
        for (int i = 0; i < valueSet.length; ++i) {
            this.getView().updateView("price", valueSet[i].getRowIndex());
            this.getView().updateView("priceandtax", valueSet[i].getRowIndex());
            this.getView().updateView("qty", valueSet[i].getRowIndex());
            this.getView().updateView("baseqty", valueSet[i].getRowIndex());
            this.getView().updateView("baseunit", valueSet[i].getRowIndex());
        }
    }

    private void initNewDataEntry(int rowIndex) {
        DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
        this.getModel().setValue("linetype", (Object)this.getDefLineTypeFromPageCache(bizType), rowIndex);
    }

    private Long getDefLineTypeFromPageCache(DynamicObject biztype) {
        if (biztype == null || Objects.equals(0L, biztype.getPkValue())) {
            return null;
        }
        String lineTypeIDCache = this.getPageCache().get(CACHE_KEY_DEF_LINETYPEID);
        if (StringUtils.isNotEmpty((String)lineTypeIDCache)) {
            return Long.valueOf(lineTypeIDCache);
        }
        Long lineTypeID = BizTypeHelper.getDefaultLineType((Long)((Long)biztype.getPkValue()));
        if (lineTypeID != null && !Objects.equals(0L, lineTypeID)) {
            this.getPageCache().put(CACHE_KEY_DEF_LINETYPEID, String.valueOf(lineTypeID));
            return lineTypeID;
        }
        return null;
    }
}

