/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pms.opplugin.price;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.mpscmm.msbd.common.utils.DateUtils;
import kd.scmc.pms.validation.price.SalesPriceSubmitValidator;

public class SalesPriceSubmitOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keys = e.getFieldKeys();
        keys.add("istax");
        keys.add("effectdate");
        keys.add("expirydate");
        keys.add("applymaterial");
        keys.add("applycustomer");
        keys.add("material");
        keys.add("materialgroup");
        keys.add("priceeffectdate");
        keys.add("priceexpirydate");
        keys.add("priceceiling");
        keys.add("pricefloor");
        keys.add("qtyfrom");
        keys.add("qtyto");
        keys.add("priceentryentity.seq");
        keys.add("price");
        keys.add("priceandtax");
        keys.add("isstairprice");
        keys.add("unit");
        keys.add("stairqtystart");
        keys.add("stairqtyend");
        keys.add("stairprice");
        keys.add("unitid");
        keys.add("customer");
        keys.add("customergroup");
        keys.add("customerentryentity.seq");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new SalesPriceSubmitValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] bills;
        for (DynamicObject bill : bills = e.getDataEntities()) {
            if (!"submit".equals(e.getOperationKey())) continue;
            Date expiryDate = bill.getDate("expirydate");
            bill.set("expirydate", (Object)DateUtils.getEndOfDay((Date)expiryDate));
            DynamicObjectCollection priceEntryEntities = bill.getDynamicObjectCollection("priceentryentity");
            for (DynamicObject priceEntryEntity : priceEntryEntities) {
                Date priceExpiryDate = priceEntryEntity.getDate("priceexpirydate");
                priceEntryEntity.set("priceexpirydate", (Object)DateUtils.getEndOfDay((Date)priceExpiryDate));
                boolean isStairPrice = priceEntryEntity.getBoolean("isstairprice");
                if (!isStairPrice) continue;
                DynamicObjectCollection salStairPrices = priceEntryEntity.getDynamicObjectCollection("salstairprice");
                ((DynamicObject)salStairPrices.get(salStairPrices.size() - 1)).set("stairqtyend", (Object)new BigDecimal("9999999999999"));
            }
        }
    }
}

