/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pms.validation.adjust;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class SalesPriceAdjustSubmitValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObjectCollection cusEntries;
            DynamicObject bill = data.getDataEntity();
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("priceentryentity");
            Boolean istax = bill.getBoolean("istax");
            if (entries != null && entries.size() > 0) {
                for (DynamicObject entry : entries) {
                    DynamicObject materialgroup;
                    String applymaterial = bill.getString("applymaterial");
                    if ("A".equals(applymaterial)) {
                        DynamicObject unit;
                        DynamicObject material = entry.getDynamicObject("material");
                        if (material == null) {
                            this.addMessage(data, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8c03\u6574\u660e\u7ec6\u5355\u636e\u4f53\u201d\u7b2c%s\u884c\u201c\u7269\u6599\u7f16\u7801\u201d\u3002", (String)"SalesPriceAdjustSubmitValidator_4", (String)"scmc-pms-opplugin", (Object[])new Object[0]), entry.getInt("seq")));
                        }
                        if ((unit = entry.getDynamicObject("unit")) == null) {
                            this.addMessage(data, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8c03\u6574\u660e\u7ec6\u5355\u636e\u4f53\u201d\u7b2c%s\u884c\u201c\u8ba1\u91cf\u5355\u4f4d\u201d\u3002", (String)"SalesPriceAdjustSubmitValidator_6", (String)"scmc-pms-opplugin", (Object[])new Object[0]), entry.getInt("seq")));
                        }
                    }
                    if ("B".equals(applymaterial) && (materialgroup = entry.getDynamicObject("materialgroup")) == null) {
                        this.addMessage(data, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8c03\u6574\u660e\u7ec6\u5355\u636e\u4f53\u201d\u7b2c%s\u884c\u201c\u7269\u6599\u5206\u7c7b\u7f16\u7801\u201d\u3002", (String)"SalesPriceAdjustSubmitValidator_5", (String)"scmc-pms-opplugin", (Object[])new Object[0]), entry.getInt("seq")));
                    }
                    BigDecimal priceandtax = entry.getBigDecimal("adjpriceandtax");
                    BigDecimal price = entry.getBigDecimal("adjprice");
                    if (istax.booleanValue()) {
                        if (BigDecimal.ZERO.compareTo(priceandtax) == 0) {
                            this.addMessage(data, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u4ef7\u683c\u660e\u7ec6\u5355\u636e\u4f53\u201d\u7b2c%s\u884c\u201c\u542b\u7a0e\u5355\u4ef7\u201d\u3002", (String)"SalesPriceAdjustSubmitValidator_7", (String)"scmc-pms-opplugin", (Object[])new Object[0]), entry.getInt("seq")));
                        }
                    } else if (BigDecimal.ZERO.compareTo(price) == 0) {
                        this.addMessage(data, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8c03\u6574\u660e\u7ec6\u5355\u636e\u4f53\u201d\u7b2c%s\u884c\u201c\u5355\u4ef7\u201d\u3002", (String)"SalesPriceAdjustSubmitValidator_8", (String)"scmc-pms-opplugin", (Object[])new Object[0]), entry.getInt("seq")));
                    }
                    BigDecimal priceFloor = entry.getBigDecimal("adjpricefloor");
                    BigDecimal priceCeiling = entry.getBigDecimal("adjpriceceiling");
                    if (priceCeiling.compareTo(BigDecimal.ZERO) > 0 && priceFloor.compareTo(priceCeiling) > 0) {
                        this.addMessage(data, String.format(ResManager.loadKDString((String)"\u8bf7\u786e\u4fdd\u7b2c%s\u884c\u8c03\u6574\u660e\u7ec6\u7684\u6700\u9ad8\u9650\u4ef7\u5927\u4e8e\u7b49\u4e8e\u6700\u4f4e\u9650\u4ef7\u3002", (String)"SalesPriceAdjustSubmitValidator_0", (String)"scmc-pms-opplugin", (Object[])new Object[0]), entry.getInt("seq")));
                    }
                    if (priceCeiling.compareTo(BigDecimal.ZERO) > 0 && priceandtax.compareTo(priceCeiling) > 0) {
                        this.addMessage(data, String.format(ResManager.loadKDString((String)"\u8c03\u6574\u660e\u7ec6\u7b2c%s\u884c\u542b\u7a0e\u5355\u4ef7\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u6700\u9ad8\u9650\u4ef7\u3002", (String)"SalesPriceAdjustSubmitValidator_1", (String)"scmc-pms-opplugin", (Object[])new Object[0]), entry.getInt("seq")));
                    }
                    if (priceFloor.compareTo(BigDecimal.ZERO) > 0 && priceandtax.compareTo(priceFloor) < 0) {
                        this.addMessage(data, String.format(ResManager.loadKDString((String)"\u8c03\u6574\u660e\u7ec6\u7b2c%s\u884c\u542b\u7a0e\u5355\u4ef7\u5e94\u5927\u4e8e\u6216\u7b49\u4e8e\u6700\u4f4e\u9650\u4ef7\u3002", (String)"SalesPriceAdjustSubmitValidator_2", (String)"scmc-pms-opplugin", (Object[])new Object[0]), entry.getInt("seq")));
                    }
                    Date priceEffDate = entry.getDate("adjpriceeffectdate");
                    Date priceExpDate = entry.getDate("adjpriceexpirydate");
                    if (priceExpDate == null || priceEffDate == null || !priceEffDate.after(priceExpDate)) continue;
                    this.addMessage(data, String.format(ResManager.loadKDString((String)"\u8c03\u6574\u660e\u7ec6\u7b2c%s\u884c\u4ef7\u683c\u751f\u6548\u65e5\u671f\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u4ef7\u683c\u5931\u6548\u65e5\u671f\u3002", (String)"SalesPriceAdjustSubmitValidator_3", (String)"scmc-pms-opplugin", (Object[])new Object[0]), entry.getInt("seq")));
                }
            }
            if ((cusEntries = bill.getDynamicObjectCollection("customerentryentity")) == null || cusEntries.size() <= 0) continue;
            Object applyCustomer = bill.get("applycustomer");
            for (DynamicObject cusEntry : cusEntries) {
                DynamicObject customerGroup;
                DynamicObject customer;
                if ("B".equals(applyCustomer) && (customer = cusEntry.getDynamicObject("customer")) == null) {
                    this.addMessage(data, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5ba2\u6237\u660e\u7ec6\u5355\u636e\u4f53\u201d\u7b2c%s\u884c\uff1a\u201c\u5ba2\u6237\u7f16\u7801\u201d\u3002", (String)"SalesPriceSubmitValidator_21", (String)"scmc-sm-opplugin", (Object[])new Object[0]), cusEntry.getInt("seq")));
                }
                if (!"C".equals(applyCustomer) || (customerGroup = cusEntry.getDynamicObject("customergroup")) != null) continue;
                this.addMessage(data, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5ba2\u6237\u660e\u7ec6\u5355\u636e\u4f53\u201d\u7b2c%s\u884c\uff1a\u201c\u5ba2\u6237\u5206\u7c7b\u7f16\u7801\u201d\u3002", (String)"SalesPriceSubmitValidator_22", (String)"scmc-sm-opplugin", (Object[])new Object[0]), cusEntry.getInt("seq")));
            }
        }
    }
}

