/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pms.validation.price;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.mpscmm.msbd.common.utils.CommonUtils;

public class SalePriceListCustomerValidator
extends AbstractValidator {
    public static final String APPLY_CUSTOMER = "B";
    public static final String APPLY_CUSTOMER_GROUP = "C";

    public Set<String> preparePropertys() {
        HashSet<String> prepareProperties = super.preparePropertys();
        if (CommonUtils.isNull((Object)prepareProperties)) {
            prepareProperties = new HashSet<String>(8);
        }
        prepareProperties.add("applycustomer");
        prepareProperties.add("customer");
        prepareProperties.add("customergroup");
        return prepareProperties;
    }

    public void validate() {
        if (this.getDataEntities() == null || this.getDataEntities().length == 0) {
            return;
        }
        for (ExtendedDataEntity entity : this.getDataEntities()) {
            DynamicObjectCollection customerEntryEntity;
            String applyCustomer;
            DynamicObject bill = entity.getDataEntity();
            if (bill == null || (applyCustomer = bill.getString("applycustomer")) == null || (customerEntryEntity = bill.getDynamicObjectCollection("customerentryentity")).isEmpty()) continue;
            for (int row = 0; row < customerEntryEntity.size(); ++row) {
                DynamicObject entry = (DynamicObject)customerEntryEntity.get(row);
                DynamicObject customer = entry.getDynamicObject("customer");
                DynamicObject customerGroup = entry.getDynamicObject("customergroup");
                if (APPLY_CUSTOMER.equals(applyCustomer) && (customer == null || customerGroup != null)) {
                    this.addMessage(entity, String.format(ResManager.loadKDString((String)"\u9002\u7528\u5ba2\u6237\u65b9\u5f0f\u4e3a\u201c\u5ba2\u6237\u201d\u65f6\uff0c\u5ba2\u6237\u660e\u7ec6\u7b2c%1$s\u884c\u7684\u5ba2\u6237\u7f16\u7801\u5fc5\u987b\u586b\u5199\uff0c\u5ba2\u6237\u5206\u7c7b\u7f16\u7801\u4e0d\u9700\u8981\u586b\u5199\u3002", (String)"SalePriceListCustomerValidator_0", (String)"scmc-sm-opplugin", (Object[])new Object[0]), row + 1, ErrorLevel.Error));
                }
                if (!APPLY_CUSTOMER_GROUP.equals(applyCustomer) || customer == null && customerGroup != null) continue;
                this.addMessage(entity, String.format(ResManager.loadKDString((String)"\u9002\u7528\u5ba2\u6237\u65b9\u5f0f\u4e3a\u201c\u5ba2\u6237\u5206\u7c7b\u201d\u65f6\uff0c\u5ba2\u6237\u660e\u7ec6\u7b2c%1$s\u884c\u7684\u5ba2\u6237\u5206\u7c7b\u7f16\u7801\u5fc5\u987b\u586b\u5199\uff0c\u5ba2\u6237\u7f16\u7801\u65e0\u9700\u586b\u5199\u3002", (String)"SalePriceListCustomerValidator_1", (String)"scmc-sm-opplugin", (Object[])new Object[0]), row + 1, ErrorLevel.Error));
            }
        }
    }
}

