/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pms.validation.price;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.scmc.sm.business.helper.LotCacheHelper;

public class SalePriceListLotValidator
extends AbstractValidator {
    private static final String MASTERID = "masterid";
    private static final String NUMBER = "number";
    private static final String PRICEENTRYENTITY = "priceentryentity";

    public Set<String> preparePropertys() {
        HashSet<String> prepareProperties = super.preparePropertys();
        if (CommonUtils.isNull((Object)prepareProperties)) {
            prepareProperties = new HashSet<String>(8);
        }
        prepareProperties.add("org");
        prepareProperties.add("applymaterial");
        prepareProperties.add("material");
        prepareProperties.add("lotnumber");
        return prepareProperties;
    }

    public void validate() {
        if (this.getDataEntities() == null || this.getDataEntities().length == 0) {
            return;
        }
        for (ExtendedDataEntity entity : this.getDataEntities()) {
            DynamicObjectCollection priceEntryEntity;
            String applyMaterial;
            DynamicObject org;
            DynamicObject bill = entity.getDataEntity();
            if (bill == null || (org = bill.getDynamicObject("org")) == null || (applyMaterial = bill.getString("applymaterial")) == null || (priceEntryEntity = bill.getDynamicObjectCollection(PRICEENTRYENTITY)).isEmpty()) continue;
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection(PRICEENTRYENTITY);
            Map resultMap = LotCacheHelper.checkLot((DynamicObject)bill, (DynamicObjectCollection)entrys);
            for (int row = 0; row < priceEntryEntity.size(); ++row) {
                Boolean isLot;
                DynamicObject material;
                DynamicObject entry = (DynamicObject)priceEntryEntity.get(row);
                DynamicObject materialSalInfo = entry.getDynamicObject("material");
                if (materialSalInfo == null || (material = materialSalInfo.getDynamicObject(MASTERID)) == null) continue;
                String lotNumber = entry.getString("lotnumber");
                if (resultMap == null || resultMap.size() <= 0 || lotNumber == null || lotNumber.isEmpty() || (isLot = (Boolean)resultMap.get(row)) != null && isLot.booleanValue()) continue;
                String tipMsg = String.format(ResManager.loadKDString((String)"\u4ef7\u683c\u660e\u7ec6\u7b2c%1$s\u884c\u7269\u6599\u201c%2$s\u201d\u672a\u5f00\u542f\u6279\u53f7\u7ba1\u7406\uff0c\u4e0d\u9700\u8981\u5f55\u5165\u6279\u53f7\u3002", (String)"SalePriceListLotValidator_0", (String)"scmc-sm-opplugin", (Object[])new Object[0]), row + 1, material.getString(NUMBER));
                this.addMessage(entity, tipMsg, ErrorLevel.Error);
            }
        }
    }
}

