/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pms.validation.price;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msbd.business.helper.MaterialHelper;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.mpscmm.msbd.common.utils.CommonUtils;

public class SalePriceListMaterialValidator
extends AbstractValidator {
    private static final String APPLY_MATERIAL = "A";
    private static final String APPLY_MATERIAL_GROUP = "B";
    private static final String MASTERID = "masterid";
    private static final String ID = "id";
    private static final String NUMBER = "number";

    public Set<String> preparePropertys() {
        HashSet<String> prepareProperties = super.preparePropertys();
        if (CommonUtils.isNull((Object)prepareProperties)) {
            prepareProperties = new HashSet<String>(8);
        }
        prepareProperties.add("istax");
        prepareProperties.add("applymaterial");
        prepareProperties.add("material");
        prepareProperties.add("taxrate");
        prepareProperties.add("materialgroup");
        prepareProperties.add("unit");
        prepareProperties.add("baseunit");
        prepareProperties.add("effectdate");
        prepareProperties.add("expirydate");
        prepareProperties.add("priceeffectdate");
        prepareProperties.add("priceexpirydate");
        prepareProperties.add("price");
        prepareProperties.add("priceandtax");
        prepareProperties.add("pricefloor");
        prepareProperties.add("priceceiling");
        return prepareProperties;
    }

    public void validate() {
        if (this.getDataEntities() == null || this.getDataEntities().length == 0) {
            return;
        }
        Map<Object, DynamicObject> materialMap = this.getMaterialMap();
        for (ExtendedDataEntity entity : this.getDataEntities()) {
            String applyMaterial;
            DynamicObject bill = entity.getDataEntity();
            if (bill == null || (applyMaterial = bill.getString("applymaterial")) == null || applyMaterial.isEmpty()) continue;
            Date effectDate = bill.getDate("effectdate");
            Date expiryDate = bill.getDate("expirydate");
            if (expiryDate != null && effectDate != null && effectDate.after(expiryDate)) {
                this.addMessage(entity, String.format(ResManager.loadKDString((String)"\u4ef7\u76ee\u751f\u6548\u65e5\u671f\u9700\u5c0f\u4e8e\u7b49\u4e8e\u4ef7\u76ee\u5931\u6548\u65e5\u671f\u3002", (String)"SalePriceListMaterialValidator_0", (String)"scmc-sm-opplugin", (Object[])new Object[0]), ErrorLevel.Error));
            }
            boolean isTax = bill.getBoolean("istax");
            DynamicObjectCollection priceEntryEntity = bill.getDynamicObjectCollection("priceentryentity");
            if (priceEntryEntity.isEmpty()) continue;
            for (int row = 0; row < priceEntryEntity.size(); ++row) {
                DynamicObject unit;
                DynamicObject entry = (DynamicObject)priceEntryEntity.get(row);
                DynamicObject materialSalInfo = entry.getDynamicObject("material");
                DynamicObject material = null;
                if (materialSalInfo != null && materialMap != null) {
                    material = materialMap.get(materialSalInfo.getPkValue());
                }
                DynamicObject materialGroup = entry.getDynamicObject("materialgroup");
                BigDecimal taxRate = entry.getBigDecimal("taxrate");
                if (APPLY_MATERIAL.equals(applyMaterial) && (materialSalInfo == null || materialGroup != null)) {
                    this.addMessage(entity, String.format(ResManager.loadKDString((String)"\u9002\u7528\u7269\u6599\u65b9\u5f0f\u4e3a\u201c\u7269\u6599\u201d\u65f6\uff0c\u4ef7\u683c\u660e\u7ec6\u7b2c%1$s\u884c\u7684\u7269\u6599\u7f16\u7801\u5fc5\u987b\u586b\u5199\uff0c\u7269\u6599\u5206\u7c7b\u7f16\u7801\u65e0\u9700\u586b\u5199\u3002", (String)"SalePriceListMaterialValidator_1", (String)"scmc-sm-opplugin", (Object[])new Object[0]), row + 1, ErrorLevel.Error));
                }
                if (APPLY_MATERIAL_GROUP.equals(applyMaterial) && (materialSalInfo != null || materialGroup == null)) {
                    this.addMessage(entity, String.format(ResManager.loadKDString((String)"\u9002\u7528\u7269\u6599\u65b9\u5f0f\u4e3a\u201c\u7269\u6599\u5206\u7c7b\u201d\u65f6\uff0c\u4ef7\u683c\u660e\u7ec6\u7b2c%1$s\u884c\u7684\u7269\u6599\u5206\u7c7b\u7f16\u7801\u5fc5\u987b\u586b\u5199\uff0c\u7269\u6599\u7f16\u7801\u4e0d\u9700\u8981\u586b\u5199\u3002", (String)"SalePriceListMaterialValidator_2", (String)"scmc-sm-opplugin", (Object[])new Object[0]), row + 1, ErrorLevel.Error));
                }
                if ((unit = entry.getDynamicObject("unit")) == null && APPLY_MATERIAL.equals(applyMaterial)) {
                    this.addMessage(entity, String.format(ResManager.loadKDString((String)"\u9002\u7528\u7269\u6599\u65b9\u5f0f\u4e3a\u201c\u7269\u6599\u201d\u65f6\uff0c\u4ef7\u683c\u660e\u7ec6\u7b2c%1$s\u884c\u7684\u8ba1\u91cf\u5355\u4f4d\u5fc5\u987b\u586b\u5199\u3002", (String)"SalePriceListMaterialValidator_3", (String)"scmc-sm-opplugin", (Object[])new Object[0]), row + 1, ErrorLevel.Error));
                }
                if (unit != null && APPLY_MATERIAL_GROUP.equals(applyMaterial)) {
                    this.addMessage(entity, String.format(ResManager.loadKDString((String)"\u9002\u7528\u7269\u6599\u65b9\u5f0f\u4e3a\u201c\u7269\u6599\u5206\u7c7b\u201d\u65f6\uff0c\u4ef7\u683c\u660e\u7ec6\u7b2c%1$s\u884c\u7684\u8ba1\u91cf\u5355\u4f4d\u4e0d\u9700\u8981\u586b\u5199\u3002", (String)"SalePriceListMaterialValidator_4", (String)"scmc-sm-opplugin", (Object[])new Object[0]), row + 1, ErrorLevel.Error));
                }
                if (material != null) {
                    boolean checkUnit;
                    DynamicObject baseUnit = material.getDynamicObject("baseunit");
                    if (unit != null && baseUnit != null && !unit.getPkValue().equals(baseUnit.getPkValue()) && !(checkUnit = MaterialHelper.checkUnit((Long)material.getLong(ID), (Long)((Long)baseUnit.getPkValue()), (Long)((Long)unit.getPkValue())))) {
                        this.addMessage(entity, String.format(ResManager.loadKDString((String)"\u4ef7\u683c\u660e\u7ec6\u7b2c%1$s\u884c\u8ba1\u91cf\u5355\u4f4d\u7f16\u7801\u201c%2$s\u201d\u4e0d\u662f\u7269\u6599\u201c%3$s\u201d\u7684\u53ef\u7528\u8ba1\u91cf\u5355\u4f4d\u3002", (String)"SalePriceListMaterialValidator_5", (String)"scmc-sm-opplugin", (Object[])new Object[0]), row + 1, unit.getString(NUMBER), material.getString(NUMBER)), ErrorLevel.Error);
                    }
                }
                Date priceEffectDate = entry.getDate("priceeffectdate");
                Date priceExpiryDate = entry.getDate("priceexpirydate");
                if (priceExpiryDate != null && priceEffectDate != null && priceEffectDate.after(priceExpiryDate)) {
                    this.addMessage(entity, String.format(ResManager.loadKDString((String)"\u4ef7\u683c\u660e\u7ec6\u7b2c%1$s\u884c\u4ef7\u683c\u751f\u6548\u65e5\u671f\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u4ef7\u683c\u5931\u6548\u65e5\u671f\u3002", (String)"SalePriceListMaterialValidator_6", (String)"scmc-sm-opplugin", (Object[])new Object[0]), row + 1, ErrorLevel.Error));
                }
                this.handlePriceAndTax(entry, entity, isTax, taxRate, row);
            }
        }
    }

    private Map<Object, DynamicObject> getMaterialMap() {
        HashSet<Object> materialSalInfoIdSet = new HashSet<Object>(8);
        for (ExtendedDataEntity entity : this.getDataEntities()) {
            DynamicObjectCollection priceEntryEntity;
            DynamicObject bill = entity.getDataEntity();
            if (bill == null || ObjectUtils.isEmpty((Object)(priceEntryEntity = bill.getDynamicObjectCollection("priceentryentity")))) continue;
            for (int row = 0; row < priceEntryEntity.size(); ++row) {
                DynamicObject entry = (DynamicObject)priceEntryEntity.get(row);
                DynamicObject materialSalInfo = entry.getDynamicObject("material");
                if (materialSalInfo == null) continue;
                materialSalInfoIdSet.add(materialSalInfo.getPkValue());
            }
        }
        if (ObjectUtils.isEmpty(materialSalInfoIdSet)) {
            return Collections.emptyMap();
        }
        Map idAndMaterialSalInfoMap = BusinessDataServiceHelper.loadFromCache((String)"bd_materialsalinfo", (String)"id,masterid.id,masterid.number,masterid.baseunit", (QFilter[])new QFilter[]{new QFilter(ID, "in", materialSalInfoIdSet)});
        HashMap<Object, DynamicObject> resMap = new HashMap<Object, DynamicObject>(idAndMaterialSalInfoMap.size());
        for (Map.Entry entry : idAndMaterialSalInfoMap.entrySet()) {
            resMap.put(entry.getKey(), ((DynamicObject)entry.getValue()).getDynamicObject(MASTERID));
        }
        return resMap;
    }

    private void handlePriceAndTax(DynamicObject entry, ExtendedDataEntity entity, boolean isTax, BigDecimal taxRate, int row) {
        BigDecimal priceAndTax = entry.getBigDecimal("priceandtax");
        BigDecimal price = entry.getBigDecimal("price");
        BigDecimal minPrice = entry.getBigDecimal("pricefloor");
        BigDecimal maxPrice = entry.getBigDecimal("priceceiling");
        if (isTax) {
            if (BigDecimalUtil.isBlank((BigDecimal)priceAndTax)) {
                this.addMessage(entity, String.format(ResManager.loadKDString((String)"\u4ef7\u683c\u660e\u7ec6\u7b2c%1$s\u884c\u542b\u7a0e\u4e3a\u201c\u662f\u201d\uff0c\u8bf7\u5f55\u5165\u542b\u7a0e\u5355\u4ef7\u3002", (String)"SalePriceListMaterialValidator_7", (String)"scmc-sm-opplugin", (Object[])new Object[0]), row + 1, ErrorLevel.Error));
                return;
            }
            BigDecimal expectPrice = priceAndTax.divide(BigDecimalUtil.ONE.add(BigDecimalUtil.div100((BigDecimal)taxRate)), 10, RoundingMode.HALF_UP);
            if (BigDecimalUtil.notEquals((BigDecimal)price, (BigDecimal)expectPrice)) {
                this.addMessage(entity, String.format(ResManager.loadKDString((String)"\u4ef7\u683c\u660e\u7ec6\u7b2c%1$s\u884c\u5355\u4ef7*\uff081+\u7a0e\u7387\uff09\u4e0d\u7b49\u4e8e\u542b\u7a0e\u5355\u4ef7\u3002", (String)"SalePriceListMaterialValidator_12", (String)"scmc-sm-opplugin", (Object[])new Object[0]), row + 1, ErrorLevel.Error));
            }
        } else {
            if (BigDecimalUtil.isBlank((BigDecimal)price)) {
                this.addMessage(entity, String.format(ResManager.loadKDString((String)"\u4ef7\u683c\u660e\u7ec6\u7b2c%1$s\u884c\u201c\u542b\u7a0e\u201d\u4e3a\u201c\u5426\u201d\uff0c\u8bf7\u5f55\u5165\u5355\u4ef7\u3002", (String)"SalePriceListMaterialValidator_8", (String)"scmc-sm-opplugin", (Object[])new Object[0]), row + 1, ErrorLevel.Error));
                return;
            }
            BigDecimal expectPriceAndTax = price.multiply(BigDecimalUtil.ONE.add(BigDecimalUtil.div100((BigDecimal)taxRate))).setScale(10, RoundingMode.HALF_UP);
            if (BigDecimalUtil.notEquals((BigDecimal)priceAndTax, (BigDecimal)expectPriceAndTax)) {
                this.addMessage(entity, String.format(ResManager.loadKDString((String)"\u4ef7\u683c\u660e\u7ec6\u7b2c%1$s\u884c\u5355\u4ef7*\uff081+\u7a0e\u7387\uff09\u4e0d\u7b49\u4e8e\u542b\u7a0e\u5355\u4ef7\u3002", (String)"SalePriceListMaterialValidator_12", (String)"scmc-sm-opplugin", (Object[])new Object[0]), row + 1, ErrorLevel.Error));
            }
        }
        if (BigDecimalUtil.isNotBlank((BigDecimal)priceAndTax) && BigDecimalUtil.lessThan((BigDecimal)priceAndTax, (BigDecimal)minPrice)) {
            this.addMessage(entity, String.format(ResManager.loadKDString((String)"\u4ef7\u683c\u660e\u7ec6\u7b2c%1$s\u884c\u542b\u7a0e\u5355\u4ef7\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u6700\u4f4e\u9650\u4ef7\u3002", (String)"SalePriceListMaterialValidator_9", (String)"scmc-sm-opplugin", (Object[])new Object[0]), row + 1, ErrorLevel.Error));
        }
        if (BigDecimalUtil.isNotBlank((BigDecimal)maxPrice)) {
            if (BigDecimalUtil.lessThan((BigDecimal)maxPrice, (BigDecimal)minPrice)) {
                this.addMessage(entity, String.format(ResManager.loadKDString((String)"\u4ef7\u683c\u660e\u7ec6\u7b2c%1$s\u884c\u6700\u9ad8\u9650\u4ef7\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u6700\u4f4e\u9650\u4ef7\u3002", (String)"SalePriceListMaterialValidator_10", (String)"scmc-sm-opplugin", (Object[])new Object[0]), row + 1, ErrorLevel.Error));
            }
            if (BigDecimalUtil.largeThan((BigDecimal)priceAndTax, (BigDecimal)maxPrice)) {
                this.addMessage(entity, String.format(ResManager.loadKDString((String)"\u4ef7\u683c\u660e\u7ec6\u7b2c%1$s\u884c\u542b\u7a0e\u5355\u4ef7\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u6700\u9ad8\u9650\u4ef7\u3002", (String)"SalePriceListMaterialValidator_11", (String)"scmc-sm-opplugin", (Object[])new Object[0]), row + 1, ErrorLevel.Error));
            }
        }
    }
}

