/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pms.validation.price;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.mpscmm.msbd.common.utils.CommonUtils;

public class SalePriceListStairValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        HashSet<String> prepareProperties = super.preparePropertys();
        if (CommonUtils.isNull((Object)prepareProperties)) {
            prepareProperties = new HashSet<String>(8);
        }
        prepareProperties.add("org");
        prepareProperties.add("isstair");
        prepareProperties.add("isstairprice");
        prepareProperties.add("pricefloor");
        prepareProperties.add("priceceiling");
        prepareProperties.add("stairprice");
        prepareProperties.add("stairqtystart");
        prepareProperties.add("stairqtyend");
        return prepareProperties;
    }

    public void validate() {
        if (this.getDataEntities() == null || this.getDataEntities().length == 0) {
            return;
        }
        for (ExtendedDataEntity entity : this.getDataEntities()) {
            DynamicObject org;
            DynamicObject bill = entity.getDataEntity();
            if (bill == null || (org = bill.getDynamicObject("org")) == null) continue;
            Boolean isStair = bill.getBoolean("isstair");
            DynamicObjectCollection priceEntryEntity = bill.getDynamicObjectCollection("priceentryentity");
            if (priceEntryEntity.isEmpty()) continue;
            for (int row = 0; row < priceEntryEntity.size(); ++row) {
                DynamicObject entry = (DynamicObject)priceEntryEntity.get(row);
                Boolean isStairPrice = entry.getBoolean("isstairprice");
                BigDecimal minPrice = entry.getBigDecimal("pricefloor");
                BigDecimal maxPrice = entry.getBigDecimal("priceceiling");
                DynamicObjectCollection salStairPriceEntity = entry.getDynamicObjectCollection("salstairprice");
                if (!isStair.booleanValue()) {
                    if (isStairPrice.booleanValue()) {
                        this.addMessage(entity, String.format(ResManager.loadKDString((String)"\u542f\u7528\u9636\u68af\u4e3a\u201c\u5426\u201d\uff0c\u4ef7\u683c\u660e\u7ec6\u7b2c%1$s\u884c\u7684\u9636\u68af\u4ef7\u683c\u4e0d\u80fd\u4e3a\u201c\u662f\u201d\u3002", (String)"SalePriceListStairValidator_0", (String)"scmc-sm-opplugin", (Object[])new Object[0]), row + 1, ErrorLevel.Error));
                    }
                    if (salStairPriceEntity.size() > 0) {
                        this.addMessage(entity, String.format(ResManager.loadKDString((String)"\u542f\u7528\u9636\u68af\u4e3a\u201c\u5426\u201d\uff0c\u4ef7\u683c\u660e\u7ec6\u7b2c%1$s\u884c\u5bf9\u5e94\u7684\u9636\u68af\u4ef7\u683c\u5b50\u5206\u5f55\u4e0d\u80fd\u6709\u503c\u3002", (String)"SalePriceListStairValidator_1", (String)"scmc-sm-opplugin", (Object[])new Object[0]), row + 1, ErrorLevel.Error));
                    }
                }
                if (isStairPrice.booleanValue()) {
                    if (salStairPriceEntity.size() <= 1) {
                        this.addStairPriceEntityErrorMessage(entity, row);
                        continue;
                    }
                    BigDecimal lastStairQtyEnd = BigDecimal.ZERO;
                    for (int childRow = 0; childRow < salStairPriceEntity.size(); ++childRow) {
                        DynamicObject childEntry = (DynamicObject)salStairPriceEntity.get(childRow);
                        BigDecimal stairQtyStart = (BigDecimal)childEntry.get("stairqtystart");
                        BigDecimal stairQtyEnd = (BigDecimal)childEntry.get("stairqtyend");
                        if (!BigDecimalUtil.largeThan((BigDecimal)stairQtyEnd, (BigDecimal)stairQtyStart)) {
                            this.addStairPriceEntityErrorMessage(entity, row);
                        }
                        if (childRow == 0 && BigDecimalUtil.isNotZero((BigDecimal)stairQtyStart)) {
                            this.addStairPriceEntityErrorMessage(entity, row);
                        }
                        if (childRow > 0 && BigDecimalUtil.notEquals((BigDecimal)stairQtyStart, (BigDecimal)lastStairQtyEnd)) {
                            this.addStairPriceEntityErrorMessage(entity, row);
                        }
                        lastStairQtyEnd = stairQtyEnd;
                        BigDecimal stairPrice = (BigDecimal)childEntry.get("stairprice");
                        if (BigDecimalUtil.isBlank((BigDecimal)stairPrice)) {
                            this.addMessage(entity, String.format(ResManager.loadKDString((String)"\u4ef7\u683c\u660e\u7ec6\u7b2c%1$s\u884c\u7684\u9636\u68af\u4ef7\u683c\u4e3a\u201c\u662f\u201d\u65f6\uff0c\u5bf9\u5e94\u7684\u9636\u68af\u4ef7\u683c\u5b50\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SalePriceListStairValidator_3", (String)"scmc-sm-opplugin", (Object[])new Object[0]), row + 1, ErrorLevel.Error));
                            continue;
                        }
                        if (BigDecimalUtil.isNotBlank((BigDecimal)maxPrice) && BigDecimalUtil.largeThan((BigDecimal)stairPrice, (BigDecimal)maxPrice)) {
                            this.addMessage(entity, String.format(ResManager.loadKDString((String)"\u4ef7\u683c\u660e\u7ec6\u7b2c%1$s\u884c\u7684\u9636\u68af\u4ef7\u683c\u5b50\u5206\u5f55\u7ef4\u62a4\u6709\u8bef\uff1a\u9636\u68af\u4ef7\u683c\u4e0d\u80fd\u5927\u4e8e\u6700\u9ad8\u9650\u4ef7\u3002", (String)"SalePriceListStairValidator_4", (String)"scmc-sm-opplugin", (Object[])new Object[0]), row + 1, ErrorLevel.Error));
                        }
                        if (!BigDecimalUtil.lessThan((BigDecimal)stairPrice, (BigDecimal)minPrice)) continue;
                        this.addMessage(entity, String.format(ResManager.loadKDString((String)"\u4ef7\u683c\u660e\u7ec6\u7b2c%1$s\u884c\u7684\u9636\u68af\u4ef7\u683c\u5b50\u5206\u5f55\u7ef4\u62a4\u6709\u8bef\uff1a\u9636\u68af\u4ef7\u683c\u4e0d\u80fd\u5c0f\u4e8e\u6700\u4f4e\u9650\u4ef7\u3002", (String)"SalePriceListStairValidator_5", (String)"scmc-sm-opplugin", (Object[])new Object[0]), row + 1, ErrorLevel.Error));
                    }
                    continue;
                }
                if (salStairPriceEntity.size() <= 0) continue;
                this.addStairPriceEntityErrorMessage(entity, row);
            }
        }
    }

    private void addStairPriceEntityErrorMessage(ExtendedDataEntity entity, int row) {
        this.addMessage(entity, String.format(ResManager.loadKDString((String)"\u4ef7\u683c\u660e\u7ec6\u7b2c%1$s\u884c\u5bf9\u5e94\u7684\u9636\u68af\u4ef7\u683c\u5b50\u5206\u5f55\u7ef4\u62a4\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"SalePriceListStairValidator_2", (String)"scmc-sm-opplugin", (Object[])new Object[0]), row + 1, ErrorLevel.Error));
    }
}

