/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pms.validation.price;

import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;

public class SalePriceListTaxValidator
extends AbstractValidator {
    private static final String ID = "id";
    private static final String NUMBER = "number";

    public Set<String> preparePropertys() {
        HashSet<String> prepareProperties = super.preparePropertys();
        if (CommonUtils.isNull((Object)prepareProperties)) {
            prepareProperties = new HashSet<String>(8);
        }
        prepareProperties.add("createtime");
        prepareProperties.add("taxrate");
        prepareProperties.add("taxrateid");
        return prepareProperties;
    }

    public void validate() {
        if (this.getDataEntities() == null || this.getDataEntities().length == 0) {
            return;
        }
        Map<Object, DynamicObject> taxRateIdMap = this.getTaxRateIdMap();
        if (ObjectUtils.isEmpty(taxRateIdMap)) {
            return;
        }
        for (ExtendedDataEntity entity : this.getDataEntities()) {
            DynamicObjectCollection priceEntryEntity;
            Date createTime;
            DynamicObject bill = entity.getDataEntity();
            if (bill == null || (createTime = bill.getDate("createtime")) == null || (priceEntryEntity = bill.getDynamicObjectCollection("priceentryentity")).isEmpty()) continue;
            for (int row = 0; row < priceEntryEntity.size(); ++row) {
                Long taxRateIdId;
                DynamicObject entry = (DynamicObject)priceEntryEntity.get(row);
                DynamicObject taxRateId = entry.getDynamicObject("taxrateid");
                if (taxRateId == null || (taxRateId = taxRateIdMap.get(taxRateIdId = (Long)taxRateId.getPkValue())) == null) continue;
                Date activeDate = taxRateId.getDate("activedate");
                Date expDate = taxRateId.getDate("expdate");
                if ((activeDate == null || activeDate.compareTo(createTime) <= 0) && (expDate == null || expDate.compareTo(createTime) >= 0)) continue;
                this.addMessage(entity, String.format(ResManager.loadKDString((String)"\u4ef7\u683c\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u201c\u521b\u5efa\u65f6\u95f4\u201d\u672a\u5728\u7a0e\u7387\u201c%2$s\u201d\u7684\u6709\u6548\u65e5\u671f\u8303\u56f4\u5185\u3002", (String)"SalePriceListTaxValidator_0", (String)"scmc-sm-opplugin", (Object[])new Object[0]), row + 1, taxRateId.getString(NUMBER)), ErrorLevel.Error);
            }
        }
    }

    private Map<Object, DynamicObject> getTaxRateIdMap() {
        HashSet<Long> idSet = new HashSet<Long>(8);
        for (ExtendedDataEntity entity : this.getDataEntities()) {
            DynamicObjectCollection priceEntryEntity;
            DynamicObject bill = entity.getDataEntity();
            if (bill == null || ObjectUtils.isEmpty((Object)(priceEntryEntity = bill.getDynamicObjectCollection("priceentryentity")))) continue;
            for (int row = 0; row < priceEntryEntity.size(); ++row) {
                DynamicObject entry = (DynamicObject)priceEntryEntity.get(row);
                DynamicObject taxRateId = entry.getDynamicObject("taxrateid");
                if (taxRateId == null) continue;
                idSet.add((Long)taxRateId.getPkValue());
            }
        }
        if (ObjectUtils.isEmpty(idSet)) {
            return Collections.emptyMap();
        }
        return BusinessDataServiceHelper.loadFromCache((String)"bd_taxrate", (String)"id,number, taxrate,activedate,expdate", (QFilter[])new QFilter[]{new QFilter(ID, "in", idSet)});
    }
}

