/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pms.validation.price;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.scmc.pms.business.helper.SalesStairPriceHelper;

public class SalesPriceSubmitValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObjectCollection cusEntries;
            DynamicObject bill = data.getDataEntity();
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("priceentryentity");
            Date effectDate = (Date)bill.get("effectdate");
            Date expDate = (Date)bill.get("expirydate");
            if (effectDate != null && expDate != null && effectDate.after(expDate)) {
                this.addMessage(data, ResManager.loadKDString((String)"\u4ef7\u76ee\u751f\u6548\u65e5\u671f\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u4ef7\u76ee\u5931\u6548\u65e5\u671f\u3002", (String)"SalesPriceSubmitValidator_6", (String)"scmc-sm-opplugin", (Object[])new Object[0]));
            }
            Boolean istax = bill.getBoolean("istax");
            if (entries != null && entries.size() > 0) {
                for (DynamicObject entry : entries) {
                    BigDecimal maxPrice;
                    DynamicObject materialgroup;
                    Object applymaterial = bill.get("applymaterial");
                    if ("A".equals(applymaterial)) {
                        DynamicObject unit;
                        DynamicObject material = entry.getDynamicObject("material");
                        if (material == null) {
                            this.addMessage(data, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u4ef7\u683c\u660e\u7ec6\u5355\u636e\u4f53\u201d\u7b2c%s\u884c\u201c\u7269\u6599\u7f16\u7801\u201d\u3002", (String)"SalesPriceSubmitValidator_2", (String)"scmc-sm-opplugin", (Object[])new Object[0]), entry.getInt("seq")));
                        }
                        if ((unit = entry.getDynamicObject("unit")) == null) {
                            this.addMessage(data, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u4ef7\u683c\u660e\u7ec6\u5355\u636e\u4f53\u201d\u7b2c%s\u884c\u201c\u8ba1\u91cf\u5355\u4f4d\u201d\u3002", (String)"SalesPriceSubmitValidator_12", (String)"scmc-sm-opplugin", (Object[])new Object[0]), entry.getInt("seq")));
                        }
                    }
                    if ("B".equals(applymaterial) && (materialgroup = entry.getDynamicObject("materialgroup")) == null) {
                        this.addMessage(data, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u4ef7\u683c\u660e\u7ec6\u5355\u636e\u4f53\u201d\u7b2c%s\u884c\u201c\u7269\u6599\u5206\u7c7b\u7f16\u7801\u201d\u3002", (String)"SalesPriceSubmitValidator_3", (String)"scmc-sm-opplugin", (Object[])new Object[0]), entry.getInt("seq")));
                    }
                    BigDecimal priceandtax = entry.getBigDecimal("priceandtax");
                    BigDecimal price = entry.getBigDecimal("price");
                    if (istax.booleanValue()) {
                        if (BigDecimal.ZERO.compareTo(priceandtax) == 0) {
                            this.addMessage(data, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u4ef7\u683c\u660e\u7ec6\u5355\u636e\u4f53\u201d\u7b2c%s\u884c\u201c\u542b\u7a0e\u5355\u4ef7\u201d\u3002", (String)"SalesPriceSubmitValidator_4", (String)"scmc-sm-opplugin", (Object[])new Object[0]), entry.getInt("seq")));
                        }
                    } else if (BigDecimal.ZERO.compareTo(price) == 0) {
                        this.addMessage(data, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u4ef7\u683c\u660e\u7ec6\u5355\u636e\u4f53\u201d\u7b2c%s\u884c\u201c\u5355\u4ef7\u201d\u3002", (String)"SalesPriceSubmitValidator_5", (String)"scmc-sm-opplugin", (Object[])new Object[0]), entry.getInt("seq")));
                    }
                    BigDecimal priceFloor = entry.getBigDecimal("pricefloor");
                    BigDecimal priceCeiling = entry.getBigDecimal("priceceiling");
                    if (priceCeiling.compareTo(BigDecimal.ZERO) > 0 && priceFloor.compareTo(priceCeiling) > 0) {
                        this.addMessage(data, String.format(ResManager.loadKDString((String)"\u4ef7\u683c\u660e\u7ec6\u7b2c%s\u884c\u6700\u9ad8\u9650\u4ef7\u5e94\u5927\u4e8e\u7b49\u4e8e\u6700\u4f4e\u9650\u4ef7\u3002", (String)"SalesPriceSubmitValidator_7", (String)"scmc-sm-opplugin", (Object[])new Object[0]), entry.getInt("seq")));
                    }
                    if (priceCeiling.compareTo(BigDecimal.ZERO) > 0 && priceandtax.compareTo(priceCeiling) > 0) {
                        this.addMessage(data, String.format(ResManager.loadKDString((String)"\u4ef7\u683c\u660e\u7ec6\u7b2c%s\u884c\u542b\u7a0e\u5355\u4ef7\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u6700\u9ad8\u9650\u4ef7\u3002", (String)"SalesPriceSubmitValidator_8", (String)"scmc-sm-opplugin", (Object[])new Object[0]), entry.getInt("seq")));
                    }
                    if (priceFloor.compareTo(BigDecimal.ZERO) > 0 && priceandtax.compareTo(priceFloor) < 0) {
                        this.addMessage(data, String.format(ResManager.loadKDString((String)"\u4ef7\u683c\u660e\u7ec6\u7b2c%s\u884c\u542b\u7a0e\u5355\u4ef7\u5e94\u5927\u4e8e\u7b49\u4e8e\u6700\u4f4e\u9650\u4ef7\u3002", (String)"SalesPriceSubmitValidator_9", (String)"scmc-sm-opplugin", (Object[])new Object[0]), entry.getInt("seq")));
                    }
                    Date priceEffDate = entry.getDate("priceeffectdate");
                    Date priceExpDate = entry.getDate("priceexpirydate");
                    if (priceExpDate != null && priceEffDate != null && priceEffDate.after(priceExpDate)) {
                        this.addMessage(data, String.format(ResManager.loadKDString((String)"\u4ef7\u683c\u660e\u7ec6\u7b2c%s\u884c\u4ef7\u683c\u751f\u6548\u65e5\u671f\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u4ef7\u683c\u5931\u6548\u65e5\u671f\u3002", (String)"SalesPriceSubmitValidator_10", (String)"scmc-sm-opplugin", (Object[])new Object[0]), entry.getInt("seq")));
                    }
                    BigDecimal qtyFrom = entry.getBigDecimal("qtyfrom");
                    BigDecimal qtyTo = entry.getBigDecimal("qtyto");
                    if (qtyTo.compareTo(BigDecimal.ZERO) != 0 && qtyTo.subtract(qtyFrom).compareTo(BigDecimal.ZERO) < 0) {
                        this.addMessage(data, String.format(ResManager.loadKDString((String)"\u4ef7\u683c\u660e\u7ec6\u7b2c%s\u884c\u9500\u552e\u6570\u91cf\uff08\u4ece\uff09\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u9500\u552e\u6570\u91cf\uff08\u81f3\uff09\u3002", (String)"SalesPriceSubmitValidator_11", (String)"scmc-sm-opplugin", (Object[])new Object[0]), entry.getInt("seq")));
                    }
                    if (!entry.getBoolean("isstairprice")) continue;
                    DynamicObjectCollection stairPrices = (DynamicObjectCollection)entry.get("salstairprice");
                    BigDecimal minPrice = entry.getBigDecimal("pricefloor");
                    int count = SalesStairPriceHelper.getCheckStairPrice((BigDecimal)minPrice, (BigDecimal)(maxPrice = entry.getBigDecimal("priceceiling")), (DynamicObjectCollection)stairPrices);
                    if (count == 0) continue;
                    String msgDetail = SalesStairPriceHelper.getDetailMsg((int)count);
                    String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u4ef7\u683c\u660e\u7ec6\u5bf9\u5e94\u7684\u9636\u68af\u4ef7\u683c\u5b50\u5206\u5f55\u6570\u636e\u9519\u8bef\uff0c\u8bf7\u4fee\u6539\u3002", (String)"SalesPriceSubmitValidator_1", (String)"scmc-sm-opplugin", (Object[])new Object[0]), entry.getInt("seq")) + msgDetail;
                    this.addMessage(data, msg);
                }
            }
            if ((cusEntries = bill.getDynamicObjectCollection("customerentryentity")) == null || cusEntries.size() <= 0) continue;
            Object applyCustomer = bill.get("applycustomer");
            for (DynamicObject cusEntry : cusEntries) {
                DynamicObject customerGroup;
                DynamicObject customer;
                if ("B".equals(applyCustomer) && (customer = cusEntry.getDynamicObject("customer")) == null) {
                    this.addMessage(data, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5ba2\u6237\u660e\u7ec6\u5355\u636e\u4f53\u201d\u7b2c%s\u884c\u201c\u5ba2\u6237\u7f16\u7801\u201d\u3002", (String)"SalesPriceAdjustSubmitValidator_9", (String)"scmc-sm-opplugin", (Object[])new Object[0]), cusEntry.getInt("seq")));
                }
                if (!"C".equals(applyCustomer) || (customerGroup = cusEntry.getDynamicObject("customergroup")) != null) continue;
                this.addMessage(data, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5ba2\u6237\u660e\u7ec6\u5355\u636e\u4f53\u201d\u7b2c%s\u884c\uff1a\u201c\u5ba2\u6237\u5206\u7c7b\u7f16\u7801\u201d\u3002", (String)"SalesPriceAdjustSubmitValidator_10", (String)"scmc-sm-opplugin", (Object[])new Object[0]), cusEntry.getInt("seq")));
            }
        }
    }
}

