/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.opplugin.notice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msbd.business.helper.SysParamHelper;
import kd.scmc.sm.business.helper.BotpHelper;
import kd.scmc.sm.business.helper.InspectionHelper;
import kd.scmc.sm.business.helper.MetaDataHelper;
import kd.scmc.sm.business.helper.SystemCallParamHelper;
import kd.scmc.sm.business.pojo.ReturnResultInfo;
import kd.scmc.sm.consts.DeliverNoticeEntryConst;

public class DeliverNoticeAuditOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(DeliverNoticeAuditOp.class);
    private static final String APP_ID = "/JJVQ13HQZAJ";

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] bills = e.getDataEntities();
        HashSet<Long> orgIdSet = new HashSet<Long>();
        for (DynamicObject bill : bills) {
            if (bill.getDynamicObject("org") == null) continue;
            orgIdSet.add(bill.getDynamicObject("org").getLong("id"));
        }
        Map orgIdAndParamMap = SysParamHelper.batchGetSysParam((String)APP_ID, (String)"03", new ArrayList(orgIdSet), (String)"enablesminspect");
        boolean sm_qmcFlag = SystemCallParamHelper.isEnable((String)"sbs_intersystemcallconf", (String)"KC0003");
        for (DynamicObject bill : bills) {
            DynamicObjectCollection billEntrys = bill.getDynamicObjectCollection("billentry");
            Object enablesminspect = orgIdAndParamMap.get(String.valueOf(bill.getDynamicObject("org").getLong("id")));
            if (enablesminspect != null && !((Boolean)enablesminspect).booleanValue()) {
                for (DynamicObject entry : billEntrys) {
                    entry.set("isinspect", (Object)Boolean.FALSE);
                }
                continue;
            }
            if (sm_qmcFlag) {
                if (MetaDataHelper.isBizAppExistQcbd()) {
                    ArrayList<Integer> indexs = new ArrayList<Integer>(16);
                    for (int j = 0; j < billEntrys.size(); ++j) {
                        indexs.add(j);
                    }
                    Set needInspectIndex = InspectionHelper.getNeedInspectByIndex((DynamicObject)bill, indexs, (String)"qcas-001");
                    for (int k = 0; k < billEntrys.size(); ++k) {
                        DynamicObject entry = (DynamicObject)billEntrys.get(k);
                        if (needInspectIndex != null && needInspectIndex.contains(k)) {
                            entry.set("isinspect", (Object)Boolean.TRUE);
                            continue;
                        }
                        entry.set("isinspect", (Object)Boolean.FALSE);
                    }
                    continue;
                }
                for (DynamicObject entry : billEntrys) {
                    entry.set("isinspect", (Object)Boolean.FALSE);
                }
                continue;
            }
            for (DynamicObject entry : billEntrys) {
                if (entry == null || entry.getDynamicObject("material") == null || entry.getDynamicObject("material").getDynamicObject("masterid") == null) continue;
                boolean isDeliverInspect = entry.getDynamicObject("material").getBoolean("isdeliverinspect");
                entry.set("isinspect", (Object)isDeliverInspect);
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] bills = e.getDataEntities();
        HashMap<Long, Long> sourceIdMap = new HashMap<Long, Long>(16);
        for (DynamicObject bill : bills) {
            Long billID = (Long)bill.getPkValue();
            DynamicObjectCollection billEntrys = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : billEntrys) {
                if (entry == null || !entry.getBoolean("isinspect")) continue;
                sourceIdMap.put((Long)entry.getPkValue(), billID);
            }
        }
        if (sourceIdMap != null && sourceIdMap.size() > 0) {
            try {
                String ruleId = "1668894672006694912";
                ReturnResultInfo rrInfo = BotpHelper.botpGenerateTargetBill(sourceIdMap, (String)ruleId, (String)"sm_delivernotice", (String)"billentry", (String)"im_invinspectbill", (String)"save", null, (boolean)true);
                if (rrInfo != null && !rrInfo.isSuccess()) {
                    log.info(rrInfo.getMessage());
                }
            }
            catch (KDBizException kdBizExc) {
                log.info("\u81ea\u52a8\u4e0b\u63a8\u5e93\u5b58\u8bf7\u68c0\u5355\u5931\u8d25\uff1a" + kdBizExc.getMessage());
            }
            catch (KDException kdExc) {
                log.info("\u81ea\u52a8\u4e0b\u63a8\u5e93\u5b58\u8bf7\u68c0\u5355\u5931\u8d25\uff1a" + kdExc.getMessage());
            }
            catch (Exception exc) {
                log.info("\u81ea\u52a8\u4e0b\u63a8\u5e93\u5b58\u8bf7\u68c0\u5355\u5931\u8d25\uff1a" + exc.getMessage());
            }
        }
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        DeliverNoticeEntryConst.getAuditProperties().forEach(f -> e.getFieldKeys().add(f));
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("inspectorg");
        e.getFieldKeys().add("isinspect");
        e.getFieldKeys().add("material.masterid.enableinspect");
        e.getFieldKeys().add("material.isdeliverinspect");
    }
}

