/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.opplugin.order;

import java.math.BigDecimal;
import java.util.Arrays;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.scmc.sm.business.helper.KitSalesHelper;
import kd.scmc.sm.business.helper.SalOrderRecPlanHelper;
import kd.scmc.sm.validator.order.BlockedOrderValidator;
import kd.scmc.sm.validator.order.CanSaleControlValidator;
import kd.scmc.sm.validator.order.DiscountTypeValidator;
import kd.scmc.sm.validator.order.MaterialTypeValidator;
import kd.scmc.sm.validator.order.MinOrderQtyValidator;
import kd.scmc.sm.validator.order.PurOrgSubmitValidator;
import kd.scmc.sm.validator.order.VMISupplytransValidator;
import kd.scmc.sm.validator.tpl.KitSalesOwnerValidator;
import kd.scmc.sm.validator.tpl.KitSalesValidator;
import kd.scmc.sm.validator.tpl.VMIOwnerValidator;

public class OrderSubmitOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("supplytrans");
        e.getFieldKeys().add("purorg");
        e.getFieldKeys().add("baseunit");
        e.getFieldKeys().add("material");
        e.getFieldKeys().add("owner");
        e.getFieldKeys().add("ownertype");
        e.getFieldKeys().add("istax");
        e.getFieldKeys().add("discounttype");
        e.getFieldKeys().add("discountrate");
        e.getFieldKeys().add("billtype");
        e.getFieldKeys().add("biztype");
        e.getFieldKeys().add("totalallamount");
        e.getFieldKeys().add("amountandtax");
        e.getFieldKeys().add("r_recadvanceamount");
        e.getFieldKeys().add("r_remainamount");
        e.getFieldKeys().add("r_unremainamount");
        e.getFieldKeys().add("entrychangetype");
        e.getFieldKeys().add("recentrychangetype");
        e.getFieldKeys().add("minorderbaseqty");
        e.getFieldKeys().add("supplier");
        Arrays.asList("qty", "baseqty", "entrysettleorg", "r_recsettleorg").forEach(f -> e.getFieldKeys().add(f));
        e.getFieldKeys().add("customer");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("operator");
        e.getFieldKeys().add("operatorgroup");
        e.getFieldKeys().add("dept");
        e.getFieldKeys().add("billentry.seq");
        e.getFieldKeys().add("materialmasterid");
        e.getFieldKeys().add("producttype");
        e.getFieldKeys().add("pricemodel");
        e.getFieldKeys().add("kitpid");
        e.getFieldKeys().add("kitqty");
        e.getFieldKeys().add("parentqty");
        e.getFieldKeys().add("bom");
        e.getFieldKeys().add("entrychangetype");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new PurOrgSubmitValidator());
        e.addValidator((AbstractValidator)new MinOrderQtyValidator());
        e.addValidator((AbstractValidator)new DiscountTypeValidator());
        e.addValidator((AbstractValidator)new MaterialTypeValidator());
        e.addValidator(SalOrderRecPlanHelper.getRecAmountValidator());
        e.addValidator((AbstractValidator)new VMISupplytransValidator());
        e.addValidator((AbstractValidator)new VMIOwnerValidator());
        e.addValidator((AbstractValidator)new BlockedOrderValidator());
        e.addValidator((AbstractValidator)new CanSaleControlValidator());
        e.addValidator((AbstractValidator)new KitSalesValidator());
        e.addValidator((AbstractValidator)new KitSalesOwnerValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] bills;
        for (DynamicObject bill : bills = e.getDataEntities()) {
            DynamicObjectCollection billEntrys = bill.getDynamicObjectCollection("billentry");
            if (billEntrys.size() <= 0) continue;
            DynamicObject org = ((DynamicObject)billEntrys.get(0)).getDynamicObject("entrysettleorg");
            DynamicObjectCollection rec = bill.getDynamicObjectCollection("recplanentry");
            for (DynamicObject row : rec) {
                row.set("r_recsettleorg", (Object)org);
                BigDecimal payAmount = row.getBigDecimal("r_recadvanceamount") == null ? BigDecimal.ZERO : row.getBigDecimal("r_recadvanceamount");
                BigDecimal needRemainAmount = row.getBigDecimal("r_remainamount") == null ? BigDecimal.ZERO : row.getBigDecimal("r_remainamount");
                row.set("r_unremainamount", (Object)payAmount.subtract(needRemainAmount));
            }
        }
        KitSalesHelper.setKitQtyDefValue((DynamicObject[])bills);
    }
}

