/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.opplugin.order;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.scmc.sm.business.custom.ext.bizextplugin.XSalOrderSynOrderStatusImpl;
import kd.scmc.sm.business.helper.KitSalesHelper;
import kd.scmc.sm.business.helper.SalOrderRecPlanHelper;
import kd.sdk.scmc.sm.extpoint.IXSalOrderCasePlugin;

public class XSSalOrderBillActiveOp
extends AbstractOperationServicePlugIn {
    private static final String BIZVALID = "bizvalid";
    private static final Log logger = LogFactory.getLog(XSSalOrderBillActiveOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keys = e.getFieldKeys();
        keys.add("changebillno");
        keys.add("org");
        keys.add("validstatus");
        keys.add("billstatus");
        keys.add("linkmanphone");
        keys.add("sourcebillid");
        keys.add("entrychangetype");
        keys.add("baseqty");
        keys.add("recentrychangetype");
        keys.add("r_recadvanceamount");
        keys.add("r_recamount");
        keys.add("deliverbaseqtyup");
        keys.add("amountandtax");
        keys.add("aramount");
        keys.add("totalallamount");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(SalOrderRecPlanHelper.getRecAmountValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        if (BIZVALID.equals(e.getOperationKey()) && !CommonUtils.isNull((Object)e.getDataEntities())) {
            DynamicObject[] bills = e.getDataEntities();
            DynamicObject bill = bills[0];
            bill = BusinessDataServiceHelper.loadSingle((Object)bill.getPkValue(), (String)bill.getDynamicObjectType().getName());
            String sourceBillEntity = bill.getString("sourcebillentity");
            Long sourceBillId = bill.getLong("sourcebillid");
            if (sourceBillId == null || sourceBillEntity == null) {
                return;
            }
            DynamicObject srcBill = BusinessDataServiceHelper.loadSingle((Object)sourceBillId, (String)sourceBillEntity);
            KitSalesHelper.resetSeq4KitSale((DynamicObject)srcBill);
            if (CommonUtils.isNull((Object)srcBill)) {
                return;
            }
            XSalOrderSynOrderStatusImpl impl = new XSalOrderSynOrderStatusImpl();
            PluginProxy pluginProxy = PluginProxy.create((Object)impl, IXSalOrderCasePlugin.class, (String)"SCMC_SM_XSSALORDERBILL_ACTIVE_SYNCSTATUS", null);
            List results = pluginProxy.callReplaceIfPresent(p -> p.activeSynOrderBillStatus(srcBill));
            if (results != null && results.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{srcBill});
                logger.info("\u9500\u552e\u8ba2\u5355\uff0c\u4e8c\u6b21\u5b9a\u7248\u6210\u529f.");
            }
        }
    }
}

