/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.opplugin.order;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LinkEntryProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.sm.business.custom.ext.bizextplugin.XSalOrderSynOrderStatusImpl;
import kd.scmc.sm.business.helper.KitSalesHelper;
import kd.scmc.sm.business.helper.SalOrderRecPlanHelper;
import kd.scmc.sm.enums.ChangeStatusEnum;
import kd.scmc.sm.enums.ChangeTypeEnum;
import kd.scmc.sm.util.CommonUtils;
import kd.scmc.sm.util.DynamicObjUtils;
import kd.scmc.sm.validator.order.XSalActiveValidator;
import kd.sdk.scmc.sm.extpoint.IXSalOrderCasePlugin;

public class XSalOrderBillActiveOp
extends AbstractOperationServicePlugIn {
    private static Log log = LogFactory.getLog(XSalOrderBillActiveOp.class);
    private static final String[] entryFields = new String[]{"qty", "baseqty", "kitqty", "parentqty", "bom", "price", "priceandtax", "taxrate", "amount", "amountandtax", "curamount", "curamountandtax", "curtaxamount", "discountamount", "taxamount", "remark", "iscontrolqty", "deliverratedown", "deliverrateup", "deliverqtyup", "deliverqtydown", "deliverbaseqtydown", "deliverbaseqtyup", "auxqty", "supplier"};
    private static final String[] fields = new String[]{"comment", "operatorgroup", "operator", "dept", "linkman", "receiveaddress", "reclinkman", "totalallamount", "totalamount", "totaltaxamount", "curtotalamount", "curtotalallamount", "address"};
    private static final String[] getEnableRecEntryField = new String[]{"r_itemname", "r_duedate", "r_recadvancerate", "r_recadvanceamount", "r_needrecadvance", "r_unremainamount", "r_relbillno"};
    private static final String[] getEnableDeliverEntryField = new String[]{"d_plandeliverydate", "d_planqty", "d_remark", "d_plandate"};

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keys = e.getFieldKeys();
        keys.add("billno");
        keys.add("org");
        keys.add("activestatus");
        keys.add("billstatus");
        keys.add("linkmanphone");
        keys.add("srcid");
        keys.add("entrychangetype");
        keys.add("baseqty");
        keys.add("recentrychangetype");
        keys.add("r_recadvanceamount");
        keys.add("r_recamount");
        keys.add("deliverbaseqtyup");
        keys.add("amountandtax");
        keys.add("aramount");
        keys.add("totalallamount");
        keys.add("srcbillentryid");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new XSalActiveValidator());
        e.addValidator(SalOrderRecPlanHelper.getRecAmountValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        block48: {
            try (TraceSpan span = Tracer.create((String)"XSalOrderBillActiveOp", (String)("beforeExecuteOperationTransaction" + e.getOperationKey()));){
                if (!"active".equals(e.getOperationKey()) || CommonUtils.isNull((Object)e.getDataEntities())) break block48;
                DynamicObject[] bills = e.getDataEntities();
                for (int i = 0; i < bills.length; ++i) {
                    QFilter qFilter2;
                    DynamicObject bill = bills[i];
                    bill = BusinessDataServiceHelper.loadSingle((Object)bill.getPkValue(), (String)bill.getDynamicObjectType().getName());
                    String srcBillNo = bill.getString("srcbillno");
                    Long orgId = (Long)bill.getDynamicObject("org").getPkValue();
                    QFilter qFilter1 = new QFilter("org", "=", (Object)orgId);
                    DynamicObject srcBillPre = BusinessDataServiceHelper.loadSingle((String)"sm_salorder", (String)"id", (QFilter[])new QFilter[]{qFilter1, qFilter2 = new QFilter("billno", "=", (Object)srcBillNo)});
                    if (srcBillPre == null) continue;
                    DynamicObject srcBill = BusinessDataServiceHelper.loadSingle((Object)srcBillPre.getPkValue(), (String)"sm_salorder");
                    for (String field : this.getSynField()) {
                        srcBill.set(field, bill.get(field));
                    }
                    String version = bill.getString("version");
                    if (version == null || "".equals(version) || version.equals("0") || version.equals("1.0")) {
                        version = "1";
                    }
                    srcBill.set("version", (Object)(Integer.parseInt(version) + 1));
                    srcBill.set("changestatus", (Object)ChangeStatusEnum.CHANGED.getValue());
                    srcBill.set("changer", (Object)BusinessDataServiceHelper.loadSingle((Object)UserServiceHelper.getCurrentUserId(), (String)"bos_user"));
                    srcBill.set("changedate", (Object)new Date(System.currentTimeMillis()));
                    DynamicObjectCollection billEntrys = srcBill.getDynamicObjectCollection("billentry");
                    DynamicObjectCollection xBillEntrys = bill.getDynamicObjectCollection("billentry");
                    if (!CommonUtils.isNull((Object)xBillEntrys)) {
                        DynamicObjectCollection xDeliverBillEntrys;
                        Long billEntryID;
                        DynamicObject billEntry;
                        int i3;
                        Long xSrcBillEntryID;
                        DynamicObject xBillEntry;
                        int i2;
                        block13: for (i2 = 0; i2 < xBillEntrys.size(); ++i2) {
                            xBillEntry = (DynamicObject)xBillEntrys.get(i2);
                            xSrcBillEntryID = xBillEntry.getLong("srcbillentryid");
                            if (!ChangeTypeEnum.UPDATE.getValue().equals(xBillEntry.get("entrychangetype"))) continue;
                            for (i3 = 0; i3 < billEntrys.size(); ++i3) {
                                Long xSrcDeliverBillEntryID;
                                DynamicObject xDeliverBillEntry;
                                int i4;
                                billEntry = (DynamicObject)billEntrys.get(i3);
                                billEntryID = (Long)billEntry.getPkValue();
                                if (xSrcBillEntryID.longValue() != billEntryID.longValue()) continue;
                                for (String field : this.getEntrySynField()) {
                                    billEntry.set(field, xBillEntry.get(field));
                                }
                                xDeliverBillEntrys = xBillEntry.getDynamicObjectCollection("orderdeliverentry");
                                DynamicObjectCollection deliverBillEntrys = billEntry.getDynamicObjectCollection("orderdeliverentry");
                                if (CommonUtils.isNull((Object)xDeliverBillEntrys)) continue block13;
                                block16: for (i4 = 0; i4 < xDeliverBillEntrys.size(); ++i4) {
                                    xDeliverBillEntry = (DynamicObject)xDeliverBillEntrys.get(i4);
                                    xSrcDeliverBillEntryID = xDeliverBillEntry.getLong("srcbilldeliverentryid");
                                    if (!ChangeTypeEnum.UPDATE.getValue().equals(xDeliverBillEntry.get("delentrychangetype"))) continue;
                                    String[] deliverFields = this.getEnableDeliverEntrySynField();
                                    for (int i5 = 0; i5 < deliverBillEntrys.size(); ++i5) {
                                        DynamicObject deliverBillEntry = (DynamicObject)deliverBillEntrys.get(i4);
                                        Long deliverBillEntryID = (Long)deliverBillEntry.getPkValue();
                                        if (xSrcDeliverBillEntryID.longValue() != deliverBillEntryID.longValue()) continue;
                                        for (String filed : deliverFields) {
                                            deliverBillEntry.set(filed, xDeliverBillEntry.get(filed));
                                        }
                                        continue block16;
                                    }
                                }
                                block19: for (i4 = 0; i4 < xDeliverBillEntrys.size(); ++i4) {
                                    xDeliverBillEntry = (DynamicObject)xDeliverBillEntrys.get(i4);
                                    xSrcDeliverBillEntryID = xDeliverBillEntry.getLong("srcbilldeliverentryid");
                                    if (!ChangeTypeEnum.CANCEL.getValue().equals(xDeliverBillEntry.get("delentrychangetype"))) continue;
                                    for (int i5 = 0; i5 < deliverBillEntrys.size(); ++i5) {
                                        DynamicObject deliverBillEntry = (DynamicObject)deliverBillEntrys.get(i5);
                                        Long deliverBillEntryID = (Long)deliverBillEntry.getPkValue();
                                        if (xSrcDeliverBillEntryID.longValue() != deliverBillEntryID.longValue()) continue;
                                        deliverBillEntrys.remove((Object)deliverBillEntry);
                                        continue block19;
                                    }
                                }
                                for (i4 = 0; i4 < xDeliverBillEntrys.size(); ++i4) {
                                    xDeliverBillEntry = (DynamicObject)xDeliverBillEntrys.get(i4);
                                    if (!ChangeTypeEnum.ADDNEW.getValue().equals(xDeliverBillEntry.get("delentrychangetype"))) continue;
                                    DynamicObject deliverBillEntry = deliverBillEntrys.addNew();
                                    for (int ii = 0; ii < deliverBillEntry.getDataEntityType().getProperties().size(); ++ii) {
                                        IDataEntityProperty entityProperty = (IDataEntityProperty)deliverBillEntry.getDataEntityType().getProperties().get(ii);
                                        if (xDeliverBillEntry.get(entityProperty.getName()) instanceof EntryProp || xDeliverBillEntry.get(entityProperty.getName()) instanceof LinkEntryProp) continue;
                                        deliverBillEntry.set(entityProperty.getName(), xDeliverBillEntry.get(entityProperty.getName()));
                                    }
                                    deliverBillEntry.set("delentrychangetype", (Object)ChangeTypeEnum.UPDATE.getValue());
                                }
                                continue block13;
                            }
                        }
                        block23: for (i2 = xBillEntrys.size() - 1; i2 >= 0; --i2) {
                            xBillEntry = (DynamicObject)xBillEntrys.get(i2);
                            xSrcBillEntryID = xBillEntry.getLong("srcbillentryid");
                            if (!ChangeTypeEnum.CANCEL.getValue().equals(xBillEntry.get("entrychangetype"))) continue;
                            for (i3 = billEntrys.size() - 1; i3 >= 0; --i3) {
                                billEntry = (DynamicObject)billEntrys.get(i3);
                                billEntryID = (Long)billEntry.getPkValue();
                                if (xSrcBillEntryID.longValue() != billEntryID.longValue()) continue;
                                DynamicObjectCollection deliverBillEntrys = billEntry.getDynamicObjectCollection("orderdeliverentry");
                                if (!CommonUtils.isNull((Object)deliverBillEntrys)) {
                                    for (int i4 = 0; i4 < deliverBillEntrys.size(); ++i4) {
                                        deliverBillEntrys.remove(i4);
                                    }
                                }
                                billEntrys.remove((Object)billEntry);
                                continue block23;
                            }
                        }
                        for (i2 = 0; i2 < xBillEntrys.size(); ++i2) {
                            xBillEntry = (DynamicObject)xBillEntrys.get(i2);
                            if (!ChangeTypeEnum.ADDNEW.getValue().equals(xBillEntry.get("entrychangetype"))) continue;
                            DynamicObject billEntry2 = billEntrys.addNew();
                            for (int ii = 0; ii < billEntry2.getDataEntityType().getProperties().size(); ++ii) {
                                IDataEntityProperty entityProperty = (IDataEntityProperty)billEntry2.getDataEntityType().getProperties().get(ii);
                                if ("orderdeliverentry".equals(entityProperty.getName())) {
                                    DynamicObjectCollection deliverBillEntrys = billEntry2.getDynamicObjectCollection("orderdeliverentry");
                                    xDeliverBillEntrys = xBillEntry.getDynamicObjectCollection("orderdeliverentry");
                                    if (CommonUtils.isNull((Object)xDeliverBillEntrys)) continue;
                                    for (int i4 = 0; i4 < xDeliverBillEntrys.size(); ++i4) {
                                        DynamicObject xDeliverBillEntry = (DynamicObject)xDeliverBillEntrys.get(i4);
                                        DynamicObject deliverBillEntry = deliverBillEntrys.addNew();
                                        for (int i5 = 0; i5 < deliverBillEntry.getDataEntityType().getProperties().size(); ++i5) {
                                            IDataEntityProperty deliverEntityProperty = (IDataEntityProperty)deliverBillEntry.getDataEntityType().getProperties().get(i5);
                                            if (xDeliverBillEntry.get(deliverEntityProperty.getName()) instanceof EntryProp || xDeliverBillEntry.get(deliverEntityProperty.getName()) instanceof LinkEntryProp) continue;
                                            deliverBillEntry.set(deliverEntityProperty.getName(), xDeliverBillEntry.get(deliverEntityProperty.getName()));
                                        }
                                    }
                                    continue;
                                }
                                if (xBillEntry.get(entityProperty.getName()) instanceof EntryProp || xBillEntry.get(entityProperty.getName()) instanceof LinkEntryProp) continue;
                                billEntry2.set(entityProperty.getName(), xBillEntry.get(entityProperty.getName()));
                            }
                            billEntry2.set("entrychangetype", (Object)ChangeTypeEnum.UPDATE.getValue());
                        }
                    }
                    DynamicObjectCollection recBillEntrys = srcBill.getDynamicObjectCollection("recplanentry");
                    DynamicObjectCollection xRecBillEntrys = bill.getDynamicObjectCollection("recplanentry");
                    if (!CommonUtils.isNull((Object)xRecBillEntrys)) {
                        Long xSrcBillEntryID;
                        int i2;
                        block30: for (i2 = 0; i2 < xRecBillEntrys.size(); ++i2) {
                            DynamicObject xRecBillEntry = (DynamicObject)xRecBillEntrys.get(i2);
                            xSrcBillEntryID = xRecBillEntry.getLong("srcbillrecentryid");
                            if (!ChangeTypeEnum.UPDATE.getValue().equals(xRecBillEntry.get("recentrychangetype"))) continue;
                            DynamicObject recplanFields = this.getEnableRecEntrySynField();
                            for (int i3 = 0; i3 < recBillEntrys.size(); ++i3) {
                                DynamicObject recBillEntry = (DynamicObject)recBillEntrys.get(i3);
                                Long billEntryID = (Long)recBillEntry.getPkValue();
                                if (xSrcBillEntryID.longValue() != billEntryID.longValue()) continue;
                                for (String filed : recplanFields) {
                                    recBillEntry.set(filed, xRecBillEntry.get(filed));
                                }
                                continue block30;
                            }
                        }
                        block33: for (i2 = xRecBillEntrys.size() - 1; i2 >= 0; --i2) {
                            DynamicObject xRecBillEntry = (DynamicObject)xRecBillEntrys.get(i2);
                            xSrcBillEntryID = xRecBillEntry.getLong("srcbillrecentryid");
                            if (!ChangeTypeEnum.CANCEL.getValue().equals(xRecBillEntry.get("recentrychangetype"))) continue;
                            for (int i3 = recBillEntrys.size() - 1; i3 >= 0; --i3) {
                                DynamicObject recBillEntry = (DynamicObject)recBillEntrys.get(i3);
                                Long billEntryID = (Long)recBillEntry.getPkValue();
                                if (xSrcBillEntryID.longValue() != billEntryID.longValue()) continue;
                                recBillEntrys.remove((Object)recBillEntry);
                                continue block33;
                            }
                        }
                        for (i2 = 0; i2 < xRecBillEntrys.size(); ++i2) {
                            DynamicObject xPayBillEntry = (DynamicObject)xRecBillEntrys.get(i2);
                            if (!ChangeTypeEnum.ADDNEW.getValue().equals(xPayBillEntry.get("recentrychangetype"))) continue;
                            DynamicObject payBillEntry = recBillEntrys.addNew();
                            for (int ii = 0; ii < payBillEntry.getDataEntityType().getProperties().size(); ++ii) {
                                IDataEntityProperty entityProperty = (IDataEntityProperty)payBillEntry.getDataEntityType().getProperties().get(ii);
                                if (xPayBillEntry.get(entityProperty.getName()) instanceof EntryProp || xPayBillEntry.get(entityProperty.getName()) instanceof LinkEntryProp) continue;
                                payBillEntry.set(entityProperty.getName(), xPayBillEntry.get(entityProperty.getName()));
                            }
                            payBillEntry.set("recentrychangetype", (Object)ChangeTypeEnum.UPDATE.getValue());
                        }
                    }
                    HashMap<String, String> entryMap = new HashMap<String, String>();
                    entryMap.put("billentry", "orderdeliverentry");
                    entryMap.put("recplanentry", "");
                    DynamicObjUtils.resetSeq((DynamicObject)srcBill, entryMap);
                    KitSalesHelper.resetSeq4KitSale((DynamicObject)srcBill);
                    XSalOrderSynOrderStatusImpl impl = new XSalOrderSynOrderStatusImpl();
                    PluginProxy pluginProxy = PluginProxy.create((Object)impl, IXSalOrderCasePlugin.class, (String)"SCMC_SM_XSSALORDERBILL_ACTIVE_SYNCSTATUS", null);
                    pluginProxy.callReplaceIfPresent(p -> p.activeSynOrderBillStatus(srcBill));
                    OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"sm_salorder", (DynamicObject[])new DynamicObject[]{srcBill}, null);
                    if (result.isSuccess()) continue;
                    if (result.getValidateResult() != null && result.getValidateResult().getValidateErrors() != null && result.getValidateResult().getValidateErrors().size() > 0) {
                        char space = ' ';
                        ValidateResult validateResult = (ValidateResult)result.getValidateResult().getValidateErrors().get(0);
                        if (validateResult.getAllErrorInfo() == null || validateResult.getAllErrorInfo().size() <= 0) continue;
                        OperateErrorInfo operateErrorInfo = (OperateErrorInfo)validateResult.getAllErrorInfo().get(0);
                        if (operateErrorInfo != null) {
                            if (StringUtils.isNotEmpty((CharSequence)operateErrorInfo.getEntityKey())) {
                                String entityName = null;
                                try {
                                    entityName = EntityMetadataCache.getDataEntityType((String)operateErrorInfo.getEntityKey()).getDisplayName().getLocaleValue();
                                }
                                catch (Exception ex) {
                                    log.error(ex.getMessage());
                                    entityName = ResManager.loadKDString((String)"\u9500\u552e\u8ba2\u5355", (String)"XSalOrderBillActiveOp_2", (String)"scmc-sm-opplugin", (Object[])new Object[0]);
                                }
                                String title = operateErrorInfo.getTitle() == null ? "" : operateErrorInfo.getTitle();
                                StringBuilder msg = new StringBuilder();
                                msg.append(entityName == null ? "" : entityName);
                                msg.append(title).append(space);
                                msg.append(operateErrorInfo.getMessage());
                                e.setCancelMessage(msg.toString());
                                e.setCancel(true);
                                continue;
                            }
                            e.setCancelMessage(operateErrorInfo.getMessage());
                            e.setCancel(true);
                            continue;
                        }
                        e.setCancelMessage(result.getMessage());
                        e.setCancel(true);
                        continue;
                    }
                    e.setCancelMessage(result.getMessage());
                    e.setCancel(true);
                }
            }
        }
    }

    protected String[] getEntrySynField() {
        return entryFields;
    }

    protected String[] getSynField() {
        return fields;
    }

    protected String[] getEnableRecEntrySynField() {
        return getEnableRecEntryField;
    }

    protected String[] getEnableDeliverEntrySynField() {
        return getEnableDeliverEntryField;
    }
}

