/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.opplugin.order;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.sm.enums.ChangeStatusEnum;
import kd.scmc.sm.util.CommonUtils;

public class XSalOrderBillDeleteOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keys = e.getFieldKeys();
        keys.add("srcid");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        if ("delete".equals(e.getOperationKey()) && !CommonUtils.isNull((Object)e.getDataEntities())) {
            DynamicObject[] bills = e.getDataEntities();
            ArrayList<DynamicObject> srcBills = new ArrayList<DynamicObject>();
            for (int i = 0; i < bills.length; ++i) {
                DynamicObject bill = bills[i];
                String srcBillID = bill.getString("srcid");
                DynamicObject srcBill = BusinessDataServiceHelper.loadSingle((Object)srcBillID, (String)"sm_salorder");
                if (srcBill != null) {
                    if (null == srcBill.get("changedate") && null == srcBill.get("changer")) {
                        srcBill.set("changestatus", (Object)ChangeStatusEnum.UNCHANGE.getValue());
                    } else {
                        srcBill.set("changestatus", (Object)ChangeStatusEnum.CHANGED.getValue());
                    }
                }
                srcBills.add(srcBill);
            }
            if (srcBills.size() != 0) {
                SaveServiceHelper.save((DynamicObject[])srcBills.toArray(new DynamicObject[0]));
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        if ("delete".equals(e.getOperationKey()) && !CommonUtils.isNull((Object)e.getDataEntities())) {
            DynamicObject[] bills = e.getDataEntities();
            for (int i = 0; i < bills.length; ++i) {
                DynamicObject bill = bills[i];
                DynamicObject srcBill = BusinessDataServiceHelper.loadSingleFromCache((Object)bill.get("srcid"), (String)"sm_salorder");
                QFilter qFilter1 = new QFilter("srcbillid", "=", srcBill.getPkValue());
                QFilter qFilter2 = new QFilter("xbillid", "=", bill.getPkValue());
                QFilter qFilter3 = new QFilter("srcbillversion", "=", (Object)srcBill.getString("version"));
                DeleteServiceHelper.delete((String)"sm_xsalorderlog", (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3});
            }
        }
    }
}

